<?php

/**
* Testimonials - view file
* @package Joomla!
* @Copyright (C) 2009-2012 Gavick.com
* @ All rights reserved
* @ Joomla! is Free Software
* @ Released under GNU/GPL License : http://www.gnu.org/copyleft/gpl.html
* @ version $Revision: GK4 1.0 $
**/

// no direct access
defined('_JEXEC') or die;

jimport('joomla.utilities.string');

$content_style = ($this->config['config']->bdt_testimonials->bdt_testimonials_content_style) ? $this->config['config']->bdt_testimonials->bdt_testimonials_content_style : '' ; 

$imageSize = new BDT_testimonials_Image();

// Testimonials Dynamic style confirmation
$testimonials_color = ($this->config['config']->bdt_testimonials->bdt_testimonials_testimonials_color) ? "color:".$this->config['config']->bdt_testimonials->bdt_testimonials_testimonials_color.";" : "";

$testimonials_background = ($this->config['config']->bdt_testimonials->bdt_testimonials_testimonials_background)? "background-color:".$this->config['config']->bdt_testimonials->bdt_testimonials_testimonials_background.";" :"";

$testimonials_border = ($this->config['config']->bdt_testimonials->bdt_testimonials_testimonials_border)? "border:".$this->config['config']->bdt_testimonials->bdt_testimonials_testimonials_border.";" :"";

$testimonials_border_radius = ($this->config['config']->bdt_testimonials->bdt_testimonials_testimonials_border_radius)? "border-radius:".$this->config['config']->bdt_testimonials->bdt_testimonials_testimonials_border_radius.";" :"";

$testimonials_font_size = ($this->config['config']->bdt_testimonials->bdt_testimonials_testimonials_font_size)? "font-size:".$this->config['config']->bdt_testimonials->bdt_testimonials_testimonials_font_size.";" :"";

$testimonials_margin = ($this->config['config']->bdt_testimonials->bdt_testimonials_testimonials_margin)? "margin:".$this->config['config']->bdt_testimonials->bdt_testimonials_testimonials_margin.";" :"";

$testimonials_padding = ($this->config['config']->bdt_testimonials->bdt_testimonials_testimonials_padding)? "padding:".$this->config['config']->bdt_testimonials->bdt_testimonials_testimonials_padding.";" :"";



$testimonials_italic = ($this->config['config']->bdt_testimonials->bdt_testimonials_testimonials_italic)? "font-style: italic;" :"";

$client_image_style = ($this->config['config']->bdt_testimonials->bdt_testimonials_client_image_style)? "class='".$this->config['config']->bdt_testimonials->bdt_testimonials_client_image_style."'" :"";


$testimonials_alignment = ($this->config['config']->bdt_testimonials->bdt_testimonials_testimonials_alignment)? $this->config['config']->bdt_testimonials->bdt_testimonials_testimonials_alignment :"";

$testimonials_style = ($this->config['config']->bdt_testimonials->bdt_testimonials_testimonials_style)? $this->config['config']->bdt_testimonials->bdt_testimonials_testimonials_style :"";



?>

<div id="testimonials-<?php echo $this->config['module_id'];?>" class="testimonials">
	<?php for($i = 0; $i < count($this->config['image_show_data']); $i++) : ?>
	<?php if($this->config['image_show_data'][$i]->published) : ?>
		<?php 
			unset($path, $title, $link, $content);
			// creating slide path
			$path = '';
			// check if the slide have to be generated or not
			if($this->config['generate_thumbnails'] == 1) {
				$path = $uri->root().'modules/mod_bdthemes_testimonials/cache/'.$imageSize->translateName($this->config['image_show_data'][$i]->image, $this->config['module_id']);
			} else {
				$path = $uri->root();
				$path .= $this->config['image_show_data'][$i]->image;
			}
            // creating slide title
			$title = htmlspecialchars(($this->config['image_show_data'][$i]->type == "text") ? $this->config['image_show_data'][$i]->name : 'Only the text slides can be used');
			$title = preg_replace('/__(.*?)__/i', '<strong>${1}</strong>', $title);
			// creating slide content
			$content = ($this->config['image_show_data'][$i]->type == "text") ? $this->config['image_show_data'][$i]->content : 'Only the text slides can be used';
			$content = str_replace(array('[ampersand]', '[leftbracket]', '[rightbracket]'), array('&', '<', '>'), $content);
			$content_sub = false;
			$subcontent_match_text = array();
			if(preg_match('/__(.*?)__/mis', $content, $subcontent_match_text) == 1) {
				$content_sub = $subcontent_match_text[1];
				$content = preg_replace('/__(.*?)__/mis', '', $content);
			}
			//
			// creating slide link
			//
			$link = ($this->config['image_show_data'][$i]->type == "text") ? $this->config['image_show_data'][$i]->url : '#';
			$link_text = '';
			// parsing custom texts
			$link_match_text = array();
			
			if(preg_match('@^\[(.*?)\]@mis', $link, $link_match_text) == 1) {
				$link = preg_replace('@^\[.*?\]@mis', '', $link);
				$link_text = $link_match_text[1];
				
				if(stripos($link_text, ',') !== FALSE) {
					$icon_match = array();
					preg_match('@icon-(.*?),@mis', $link_text, $icon_match);
					$link_text = preg_replace('@icon-(.*?),@mis', '<i class="icon-${1}"></i> ', $link_text);
				}
			} else {
				$link_text = JText::_('MOD_BDTHEMES_TESTIMONIALS_ROCKWALL_READMORE');
			}
		?>
		<div class="testimonials-wrapper <?php echo $testimonials_alignment." ".$testimonials_style; ?> " data-title="<?php echo strip_tags($title); ?>">
			<?php if($title or $content or $link) : ?>
				<blockquote class="testimonial" <?php echo "style='".$testimonials_background.$testimonials_color.$testimonials_border.$testimonials_border_radius.$testimonials_font_size.$testimonials_margin.$testimonials_padding.$testimonials_italic."'";?>>

						<?php if($content) : ?>
							<p ><?php echo $content; ?></p>
						<?php endif; ?>

						<div class="client-info">
							<img <?php echo $client_image_style;?> src="<?php echo $path; ?>" data-src="<?php echo $path; ?>" alt=""/>
						
							<cite>
								<span class="bx-name" <?php echo "style='".$testimonials_color."'";?>>
								—	<?php echo $link ? "<a href='".$link."'>". $title."</a>" : $title; ?>
								</span>
							</cite>
						</div>

				</blockquote>
			<?php endif; ?>
		</div>
	<?php endif; ?>
	<?php endfor; ?>
</div>

<script type="text/javascript">
    	jQuery(document).ready(function() {
		jQuery('#testimonials-<?php echo $this->config['module_id'];?>').owlCarousel({

			// // Most important owl features
			items: [<?php echo $this->config['config']->bdt_testimonials->bdt_testimonials_testimonials_number; ?>],
		    itemsDesktop : [<?php echo $this->config['config']->bdt_testimonials->bdt_testimonials_itemsDesktop; ?>],
		    itemsDesktopSmall : [<?php echo $this->config['config']->bdt_testimonials->bdt_testimonials_itemsDesktopSmall; ?>],
		    itemsTablet: [<?php echo $this->config['config']->bdt_testimonials->bdt_testimonials_itemsTablet; ?>],
		    itemsMobile : [<?php echo $this->config['config']->bdt_testimonials->bdt_testimonials_itemsMobile; ?>],


		    //Basic Speeds
			slideSpeed : <?php echo $this->config['config']->bdt_testimonials->bdt_testimonials_slide_speed; ?>,
			paginationSpeed : <?php echo $this->config['config']->bdt_testimonials->bdt_testimonials_paginationSpeed; ?>,

			// Auto Play
			autoPlay : <?php echo $this->config['config']->bdt_testimonials->bdt_testimonials_autoPlay; ?>,
   			stopOnHover : <?php echo $this->config['config']->bdt_testimonials->bdt_testimonials_stopOnHover; ?>,

    		// Navigation
			navigation: <?php echo $this->config['config']->bdt_testimonials->bdt_testimonials_navigation; ?>,
		    navigationText : [<?php echo $this->config['config']->bdt_testimonials->bdt_testimonials_navigation_text; ?>],
		 
		    //Pagination
		    pagination : <?php echo $this->config['config']->bdt_testimonials->bdt_testimonials_pagination; ?>,
		    paginationNumbers: <?php echo $this->config['config']->bdt_testimonials->bdt_testimonials_pagination_number; ?>,

		    //Auto height
			autoHeight: <?php echo $this->config['config']->bdt_testimonials->bdt_testimonials_autoHeight; ?>
				 
		});
	});

</script>