<?php
/*
 * get intro image from an article, if indtro image is not exist, return first image from article
 * @params Object article object
 * @return indtro image url
 */
function get_post_thumbnail_id($post){
	$images = $post->images;
	if($images){
		$images = json_decode($images);
		if($images->image_intro){
			return $images->image_intro;
		};
	}
	return getFirstImageFromHTML($post->introtext);
}
/*
 * get fulltex image from an article, if not exist, return intro image, if both do not exist, return first image from article
 * @params Object article object
 * @return indtro image url
 */
function get_post_image($post) {
	$images = $post->images;
	if($images) {
		$images = json_decode($images);
		if($images->image_fulltext){
			return $images->image_fulltext;
		}
		elseif($images->image_intro) {
		  return $images->image_intro;
		};
	}
	return getFirstImageFromHTML($post->introtext);
}
/*
 * get first image from html string and return
 * @params String $html - html string that want to get image
 * @return String $img - first image found
 */
function getFirstImageFromHTML($html){
    $image = NULL;
    $pos = strpos($html, "<img");
    if($pos){
	    $img = substr($html, $pos, 300);
	    $img = explode("src=", $img);
		$img = str_replace("'",'"',$img[1]);
		$img = explode('"',$img);
		$image = $img[1];
	}
        return $image;
}

function wp_parse_args( $args, $defaults = '' ) {
	if ( is_object( $args ) )
	    $r = get_object_vars( $args );
	elseif ( is_array( $args ) )
	    $r =& $args;

	if ( is_array( $defaults ) )
	    return array_merge( $defaults, $r );
	return $r;
}

function __($bien) {
	return JText::_($bien);
}

function esc_attr($attr){
	return $attr;
}

function apply_filters($arg1, $arg2) {
	return $arg2;
}

function get_option($arg) {
  return $arg;
}

function sanitize_text_field($attr) {
  $filtered = wp_check_invalid_utf8( $attr );
  if ( strpos($filtered, '<') !== false ) {
		$filtered = wp_pre_kses_less_than( $filtered );
		// This will strip extra whitespace for us.
		$filtered = wp_strip_all_tags( $filtered, true );
	} else {
		$filtered = trim( preg_replace('/[\r\n\t ]+/', ' ', $filtered) );
	}

	$found = false;
	while ( preg_match('/%[a-f0-9]{2}/i', $filtered, $match) ) {
		$filtered = str_replace($match[0], '', $filtered);
		$found = true;
	}

	if ( $found ) {
		// Strip out the whitespace that may now exist after removing the octets.
		$filtered = trim( preg_replace('/ +/', ' ', $filtered) );
	}

	return apply_filters( 'sanitize_text_field', $filtered, $str );
}
function wp_pre_kses_less_than_callback( $matches ) {
	if ( false === strpos($matches[0], '>') )
		return esc_html($matches[0]);
	return $matches[0];
}
function wp_pre_kses_less_than( $text ) {
	return preg_replace_callback('%<[^>]*?((?=<)|>|$)%', 'wp_pre_kses_less_than_callback', $text);
}
function wp_strip_all_tags($string, $remove_breaks = false) {
	$string = preg_replace( '@<(script|style)[^>]*?>.*?</\\1>@si', '', $string );
	$string = strip_tags($string);

	if ( $remove_breaks )
		$string = preg_replace('/[\r\n\t ]+/', ' ', $string);

	return trim( $string );
}

function wp_check_invalid_utf8( $string, $strip = false ) {
	$string = (string) $string;

	if ( 0 === strlen( $string ) ) {
		return '';
	}

	// Store the site charset as a static to avoid multiple calls to get_option()
	static $is_utf8;
	if ( !isset( $is_utf8 ) ) {
		$is_utf8 = in_array( get_option( 'blog_charset' ), array( 'utf8', 'utf-8', 'UTF8', 'UTF-8' ) );
	}
	if ( !$is_utf8 ) {
		return $string;
	}

	// Check for support for utf8 in the installed PCRE library once and store the result in a static
	static $utf8_pcre;
	if ( !isset( $utf8_pcre ) ) {
		$utf8_pcre = @preg_match( '/^./u', 'a' );
	}
	// We can't demand utf8 in the PCRE installation, so just return the string in those cases
	if ( !$utf8_pcre ) {
		return $string;
	}

	// preg_match fails when it encounters invalid UTF8 in $string
	if ( 1 === @preg_match( '/^./us', $string ) ) {
		return $string;
	}

	// Attempt to strip the bad chars if requested (not recommended)
	if ( $strip && function_exists( 'iconv' ) ) {
		return iconv( 'utf-8', 'utf-8', $string );
	}

	return '';
}