<?php
/**
 * @version		$Id: item.php 1812 2013-01-14 18:45:06Z lefteris.kavadas $
 * @package		K2
 * @author		JoomlaWorks http://www.joomlaworks.net
 * @copyright	Copyright (c) 2006 - 2013 JoomlaWorks Ltd. All rights reserved.
 * @license		GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 */

// no direct access
defined('_JEXEC') or die;

?>

<?php if(JRequest::getInt('print')==1): ?>
<!-- Print button at the top of the print page only -->
<a class="itemPrintThisPage" rel="nofollow" href="#" onclick="window.print();return false;">
	<span><?php echo JText::_('K2_PRINT_THIS_PAGE'); ?></span>
</a>
<?php endif; ?>

<!-- Start K2 Item Layout -->
<span id="startOfPageId<?php echo JRequest::getInt('id'); ?>"></span>

<div id="k2Container" class="project-Single-item<?php echo ($this->item->featured) ? ' itemIsFeatured' : ''; ?><?php if($this->item->params->get('pageclass_sfx')) echo ' '.$this->item->params->get('pageclass_sfx'); ?>">

	<!-- K2 Plugins: K2AfterDisplayTitle -->
  	<?php echo $this->item->event->K2AfterDisplayTitle; ?>
  	<div class="project-item-header">

  		<div class="itemHeader">

		  <?php if($this->item->params->get('itemTitle')): ?>
		  <!-- Item title -->
		  	<h2 class="itemTitle">
				<?php if(isset($this->item->editLink)): ?>
				<!-- Item edit link -->
				<span class="itemEditLink">
					<a class="modal" rel="{handler:'iframe',size:{x:990,y:550}}" href="<?php echo $this->item->editLink; ?>">
						<?php echo JText::_('K2_EDIT_ITEM'); ?>
					</a>
				</span>
				<?php endif; ?>

			  	<?php echo $this->item->title; ?>

			  	<?php if($this->item->params->get('itemFeaturedNotice') && $this->item->featured): ?>
				  	<!-- Featured flag -->
				  	<span class="uk-hidden-small">
					  	<?php echo JText::_('K2_FEATURED'); ?>
				  	</span>
			  	<?php endif; ?>
			</h2>
		  <?php endif; ?>
		</div>

  		<?php if($this->item->params->get('itemNavigation') && !JRequest::getCmd('print') && (isset($this->item->nextLink) || isset($this->item->previousLink))): ?>
	  	<!-- Item navigation -->
	  	<div class="itemNavigation">
			<?php if(isset($this->item->previousLink)): ?>
			<a class="itemPrevious" href="<?php echo $this->item->previousLink; ?>">
				<i class="uk-icon-angle-double-left"></i>
			</a>
			<?php endif; ?>

			<?php if(isset($this->item->nextLink)): ?>
			<a class="itemNext" href="<?php echo $this->item->nextLink; ?>">
				<i class="uk-icon-angle-double-right"></i>
			</a>
			<?php endif; ?>
		</div>
		<?php endif; ?>
  	</div>

  	<!-- item toolbar -->
	<?php if(
		$this->item->params->get('itemFontResizer') ||
		$this->item->params->get('itemPrintButton') ||
		$this->item->params->get('itemEmailButton') ||
		$this->item->params->get('itemSocialButton') ||
		$this->item->params->get('itemVideoAnchor') ||
		$this->item->params->get('itemImageGalleryAnchor') ||
		$this->item->params->get('itemCommentsAnchor')
	): ?>
    <div class="itemToolbar">


    	<!-- K2 Plugins: K2BeforeDisplay -->
		<?php echo $this->item->event->K2BeforeDisplay; ?>

		<?php if($this->item->params->get('itemDateCreated')): ?>
		<!-- Date created -->
		<?php 
			$createDay = date('d', strtotime( $this->item->created ));
			$createMonth = JText::_(strtoupper(date('F', strtotime( $this->item->created )))."_SHORT");
			$createYear = date('Y', strtotime( $this->item->created ));
		?>
		<span class="projeceItemDateCreated">
			<span class="month"><i class="uk-icon-clock-o"></i> <?php echo $createMonth; ?></span>
			<span class="project-date"><?php echo $createDay; ?></span>
			<span class="year"><?php echo $createYear; ?></span>
		</span>
		<?php endif; ?>

    	<?php if($this->item->params->get('itemAuthor')): ?>
		<!-- Item Author -->
		<span class="itemAuthor">
			<i class="uk-icon-user"></i>
			<?php echo JText::_('K2_BY'); ?>&nbsp;
			<?php if(empty($this->item->created_by_alias)): ?>
			<a rel="author" href="<?php echo $this->item->author->link; ?>"><?php echo $this->item->author->name; ?></a>
			<?php else: ?>
			<?php echo $this->item->author->name; ?>
			<?php endif; ?>
		</span>
		<?php endif; ?>

	    <?php if($this->item->params->get('itemCategory') || $this->item->params->get('itemTags') || $this->item->params->get('itemAttachments')): ?>
	    <div class="itemLinks">

			<?php if($this->item->params->get('itemCategory')): ?>
			<!-- Item category -->
			<div class="itemCategory uk-hidden-small">
				<i class="uk-icon-folder-open-o"></i>
				<span><?php echo JText::_('K2_IN'); ?></span>
				<a href="<?php echo $this->item->category->link; ?>"><?php echo $this->item->category->name; ?></a>
			</div>
			<?php endif; ?>

		  <?php if($this->item->params->get('itemTags') && count($this->item->tags)): ?>
		  <!-- Item tags -->
		  <div class="itemTagsBlock uk-hidden-small">
			  <span class="uk-icon-tag"></span>
			  <ul class="itemTags">
			    <?php foreach ($this->item->tags as $tag): ?>
			    <li><a href="<?php echo $tag->link; ?>"><?php echo $tag->name; ?></a></li>
			    <?php endforeach; ?>
			  </ul>
			  <div class="clr"></div>
		  </div>
		  <?php endif; ?>

		  <?php if($this->item->params->get('itemAttachments') && count($this->item->attachments)): ?>
		  <!-- Item attachments -->
		  <div class="itemAttachmentsBlock">
			  <span><?php echo JText::_('K2_DOWNLOAD_ATTACHMENTS'); ?></span>
			  <ul class="itemAttachments">
			    <?php foreach ($this->item->attachments as $attachment): ?>
			    <li>
				    <a title="<?php echo K2HelperUtilities::cleanHtml($attachment->titleAttribute); ?>" href="<?php echo $attachment->link; ?>"><?php echo $attachment->title; ?></a>
				    <?php if($this->item->params->get('itemAttachmentsCounter')): ?>
				    <span>(<?php echo $attachment->hits; ?> <?php echo ($attachment->hits==1) ? JText::_('K2_DOWNLOAD') : JText::_('K2_DOWNLOADS'); ?>)</span>
				    <?php endif; ?>
			    </li>
			    <?php endforeach; ?>
			  </ul>
		  </div>
		  <?php endif; ?>

		 <div class="clr"></div>
	    </div>
	  <?php endif; ?>


  		<?php if($this->item->params->get('itemRating')): ?>
		<!-- Item Rating -->
		<div class="itemRatingBlock">
			
			<div class="itemRatingForm">
				<ul class="itemRatingList">
					<li class="itemCurrentRating" id="itemCurrentRating<?php echo $this->item->id; ?>" style="width:<?php echo $this->item->votingPercentage; ?>%;"></li>
					<li><a href="#" rel="<?php echo $this->item->id; ?>" title="<?php echo JText::_('K2_1_STAR_OUT_OF_5'); ?>" class="one-star">1</a></li>
					<li><a href="#" rel="<?php echo $this->item->id; ?>" title="<?php echo JText::_('K2_2_STARS_OUT_OF_5'); ?>" class="two-stars">2</a></li>
					<li><a href="#" rel="<?php echo $this->item->id; ?>" title="<?php echo JText::_('K2_3_STARS_OUT_OF_5'); ?>" class="three-stars">3</a></li>
					<li><a href="#" rel="<?php echo $this->item->id; ?>" title="<?php echo JText::_('K2_4_STARS_OUT_OF_5'); ?>" class="four-stars">4</a></li>
					<li><a href="#" rel="<?php echo $this->item->id; ?>" title="<?php echo JText::_('K2_5_STARS_OUT_OF_5'); ?>" class="five-stars">5</a></li>
				</ul>
				<div id="itemRatingLog<?php echo $this->item->id; ?>" class="itemRatingLog"><?php echo $this->item->numOfvotes; ?></div>
			</div>
		</div>
		<?php endif; ?>
		<ul>
			<?php if($this->item->params->get('itemFontResizer')): ?>
			<!-- Font Resizer -->
			<li class="first uk-hidden-small">
				<span class="itemTextResizerTitle"><?php echo JText::_('K2_FONT_SIZE'); ?></span>
				<a href="#" id="fontDecrease">
					<span class="uk-icon-minus"></span>
				</a>
				<a href="#" id="fontIncrease">
					<span class="uk-icon-plus"></span>
				</a>
			</li class="first uk-hidden-small">
			<?php endif; ?>

			<?php if($this->item->params->get('itemPrintButton') && !JRequest::getInt('print')): ?>
			<!-- Print Button -->
			<li class="first uk-hidden-small">
				<a class="itemPrintLink" rel="nofollow" href="<?php echo $this->item->printLink; ?>" onclick="window.open(this.href,'printWindow','width=900,height=600,location=no,menubar=no,resizable=yes,scrollbars=yes'); return false;">
					<span><?php echo JText::_('K2_PRINT'); ?></span>
				</a>
			</li>
			<?php endif; ?>

			<?php if($this->item->params->get('itemEmailButton') && !JRequest::getInt('print')): ?>
			<!-- Email Button -->
			<li class="uk-hidden-small">
				<a class="itemEmailLink" rel="nofollow" href="<?php echo $this->item->emailLink; ?>" onclick="window.open(this.href,'emailWindow','width=400,height=350,location=no,menubar=no,resizable=no,scrollbars=no'); return false;">
					<span><?php echo JText::_('K2_EMAIL'); ?></span>
				</a>
			</li>
			<?php endif; ?>

			<?php if($this->item->params->get('itemSocialButton') && !is_null($this->item->params->get('socialButtonCode', NULL))): ?>
			<!-- Item Social Button -->
			<li>
				<?php echo $this->item->params->get('socialButtonCode'); ?>
			</li>
			<?php endif; ?>

			<?php if($this->item->params->get('itemVideoAnchor') && !empty($this->item->video)): ?>
			<!-- Anchor link to item video below - if it exists -->
			<li>
				<a class="itemVideoLink k2Anchor" href="<?php echo $this->item->link; ?>#itemVideoAnchor"><?php echo JText::_('K2_MEDIA'); ?></a>
			</li>
			<?php endif; ?>

			<?php if($this->item->params->get('itemImageGalleryAnchor') && !empty($this->item->gallery)): ?>
			<!-- Anchor link to item image gallery below - if it exists -->
			<li>
				<a class="itemImageGalleryLink k2Anchor" href="<?php echo $this->item->link; ?>#itemImageGalleryAnchor"><?php echo JText::_('K2_IMAGE_GALLERY'); ?></a>
			</li>
			<?php endif; ?>

		</ul>
	</div>
	<?php endif; ?>

	<div class="uk-grid">
		<div class="uk-width-large-6-10 uk-width-small-1-1">
			<?php if($this->item->params->get('itemImage') && !empty($this->item->image)): ?>
			<!-- Item Image -->
		    <div class="itemImageBlock">
			  <span class="itemImage">
			  	<a data-rokbox href="<?php echo $this->item->imageXLarge; ?>" title="<?php echo JText::_('K2_CLICK_TO_PREVIEW_IMAGE'); ?>" data-rokbox-caption="<?php echo $this->item->title; ?>">
			  		<span class="image-over-style"></span>
			  		<img src="<?php echo $this->item->image; ?>" alt="<?php if(!empty($this->item->image_caption)) echo K2HelperUtilities::cleanHtml($this->item->image_caption); else echo K2HelperUtilities::cleanHtml($this->item->title); ?>" style="width:<?php echo $this->item->imageWidth; ?>px; height:auto;"  />
		  			<?php if($this->item->params->get('itemFeaturedNotice') && $this->item->featured): ?>
					  	<!-- Featured flag -->
					  	<span class="itemFeatured">
						  	<?php echo JText::_('K2_FEATURED'); ?>
					  	</span>
				  	<?php endif; ?>
			  	</a>
			  </span>

			  <?php if($this->item->params->get('itemImageMainCaption') && !empty($this->item->image_caption)): ?>
			  <!-- Image caption -->
			  <span class="itemImageCaption"><?php echo $this->item->image_caption; ?></span>
			  <?php endif; ?>

			  <?php if($this->item->params->get('itemImageMainCredits') && !empty($this->item->image_credits)): ?>
			  <!-- Image credits -->
			  <span class="itemImageCredits"><?php echo $this->item->image_credits; ?></span>
			  <?php endif; ?>

			  <div class="clr"></div>
		    </div>
			<?php endif; ?>
		</div>
		<div class="uk-width-large-4-10 uk-width-small-1-1">
			<!-- Plugins: AfterDisplayTitle -->
			<?php echo $this->item->event->AfterDisplayTitle; ?>
			<div class="project-item-Body">

			<!-- Plugins: BeforeDisplayContent -->
			<?php echo $this->item->event->BeforeDisplayContent; ?>

			<!-- K2 Plugins: K2BeforeDisplayContent -->
			<?php echo $this->item->event->K2BeforeDisplayContent; ?>

			<?php if(!empty($this->item->fulltext)): ?>
			<?php if($this->item->params->get('itemIntroText')): ?>
			<!-- Item introtext -->
			<div class="projectItemIntroText">
				<?php echo $this->item->introtext; ?>
			</div>
			<?php endif; ?>
			<?php if($this->item->params->get('itemFullText')): ?>
			<!-- Item fulltext -->
			<div class="itemFullText">
				<?php echo $this->item->fulltext; ?>
			</div>
			<?php endif; ?>
			<?php else: ?>
			<!-- Item text -->
			<div class="itemFullText">
				<?php echo $this->item->introtext; ?>
			</div>
			<?php endif; ?>

			<div class="clr"></div>

			<?php if($this->item->params->get('itemExtraFields') && count($this->item->extra_fields)): ?>
			<!-- Item extra fields -->
			<div class="itemExtraFields">
				<h3><?php echo JText::_('K2_ADDITIONAL_INFO'); ?></h3>
				<ul class="uk-list uk-list-line">
				<?php foreach ($this->item->extra_fields as $key=>$extraField): ?>
				<?php if($extraField->value != ''): ?>
				<li class="<?php echo ($key%2) ? "odd" : "even"; ?> type<?php echo ucfirst($extraField->type); ?> group<?php echo $extraField->group; ?>">
					<?php if($extraField->type == 'header'): ?>
					<h4 class="itemExtraFieldsHeader"><?php echo $extraField->name; ?></h4>
					<?php else: ?>
					<span class="itemExtraFieldsLabel"><?php echo $extraField->name; ?>:</span>
					<span class="itemExtraFieldsValue"><?php echo $extraField->value; ?></span>
					<?php endif; ?>
				</li>
				<?php endif; ?>
				<?php endforeach; ?>
				</ul>
			<div class="clr"></div>
			</div>
			<?php endif; ?>

			<!-- Plugins: AfterDisplayContent -->
			<?php echo $this->item->event->AfterDisplayContent; ?>

			<!-- K2 Plugins: K2AfterDisplayContent -->
			<?php echo $this->item->event->K2AfterDisplayContent; ?>

			<div class="clr"></div>
			</div>
		</div>
	</div>

	<?php if($this->item->params->get('itemHits') || ($this->item->params->get('itemDateModified') && intval($this->item->modified)!=0)): ?>
	<div class="itemContentFooter">

		<?php if($this->item->params->get('itemHits')): ?>
		<!-- Item Hits -->
		<span class="itemHits">
			<?php echo JText::_('K2_READ'); ?> <b><?php echo $this->item->hits; ?></b> <?php echo JText::_('K2_TIMES'); ?>
		</span>
		<?php endif; ?>

		<?php if($this->item->params->get('itemDateModified') && intval($this->item->modified)!=0): ?>
		<!-- Item date modified -->
		<span class="itemDateModified">
			<?php echo JText::_('K2_LAST_MODIFIED_ON'); ?> <?php echo JHTML::_('date', $this->item->modified, JText::_('K2_DATE_FORMAT_LC2')); ?>
		</span>
		<?php endif; ?>

		<div class="clr"></div>
	</div>
	<?php endif; ?>

	<div class="clr"></div>
</div>
<!-- End K2 Item Layout -->
