<?php
/**
* @package   yoo_master2
* @author    YOOtheme http://www.yootheme.com
* @copyright Copyright (C) YOOtheme GmbH
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

// get theme configuration
include($this['path']->path('layouts:theme.config.php'));
include($this['path']->path('layouts:header.php'));

?>

<!DOCTYPE HTML>
<html lang="<?php echo $this['config']->get('language'); ?>" dir="<?php echo $this['config']->get('direction'); ?>"  data-config='<?php echo $this['config']->get('body_config','{}'); ?>'>
<head>
<?php echo $this['template']->render('head'); ?>
</head>

<body class="<?php echo $this['config']->get('body_classes'); ?>">
	<?php if ($this['config']->get('layout_width') == 'boxed') : ?>
	<div class="layout-boxed-wrapper">
	<?php endif; ?>
	
	<?php if ($this['widgets']->count('drawer')) : ?>
		<div class="<?php echo $wrapper_classes['drawer']; ?>">
			<div id="drawer">
				<div class="uk-container uk-container-center">
					<section class="<?php echo $grid_classes['drawer']; ?>" data-uk-grid-match="{target:'> div > .uk-panel'}" data-uk-grid-margin><?php echo $this['widgets']->render('drawer', array('layout'=>$this['config']->get('grid.drawer.layout'))); ?></section>
				</div>
			</div>
			<a href="#" class="drawer_toggle"><span class="uk-icon-plus"></span></a>
		</div>
	<?php endif; ?>

	<div class="header-top-wrapper">

		<?php if ($this['widgets']->count('toolbar-l + toolbar-r')) : ?>
		<div class="uk-container uk-container-center">
			<div class="tm-toolbar uk-clearfix uk-hidden-small">

				<?php if ($this['widgets']->count('toolbar-l')) : ?>
				<div class="uk-float-left toolbar-l"><?php echo $this['widgets']->render('toolbar-l'); ?></div>
				<?php endif; ?>

				<?php if ($this['widgets']->count('toolbar-r')) : ?>
				<div class="uk-float-right toolbar-r"><?php echo $this['widgets']->render('toolbar-r'); ?></div>
				<?php endif; ?>

			</div>
		</div>	
		<?php endif; ?>
	
		<?php // This is dynamic header ?>
		<?php bdt_headerStyle($this); ?>
	</div>
	
	<?php if ($this['widgets']->count('heading')) : ?>
		<div class="<?php echo $wrapper_classes['heading']; ?>">
				<section class="<?php echo $grid_classes['heading']; ?>">
					<?php echo $this['widgets']->render('heading', array('layout'=>$this['config']->get('grid.heading.layout'))); ?>

					<?php if ($this['widgets']->count('breadcrumbs')) : ?>
						<div class="breadcrumbs-wrapper">
							<div class="uk-container uk-container-center">
								<div class="uk-width-1-1">
									<?php echo $this['widgets']->render('breadcrumbs'); ?>
								</div>
							</div>
						</div>
					<?php endif; ?>
				</section>
		</div>
	<?php endif; ?>
	
	<?php if ($this['widgets']->count('slider')) : ?>
		<div class="<?php echo $wrapper_classes['slider']; ?>">
			<div class="uk-container-center">
				<section class="<?php echo $grid_classes['slider']; ?>" data-uk-grid-match="{target:'> div > .uk-panel'}" data-uk-grid-margin><?php echo $this['widgets']->render('slider', array('layout'=>$this['config']->get('grid.slider.layout'))); ?></section>
			</div>
		</div>
	<?php endif; ?>

	<?php if ($this['widgets']->count('features')) : ?>
		<div class="<?php echo $wrapper_classes['features']; ?>">
			<div class="uk-container uk-container-center">
				<section class="<?php echo $grid_classes['features']; ?>" data-uk-grid-match="{target:'> div > .uk-panel'}" data-uk-grid-margin><?php echo $this['widgets']->render('features', array('layout'=>$this['config']->get('grid.features.layout'))); ?></section>
			</div>
		</div>
	<?php endif; ?>
			
	<?php if ($this['widgets']->count('top-a')) : ?>
		<div class="<?php echo $wrapper_classes['top-a']; ?>">
			<div class="uk-container uk-container-center">
				<section class="<?php echo $grid_classes['top-a']; ?>" data-uk-grid-match="{target:'> div > .uk-panel'}" data-uk-grid-margin><?php echo $this['widgets']->render('top-a', array('layout'=>$this['config']->get('grid.top-a.layout'))); ?></section>
			</div>
		</div>
	<?php endif; ?>


	<?php if ($this['widgets']->count('top-b')) : ?>
		<div class="<?php echo $wrapper_classes['top-b']; ?>">
			<div class="uk-container uk-container-center">
				<section class="<?php echo $grid_classes['top-b']; ?>" data-uk-grid-match="{target:'> div > .uk-panel'}" data-uk-grid-margin><?php echo $this['widgets']->render('top-b', array('layout'=>$this['config']->get('grid.top-b.layout'))); ?></section>
			</div>
		</div>
	<?php endif; ?>

	<?php if ($this['widgets']->count('main-top + main-bottom + sidebar-a + sidebar-b') || $this['config']->get('system_output', true)) : ?>
		<div class="mainbody-wrapper">
			<div class="uk-container uk-container-center">
				<div class="tm-middle uk-grid" data-uk-grid-match data-uk-grid-margin>

					<?php if ($this['widgets']->count('main-top + main-bottom') || $this['config']->get('system_output', true)) : ?>
					<div class="<?php echo $columns['main']['class'] ?>">

						<?php if ($this['widgets']->count('main-top')) : ?>
						<section class="<?php echo $grid_classes['main-top']; ?>" data-uk-grid-match="{target:'> div > .uk-panel'}" data-uk-grid-margin><?php echo $this['widgets']->render('main-top', array('layout'=>$this['config']->get('grid.main-top.layout'))); ?></section>
						<?php endif; ?>

						<?php if ($this['config']->get('system_output', true)) : ?>
						<main class="tm-content">

							<?php echo $this['template']->render('content'); ?>

						</main>
						<?php endif; ?>

						<?php if ($this['widgets']->count('main-bottom')) : ?>
						<section class="<?php echo $grid_classes['main-bottom']; ?>" data-uk-grid-match="{target:'> div > .uk-panel'}" data-uk-grid-margin><?php echo $this['widgets']->render('main-bottom', array('layout'=>$this['config']->get('grid.main-bottom.layout'))); ?></section>
						<?php endif; ?>

					</div>
					<?php endif; ?>

		            <?php foreach($columns as $name => &$column) : ?>
		            <?php if ($name != 'main' && $this['widgets']->count($name)) : ?>
		            <aside class="<?php echo $column['class'] ?>"><?php echo $this['widgets']->render($name) ?></aside>
		            <?php endif ?>
		            <?php endforeach ?>

				</div>
			</div>
		</div>
	<?php endif; ?>

	<?php if ($this['widgets']->count('expanded-top')) : ?>
		<div class="<?php echo $wrapper_classes['expanded-top']; ?>">
			<div class="uk-container uk-container-center">
				<section class="<?php echo $grid_classes['expanded-top']; ?>" data-uk-grid-match="{target:'> div > .uk-panel'}" data-uk-grid-margin><?php echo $this['widgets']->render('expanded-top', array('layout'=>$this['config']->get('grid.expanded-top.layout'))); ?></section>
			</div>
		</div>
	<?php endif; ?>

	<?php if ($this['widgets']->count('expanded-bottom')) : ?>
		<div class="<?php echo $wrapper_classes['expanded-bottom']; ?>">
			<div class="uk-container uk-container-center">
				<section class="<?php echo $grid_classes['expanded-bottom']; ?>" data-uk-grid-match="{target:'> div > .uk-panel'}" data-uk-grid-margin><?php echo $this['widgets']->render('expanded-bottom', array('layout'=>$this['config']->get('grid.expanded-bottom.layout'))); ?></section>
			</div>
		</div>
	<?php endif; ?>

	<?php if ($this['widgets']->count('bottom-a')) : ?>
		<div class="<?php echo $wrapper_classes['bottom-a']; ?>">
			<div class="uk-container uk-container-center">
				<section class="<?php echo $grid_classes['bottom-a']; ?>" data-uk-grid-match="{target:'> div > .uk-panel'}" data-uk-grid-margin><?php echo $this['widgets']->render('bottom-a', array('layout'=>$this['config']->get('grid.bottom-a.layout'))); ?></section>
			</div>
		</div>
	<?php endif; ?>

		
	<?php if ($this['widgets']->count('bottom-b')) : ?>
		<div class="<?php echo $wrapper_classes['bottom-b']; ?>" >
			<div class="uk-container uk-container-center ">
				<section class="<?php echo $grid_classes['bottom-b']; ?>" data-uk-grid-match="{target:'> div > .uk-panel'}" data-uk-grid-margin><?php echo $this['widgets']->render('bottom-b', array('layout'=>$this['config']->get('grid.bottom-b.layout'))); ?></section>
			</div>
		</div>
	<?php endif; ?>

	<?php if ($this['widgets']->count('footer + footer-r + debug') || $this['config']->get('warp_branding', true) || $this['config']->get('totop_scroller', true)) : ?>
		<div class="footer-wrapper">
			<div class="uk-container uk-container-center">
				<footer class="tm-footer">
					<div class="uk-grid">
						<div class="uk-width-large-1-2 uk-width-medium-1-1 footer-l">
							<?php
								echo $this['widgets']->render('footer');
								$this->output('warp_branding');
							?>
						</div>
						<div class="uk-width-large-1-2 uk-width-medium-1-1 footer-r">
							<?php
								echo $this['widgets']->render('footer-r');
							?>
						</div>
					</div>
					
					<?php echo $this['widgets']->render('debug'); ?>

				</footer>

			</div>
		</div>
	<?php endif; ?>

	<?php echo $this->render('footer'); ?>

	<?php if ($this['config']->get('totop_scroller', true)) : ?>
	<a class="tm-totop-scroller totop-hidden" data-uk-smooth-scroll href="#"></a>
	<?php endif; ?>

	<?php if ($this['widgets']->count('offcanvas')) : ?>
	<div id="offcanvas" class="uk-offcanvas">
		<div class="uk-offcanvas-bar"><?php echo $this['widgets']->render('offcanvas'); ?></div>
	</div>
	<?php endif; ?>

	<?php if ($this['config']->get('layout_width') == 'boxed') : ?>
	</div>
	<?php endif; ?>
</body>
</html>