<?php

/*
* @category    Controlador Profesionales
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

require("../../../core/php/_database.php");
require("../../../core/php/php_functions.php");

$task = '';
if ( isset($_POST['task'])){
  $task = $_POST['task'];
}
switch($task){
    case "LISTAR":
        Listar();
        break;
    case "INSERTAR":
        Insertar();
        break;
    case "MODIFICAR":
        Modificar();
        break;
    case "ELIMINAR":
        Eliminar();
        break;
    default:
        echo "{failure:true}";
        break;
}

function Insertar()
{
    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_agendas_tiposhorario_insert(" . spParametros($estructura,"NO") . ")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function Modificar()
{
    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_agendas_tiposhorario_update(" . spParametros($estructura,"NO") . ")";
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function Eliminar()
{
    $pIdTipoHorario = isset($_REQUEST['pIdTipoHorario'])?$_REQUEST['pIdTipoHorario']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_agendas_tiposhorario_delete('" . $pIdTipoHorario . "')";
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo '1';
    else
        echo '0';
    $gBaseDatos->cerrar();
}

function Listar()
{
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    if (is_null($pEmpresa) || $pEmpresa == 0)
        $pEmpresa = isset($_REQUEST['paramP1'])?$_REQUEST['paramP1']:0;
    $Horario = isset($_REQUEST['query']) ? $_REQUEST['query'] : null;
    if (is_null($Horario) || $Horario == "")
        $Horario = "Todos";
    $qry = "CALL sp_agendas_grid_tiposhorario('" . $pEmpresa . "',\"" . $Horario . "\")";
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $nbrows = $gBaseDatos->nroRegistros();
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    //echo $qry;
    if($nbrows>0){
        $gBaseDatos->conectar();
        $start = (integer) (isset($_POST['start']) ? $_POST['start'] : $_GET['start']);
        $end = (integer) (isset($_POST['limit']) ? $_POST['limit'] : $_GET['limit']);
        $qry = "CALL sp_agendas_grid_tiposhorario_limit('" . $pEmpresa . "',\"" . $Horario . "\",'" . $start . "','" . $end . "')";
        //echo $qry;
        $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
        while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
        {
            $nRow = $row;
            foreach($row as $key => $val)
            {
                $nRow[$key] = PonerAcentosHTML($val);
            }
            $arr[] = $nRow;
        }
        $jsonresult = JEncode($arr);
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        echo '({"total":"'.$nbrows.'","results":'.$jsonresult.'})';
    } else {
        echo '({"total":"0", "results":""})';
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
}

?>
