<?php
    set_time_limit(500);
    require_once('../../../lib/tcpdf/config/lang/spa.php');
    require_once('../../../lib/tcpdf/tcpdf.php');
    require("../../../core/php/_database.php");
    require("../../../core/php/php_functions.php");
    header('Content-type: application/pdf; charset: UTF-8');
    
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS']) ? $_REQUEST['pIPS']:0;
    $pPaciente = isset($_REQUEST['pPaciente']) ? $_REQUEST['pPaciente']:0;
    $pDesde = isset($_REQUEST['pDesde']) ? $_REQUEST['pDesde']:null;
    $pHasta = isset($_REQUEST['pHasta']) ? $_REQUEST['pHasta']:null;
    $pNomBaseDatos = isset($_REQUEST['pNomBaseDatos'])?$_REQUEST['pNomBaseDatos']:"NA";
    if($pNomBaseDatos == "NA"){
        $gBaseDatos = new ofiMySQLi();
    }else{
        $gBaseDatos = new ofiMySQLi($pNomBaseDatos);
    }
    $qry = "CALL sp_historial_citas_asignadas_print('" . $pPaciente . "','". $pEmpresa . "','" . $pIPS . "',\"" . $pDesde . "\",\"" . $pHasta . "\")";
    
    // create new PDF document
    $pdf = new TCPDF("P", PDF_UNIT, "CARTA", true, 'UTF-8', false);
    // set document information
    $pdf->SetCreator(PDF_CREATOR);
    $pdf->SetAuthor('Sistemas Ofisalud © - 2006');
    $pdf->SetTitle('MORBILIDAD');
    $pdf->SetSubject('Informe Historial Citas Asignadas');
    // set default header data
    session_start();
    $pdf->pAlineacionEncabezado = "L";
    $pdf->pTituloInforme = "HISTORIAL CITAS ASIGNADAS";
    $pdf->pImprimeLogo = "NO";
    $pdf->pAnchoTxtPagina = 270;
    $pdf->pNomEmpresa = $_SESSION['NOM_EMPRESA'];
    $pdf->pNomSede = $_SESSION['NOM_SEDE'];
    $pdf->pNomIPS = $_SESSION['NOM_IPS'];
    $pdf->pMargenPie = -20;
    if($_SESSION['IdAplicacion'] == "OfiMedical"){
        $pdf->pLogoCliente = "../../../consultoriovirtual/" . $_SESSION['IDBD'] . "/logo/logoenc.gif";
    }else{
        $pdf->pLogoCliente = "../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/logoenc.gif";
    }
    $pdf->SetHeaderData($pdf->pLogoCliente, PDF_HEADER_LOGO_WIDTH, $pdf->pTituloInforme, PDF_HEADER_STRING);
    // set header and footer fonts
    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
    // set default monospaced font
    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
    //set margins
    $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
    $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
    $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
    //set auto page breaks
    $pdf->SetAutoPageBreak(FALSE, PDF_MARGIN_BOTTOM);
    //set image scale factor
    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
    //set some language-dependent strings
    $pdf->setLanguageArray($l);
    // set default font subsetting mode
    $pdf->setFontSubsetting(true);
    $pdf->SetFont('dejavusans', '', 14, '', true);

    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    while ($row[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
    $pRegistros = count($row)-1;
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $i = 0;
    $rowcount = 0;
    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
    
    for($i=0;$i<$pRegistros;$i++)
    {
        if($row[$i]["CAS"] != ""){
            $rowcount = max($pdf->getNumLines(utf8_decode($row[$i]["Descripcion"]),203),1)*4;
            $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 9);
            EscribeDetalle($pdf, $row, $i, $rowcount, $contador);
            if (($pdf->GetY()+$rowcount) > 195)
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
        }
    }
    $pdf->Output('infCitasAsignadas.pdf', 'I');

    function EncabezadoPagina(&$pdf, &$row, &$i, &$rowcount, &$contador, &$pDesde, &$pHasta){
        $pdf->AddPage();
        $pdf->Ln(6);
        $pdf->SetFont(PDF_FONT_NAME_MAIN,'B',11);
        //$pdf->MultiCell(264,10,"Periodo: " . $pDesde . " - " . $pHasta ,0,'L',0,0);
        $rowcount = max($pdf->getNumLines($row[$i]["TipDoc"] . " - " . $row[$i]["Documento"] . " " . $row[$i]["PrimerNombre"] . " " . $row[$i]["SegundoNombre"] . " " . $row[$i]["PrimerApellido"] . " " . $row[$i]["SegundoApellido"],203),5);
        //$pdf->Ln(24);
        $pdf->writeHTMLCell(203, $rowcount, '', '', "Paciente: " . PonerAcentosHTML($row[$i]["TipDoc"] . " - " . $row[$i]["Documento"] . " " . $row[$i]["PrimerNombre"] . " " . $row[$i]["SegundoNombre"] . " " . $row[$i]["PrimerApellido"] . " " . $row[$i]["SegundoApellido"]), 0, 0, 0, true, 'L', true);
        $pdf->Ln();
        $rowcount = max($pdf->getNumLines($row[$i]["TipDoc"],203),5);
        $pdf->writeHTMLCell(203, $rowcount, '', '', PonerAcentosHTML("Direccion: " . $row[$i]["Dieccion"] . " - Tel: " . $row[$i]["Telefono"] . " " . $row[$i]["Telefono2"]), 0, 0, 0, true, 'L', true);
        $pdf->Ln();
        $rowcount = max($pdf->getNumLines($row[$i]["Cliente"],203),5);
        $pdf->writeHTMLCell(203, $rowcount, '', '', PonerAcentosHTML("Entidad: " . $row[$i]["Cliente"]), 0, 0, 0, true, 'L', true);
        $pdf->Ln();
        if($pDesde != "" && $pHasta != "" && $pDesde != null && $pHasta != null && $pDesde != "null" && $pHasta != "null"){
            $rowcount = 5;
            $pdf->writeHTMLCell(203, $rowcount, '', '', "Desde: " . $pDesde . " - Hasta: " . $pHasta, 0, 0, 0, true, 'L', true);
            $pdf->Ln();
        }
        EncabezadoColumnas($pdf);
    }
   
    function EncabezadoColumnas(&$pdf)
    {
        $pdf->SetFillColor(242 , 236, 236);
        $pdf->Ln(4.5);
        $pdf->SetFont(PDF_FONT_NAME_MAIN,'B',9);
        $pdf->MultiCell(10,5,"Nro",1,'C',1,0);
        $pdf->MultiCell(25,5,"Fecha",1,'C',1,0);
        $pdf->MultiCell(40,5,"Hora",1,'C',1,0);
        $pdf->MultiCell(85,5,"Profesional",1,'C',1,0);
        $pdf->MultiCell(40,5,"Firma / Acudiente",1,'C',1,0);
        $pdf->Ln();
    }
    function EscribeDetalle(&$pdf, &$row, &$i, &$rowcount, &$contador)
    {
        $HoraCita = "";
        if($row[$i]["DesCita"] == "" || $row[$i]["DesCita"] == null || $row[$i]["DesCita"] == "null"){
            $HoraCita = $row[$i]["DesCitaManual"];
        }else{
            $HoraCita = $row[$i]["DesCita"];
        }
        $pdf->writeHTMLCell(10, 10, '', '', $i+1, 1, 0, 0, true, 'C', true);
        $pdf->writeHTMLCell(25, 10, '', '', $row[$i]["FecCita"], 1, 0, 0, true, 'L', true);
        $pdf->writeHTMLCell(40, 10, '', '', $HoraCita, 1, 0, 0, true, 'L', true);
        $pdf->writeHTMLCell(85, 10, '', '', $row[$i]["Profesional"], 1, 0, 0, true, 'L', true);
        $pdf->writeHTMLCell(40, 10, '', '', "", 1, 0, 0, true, 'C', true);
        $pdf->Ln();
    }
    
?>