<?php

/*
* @category    Controlador Confirmacion Citas
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

require("../../../core/php/_database.php");
require("../../../core/php/php_functions.php");

$task = '';
if ( isset($_POST['task'])){
  $task = $_POST['task'];
}
switch($task){
    case "LISTAR":
        Listar();
        break;
    case "CONFIRMAR_CITA":
        ConfirmarCita();
        break;
    case "RECHAZO_CITA":
        RechazoCita();
        break;
    case "HISTORIAL_CITAS_ASIGNADAS_MANUAL":
        Historial_CitasAsignadasManual();
        break;
    default:
        echo "{failure:true}";
        break;
}

function Listar(){
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pDesde = isset($_REQUEST['pDesde']) ? $_REQUEST['pDesde']:null;
    $pHasta = isset($_REQUEST['pHasta']) ? $_REQUEST['pHasta']:null;
    $pMunicipio = isset($_REQUEST['pMunicipio'])?$_REQUEST['pMunicipio']:0;
    $pCliente = isset($_REQUEST['pCliente'])?$_REQUEST['pCliente']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_grid_confirmar_cita_listar('" . $pPaciente . "',\"" . $pDesde . "\",\"" . $pHasta . "\",'" . $pMunicipio . "','" . $pCliente . "')";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = PonerAcentosHTML($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}
        
function ConfirmarCita(){
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $pIdAgendaManual = isset($_REQUEST['pIdAgendaManual'])?$_REQUEST['pIdAgendaManual']:0;
    $pObservacionesCon = isset($_REQUEST['pObservacionesCon'])?$_REQUEST['pObservacionesCon']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pFecha = isset($_REQUEST['pFecha'])?$_REQUEST['pFecha']:0;
    $pHora = isset($_REQUEST['pHora'])?$_REQUEST['pHora']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_grid_confirmar_cita_update('" . $pUsuario . "','" . $pPaciente . "','" . $pCAS . "',\"" . $pFecha . "\",'" . $pHora . "','" . $pIdAgendaManual . "','" . $pObservacionesCon . "')";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function RechazoCita(){
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $pIdAgendaManual = isset($_REQUEST['pIdAgendaManual'])?$_REQUEST['pIdAgendaManual']:0;
    $pObservacionesCon = isset($_REQUEST['pObservacionesCon'])?$_REQUEST['pObservacionesCon']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pFecha = isset($_REQUEST['pFecha'])?$_REQUEST['pFecha']:0;
    $pHora = isset($_REQUEST['pHora'])?$_REQUEST['pHora']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_grid_confirmar_cita_rechazo_update('" . $pUsuario . "','" . $pPaciente . "','" . $pCAS . "',\"" . $pFecha . "\",'" . $pHora . "','" . $pIdAgendaManual . "','" . $pObservacionesCon . "')";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}


function Historial_CitasAsignadasManual(){
    // OR = ||
    
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pPaciente = isset($_REQUEST['pPaciente']) ? $_REQUEST['pPaciente']:0;
    $pNomBaseDatos = isset($_REQUEST['pNomBaseDatos'])?$_REQUEST['pNomBaseDatos']:"NA";
    if($pNomBaseDatos == "NA"){
        $gBaseDatos = new ofiMySQLi();
    }else{
        $gBaseDatos = new ofiMySQLi($pNomBaseDatos);
    }
    $gBaseDatos->conectar();
    $qry = "CALL sp_historial_citas_asignadas_confirmacion_citas('" . $pPaciente . "','". $pEmpresa . "')";
    $CampoLlave = explode("^",$gBaseDatos->jasonSP_arreglo2011($qry));
    $nbrows = $CampoLlave[0];
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    if($nbrows>0){
        $gBaseDatos->conectar();
        $start = (integer) (isset($_POST['start']) ? $_POST['start'] : $_GET['start']);
        $end = (integer) (isset($_POST['limit']) ? $_POST['limit'] : $_GET['limit']);
        $qry = "CALL sp_historial_citas_asignadas_confirmacion_citas_limit('" . $pPaciente . "','". $pEmpresa . "','" . $start . "','" . $end . "')";
        //echo $qry;
        $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
        while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
        {
            $nRow = $row;
            foreach($row as $key => $val)
            {
                $nRow[$key] = PonerAcentosHTML($val);
            }
            $arr[] = $nRow;
        }
        $jsonresult = JEncode($arr);
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        echo '({success: true, requestedId:"1", "total":"'.$nbrows.'","results":'.$jsonresult.'})';
    } else {
        echo '({success: true, requestedId:"1", "total":"0", "results":""})';
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
}
?>
