<?php

/*
* @category    Controlador Hospitalizacion
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/
header("Content-Type: text/plain; charset=UTF-8");
require("../../../core/php/_database.php");
require("../../../core/php/php_functions.php");
session_start();

$task = '';
if ( isset($_POST['task'])){
  $task = $_POST['task'];
}
switch($task){
    case "ImportarUltimaAtencion":
        CargarUltimaAtencion();
        break;
    case "guardar":
        GuardarHC();
        break;
    case "modificar":
        ModificarHC();
        break;
    case "VerHistorialObservaHospitalizaxPaciente":
        VerHistorialObservaHospitalizaHCxPaciente();
        break;
    case "VerMxSolicitadosxHC":
        VerConceptosSolicitadosxHC("M");
        break;
    case "VerExaSolicitadosxHC":
        VerConceptosSolicitadosxHC("E");
        break;
    case "GUARDAR_SOLMX":
        GuardarMX();
        break;
    case "ELIMINAR_SOLMX":
        EliminarMX();
        break;
    case "GUARDAR_SOLEXA":
        GuardarEXA();
        break;
    case "ImportarEpicrisisOrigenAtencion":
        ImportarOrigenEpicrisis();
        break;
    case "guardar_epicrisis":
        GuardarEpicrisisHC();
        break;
    case "modificar_epicrisis":
        ModificarEpicrisisHC();
        break;
    default:
        echo "{failure:true}";
        break;
}

function ImportarOrigenEpicrisis(){
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $qry = "CALL sp_asistencial_observahospitaliza_epicrisis_load_origenservicio('" . $pPaciente . "','" . $pCAS . "')";
    //echo $qry;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $resY = str_replace("<BR \/><br \/>","",PonerAcentosHTML($gBaseDatos->jsonSP($qry,"D")));
    $res = str_replace("<br \/>","",$resY);
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $res1 = str_replace("[", "", $res);
    $res = str_replace("]", "", $res1);
    echo $res;
}
//ATENCION CONSULTA PRIORITARIA - URGENCIAS
//sp_asistencial_observahospitaliza_epicrisis_load_origenservicio

function CargarUltimaAtencion(){
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $qry = "CALL sp_asistencial_observahospitaliza_load_ultimo('" . $pPaciente . "','" . $pCAS . "')";
    //echo $qry;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $resY = str_replace("<BR \/><br \/>","",PonerAcentosHTML($gBaseDatos->jsonSP($qry,"D")));
    $res = str_replace("<br \/>","",$resY);
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    echo $res;
}

function GuardarHC(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    //$pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $pProfesional = $_SESSION['ID_PROFESIONAL_HC'];
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pidPlantillaHC = isset($_REQUEST['pidPlantillaHC'])?$_REQUEST['pidPlantillaHC']:0;
    $pFechaAtencion = isset($_REQUEST['pFechaAtencion'])?$_REQUEST['pFechaAtencion']:null;
    $pHoraApertura = isset($_REQUEST['pHoraApertura'])?$_REQUEST['pHoraApertura']:null;
    $pActividad = isset($_REQUEST['pActividad'])?$_REQUEST['pActividad']:null;
    $pPlantilla = isset($_REQUEST['pPlantilla'])?$_REQUEST['pPlantilla']:null;
    $pRutaRptHC = isset($_REQUEST['pRutaRptHC'])?$_REQUEST['pRutaRptHC']:null;
    $pRutaRptMx = isset($_REQUEST['pRutaRptMx'])?$_REQUEST['pRutaRptMx']:null;
    $pRutaRptExa = isset($_REQUEST['pRutaRptExa'])?$_REQUEST['pRutaRptExa']:null;
    $pRutaRptRem = isset($_REQUEST['pRutaRptRem'])?$_REQUEST['pRutaRptRem']:null;
    $pServicio = isset($_REQUEST['pServicio'])?$_REQUEST['pServicio']:null;
    $pTipoNota = isset($_REQUEST['pTipoNota'])?$_REQUEST['pTipoNota']:null;
    $contenido = isset($_REQUEST['CAMPOS'])?$_REQUEST['CAMPOS']:null;
    $pEvolucion = stripslashes(utf8_encode(str_replace('"', '""',nl2br($contenido))));
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $pIdCliente = isset($_REQUEST['pIdCliente'])?$_REQUEST['pIdCliente']:0;
    $CodInsercion = "PRS-" .  $_SESSION['ID_EMPRESA'] . "-SED-" . $_SESSION['ID_SEDE'] .  "-IPS-" . $_SESSION['ID_IPS'] . "-USR-" . $_SESSION['ID_USUARIO'] . "-CAS-" . $pCAS . "-CONS-" . mt_rand(0,100000) . "-" . date("His");
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_observahospitaliza_add_evolucion2013('" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pProfesional . "','" . $pCAS . "','" . $pidPlantillaHC . "',\"" . $pFechaAtencion . "\",\"" . $pHoraApertura . "\",\"" . $pActividad . "\",\"" . $pPlantilla . "\",\"" . $pRutaRptHC . "\",\"" . $pRutaRptMx . "\",\"" . $pRutaRptExa . "\",\"" . $pRutaRptRem . "\",\"" . $pEvolucion . "\",'" . $pUsuario . "','" . $pIdCliente . "',\"" . $CodInsercion . "\",\"" . $pServicio . "\",\"" . $pTipoNota . "\")";
    //echo $qry;
    $CampoLlave = explode("^",$gBaseDatos->jasonSP_arreglo2011($qry));
    $gBaseDatos->cerrar();   
    $ConsecutivoHC = $CampoLlave[0];
    if($ConsecutivoHC != 0)
        echo "{success: true, requestedId:'" . $ConsecutivoHC . "'}";
    else
       echo "{success: true, requestedId:'0'}";
}

function ModificarHC(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    //$pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $pProfesional = $_SESSION['ID_PROFESIONAL_HC'];
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pConsecutivoDetalle = isset($_REQUEST['pConsecutivoDetalle'])?$_REQUEST['pConsecutivoDetalle']:0;
    $pidPlantillaHC = isset($_REQUEST['pidPlantillaHC'])?$_REQUEST['pidPlantillaHC']:0;
    $pFechaAtencion = isset($_REQUEST['pFechaAtencion'])?$_REQUEST['pFechaAtencion']:null;
    $pHoraApertura = isset($_REQUEST['pHoraApertura'])?$_REQUEST['pHoraApertura']:null;
    $pActividad = isset($_REQUEST['pActividad'])?$_REQUEST['pActividad']:null;
    $pPlantilla = isset($_REQUEST['pPlantilla'])?$_REQUEST['pPlantilla']:null;
    $pRutaRptHC = isset($_REQUEST['pRutaRptHC'])?$_REQUEST['pRutaRptHC']:null;
    $pRutaRptMx = isset($_REQUEST['pRutaRptMx'])?$_REQUEST['pRutaRptMx']:null;
    $pRutaRptExa = isset($_REQUEST['pRutaRptExa'])?$_REQUEST['pRutaRptExa']:null;
    $pRutaRptRem = isset($_REQUEST['pRutaRptRem'])?$_REQUEST['pRutaRptRem']:null;
    $pServicio = isset($_REQUEST['pServicio'])?$_REQUEST['pServicio']:null;
    $pTipoNota = isset($_REQUEST['pTipoNota'])?$_REQUEST['pTipoNota']:null;
    $contenido = isset($_REQUEST['CAMPOS'])?$_REQUEST['CAMPOS']:null;
    $pEvolucion = stripslashes(utf8_encode(str_replace('"', '""',nl2br($contenido))));
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $pIdCliente = isset($_REQUEST['pIdCliente'])?$_REQUEST['pIdCliente']:0;
    $CodInsercion = "PRS-" .  $_SESSION['ID_EMPRESA'] . "-SED-" . $_SESSION['ID_SEDE'] .  "-IPS-" . $_SESSION['ID_IPS'] . "-USR-" . $_SESSION['ID_USUARIO'] . "-CAS-" . $pCAS . "-CONS-" . mt_rand(0,100000) . "-" . date("His");
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_observahospitaliza_edit_evolucion2013('" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pProfesional . "','" . $pCAS . "','" . $pConsecutivoDetalle . "','" . $pidPlantillaHC . "',\"" . $pFechaAtencion . "\",\"" . $pHoraApertura . "\",\"" . $pActividad . "\",\"" . $pPlantilla . "\",\"" . $pRutaRptHC . "\",\"" . $pRutaRptMx . "\",\"" . $pRutaRptExa . "\",\"" . $pRutaRptRem . "\",\"" . $pEvolucion . "\",'" . $pUsuario . "','" . $pIdCliente . "',\"" . $CodInsercion . "\",\"" . $pServicio . "\",\"" . $pTipoNota . "\")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function VerHistorialObservaHospitalizaHCxPaciente(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pServicio = isset($_REQUEST['pServicio'])?$_REQUEST['pServicio']:"T";
    if($pServicio == "" || $pServicio == null){
        $pServicio = "T";
    }
    $pNota = isset($_REQUEST['pNota'])?$_REQUEST['pNota']:"Todos";
    if($pNota == "" || $pNota == null){
        $pNota = "Todos";
    }
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_observahospitaliza_evolucionesxpaciente('" . $pEmpresa . "','" . $pPaciente . "',\"" . $pServicio . "\",\"" . $pNota . "\")";
    //echo $qry; 
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = utf8_decode($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}

function VerConceptosSolicitadosxHC($pTipoConcepto){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pConsecutivoHC = isset($_REQUEST['pConsecutivoHC'])?$_REQUEST['pConsecutivoHC']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_observahospitaliza_serviciossolicitados(\"" . $pTipoConcepto . "\",'" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pCAS . "','" . $pConsecutivoHC . "')";
    //echo $qry;
    @mysqli_query("\"SET NAMES UTF8\"");
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = utf8_decode($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}

function GuardarMX(){
    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_observahospitaliza_mxadd(" . spParametros($estructura,"SI") . ")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function EliminarMX(){
    $pIdMx = isset($_REQUEST['pIdMx'])?$_REQUEST['pIdMx']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_observahospitaliza_delsolicitudes('" . $pIdMx . "')";
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo '1';
    else
        echo '0';
    $gBaseDatos->cerrar();
}

function GuardarEXA(){
    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_observahospitaliza_exaadd(" . spParametros($estructura,"SI") . ")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function GuardarEpicrisisHC(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    //$pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $pProfesional = $_SESSION['ID_PROFESIONAL_HC'];
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pidPlantillaHC = isset($_REQUEST['pidPlantillaHC'])?$_REQUEST['pidPlantillaHC']:0;
    $pFechaAtencion = isset($_REQUEST['pFechaAtencion'])?$_REQUEST['pFechaAtencion']:null;
    $pHoraApertura = isset($_REQUEST['pHoraApertura'])?$_REQUEST['pHoraApertura']:null;
    $pActividad = isset($_REQUEST['pActividad'])?$_REQUEST['pActividad']:null;
    $pPlantilla = isset($_REQUEST['pPlantilla'])?$_REQUEST['pPlantilla']:null;
    $pRutaRptHC = isset($_REQUEST['pRutaRptHC'])?$_REQUEST['pRutaRptHC']:null;
    $pRutaRptMx = isset($_REQUEST['pRutaRptMx'])?$_REQUEST['pRutaRptMx']:null;
    $pRutaRptExa = isset($_REQUEST['pRutaRptExa'])?$_REQUEST['pRutaRptExa']:null;
    $pRutaRptRem = isset($_REQUEST['pRutaRptRem'])?$_REQUEST['pRutaRptRem']:null;
    $pServicio = isset($_REQUEST['pServicio'])?$_REQUEST['pServicio']:null;
    $pTipoNota = isset($_REQUEST['pTipoNota'])?$_REQUEST['pTipoNota']:null;
    $pDiagppal = isset($_REQUEST['pDiagppal'])?$_REQUEST['pDiagppal']:null;
    $pDiagrel1 = isset($_REQUEST['pDiagrel1'])?$_REQUEST['pDiagrel1']:null;
    $pDiagrel2 = isset($_REQUEST['pDiagrel2'])?$_REQUEST['pDiagrel2']:null;
    $pDiagrel3 = isset($_REQUEST['pDiagrel3'])?$_REQUEST['pDiagrel3']:null;
    $pDiagComplica = isset($_REQUEST['pDiagComplica'])?$_REQUEST['pDiagComplica']:null;
    $pEstadoSalida = isset($_REQUEST['pEstadoSalida'])?$_REQUEST['pEstadoSalida']:null;
    $pDestinoSalida = isset($_REQUEST['pDestinoSalida'])?$_REQUEST['pDestinoSalida']:null;
    $pCausaMuerte = isset($_REQUEST['pCausaMuerte'])?$_REQUEST['pCausaMuerte']:null;
    $pFechaSalida = isset($_REQUEST['pFechaSalida'])?$_REQUEST['pFechaSalida']:null;
    $pHoraSalida = isset($_REQUEST['pHoraSalida'])?$_REQUEST['pHoraSalida']:null;
    $contenido = isset($_REQUEST['CAMPOS'])?$_REQUEST['CAMPOS']:null;
    $pEvolucion = stripslashes(utf8_encode(str_replace('"', '""',nl2br($contenido))));
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $pIdCliente = isset($_REQUEST['pIdCliente'])?$_REQUEST['pIdCliente']:0;
    $CodInsercion = "PRS-" .  $_SESSION['ID_EMPRESA'] . "-SED-" . $_SESSION['ID_SEDE'] .  "-IPS-" . $_SESSION['ID_IPS'] . "-USR-" . $_SESSION['ID_USUARIO'] . "-CAS-" . $pCAS . "-CONS-" . mt_rand(0,100000) . "-" . date("His");
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_observahospitaliza_epicrisis_add_evolucion2013('" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pProfesional . "','" . $pCAS . "','" . $pidPlantillaHC . "',\"" . $pFechaAtencion . "\",\"" . $pHoraApertura . "\",\"" . $pActividad . "\",\"" . $pPlantilla . "\",\"" . $pRutaRptHC . "\",\"" . $pRutaRptMx . "\",\"" . $pRutaRptExa . "\",\"" . $pRutaRptRem . "\",\"" . $pEvolucion . "\",'" . $pUsuario . "','" . $pIdCliente . "',\"" . $CodInsercion . "\",\"" . $pServicio . "\",\"" . $pTipoNota . "\",\"" . $pDiagppal . "\",\"" . $pDiagrel1 . "\",\"" . $pDiagrel2 . "\",\"" . $pDiagrel3 . "\",\"" . $pDiagComplica . "\",\"" . $pEstadoSalida . "\",\"" . $pDestinoSalida . "\",\"" . $pCausaMuerte . "\",\"" . $pFechaSalida . "\",\"" . $pHoraSalida . "\")";
    //echo $qry;
    $CampoLlave = explode("^",$gBaseDatos->jasonSP_arreglo2011($qry));
    $gBaseDatos->cerrar();   
    $ConsecutivoHC = $CampoLlave[0];
    if($ConsecutivoHC != 0)
        echo "{success: true, requestedId:'" . $ConsecutivoHC . "'}";
    else
       echo "{success: true, requestedId:'0'}";
}

function ModificarEpicrisisHC(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    //$pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $pProfesional = $_SESSION['ID_PROFESIONAL_HC'];
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pConsecutivoDetalle = isset($_REQUEST['pConsecutivoDetalle'])?$_REQUEST['pConsecutivoDetalle']:0;
    $pidPlantillaHC = isset($_REQUEST['pidPlantillaHC'])?$_REQUEST['pidPlantillaHC']:0;
    $pFechaAtencion = isset($_REQUEST['pFechaAtencion'])?$_REQUEST['pFechaAtencion']:null;
    $pHoraApertura = isset($_REQUEST['pHoraApertura'])?$_REQUEST['pHoraApertura']:null;
    $pActividad = isset($_REQUEST['pActividad'])?$_REQUEST['pActividad']:null;
    $pPlantilla = isset($_REQUEST['pPlantilla'])?$_REQUEST['pPlantilla']:null;
    $pRutaRptHC = isset($_REQUEST['pRutaRptHC'])?$_REQUEST['pRutaRptHC']:null;
    $pRutaRptMx = isset($_REQUEST['pRutaRptMx'])?$_REQUEST['pRutaRptMx']:null;
    $pRutaRptExa = isset($_REQUEST['pRutaRptExa'])?$_REQUEST['pRutaRptExa']:null;
    $pRutaRptRem = isset($_REQUEST['pRutaRptRem'])?$_REQUEST['pRutaRptRem']:null;
    $pServicio = isset($_REQUEST['pServicio'])?$_REQUEST['pServicio']:null;
    $pTipoNota = isset($_REQUEST['pTipoNota'])?$_REQUEST['pTipoNota']:null;
    $pDiagppal = isset($_REQUEST['pDiagppal'])?$_REQUEST['pDiagppal']:null;
    $pDiagrel1 = isset($_REQUEST['pDiagrel1'])?$_REQUEST['pDiagrel1']:null;
    $pDiagrel2 = isset($_REQUEST['pDiagrel2'])?$_REQUEST['pDiagrel2']:null;
    $pDiagrel3 = isset($_REQUEST['pDiagrel3'])?$_REQUEST['pDiagrel3']:null;
    $pDiagComplica = isset($_REQUEST['pDiagComplica'])?$_REQUEST['pDiagComplica']:null;
    $pEstadoSalida = isset($_REQUEST['pEstadoSalida'])?$_REQUEST['pEstadoSalida']:null;
    $pDestinoSalida = isset($_REQUEST['pDestinoSalida'])?$_REQUEST['pDestinoSalida']:null;
    $pCausaMuerte = isset($_REQUEST['pCausaMuerte'])?$_REQUEST['pCausaMuerte']:null;
    $pFechaSalida = isset($_REQUEST['pFechaSalida'])?$_REQUEST['pFechaSalida']:null;
    $pHoraSalida = isset($_REQUEST['pHoraSalida'])?$_REQUEST['pHoraSalida']:null;
    $contenido = isset($_REQUEST['CAMPOS'])?$_REQUEST['CAMPOS']:null;
    $pEvolucion = stripslashes(utf8_encode(str_replace('"', '""',nl2br($contenido))));
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $pIdCliente = isset($_REQUEST['pIdCliente'])?$_REQUEST['pIdCliente']:0;
    $CodInsercion = "PRS-" .  $_SESSION['ID_EMPRESA'] . "-SED-" . $_SESSION['ID_SEDE'] .  "-IPS-" . $_SESSION['ID_IPS'] . "-USR-" . $_SESSION['ID_USUARIO'] . "-CAS-" . $pCAS . "-CONS-" . mt_rand(0,100000) . "-" . date("His");
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_observahospitaliza_epicrisis_edit_evolucion2013('" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pProfesional . "','" . $pCAS . "','" . $pConsecutivoDetalle . "','" . $pidPlantillaHC . "',\"" . $pFechaAtencion . "\",\"" . $pHoraApertura . "\",\"" . $pActividad . "\",\"" . $pPlantilla . "\",\"" . $pRutaRptHC . "\",\"" . $pRutaRptMx . "\",\"" . $pRutaRptExa . "\",\"" . $pRutaRptRem . "\",\"" . $pEvolucion . "\",'" . $pUsuario . "','" . $pIdCliente . "',\"" . $CodInsercion . "\",\"" . $pServicio . "\",\"" . $pTipoNota . "\",\"" . $pDiagppal . "\",\"" . $pDiagrel1 . "\",\"" . $pDiagrel2 . "\",\"" . $pDiagrel3 . "\",\"" . $pDiagComplica . "\",\"" . $pEstadoSalida . "\",\"" . $pDestinoSalida . "\",\"" . $pCausaMuerte . "\",\"" . $pFechaSalida . "\",\"" . $pHoraSalida . "\")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}
?>