<?php

/*
* @category    Controlador Odontologia
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/
header("Content-Type: text/plain; charset=UTF-8");
require("../../../core/php/_database.php");
require("../../../core/php/php_functions.php");
session_start();

$task = '';
if ( isset($_POST['task'])){
  $task = $_POST['task'];
}
switch($task){
    case "VerDientesActividadesProximaCitaDetalle":
        VerDientesActividadesProximaCitaDetalle();
        break;
    case "VerDientesActividadesProximaCita":
        VerDientesActividadesProximaCita();
        break;
    case "VerDientesActividadesRealizadas":
        VerDientesActividadesRealizadas();
        break;
    case "VerNecesidadesAtencion":
        VerNecesidadesAtencion();
        break;
    case "GUARDAR_NECESIDAD_ATENCION":
        GuardarNecesidadAtencion();
        break;
    case "MODIFICAR_NECESIDAD_ATENCION":
        ModificarNecesidadAtencion();
        break;
    case "ELIMINAR_NECESIDAD_ATENCION":
        EliminarNecesidadAtencion();
        break;
    case "GUARDAR_DIENTE_PROXIMACITA":
        GuardarDienteActividadesProxCita();
        break;
    case "GUARDAR_DIENTE_ACTIVIDAD":
        GuardarDienteActividadesRealizadas();
        break;
    case "GUARDAR_DIENTE_ACTIVIDAD201401":
        GuardarDienteActividadesRealizadas201401();
        break;
    case "ELIMINAR_DIENTE_ACTIVIDAD":
        EliminarDienteActividadesRealizadas();
        break;
    case "ELIMINAR_DIENTE_PROXIMACITA":
        EliminarDienteActividadesProxCita();
        break;
    case "VerNecesidadesAtencionTratamiento":
        VerNecesidadesAtencionTratamiento();
        break;
    case "GUARDAR_DIENTE_NECESIDAD":
        GuardarDienteActividadesNecesidad();
        break;
    case "INDICECOPxPAC":
        CalcularCOPxPaciente();
        break;
    case "INDICECEOxPAC":
        CalcularCEOxPaciente();
        break;
    case "INDICEPLACAxDIAG":
        CalcularIndicePlaca();
        break;
    case "LISTAR_OTROSxLEGALIZAR":
        ListarCopagosxLegalizar();
        break;
    case "GENERAR_COPAGOSxLEGALIZAR":
        GenerarCopagosxLegalizar();
        break;
    case "GENERAR_MULTASxLEGALIZAR":
        GenerarMultasxLegalizar();
        break;
    case "HISTORIAL_OTROS_PAGOS":
        HistorialPagosRealizados();
        break;
    default:
        echo "{failure:true}";
        break;
}

function HistorialPagosRealizados(){
    $pIPS = isset($_REQUEST['pIPS']) ? $_REQUEST['pIPS']:0;
    $pPaciente = isset($_REQUEST['pPaciente']) ? $_REQUEST['pPaciente']:0;
    $pNomBaseDatos = isset($_REQUEST['pNomBaseDatos'])?$_REQUEST['pNomBaseDatos']:"NA";
    if($pNomBaseDatos == "NA"){
        $gBaseDatos = new ofiMySQLi();
    }else{
        $gBaseDatos = new ofiMySQLi($pNomBaseDatos);
    }
    $gBaseDatos->conectar();
    $qry = "CALL sp_otrospagos_legalizados('" . $pIPS . "','" . $pPaciente . "')";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = PonerAcentosHTML($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}

function ListarCopagosxLegalizar(){
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pNomBaseDatos = isset($_REQUEST['pNomBaseDatos'])?$_REQUEST['pNomBaseDatos']:"NA";
    if($pNomBaseDatos == "NA"){
        $gBaseDatos = new ofiMySQLi();
    }else{
        $gBaseDatos = new ofiMySQLi($pNomBaseDatos);
    }
    $gBaseDatos->conectar();
    $qry = "CALL sp_otrospagos_xlegalizar('" . $pIPS . "','" . $pPaciente . "')";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = PonerAcentosHTML($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';    
}

function GenerarMultasxLegalizar(){
    $pPaciente = isset($_REQUEST['pPaciente']) ? $_REQUEST['pPaciente']:0;
    $pUsuario = isset($_REQUEST['pUsuario']) ? $_REQUEST['pUsuario']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_otrospagos_generarmultas('" . $pPaciente . "','" . $_SESSION['ID_IPS'] . "','" . $pUsuario . "')";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo '1';
    else
        echo '0';
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
}

function GenerarCopagosxLegalizar(){
    $pPaciente = isset($_REQUEST['pPaciente']) ? $_REQUEST['pPaciente']:0;
    $pUsuario = isset($_REQUEST['pUsuario']) ? $_REQUEST['pUsuario']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_otrospagos_generarcop('" . $pPaciente . "','" . $pUsuario . "')";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo '1';
    else
        echo '0';
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
}

function CalcularIndicePlaca(){
    $gBaseDatos = new ofiMySQLi();
    $pDiagrama = isset($_REQUEST['pDiagrama']) ? $_REQUEST['pDiagrama']:0;
    $gBaseDatos->conectar();
    $qry = "CALL sp_odontologia_calcularindiceplaca('" . $pDiagrama . "')";
    //echo $qry;
    echo $gBaseDatos->jasonSP_arreglo2011($qry);
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
}

function CalcularCEOxPaciente(){
    $gBaseDatos = new ofiMySQLi();
    $pPaciente = isset($_REQUEST['pPaciente']) ? $_REQUEST['pPaciente']:0;
    $gBaseDatos->conectar();
    $qry = "CALL sp_odontologia_ceoxpaciente('" . $pPaciente . "')";
    echo $gBaseDatos->jasonSP_arreglo2011($qry);
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
}

function CalcularCOPxPaciente(){
    $gBaseDatos = new ofiMySQLi();
    $pPaciente = isset($_REQUEST['pPaciente']) ? $_REQUEST['pPaciente']:0;
    $gBaseDatos->conectar();
    $qry = "CALL sp_odontologia_copxpaciente('" . $pPaciente . "')";
    //echo $qry;
    echo $gBaseDatos->jasonSP_arreglo2011($qry);
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
}

function GuardarDienteActividadesNecesidad(){
    $estructura = explode("Â¬", $_REQUEST['CAMPOS']);
    $superficies = explode("-", strtoupper($_REQUEST['Superficies']));
    if(strtoupper($_REQUEST['Superficies'])=='N-N-N-N-N'){
        $gBaseDatos = new ofiMySQLi();
        $gBaseDatos->conectar();
        $qry = "CALL sp_asistencial_necesidadesatencion_tratamiento_insert(" . spParametros($estructura,"SI") . ",\"N\")";
        @mysqli_query($gBaseDatos->ConexionID, $qry);
        $gBaseDatos->cerrar();
    }else{
        $pRegistros = count($superficies);
        for($i=0;$i<$pRegistros;$i++)
        {
            if($superficies[$i] != "N"){
                $gBaseDatos = new ofiMySQLi();
                $gBaseDatos->conectar();
                $qry = "CALL sp_asistencial_necesidadesatencion_tratamiento_insert(" . spParametros($estructura,"SI") . ",\"" . $superficies[$i] . "\")";
                //echo $qry;
                @mysqli_query($gBaseDatos->ConexionID, $qry);
                $gBaseDatos->cerrar();
            }
        }
    }
    echo "{success: true, requestedId:'1'}";
}

function VerNecesidadesAtencionTratamiento(){
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pIdConsecutivoNecesidad = isset($_REQUEST['pIdConsecutivoNecesidad'])?$_REQUEST['pIdConsecutivoNecesidad']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_necesidadesatencion_tratamiento_listar('" . $pPaciente . "','" . $pIdConsecutivoNecesidad . "')";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = utf8_decode(str_replace("\n\n", "\n",preg_replace('/\<br(\s*)?\/?\>/i', "\n",$val)));
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}

function VerDientesActividadesProximaCitaDetalle(){
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_odontologia_actividades_proxcita_detalle_listar('" . $pPaciente . "','" . $pCAS . "')";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = utf8_decode(str_replace("\n\n", "\n",preg_replace('/\<br(\s*)?\/?\>/i', "\n",$val)));
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}

function VerDientesActividadesProximaCita(){
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_odontologia_actividades_proxcita_listar('" . $pPaciente . "')";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = utf8_decode(str_replace("\n\n", "\n",preg_replace('/\<br(\s*)?\/?\>/i', "\n",$val)));
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}

function VerDientesActividadesRealizadas(){
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_odontologia_dientes_actividades_listar('" . $pPaciente . "')";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = utf8_decode(str_replace("\n\n", "\n",preg_replace('/\<br(\s*)?\/?\>/i', "\n",$val)));
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}

function VerNecesidadesAtencion(){
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_odontologia_neseatencion_list('" . $pCAS . "')";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = utf8_decode(str_replace("\n\n", "\n",preg_replace('/\<br(\s*)?\/?\>/i', "\n",$val)));
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';    
}

function EliminarNecesidadAtencion(){
    $pConsecutivo = isset($_REQUEST['pIdRegistroNecesidad'])?$_REQUEST['pIdRegistroNecesidad']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_odontologia_neseatencion_delete('" . $pConsecutivo . "')";
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo '1';
    else
        echo '0';
    $gBaseDatos->cerrar();
}

function ModificarNecesidadAtencion(){
    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $pIdConsecutivoNecesidad = isset($_REQUEST['pIdConsecutivoNecesidad'])?$_REQUEST['pIdConsecutivoNecesidad']:10;
    
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_odontologia_neseatencion_udpadte('" . $pIdConsecutivoNecesidad . "'," . spParametros($estructura,"SI") . ")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry)){
        echo "{success: true, requestedId:'1'}";
    }else{
        echo "{success: true, requestedId:'0'}";
    }
    $gBaseDatos->cerrar();
}

function GuardarNecesidadAtencion(){
    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_odontologia_neseatencion_insert(" . spParametros($estructura,"SI") . ")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry)){
        echo "{success: true, requestedId:'1'}";
    }else{
        echo "{success: true, requestedId:'0'}";
    }
    $gBaseDatos->cerrar();
}

function EliminarDienteActividadesRealizadas(){
    $pIdRegistroActividadDiente = isset($_REQUEST['pIdRegistroActividadDiente'])?$_REQUEST['pIdRegistroActividadDiente']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_odontologia_dientesactividad_delete('" . $pIdRegistroActividadDiente . "')";
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo '1';
    else
        echo '0';
    $gBaseDatos->cerrar();
}

function EliminarDienteActividadesProxCita(){
    $pIdRegistroActividadDiente = isset($_REQUEST['pIdRegistroActividadDiente'])?$_REQUEST['pIdRegistroActividadDiente']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_odontologia_dientesactividadproxcita_delete('" . $pIdRegistroActividadDiente . "')";
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo '1';
    else
        echo '0';
    $gBaseDatos->cerrar();
}

function GuardarDienteActividadesProxCita(){
    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_odontologia_dientesactividadproxcita_insert(" . spParametros($estructura,"SI") . ")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry)){
        echo "{success: true, requestedId:'1'}";
    }else{
        echo "{success: true, requestedId:'0'}";
    }
    $gBaseDatos->cerrar();
}

function GuardarDienteActividadesRealizadas(){
    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $superficies = explode("-", strtoupper($_REQUEST['Superficies']));
    if(strtoupper($_REQUEST['Superficies'])=='N-N-N-N-N'){
        $gBaseDatos = new ofiMySQLi();
        $gBaseDatos->conectar();
        $qry = "CALL sp_asistencial_odontologia_dientesactividad_insert(" . spParametros($estructura,"SI") . ",\"N\")";
        @mysqli_query($gBaseDatos->ConexionID, $qry);
        $gBaseDatos->cerrar();
    }else{
        $pRegistros = count($superficies);
        for($i=0;$i<$pRegistros;$i++)
        {
            if($superficies[$i] != "N"){
                $gBaseDatos = new ofiMySQLi();
                $gBaseDatos->conectar();
                $qry = "CALL sp_asistencial_odontologia_dientesactividad_insert(" . spParametros($estructura,"SI") . ",\"" . $superficies[$i] . "\")";
                //echo $qry;
                @mysqli_query($gBaseDatos->ConexionID, $qry);
                $gBaseDatos->cerrar();
            }
        }
    }
    echo "{success: true, requestedId:'1'}";
}

function GuardarDienteActividadesRealizadas201401(){
    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $superficies = explode("-", strtoupper($_REQUEST['Superficies']));
    if(strtoupper($_REQUEST['Superficies'])=='N-N-N-N-N'){
        $gBaseDatos = new ofiMySQLi();
        $gBaseDatos->conectar();
        $qry = "CALL sp_asistencial_odontologia_dientesactividad201401_insert(" . spParametros($estructura,"SI") . ",\"N\")";
        @mysqli_query($gBaseDatos->ConexionID, $qry);
        $gBaseDatos->cerrar();
    }else{
        $pRegistros = count($superficies);
        for($i=0;$i<$pRegistros;$i++)
        {
            if($superficies[$i] != "N"){
                $gBaseDatos = new ofiMySQLi();
                $gBaseDatos->conectar();
                $qry = "CALL sp_asistencial_odontologia_dientesactividad201401_insert(" . spParametros($estructura,"SI") . ",\"" . $superficies[$i] . "\")";
                //echo $qry;
                @mysqli_query($gBaseDatos->ConexionID, $qry);
                $gBaseDatos->cerrar();
            }
        }
    }
    echo "{success: true, requestedId:'1'}";
}

?>