<?php

function FormatoOdontograma001(&$pdf, &$pProfesional, &$pNomProfesional, &$pnomEspecialidad, &$pRegistroProfesional, &$pImprimeFirmas, $pPrestador, $pIPS, $pPaciente, $pConsecutivoHC, $pNomAplicacion, $IdContador, $pCAS=0){ //Formato General de Impresion de Historia Clinica
    if($pConsecutivoHC != null || $pConsecutivoHC != ""){
        $pControlSalto = 30;
        unset($rowHC);
        $gBaseDatos = new ofiMySQLi();
        $gBaseDatos->conectar();
        $qry = "CALL sp_asistencial_printhc('" . $pPrestador . "','" . $pIPS . "','" . $pPaciente . "','" . $pConsecutivoHC . "')";
        $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
        while ($rowHC[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        $pRegistros = count($rowHC);
        $pdf->SetFont('dejavusans', '', 14, '', true);
        for($i=0;$i<$pRegistros;$i++){
            if($rowHC[$i]["nomPaciente"] != ""){
                $idPaciente = $rowHC[$i]["nomPaciente"];
                //Odontograma
                EncabezadoPaginaOdontograma($pdf, $rowHC, $i, $rowcount, $contador, $pDesde, $pHasta, $pNomAplicacion);
                $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
                //$pPaciente = 15;
                //Pinta D18
                $pdf->Cell(5, 5, 'D18           D17           D16           D15           D14           D13           D12           D11               D21           D22           D23           D24           D25           D26           D27           D28', 0, 0, 'L', 0, '', 0);
                $pdf->Image('../../../resources/odontograma/diente.png', 5, 48, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                MostrarOdontograma($pdf,18,$pPaciente,utf8_decode($rowHC[$i]["Fecha"]),5,48);
                
                //Pinta D17
                $pdf->Image('../../../resources/odontograma/diente.png', 17, 48, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                MostrarOdontograma($pdf,17,$pPaciente,utf8_decode($rowHC[$i]["Fecha"]),17,48);
                //Pinta D16
                $pdf->Image('../../../resources/odontograma/diente.png', 29, 48, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                MostrarOdontograma($pdf,16,$pPaciente,utf8_decode($rowHC[$i]["Fecha"]),29,48);
                //Pinta D15
                $pdf->Image('../../../resources/odontograma/diente.png', 41, 48, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                MostrarOdontograma($pdf,15,$pPaciente,utf8_decode($rowHC[$i]["Fecha"]),41,48);
                //Pinta D14
                $pdf->Image('../../../resources/odontograma/diente.png', 53, 48, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                MostrarOdontograma($pdf,14,$pPaciente,utf8_decode($rowHC[$i]["Fecha"]),53,48);
                //Pinta D13
                $pdf->Image('../../../resources/odontograma/diente.png', 65, 48, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                MostrarOdontograma($pdf,13,$pPaciente,utf8_decode($rowHC[$i]["Fecha"]),65,48);
                //Pinta D12
                $pdf->Image('../../../resources/odontograma/diente.png', 77, 48, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                MostrarOdontograma($pdf,12,$pPaciente,utf8_decode($rowHC[$i]["Fecha"]),77,48);
                //Pinta D11
                $pdf->Image('../../../resources/odontograma/diente.png', 89, 48, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                MostrarOdontograma($pdf,11,$pPaciente,utf8_decode($rowHC[$i]["Fecha"]),89,48);
                //Pinta D21
                $pdf->Image('../../../resources/odontograma/diente.png', 105, 48, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                MostrarOdontograma($pdf,21,$pPaciente,utf8_decode($rowHC[$i]["Fecha"]),105,48);
                //Pinta D22
                $pdf->Image('../../../resources/odontograma/diente.png', 117, 48, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                MostrarOdontograma($pdf,22,$pPaciente,utf8_decode($rowHC[$i]["Fecha"]),117,48);
                //Pinta D23
                $pdf->Image('../../../resources/odontograma/diente.png', 129, 48, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                MostrarOdontograma($pdf,23,$pPaciente,utf8_decode($rowHC[$i]["Fecha"]),129,48);
                //Pinta D24
                $pdf->Image('../../../resources/odontograma/diente.png', 141, 48, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                MostrarOdontograma($pdf,24,$pPaciente,utf8_decode($rowHC[$i]["Fecha"]),141,48);
                //Pinta D25
                $pdf->Image('../../../resources/odontograma/diente.png', 153, 48, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);  
                MostrarOdontograma($pdf,25,$pPaciente,utf8_decode($rowHC[$i]["Fecha"]),153,48);
                //Pinta D26
                $pdf->Image('../../../resources/odontograma/diente.png', 165, 48, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                MostrarOdontograma($pdf,26,$pPaciente,utf8_decode($rowHC[$i]["Fecha"]),165,48);
                //Pinta D27
                $pdf->Image('../../../resources/odontograma/diente.png', 177, 48, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                MostrarOdontograma($pdf,27,$pPaciente,utf8_decode($rowHC[$i]["Fecha"]),177,48);
                //Pinta D28
                $pdf->Image('../../../resources/odontograma/diente.png', 189, 48, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                MostrarOdontograma($pdf,28,$pPaciente,utf8_decode($rowHC[$i]["Fecha"]),189,48);
                ////////////////////////////////////////////////////////////////////////////
                //Pinta D88
                $pdf->Ln(23);
                $pdf->Cell(5, 5, '                                                    D55           D54           D53           D52           D51               D61           D62           D63           D64           D65                                          ', 0, 0, 'L', 0, '', 0);
                $pdf->Image('../../../resources/odontograma/vacio.png', 5, 71, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                //Pinta D57
                $pdf->Image('../../../resources/odontograma/vacio.png', 17, 71, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                //Pinta D56
                $pdf->Image('../../../resources/odontograma/vacio.png', 29, 71, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                //Pinta D55
                $pdf->Image('../../../resources/odontograma/diente.png', 41, 71, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                MostrarOdontograma($pdf,55,$pPaciente,utf8_decode($rowHC[$i]["Fecha"]),41,71);
                //Pinta D54
                $pdf->Image('../../../resources/odontograma/diente.png', 53, 71, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                MostrarOdontograma($pdf,54,$pPaciente,utf8_decode($rowHC[$i]["Fecha"]),53,71);
                //Pinta D53
                $pdf->Image('../../../resources/odontograma/diente.png', 65, 71, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                MostrarOdontograma($pdf,53,$pPaciente,utf8_decode($rowHC[$i]["Fecha"]),65,71);
                //Pinta D52
                $pdf->Image('../../../resources/odontograma/diente.png', 77, 71, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                MostrarOdontograma($pdf,52,$pPaciente,utf8_decode($rowHC[$i]["Fecha"]),77,71);
                //Pinta D51
                $pdf->Image('../../../resources/odontograma/diente.png', 89, 71, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                MostrarOdontograma($pdf,51,$pPaciente,utf8_decode($rowHC[$i]["Fecha"]),89,71);
                //Pinta D61
                $pdf->Image('../../../resources/odontograma/diente.png', 105, 71, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                MostrarOdontograma($pdf,61,$pPaciente,utf8_decode($rowHC[$i]["Fecha"]),105,71);
                //Pinta D62
                $pdf->Image('../../../resources/odontograma/diente.png', 117, 71, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                MostrarOdontograma($pdf,62,$pPaciente,utf8_decode($rowHC[$i]["Fecha"]),117,71);
                //Pinta D63
                $pdf->Image('../../../resources/odontograma/diente.png', 129, 71, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                MostrarOdontograma($pdf,63,$pPaciente,utf8_decode($rowHC[$i]["Fecha"]),129,71);
                //Pinta D64
                $pdf->Image('../../../resources/odontograma/diente.png', 141, 71, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                MostrarOdontograma($pdf,64,$pPaciente,utf8_decode($rowHC[$i]["Fecha"]),141,71);
                //Pinta D65
                $pdf->Image('../../../resources/odontograma/diente.png', 153, 71, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                MostrarOdontograma($pdf,65,$pPaciente,utf8_decode($rowHC[$i]["Fecha"]),153,71);
                //Pinta D66
                $pdf->Image('../../../resources/odontograma/vacio.png', 165, 71, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                //Pinta D67
                $pdf->Image('../../../resources/odontograma/vacio.png', 177, 71, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                //Pinta D68
                $pdf->Image('../../../resources/odontograma/vacio.png', 189, 71, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                ////////////////////////////////////////////////////////////////////////////
                //Pinta D88
                $pdf->Ln(23);
                $pdf->Cell(5, 5, '                                                    D85           D84           D83           D82           D81               D71           D72           D73           D74           D75                                          ', 0, 0, 'L', 0, '', 0);
                $pdf->Image('../../../resources/odontograma/vacio.png', 5, 94, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                //Pinta D87
                $pdf->Image('../../../resources/odontograma/vacio.png', 17, 94, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                //Pinta D86
                $pdf->Image('../../../resources/odontograma/vacio.png', 29, 94, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                //Pinta D85
                $pdf->Image('../../../resources/odontograma/diente.png', 41, 94, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                MostrarOdontograma($pdf,85,$pPaciente,utf8_decode($rowHC[$i]["Fecha"]),41,94);
                //Pinta D84
                $pdf->Image('../../../resources/odontograma/diente.png', 53, 94, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                MostrarOdontograma($pdf,84,$pPaciente,utf8_decode($rowHC[$i]["Fecha"]),53,94);
                //Pinta D83
                $pdf->Image('../../../resources/odontograma/diente.png', 65, 94, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                MostrarOdontograma($pdf,83,$pPaciente,utf8_decode($rowHC[$i]["Fecha"]),65,94);
                //Pinta D82
                $pdf->Image('../../../resources/odontograma/diente.png', 77, 94, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                MostrarOdontograma($pdf,82,$pPaciente,utf8_decode($rowHC[$i]["Fecha"]),77,94);
                //Pinta D81
                $pdf->Image('../../../resources/odontograma/diente.png', 89, 94, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                MostrarOdontograma($pdf,81,$pPaciente,utf8_decode($rowHC[$i]["Fecha"]),89,94);
                //Pinta D71
                $pdf->Image('../../../resources/odontograma/diente.png', 105, 94, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                MostrarOdontograma($pdf,71,$pPaciente,utf8_decode($rowHC[$i]["Fecha"]),105,94);
                //Pinta D72
                $pdf->Image('../../../resources/odontograma/diente.png', 117, 94, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                MostrarOdontograma($pdf,72,$pPaciente,utf8_decode($rowHC[$i]["Fecha"]),117,94);
                //Pinta D73
                $pdf->Image('../../../resources/odontograma/diente.png', 129, 94, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                MostrarOdontograma($pdf,73,$pPaciente,utf8_decode($rowHC[$i]["Fecha"]),129,94);
                //Pinta D74
                $pdf->Image('../../../resources/odontograma/diente.png', 141, 94, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                MostrarOdontograma($pdf,74,$pPaciente,utf8_decode($rowHC[$i]["Fecha"]),141,94);
                //Pinta D75
                $pdf->Image('../../../resources/odontograma/diente.png', 153, 94, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                MostrarOdontograma($pdf,75,$pPaciente,utf8_decode($rowHC[$i]["Fecha"]),153,94);
                //Pinta D76
                $pdf->Image('../../../resources/odontograma/vacio.png', 165, 94, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                //Pinta D77
                $pdf->Image('../../../resources/odontograma/vacio.png', 177, 94, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                //Pinta D78
                $pdf->Image('../../../resources/odontograma/vacio.png', 189, 94, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                ////////////////////////////////////////////////////////////////////////////
                $pdf->Ln(23);
                //Pinta D48
                $pdf->Cell(5, 5, 'D48           D47           D46           D45           D44           D43           D42           D41               D31           D32           D33           D34           D35           D36           D37           D38', 0, 0, 'L', 0, '', 0);
                $pdf->Image('../../../resources/odontograma/diente.png', 5, 117, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                MostrarOdontograma($pdf,48,$pPaciente,utf8_decode($rowHC[$i]["Fecha"]),5,117);
                //Pinta D47
                $pdf->Image('../../../resources/odontograma/diente.png', 17, 117, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                MostrarOdontograma($pdf,47,$pPaciente,utf8_decode($rowHC[$i]["Fecha"]),17,117);
                //Pinta D46
                $pdf->Image('../../../resources/odontograma/diente.png', 29, 117, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                MostrarOdontograma($pdf,46,$pPaciente,utf8_decode($rowHC[$i]["Fecha"]),29,117);
                //Pinta D45
                $pdf->Image('../../../resources/odontograma/diente.png', 41, 117, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                MostrarOdontograma($pdf,45,$pPaciente,utf8_decode($rowHC[$i]["Fecha"]),41,117);
                //Pinta D44
                $pdf->Image('../../../resources/odontograma/diente.png', 53, 117, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                MostrarOdontograma($pdf,44,$pPaciente,utf8_decode($rowHC[$i]["Fecha"]),53,117);
                //Pinta D43
                $pdf->Image('../../../resources/odontograma/diente.png', 65, 117, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                MostrarOdontograma($pdf,43,$pPaciente,utf8_decode($rowHC[$i]["Fecha"]),65,117);
                //Pinta D42
                $pdf->Image('../../../resources/odontograma/diente.png', 77, 117, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                MostrarOdontograma($pdf,42,$pPaciente,utf8_decode($rowHC[$i]["Fecha"]),77,117);
                //Pinta D41
                $pdf->Image('../../../resources/odontograma/diente.png', 89, 117, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                MostrarOdontograma($pdf,41,$pPaciente,utf8_decode($rowHC[$i]["Fecha"]),89,117);
                //Pinta D31
                $pdf->Image('../../../resources/odontograma/diente.png', 105, 117, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                MostrarOdontograma($pdf,31,$pPaciente,utf8_decode($rowHC[$i]["Fecha"]),105,117);
                //Pinta D32
                $pdf->Image('../../../resources/odontograma/diente.png', 117, 117, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                MostrarOdontograma($pdf,32,$pPaciente,utf8_decode($rowHC[$i]["Fecha"]),117,117);
                //Pinta D33
                $pdf->Image('../../../resources/odontograma/diente.png', 129, 117, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                MostrarOdontograma($pdf,33,$pPaciente,utf8_decode($rowHC[$i]["Fecha"]),129,117);
                //Pinta D34
                $pdf->Image('../../../resources/odontograma/diente.png', 141, 117, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                MostrarOdontograma($pdf,34,$pPaciente,utf8_decode($rowHC[$i]["Fecha"]),141,117);
                //Pinta D35
                $pdf->Image('../../../resources/odontograma/diente.png', 153, 117, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                MostrarOdontograma($pdf,35,$pPaciente,utf8_decode($rowHC[$i]["Fecha"]),153,117);
                //Pinta D36
                $pdf->Image('../../../resources/odontograma/diente.png', 165, 117, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                MostrarOdontograma($pdf,36,$pPaciente,utf8_decode($rowHC[$i]["Fecha"]),165,117);
                //Pinta D37
                $pdf->Image('../../../resources/odontograma/diente.png', 177, 117, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                MostrarOdontograma($pdf,37,$pPaciente,utf8_decode($rowHC[$i]["Fecha"]),177,117);
                //Pinta D38
                $pdf->Image('../../../resources/odontograma/diente.png', 189, 117, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                MostrarOdontograma($pdf,38,$pPaciente,utf8_decode($rowHC[$i]["Fecha"]),189,117);
            }
        }
        
    }
}

function EncabezadoPaginaOdontograma(&$pdf, &$rowHC, &$i, &$rowcount, &$contador, &$pDesde, &$pHasta, $pNomAplicacion){
    $Alineacion = "P";
    $FormatoPagina = "CARTA";
    if($rowHC[$i]["DireccionIPS"] != "" && $rowHC[$i]["DireccionIPS"] != null){
        $pdf->pDirEmpresa = $rowHC[$i]["DireccionIPS"] . "<br>";
    }
    if($rowHC[$i]["TelefonoIPS"] != "" && $rowHC[$i]["TelefonoIPS"] != null){
        $pdf->pTelEmpresa = $rowHC[$i]["TelefonoIPS"];
    }
    if($rowHC[$i]["DescMunicipioIPS"] != "" && $rowHC[$i]["DescMunicipioIPS"] != null){
        $pdf->pCiuEmpresa = $rowHC[$i]["DescMunicipioIPS"] . " - " . $rowHC[$i]["DescDeptoIPS"];
    }
    $pdf->AddPage($Alineacion,$FormatoPagina);
    $pdf->Ln(8);
    $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
    $EncabezadoHTML = '<table cellspacing="0" border="0" style="font-size:24px; color:#000;">';
    $EncabezadoHTML .= '<tr>';
    $EncabezadoHTML .= '<td>';
    $EncabezadoHTML .= '<span style="font-size:44px; color:#000; font-weight:bold">' . utf8_decode($pdf->pNomEmpresa) . '</span><br>';
    if($pdf->pEspEmpresa != null || $pdf->pEspEmpresa != "")
            $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . utf8_decode($pdf->pEspEmpresa) . '</span><br>';
    if($pdf->pTDocEmpresa == "NI"){
        $tipodoc = "NIT: ";
        $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $tipodoc . $pdf->pDocEmpresa . '</span><br>';
    }
    $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $pdf->pDirEmpresa . ' - ' . $pdf->pTelEmpresa . '</span><br>';
    $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $pdf->pCiuEmpresa . '</span><br><br>';
    $EncabezadoHTML .= '<span style="font-size:29px; color:#000;"><b>PACIENTE:&nbsp;&nbsp;</b>' . utf8_decode($rowHC[$i]["TipDoc"]) . ' ' . utf8_decode($rowHC[$i]["Documento"]) . ' - ' . utf8_decode($rowHC[$i]["Nom1"]) . ' ' . utf8_decode($rowHC[$i]["Nom2"]) . ' ' . utf8_decode($rowHC[$i]["Ape1"]) . ' ' . utf8_decode($rowHC[$i]["Ape2"]) . '</span><br>';
    if (utf8_decode($rowHC[$i]["Genero"]) == "M")
        $EncabezadoHTML .= '<span style="font-size:29px; color:#000;"><b>GENERO:&nbsp;&nbsp;</b>MASCULINO</span><br>';
    else
        $EncabezadoHTML .= '<span style="font-size:29px; color:#000;"><b>GENERO:&nbsp;&nbsp;</b>FEMENINO</span><br>';
    $EncabezadoHTML .= '<span style="font-size:29px; color:#000;"><b>FECHA NACIMIENTO:&nbsp;&nbsp;</b>' . $rowHC[$i]["FecNac"];
    $EdadCompleta = "";
	
    $EdadCompleta = CalcularEdadComleta( $rowHC[$i]["FecNac"],  $rowHC[$i]["Fecha"]);
    if($EdadCompleta != "" && $EdadCompleta != null){
        if((int)substr($rowHC[$i]["FecNac"], 0, 4) > 1900){
            $EncabezadoHTML .= ' - Edad: ' . $EdadCompleta;
        }
    }
    $EncabezadoHTML .= '</span>';
    $EncabezadoHTML .= '</td>';

    //COL2
    $EncabezadoHTML .= '<td align="right">';
    if($pNomAplicacion == "OfiMedical"){
        if (file_exists("../../../consultoriovirtual/" . $_SESSION['IDBD'] . "/logo/logoenc.gif")) {
            $EncabezadoHTML .= '<img src="../../../consultoriovirtual/' . $_SESSION['IDBD'] . '/logo/logoenc.gif" align="right"/>';
            $EncabezadoHTML .= '<br>';
        }else{
            if (file_exists("../../../../consultoriovirtual/" . $_SESSION['IDBD'] . "/logo/logoenc.gif")) {
                $EncabezadoHTML .= '<img src="../../../../consultoriovirtual/' . $_SESSION['IDBD'] . '/logo/logoenc.gif" align="right"/>';
                $EncabezadoHTML .= '<br>';
            }
        }
    }else{
        if (file_exists("../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/logoenc.gif")) {
            $EncabezadoHTML .= '<img src="../../../empresas/' . $_SESSION['ID_EMPRESA'] . '/logo/logoenc.gif" align="right"/>';
            $EncabezadoHTML .= '<br>';
        }else{
            if (file_exists("../../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/logoenc.gif")) {
                $EncabezadoHTML .= '<img src="../../../../empresas/' . $_SESSION['ID_EMPRESA'] . '/logo/logoenc.gif" align="right"/>';
                $EncabezadoHTML .= '<br>';
            }
        }

    }
    $EncabezadoHTML .= '<span align="rigth" style="font-size:44px; color:#000; font-weight:bold">ODONTOGRAMA</span><br>';
    if (file_exists('../../../consultoriovirtual/' . $_SESSION['IDBD']  . '/pacientes/' . $rowHC[$i]["Paciente"] . '/uploads/foto.jpg')) {
        $EncabezadoHTML .= '<br><img src="../../../consultoriovirtual/' . $_SESSION['IDBD']  . '/pacientes/' . $rowHC[$i]["Paciente"] . '/uploads/foto.jpg" width="130" height="100"/><br>';
    }else{
        if (file_exists('../../../empresas/' . $_SESSION['ID_EMPRESA']  . '/pacientes/' . $rowHC[$i]["Paciente"] . '/uploads/foto.jpg')) {
            $EncabezadoHTML .= '<br><img src="../../../empresas/' . $_SESSION['ID_EMPRESA']  . '/pacientes/' . $rowHC[$i]["Paciente"] . '/uploads/foto.jpg" width="130" height="100"/><br>';
        }
    }
    $EncabezadoHTML .= '<span align="rigth" style="font-size:26px; color:#000; font-weight:bold">Copia Controlada</span>';
    $EncabezadoHTML .= '</td>';
    $EncabezadoHTML .= '</tr>';
    $EncabezadoHTML .= '</table>';
    $EncabezadoHTML .= '<hr class="linea">';
    $pdf->writeHTML($EncabezadoHTML, true, false, false, false, '');
}

function MostrarOdontograma(&$pdf, $pDiente, $pPaciente, $pHasta, $pX, $pY){
    unset($rowOdontograma);
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_odontograma_hisdxdiente('" . $pPaciente . "','" . $pDiente . "',\"0000-00-00\")";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    while ($rowOdontograma[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $pRegistros = count($rowOdontograma);
    $COP_C = 0;
    $DxCavidadTxt = "";
    $YaClasifico = 0;
    $htmlDiente = "";
    for ($j=0; $j<$pRegistros; $j++){ 
        switch($rowOdontograma[$j]["Diagnostico"]){
            case "DX_DIENTE_SANO":
                $pdf->Image('../../../resources/odontograma/diente_sano.png', $pX, $pY, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                break;
            case "DX_DIENTE_EXTRAIDOCARIES":
                $pdf->Image('../../../resources/odontograma/diente_extraidocaries.png', $pX, $pY, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                break;
            case "DX_DIENTE_EXTRAIDOOTRA":
                $pdf->Image('../../../resources/odontograma/diente_extraidootra.png', $pX, $pY, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                break;
            case "DX_DIENTE_EXTRAIDOORTO":
                $pdf->Image('../../../resources/odontograma/diente_extraidoortodoncia.png', $pX, $pY, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                break;
            case "DX_DIENTE_SINERUPCIONAR":
                $pdf->Image('../../../resources/odontograma/dienteausente.png', $pX, $pY, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                break;
            case "DX_DIENTE_TRAUMA":
                $pdf->Image('../../../resources/odontograma/diente_trauma.png', $pX, $pY, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                break;
            case "DX_DIENTE_EXOINDICACARIES":
                $pdf->Image('../../../resources/odontograma/diente_exodonciaindicadcaries.png', $pX, $pY, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                break;
            case "DX_DIENTE_EXOINDICAOTRAS":
                $pdf->Image('../../../resources/odontograma/diente_exodonciaindicadotros.png', $pX, $pY, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                break;
            case "DX_DIENTE_ZONADESDENTADA":
                $pdf->Image('../../../resources/odontograma/diente_zonadesremplza.png', $pX, $pY, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                break;
            case "DX_DIENTE_PONTICO":
                $pdf->Image('../../../resources/odontograma/diente_pontico.png', $pX, $pY, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                break;
            case "DX_DIENTE_NUCLEO":
                $pdf->Image('../../../resources/odontograma/diente_nucleo.png', $pX, $pY, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                break;
            case "DX_DIENTE_IMPLANTE":
                $pdf->Image('../../../resources/odontograma/diente_implante.png', $pX, $pY, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                break;
            case "DX_DIENTE_ENDOBUENA":
                $pdf->Image('../../../resources/odontograma/diente_endoconciabuena.png', $pX, $pY, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                break;
            case "DX_DIENTE_ENDOINDICADA":
                $pdf->Image('../../../resources/odontograma/diente_endoconciaindicada.png', $pX, $pY, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                break;
            case "DX_DIENTE_SELLANTEBOCA":
                $pdf->Image('../../../resources/odontograma/cavidad_cen_sellanteboca.png', $pX, $pY, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                break;
            case "DX_DIENTE_SELLANTEINDICADO":
                $pdf->Image('../../../resources/odontograma/cavidad_cen_sellanteindicado.png', $pX, $pY, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                break;
            case "DX_DIENTE_PROVICIONAL":
                $pdf->Image('../../../resources/odontograma/diente_provisional.png', $pX, $pY, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                break;
            case "DX_DIENTE_PROVICIONALMAL":
                $pdf->Image('../../../resources/odontograma/diente_provisionalmal.png', $pX, $pY, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                break;
            case "DX_DIENTE_OBTURAMETALICA":
                $pdf->Image('../../../resources/odontograma/diente_obturametalica.png', $pX, $pY, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                break;
            case "DX_DIENTE_OBTURAPORCELANA":
                $pdf->Image('../../../resources/odontograma/diente_obturaporcelana.png', $pX, $pY, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                break;
            case "DX_DIENTE_ABRASION":
                $pdf->Image('../../../resources/odontograma/diente_abracion.png', $pX, $pY, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                break;
            case "DX_DIENTE_ROTACIONES":
                $pdf->Image('../../../resources/odontograma/diente_rotaciones.png', $pX, $pY, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                break;
            case "DX_CAVIDAD_SELLANTECARIESSECUNDARIA":
                $pdf->Image('../../../resources/odontograma/cavidad_cen_sellanteindicadocariessec.png', $pX, $pY, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                break;
            case "DX_CAVIDAD_SELLANTEDEFECTUOSO":
                $pdf->Image('../../../resources/odontograma/cavidad_cen_sellanteindicadodefecto.png', $pX, $pY, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                break;
            default:
                $DxCavidad = $rowOdontograma[$j]["Diagnostico"];
                $DxCavidadTxt = "";
                $Seguir = 0;
                switch ($DxCavidad){
                    case "DX_CAVIDAD_CARIES":
                        $DxCavidadTxt = "cavidad_posicion_dxcaries.png";
                        $Seguir = 1;
                        break;
                    case "DX_CAVIDAD_CARIES3":
                        $DxCavidadTxt = "cavidad_posicion_dxcaries3.png";
                        $Seguir = 1;
                        break;
                    case "DX_CAVIDAD_CARIES4":
                        $DxCavidadTxt = "cavidad_posicion_dxcaries4.png";
                        $Seguir = 1;
                        break;
                    case "DX_CAVIDAD_CARIES5":
                        $DxCavidadTxt = "cavidad_posicion_dxcaries5.png";
                        $Seguir = 1;
                        break;
                    case "DX_CAVIDAD_CARIES6":
                        $DxCavidadTxt = "cavidad_posicion_dxcaries6.png";
                        $Seguir = 1;
                        break;
                    case "DX_CAVIDAD_CARIESINSIPIENTE":
                        $DxCavidadTxt = "cavidad_posicion_dxcariesins.png";
                        $Seguir = 1;
                        break;
                    case "DX_CAVIDAD_CARIESINSIPIENTE1":
                        $DxCavidadTxt = "cavidad_posicion_dxcariesins1.png";
                        $Seguir = 1;
                        break;
                    case "DX_CAVIDAD_CARIESINSIPIENTE2":
                        $DxCavidadTxt = "cavidad_posicion_dxcariesins2.png";
                        $Seguir = 1;
                        break;
                    case "DX_CAVIDAD_CAVIDADVACIASINCARIES":
                        $DxCavidadTxt = "cavidad_posicion_dxvaciasincaries.png";
                        $Seguir = 1;
                        break;
                    case "DX_CAVIDAD_IONOMEROORESINA":
                        $DxCavidadTxt = "cavidad_posicion_dxionomero.png";
                        $Seguir = 1;
                        break;
                    case "DX_CAVIDAD_IONOMEROORESINACONDEFECTO":
                        $DxCavidadTxt = "cavidad_posicion_dxionomerodefecto.png";
                        //$DxCavidadTxt = "cavidad_posicion_dxionomerocariessec.png";
                        $Seguir = 1;
                        break;
                    case "DX_CAVIDAD_IONOMEROORESINACARIESSECUNDARIA":
                        $DxCavidadTxt = "cavidad_posicion_dxionomerocariessec.png";
                        $Seguir = 1;
                        break;
                    case "DX_CAVIDAD_RESINA":
                        $DxCavidadTxt = "cavidad_posicion_dxresina.png";
                        $Seguir = 1;
                        break;
                    case "DX_CAVIDAD_RESINACONDEFECTO":
                        $DxCavidadTxt = "cavidad_posicion_dxresinadefecto.png";
                        $Seguir = 1;
                        break;
                    case "DX_CAVIDAD_RESINACARIESSECUNDARIA":
                        $DxCavidadTxt = "cavidad_posicion_dxresinacariessec.png";
                        $Seguir = 1;
                        break;
                    case "DX_CAVIDAD_AMALGAMA":
                        $DxCavidadTxt = "cavidad_posicion_dxobtura.png";
                        $Seguir = 1;
                        break;
                    case "DX_CAVIDAD_AMALGAMACONDEFECTO":
                        $DxCavidadTxt = "cavidad_posicion_dxobturadefecto.png";
                        $Seguir = 1;
                        break;
                    case "DX_CAVIDAD_AMALGAMACARIESSECUNDARIA":
                        $DxCavidadTxt = "cavidad_posicion_dxamalgamacariessec.png";
                        $Seguir = 1;
                        break;
                    default:
                        $Seguir = 0;
                        break;
                }
                if($Seguir == 1){
                    $superficies = str_replace("-N", "", $rowOdontograma[$j]["Superficies"]);
                    $estructurahc = explode("-",$superficies); 
                    $reg = count($estructurahc);
                    for ($k=0; $k<$reg; $k++){ 
                        if(($pDiente >= 11 && $pDiente <= 18) || ($pDiente >= 21 && $pDiente <= 28) || ($pDiente >= 51 && $pDiente <= 55) || ($pDiente >= 61 && $pDiente <= 65)){
                            // Dientes Superiores 
                            // Superficies 
                            // Vestibular = sup
                            // Lingual - Palatina = inf
                            // Oclusal = cen
                            switch($estructurahc[$k]){
                                case "O":
                                    $pdf->Image("../../../resources/odontograma/" . str_replace("posicion","cen",$DxCavidadTxt), $pX, $pY, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                                    break;
                                case "V":
                                    $pdf->Image("../../../resources/odontograma/" . str_replace("posicion","sup",$DxCavidadTxt), $pX, $pY, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                                    break;
                                case "L":
                                    $pdf->Image("../../../resources/odontograma/" . str_replace("posicion","inf",$DxCavidadTxt), $pX, $pY, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                                    break;
                                case "P":
                                    $pdf->Image("../../../resources/odontograma/" . str_replace("posicion","inf",$DxCavidadTxt), $pX, $pY, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                                    break;
                                default:
                                    break;
                            }
                            if(($pDiente >= 11 && $pDiente <= 18) || ($pDiente >= 51 && $pDiente <= 55)){
                                // Distal = izq
                                // Mesial = der
                                switch($estructurahc[$k]){
                                    case "M":
                                        $pdf->Image("../../../resources/odontograma/" . str_replace("posicion","der",$DxCavidadTxt), $pX, $pY, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                                        break;
                                    case "D":
                                        $pdf->Image("../../../resources/odontograma/" . str_replace("posicion","izq",$DxCavidadTxt), $pX, $pY, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                                        break;
                                    default:
                                        break;
                                }
                            }else{
                                switch($estructurahc[$k]){
                                    case "M":
                                        $pdf->Image("../../../resources/odontograma/" . str_replace("posicion","izq",$DxCavidadTxt), $pX, $pY, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                                        break;
                                    case "D":
                                        $pdf->Image("../../../resources/odontograma/" . str_replace("posicion","der",$DxCavidadTxt), $pX, $pY, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                                        break;
                                    default:
                                        break;
                                }
                            }
                        }else{
                            if(($pDiente >= 41 && $pDiente <= 48) || ($pDiente >= 31 && $pDiente <= 38) || ($pDiente >= 81 && $pDiente <= 85) || ($pDiente >= 71 && $pDiente <= 75)){
                                // Dientes Inferiores 
                                // Superficies 
                                // Vestibular = inf
                                // Lingual - Palatina = sup
                                // Oclusal = cen
                                switch($estructurahc[$k]){
                                    case "O":
                                        $pdf->Image("../../../resources/odontograma/" . str_replace("posicion","cen",$DxCavidadTxt), $pX, $pY, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                                        break;
                                    case "V":
                                        $pdf->Image("../../../resources/odontograma/" . str_replace("posicion","inf",$DxCavidadTxt), $pX, $pY, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                                        break;
                                    case "L":
                                        $pdf->Image("../../../resources/odontograma/" . str_replace("posicion","sup",$DxCavidadTxt), $pX, $pY, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                                        break;
                                    case "P":
                                        $pdf->Image("../../../resources/odontograma/" . str_replace("posicion","sup",$DxCavidadTxt), $pX, $pY, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                                        break;
                                    default:
                                        break;
                                }
                                if(($pDiente >= 41 && $pDiente <= 48) || ($pDiente >= 81 && $pDiente <= 85)){
                                    switch($estructurahc[$k]){
                                        case "M":
                                            $pdf->Image("../../../resources/odontograma/" . str_replace("posicion","der",$DxCavidadTxt), $pX, $pY, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                                            break;
                                        case "D":
                                            $pdf->Image("../../../resources/odontograma/" . str_replace("posicion","izq",$DxCavidadTxt), $pX, $pY, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                                            break;
                                        default:
                                            break;
                                    }
                                }else{
                                    switch($estructurahc[$k]){
                                        case "M":
                                            $pdf->Image("../../../resources/odontograma/" . str_replace("posicion","izq",$DxCavidadTxt), $pX, $pY, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                                            break;
                                        case "D":
                                            $pdf->Image("../../../resources/odontograma/" . str_replace("posicion","der",$DxCavidadTxt), $pX, $pY, 12, 22, 'PNG', '', '', true, 300, '', false, false, 1, false, false, false);
                                            break;
                                        default:
                                            break;
                                    }
                                }
                            }
                        }
                    }
                }
                break;
        }
    }
}

?>