<?php

//set_time_limit(500);
require_once('../../../lib/tcpdf/config/lang/spa.php');
require_once('../../../lib/tcpdf/tcpdf.php');
require("../../../core/php/_database.php");
require("../../../core/php/php_functions.php");
//header('Content-type: application/pdf; charset: UTF-8');

    session_start();
    $pConsultorioVirtual = $_SESSION['IDBD'];
    $nomEmpresa = $_SESSION['NOM_EMPRESA'];
    $nomUsuario = $_SESSION['NOM_USUARIO'];
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:1;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:1;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pEvolucion = isset($_REQUEST['pEvolucion'])?$_REQUEST['pEvolucion']:0;

    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_civyc_printhc('" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pEvolucion . "')";
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    while ($row[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $pRegistros = count($row);

    //Definicion de las Margenes
    $LeftMargin = PDF_MARGIN_LEFT;
    $TopMargin = 10;
    $RightMargin = PDF_MARGIN_RIGHT;
    $HeaderMargin = PDF_MARGIN_HEADER;
    $BottomMargin = 3;
    $FooterMargin = 5;
    $Alineacion = "P";
    $FormatoPagina = "CARTA";
    $UsaPiePagina = "SI";
    $pTipoEncabezado = "FVP";
    $pControlSalto = 20;

    //Inicializacion de la Clase
    $pdf = new TCPDF($Alineacion, PDF_UNIT, $FormatoPagina, true, 'UTF-8', false);
    
     
    //Inicializacion Variables de Control
    $pdf->pAlineacionEncabezado = $Alineacion;
    $pdf->pTituloInforme = "HISTORIA CLINICA";
    $pdf->pImprimeLogo = "NO";
    $pdf->pAnchoTxtPagina = 210;
    $pdf->pNomEmpresa = $_SESSION['NOM_EMPRESA'];
    $pdf->pTDocEmpresa = $_SESSION['EMPRESA_TDOC'];
    $pdf->pDocEmpresa = $_SESSION['EMPRESA_DOC'];
    $pdf->pDirEmpresa = $_SESSION['EMPRESA_DIR'];
    $pdf->pTelEmpresa = $_SESSION['EMPRESA_TEL'];
    $pdf->pCiuEmpresa = $_SESSION['EMPRESA_CIU'];
    $pdf->pEspEmpresa = $_SESSION['EMPRESA_ESP'];
    $pdf->pRegEmpresa = $_SESSION['EMPRESA_REGIMEN'];
    $pdf->pContribuyentes = $_SESSION['EMPRESA_CONTRIBUYENTE'];
    $pdf->pReteIVA  = $_SESSION['EMPRESA_RTEICA'];
    $pdf->pReteICA = $_SESSION['EMPRESA_RTEIVA'];

    $pdf->pTipoEncabezado = $pTipoEncabezado;
    $pdf->pNomSede = $_SESSION['EMPRESA_DOC'];
    $pdf->pNomIPS = $_SESSION['NOM_IPS'];
    $pdf->pMargenPie = -20;
    $pdf->pLogoCliente = "../../../consultoriovirtual/" . $_SESSION['IDBD'] . "/logo/logoenc.gif";
    $pdf->pPrefijo = 1; //$row[0]["Prefijo"];
    $pdf->pNroDocumento = 1; //str_pad($row[0]["NroDocumento"], 7, "0", STR_PAD_LEFT);
    $pdf->pNroResolucion = 1; //$row[0]["NroResolucion"];
    $pdf->pFechaDoc = 1; //$row[0]["FechaDocumento"];
    $pdf->pCAS = null;
    $pdf->pTratamiento = null;
    $pdf->pUsaPie = $UsaPiePagina;

    $pdf->SetCreator(PDF_CREATOR);
    $pdf->SetAuthor('Sistemas Ofisalud © - 2011');
    $pdf->SetTitle('OfiClinic Historia Clinica©');
    $pdf->SetSubject('Soporte Historia Clinica Inestabilidad, Vertigo y Caidas');

    $pdf->SetHeaderData($pdf->pLogoCliente, PDF_HEADER_LOGO_WIDTH, $pdf->pTituloInforme, PDF_HEADER_STRING);
    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
    $pdf->SetMargins($LeftMargin, $TopMargin, $RightMargin);
    $pdf->SetHeaderMargin($HeaderMargin);
    $pdf->SetFooterMargin($FooterMargin);
    // set bacground image

    $pdf->SetAutoPageBreak(TRUE, $BottomMargin);
    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
    $pdf->setLanguageArray($l);
    $pdf->setFontSubsetting(true);
    $pdf->SetFont('dejavusans', '', 14, '', true);
    
    for($i=0;$i<$pRegistros;$i++)
    {
        if($row[$i]["nomPaciente"] != ""){
            if ($idPaciente != $row[$i]["nomPaciente"])
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
            $pdf->Ln(0.5);
        
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $pEstadoCivil = "";
            $mostrarHC = '<table><tr><td colspan="4" style="font-size:30px; font-weight:bolder;">IDENTIFICACION</td></tr>';
            $mostrarHC .= '<tr><td colspan="4"><hr></td></tr>';
            $mostrarHC .= '<tr><td width="140" style="font-size:30px; font-weight:bolder;">NOMBRES Y APELLIDOS:</td><td width="300" style="font-size:30px;">' . utf8_decode($row[$i]["Nom1"]) . " " . utf8_decode($row[$i]["Nom2"]) . " " . utf8_decode($row[$i]["Ape1"]) . " " . utf8_decode($row[$i]["Ape2"]) . '</td>';
            $mostrarHC .= '<td></td></tr>';
            $mostrarHC .= '<tr><td style="font-size:30px; font-weight:bolder;">IDENTIFICACION:</td><td style="font-size:30px;">' . utf8_decode($row[$i]["TipDoc"]) . " - " . utf8_decode($row[$i]["Documento"]) . '</td><td width="80" style="font-size:30px; font-weight:bolder;"></td><td></td></tr>';
            $mostrarHC .= '<tr><td style="font-size:30px; font-weight:bolder;">FECHA DE NACIMIENTO:</td><td style="font-size:30px;">' . utf8_decode($row[$i]["FecNac"]) . '</td><td width="100" style="font-size:30px; font-weight:bolder;">SEXO:</td><td style="font-size:30px;">' . utf8_decode($row[$i]["Genero"]) . '</td></tr>';
            switch(utf8_decode($row[$i]["ecivi"])){
                case "1":
                    $pEstadoCivil = "SOLTERO(A)";
                    break;
                case "2":
                    $pEstadoCivil = "SEPARADO(A)";
                    break;
                case "3":
                    $pEstadoCivil = "CASADO(A)";
                    break;
                case "4":
                    $pEstadoCivil = "VIUDO(A)";
                    break;
                default: 
                    break;
            }
            $mostrarHC .= '<tr><td style="font-size:30px; font-weight:bolder;">ESTADO CIVIL:</td><td style="font-size:30px;">' . $pEstadoCivil . '</td><td width="100" style="font-size:30px; font-weight:bolder;">EDAD:</td><td style="font-size:30px;">' . utf8_decode($row[$i]["Edad"]) . '</td></tr>';
            $mostrarHC .= '<tr><td style="font-size:30px; font-weight:bolder;">DIRECCION:</td><td style="font-size:30px;">' . utf8_decode($row[$i]["Direccion"]) . '</td><td width="100" style="font-size:30px; font-weight:bolder;">TELEFONO:</td><td style="font-size:30px;">' . utf8_decode($row[$i]["Telefono"]) . " - " . utf8_decode($row[$i]["Telefono1"]) . '</td></tr>';
            $mostrarHC .= '<tr><td style="font-size:30px; font-weight:bolder;">OCUPACION PRINCIPAL:</td><td style="font-size:30px;">' . strtoupper(utf8_decode($row[$i]["ocu_pal"])) . '</td><td width="100" style="font-size:30px; font-weight:bolder;">ACTUAL:</td><td style="font-size:30px;">' . strtoupper(utf8_decode($row[$i]["ocu_actu"])) . '</td></tr>';
            $pRegimen = "";
            switch(utf8_decode($row[$i]["afiliac"])){
                case "1":
                    $pRegimen = "CONTRIBUTIVO";
                    break;
                case "2":
                    $pRegimen = "SUBSIDIADO";
                    break;
                case "3":
                    $pRegimen = "POBRE NO ASEGURADO";
                    break;
                case "4":
                    $pRegimen = "PARTICULAR";
                    break;
                case "5":
                    $pRegimen = "OTRO";
                    break;
                default:
                    break;
            }
            $mostrarHC .= '<tr><td style="font-size:30px; font-weight:bolder;">EPS:</td><td style="font-size:30px;">' . strtoupper(utf8_decode($row[$i]["eps"])) . '</td><td width="100" style="font-size:30px; font-weight:bolder;">REGIMEN:</td><td style="font-size:30px;">' . $pRegimen . '</td></tr>';
            $mostrarHC .= '</table>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $pNivelEducativo = "";
            switch(utf8_decode($row[$i]["niveledu"])){
                case "0":
                    $pNivelEducativo = "ANALFABETA";
                    break;
                case "1":
                    $pNivelEducativo = "SOLAMENTE APRENDIO A LEER Y ESCRIBIR";
                    break;
                case "2":
                    $pNivelEducativo = "MENOS QUE PRIMARIA";
                    break;
                case "3":
                    $pNivelEducativo = "PRIMARIA";
                    break;
                case "4":
                    $pNivelEducativo = "MENOS QUE SECUNDARIA";
                    break;
                case "5":
                    $pNivelEducativo = "SECUNDARIA";
                    break;
                case "6":
                    $pNivelEducativo = "UNIVERSIDAD O EQUIVALENTE";
                    break;
                default:
                    break;
            }
            $mostrarHC = '<span style="font-size:30px;">Cuantos años de educación completa tuvo usted?&nbsp;<u>' . utf8_decode($row[$i]["anoedu"]) . '</u>, años, ¿Cuál fue el mas alto nivel educativo que tuvo?&nbsp;' . $pNivelEducativo;
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $pConviventes = "";
            switch(utf8_decode($row[$i]["convivi"])){
                case "0":
                    $pConviventes = "VIVE SOLO";
                    break;
                case "1":
                    $pConviventes = "VIVE CON OTROS EN LA MISMA CASA";
                    break;
                case "2":
                    $pConviventes = "LARGA ESTANCIA (HOGAR DE ANCIANOS O RECIDENCIA)";
                    break;
                case "3":
                    $pConviventes = "OTROS";
                    break;
                default:
                    break;
            }
            $mostrarHC = '<span style="font-size:30px;"><b>CONVIVENTES:</b>&nbsp;' . $pConviventes . '</span>';
            if($pConviventes == "OTRO"){
                $mostrarHC .= '<span style="font-size:30px;">&nbsp;&nbsp;- ESPECIFIQUE:&nbsp;' . strtoupper(utf8_decode($row[$i]["otrosconvivi"])) . '</span>';
            }
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $pRemitidoPor = "";
            switch(utf8_decode($row[$i]["remision"])){
                case "0":
                    $pRemitidoPor = "MEDICO INTERNISTA";
                    break;
                case "1":
                    $pRemitidoPor = "MEDICO GERIATRA";
                    break;
                case "2":
                    $pRemitidoPor = "MEDICO GENERAL";
                    break;
                case "3":
                    $pRemitidoPor = "OTORRINO";
                    break;
                case "4":
                    $pRemitidoPor = "NEUROLOGO";
                    break;
                case "5":
                    $pRemitidoPor = "PSIQUIATRA";
                    break;
                case "6":
                    $pRemitidoPor = "PACIENTE - FAMILIA";
                    break;
                case "7":
                    $pRemitidoPor = "CUIDADOR";
                    break;
                case "8":
                    $pRemitidoPor = "SERVICIO - COMUNITARIO";
                    break;
                case "9":
                    $pRemitidoPor = "REHABILITACIÓN";
                    break;
                case "10":
                    $pRemitidoPor = "ENFERMERA";
                    break;
                case "11":
                    $pRemitidoPor = "TRABAJO SOCIAL";
                    break;
                case "12":
                    $pRemitidoPor = "OTRO";
                    break;
                default:
                    break;
            }
            $mostrarHC = '<span style="font-size:30px;"><b>REMITIDO POR:</b>&nbsp;' . $pRemitidoPor . '</span>';
            if($pConviventes == "OTRO"){
                $mostrarHC .= '<span style="font-size:30px;">&nbsp;&nbsp;- ESPECIFIQUE:&nbsp;' . strtoupper(utf8_decode($row[$i]["otrosremision"])) . '</span>';
            }
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $pdf->writeHTML("<hr><br>", true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>MOTIVO CONSULTA</b>:&nbsp;' . strtoupper(utf8_decode($row[$i]["MotivoConsulta"])) . '</span><br><br>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>ENFERMEDAD ACTUAL</b>:&nbsp;' . strtoupper(utf8_decode($row[$i]["EnfermedadActual"])) . '</span><br><br>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            unset($rowSintomas);
            $gBaseDatos = new ofiMySQLi();
            $gBaseDatos->conectar();
            $qry = "CALL sp_asistencial_civyc_printhc_01('" . $pEvolucion . "')";
            $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
            while ($rowSintomas[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
            $gBaseDatos->liberar();
            $gBaseDatos->cerrar();

            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>SINTOMAS</b>:&nbsp;</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $pVertigo = "SI";
            if(utf8_decode($rowSintomas[0]["verti_si"]) == "0" || utf8_decode($rowSintomas[0]["verti_si"]) == 0){
                $pVertigo = "NO";
            }
            $pTipoVertigo = "";
            switch(utf8_decode($rowSintomas[0]["vertigo"])){
                case "0":
                    $pTipoVertigo = "AUSENCIA";
                    break;
                case "1":
                    $pTipoVertigo = "GIRO";
                    break;
                case "2":
                    $pTipoVertigo = "ASCENSO - DESCENSO";
                    break;
                case "3":
                    $pTipoVertigo = "ANTEROPOSTERIOR";
                    break;
                default:
                    break;
            }
            $pInestabilidadP = "SI";
            if(utf8_decode($rowSintomas[0]["inest"]) == "0" || utf8_decode($rowSintomas[0]["inest"]) == 0){
                $pInestabilidadP = "NO";
            }
            $pInestabilidadS = "SI";
            if(utf8_decode($rowSintomas[0]["desequil"]) == "0" || utf8_decode($rowSintomas[0]["desequil"]) == 0){
                $pInestabilidadS = "NO";
            }
            $pSincope = "SI";
            if(utf8_decode($rowSintomas[0]["sinco"]) == "0" || utf8_decode($rowSintomas[0]["sinco"]) == 0){
                $pSincope = "NO";
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>- VERTIGO</b>:&nbsp;' . $pVertigo . ',&nbsp;&nbsp;' . $pTipoVertigo . ',&nbsp;&nbsp;<b>INESTABILIDAD PRIMARIA</b>:&nbsp;' . $pInestabilidadP . ',&nbsp;&nbsp;<b>INESTABILIDAD SECUNDARIA</b>:&nbsp;' . $pInestabilidadS . ',&nbsp;&nbsp;<b>SINCOPE</b>:&nbsp;' . $pSincope . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $pMareo = "SI";
            if(utf8_decode($rowSintomas[0]["mareo"]) == "0" || utf8_decode($rowSintomas[0]["mareo"]) == 0){
                $pMareo = "NO";
            }
            $pTipoMareo = "";
            switch(utf8_decode($rowSintomas[0]["tipomare"])){
                case "0":
                    $pTipoMareo = "AUSENCIA";
                    break;
                case "1":
                    $pTipoMareo = "VAHIDO";
                    break;
                case "2":
                    $pTipoMareo = "BORRACHERA";
                    break;
                case "3":
                    $pTipoMareo = "TONTINA";
                    break;
                case "4":
                    $pTipoMareo = "CABEZA HUECA";
                    break;
                case "5":
                    $pTipoMareo = "EMBOMBAMIENTO";
                    break;
                case "6":
                    $pTipoMareo = "EMBOTAMIENTO";
                    break;
                default:
                    break;
            }
            $pMareoPre = "SI";
            if(utf8_decode($rowSintomas[0]["mareopre"]) == "0" || utf8_decode($rowSintomas[0]["mareopre"]) == 0){
                $pMareoPre = "NO";
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>- MAREO</b>:&nbsp;' . $pMareo . ',&nbsp;&nbsp;<b>TIPO MAREO</b>:&nbsp;' . $pTipoMareo . ',&nbsp;&nbsp;<b>MAREO PRESINCOPAL</b>:&nbsp;' . $pMareoPre . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $pCuandoSePresentan = "";
            switch(utf8_decode($rowSintomas[0]["cuando"])){
                case "1":
                    $pCuandoSePresentan = "CON OSCURIDAD";
                    break;
                case "2":
                    $pCuandoSePresentan = "CON LUZ (NATURAL O ARTIFICIAL)";
                    break;
                case "3":
                    $pCuandoSePresentan = "EN REPOSO (QUIETO)";
                    break;
                case "4":
                    $pCuandoSePresentan = "EN MOVIMIENTO";
                    break;
                case "5":
                    $pCuandoSePresentan = "DENTRO DE LA CASA";
                    break;
                case "6":
                    $pCuandoSePresentan = "FUERA DE LA CASA";
                    break;
                default:
                    break;
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>- CUANDO SE PRESENTAN</b>:&nbsp;' . $pCuandoSePresentan . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>- TIEMPO DE LA SINTOMATOLOGIA</b>:&nbsp;</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $pTVertigo = "";
            switch(utf8_decode($rowSintomas[0]["tvertigo"])){
                case "1":
                    $pTVertigo = "MENOR A 3 SEMANAS";
                    break;
                case "2":
                    $pTVertigo = "3 SEMANAS A 3 MESES";
                    break;
                case "3":
                    $pTVertigo = "3 MESES A 1 AÑO";
                    break;
                case "4":
                    $pTVertigo = "MAYOR 1 AÑO";
                    break;
                case "5":
                    $pTVertigo = "NO INFORMA";
                    break;
                default:
                    break;
            }
            $pTMareo = "";
            switch(utf8_decode($rowSintomas[0]["tmareo"])){
                case "1":
                    $pTMareo = "MENOR A 3 SEMANAS";
                    break;
                case "2":
                    $pTMareo = "3 SEMANAS A 3 MESES";
                    break;
                case "3":
                    $pTMareo = "3 MESES A 1 AÑO";
                    break;
                case "4":
                    $pTMareo = "MAYOR 1 AÑO";
                    break;
                case "5":
                    $pTMareo = "NO INFORMA";
                    break;
                default:
                    break;
            }
            $pTInestabilidad = "";
            switch(utf8_decode($rowSintomas[0]["tinest"])){
                case "1":
                    $pTInestabilidad = "MENOR A 3 SEMANAS";
                    break;
                case "2":
                    $pTInestabilidad = "3 SEMANAS A 3 MESES";
                    break;
                case "3":
                    $pTInestabilidad = "3 MESES A 1 AÑO";
                    break;
                case "4":
                    $pTInestabilidad = "MAYOR 1 AÑO";
                    break;
                case "5":
                    $pTInestabilidad = "NO INFORMA";
                    break;
                default:
                    break;
            }
            $pTSincope = "";
            switch(utf8_decode($rowSintomas[0]["tsincope"])){
                case "1":
                    $pTSincope = "MENOR A 3 SEMANAS";
                    break;
                case "2":
                    $pTSincope = "3 SEMANAS A 3 MESES";
                    break;
                case "3":
                    $pTSincope = "3 MESES A 1 AÑO";
                    break;
                case "4":
                    $pTSincope = "MAYOR 1 AÑO";
                    break;
                case "5":
                    $pTSincope = "NO INFORMA";
                    break;
                default:
                    break;
            }
            $pTMareoPresin = "";
            switch(utf8_decode($rowSintomas[0]["tpresincope"])){
                case "1":
                    $pTMareoPresin = "MENOR A 3 SEMANAS";
                    break;
                case "2":
                    $pTMareoPresin = "3 SEMANAS A 3 MESES";
                    break;
                case "3":
                    $pTMareoPresin = "3 MESES A 1 AÑO";
                    break;
                case "4":
                    $pTMareoPresin = "MAYOR 1 AÑO";
                    break;
                case "5":
                    $pTMareoPresin = "NO INFORMA";
                    break;
                default:
                    break;
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- VERTIGO</b>:&nbsp;' . $pTVertigo . ',&nbsp;&nbsp;<b>MAREO:</b>&nbsp;' . $pTMareo . ',&nbsp;&nbsp;<b>INESTABILIDAD</b>:&nbsp;' . $pTInestabilidad . ',&nbsp;&nbsp;<b>SINCOPE</b>:&nbsp;' . $pTSincope . ',&nbsp;&nbsp;<b>MAREO PRESINCOPAL</b>:&nbsp;' . $pTMareoPresin . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>- FRECUENCIA</b>:&nbsp;</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $pFVertigo = "";
            switch(utf8_decode($rowSintomas[0]["frecvertigo"])){
                case "1":
                    $pFVertigo = "PREMANENTE";
                    break;
                case "2":
                    $pFVertigo = "EPISODIOS DIARIOS";
                    break;
                case "3":
                    $pFVertigo = "EPISODIOS SEMANALES";
                    break;
                case "4":
                    $pFVertigo = "EPISODIOS MENSUALES";
                    break;
                case "5":
                    $pFVertigo = "NO INFORMA";
                    break;
                default:
                    break;
            }
            $pFMareo = "";
            switch(utf8_decode($rowSintomas[0]["frecmareo"])){
                case "1":
                    $pFMareo = "PREMANENTE";
                    break;
                case "2":
                    $pFMareo = "EPISODIOS DIARIOS";
                    break;
                case "3":
                    $pFMareo = "EPISODIOS SEMANALES";
                    break;
                case "4":
                    $pFMareo = "EPISODIOS MENSUALES";
                    break;
                case "5":
                    $pFMareo = "NO INFORMA";
                    break;
                default:
                    break;
            }
            $pFInestabilidad = "";
            switch(utf8_decode($rowSintomas[0]["frecinest"])){
                case "1":
                    $pFInestabilidad = "PREMANENTE";
                    break;
                case "2":
                    $pFInestabilidad = "EPISODIOS DIARIOS";
                    break;
                case "3":
                    $pFInestabilidad = "EPISODIOS SEMANALES";
                    break;
                case "4":
                    $pFInestabilidad = "EPISODIOS MENSUALES";
                    break;
                case "5":
                    $pFInestabilidad = "NO INFORMA";
                    break;
                default:
                    break;
            }
            $pFSincope = "";
            switch(utf8_decode($rowSintomas[0]["frecsincope"])){
                case "1":
                    $pFSincope = "PREMANENTE";
                    break;
                case "2":
                    $pFSincope = "EPISODIOS DIARIOS";
                    break;
                case "3":
                    $pFSincope = "EPISODIOS SEMANALES";
                    break;
                case "4":
                    $pFSincope = "EPISODIOS MENSUALES";
                    break;
                case "5":
                    $pFSincope = "NO INFORMA";
                    break;
                default:
                    break;
            }
            $pFMareoPresin = "";
            switch(utf8_decode($rowSintomas[0]["frecpresincope"])){
                case "1":
                    $pFMareoPresin = "PREMANENTE";
                    break;
                case "2":
                    $pFMareoPresin = "EPISODIOS DIARIOS";
                    break;
                case "3":
                    $pFMareoPresin = "EPISODIOS SEMANALES";
                    break;
                case "4":
                    $pFMareoPresin = "EPISODIOS MENSUALES";
                    break;
                case "5":
                    $pFMareoPresin = "NO INFORMA";
                    break;
                default:
                    break;
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- VERTIGO</b>:&nbsp;' . $pFVertigo . ',&nbsp;&nbsp;<b>MAREO:</b>&nbsp;' . $pFMareo . ',&nbsp;&nbsp;<b>INESTABILIDAD</b>:&nbsp;' . $pFInestabilidad . ',&nbsp;&nbsp;<b>SINCOPE</b>:&nbsp;' . $pFSincope . ',&nbsp;&nbsp;<b>MAREO PRESINCOPAL</b>:&nbsp;' . $pFMareoPresin . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>- DURACION</b>:&nbsp;</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $pDVertigo = "";
            switch(utf8_decode($rowSintomas[0]["duracvertigo"])){
                case "1":
                    $pDVertigo = "SEGUNDOS";
                    break;
                case "2":
                    $pDVertigo = "MINUTOS";
                    break;
                case "3":
                    $pDVertigo = "HORAS";
                    break;
                case "4":
                    $pDVertigo = "PERMANENTE";
                    break;
                case "5":
                    $pDVertigo = "NO INFORMA";
                    break;
                default:
                    break;
            }
            $pDMareo = "";
            switch(utf8_decode($rowSintomas[0]["duracmareo"])){
                case "1":
                    $pDMareo = "SEGUNDOS";
                    break;
                case "2":
                    $pDMareo = "MINUTOS";
                    break;
                case "3":
                    $pDMareo = "HORAS";
                    break;
                case "4":
                    $pDMareo = "PERMANENTE";
                    break;
                case "5":
                    $pDMareo = "NO INFORMA";
                    break;
                default:
                    break;
            }
            $pDInestabilidad = "";
            switch(utf8_decode($rowSintomas[0]["duracinest"])){
                case "1":
                    $pDInestabilidad = "SEGUNDOS";
                    break;
                case "2":
                    $pDInestabilidad = "MINUTOS";
                    break;
                case "3":
                    $pDInestabilidad = "HORAS";
                    break;
                case "4":
                    $pDInestabilidad = "PERMANENTE";
                    break;
                case "5":
                    $pDInestabilidad = "NO INFORMA";
                    break;
                default:
                    break;
            }
            $pDSincope = "";
            switch(utf8_decode($rowSintomas[0]["duracsincope"])){
                case "1":
                    $pDSincope = "SEGUNDOS";
                    break;
                case "2":
                    $pDSincope = "MINUTOS";
                    break;
                case "3":
                    $pDSincope = "HORAS";
                    break;
                case "4":
                    $pDSincope = "PERMANENTE";
                    break;
                case "5":
                    $pDSincope = "NO INFORMA";
                    break;
                default:
                    break;
            }
            $pDMareoPresin = "";
            switch(utf8_decode($rowSintomas[0]["duracpresincope"])){
                case "1":
                    $pDMareoPresin = "SEGUNDOS";
                    break;
                case "2":
                    $pDMareoPresin = "MINUTOS";
                    break;
                case "3":
                    $pDMareoPresin = "HORAS";
                    break;
                case "4":
                    $pDMareoPresin = "PERMANENTE";
                    break;
                case "5":
                    $pDMareoPresin = "NO INFORMA";
                    break;
                default:
                    break;
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- VERTIGO</b>:&nbsp;' . $pDVertigo . ',&nbsp;&nbsp;<b>MAREO:</b>&nbsp;' . $pDMareo . ',&nbsp;&nbsp;<b>INESTABILIDAD</b>:&nbsp;' . $pDInestabilidad . ',&nbsp;&nbsp;<b>SINCOPE</b>:&nbsp;' . $pDSincope . ',&nbsp;&nbsp;<b>MAREO PRESINCOPAL</b>:&nbsp;' . $pDMareoPresin . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>- FACTORES DESENCADENANTES</b>:&nbsp;</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $pDesencVertigo = "";
            switch(utf8_decode($rowSintomas[0]["desencvertigo"])){
                case "1":
                    $pDesencVertigo = "GIRO DE CABEZA";
                    break;
                case "2":
                    $pDesencVertigo = "HIPEREXTENSION";
                    break;
                case "3":
                    $pDesencVertigo = "AGACHARSE";
                    break;
                case "4":
                    $pDesencVertigo = "INCORPORSE";
                    break;
                case "5":
                    $pDesencVertigo = "DESPLAZARSE";
                    break;
                case "6":
                    $pDesencVertigo = "MOVIMIENTO";
                    break;
                case "7":
                    $pDesencVertigo = "NO INFORMA";
                    break;
                default:
                    break;
            }
            $pDesencMareo = "";
            switch(utf8_decode($rowSintomas[0]["desencmareo"])){
                case "1":
                    $pDesencMareo = "GIRO DE CABEZA";
                    break;
                case "2":
                    $pDesencMareo = "HIPEREXTENSION";
                    break;
                case "3":
                    $pDesencMareo = "AGACHARSE";
                    break;
                case "4":
                    $pDesencMareo = "INCORPORSE";
                    break;
                case "5":
                    $pDesencMareo = "DESPLAZARSE";
                    break;
                case "6":
                    $pDesencMareo = "MOVIMIENTO";
                    break;
                case "7":
                    $pDesencMareo = "NO INFORMA";
                    break;
                default:
                    break;
            }
            $pDesencInestabilidad = "";
            switch(utf8_decode($rowSintomas[0]["desencinest"])){
                case "1":
                    $pDesencInestabilidad = "GIRO DE CABEZA";
                    break;
                case "2":
                    $pDesencInestabilidad = "HIPEREXTENSION";
                    break;
                case "3":
                    $pDesencInestabilidad = "AGACHARSE";
                    break;
                case "4":
                    $pDesencInestabilidad = "INCORPORSE";
                    break;
                case "5":
                    $pDesencInestabilidad = "DESPLAZARSE";
                    break;
                case "6":
                    $pDesencInestabilidad = "MOVIMIENTO";
                    break;
                case "7":
                    $pDesencInestabilidad = "NO INFORMA";
                    break;
                default:
                    break;
            }
            $pDesencSincope = "";
            switch(utf8_decode($rowSintomas[0]["desencsincope"])){
                case "1":
                    $pDesencSincope = "GIRO DE CABEZA";
                    break;
                case "2":
                    $pDesencSincope = "HIPEREXTENSION";
                    break;
                case "3":
                    $pDesencSincope = "AGACHARSE";
                    break;
                case "4":
                    $pDesencSincope = "INCORPORSE";
                    break;
                case "5":
                    $pDesencSincope = "DESPLAZARSE";
                    break;
                case "6":
                    $pDesencSincope = "MOVIMIENTO";
                    break;
                case "7":
                    $pDesencSincope = "NO INFORMA";
                    break;
                default:
                    break;
            }
            $pDesencMareoPresin = "";
            switch(utf8_decode($rowSintomas[0]["desencpresincope"])){
                case "1":
                    $pDesencMareoPresin = "GIRO DE CABEZA";
                    break;
                case "2":
                    $pDesencMareoPresin = "HIPEREXTENSION";
                    break;
                case "3":
                    $pDesencMareoPresin = "AGACHARSE";
                    break;
                case "4":
                    $pDesencMareoPresin = "INCORPORSE";
                    break;
                case "5":
                    $pDesencMareoPresin = "DESPLAZARSE";
                    break;
                case "6":
                    $pDesencMareoPresin = "MOVIMIENTO";
                    break;
                case "7":
                    $pDesencMareoPresin = "NO INFORMA";
                    break;
                default:
                    break;
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- VERTIGO</b>:&nbsp;' . $pDesencVertigo . ',&nbsp;&nbsp;<b>MAREO:</b>&nbsp;' . $pDesencMareo . ',&nbsp;&nbsp;<b>INESTABILIDAD</b>:&nbsp;' . $pDesencInestabilidad . ',&nbsp;&nbsp;<b>SINCOPE</b>:&nbsp;' . $pDesencSincope . ',&nbsp;&nbsp;<b>MAREO PRESINCOPAL</b>:&nbsp;' . $pDesencMareoPresin . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            if(utf8_decode($rowSintomas[0]["desencobservaciones"]) != "" && utf8_decode($rowSintomas[0]["desencobservaciones"]) != null){
                $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- OBSERVACIONES</b>:&nbsp;' . utf8_decode($rowSintomas[0]["desencobservaciones"]) . '</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>- SINTOMAS ASOCIADOS</b>:&nbsp;</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $pSintAsocNauceas = "SI";
            if(utf8_decode($rowSintomas[0]["sasociadnauseas"]) == "0" || utf8_decode($rowSintomas[0]["sasociadnauseas"]) == 0){
                $pSintAsocNauceas = "NO";
            }
            $mostrarHC = '<span style="font-size:30px; text-align:left;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- NAUSEAS</b>:&nbsp;' . $pSintAsocNauceas . ',&nbsp;&nbsp;';
            $pSintAsocVomito = "SI";
            if(utf8_decode($rowSintomas[0]["sasociadvomito"]) == "0" || utf8_decode($rowSintomas[0]["sasociadvomito"]) == 0){
                $pSintAsocVomito = "NO";
            }
            $mostrarHC .= '<b>VOMITO</b>:&nbsp;' . $pSintAsocVomito . ',&nbsp;&nbsp;';
            $pSintAsocDiaforesis = "SI";
            if(utf8_decode($rowSintomas[0]["sasociaddiaforesis"]) == "0" || utf8_decode($rowSintomas[0]["sasociaddiaforesis"]) == 0){
                $pSintAsocDiaforesis = "NO";
            }
            $mostrarHC .= '<b>DIAFORESIS</b>:&nbsp;' . $pSintAsocDiaforesis . ',&nbsp;&nbsp;';
            
            $pSintAsocDolorCabeza = "SI";
            if(utf8_decode($rowSintomas[0]["sasociaddolorcabeza"]) == "0" || utf8_decode($rowSintomas[0]["sasociaddolorcabeza"]) == 0){
                $pSintAsocDolorCabeza = "NO";
            }
            $mostrarHC .= '<b>DOLOR DE CABEZA</b>:&nbsp;' . $pSintAsocDolorCabeza . ',&nbsp;&nbsp;';
            
            $pSintAsocParestesias = "SI";
            if(utf8_decode($rowSintomas[0]["sasociadparestesiasdiaste"]) == "0" || utf8_decode($rowSintomas[0]["sasociadparestesiasdiaste"]) == 0){
                $pSintAsocParestesias = "NO";
            }
            $mostrarHC .= '<b>PARESTESIAS Y DIASTESIAS</b>:&nbsp;' . $pSintAsocParestesias . ',&nbsp;&nbsp;';
            
            $pSintAsocTennitus = "SI";
            if(utf8_decode($rowSintomas[0]["sasociadtinnitus"]) == "0" || utf8_decode($rowSintomas[0]["sasociadtinnitus"]) == 0){
                $pSintAsocTennitus = "NO";
            }
            $mostrarHC .= '<b>TINNITUS</b>:&nbsp;' . $pSintAsocTennitus . ',&nbsp;&nbsp;';
            
            $pSintAsocTomarAliento = "SI";
            if(utf8_decode($rowSintomas[0]["sasociaddificultaaliento"]) == "0" || utf8_decode($rowSintomas[0]["sasociaddificultaaliento"]) == 0){
                $pSintAsocTomarAliento = "NO";
            }
            $mostrarHC .= '<b>DIFICTULTAD PARA TOMAR ALIENTO</b>:&nbsp;' . $pSintAsocTomarAliento . ',&nbsp;&nbsp;';
            
            $pSintAsocDolorTorax = "SI";
            if(utf8_decode($rowSintomas[0]["sasociaddolortorax"]) == "0" || utf8_decode($rowSintomas[0]["sasociaddolortorax"]) == 0){
                $pSintAsocDolorTorax = "NO";
            }
            $mostrarHC .= '<b>DOLOR TORAXICO</b>:&nbsp;' . $pSintAsocDolorTorax . ',&nbsp;&nbsp;';
            
            $pSintAsocPalpitaciones = "SI";
            if(utf8_decode($rowSintomas[0]["sasociadpalpitaciones"]) == "0" || utf8_decode($rowSintomas[0]["sasociadpalpitaciones"]) == 0){
                $pSintAsocPalpitaciones = "NO";
            }
            $mostrarHC .= '<b>PALPITACIONES</b>:&nbsp;' . $pSintAsocPalpitaciones . ',&nbsp;&nbsp;';
            
            $pSintAsocDisartria = "SI";
            if(utf8_decode($rowSintomas[0]["sasociaddisartria"]) == "0" || utf8_decode($rowSintomas[0]["sasociaddisartria"]) == 0){
                $pSintAsocDisartria = "NO";
            }
            $mostrarHC .= '<b>DISARTRIA</b>:&nbsp;' . $pSintAsocDisartria . ',&nbsp;&nbsp;';
            
            $pSintAsocCambiosAud = "SI";
            if(utf8_decode($rowSintomas[0]["sasociadcambiosaud"]) == "0" || utf8_decode($rowSintomas[0]["sasociadcambiosaud"]) == 0){
                $pSintAsocCambiosAud = "NO";
            }
            $mostrarHC .= '<b>CAMBIOS EN AUDICION</b>:&nbsp;' . $pSintAsocCambiosAud . ',&nbsp;&nbsp;';
            
            $pSintAsocDisnea = "SI";
            if(utf8_decode($rowSintomas[0]["sasociaddisnea"]) == "0" || utf8_decode($rowSintomas[0]["sasociaddisnea"]) == 0){
                $pSintAsocDisnea = "NO";
            }
            $mostrarHC .= '<b>DISNEA</b>:&nbsp;' . $pSintAsocDisnea . ',&nbsp;&nbsp;';
            
            $pSintAsocDifVision = "SI";
            if(utf8_decode($rowSintomas[0]["sasociaddificultavision"]) == "0" || utf8_decode($rowSintomas[0]["sasociaddificultavision"]) == 0){
                $pSintAsocDifVision = "NO";
            }
            $mostrarHC .= '<b>DIFICULTADES EN LA VISION</b>:&nbsp;' . $pSintAsocDifVision . ',&nbsp;&nbsp;';
            
            $pSintAsocNervioso = "SI";
            if(utf8_decode($rowSintomas[0]["sasociadnerviosoansiedad"]) == "0" || utf8_decode($rowSintomas[0]["sasociadnerviosoansiedad"]) == 0){
                $pSintAsocNervioso = "NO";
            }
            $mostrarHC .= '<b>NERVIOSISMO O ANSIEDAD</b>:&nbsp;' . $pSintAsocNervioso;
            
            $mostrarHC .= '</span><br><br>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            
            unset($rowCaidas);
            $gBaseDatos = new ofiMySQLi();
            $gBaseDatos->conectar();
            $qry = "CALL sp_asistencial_civyc_printhc_02('" . $pEvolucion . "')";
            $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
            while ($rowCaidas[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
            $gBaseDatos->liberar();
            $gBaseDatos->cerrar();

            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>CAIDAS</b>:&nbsp;</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $pCausaCaida = "";
            switch(utf8_decode($rowCaidas[0]["causacai"])){
                case "1":
                    $pCausaCaida = "TROPEZO";
                    break;
                case "2":
                    $pCausaCaida = "DESLIZO";
                    break;
                case "3":
                    $pCausaCaida = "MAREO";
                    break;
                case "4":
                    $pCausaCaida = "OTRA";
                    break;
                default:
                    break;
            }
            
            $mostrarHC = '<span style="font-size:30px;">En el ultimo año se ha <b>CAIDO</b> al piso. Numero:&nbsp;<u>' . utf8_decode($rowCaidas[0]["ncaida"]) . '</u>, Lugar de la caida:&nbsp;' . utf8_decode($rowCaidas[0]["sitiocai"]) . '&nbsp;<b>CAUSA</b>:&nbsp;' . $pCausaCaida;
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<span style="font-size:30px;">Que estaba haciendo en el momento de la ultima caida?   &nbsp;<u>' . utf8_decode($rowCaidas[0]["activcae"]);
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $pAyudaLevantarse = "SI";
            if(utf8_decode($rowCaidas[0]["ayuda"]) == "0" || utf8_decode($rowCaidas[0]["ayuda"]) == 0){
                $pAyudaLevantarse = "NO";
            }
            $mostrarHC = '<span style="font-size:30px;">No necesito ayuda de otra persona para levantarse?&nbsp;<u>' . $pAyudaLevantarse;
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px;">En la ultima caida, cuanto tiempo estuvo en el piso?&nbsp;<u>'  . utf8_decode($rowCaidas[0]["tiempiso"]) . " segundos.";
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $pLesionesCaida = "SI";
            if(utf8_decode($rowCaidas[0]["lesicai"]) == "0" || utf8_decode($rowCaidas[0]["lesicai"]) == 0){
                $pLesionesCaida = "NO";
            }
            $pLesionesCaidaFractura = "SI";
            if(utf8_decode($rowCaidas[0]["fract"]) == "0" || utf8_decode($rowCaidas[0]["fract"]) == 0){
                $pLesionesCaidaFractura = "NO";
            }
            $pLesionesCaidaSitioFractura = "";
            switch(utf8_decode($rowCaidas[0]["sitiofx"])){
                case "1":
                    $pLesionesCaidaSitioFractura = "CABEZA";
                    break;
                case "2":
                    $pLesionesCaidaSitioFractura = "TRONCO";
                    break;
                case "3":
                    $pLesionesCaidaSitioFractura = "EXTREMIDADES SUPERIORES";
                    break;
                case "4":
                    $pLesionesCaidaSitioFractura = "EXTREMIDADES INFERIORES";
                    break;
                default:
                    break;
            }
            $pLesionesCaidaLuxacion = "SI";
            if(utf8_decode($rowCaidas[0]["luxa"]) == "0" || utf8_decode($rowCaidas[0]["luxa"]) == 0){
                $pLesionesCaidaLuxacion = "NO";
            }
            $pLesionesCaidaSitioLuxacion = "";
            switch(utf8_decode($rowCaidas[0]["sitioluxa"])){
                case "1":
                    $pLesionesCaidaSitioLuxacion = "CABEZA";
                    break;
                case "2":
                    $pLesionesCaidaSitioLuxacion = "TRONCO";
                    break;
                case "3":
                    $pLesionesCaidaSitioLuxacion = "EXTREMIDADES SUPERIORES";
                    break;
                case "4":
                    $pLesionesCaidaSitioLuxacion = "EXTREMIDADES INFERIORES";
                    break;
                default:
                    break;
            }
            $pLesionesCaidaHerida = "SI";
            if(utf8_decode($rowCaidas[0]["herid"]) == "0" || utf8_decode($rowCaidas[0]["herid"]) == 0){
                $pLesionesCaidaHerida = "NO";
            }
            $pLesionesCaidaSitioHerida = "";
            switch(utf8_decode($rowCaidas[0]["sitioher"])){
                case "1":
                    $pLesionesCaidaSitioHerida = "CABEZA";
                    break;
                case "2":
                    $pLesionesCaidaSitioHerida = "TRONCO";
                    break;
                case "3":
                    $pLesionesCaidaSitioHerida = "EXTREMIDADES SUPERIORES";
                    break;
                case "4":
                    $pLesionesCaidaSitioHerida = "EXTREMIDADES INFERIORES";
                    break;
                default:
                    break;
            }
            $pLesionesCaidaHospitalizacion = "";
            switch(utf8_decode($rowCaidas[0]["golcabez"])){
                case "0":
                    $pLesionesCaidaHospitalizacion = "NINGUNA";
                    break;
                case "1":
                    $pLesionesCaidaHospitalizacion = "FRACTURA";
                    break;
                case "2":
                    $pLesionesCaidaHospitalizacion = "LUXACION";
                    break;
                case "3":
                    $pLesionesCaidaHospitalizacion = "HERIDA";
                    break;
                case "4":
                    $pLesionesCaidaHospitalizacion = "TRAUMA CRANEOENCEFALICO";
                    break;
                case "5":
                    $pLesionesCaidaHospitalizacion = "OTRA";
                    break;
                default:
                    break;
            }
            $pLesionesCaidaOtra = "SI";
            if(utf8_decode($rowCaidas[0]["otralesi"]) == "0" || utf8_decode($rowCaidas[0]["otralesi"]) == 0){
                $pLesionesCaidaOtra = "NO";
            }
            $mostrarHC = '<span style="font-size:30px;">Por una caida en el ultimo año tuvo lesiones:&nbsp;'  . $pLesionesCaidaOtra . ', <b>SE FRACTURO</b>:&nbsp;' . $pLesionesCaidaFractura . ' <b>SITIO</b>:&nbsp;' . $pLesionesCaidaSitioFractura  . ', <b>SE DISLOCO O TORCIO ALGO</b>:&nbsp;' . $pLesionesCaidaLuxacion . ' <b>SITIO</b>:&nbsp;' . $pLesionesCaidaSitioLuxacion;
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<b>SE HIRIO</b>:&nbsp;' . $pLesionesCaidaHerida . ' <b>SITIO</b>:&nbsp;' . $pLesionesCaidaSitioHerida  . ', <b>SE GOLPEO LA CABEZA Y LO HOSPITALIZARON</b>:&nbsp;' . $pLesionesCaidaHospitalizacion . ', <b>OTRA LESION</b>:&nbsp;' . $pLesionesCaidaOtra . ' <b>CUAL</b>:&nbsp;' . utf8_decode($rowCaidas[0]["otrales1"]);
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $pConsultaCaida = "SI";
            if(utf8_decode($rowCaidas[0]["consucai"]) == "0" || utf8_decode($rowCaidas[0]["consucai"]) == 0){
                $pConsultaCaida = "NO";
            }
            $mostrarHC = '<span style="font-size:30px;">Por alguna caida en el ultimo año tuvo necesidad de consultar?&nbsp;' . $pConsultaCaida . '. Si si. No. de Veces:&nbsp;' . utf8_decode($rowCaidas[0]["consulta"]) . ', sitio de consulta:&nbsp;' . utf8_decode($rowCaidas[0]["sitiocon"]);
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $pCaminarCasa = "SI";
            if(utf8_decode($rowCaidas[0]["camincas"]) == "0" || utf8_decode($rowCaidas[0]["camincas"]) == 0){
                $pCaminarCasa = "NO";
            }
            $pOficioCasa = "SI";
            if(utf8_decode($rowCaidas[0]["oficcasa"]) == "0" || utf8_decode($rowCaidas[0]["oficcasa"]) == 0){
                $pOficioCasa = "NO";
            }
            $pIrTrabajar= "SI";
            if(utf8_decode($rowCaidas[0]["trabaj"]) == "0" || utf8_decode($rowCaidas[0]["trabaj"]) == 0){
                $pOficioCasa = "NO";
            }
            $mostrarHC = '<span style="font-size:30px;">A consecuencia de una caida en el ultimo año, estuvo usted incapacitado para: Caminar dentro de la Casa &nbsp;' . $pCaminarCasa . ', Hacer Oficio en la Casa&nbsp;' . $pOficioCasa . ', Ir a Trabajar&nbsp;' . $pIrTrabajar . '</span><br><br>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            unset($rowAntecedentes);
            $gBaseDatos = new ofiMySQLi();
            $gBaseDatos->conectar();
            $qry = "CALL sp_asistencial_civyc_printhc_03('" . $pEvolucion . "')";
            $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
            while ($rowAntecedentes[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
            $gBaseDatos->liberar();
            $gBaseDatos->cerrar();
            
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>ANTECEDENTES PERSONALES PATOLOGICOS</b>:&nbsp;</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>- SISTEMA AUDITIVO</b>:&nbsp;</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $pHipoAcusia = "SI";
            if(utf8_decode($rowAntecedentes[0]["hipoacus"]) == "0" || utf8_decode($rowAntecedentes[0]["hipoacus"]) == 0){
                $pHipoAcusia = "NO";
            }
            $pOtopatia = "SI";
            if(utf8_decode($rowAntecedentes[0]["otopat"]) == "0" || utf8_decode($rowAntecedentes[0]["otopat"]) == 0){
                $pOtopatia = "NO";
            }
            $pAuditivoOtro = "SI";
            if(utf8_decode($rowAntecedentes[0]["audiotra"]) == "0" || utf8_decode($rowAntecedentes[0]["audiotra"]) == 0){
                $pAuditivoOtro = "NO";
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- HIPOACUSIA (Audiometria)</b>:&nbsp;' . $pHipoAcusia . ',&nbsp;&nbsp;<b>OTOPATIA CRONICA INFECCIONSA:</b>&nbsp;' . $pOtopatia . ',&nbsp;&nbsp;<b>OTROS</b>:&nbsp;' . $pAuditivoOtro . ',&nbsp;&nbsp;<b>ESPECIFIQUE</b>:&nbsp;' . utf8_decode($rowAntecedentes[0]["audiotraespecifique"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>- SISTEMA VESTIBULAR</b>:&nbsp;</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $pNeuronitis = "SI";
            if(utf8_decode($rowAntecedentes[0]["neuroni"]) == "0" || utf8_decode($rowAntecedentes[0]["neuroni"]) == 0){
                $pNeuronitis = "NO";
            }
            $pVertigoParoxistico = "SI";
            if(utf8_decode($rowAntecedentes[0]["vppb"]) == "0" || utf8_decode($rowAntecedentes[0]["vppb"]) == 0){
                $pVertigoParoxistico = "NO";
            }
            $pVestivularOtra = "SI";
            if(utf8_decode($rowAntecedentes[0]["vest_otr"]) == "0" || utf8_decode($rowAntecedentes[0]["vest_otr"]) == 0){
                $pVestivularOtra = "NO";
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- NEURONITIS VESTIBULAR</b>:&nbsp;' . $pNeuronitis . ',&nbsp;&nbsp;<b>VERTIGO POSICIONAL PAROXISTICO BENIGNO:</b>&nbsp;' . $pVertigoParoxistico . ',&nbsp;&nbsp;<b>OTROS</b>:&nbsp;' . $pVestivularOtra . ',&nbsp;&nbsp;<b>ESPECIFIQUE</b>:&nbsp;' . utf8_decode($rowAntecedentes[0]["vest_otrespecifique"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>- SISTEMA VISUAL</b>:&nbsp;</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $pTranstornoRefraccion = "SI";
            if(utf8_decode($rowAntecedentes[0]["refracc"]) == "0" || utf8_decode($rowAntecedentes[0]["refracc"]) == 0){
                $pTranstornoRefraccion = "NO";
            }
            $pTranstornoRefraccionCorreccion = "SI";
            if(utf8_decode($rowAntecedentes[0]["refracccorrec"]) == "0" || utf8_decode($rowAntecedentes[0]["refracccorrec"]) == 0){
                $pTranstornoRefraccionCorreccion = "NO";
            }
            $pCataratas = "SI";
            if(utf8_decode($rowAntecedentes[0]["Cataratas"]) == "0" || utf8_decode($rowAntecedentes[0]["Cataratas"]) == 0){
                $pCataratas = "NO";
            }
            $pGlaucoma = "SI";
            if(utf8_decode($rowAntecedentes[0]["Glaucoma"]) == "0" || utf8_decode($rowAntecedentes[0]["Glaucoma"]) == 0){
                $pGlaucoma = "NO";
            }
            $pRetinopatia = "SI";
            if(utf8_decode($rowAntecedentes[0]["RetinopatiaDiabetica"]) == "0" || utf8_decode($rowAntecedentes[0]["RetinopatiaDiabetica"]) == 0){
                $pRetinopatia = "NO";
            }
            $pDegeneracionMacular = "SI";
            if(utf8_decode($rowAntecedentes[0]["DegeneracionMacular"]) == "0" || utf8_decode($rowAntecedentes[0]["DegeneracionMacular"]) == 0){
                $pDegeneracionMacular = "NO";
            }
            $pVisualOtro = "SI";
            if(utf8_decode($rowAntecedentes[0]["vis_otra"]) == "0" || utf8_decode($rowAntecedentes[0]["vis_otra"]) == 0){
                $pVisualOtro = "NO";
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- TRANSTORNO DE REFRACCION</b>:&nbsp;' . $pTranstornoRefraccion . ',&nbsp;&nbsp;<b>CON CORRECCION:</b>&nbsp;' . $pTranstornoRefraccionCorreccion . ',&nbsp;&nbsp;<b>CATARATAS</b>:&nbsp;' . $pCataratas . ',&nbsp;&nbsp;<b>GLAUCOMA</b>:&nbsp;' . $pGlaucoma . ',&nbsp;&nbsp;<b>RETINOPATIA DIABETICA</b>:&nbsp;' . $pRetinopatia . ',&nbsp;&nbsp;<b>DEGENERACION MACULAR</b>:&nbsp;' . $pDegeneracionMacular . ',&nbsp;&nbsp;<b>OTROS</b>:&nbsp;' . $pVisualOtro . ',&nbsp;&nbsp;<b>ESPECIFIQUE</b>:&nbsp;' . utf8_decode($rowAntecedentes[0]["vis_otraespecifique"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>- CARDIOVASCULAR</b>:&nbsp;</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $pHTA = "SI";
            if(utf8_decode($rowAntecedentes[0]["HTA"]) == "0" || utf8_decode($rowAntecedentes[0]["HTA"]) == 0){
                $pHTA = "NO";
            }
            $pIMA = "SI";
            if(utf8_decode($rowAntecedentes[0]["IMA"]) == "0" || utf8_decode($rowAntecedentes[0]["IMA"]) == 0){
                $pIMA = "NO";
            }
            $pInsuficienciaCardiaca = "SI";
            if(utf8_decode($rowAntecedentes[0]["InsuficienciaCardiaca"]) == "0" || utf8_decode($rowAntecedentes[0]["InsuficienciaCardiaca"]) == 0){
                $pInsuficienciaCardiaca = "NO";
            }
            $pAngorPectoris = "SI";
            if(utf8_decode($rowAntecedentes[0]["AngorPectoris"]) == "0" || utf8_decode($rowAntecedentes[0]["AngorPectoris"]) == 0){
                $pAngorPectoris = "NO";
            }
            $pArritmias = "SI";
            if(utf8_decode($rowAntecedentes[0]["Arritmias"]) == "0" || utf8_decode($rowAntecedentes[0]["Arritmias"]) == 0){
                $pArritmias = "NO";
            }
            $pCardiovascularOtros = "SI";
            if(utf8_decode($rowAntecedentes[0]["otroscv"]) == "0" || utf8_decode($rowAntecedentes[0]["otroscv"]) == 0){
                $pCardiovascularOtros = "NO";
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- H.T.A.</b>:&nbsp;' . $pHTA . ',&nbsp;&nbsp;<b>I.M.A.:</b>&nbsp;' . $pIMA . ',&nbsp;&nbsp;<b>INSUFICIENCIA CARDIACA</b>:&nbsp;' . $pInsuficienciaCardiaca . ',&nbsp;&nbsp;<b>ANGOR PECTORIS</b>:&nbsp;' . $pAngorPectoris . ',&nbsp;&nbsp;<b>ARRITMIAS</b>:&nbsp;' . $pArritmias . ',&nbsp;&nbsp;<b>OTROS</b>:&nbsp;' . $pCardiovascularOtros  . ',&nbsp;&nbsp;<b>ESPECIFIQUE</b>:&nbsp;' . utf8_decode($rowAntecedentes[0]["otroscvespecifique"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            
            
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>- SISTEMA PULMONAR</b>:&nbsp;</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $pEPOC = "SI";
            if(utf8_decode($rowAntecedentes[0]["Epoc"]) == "0" || utf8_decode($rowAntecedentes[0]["Epoc"]) == 0){
                $pEPOC = "NO";
            }
            $pTBC = "SI";
            if(utf8_decode($rowAntecedentes[0]["Tbc"]) == "0" || utf8_decode($rowAntecedentes[0]["Tbc"]) == 0){
                $pTBC = "NO";
            }
            $pNeumoconiosis = "SI";
            if(utf8_decode($rowAntecedentes[0]["Neumoconiosis"]) == "0" || utf8_decode($rowAntecedentes[0]["Neumoconiosis"]) == 0){
                $pNeumoconiosis = "NO";
            }
            $pNeumonia = "SI";
            if(utf8_decode($rowAntecedentes[0]["Neumonia"]) == "0" || utf8_decode($rowAntecedentes[0]["Neumonia"]) == 0){
                $pNeumonia = "NO";
            }
            $pAsma = "SI";
            if(utf8_decode($rowAntecedentes[0]["Asma"]) == "0" || utf8_decode($rowAntecedentes[0]["Asma"]) == 0){
                $pAsma = "NO";
            }
            $pPulmonarOtro = "SI";
            if(utf8_decode($rowAntecedentes[0]["otrospulmon"]) == "0" || utf8_decode($rowAntecedentes[0]["otrospulmon"]) == 0){
                $pPulmonarOtro = "NO";
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- E.P.O.C.</b>:&nbsp;' . $pEPOC . ',&nbsp;&nbsp;<b>T.B.C.:</b>&nbsp;' . $pTBC . ',&nbsp;&nbsp;<b>NEUMOCONIOSIS</b>:&nbsp;' . $pNeumoconiosis . ',&nbsp;&nbsp;<b>NEUMONIA</b>:&nbsp;' . $pNeumonia . ',&nbsp;&nbsp;<b>ASMA</b>:&nbsp;' . $pAsma . ',&nbsp;&nbsp;<b>OTROS</b>:&nbsp;' . $pPulmonarOtro  . ',&nbsp;&nbsp;<b>ESPECIFIQUE</b>:&nbsp;' . utf8_decode($rowAntecedentes[0]["otrospulmonespecifique"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            
            
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>- SISTEMA OSTEOARTICULAR</b>:&nbsp;</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $pOsteoArtritis = "SI";
            if(utf8_decode($rowAntecedentes[0]["Osteoartritis"]) == "0" || utf8_decode($rowAntecedentes[0]["Osteoartritis"]) == 0){
                $pOsteoArtritis = "NO";
            }
            $pAR = "SI";
            if(utf8_decode($rowAntecedentes[0]["AR"]) == "0" || utf8_decode($rowAntecedentes[0]["AR"]) == 0){
                $pAR = "NO";
            }
            $pOsteoporosis = "SI";
            if(utf8_decode($rowAntecedentes[0]["Osteoporosis"]) == "0" || utf8_decode($rowAntecedentes[0]["Osteoporosis"]) == 0){
                $pOsteoporosis = "NO";
            }
            $pOtrosOsteoarticular = "SI";
            if(utf8_decode($rowAntecedentes[0]["otrososteomuscular"]) == "0" || utf8_decode($rowAntecedentes[0]["otrososteomuscular"]) == 0){
                $pOtrosOsteoarticular = "NO";
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- OSTEOARTRITIS</b>:&nbsp;' . $pOsteoArtritis . ',&nbsp;&nbsp;<b>A.R</b>:&nbsp;' . $pAR . ',&nbsp;&nbsp;<b>OSTEOPOROSIS</b>:&nbsp;' . $pOsteoporosis . ',&nbsp;&nbsp;<b>OTROS</b>:&nbsp;' . $pOtrosOsteoarticular  . ',&nbsp;&nbsp;<b>ESPECIFIQUE</b>:&nbsp;' . utf8_decode($rowAntecedentes[0]["otrososteomuscularespecifique"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>- SISTEMA ENDOCRINO</b>:&nbsp;</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $pDiabetesmellitus = "SI";
            if(utf8_decode($rowAntecedentes[0]["DiabetesMellitus"]) == "0" || utf8_decode($rowAntecedentes[0]["DiabetesMellitus"]) == 0){
                $pDiabetesmellitus = "NO";
            }
            $pHipotiroidismo = "SI";
            if(utf8_decode($rowAntecedentes[0]["Hipotiroidismo"]) == "0" || utf8_decode($rowAntecedentes[0]["Hipotiroidismo"]) == 0){
                $pHipotiroidismo = "NO";
            }
            $pHipertiroidismo = "SI";
            if(utf8_decode($rowAntecedentes[0]["Hipertiroidismo"]) == "0" || utf8_decode($rowAntecedentes[0]["Hipertiroidismo"]) == 0){
                $pHipertiroidismo = "NO";
            }
            $pDislipoproteinemia = "SI";
            if(utf8_decode($rowAntecedentes[0]["Dislipoproteinemia"]) == "0" || utf8_decode($rowAntecedentes[0]["Dislipoproteinemia"]) == 0){
                $pDislipoproteinemia = "NO";
            }
            $pHiperuricemia = "SI";
            if(utf8_decode($rowAntecedentes[0]["Hiperuricemia"]) == "0" || utf8_decode($rowAntecedentes[0]["Hiperuricemia"]) == 0){
                $pHiperuricemia = "NO";
            }
            $pOtrosEndocrino = "SI";
            if(utf8_decode($rowAntecedentes[0]["otrosoendocrino"]) == "0" || utf8_decode($rowAntecedentes[0]["otrosoendocrino"]) == 0){
                $pOtrosEndocrino = "NO";
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- DIABETES</b>:&nbsp;' . $pDiabetesmellitus . ',&nbsp;&nbsp;<b>HIPOTIROIDISMO</b>:&nbsp;' . $pHipotiroidismo . ',&nbsp;&nbsp;<b>HIPERTIROIDISMO</b>:&nbsp;' . $pHipertiroidismo . ',&nbsp;&nbsp;<b>DISLIPOPROTEINEMIA</b>:&nbsp;' . $pDislipoproteinemia . ',&nbsp;&nbsp;<b>HIPERURICEMIA</b>:&nbsp;' . $pHiperuricemia . ',</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;OTROS</b>:&nbsp;' . $pOtrosEndocrino  . ',&nbsp;&nbsp;<b>ESPECIFIQUE</b>:&nbsp;' . utf8_decode($rowAntecedentes[0]["otrosoendocrinoespecifique"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>- SISTEMA NEUROLOGICO</b>:&nbsp;</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $pEnfermedadCerebroVascular = "SI";
            if(utf8_decode($rowAntecedentes[0]["EnfermedadCerebroVascular"]) == "0" || utf8_decode($rowAntecedentes[0]["EnfermedadCerebroVascular"]) == 0){
                $pEnfermedadCerebroVascular = "NO";
            }
            $pSxVertiginoso = "SI";
            if(utf8_decode($rowAntecedentes[0]["SxVertiginoso"]) == "0" || utf8_decode($rowAntecedentes[0]["SxVertiginoso"]) == 0){
                $pSxVertiginoso = "NO";
            }
            $pIsquemiaCerebralTransitoria = "SI";
            if(utf8_decode($rowAntecedentes[0]["IsquemiaCerebralTransitoria"]) == "0" || utf8_decode($rowAntecedentes[0]["IsquemiaCerebralTransitoria"]) == 0){
                $pIsquemiaCerebralTransitoria = "NO";
            }
            $pDelirium = "SI";
            if(utf8_decode($rowAntecedentes[0]["Delirium"]) == "0" || utf8_decode($rowAntecedentes[0]["Delirium"]) == 0){
                $pDelirium = "NO";
            }
            $pNeuropatias = "SI";
            if(utf8_decode($rowAntecedentes[0]["Neuropatias"]) == "0" || utf8_decode($rowAntecedentes[0]["Neuropatias"]) == 0){
                $pNeuropatias = "NO";
            }
            $pDemencia = "SI";
            if(utf8_decode($rowAntecedentes[0]["Demencia"]) == "0" || utf8_decode($rowAntecedentes[0]["Demencia"]) == 0){
                $pDemencia = "NO";
            }
            $pEnfParkinson = "SI";
            if(utf8_decode($rowAntecedentes[0]["Parkinson"]) == "0" || utf8_decode($rowAntecedentes[0]["Parkinson"]) == 0){
                $pEnfParkinson = "NO";
            }
            $pOtrosNeurologico = "SI";
            if(utf8_decode($rowAntecedentes[0]["otrosneurologico"]) == "0" || utf8_decode($rowAntecedentes[0]["otrosneurologico"]) == 0){
                $pOtrosNeurologico = "NO";
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- ENF. CEREBRO VASCULAR</b>:&nbsp;' . $pEnfermedadCerebroVascular . ',&nbsp;&nbsp;<b>SX. VERTIGINOSO</b>:&nbsp;' . $pSxVertiginoso . ',&nbsp;&nbsp;<b>ISQU. CEREBRAL TRANSITORIA</b>:&nbsp;' . $pIsquemiaCerebralTransitoria . ',&nbsp;&nbsp;<b>DELIRIUM</b>:&nbsp;' . $pDelirium . ',&nbsp;&nbsp;<b>NEUROPATIAS</b>:&nbsp;' . $pNeuropatias . ',</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;DEMENCIA</b>:&nbsp;' . $pDemencia  . ',&nbsp;&nbsp;<b>ENF. PARKINSON</b>:&nbsp;' . $pEnfParkinson . ',&nbsp;&nbsp;<b>OTROS</b>:&nbsp;' . $pOtrosNeurologico . ',&nbsp;&nbsp;<b>ESPECIFIQUE</b>:&nbsp;' . utf8_decode($rowAntecedentes[0]["otrosneurologicoespecifique"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>- OTROS</b>:&nbsp;</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $pAnemia = "SI";
            if(utf8_decode($rowAntecedentes[0]["Anemias"]) == "0" || utf8_decode($rowAntecedentes[0]["Anemias"]) == 0){
                $pAnemia = "NO";
            }
            $pNeoplasia = "SI";
            if(utf8_decode($rowAntecedentes[0]["Neoplasias"]) == "0" || utf8_decode($rowAntecedentes[0]["Neoplasias"]) == 0){
                $pNeoplasia = "NO";
            }
            $pOtrosOtros = "SI";
            if(utf8_decode($rowAntecedentes[0]["AntOtrosEspecificar"]) == "0" || utf8_decode($rowAntecedentes[0]["AntOtrosEspecificar"]) == 0){
                $pOtrosOtros = "NO";
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- ANEMIA</b>:&nbsp;' . $pAnemia . ',&nbsp;&nbsp;<b>NEOPLASIA</b>:&nbsp;' . $pNeoplasia . ',&nbsp;&nbsp;si Si, Sitio:&nbsp;' . utf8_decode($rowAntecedentes[0]["NeoplasiasSitio"]) . ',&nbsp;&nbsp;<b>OTROS</b>:&nbsp;' . $pOtrosOtros . '</span><br><br>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>ANTECEDENTES QUIRURGICOS Y TRAUMATICOS</b>:&nbsp;</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $pQuirurgicos = "SI";
            if(utf8_decode($rowAntecedentes[0]["Quirurgicos"]) == "0" || utf8_decode($rowAntecedentes[0]["Quirurgicos"]) == 0){
                $pQuirurgicos = "NO";
            }
            $pQuirurgicosE = "";
            if(utf8_decode($rowAntecedentes[0]["QuirurgicosEspecifique"]) != "" && utf8_decode($rowAntecedentes[0]["QuirurgicosEspecifique"]) != null){
                $pQuirurgicosE = " - " . utf8_decode($rowAntecedentes[0]["QuirurgicosEspecifique"]);
            }
            $pTraumaticos = "SI";
            if(utf8_decode($rowAntecedentes[0]["Traumatologicos"]) == "0" || utf8_decode($rowAntecedentes[0]["Traumatologicos"]) == 0){
                $pTraumaticos = "NO";
            }
            $pTraumaticosE = "";
            if(utf8_decode($rowAntecedentes[0]["TraumatologicosEspecifique"]) != "" && utf8_decode($rowAntecedentes[0]["TraumatologicosEspecifique"]) != null){
                $pTraumaticosE = " - " . utf8_decode($rowAntecedentes[0]["TraumatologicosEspecifique"]);
            }
            $pHospitalizaciones = "SI";
            if(utf8_decode($rowAntecedentes[0]["Hospitalizaciones"]) == "0" || utf8_decode($rowAntecedentes[0]["Hospitalizaciones"]) == 0){
                $pHospitalizaciones = "NO";
            }
            $pInstitucionalizacion = "SI";
            if(utf8_decode($rowAntecedentes[0]["Institucionalizacion"]) == "0" || utf8_decode($rowAntecedentes[0]["Institucionalizacion"]) == 0){
                $pInstitucionalizacion = "NO";
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- QUIRURGICOS</b>:&nbsp;' . $pQuirurgicos . $pQuirurgicosE . ',&nbsp;&nbsp;<b>TRAUMATICOS</b>:&nbsp;' . $pTraumaticos . $pTraumaticosE . ',&nbsp;&nbsp;<b>HOSPITALIZACIONES</b>:&nbsp;' . $pHospitalizaciones . '.&nbsp;&nbsp;N. Veces en el ultimo año:&nbsp;' . utf8_decode($rowAntecedentes[0]["HospVecesUltAnio"]) . '.&nbsp;&nbsp;Razon de la Hospitalizacion:&nbsp;' . utf8_decode($rowAntecedentes[0]["RazonHospitalizacion"]) . '.&nbsp;&nbsp;Promedio de dias de hospitalizacion:&nbsp;' . utf8_decode($rowAntecedentes[0]["PromedioDiasHosp"]) . '</span><br><br>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>INSTITUCIONALIZACION</b>:&nbsp;' . $pInstitucionalizacion . '</span><br><br>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>ANTECEDENTES HEREDO FAMILIARES</b>:&nbsp;' . utf8_decode($rowAntecedentes[0]["AntecedentesHeredoFamilaires"]) . '</span><br><br>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            unset($rowFarmacologico);
            $gBaseDatos = new ofiMySQLi();
            $gBaseDatos->conectar();
            $qry = "CALL sp_asistencial_civyc_printhc_04('" . $pEvolucion . "')";
            $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
            while ($rowFarmacologico[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
            $gBaseDatos->liberar();
            $gBaseDatos->cerrar();
            
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>HISTORIA FARMACOLOGICA</b>:&nbsp;</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            //JORGE
            if(utf8_decode($rowFarmacologico[0]["BenzodiacepinasNombre_1"]) != "" || utf8_decode($rowFarmacologico[0]["BenzodiacepinasNombre_1"]) != null || utf8_decode($rowFarmacologico[0]["BenzodiacepinasNombre_2"]) != "" || utf8_decode($rowFarmacologico[0]["BenzodiacepinasNombre_2"]) != null || utf8_decode($rowFarmacologico[0]["BenzodiacepinasNombre_3"]) != "" || utf8_decode($rowFarmacologico[0]["BenzodiacepinasNombre_3"]) != null || utf8_decode($rowFarmacologico[0]["BenzodiacepinasNombre_4"]) != "" || utf8_decode($rowFarmacologico[0]["BenzodiacepinasNombre_4"]) != null || utf8_decode($rowFarmacologico[0]["BenzodiacepinasNombre_5"]) != "" || utf8_decode($rowFarmacologico[0]["BenzodiacepinasNombre_5"]) != null){
                $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- SEDANTES BENZODIACEPINAS</b>:</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
                if(utf8_decode($rowFarmacologico[0]["BenzodiacepinasNombre_1"]) != "" || utf8_decode($rowFarmacologico[0]["BenzodiacepinasNombre_1"])){
                    $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- NOMBRE</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["BenzodiacepinasNombre_1"]) . ',&nbsp;&nbsp;<b>DOSIS</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["BenzodiacepinasDosis_1"]) . ',&nbsp;&nbsp;<b>TIPO</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["BenzodiacepinasPrescrito_1"]) . '</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
                if(utf8_decode($rowFarmacologico[0]["BenzodiacepinasNombre_2"]) != "" || utf8_decode($rowFarmacologico[0]["BenzodiacepinasNombre_2"])){
                    $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- NOMBRE</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["BenzodiacepinasNombre_2"]) . ',&nbsp;&nbsp;<b>DOSIS</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["BenzodiacepinasDosis_2"]) . ',&nbsp;&nbsp;<b>TIPO</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["BenzodiacepinasPrescrito_2"]) . '</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
                if(utf8_decode($rowFarmacologico[0]["BenzodiacepinasNombre_3"]) != "" || utf8_decode($rowFarmacologico[0]["BenzodiacepinasNombre_3"])){
                    $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- NOMBRE</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["BenzodiacepinasNombre_3"]) . ',&nbsp;&nbsp;<b>DOSIS</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["BenzodiacepinasDosis_3"]) . ',&nbsp;&nbsp;<b>TIPO</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["BenzodiacepinasPrescrito_3"]) . '</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
                if(utf8_decode($rowFarmacologico[0]["BenzodiacepinasNombre_4"]) != "" || utf8_decode($rowFarmacologico[0]["BenzodiacepinasNombre_4"])){
                    $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- NOMBRE</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["BenzodiacepinasNombre_4"]) . ',&nbsp;&nbsp;<b>DOSIS</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["BenzodiacepinasDosis_4"]) . ',&nbsp;&nbsp;<b>TIPO</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["BenzodiacepinasPrescrito_4"]) . '</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
                if(utf8_decode($rowFarmacologico[0]["BenzodiacepinasNombre_|"]) != "" || utf8_decode($rowFarmacologico[0]["BenzodiacepinasNombre_5"])){
                    $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- NOMBRE</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["BenzodiacepinasNombre_5"]) . ',&nbsp;&nbsp;<b>DOSIS</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["BenzodiacepinasDosis_5"]) . ',&nbsp;&nbsp;<b>TIPO</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["BenzodiacepinasPrescrito_5"]) . '</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
            }
            
            if(utf8_decode($rowFarmacologico[0]["AntipsicoticoNombre_1"]) != "" || utf8_decode($rowFarmacologico[0]["AntipsicoticoNombre_1"]) != null || utf8_decode($rowFarmacologico[0]["AntipsicoticoNombre_2"]) != "" || utf8_decode($rowFarmacologico[0]["AntipsicoticoNombre_2"]) != null || utf8_decode($rowFarmacologico[0]["AntipsicoticoNombre_3"]) != "" || utf8_decode($rowFarmacologico[0]["AntipsicoticoNombre_3"]) != null || utf8_decode($rowFarmacologico[0]["AntipsicoticoNombre_4"]) != "" || utf8_decode($rowFarmacologico[0]["AntipsicoticoNombre_4"]) != null || utf8_decode($rowFarmacologico[0]["AntipsicoticoNombre_5"]) != "" || utf8_decode($rowFarmacologico[0]["AntipsicoticoNombre_5"]) != null){
                $mostrarHC = '<br>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
                $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- ANTIPSICOTICOS</b>:</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
                if(utf8_decode($rowFarmacologico[0]["AntipsicoticoNombre_1"]) != "" || utf8_decode($rowFarmacologico[0]["AntipsicoticoNombre_1"])){
                    $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- NOMBRE</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AntipsicoticoNombre_1"]) . ',&nbsp;&nbsp;<b>DOSIS</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AntipsicoticoDosis_1"]) . ',&nbsp;&nbsp;<b>TIPO</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AntipsicoticoPrescrito_1"]) . '</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
                if(utf8_decode($rowFarmacologico[0]["AntipsicoticoNombre_2"]) != "" || utf8_decode($rowFarmacologico[0]["AntipsicoticoNombre_2"])){
                    $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- NOMBRE</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AntipsicoticoNombre_2"]) . ',&nbsp;&nbsp;<b>DOSIS</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AntipsicoticoDosis_2"]) . ',&nbsp;&nbsp;<b>TIPO</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AntipsicoticoPrescrito_2"]) . '</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
                if(utf8_decode($rowFarmacologico[0]["AntipsicoticoNombre_3"]) != "" || utf8_decode($rowFarmacologico[0]["AntipsicoticoNombre_3"])){
                    $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- NOMBRE</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AntipsicoticoNombre_3"]) . ',&nbsp;&nbsp;<b>DOSIS</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AntipsicoticoDosis_3"]) . ',&nbsp;&nbsp;<b>TIPO</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AntipsicoticoPrescrito_3"]) . '</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
                if(utf8_decode($rowFarmacologico[0]["AntipsicoticoNombre_4"]) != "" || utf8_decode($rowFarmacologico[0]["AntipsicoticoNombre_4"])){
                    $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- NOMBRE</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AntipsicoticoNombre_4"]) . ',&nbsp;&nbsp;<b>DOSIS</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AntipsicoticoDosis_4"]) . ',&nbsp;&nbsp;<b>TIPO</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AntipsicoticoPrescrito_4"]) . '</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
                if(utf8_decode($rowFarmacologico[0]["AntipsicoticoNombre_|"]) != "" || utf8_decode($rowFarmacologico[0]["AntipsicoticoNombre_5"])){
                    $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- NOMBRE</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AntipsicoticoNombre_5"]) . ',&nbsp;&nbsp;<b>DOSIS</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AntipsicoticoDosis_5"]) . ',&nbsp;&nbsp;<b>TIPO</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AntipsicoticoPrescrito_5"]) . '</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
            }
            
            if(utf8_decode($rowFarmacologico[0]["AnticonvulsivantesNombre_1"]) != "" || utf8_decode($rowFarmacologico[0]["AnticonvulsivantesNombre_1"]) != null || utf8_decode($rowFarmacologico[0]["AnticonvulsivantesNombre_2"]) != "" || utf8_decode($rowFarmacologico[0]["AnticonvulsivantesNombre_2"]) != null || utf8_decode($rowFarmacologico[0]["AnticonvulsivantesNombre_3"]) != "" || utf8_decode($rowFarmacologico[0]["AnticonvulsivantesNombre_3"]) != null || utf8_decode($rowFarmacologico[0]["AnticonvulsivantesNombre_4"]) != "" || utf8_decode($rowFarmacologico[0]["AnticonvulsivantesNombre_4"]) != null || utf8_decode($rowFarmacologico[0]["AnticonvulsivantesNombre_5"]) != "" || utf8_decode($rowFarmacologico[0]["AnticonvulsivantesNombre_5"]) != null){
                $mostrarHC = '<br>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
                $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- ANTICONVULSIVANTES</b>:</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
                if(utf8_decode($rowFarmacologico[0]["AnticonvulsivantesNombre_1"]) != "" || utf8_decode($rowFarmacologico[0]["AnticonvulsivantesNombre_1"])){
                    $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- NOMBRE</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AnticonvulsivantesNombre_1"]) . ',&nbsp;&nbsp;<b>DOSIS</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AnticonvulsivantesDosis_1"]) . ',&nbsp;&nbsp;<b>TIPO</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AnticonvulsivantesPrescrito_1"]) . '</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
                if(utf8_decode($rowFarmacologico[0]["AnticonvulsivantesNombre_2"]) != "" || utf8_decode($rowFarmacologico[0]["AnticonvulsivantesNombre_2"])){
                    $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- NOMBRE</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AnticonvulsivantesNombre_2"]) . ',&nbsp;&nbsp;<b>DOSIS</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AnticonvulsivantesDosis_2"]) . ',&nbsp;&nbsp;<b>TIPO</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AnticonvulsivantesPrescrito_2"]) . '</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
                if(utf8_decode($rowFarmacologico[0]["AnticonvulsivantesNombre_3"]) != "" || utf8_decode($rowFarmacologico[0]["AnticonvulsivantesNombre_3"])){
                    $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- NOMBRE</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AnticonvulsivantesNombre_3"]) . ',&nbsp;&nbsp;<b>DOSIS</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AnticonvulsivantesDosis_3"]) . ',&nbsp;&nbsp;<b>TIPO</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AnticonvulsivantesPrescrito_3"]) . '</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
                if(utf8_decode($rowFarmacologico[0]["AnticonvulsivantesNombre_4"]) != "" || utf8_decode($rowFarmacologico[0]["AnticonvulsivantesNombre_4"])){
                    $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- NOMBRE</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AnticonvulsivantesNombre_4"]) . ',&nbsp;&nbsp;<b>DOSIS</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AnticonvulsivantesDosis_4"]) . ',&nbsp;&nbsp;<b>TIPO</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AnticonvulsivantesPrescrito_4"]) . '</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
                if(utf8_decode($rowFarmacologico[0]["AnticonvulsivantesNombre_|"]) != "" || utf8_decode($rowFarmacologico[0]["AnticonvulsivantesNombre_5"])){
                    $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- NOMBRE</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AnticonvulsivantesNombre_5"]) . ',&nbsp;&nbsp;<b>DOSIS</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AnticonvulsivantesDosis_5"]) . ',&nbsp;&nbsp;<b>TIPO</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AnticonvulsivantesPrescrito_5"]) . '</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
            }
            
            if(utf8_decode($rowFarmacologico[0]["AntidepresivosNombre_1"]) != "" || utf8_decode($rowFarmacologico[0]["AntidepresivosNombre_1"]) != null || utf8_decode($rowFarmacologico[0]["AntidepresivosNombre_2"]) != "" || utf8_decode($rowFarmacologico[0]["AntidepresivosNombre_2"]) != null || utf8_decode($rowFarmacologico[0]["AntidepresivosNombre_3"]) != "" || utf8_decode($rowFarmacologico[0]["AntidepresivosNombre_3"]) != null || utf8_decode($rowFarmacologico[0]["AntidepresivosNombre_4"]) != "" || utf8_decode($rowFarmacologico[0]["AntidepresivosNombre_4"]) != null || utf8_decode($rowFarmacologico[0]["AntidepresivosNombre_5"]) != "" || utf8_decode($rowFarmacologico[0]["AntidepresivosNombre_5"]) != null){
                $mostrarHC = '<br>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
                $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- ANTIDEPRESIVOS</b>:</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
                if(utf8_decode($rowFarmacologico[0]["AntidepresivosNombre_1"]) != "" || utf8_decode($rowFarmacologico[0]["AntidepresivosNombre_1"])){
                    $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- NOMBRE</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AntidepresivosNombre_1"]) . ',&nbsp;&nbsp;<b>DOSIS</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AntidepresivosDosis_1"]) . ',&nbsp;&nbsp;<b>TIPO</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AntidepresivosPrescrito_1"]) . '</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
                if(utf8_decode($rowFarmacologico[0]["AntidepresivosNombre_2"]) != "" || utf8_decode($rowFarmacologico[0]["AntidepresivosNombre_2"])){
                    $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- NOMBRE</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AntidepresivosNombre_2"]) . ',&nbsp;&nbsp;<b>DOSIS</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AntidepresivosDosis_2"]) . ',&nbsp;&nbsp;<b>TIPO</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AntidepresivosPrescrito_2"]) . '</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
                if(utf8_decode($rowFarmacologico[0]["AntidepresivosNombre_3"]) != "" || utf8_decode($rowFarmacologico[0]["AntidepresivosNombre_3"])){
                    $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- NOMBRE</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AntidepresivosNombre_3"]) . ',&nbsp;&nbsp;<b>DOSIS</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AntidepresivosDosis_3"]) . ',&nbsp;&nbsp;<b>TIPO</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AntidepresivosPrescrito_3"]) . '</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
                if(utf8_decode($rowFarmacologico[0]["AntidepresivosNombre_4"]) != "" || utf8_decode($rowFarmacologico[0]["AntidepresivosNombre_4"])){
                    $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- NOMBRE</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AntidepresivosNombre_4"]) . ',&nbsp;&nbsp;<b>DOSIS</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AntidepresivosDosis_4"]) . ',&nbsp;&nbsp;<b>TIPO</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AntidepresivosPrescrito_4"]) . '</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
                if(utf8_decode($rowFarmacologico[0]["AntidepresivosNombre_|"]) != "" || utf8_decode($rowFarmacologico[0]["AntidepresivosNombre_5"])){
                    $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- NOMBRE</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AntidepresivosNombre_5"]) . ',&nbsp;&nbsp;<b>DOSIS</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AntidepresivosDosis_5"]) . ',&nbsp;&nbsp;<b>TIPO</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AntidepresivosPrescrito_5"]) . '</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
            }
            
            if(utf8_decode($rowFarmacologico[0]["AntiarritmicosNombre_1"]) != "" || utf8_decode($rowFarmacologico[0]["AntiarritmicosNombre_1"]) != null || utf8_decode($rowFarmacologico[0]["AntiarritmicosNombre_2"]) != "" || utf8_decode($rowFarmacologico[0]["AntiarritmicosNombre_2"]) != null || utf8_decode($rowFarmacologico[0]["AntiarritmicosNombre_3"]) != "" || utf8_decode($rowFarmacologico[0]["AntiarritmicosNombre_3"]) != null || utf8_decode($rowFarmacologico[0]["AntiarritmicosNombre_4"]) != "" || utf8_decode($rowFarmacologico[0]["AntiarritmicosNombre_4"]) != null || utf8_decode($rowFarmacologico[0]["AntiarritmicosNombre_5"]) != "" || utf8_decode($rowFarmacologico[0]["AntiarritmicosNombre_5"]) != null){
                $mostrarHC = '<br>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
                $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- ANTIARRITMICOS</b>:</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
                if(utf8_decode($rowFarmacologico[0]["AntiarritmicosNombre_1"]) != "" || utf8_decode($rowFarmacologico[0]["AntiarritmicosNombre_1"])){
                    $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- NOMBRE</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AntiarritmicosNombre_1"]) . ',&nbsp;&nbsp;<b>DOSIS</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AntiarritmicosDosis_1"]) . ',&nbsp;&nbsp;<b>TIPO</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AntiarritmicosPrescrito_1"]) . '</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
                if(utf8_decode($rowFarmacologico[0]["AntiarritmicosNombre_2"]) != "" || utf8_decode($rowFarmacologico[0]["AntiarritmicosNombre_2"])){
                    $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- NOMBRE</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AntiarritmicosNombre_2"]) . ',&nbsp;&nbsp;<b>DOSIS</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AntiarritmicosDosis_2"]) . ',&nbsp;&nbsp;<b>TIPO</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AntiarritmicosPrescrito_2"]) . '</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
                if(utf8_decode($rowFarmacologico[0]["AntiarritmicosNombre_3"]) != "" || utf8_decode($rowFarmacologico[0]["AntiarritmicosNombre_3"])){
                    $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- NOMBRE</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AntiarritmicosNombre_3"]) . ',&nbsp;&nbsp;<b>DOSIS</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AntiarritmicosDosis_3"]) . ',&nbsp;&nbsp;<b>TIPO</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AntiarritmicosPrescrito_3"]) . '</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
                if(utf8_decode($rowFarmacologico[0]["AntiarritmicosNombre_4"]) != "" || utf8_decode($rowFarmacologico[0]["AntiarritmicosNombre_4"])){
                    $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- NOMBRE</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AntiarritmicosNombre_4"]) . ',&nbsp;&nbsp;<b>DOSIS</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AntiarritmicosDosis_4"]) . ',&nbsp;&nbsp;<b>TIPO</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AntiarritmicosPrescrito_4"]) . '</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
                if(utf8_decode($rowFarmacologico[0]["AntiarritmicosNombre_|"]) != "" || utf8_decode($rowFarmacologico[0]["AntiarritmicosNombre_5"])){
                    $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- NOMBRE</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AntiarritmicosNombre_5"]) . ',&nbsp;&nbsp;<b>DOSIS</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AntiarritmicosDosis_5"]) . ',&nbsp;&nbsp;<b>TIPO</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AntiarritmicosPrescrito_5"]) . '</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
            }
            
            if(utf8_decode($rowFarmacologico[0]["AntihipertensivosNombre_1"]) != "" || utf8_decode($rowFarmacologico[0]["AntihipertensivosNombre_1"]) != null || utf8_decode($rowFarmacologico[0]["AntihipertensivosNombre_2"]) != "" || utf8_decode($rowFarmacologico[0]["AntihipertensivosNombre_2"]) != null || utf8_decode($rowFarmacologico[0]["AntihipertensivosNombre_3"]) != "" || utf8_decode($rowFarmacologico[0]["AntihipertensivosNombre_3"]) != null || utf8_decode($rowFarmacologico[0]["AntihipertensivosNombre_4"]) != "" || utf8_decode($rowFarmacologico[0]["AntihipertensivosNombre_4"]) != null || utf8_decode($rowFarmacologico[0]["AntihipertensivosNombre_5"]) != "" || utf8_decode($rowFarmacologico[0]["AntihipertensivosNombre_5"]) != null){
                $mostrarHC = '<br>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
                $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- ANTIHIPERTENSIVOS</b>:</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
                if(utf8_decode($rowFarmacologico[0]["AntihipertensivosNombre_1"]) != "" || utf8_decode($rowFarmacologico[0]["AntihipertensivosNombre_1"])){
                    $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- NOMBRE</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AntihipertensivosNombre_1"]) . ',&nbsp;&nbsp;<b>DOSIS</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AntihipertensivosDosis_1"]) . ',&nbsp;&nbsp;<b>TIPO</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AntihipertensivosPrescrito_1"]) . '</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
                if(utf8_decode($rowFarmacologico[0]["AntihipertensivosNombre_2"]) != "" || utf8_decode($rowFarmacologico[0]["AntihipertensivosNombre_2"])){
                    $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- NOMBRE</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AntihipertensivosNombre_2"]) . ',&nbsp;&nbsp;<b>DOSIS</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AntihipertensivosDosis_2"]) . ',&nbsp;&nbsp;<b>TIPO</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AntihipertensivosPrescrito_2"]) . '</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
                if(utf8_decode($rowFarmacologico[0]["AntihipertensivosNombre_3"]) != "" || utf8_decode($rowFarmacologico[0]["AntihipertensivosNombre_3"])){
                    $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- NOMBRE</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AntihipertensivosNombre_3"]) . ',&nbsp;&nbsp;<b>DOSIS</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AntihipertensivosDosis_3"]) . ',&nbsp;&nbsp;<b>TIPO</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AntihipertensivosPrescrito_3"]) . '</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
                if(utf8_decode($rowFarmacologico[0]["AntihipertensivosNombre_4"]) != "" || utf8_decode($rowFarmacologico[0]["AntihipertensivosNombre_4"])){
                    $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- NOMBRE</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AntihipertensivosNombre_4"]) . ',&nbsp;&nbsp;<b>DOSIS</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AntihipertensivosDosis_4"]) . ',&nbsp;&nbsp;<b>TIPO</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AntihipertensivosPrescrito_4"]) . '</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
                if(utf8_decode($rowFarmacologico[0]["AntihipertensivosNombre_|"]) != "" || utf8_decode($rowFarmacologico[0]["AntihipertensivosNombre_5"])){
                    $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- NOMBRE</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AntihipertensivosNombre_5"]) . ',&nbsp;&nbsp;<b>DOSIS</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AntihipertensivosDosis_5"]) . ',&nbsp;&nbsp;<b>TIPO</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AntihipertensivosPrescrito_5"]) . '</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
            }
                        
            if(utf8_decode($rowFarmacologico[0]["DiureticosNombre_1"]) != "" || utf8_decode($rowFarmacologico[0]["DiureticosNombre_1"]) != null || utf8_decode($rowFarmacologico[0]["DiureticosNombre_2"]) != "" || utf8_decode($rowFarmacologico[0]["DiureticosNombre_2"]) != null || utf8_decode($rowFarmacologico[0]["DiureticosNombre_3"]) != "" || utf8_decode($rowFarmacologico[0]["DiureticosNombre_3"]) != null || utf8_decode($rowFarmacologico[0]["DiureticosNombre_4"]) != "" || utf8_decode($rowFarmacologico[0]["DiureticosNombre_4"]) != null || utf8_decode($rowFarmacologico[0]["DiureticosNombre_5"]) != "" || utf8_decode($rowFarmacologico[0]["DiureticosNombre_5"]) != null){
                $mostrarHC = '<br>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
                $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- DIURETICOS</b>:</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
                if(utf8_decode($rowFarmacologico[0]["DiureticosNombre_1"]) != "" || utf8_decode($rowFarmacologico[0]["DiureticosNombre_1"])){
                    $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- NOMBRE</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["DiureticosNombre_1"]) . ',&nbsp;&nbsp;<b>DOSIS</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["DiureticosDosis_1"]) . ',&nbsp;&nbsp;<b>TIPO</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["DiureticosPrescrito_1"]) . '</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
                if(utf8_decode($rowFarmacologico[0]["DiureticosNombre_2"]) != "" || utf8_decode($rowFarmacologico[0]["DiureticosNombre_2"])){
                    $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- NOMBRE</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["DiureticosNombre_2"]) . ',&nbsp;&nbsp;<b>DOSIS</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["DiureticosDosis_2"]) . ',&nbsp;&nbsp;<b>TIPO</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["DiureticosPrescrito_2"]) . '</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
                if(utf8_decode($rowFarmacologico[0]["DiureticosNombre_3"]) != "" || utf8_decode($rowFarmacologico[0]["DiureticosNombre_3"])){
                    $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- NOMBRE</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["DiureticosNombre_3"]) . ',&nbsp;&nbsp;<b>DOSIS</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["DiureticosDosis_3"]) . ',&nbsp;&nbsp;<b>TIPO</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["DiureticosPrescrito_3"]) . '</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
                if(utf8_decode($rowFarmacologico[0]["DiureticosNombre_4"]) != "" || utf8_decode($rowFarmacologico[0]["DiureticosNombre_4"])){
                    $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- NOMBRE</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["DiureticosNombre_4"]) . ',&nbsp;&nbsp;<b>DOSIS</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["DiureticosDosis_4"]) . ',&nbsp;&nbsp;<b>TIPO</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["DiureticosPrescrito_4"]) . '</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
                if(utf8_decode($rowFarmacologico[0]["DiureticosNombre_|"]) != "" || utf8_decode($rowFarmacologico[0]["DiureticosNombre_5"])){
                    $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- NOMBRE</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["DiureticosNombre_5"]) . ',&nbsp;&nbsp;<b>DOSIS</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["DiureticosDosis_5"]) . ',&nbsp;&nbsp;<b>TIPO</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["DiureticosPrescrito_5"]) . '</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
            }
            
            if(utf8_decode($rowFarmacologico[0]["HipoglicemiantesNombre_1"]) != "" || utf8_decode($rowFarmacologico[0]["HipoglicemiantesNombre_1"]) != null || utf8_decode($rowFarmacologico[0]["HipoglicemiantesNombre_2"]) != "" || utf8_decode($rowFarmacologico[0]["HipoglicemiantesNombre_2"]) != null || utf8_decode($rowFarmacologico[0]["HipoglicemiantesNombre_3"]) != "" || utf8_decode($rowFarmacologico[0]["HipoglicemiantesNombre_3"]) != null || utf8_decode($rowFarmacologico[0]["HipoglicemiantesNombre_4"]) != "" || utf8_decode($rowFarmacologico[0]["HipoglicemiantesNombre_4"]) != null || utf8_decode($rowFarmacologico[0]["HipoglicemiantesNombre_5"]) != "" || utf8_decode($rowFarmacologico[0]["HipoglicemiantesNombre_5"]) != null){
                $mostrarHC = '<br>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
                $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- HIPOGLICEMIANTES</b>:</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
                if(utf8_decode($rowFarmacologico[0]["HipoglicemiantesNombre_1"]) != "" || utf8_decode($rowFarmacologico[0]["HipoglicemiantesNombre_1"])){
                    $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- NOMBRE</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["HipoglicemiantesNombre_1"]) . ',&nbsp;&nbsp;<b>DOSIS</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["HipoglicemiantesDosis_1"]) . ',&nbsp;&nbsp;<b>TIPO</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["HipoglicemiantesPrescrito_1"]) . '</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
                if(utf8_decode($rowFarmacologico[0]["HipoglicemiantesNombre_2"]) != "" || utf8_decode($rowFarmacologico[0]["HipoglicemiantesNombre_2"])){
                    $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- NOMBRE</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["HipoglicemiantesNombre_2"]) . ',&nbsp;&nbsp;<b>DOSIS</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["HipoglicemiantesDosis_2"]) . ',&nbsp;&nbsp;<b>TIPO</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["HipoglicemiantesPrescrito_2"]) . '</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
                if(utf8_decode($rowFarmacologico[0]["HipoglicemiantesNombre_3"]) != "" || utf8_decode($rowFarmacologico[0]["HipoglicemiantesNombre_3"])){
                    $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- NOMBRE</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["HipoglicemiantesNombre_3"]) . ',&nbsp;&nbsp;<b>DOSIS</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["HipoglicemiantesDosis_3"]) . ',&nbsp;&nbsp;<b>TIPO</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["HipoglicemiantesPrescrito_3"]) . '</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
                if(utf8_decode($rowFarmacologico[0]["HipoglicemiantesNombre_4"]) != "" || utf8_decode($rowFarmacologico[0]["HipoglicemiantesNombre_4"])){
                    $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- NOMBRE</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["HipoglicemiantesNombre_4"]) . ',&nbsp;&nbsp;<b>DOSIS</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["HipoglicemiantesDosis_4"]) . ',&nbsp;&nbsp;<b>TIPO</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["HipoglicemiantesPrescrito_4"]) . '</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
                if(utf8_decode($rowFarmacologico[0]["HipoglicemiantesNombre_|"]) != "" || utf8_decode($rowFarmacologico[0]["HipoglicemiantesNombre_5"])){
                    $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- NOMBRE</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["HipoglicemiantesNombre_5"]) . ',&nbsp;&nbsp;<b>DOSIS</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["HipoglicemiantesDosis_5"]) . ',&nbsp;&nbsp;<b>TIPO</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["HipoglicemiantesPrescrito_5"]) . '</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
            }
            
            if(utf8_decode($rowFarmacologico[0]["AnticolinergicosNombre_1"]) != "" || utf8_decode($rowFarmacologico[0]["AnticolinergicosNombre_1"]) != null || utf8_decode($rowFarmacologico[0]["AnticolinergicosNombre_2"]) != "" || utf8_decode($rowFarmacologico[0]["AnticolinergicosNombre_2"]) != null || utf8_decode($rowFarmacologico[0]["AnticolinergicosNombre_3"]) != "" || utf8_decode($rowFarmacologico[0]["AnticolinergicosNombre_3"]) != null || utf8_decode($rowFarmacologico[0]["AnticolinergicosNombre_4"]) != "" || utf8_decode($rowFarmacologico[0]["AnticolinergicosNombre_4"]) != null || utf8_decode($rowFarmacologico[0]["AnticolinergicosNombre_5"]) != "" || utf8_decode($rowFarmacologico[0]["AnticolinergicosNombre_5"]) != null){
                $mostrarHC = '<br>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
                $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- ANTICOLINERGICOS</b>:</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
                if(utf8_decode($rowFarmacologico[0]["AnticolinergicosNombre_1"]) != "" || utf8_decode($rowFarmacologico[0]["AnticolinergicosNombre_1"])){
                    $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- NOMBRE</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AnticolinergicosNombre_1"]) . ',&nbsp;&nbsp;<b>DOSIS</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AnticolinergicosDosis_1"]) . ',&nbsp;&nbsp;<b>TIPO</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AnticolinergicosPrescrito_1"]) . '</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
                if(utf8_decode($rowFarmacologico[0]["AnticolinergicosNombre_2"]) != "" || utf8_decode($rowFarmacologico[0]["AnticolinergicosNombre_2"])){
                    $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- NOMBRE</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AnticolinergicosNombre_2"]) . ',&nbsp;&nbsp;<b>DOSIS</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AnticolinergicosDosis_2"]) . ',&nbsp;&nbsp;<b>TIPO</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AnticolinergicosPrescrito_2"]) . '</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
                if(utf8_decode($rowFarmacologico[0]["AnticolinergicosNombre_3"]) != "" || utf8_decode($rowFarmacologico[0]["AnticolinergicosNombre_3"])){
                    $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- NOMBRE</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AnticolinergicosNombre_3"]) . ',&nbsp;&nbsp;<b>DOSIS</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AnticolinergicosDosis_3"]) . ',&nbsp;&nbsp;<b>TIPO</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AnticolinergicosPrescrito_3"]) . '</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
                if(utf8_decode($rowFarmacologico[0]["AnticolinergicosNombre_4"]) != "" || utf8_decode($rowFarmacologico[0]["AnticolinergicosNombre_4"])){
                    $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- NOMBRE</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AnticolinergicosNombre_4"]) . ',&nbsp;&nbsp;<b>DOSIS</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AnticolinergicosDosis_4"]) . ',&nbsp;&nbsp;<b>TIPO</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AnticolinergicosPrescrito_4"]) . '</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
                if(utf8_decode($rowFarmacologico[0]["AnticolinergicosNombre_|"]) != "" || utf8_decode($rowFarmacologico[0]["AnticolinergicosNombre_5"])){
                    $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- NOMBRE</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AnticolinergicosNombre_5"]) . ',&nbsp;&nbsp;<b>DOSIS</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AnticolinergicosDosis_5"]) . ',&nbsp;&nbsp;<b>TIPO</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["AnticolinergicosPrescrito_5"]) . '</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
            }
            
            if(utf8_decode($rowFarmacologico[0]["OtrosNombre_1"]) != "" || utf8_decode($rowFarmacologico[0]["OtrosNombre_1"]) != null || utf8_decode($rowFarmacologico[0]["OtrosNombre_2"]) != "" || utf8_decode($rowFarmacologico[0]["OtrosNombre_2"]) != null || utf8_decode($rowFarmacologico[0]["OtrosNombre_3"]) != "" || utf8_decode($rowFarmacologico[0]["OtrosNombre_3"]) != null || utf8_decode($rowFarmacologico[0]["OtrosNombre_4"]) != "" || utf8_decode($rowFarmacologico[0]["OtrosNombre_4"]) != null || utf8_decode($rowFarmacologico[0]["OtrosNombre_5"]) != "" || utf8_decode($rowFarmacologico[0]["OtrosNombre_5"]) != null){
                $mostrarHC = '<br>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
                $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- OTROS</b>:</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
                if(utf8_decode($rowFarmacologico[0]["OtrosNombre_1"]) != "" || utf8_decode($rowFarmacologico[0]["OtrosNombre_1"])){
                    $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- NOMBRE</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["OtrosNombre_1"]) . ',&nbsp;&nbsp;<b>DOSIS</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["OtrosDosis_1"]) . ',&nbsp;&nbsp;<b>TIPO</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["OtrosPrescrito_1"]) . '</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
                if(utf8_decode($rowFarmacologico[0]["OtrosNombre_2"]) != "" || utf8_decode($rowFarmacologico[0]["OtrosNombre_2"])){
                    $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- NOMBRE</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["OtrosNombre_2"]) . ',&nbsp;&nbsp;<b>DOSIS</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["OtrosDosis_2"]) . ',&nbsp;&nbsp;<b>TIPO</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["OtrosPrescrito_2"]) . '</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
                if(utf8_decode($rowFarmacologico[0]["OtrosNombre_3"]) != "" || utf8_decode($rowFarmacologico[0]["OtrosNombre_3"])){
                    $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- NOMBRE</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["OtrosNombre_3"]) . ',&nbsp;&nbsp;<b>DOSIS</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["OtrosDosis_3"]) . ',&nbsp;&nbsp;<b>TIPO</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["OtrosPrescrito_3"]) . '</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
                if(utf8_decode($rowFarmacologico[0]["OtrosNombre_4"]) != "" || utf8_decode($rowFarmacologico[0]["OtrosNombre_4"])){
                    $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- NOMBRE</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["OtrosNombre_4"]) . ',&nbsp;&nbsp;<b>DOSIS</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["OtrosDosis_4"]) . ',&nbsp;&nbsp;<b>TIPO</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["OtrosPrescrito_4"]) . '</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
                if(utf8_decode($rowFarmacologico[0]["OtrosNombre_|"]) != "" || utf8_decode($rowFarmacologico[0]["OtrosNombre_5"])){
                    $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- NOMBRE</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["OtrosNombre_5"]) . ',&nbsp;&nbsp;<b>DOSIS</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["OtrosDosis_5"]) . ',&nbsp;&nbsp;<b>TIPO</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["OtrosPrescrito_5"]) . '</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
            }
            
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;Numero de Medicamentos</b>:&nbsp;' . utf8_decode($rowFarmacologico[0]["NumeroMedicamentos"]) . '</span><br><br>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            unset($rowExamenFisico);
            $gBaseDatos = new ofiMySQLi();
            $gBaseDatos->conectar();
            $qry = "CALL sp_asistencial_civyc_printhc_05('" . $pEvolucion . "')";
            $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
            while ($rowExamenFisico[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
            $gBaseDatos->liberar();
            $gBaseDatos->cerrar();
            
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>EXAMEN FISICO</b>:&nbsp;</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- PESO</b>:&nbsp;' . utf8_decode($rowExamenFisico[0]["Peso"]) . ',&nbsp;&nbsp;<b>TALLA</b>:&nbsp;' . utf8_decode($rowExamenFisico[0]["Talla"]) . ',&nbsp;&nbsp;<b>IMC</b>:&nbsp;' . utf8_decode($rowExamenFisico[0]["IMC"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- T.A. ACOSTADO</b>:&nbsp;' . utf8_decode($rowExamenFisico[0]["TensionArterialCostado"]) . ',&nbsp;&nbsp;<b>T.A. SENTADO</b>:&nbsp;' . utf8_decode($rowExamenFisico[0]["TensionArterialSentado"]) . ',&nbsp;&nbsp;<b>T.A. DE PIE</b>:&nbsp;' . utf8_decode($rowExamenFisico[0]["TensionArterialDePie"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- FRECUENCIA RESPIRATORIA</b>:&nbsp;' . utf8_decode($rowExamenFisico[0]["FR"]) . ',&nbsp;&nbsp;<b>FRECUENCIA CARDIACA</b>:&nbsp;' . utf8_decode($rowExamenFisico[0]["FC"]) . ',&nbsp;&nbsp;<b>PULSO</b>:&nbsp;' . utf8_decode($rowExamenFisico[0]["PulsoSignosVitales"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $pSoplosExamen = "SI";
            if(utf8_decode($rowExamenFisico[0]["PulsosSoplos"]) == "0" || utf8_decode($rowExamenFisico[0]["PulsosSoplos"]) == 0){
                $pSoplosExamen = "NO";
            }
            $pPulsosExamen = "";
            switch(utf8_decode($rowExamenFisico[0]["Pulsos"])){
                case "0":
                    $pPulsosExamen = "ANORMAL";
                    break;
                case "1":
                    $pPulsosExamen = "NORMAL";
                    break;
                default:
                    break;
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- SOPLOS</b>:&nbsp;' . $pSoplosExamen . ',&nbsp;&nbsp;<b>ESPECIFIQUE</b>:&nbsp;' . utf8_decode($rowExamenFisico[0]["PulsosSoplosEspecifique"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- PULSOS</b>:&nbsp;' . $pPulsosExamen . ',&nbsp;&nbsp;<b>ESPECIFIQUE</b>:&nbsp;' . utf8_decode($rowExamenFisico[0]["PulsosEspecifique"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            //JORGE
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- CONDICIONES GENERALES</b>:</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;- APARIENCIA</b>:&nbsp;' . utf8_decode($rowExamenFisico[0]["Apariencia"]);
            $mostrarHC .= '<b>&nbsp;&nbsp;- HIDRATACION</b>:&nbsp;' . utf8_decode($rowExamenFisico[0]["Hidratacion"]);
            $mostrarHC .= '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;- PIEL</b>:&nbsp;' . utf8_decode($rowExamenFisico[0]["Piel"]) . ',&nbsp;&nbsp;<b>ESPECIFIQUE</b>:&nbsp;' . utf8_decode($rowExamenFisico[0]["PielEspecifique"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;- ANEXOS</b>:&nbsp;' . utf8_decode($rowExamenFisico[0]["Anexos"]) . ',&nbsp;&nbsp;<b>ESPECIFIQUE</b>:&nbsp;' . utf8_decode($rowExamenFisico[0]["AnexosEspecifique"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- CABEZA</b>:</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;- OJOS</b>:</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;- RETINA</b>:&nbsp;' . utf8_decode($rowExamenFisico[0]["Retina"]) . ',&nbsp;&nbsp;<b>ESPECIFIQUE</b>:&nbsp;' . utf8_decode($rowExamenFisico[0]["RetinaEspecifique"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;- CONJUNTIVAS</b>:&nbsp;' . utf8_decode($rowExamenFisico[0]["Conuntivas"]) . ',&nbsp;&nbsp;<b>ESPECIFIQUE</b>:&nbsp;' . utf8_decode($rowExamenFisico[0]["ConuntivasEspecifique"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;- PUPILAS</b>:&nbsp;' . utf8_decode($rowExamenFisico[0]["Pupilas"]) . ',&nbsp;&nbsp;<b>ESPECIFIQUE</b>:&nbsp;' . utf8_decode($rowExamenFisico[0]["PupilasEspecifique"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;- CRISTALINO</b>:&nbsp;' . utf8_decode($rowExamenFisico[0]["Cristalino"]) . ',&nbsp;&nbsp;<b>ESPECIFIQUE</b>:&nbsp;' . utf8_decode($rowExamenFisico[0]["CristalinoEspecifique"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;- CAMARA ANT.</b>:&nbsp;' . utf8_decode($rowExamenFisico[0]["CamartaAnt"]) . ',&nbsp;&nbsp;<b>ESPECIFIQUE</b>:&nbsp;' . utf8_decode($rowExamenFisico[0]["CamartaAntEspecifique"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;- TONO OCULAR DER.</b>:&nbsp;' . utf8_decode($rowExamenFisico[0]["TonoOcularDer"]) . ',&nbsp;&nbsp;<b>ESPECIFIQUE</b>:&nbsp;' . utf8_decode($rowExamenFisico[0]["TonoOcularDerEspecifique"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;- TONO OCULAR IZQ.</b>:&nbsp;' . utf8_decode($rowExamenFisico[0]["TonoOcularIzq"]) . ',&nbsp;&nbsp;<b>ESPECIFIQUE</b>:&nbsp;' . utf8_decode($rowExamenFisico[0]["TonoOcularIzqEspecifique"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;- BOCA</b>:&nbsp;' . utf8_decode($rowExamenFisico[0]["Boca"]) . ',&nbsp;&nbsp;<b>ESPECIFIQUE</b>:&nbsp;' . utf8_decode($rowExamenFisico[0]["BocaEspecifique"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;- NARIZ</b>:&nbsp;' . utf8_decode($rowExamenFisico[0]["Nariz"]) . ',&nbsp;&nbsp;<b>ESPECIFIQUE</b>:&nbsp;' . utf8_decode($rowExamenFisico[0]["NarizEspecifique"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;- OTOSCOPIA</b>:&nbsp;' . utf8_decode($rowExamenFisico[0]["Otoscopia"]) . ',&nbsp;&nbsp;<b>ESPECIFIQUE</b>:&nbsp;' . utf8_decode($rowExamenFisico[0]["OtoscopiaEspecifique"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;- CUELLO</b>:&nbsp;' . utf8_decode($rowExamenFisico[0]["Cuello"]) . ',&nbsp;&nbsp;<b>ESPECIFIQUE</b>:&nbsp;' . utf8_decode($rowExamenFisico[0]["CuelloEspecifique"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;- SOPLOS CAROTIDEOS</b>:&nbsp;' . utf8_decode($rowExamenFisico[0]["SoplosCarotideos"]) . ',&nbsp;&nbsp;<b>ESPECIFIQUE</b>:&nbsp;' . utf8_decode($rowExamenFisico[0]["SoplosCarotideosEspecifique"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- TORAX</b>:</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;- INSPECCION GENERAL</b>:&nbsp;' . utf8_decode($rowExamenFisico[0]["ToraxInspeccionGeneral"]) . ',&nbsp;&nbsp;<b>ESPECIFIQUE</b>:&nbsp;' . utf8_decode($rowExamenFisico[0]["ToraxInspeccionGeneralEspecifique"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;- CORAZON</b>:&nbsp;' . utf8_decode($rowExamenFisico[0]["ToraxCorazon"]) . ',&nbsp;&nbsp;<b>ESPECIFIQUE</b>:&nbsp;' . utf8_decode($rowExamenFisico[0]["ToraxCorazonEspecifique"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;- PULMON</b>:&nbsp;' . utf8_decode($rowExamenFisico[0]["ToraxPulmon"]) . ',&nbsp;&nbsp;<b>ESPECIFIQUE</b>:&nbsp;' . utf8_decode($rowExamenFisico[0]["ToraxPulmonEspecifique"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- ABDOMEN</b>:</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;- INSPECCION GENERAL</b>:&nbsp;' . utf8_decode($rowExamenFisico[0]["AbdomenInspeccionGeneral"]) . ',&nbsp;&nbsp;<b>ESPECIFIQUE</b>:&nbsp;' . utf8_decode($rowExamenFisico[0]["AbdomenInspeccionGeneralEspecifique"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;- PALPACION</b>:&nbsp;' . utf8_decode($rowExamenFisico[0]["AbdomenPalpacion"]) . ',&nbsp;&nbsp;<b>ESPECIFIQUE</b>:&nbsp;' . utf8_decode($rowExamenFisico[0]["AbdomenPalpacionEspecifique"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;- AUSCULTACION</b>:&nbsp;' . utf8_decode($rowExamenFisico[0]["AbdomenAuscultacion"]) . ',&nbsp;&nbsp;<b>ESPECIFIQUE</b>:&nbsp;' . utf8_decode($rowExamenFisico[0]["AbdomenAuscultacionEspecifique"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<br>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            //FIN JORGE
            
            unset($rowExamenFisicoTF);
            $gBaseDatos = new ofiMySQLi();
            $gBaseDatos->conectar();
            $qry = "CALL sp_asistencial_civyc_printhc_09('" . $pEvolucion . "')";
            $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
            while ($rowExamenFisicoTF[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
            $gBaseDatos->liberar();
            $gBaseDatos->cerrar();
            
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>- SISTEMA LOCOMOTOR</b>:&nbsp;</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;">&nbsp;&nbsp;<b>- MOVILIDAD ARTICULAR</b>:&nbsp;</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- HOMBRO</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["Hombro"]) . ',&nbsp;&nbsp;<b>ESPECIFIQUE</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["HombroEspecifique"]) . ',&nbsp;&nbsp;<b>CODO</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["Codo"]) . ',&nbsp;&nbsp;<b>ESPECIFIQUE</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["CodoEspecifique"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- MUÑECA</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["Muneca"]) . ',&nbsp;&nbsp;<b>ESPECIFIQUE</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["MunecaEspecifique"]) . ',&nbsp;&nbsp;<b>DEDOS</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["Dedos"]) . ',&nbsp;&nbsp;<b>ESPECIFIQUE</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["DedosEspecifique"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- CUELLO</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["CuelloOsteoMuscular"]) . ',&nbsp;&nbsp;<b>ESPECIFIQUE</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["CuelloOsteoMuscularEspecifique"]) . ',&nbsp;&nbsp;<b>CADERA</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["Cadera"]) . ',&nbsp;&nbsp;<b>ESPECIFIQUE</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["CaderaEspecifique"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- RODILLA</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["Rodilla"]) . ',&nbsp;&nbsp;<b>ESPECIFIQUE</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["RodillaEspecifique"]) . ',&nbsp;&nbsp;<b>TOBILLO</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["Tobillo"]) . ',&nbsp;&nbsp;<b>ESPECIFIQUE</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["TobilloEspecifique"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- COLUMNA</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["Columna"]) . ',&nbsp;&nbsp;<b>ESPECIFIQUE</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["ColumnaEspecifique"]) . ',&nbsp;&nbsp;<b>SIGNOS ARTICULARES</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["SignosArticulares"]) . ',&nbsp;&nbsp;<b>ESPECIFIQUE</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["SignosArticularesEspecifique"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;">&nbsp;&nbsp;<b>- MUSCULOS</b>:&nbsp;</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- ATROFIAS</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["Atrofias"]) . ',&nbsp;&nbsp;<b>ESPECIFIQUE</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["AtrofiasEspecifique"]) . ',&nbsp;&nbsp;<b>MOV. INVOLUNTARIOS</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["MovInvoluntarios"]) . ',&nbsp;&nbsp;<b>ESPECIFIQUE</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["MovInvoluntariosEspecifique"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- ATROFIAS</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["Atrofias"]) . ',&nbsp;&nbsp;<b>ESPECIFIQUE</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["AtrofiasEspecifique"]) . ',&nbsp;&nbsp;<b>MOV. INVOLUNTARIOS</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["MovInvoluntarios"]) . ',&nbsp;&nbsp;<b>ESPECIFIQUE</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["MovInvoluntariosEspecifique"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- FUERZA MIEMBROS SUPERIORES</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["FuerzaMiembrosSupeiores"]) . ',&nbsp;&nbsp;<b>FUERZA MIEMBROS SUPERIORES</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["FuerzaMiembrosInferiores"]) . ',&nbsp;&nbsp;<b>TONO MUSCULAR</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["TonoMuscular"]) . ',&nbsp;&nbsp;<b>ESPECIFIQUE</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["TonoMuscularEspecifique"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>- PARES CRANEALES</b>:&nbsp;</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- PAR CRANEAL I</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["ParCranealI"]) . ',&nbsp;&nbsp;<b>ESPECIFIQUE</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["ParCranealIEspecifique"]) . ',&nbsp;&nbsp;<b>PAR CRANEAL II</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["ParCranealII"]) . ',&nbsp;&nbsp;<b>ESPECIFIQUE</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["ParCranealIIEspecifique"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- PAR CRANEAL III</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["ParCranealIII"]) . ',&nbsp;&nbsp;<b>ESPECIFIQUE</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["ParCranealIIIEspecifique"]) . ',&nbsp;&nbsp;<b>PAR CRANEAL IV</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["ParCranealIV"]) . ',&nbsp;&nbsp;<b>ESPECIFIQUE</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["ParCranealIVEspecifique"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- PAR CRANEAL V</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["ParCranealV"]) . ',&nbsp;&nbsp;<b>ESPECIFIQUE</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["ParCranealVEspecifique"]) . ',&nbsp;&nbsp;<b>PAR CRANEAL VI</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["ParCranealVI"]) . ',&nbsp;&nbsp;<b>ESPECIFIQUE</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["ParCranealVIEspecifique"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- PAR CRANEAL VII</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["ParCranealVII"]) . ',&nbsp;&nbsp;<b>ESPECIFIQUE</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["ParCranealVIIEspecifique"]) . ',&nbsp;&nbsp;<b>PAR CRANEAL VIII</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["ParCranealVIII"]) . ',&nbsp;&nbsp;<b>ESPECIFIQUE</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["ParCranealVIIIEspecifique"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- PAR CRANEAL IX</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["ParCranealIX"]) . ',&nbsp;&nbsp;<b>ESPECIFIQUE</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["ParCranealIXEspecifique"]) . ',&nbsp;&nbsp;<b>PAR CRANEAL X</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["ParCranealX"]) . ',&nbsp;&nbsp;<b>ESPECIFIQUE</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["ParCranealXEspecifique"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- PAR CRANEAL XI</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["ParCranealXI"]) . ',&nbsp;&nbsp;<b>ESPECIFIQUE</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["ParCranealXIEspecifique"]) . ',&nbsp;&nbsp;<b>PAR CRANEAL XII</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["ParCranealXII"]) . ',&nbsp;&nbsp;<b>ESPECIFIQUE</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["ParCranealXIIEspecifique"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>- SENSIBILIDAD</b>:&nbsp;</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- TACTIL</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["Tactil"]) . ',&nbsp;&nbsp;<b>ESPECIFIQUE</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["TactilEspecifique"]) . ',&nbsp;&nbsp;<b>TERMICO DOLOROSA</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["TermicoDolorosa"]) . ',&nbsp;&nbsp;<b>ESPECIFIQUE</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["TermicoDolorosaEspecifique"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- VIBRATORIA</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["Vibratoria"]) . ',&nbsp;&nbsp;<b>ESPECIFIQUE</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["VibratoriaEspecifique"]) . ',&nbsp;&nbsp;<b>PROPIOCEPTIVA</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["Propioceptiva"]) . ',&nbsp;&nbsp;<b>ESPECIFIQUE</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["PropioceptivaEspecifique"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- REFLEJOS SUPERFICIALES CUTANEOS</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["ReflejosSuperficialesCutaneos"]) . ',&nbsp;&nbsp;<b>ESPECIFIQUE</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["ReflejosSuperficialesCutaneosEspecifique"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- REFLEJOS OSTEOTENDINOSO</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["ReflejosOsteotendimosos"]) . ',&nbsp;&nbsp;<b>ESPECIFIQUE</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["CutaneosEspecifique"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- SIGNOS PATOLOGICOS (CEREBELOSOS, MENINGEOS, BABINSKI)</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["SignosPatologicos"]) . ',&nbsp;&nbsp;<b>ESPECIFIQUE</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["SignosPatologicosEspecifique"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- SIGNOS FRONTALES (PALMOMENTONIANO, GLABELAR, PRESION PALMAR, SUCCION)</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["SignosFrontales"]) . ',&nbsp;&nbsp;<b>ESPECIFIQUE</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["SignosFrontalesEspecifique"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- MANIIOBRA DE DIX-HALLPIKE</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["SignosManiobraHallpike"]) . ',&nbsp;&nbsp;<b>ESPECIFIQUE</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["SignosManiobraHallpikeEspecifique"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- NISTAGMO DE LA AGITACION CEFALICA</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["SignosNistagmo"]) . ',&nbsp;&nbsp;<b>ESPECIFIQUE</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["SignosNistagmo"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<br><br><span style="font-size:30px; text-align:justify;"><b>- MEDIDAS BASADAS EN LA EJECUCION</b>:&nbsp;</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;">&nbsp;&nbsp;<b>- MARCHA EN TANDEM</b>:&nbsp;</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px;">Tiempo utilizado en caminar 4Mtrs:&nbsp;<u>' . utf8_decode($rowExamenFisicoTF[0]["Tiempo4MtsTandem"]) . '</u> segundos. Mts/seg:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["MtsSegTandem"]);
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px;">Numero de veces que pisa la linea o sale del espacio:&nbsp;<u>' . utf8_decode($rowExamenFisicoTF[0]["PisadasFuera"]);
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $pAyudaMarchaTandem = "";
            switch(utf8_decode($rowExamenFisicoTF[0]["AyudaTandem"])){
                case "0":
                    $pAyudaMarchaTandem = "NO REQUIERE AYUDA";
                    break;
                case "1":
                    $pAyudaMarchaTandem = "REQUIERE AYUDA (CAMINADOR - MULETA - BASTON)";
                    break;
                case "2":
                    $pAyudaMarchaTandem = "REQUIERE AYUDA DE UNA PERRSONA (CON O SIN AYUDA DE CAMINADOR - MULETA - BASTON)";
                    break;
                case "3":
                    $pAyudaMarchaTandem = "REQUIERE AYUDA DE DOS PERSONAS";
                    break;
                case "4":
                    $pAyudaMarchaTandem = "NO LO HACE";
                    break;
                default:
                    break;
            }
            $mostrarHC = '<span style="font-size:30px;">Numero de veces que pisa la linea o sale del espacio:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["PisadasFuera"]) . '. Ayuda Marcha en Tandem:&nbsp;' . $pAyudaMarchaTandem;
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;">&nbsp;&nbsp;<b>- MARCHA CON VASO DE AGUA</b>:&nbsp;</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $pRiegaAgua = "";
            switch(utf8_decode($rowExamenFisicoTF[0]["RiegaAgua"])){
                case "0":
                    $pRiegaAgua = "NO";
                    break;
                case "1":
                    $pRiegaAgua = "SI";
                    break;
                case "2":
                    $pRiegaAgua = "NO LO HACE";
                    break;
                default:
                    break;
            }
            $mostrarHC = '<span style="font-size:30px;">Tiempo utilizado para caminar 4 Mts:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["Tiempo4MtsVasoAgua"]) . 'segundos. Mts/seg:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["MtsSegVasoAgua"]) . '</u>. Riega el Agua:&nbsp;' . $pRiegaAgua;
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;">&nbsp;&nbsp;<b>- ALCANCE FUNCIONAL</b>:&nbsp;</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px;">Primer Intento:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["AlcanceFuncionalPrimerIntentoIniicial"]) . 'cm. Inicial,&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["AlcanceFuncionalPrimerIntentoFinal"]) . '</u> cm. Final. Distancia Recorrida:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["AlcanceFuncionalDistanciaRecorridaPrimerIntento"]);
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px;">Segundo Intento:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["AlcanceFuncionalSegundoIntentoIniicial"]) . 'cm. Inicial,&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["AlcanceFuncionalSegundoIntentoFinal"]) . '</u> cm. Final. Distancia Recorrida:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["AlcanceFuncionalDistanciaRecorridaSegundoIntento"]);
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;">&nbsp;&nbsp;<b>- FUERZA DE AGARRE</b>:&nbsp;</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $pManoDominante = "";
            switch(utf8_decode($rowExamenFisicoTF[0]["ManoDominante"])){
                case "1":
                    $pManoDominante = "MANO DERECHA";
                    break;
                case "2":
                    $pManoDominante = "MANO IZQUEIRDA";
                    break;
                default:
                    break;
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- FUERZA MANO DERECHA</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["FuerzaDerecha"]) . ',&nbsp;&nbsp;<b>FUERZA MANO IZQUIERDA</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["FuerzaIzquierda"]) . ',&nbsp;&nbsp;<b>MANO DOMINANTE</b>:&nbsp;' . $pManoDominante . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;">&nbsp;&nbsp;<b>- ESCALA DE TINETTI. PRUEBA DE MARCHA</b>:&nbsp;</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $pTinettiMarchaInicio = "";
            switch(utf8_decode($rowExamenFisicoTF[0]["TinettiMarchaIniciacionPaso"])){
                case "1":
                    $pTinettiMarchaInicio = "NORMAL";
                    break;
                case "0":
                    $pTinettiMarchaInicio = "ANORMAL";
                    break;
                default:
                    break;
            }
            $pTinettiMarchaAltura = "";
            switch(utf8_decode($rowExamenFisicoTF[0]["TinettiMarchaAlturaPaso"])){
                case "1":
                    $pTinettiMarchaAltura = "NORMAL";
                    break;
                case "0":
                    $pTinettiMarchaAltura = "ANORMAL";
                    break;
                default:
                    break;
            }
            $pTinettiMarchaLongitud = "";
            switch(utf8_decode($rowExamenFisicoTF[0]["TinettiMarchaLongitudPaso"])){
                case "1":
                    $pTinettiMarchaLongitud = "NORMAL";
                    break;
                case "0":
                    $pTinettiMarchaLongitud = "ANORMAL";
                    break;
                default:
                    break;
            }
            $pTinettiMarchaSimetria = "";
            switch(utf8_decode($rowExamenFisicoTF[0]["TinettiMarchaSimetriaPaso"])){
                case "1":
                    $pTinettiMarchaSimetria = "NORMAL";
                    break;
                case "0":
                    $pTinettiMarchaSimetria = "ANORMAL";
                    break;
                default:
                    break;
            }
            $pTinettiMarchaContinuidad = "";
            switch(utf8_decode($rowExamenFisicoTF[0]["TinettiMarchaContinuidadPaso"])){
                case "1":
                    $pTinettiMarchaContinuidad = "NORMAL";
                    break;
                case "0":
                    $pTinettiMarchaContinuidad = "ANORMAL";
                    break;
                default:
                    break;
            }
            $pTinettiMarchaDireccion = "";
            switch(utf8_decode($rowExamenFisicoTF[0]["TinettiMarchaDireccionCamino"])){
                case "1":
                    $pTinettiMarchaDireccion = "NORMAL";
                    break;
                case "0":
                    $pTinettiMarchaDireccion = "ANORMAL";
                    break;
                default:
                    break;
            }
            $pTinettiMarchaEstabilidad = "";
            switch(utf8_decode($rowExamenFisicoTF[0]["TinettiMarchaEstabilidadTronco"])){
                case "1":
                    $pTinettiMarchaEstabilidad = "NORMAL";
                    break;
                case "0":
                    $pTinettiMarchaEstabilidad = "ANORMAL";
                    break;
                default:
                    break;
            }
            $pTinettiMarchaSustentacion = "";
            switch(utf8_decode($rowExamenFisicoTF[0]["TinettiMarchaBaseSustentacionMarcha"])){
                case "1":
                    $pTinettiMarchaSustentacion = "NORMAL";
                    break;
                case "0":
                    $pTinettiMarchaSustentacion = "ANORMAL";
                    break;
                default:
                    break;
            }
            $pTinettiMarchaGiro = "";
            switch(utf8_decode($rowExamenFisicoTF[0]["TinettiMarchaGirarCamina"])){
                case "1":
                    $pTinettiMarchaGiro = "NORMAL";
                    break;
                case "0":
                    $pTinettiMarchaGiro = "ANORMAL";
                    break;
                default:
                    break;
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;- INICIACION DEL PASO</b>:&nbsp;' . $pTinettiMarchaInicio . ',&nbsp;&nbsp;<b>ALTURA DE PASO</b>:&nbsp;' . $pTinettiMarchaAltura . ',&nbsp;&nbsp;<b>LONGITUD DEL PASO</b>:&nbsp;' . $pTinettiMarchaLongitud . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;SIMETRIA DEL PASO</b>:&nbsp;' . $pTinettiMarchaSimetria . ',&nbsp;&nbsp;<b>CONTINUIDAD DE PASO</b>:&nbsp;' . $pTinettiMarchaContinuidad . ',&nbsp;&nbsp;<b>DIRECCION DEL CAMINO</b>:&nbsp;' . $pTinettiMarchaDireccion . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;ESTABILIDAD DEL TRONCO</b>:&nbsp;' . $pTinettiMarchaEstabilidad . ',&nbsp;&nbsp;<b>BASE DE SUSTENTACION DURANTE LA MARCHA</b>:&nbsp;' . $pTinettiMarchaSustentacion . ',&nbsp;&nbsp;<b>GIRAR MIENTRAS SE CAMINA</b>:&nbsp;' . $pTinettiMarchaGiro . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;PUNTAJE TOTAL</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["PuntajeTotalTinettiMarcha"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;">&nbsp;&nbsp;<b>- ESCALA DE TINETTI. PRUEBA DE EQUILIBRIO</b>:&nbsp;</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $pTinettiEquilibrioBalance = "";
            switch(utf8_decode($rowExamenFisicoTF[0]["TinettiEquilibrioBalance"])){
                case "0":
                    $pTinettiEquilibrioBalance = "MALO";
                    break;
                case "1":
                    $pTinettiEquilibrioBalance = "REGULAR";
                    break;
                case "2":
                    $pTinettiEquilibrioBalance = "NORMAL";
                    break;
                default:
                    break;
            }
            $pTinettiEquilibrioLevantarse = "";
            switch(utf8_decode($rowExamenFisicoTF[0]["TinettiEquilibrioLevantarse"])){
                case "0":
                    $pTinettiEquilibrioLevantarse = "MALO";
                    break;
                case "1":
                    $pTinettiEquilibrioLevantarse = "REGULAR";
                    break;
                case "2":
                    $pTinettiEquilibrioLevantarse = "NORMAL";
                    break;
                default:
                    break;
            }
            $pTinettiEquilibrioBalancePie = "";
            switch(utf8_decode($rowExamenFisicoTF[0]["TinettiEquilibrioBalancePie"])){
                case "0":
                    $pTinettiEquilibrioBalancePie = "MALO";
                    break;
                case "1":
                    $pTinettiEquilibrioBalancePie = "REGULAR";
                    break;
                case "2":
                    $pTinettiEquilibrioBalancePie = "NORMAL";
                    break;
                default:
                    break;
            }
            $pTinettiEquilibrioBalancePosicionPie = "";
            switch(utf8_decode($rowExamenFisicoTF[0]["TinettiEquilibrioBalancePosicionPie"])){
                case "0":
                    $pTinettiEquilibrioBalancePosicionPie = "MALO";
                    break;
                case "1":
                    $pTinettiEquilibrioBalancePosicionPie = "REGULAR";
                    break;
                case "2":
                    $pTinettiEquilibrioBalancePosicionPie = "NORMAL";
                    break;
                default:
                    break;
            }
            $pTinettiEquilibrioBalanceOjos = "";
            switch(utf8_decode($rowExamenFisicoTF[0]["TinettiEquilibrioBalanceOjos"])){
                case "0":
                    $pTinettiEquilibrioBalanceOjos = "MALO";
                    break;
                case "1":
                    $pTinettiEquilibrioBalanceOjos = "REGULAR";
                    break;
                case "2":
                    $pTinettiEquilibrioBalanceOjos = "NORMAL";
                    break;
                default:
                    break;
            }
            $pTinettiEquilibrioBalanceGirar = "";
            switch(utf8_decode($rowExamenFisicoTF[0]["TinettiEquilibrioBalanceGirar"])){
                case "0":
                    $pTinettiEquilibrioBalanceGirar = "MALO";
                    break;
                case "1":
                    $pTinettiEquilibrioBalanceGirar = "REGULAR";
                    break;
                case "2":
                    $pTinettiEquilibrioBalanceGirar = "NORMAL";
                    break;
                default:
                    break;
            }
            $pTinettiEquilibrioEmpujon = "";
            switch(utf8_decode($rowExamenFisicoTF[0]["TinettiEquilibrioEmpujon"])){
                case "0":
                    $pTinettiEquilibrioEmpujon = "MALO";
                    break;
                case "1":
                    $pTinettiEquilibrioEmpujon = "REGULAR";
                    break;
                case "2":
                    $pTinettiEquilibrioEmpujon = "NORMAL";
                    break;
                default:
                    break;
            }
            $pTinettiEquilibrioBalanceUnPie = "";
            switch(utf8_decode($rowExamenFisicoTF[0]["TinettiEquilibrioBalanceUnPie"])){
                case "0":
                    $pTinettiEquilibrioBalanceUnPie = "MALO";
                    break;
                case "1":
                    $pTinettiEquilibrioBalanceUnPie = "REGULAR";
                    break;
                case "2":
                    $pTinettiEquilibrioBalanceUnPie = "NORMAL";
                    break;
                default:
                    break;
            }
            $pTinettiEquilibrioBalanceEspalda = "";
            switch(utf8_decode($rowExamenFisicoTF[0]["TinettiEquilibrioBalanceEspalda"])){
                case "0":
                    $pTinettiEquilibrioBalanceEspalda = "MALO";
                    break;
                case "1":
                    $pTinettiEquilibrioBalanceEspalda = "REGULAR";
                    break;
                case "2":
                    $pTinettiEquilibrioBalanceEspalda = "NORMAL";
                    break;
                default:
                    break;
            }
            $pTinettiEquilibrioAlcanzarObjetoAlto = "";
            switch(utf8_decode($rowExamenFisicoTF[0]["TinettiEquilibrioAlcanzarObjetoAlto"])){
                case "0":
                    $pTinettiEquilibrioAlcanzarObjetoAlto = "MALO";
                    break;
                case "1":
                    $pTinettiEquilibrioAlcanzarObjetoAlto = "REGULAR";
                    break;
                case "2":
                    $pTinettiEquilibrioAlcanzarObjetoAlto = "NORMAL";
                    break;
                default:
                    break;
            }
            $pTinettiEquilibrioAgacharse = "";
            switch(utf8_decode($rowExamenFisicoTF[0]["TinettiEquilibrioAgacharse"])){
                case "0":
                    $pTinettiEquilibrioAgacharse = "MALO";
                    break;
                case "1":
                    $pTinettiEquilibrioAgacharse = "REGULAR";
                    break;
                case "2":
                    $pTinettiEquilibrioAgacharse = "NORMAL";
                    break;
                default:
                    break;
            }
            $pTinettiEquilibrioSentarse = "";
            switch(utf8_decode($rowExamenFisicoTF[0]["TinettiEquilibrioSentarse"])){
                case "0":
                    $pTinettiEquilibrioSentarse = "MALO";
                    break;
                case "1":
                    $pTinettiEquilibrioSentarse = "REGULAR";
                    break;
                case "2":
                    $pTinettiEquilibrioSentarse = "NORMAL";
                    break;
                default:
                    break;
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;BALANCE EN POSICION DE SEDENTE EN SILLA</b>:&nbsp;' . $pTinettiEquilibrioBalance . ',&nbsp;&nbsp;<bLEVANTARSE DE UNA SILLA SIN AYUDA DE BRAZOS</b>:&nbsp;' . $pTinettiEquilibrioLevantarse . ',&nbsp;&nbsp;<b>BALANCE EN EL MOMENTO DE ADOPTAR LA POSICION DE PIE (PRIMERO 3-5 SEG.)</b>:&nbsp;' . $pTinettiEquilibrioBalancePie . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;BALANCE EN POSICION DE PIE (DESPUES DE 5 SEG.)</b>:&nbsp;' . $pTinettiEquilibrioBalancePosicionPie . ',&nbsp;&nbsp;<b>BALANCE CON OJOS CERRADOS (PIES TAN JUNTOS COMO PUEDA)</b>:&nbsp;' . $pTinettiEquilibrioBalanceOjos . ',&nbsp;&nbsp;<b>BALANCE AL GIRAR 360 GRADOS</b>:&nbsp;' . $pTinettiEquilibrioBalanceGirar . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;EMPUJON SOBRE EL ESTERNON</b>:&nbsp;' . $pTinettiEquilibrioEmpujon . ',&nbsp;&nbsp;<b>BALANCE EN UN PIE (UN PUNTO POR CADA PIE)</b>:&nbsp;' . $pTinettiEquilibrioBalanceUnPie . ',&nbsp;&nbsp;<b>EXTENSION DE ESPALDA</b>:&nbsp;' . $pTinettiEquilibrioBalanceEspalda . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;ALCANZAR UN OBJETO ALTO</b>:&nbsp;' . $pTinettiEquilibrioAlcanzarObjetoAlto . ',&nbsp;&nbsp;<b>AGACHARSE A RECOGER UN OBJETO DEL PISO</b>:&nbsp;' . $pTinettiEquilibrioAgacharse . ',&nbsp;&nbsp;<b>SENTARSE EN UN SILLA</b>:&nbsp;' . $pTinettiEquilibrioSentarse . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;PUNTAJE TOTAL</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["PuntajeTotalTinettiEquilibrio"]) . '</span><br><br>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            //POSTUROGRAFIA
            /*pacientes_evolucionhc_clinicacaidas_009.IndiceCaida AS intIndiceCaidaW003,
pacientes_evolucionhc_clinicacaidas_009.IndiceEquilibrio AS ,
pacientes_evolucionhc_clinicacaidas_009.IndiceBalanceo_1 AS intIndiceBalanceo_1W003,
pacientes_evolucionhc_clinicacaidas_009.IndiceBalanceo_2 AS intIndiceBalanceo_2W003,
pacientes_evolucionhc_clinicacaidas_009.IndiceBalanceo_3 AS intIndiceBalanceo_3W003,
pacientes_evolucionhc_clinicacaidas_009.IndiceBalanceo_4 AS intIndiceBalanceo_4W003,
pacientes_evolucionhc_clinicacaidas_009.DesvisionEstandar_1 AS intDesvisionEstandar_1W003,
pacientes_evolucionhc_clinicacaidas_009.DesvisionEstandar_2 AS intDesvisionEstandar_2W003,
pacientes_evolucionhc_clinicacaidas_009.DesvisionEstandar_3 AS intDesvisionEstandar_3W003,
pacientes_evolucionhc_clinicacaidas_009.DesvisionEstandar_4 AS intDesvisionEstandar_4W003,
pacientes_evolucionhc_clinicacaidas_009.CondicionResultado_1 AS intCondicionResultado_1W003,
pacientes_evolucionhc_clinicacaidas_009.CondicionResultado_2 AS intCondicionResultado_2W003,
pacientes_evolucionhc_clinicacaidas_009.CondicionResultado_3 AS intCondicionResultado_3W003,
pacientes_evolucionhc_clinicacaidas_009.CondicionResultado_4 AS intCondicionResultado_4W003,
pacientes_evolucionhc_clinicacaidas_009.InterpretacionPosturografia AS ,
*/
                     
                    
            if(utf8_decode($rowExamenFisicoTF[0]["intIndiceCaidaW003"]) != "" || utf8_decode($rowExamenFisicoTF[0]["intIndiceEquilibrioW003"]) != "" || utf8_decode($rowExamenFisicoTF[0]["intIndiceBalanceo_1W003"]) != "" || utf8_decode($rowExamenFisicoTF[0]["intIndiceBalanceo_2W003"]) != "" || utf8_decode($rowExamenFisicoTF[0]["intIndiceBalanceo_3W003"]) != "" || utf8_decode($rowExamenFisicoTF[0]["intIndiceBalanceo_4W003"]) != "" || utf8_decode($rowExamenFisicoTF[0]["intDesvisionEstandar_1W003"]) != "" || utf8_decode($rowExamenFisicoTF[0]["intDesvisionEstandar_2W003"]) != ""  || utf8_decode($rowExamenFisicoTF[0]["intDesvisionEstandar_3W003"]) != "" || utf8_decode($rowExamenFisicoTF[0]["intDesvisionEstandar_4W003"]) != "" || utf8_decode($rowExamenFisicoTF[0]["intCondicionResultado_1W003"]) != "" || utf8_decode($rowExamenFisicoTF[0]["intCondicionResultado_2W003"]) != "" || utf8_decode($rowExamenFisicoTF[0]["intCondicionResultado_3W003"]) != "" || utf8_decode($rowExamenFisicoTF[0]["intCondicionResultado_4W003"]) != "" || utf8_decode($rowExamenFisicoTF[0]["memInterpretacionPosturografiaW003"]) != ""){
                $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>POSTUROGRAFIA:</b></span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
                $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>INDICE DE CAIDA</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["intIndiceCaidaW003"]) . '&nbsp;&nbsp;-&nbsp;&nbsp;<b>INDICE DE EQUILIBRIO</b>:&nbsp;' . utf8_decode($rowExamenFisicoTF[0]["intIndiceEquilibrioW003"]) . '</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
                $mostrarHC = '<span style="font-size:30px;">';
                $mostrarHC .= '<table border="1">';
                $mostrarHC .= '<tr>';
                $mostrarHC .= '<td width="400" align="center"><b>Condicion</b></td>';
                $mostrarHC .= '<td width="60" align="center"><b>Indice Balanceo</b></td>';
                $mostrarHC .= '<td width="60" align="center"><b>Desviación Estandar</b></td>';
                $mostrarHC .= '<td></td>';
                $mostrarHC .= '</tr>';
                $mostrarHC .= '<tr>';
                $mostrarHC .= '<td><b>Condición 1: Integración Visual y Somatosensorial.</b></td>';
                $mostrarHC .= '<td align="center">' . utf8_decode($rowExamenFisicoTF[0]["intIndiceBalanceo_1W003"]) . '</td>';
                $mostrarHC .= '<td align="center">' . utf8_decode($rowExamenFisicoTF[0]["intDesvisionEstandar_1W003"]) . '</td>';
                $mostrarHC .= '<td align="center">' . utf8_decode($rowExamenFisicoTF[0]["intCondicionResultado_1W003"]) . '</td>';
                $mostrarHC .= '</tr>';
                $mostrarHC .= '<tr>';
                $mostrarHC .= '<td><b>Condición 2: Integración Somatosensorial y Vestibular.</b></td>';
                $mostrarHC .= '<td align="center">' . utf8_decode($rowExamenFisicoTF[0]["intIndiceBalanceo_2W003"]) . '</td>';
                $mostrarHC .= '<td align="center">' . utf8_decode($rowExamenFisicoTF[0]["intDesvisionEstandar_2W003"]) . '</td>';
                $mostrarHC .= '<td align="center">' . utf8_decode($rowExamenFisicoTF[0]["intCondicionResultado_2W003"]) . '</td>';
                $mostrarHC .= '</tr>';
                $mostrarHC .= '<tr>';
                $mostrarHC .= '<td><b>Condición 3: Integración Propioceptivo y Vestibular.</b></td>';
                $mostrarHC .= '<td align="center">' . utf8_decode($rowExamenFisicoTF[0]["intIndiceBalanceo_3W003"]) . '</td>';
                $mostrarHC .= '<td align="center">' . utf8_decode($rowExamenFisicoTF[0]["intDesvisionEstandar_3W003"]) . '</td>';
                $mostrarHC .= '<td align="center">' . utf8_decode($rowExamenFisicoTF[0]["intCondicionResultado_3W003"]) . '</td>';
                $mostrarHC .= '</tr>';
                $mostrarHC .= '<tr>';
                $mostrarHC .= '<td><b>Condición 4: Integración Propioceptivo, Somatosensorial y Vestibular.</b></td>';
                $mostrarHC .= '<td align="center">' . utf8_decode($rowExamenFisicoTF[0]["intIndiceBalanceo_4W003"]) . '</td>';
                $mostrarHC .= '<td align="center">' . utf8_decode($rowExamenFisicoTF[0]["intDesvisionEstandar_4W003"]) . '</td>';
                $mostrarHC .= '<td align="center">' . utf8_decode($rowExamenFisicoTF[0]["intCondicionResultado_4W003"]) . '</td>';
                $mostrarHC .= '</tr>';
                $mostrarHC .= '</table></span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
                $pdf->Ln(-3);
                $mostrarHC = '<span style="font-size:30px; text-align:justify;">' . utf8_decode($rowExamenFisicoTF[0]["memInterpretacionPosturografiaW003"]) . '</span><br><br>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            
            //Generacion Impresion de los Test
            unset($rowTest);
            $gBaseDatos = new ofiMySQLi();
            $gBaseDatos->conectar();
            $qry = "CALL sp_asistencial_civyc_loadtest001('" . $pEvolucion . "')";
            $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
            while ($rowTest[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
            $gBaseDatos->liberar();
            $gBaseDatos->cerrar();
            if(utf8_decode($rowTest[0]["intAnexo1PuntajeTotal"]) != ""){
                $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>FES-1 ESCALA DE AUTOEFICACIA RELACIONADA CON CAIDAS:</b>&nbsp;' . utf8_decode($rowTest[0]["intAnexo1PuntajeTotal"]) . '</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            
            unset($rowTest);
            $gBaseDatos = new ofiMySQLi();
            $gBaseDatos->conectar();
            $qry = "CALL sp_asistencial_civyc_loadtest002('" . $pEvolucion . "')";
            $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
            while ($rowTest[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
            $gBaseDatos->liberar();
            $gBaseDatos->cerrar();
            if(utf8_decode($rowTest[0]["intAnexo2PuntajeTotal"]) != ""){
                $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>INDICE DE BARTHEL:</b>&nbsp;' . utf8_decode($rowTest[0]["intAnexo2PuntajeTotal"]) . '</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            
            unset($rowTest);
            $gBaseDatos = new ofiMySQLi();
            $gBaseDatos->conectar();
            $qry = "CALL sp_asistencial_civyc_loadtest003('" . $pEvolucion . "')";
            $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
            while ($rowTest[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
            $gBaseDatos->liberar();
            $gBaseDatos->cerrar();
            if(utf8_decode($rowTest[0]["strtest003PuntajeTotal"]) != ""){
                $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>ESCALA DE LAWTON Y BRODY:</b>&nbsp;' . utf8_decode($rowTest[0]["strtest003PuntajeTotal"]) . '</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            
            unset($rowTest);
            $gBaseDatos = new ofiMySQLi();
            $gBaseDatos->conectar();
            $qry = "CALL sp_asistencial_civyc_loadtest005('" . $pEvolucion . "')";
            $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
            while ($rowTest[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
            $gBaseDatos->liberar();
            $gBaseDatos->cerrar();
            if(utf8_decode($rowTest[0]["intAnexo5PuntajeTotal"]) != ""){
                $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>VALORACION COGNOSCITIVA "Minimental":</b>&nbsp;' . utf8_decode($rowTest[0]["intAnexo5PuntajeTotal"]) . '/30</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            
            unset($rowTest);
            $gBaseDatos = new ofiMySQLi();
            $gBaseDatos->conectar();
            $qry = "CALL sp_asistencial_civyc_loadtest006('" . $pEvolucion . "')";
            $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
            while ($rowTest[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
            $gBaseDatos->liberar();
            $gBaseDatos->cerrar();
            if(utf8_decode($rowTest[0]["intAnexo6PuntajeTotal"]) != ""){
                $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>ESCALA DE DEPRESION GERIATRICA, YESAVAGE (GDS):</b>&nbsp;' . utf8_decode($rowTest[0]["intAnexo6PuntajeTotal"]) . '</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            
            unset($rowTest);
            $gBaseDatos = new ofiMySQLi();
            $gBaseDatos->conectar();
            $qry = "CALL sp_asistencial_civyc_loadtest007('" . $pEvolucion . "')";
            $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
            while ($rowTest[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
            $gBaseDatos->liberar();
            $gBaseDatos->cerrar();
            if(utf8_decode($rowTest[0]["intHamiltonPuntajeTotal"]) != ""){
                $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>ESCALA DE HAMILTON:</b>&nbsp;' . utf8_decode($rowTest[0]["intHamiltonPuntajeTotal"]) . '</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            
            unset($rowTest);
            $gBaseDatos = new ofiMySQLi();
            $gBaseDatos->conectar();
            $qry = "CALL sp_asistencial_civyc_loadtest008('" . $pEvolucion . "')";
            $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
            while ($rowTest[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
            $gBaseDatos->liberar();
            $gBaseDatos->cerrar();
            if(utf8_decode($rowTest[0]["intAnexo8PuntajeTotal"]) != ""){
                $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>PRUEBAS DE EJECUCION FISICA (SPPB):</b>&nbsp;' . utf8_decode($rowTest[0]["intAnexo8PuntajeTotal"]) . '</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            
            unset($rowTest);
            $gBaseDatos = new ofiMySQLi();
            $gBaseDatos->conectar();
            $qry = "CALL sp_asistencial_civyc_loadtest009('" . $pEvolucion . "')";
            $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
            while ($rowTest[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
            $gBaseDatos->liberar();
            $gBaseDatos->cerrar();
            if(utf8_decode($rowTest[0]["intAnexo9PuntajeTotal"]) != ""){
                $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>Mini Nutritional Assessment MNA:</b>&nbsp;' . utf8_decode($rowTest[0]["intAnexo9PuntajeTotal"]) . ' - ' . utf8_decode($rowTest[0]["strAnexo9ClasificaPuntajeTotal"]) . '</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            
            unset($rowTest);
            $gBaseDatos = new ofiMySQLi();
            $gBaseDatos->conectar();
            $qry = "CALL sp_asistencial_civyc_loadtest010('" . $pEvolucion . "')";
            $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
            while ($rowTest[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
            $gBaseDatos->liberar();
            $gBaseDatos->cerrar();
            if(utf8_decode($rowTest[0]["intAnexo10PuntajeIndiceGlobal"]) != ""){
                $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>ESCALA DE APOYO SOCIAL MOS:</b>&nbsp;' . utf8_decode($rowTest[0]["intAnexo10PuntajeIndiceGlobal"]) . ' - ' . utf8_decode($rowTest[0]["strAnexo10ClasificaIndiceGlobal"]) . '</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            
            unset($rowTest);
            $gBaseDatos = new ofiMySQLi();
            $gBaseDatos->conectar();
            $qry = "CALL sp_asistencial_civyc_loadtest011('" . $pEvolucion . "')";
            $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
            while ($rowTest[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
            $gBaseDatos->liberar();
            $gBaseDatos->cerrar();
            if(utf8_decode($rowTest[0]["strAnexo11FracturaMayorFRAX"]) != ""){
                $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>INDICE RIESGO DE FRACTURA FRAX:</b>&nbsp;' . utf8_decode($rowTest[0]["strAnexo11FracturaMayorFRAX"]) . '</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            if(utf8_decode($rowTest[0]["strAnexo11PorcentajeFracturaCaderaFRAX"]) != ""){
                $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>PORCENTAJE FRACTURA DE CADERA:</b>&nbsp;' . utf8_decode($rowTest[0]["strAnexo11PorcentajeFracturaCaderaFRAX"]) . '</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            //Fin Test
            
            
            unset($rowDxPpal);
            $gBaseDatos = new ofiMySQLi();
            $gBaseDatos->conectar();
            $qry = "CALL sp_asistencial_civyc_printhc_06_dxppal('" . $pEvolucion . "')";
            $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
            while ($rowDxPpal[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
            $gBaseDatos->liberar();
            $gBaseDatos->cerrar();
            
            unset($rowDxRel1);
            $gBaseDatos = new ofiMySQLi();
            $gBaseDatos->conectar();
            $qry = "CALL sp_asistencial_civyc_printhc_06_rel1('" . $pEvolucion . "')";
            $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
            while ($rowDxRel1[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
            $gBaseDatos->liberar();
            $gBaseDatos->cerrar();
            
            unset($rowDxRel2);
            $gBaseDatos = new ofiMySQLi();
            $gBaseDatos->conectar();
            $qry = "CALL sp_asistencial_civyc_printhc_06_rel2('" . $pEvolucion . "')";
            $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
            while ($rowDxRel2[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
            $gBaseDatos->liberar();
            $gBaseDatos->cerrar();
            
            unset($rowDxRel3);
            $gBaseDatos = new ofiMySQLi();
            $gBaseDatos->conectar();
            $qry = "CALL sp_asistencial_civyc_printhc_06_rel3('" . $pEvolucion . "')";
            $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
            while ($rowDxRel3[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
            $gBaseDatos->liberar();
            $gBaseDatos->cerrar();
            
            unset($rowDiagnosticos);
            $gBaseDatos = new ofiMySQLi();
            $gBaseDatos->conectar();
            $qry = "CALL sp_asistencial_civyc_printhc_06('" . $pEvolucion . "')";
            $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
            while ($rowDiagnosticos[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
            $gBaseDatos->liberar();
            $gBaseDatos->cerrar();
            
            $mostrarHC = '<br><br><span style="font-size:30px; text-align:justify;"><b>DIAGNOSTICOS</b>:&nbsp;</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;">&nbsp;&nbsp;<b>- MEDICOS</b>:&nbsp;</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;DIAGNOSTICO PPAL:</b>:&nbsp;' . utf8_decode($rowDxPpal[0]["DiagPpal"]) . ',&nbsp;-&nbsp;' . utf8_decode($rowDxPpal[0]["Des_Diagnostico"]) . ',&nbsp;&nbsp;<b>COMPENSADO?</b>:&nbsp;' . utf8_decode($rowDxPpal[0]["DiagPpalHCEstado"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            if(utf8_decode($rowDxRel1[0]["DiagRel1"]) != "" && utf8_decode($rowDxRel1[0]["DiagRel1"]) != null){
                $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;DIAGNOSTICO REL1:</b>:&nbsp;' . utf8_decode($rowDxRel1[0]["DiagRel1"]) . ',&nbsp;-&nbsp;' . utf8_decode($rowDxRel1[0]["Des_DiagnosticoRel1"]) . ',&nbsp;&nbsp;<b>COMPENSADO</b>:&nbsp;' . utf8_decode($rowDxRel1[0]["DiagRel1HCEstado"]) . '</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            if(utf8_decode($rowDxRel2[0]["DiagRel2"]) != "" && utf8_decode($rowDxRel2[0]["DiagRel2"]) != null){
                $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;DIAGNOSTICO REL2:</b>:&nbsp;' . utf8_decode($rowDxRel2[0]["DiagRel2"]) . ',&nbsp;-&nbsp;' . utf8_decode($rowDxRel2[0]["Des_DiagnosticoRel2"]) . ',&nbsp;&nbsp;<b>COMPENSADO</b>:&nbsp;' . utf8_decode($rowDxRel2[0]["DiagRel2HCEstado"]) . '</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            if(utf8_decode($rowDxRel3[0]["DiagRel3"]) != "" && utf8_decode($rowDxRel3[0]["DiagRel3"]) != null){
                $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;DIAGNOSTICO REL3:</b>:&nbsp;' . utf8_decode($rowDxRel3[0]["DiagRel3"]) . ',&nbsp;-&nbsp;' . utf8_decode($rowDxRel3[0]["Des_DiagnosticoRel3"]) . ',&nbsp;&nbsp;<b>COMPENSADO</b>:&nbsp;' . utf8_decode($rowDxRel3[0]["DiagRel3HCEstado"]) . '</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;FINALIDAD:</b>:&nbsp;' . utf8_decode($rowDiagnosticos[0]["Des_FinalidadConsulta"]) . ',&nbsp;&nbsp;<b>CAUSA EXTERNA</b>:&nbsp;' . utf8_decode($rowDiagnosticos[0]["Des_CausaExterna"]) . ',&nbsp;&nbsp;<b>TIPO DX</b>:&nbsp;' . utf8_decode($rowDiagnosticos[0]["Des_TipDiag"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            if(utf8_decode($rowDiagnosticos[0]["DiagFunc1Nom"]) != "" || utf8_decode($rowDiagnosticos[0]["DiagFunc2Nom"]) != "" || utf8_decode($rowDiagnosticos[0]["DiagFunc3Nom"]) != "" || utf8_decode($rowDiagnosticos[0]["DiagFunc4Nom"]) != "" || utf8_decode($rowDiagnosticos[0]["DiagFunc5Nom"]) != ""){
                $mostrarHC = '<span style="font-size:30px; text-align:justify;">&nbsp;&nbsp;<b>- FUNCIONALES</b>:&nbsp;</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
                $idContador = 0;
                if(utf8_decode($rowDiagnosticos[0]["DiagFunc1Nom"]) != ""){
                    $idContador ++;
                    $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;' . $idContador . '.:</b>:&nbsp;' . utf8_decode($rowDiagnosticos[0]["DiagFunc1Cod"]) . ',&nbsp;-&nbsp;' . utf8_decode($rowDiagnosticos[0]["DiagFunc1Nom"]) . ',&nbsp;&nbsp;<b>COMPENSADO</b>:&nbsp;' . utf8_decode($rowDiagnosticos[0]["DiagFunc1Estado"]) . '</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
                if(utf8_decode($rowDiagnosticos[0]["DiagFunc2Nom"]) != ""){
                    $idContador ++;
                    $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;' . $idContador . '.:</b>:&nbsp;' . utf8_decode($rowDiagnosticos[0]["DiagFunc2Cod"]) . ',&nbsp;-&nbsp;' . utf8_decode($rowDiagnosticos[0]["DiagFunc2Nom"]) . ',&nbsp;&nbsp;<b>COMPENSADO</b>:&nbsp;' . utf8_decode($rowDiagnosticos[0]["DiagFunc2Estado"]) . '</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
                if(utf8_decode($rowDiagnosticos[0]["DiagFunc3Nom"]) != ""){
                    $idContador ++;
                    $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;' . $idContador . '.:</b>:&nbsp;' . utf8_decode($rowDiagnosticos[0]["DiagFunc3Cod"]) . ',&nbsp;-&nbsp;' . utf8_decode($rowDiagnosticos[0]["DiagFunc3Nom"]) . ',&nbsp;&nbsp;<b>COMPENSADO</b>:&nbsp;' . utf8_decode($rowDiagnosticos[0]["DiagFunc3Estado"]) . '</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
                if(utf8_decode($rowDiagnosticos[0]["DiagFunc4Nom"]) != ""){
                    $idContador ++;
                    $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;' . $idContador . '.:</b>:&nbsp;' . utf8_decode($rowDiagnosticos[0]["DiagFunc4Cod"]) . ',&nbsp;-&nbsp;' . utf8_decode($rowDiagnosticos[0]["DiagFunc4Nom"]) . ',&nbsp;&nbsp;<b>COMPENSADO</b>:&nbsp;' . utf8_decode($rowDiagnosticos[0]["DiagFunc4Estado"]) . '</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
                if(utf8_decode($rowDiagnosticos[0]["DiagFunc5Nom"]) != ""){
                    $idContador ++;
                    $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;' . $idContador . '.:</b>:&nbsp;' . utf8_decode($rowDiagnosticos[0]["DiagFunc5Cod"]) . ',&nbsp;-&nbsp;' . utf8_decode($rowDiagnosticos[0]["DiagFunc5Nom"]) . ',&nbsp;&nbsp;<b>COMPENSADO</b>:&nbsp;' . utf8_decode($rowDiagnosticos[0]["DiagFunc5Estado"]) . '</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
            }
            if(utf8_decode($rowDiagnosticos[0]["DiagPsiq1Nom"]) != "" || utf8_decode($rowDiagnosticos[0]["DiagPsiq2Nom"]) != "" || utf8_decode($rowDiagnosticos[0]["DiagPsiq3Nom"]) != "" || utf8_decode($rowDiagnosticos[0]["DiagPsiq4Nom"]) != "" || utf8_decode($rowDiagnosticos[0]["DiagPsiq5Nom"]) != ""){
                $mostrarHC = '<span style="font-size:30px; text-align:justify;">&nbsp;&nbsp;<b>- PSIQUICOS</b>:&nbsp;</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
                $idContador = 0;
                if(utf8_decode($rowDiagnosticos[0]["DiagPsiq1Nom"]) != ""){
                    $idContador ++;
                    $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;' . $idContador . '.:</b>:&nbsp;' . utf8_decode($rowDiagnosticos[0]["DiagPsiq1Cod"]) . ',&nbsp;-&nbsp;' . utf8_decode($rowDiagnosticos[0]["DiagPsiq1Nom"]) . ',&nbsp;&nbsp;<b>COMPENSADO</b>:&nbsp;' . utf8_decode($rowDiagnosticos[0]["DiagPsiq1Estado"]) . '</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
                if(utf8_decode($rowDiagnosticos[0]["DiagPsiq2Nom"]) != ""){
                    $idContador ++;
                    $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;' . $idContador . '.:</b>:&nbsp;' . utf8_decode($rowDiagnosticos[0]["DiagPsiq2Cod"]) . ',&nbsp;-&nbsp;' . utf8_decode($rowDiagnosticos[0]["DiagPsiq2Nom"]) . ',&nbsp;&nbsp;<b>COMPENSADO</b>:&nbsp;' . utf8_decode($rowDiagnosticos[0]["DiagPsiq2Estado"]) . '</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
                if(utf8_decode($rowDiagnosticos[0]["DiagPsiq3Nom"]) != ""){
                    $idContador ++;
                    $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;' . $idContador . '.:</b>:&nbsp;' . utf8_decode($rowDiagnosticos[0]["DiagPsiq3Cod"]) . ',&nbsp;-&nbsp;' . utf8_decode($rowDiagnosticos[0]["DiagPsiq3Nom"]) . ',&nbsp;&nbsp;<b>COMPENSADO</b>:&nbsp;' . utf8_decode($rowDiagnosticos[0]["DiagPsiq3Estado"]) . '</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
                if(utf8_decode($rowDiagnosticos[0]["DiagPsiq4Nom"]) != ""){
                    $idContador ++;
                    $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;' . $idContador . '.:</b>:&nbsp;' . utf8_decode($rowDiagnosticos[0]["DiagPsiq4Cod"]) . ',&nbsp;-&nbsp;' . utf8_decode($rowDiagnosticos[0]["DiagPsiq4Nom"]) . ',&nbsp;&nbsp;<b>COMPENSADO</b>:&nbsp;' . utf8_decode($rowDiagnosticos[0]["DiagPsiq4Estado"]) . '</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
                if(utf8_decode($rowDiagnosticos[0]["DiagPsiq5Nom"]) != ""){
                    $idContador ++;
                    $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;' . $idContador . '.:</b>:&nbsp;' . utf8_decode($rowDiagnosticos[0]["DiagPsiq5Cod"]) . ',&nbsp;-&nbsp;' . utf8_decode($rowDiagnosticos[0]["DiagPsiq5Nom"]) . ',&nbsp;&nbsp;<b>COMPENSADO</b>:&nbsp;' . utf8_decode($rowDiagnosticos[0]["DiagPsiq5Estado"]) . '</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
            }
            if(utf8_decode($rowDiagnosticos[0]["DiagSoc1Nom"]) != "" || utf8_decode($rowDiagnosticos[0]["DiagSoc2Nom"]) != "" || utf8_decode($rowDiagnosticos[0]["DiagSoc3Nom"]) != "" || utf8_decode($rowDiagnosticos[0]["DiagSoc4Nom"]) != "" || utf8_decode($rowDiagnosticos[0]["DiagSoc5Nom"]) != ""){
                $mostrarHC = '<span style="font-size:30px; text-align:justify;">&nbsp;&nbsp;<b>- SOCIALES</b>:&nbsp;</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
                $idContador = 0;
                if(utf8_decode($rowDiagnosticos[0]["DiagSoc1Nom"]) != ""){
                    $idContador ++;
                    $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;' . $idContador . '.:</b>:&nbsp;' . utf8_decode($rowDiagnosticos[0]["DiagSoc1Cod"]) . ',&nbsp;-&nbsp;' . utf8_decode($rowDiagnosticos[0]["DiagSoc1Nom"]) . ',&nbsp;&nbsp;<b>COMPENSADO</b>:&nbsp;' . utf8_decode($rowDiagnosticos[0]["DiagSoc1Estado"]) . '</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
                if(utf8_decode($rowDiagnosticos[0]["DiagSoc2Nom"]) != ""){
                    $idContador ++;
                    $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;' . $idContador . '.:</b>:&nbsp;' . utf8_decode($rowDiagnosticos[0]["DiagSoc2Cod"]) . ',&nbsp;-&nbsp;' . utf8_decode($rowDiagnosticos[0]["DiagSoc2Nom"]) . ',&nbsp;&nbsp;<b>COMPENSADO</b>:&nbsp;' . utf8_decode($rowDiagnosticos[0]["DiagSoc2Estado"]) . '</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
                if(utf8_decode($rowDiagnosticos[0]["DiagSoc3Nom"]) != ""){
                    $idContador ++;
                    $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;' . $idContador . '.:</b>:&nbsp;' . utf8_decode($rowDiagnosticos[0]["DiagSoc3Cod"]) . ',&nbsp;-&nbsp;' . utf8_decode($rowDiagnosticos[0]["DiagSoc3Nom"]) . ',&nbsp;&nbsp;<b>COMPENSADO</b>:&nbsp;' . utf8_decode($rowDiagnosticos[0]["DiagSoc3Estado"]) . '</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
                if(utf8_decode($rowDiagnosticos[0]["DiagSoc4Nom"]) != ""){
                    $idContador ++;
                    $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;' . $idContador . '.:</b>:&nbsp;' . utf8_decode($rowDiagnosticos[0]["DiagSoc4Cod"]) . ',&nbsp;-&nbsp;' . utf8_decode($rowDiagnosticos[0]["DiagSoc4Nom"]) . ',&nbsp;&nbsp;<b>COMPENSADO</b>:&nbsp;' . utf8_decode($rowDiagnosticos[0]["DiagSoc4Estado"]) . '</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
                if(utf8_decode($rowDiagnosticos[0]["DiagSoc5Nom"]) != ""){
                    $idContador ++;
                    $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;' . $idContador . '.:</b>:&nbsp;' . utf8_decode($rowDiagnosticos[0]["DiagSoc5Cod"]) . ',&nbsp;-&nbsp;' . utf8_decode($rowDiagnosticos[0]["DiagSoc5Nom"]) . ',&nbsp;&nbsp;<b>COMPENSADO</b>:&nbsp;' . utf8_decode($rowDiagnosticos[0]["DiagSoc5Estado"]) . '</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
            }
            
            unset($rowRecomendaciones);
            $gBaseDatos = new ofiMySQLi();
            $gBaseDatos->conectar();
            $qry = "CALL sp_asistencial_civyc_printhc_07('" . $pEvolucion . "')";
            $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
            while ($rowRecomendaciones[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
            $gBaseDatos->liberar();
            $gBaseDatos->cerrar();
            
            if(utf8_decode($rowRecomendaciones[0]["Analisis"]) != ""){
                $mostrarHC = '<br><br><span style="font-size:30px; text-align:justify;"><b>ANALISIS:</b>&nbsp;' . utf8_decode($rowRecomendaciones[0]["Analisis"]) . '</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
                
            $mostrarHC = '<br><br><span style="font-size:30px; text-align:justify;"><b>RECOMENDACIONES PLAN DE TRATAMIENTO E INTERVENCIONES</b>:&nbsp;</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;">&nbsp;&nbsp;<b>- MEDICAS</b>:&nbsp;</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;REMISION A ESPECIALISTA</b>:&nbsp;' . utf8_decode($rowRecomendaciones[0]["RemisionEspecialista"]) . ',&nbsp;<b>SOLICITUD DE EXAMENES DIAGNOSTICOS</b>:&nbsp;' . utf8_decode($rowDiagnosticos[0]["SolicitudExamenesDiagnosticos"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;NUEVOS MEDICAMENTOS</b>:&nbsp;' . utf8_decode($rowRecomendaciones[0]["NuevosMedicamentos"]) . ',&nbsp;<b>ADECUACION DE DOSIS O VIA</b>:&nbsp;' . utf8_decode($rowDiagnosticos[0]["AdecuacionDosis"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;SUSPENCION DE MEDICAMENTOS</b>:&nbsp;' . utf8_decode($rowRecomendaciones[0]["SuspensionMedicamentos"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;">&nbsp;&nbsp;<b>- REHABILITACION</b>:&nbsp;</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;REHABILITACION VESTIBULAR</b>:&nbsp;' . utf8_decode($rowRecomendaciones[0]["RehabilitacionVestibular"]) . ',&nbsp;<b>REHABILITACION DE EQUILIBRIO</b>:&nbsp;' . utf8_decode($rowDiagnosticos[0]["RehabilitacionEquilibrio"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;REHABILITACION DE MARCHA</b>:&nbsp;' . utf8_decode($rowRecomendaciones[0]["RehabilitacionMarcha"]) . ',&nbsp;<b>OTRA</b>:&nbsp;' . utf8_decode($rowDiagnosticos[0]["RehabilitacionOtra"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;REMISION A OTRO PROFESIONAL</b>:&nbsp;' . utf8_decode($rowRecomendaciones[0]["RehabilitacionRemisionProfesional"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;">&nbsp;&nbsp;<b>- OTRAS REMISIONES</b>:&nbsp;</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;SERVICIOS COMUNITARIOS</b>:&nbsp;' . utf8_decode($rowRecomendaciones[0]["ServiciosComunitarios"]) . ',&nbsp;<b>CLINICAS ESPECIALIZADAS</b>:&nbsp;' . utf8_decode($rowDiagnosticos[0]["ClinicasEspecializadas"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;">&nbsp;&nbsp;<b>- MEDIO AMBIENTALES</b>:&nbsp;</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;MODIFICACIONES O AYUDAS EN CASA</b>:&nbsp;' . utf8_decode($rowRecomendaciones[0]["ModificacionesAyudasCasa"]) . ',&nbsp;<b>CAMBIOS O AJUSTES EN AYUDAS PARA LA MARCHA</b>:&nbsp;' . utf8_decode($rowDiagnosticos[0]["CambiosAjustesAyudasMarcha"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;">&nbsp;&nbsp;<b>- OTRAS RECOMENDACIONES</b>:&nbsp;</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;EDUCACION</b>:&nbsp;' . utf8_decode($rowRecomendaciones[0]["Educacion"]) . ',&nbsp;<b>MODIFICACIONES CONDUCTUALES (HABITOS, ESTILOS DE VIDA)</b>:&nbsp;' . utf8_decode($rowDiagnosticos[0]["ModificacionesConductuales"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px; text-align:justify;"><b>&nbsp;&nbsp;&nbsp;&nbsp;RECOMENDACIONES A CUIDADORES</b>:&nbsp;' . utf8_decode($rowRecomendaciones[0]["RecomendacionesCuidadores"]) . ',&nbsp;<b>OTROS</b>:&nbsp;' . utf8_decode($rowDiagnosticos[0]["RecomendacionesOtros"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<br><br>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            
            $idPaciente = $row[$i]["nomPaciente"];
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
        }
    }

    $pdf->Ln();
    $pdf->Output('infHistoriaCIVyC.pdf', 'I');

    function EncabezadoPagina(&$pdf, &$row, &$i, &$rowcount, &$contador, &$pDesde, &$pHasta){
        $idReg = $i;
        $ojo = "nada";
        if($row[$idReg]["Paciente"]=="" || $row[$idReg]["Paciente"]==null){
            $idReg = 0;
        }
        $pdf->AddPage();
        $pdf->Ln(0.5);
        $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
        $EncabezadoHTML = '<table cellspacing="0" border="0" style="font-size:24px; color:#000;">';
        $EncabezadoHTML .= '<tr>';
        $EncabezadoHTML .= '<td width="500">';
        $EncabezadoHTML .= '<span style="font-size:44px; color:#000; font-weight:bold">' . utf8_decode($pdf->pNomEmpresa) . '</span><br>';
        if($pdf->pEspEmpresa != null || $pdf->pEspEmpresa != "")
                $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . utf8_decode($pdf->pEspEmpresa) . '</span><br>';
        $EncabezadoHTML .= '</td>';

        //COL2
        $EncabezadoHTML .= '<td width="220" align="right">';
        if (file_exists("../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/logoenc.gif")) {
            $EncabezadoHTML .= '<img src="../../../empresas/' . $_SESSION['ID_EMPRESA'] . '/logo/logoenc.gif" align="right"/>';
            $EncabezadoHTML .= '<br>';
        }else{
            if (file_exists("../../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/logoenc.gif")) {
                $EncabezadoHTML .= '<img src="../../../../empresas/' . $_SESSION['ID_EMPRESA'] . '/logo/logoenc.gif" align="right"/>';
                $EncabezadoHTML .= '<br>';
            }
        }
        $EncabezadoHTML .= '<span align="rigth" style="font-size:40px; color:#000; font-weight:bold">HISTORIA CLINICA</span><br>';
        $EncabezadoHTML .= '<span align="rigth" style="font-size:38px; color:#000; font-weight:bold">FECHA EVALUACION<br>' . $row[$idReg]["FechaAtencion"] . '</span><br>';
        $EncabezadoHTML .= '<span align="rigth" style="font-size:26px; color:#000; font-weight:bold"></span>';
        $EncabezadoHTML .= '</td>';
        $EncabezadoHTML .= '</tr>';
        $EncabezadoHTML .= '</table>';
        $EncabezadoHTML .= '<hr>';
        $pdf->writeHTML($EncabezadoHTML, true, false, false, false, '');
    }

    
?>
