<?php

set_time_limit(500);
require_once('../../../lib/tcpdf/config/lang/spa.php');
require_once('../../../lib/tcpdf/tcpdf.php');
require("../../../core/php/_database.php");
require("../../../core/php/php_functions.php");
//header('Content-type: application/pdf; charset: UTF-8');

    session_start();
    $pConsultorioVirtual = $_SESSION['IDBD'];
    $nomEmpresa = $_SESSION['NOM_EMPRESA'];
    $nomUsuario = $_SESSION['NOM_USUARIO'];
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pEvolucion = isset($_REQUEST['pEvolucion'])?$_REQUEST['pEvolucion']:0;

    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_printhc('" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pEvolucion . "')";
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    while ($row[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $pRegistros = count($row);
    
    //Definicion de las Margenes
    $LeftMargin = PDF_MARGIN_LEFT;
    $TopMargin = 5;
    $RightMargin = PDF_MARGIN_RIGHT;
    $HeaderMargin = PDF_MARGIN_HEADER;
    $BottomMargin = 3;
    $FooterMargin = 5;
    $Alineacion = "P";
    $FormatoPagina = "CARTA";
    $UsaPiePagina = "SI";
    $pTipoEncabezado = "FVP";
    $pControlSalto = 30;
    
    //Inicializacion de la Clase
    $pdf = new TCPDF($Alineacion, PDF_UNIT, $FormatoPagina, true, 'UTF-8', false);
    //Inicializacion Variables de Control
    $pdf->pAlineacionEncabezado = $Alineacion;
    $pdf->pTituloInforme = "HISTORIA CLINICA";
    $pdf->pImprimeLogo = "NO";
    $pdf->pAnchoTxtPagina = 210;
    $pdf->pNomEmpresa = $_SESSION['NOM_EMPRESA'];
    $pdf->pTDocEmpresa = $_SESSION['EMPRESA_TDOC'];
    $pdf->pDocEmpresa = $_SESSION['EMPRESA_DOC'];
    $pdf->pDirEmpresa = $_SESSION['EMPRESA_DIR'];
    $pdf->pTelEmpresa = $_SESSION['EMPRESA_TEL'];
    $pdf->pCiuEmpresa = $_SESSION['EMPRESA_CIU'];
    $pdf->pEspEmpresa = $_SESSION['EMPRESA_ESP'];
    $pdf->pRegEmpresa = $_SESSION['EMPRESA_REGIMEN'];
    $pdf->pContribuyentes = $_SESSION['EMPRESA_CONTRIBUYENTE'];
    $pdf->pReteIVA  = $_SESSION['EMPRESA_RTEICA'];
    $pdf->pReteICA = $_SESSION['EMPRESA_RTEIVA'];
            
    $pdf->pTipoEncabezado = $pTipoEncabezado;
    $pdf->pNomSede = $_SESSION['EMPRESA_DOC'];
    $pdf->pNomIPS = $_SESSION['NOM_IPS'];
    $pdf->pMargenPie = -20;
    $pdf->pLogoCliente = "../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/logoenc.gif";
    $pdf->pPrefijo = 1; //$row[0]["Prefijo"];
    $pdf->pNroDocumento = 1; //str_pad($row[0]["NroDocumento"], 7, "0", STR_PAD_LEFT);
    $pdf->pNroResolucion = 1; //$row[0]["NroResolucion"];
    $pdf->pFechaDoc = 1; //$row[0]["FechaDocumento"];
    $pdf->pCAS = null;
    $pdf->pTratamiento = null;
    $pdf->pUsaPie = $UsaPiePagina;
        
    $pdf->SetCreator(PDF_CREATOR);
    $pdf->SetAuthor('Sistemas Ofisalud © - 2011');
    $pdf->SetTitle('Ofimedical©');
    $pdf->SetSubject('Soporte Historia Clinica');

    $pdf->SetHeaderData($pdf->pLogoCliente, PDF_HEADER_LOGO_WIDTH, $pdf->pTituloInforme, PDF_HEADER_STRING);
    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
    $pdf->SetMargins($LeftMargin, $TopMargin, $RightMargin);
    $pdf->SetHeaderMargin($HeaderMargin);
    $pdf->SetFooterMargin($FooterMargin);
    // set bacground image
    
    $pdf->SetAutoPageBreak(TRUE, $BottomMargin);
    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
    $pdf->setLanguageArray($l);
    $pdf->setFontSubsetting(true);
    $pdf->SetFont('dejavusans', '', 14, '', true);

    for($i=0;$i<$pRegistros;$i++)
    {
        if($row[$i]["nomPaciente"] != ""){
            if ($idPaciente != $row[$i]["nomPaciente"])
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
            $pdf->Ln(2);
            
            $mostrarHC = '<span colspan="2" style="font-size:25px; color:#0B0B61; font-weight:bolder;">Fecha y Hora de Atención: ' . utf8_decode($row[$i]["Fecha"]) . ' - ' . utf8_decode($row[$i]["HoraApertura"]) . '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;CAS:' . utf8_decode($row[$i]["CAS"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span colspan="2" style="font-size:22px; color:#000;"><b>Cliente: </b>' . utf8_decode($row[$i]["Cliente"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span colspan="2" style="font-size:22px; color:#000;"><b>Profesional Tratante: </b>' . utf8_decode($row[$i]["NomProfesional"]) . '</span><br>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span colspan="2" style="font-size:18px; color:#000;"><b>Finalidad: </b>' . utf8_decode($row[$i]["Finalidad"]) . '   -   <b>Causa Externa: </b>' . utf8_decode($row[$i]["CausaExterna"]) .  '   -   <b>Tipo Diagnostico: </b>' . utf8_decode($row[$i]["Des_TipDiag"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span colspan="2" style="font-size:18px; color:#000;"><b>Diagnostico Principal: </b>' . utf8_decode($row[$i]["Diagppal"]) . ' - ' . utf8_decode($row[$i]["DesDiagPpal"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            if (utf8_decode($row[$i]["Diagrel1"]) != "" && utf8_decode($row[$i]["Diagrel1"]) != null){
                $mostrarHC = '<span colspan="2" style="font-size:18px; color:#000;"><b>Diagnostico Relacionado Nro1: </b>' . utf8_decode($row[$i]["Diagrel1"]) . ' - ' . utf8_decode($row[$i]["DesDiagRel1"]) . '</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            if (utf8_decode($row[$i]["Diagrel2"]) != "" && utf8_decode($row[$i]["Diagrel2"]) != null){
                $mostrarHC = '<span colspan="2" style="font-size:18px; color:#000;"><b>Diagnostico Relacionado Nro2: </b>' . utf8_decode($row[$i]["Diagrel2"]) . ' - ' . utf8_decode($row[$i]["DesDiagRel2"]) . '</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            if (utf8_decode($row[$i]["Diagrel3"]) != "" && utf8_decode($row[$i]["Diagrel3"]) != null){
                $mostrarHC = '<span colspan="2" style="font-size:18px; color:#000;"><b>Diagnostico Relacionado Nro3: </b>' . utf8_decode($row[$i]["Diagrel3"]) . ' - ' . utf8_decode($row[$i]["DesDiagRel3"]) . '</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            $mostrarHC = '<hr>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $estructurahc = explode("¬",utf8_decode($row[$i]["Evolucion"])); 
            $reg = count($estructurahc)-1;
            $mostrarHC = "";
            $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
            for ($j=0; $j<$reg; $j++){ 
                $pPadding = 0;
                $contenidohc = explode("^~",$estructurahc[$j]);
                switch($contenidohc[1]){
                    case "TRUE":
                        $txtContenido = "SI";
                        break;

                    case "FALSE":
                        $txtContenido = "NO";
                        break;

                    default:
                        $txtContenido = $contenidohc[1];
                        break;
                }
                if(substr($contenidohc[2],0,3) == "bTB"){
                    $mostrarHC = '<span style="text-decoration:underline; font-size:18px; color:#000; font-weight:bolder">' . substr($contenidohc[2],3,strlen($contenidohc[2])) . ':</span><br>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                    {
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                        $pPadding = 15;
                }else{
                    if(substr($contenidohc[2],0,3) == "eTB"){
                        $pPadding = 0;
                    }else{
                        $mostrarHC = '<span style="padding-left:' . $pPadding .'px; text-decoration:underline; font-size:18px; color:#000; font-weight:bolder">' . $contenidohc[2] . ':</span>';
                        $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                        if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                        {
                            EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                        }
                        $mostrarHC = '<span style="text-align:justify; padding-left:' . $pPadding .'px; font-size:18px; color:#000;">' . $txtContenido . '</span><br>';
                        $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                        if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                        {
                            EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                        }
                    }
                }
            }
            $mostrarHC = '<br>';
            $mostrarHC .= '<table border="0" cellspacing="0">';
            if (file_exists('../../../empresas/' . $_SESSION['ID_EMPRESA']  . '/firmas/' . $row[$i]["Profesional"] . '.png')) {
                $mostrarHC .= '<tr>';
                $mostrarHC .= '<td width="500">&nbsp;</td>';
                $mostrarHC .= '<td width="200" valign="middle" align="left"><img src="../../../empresas/' . $_SESSION['ID_EMPRESA'] . '/firmas/' . $row[$i]["Profesional"] . '.png" width="100" height="25"/></td>';
                $mostrarHC .= '</tr>';
            }
            $mostrarHC .= '<tr>';
            $mostrarHC .= '<td width="500">&nbsp;</td>';
            $mostrarHC .= '<td width="200" align="left" style="border-top-width: 1px; border-top-style: solid;">' . utf8_decode($row[$i]["NomProfesional"]) . '</td>';
            $mostrarHC .= '</tr>';
            $mostrarHC .= '<tr>';
            $mostrarHC .= '<td>&nbsp;</td>';
            $mostrarHC .= '<td align="left">' . utf8_decode($row[$i]["nomEspecialidad"]) . '</td>';
            $mostrarHC .= '</tr>';
            $mostrarHC .= '<tr>';
            $mostrarHC .= '<td>&nbsp;</td>';
            $mostrarHC .= '<td align="left">Nro. Registro:' . utf8_decode($row[$i]["RegistroProfesional"]) . '</td>';
            $mostrarHC .= '</tr>';
            $mostrarHC .= '</table>';
            $mostrarHC .= '<hr>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            
            $idPaciente = $row[$i]["nomPaciente"];
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
        }
    }
    $pdf->Output('infSoporteHC.pdf', 'I');

    function EncabezadoPagina(&$pdf, &$row, &$i, &$rowcount, &$contador, &$pDesde, &$pHasta){
        $pdf->AddPage();
        $pdf->Ln(2);
        $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
        $EncabezadoHTML = '<table cellspacing="0" border="0" style="font-size:24px; color:#000;">';
        $EncabezadoHTML .= '<tr>';
        $EncabezadoHTML .= '<td>';
        $EncabezadoHTML .= '<span style="font-size:44px; color:#000; font-weight:bold">' . utf8_decode($pdf->pNomEmpresa) . '</span><br>';
        if($pdf->pEspEmpresa != null || $pdf->pEspEmpresa != "")
                $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . utf8_decode($pdf->pEspEmpresa) . '</span><br>';
        if($pdf->pTDocEmpresa == "NI"){
            $tipodoc = "NIT: ";
            $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $tipodoc . $pdf->pDocEmpresa . '</span><br>';
        }
        $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $pdf->pDirEmpresa . ' - ' . $pdf->pTelEmpresa . '</span><br>';
        $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $pdf->pCiuEmpresa . '</span><br><br>';
        $EncabezadoHTML .= '<span style="font-size:24px; color:#000;"><b>PACIENTE:&nbsp;&nbsp;</b>' . utf8_decode($row[$i]["TipDoc"]) . ' ' . utf8_decode($row[$i]["Documento"]) . ' - ' . utf8_decode($row[$i]["Nom1"]) . ' ' . utf8_decode($row[$i]["Nom2"]) . ' ' . utf8_decode($row[$i]["Ape1"]) . ' ' . utf8_decode($row[$i]["Ape2"]) . '</span><br>';
        if (utf8_decode($row[$i]["Genero"]) == "M")
            $EncabezadoHTML .= '<span style="font-size:24px; color:#000;"><b>GENERO:&nbsp;&nbsp;</b>MASCULINO</span><br>';
        else
            $EncabezadoHTML .= '<span style="font-size:24px; color:#000;"><b>GENERO:&nbsp;&nbsp;</b>FEMENINO</span><br>';
        $EncabezadoHTML .= '<span style="font-size:24px; color:#000;"><b>FECHA NACIMIENTO:&nbsp;&nbsp;</b>' . $row[$i]["FecNac"]  . '</span>';
        $EncabezadoHTML .= '</td>';

        //COL2
        $EncabezadoHTML .= '<td align="right">';
        if (file_exists("../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/logoenc.gif")) {
            $EncabezadoHTML .= '<img src="../../../empresas/' . $_SESSION['ID_EMPRESA'] . '/logo/logoenc.gif" align="right"/>';
            $EncabezadoHTML .= '<br>';
        }
        $EncabezadoHTML .= '<span align="rigth" style="font-size:44px; color:#000; font-weight:bold">HISTORIA CLINICA</span><br>';
        $EncabezadoHTML .= '<span align="rigth" style="font-size:26px; color:#000; font-weight:bold">Copia Controlada</span>';
        $EncabezadoHTML .= '</td>';
        $EncabezadoHTML .= '</tr>';
        $EncabezadoHTML .= '</table>';
        $EncabezadoHTML .= '<hr class="linea">';
        $pdf->writeHTML($EncabezadoHTML, true, false, false, false, '');
    }
    
?>
