<?php

//set_time_limit(500);
require_once('../../../lib/tcpdf/config/lang/spa.php');
require_once('../../../lib/tcpdf/tcpdf.php');
require("../../../core/php/_database.php");
require("../../../core/php/php_functions.php");
//header('Content-type: application/pdf; charset: UTF-8');

    session_start();
    $pConsultorioVirtual = $_SESSION['IDBD'];
    $nomEmpresa = $_SESSION['NOM_EMPRESA'];
    $nomUsuario = $_SESSION['NOM_USUARIO'];
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:1;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:1;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pEvolucion = isset($_REQUEST['pEvolucion'])?$_REQUEST['pEvolucion']:0;

    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_saludocupacional001_printhc('" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pEvolucion . "')";
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    while ($row[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $pRegistros = count($row);

    //Definicion de las Margenes
    $LeftMargin = PDF_MARGIN_LEFT;
    $TopMargin = 10;
    $RightMargin = PDF_MARGIN_RIGHT;
    $HeaderMargin = PDF_MARGIN_HEADER;
    $BottomMargin = 3;
    $FooterMargin = 5;
    $Alineacion = "P";
    $FormatoPagina = "CARTA";
    $UsaPiePagina = "SI";
    $pTipoEncabezado = "FVP";
    $pControlSalto = 20;

    //Inicializacion de la Clase
    $pdf = new TCPDF($Alineacion, PDF_UNIT, $FormatoPagina, true, 'UTF-8', false);
    
     
    //Inicializacion Variables de Control
    $pdf->pAlineacionEncabezado = $Alineacion;
    $pdf->pTituloInforme = "HISTORIA CLINICA";
    $pdf->pImprimeLogo = "NO";
    $pdf->pAnchoTxtPagina = 210;
    $pdf->pNomEmpresa = $_SESSION['NOM_EMPRESA'];
    $pdf->pTDocEmpresa = $_SESSION['EMPRESA_TDOC'];
    $pdf->pDocEmpresa = $_SESSION['EMPRESA_DOC'];
    $pdf->pDirEmpresa = $_SESSION['EMPRESA_DIR'];
    $pdf->pTelEmpresa = $_SESSION['EMPRESA_TEL'];
    $pdf->pCiuEmpresa = $_SESSION['EMPRESA_CIU'];
    $pdf->pEspEmpresa = $_SESSION['EMPRESA_ESP'];
    $pdf->pRegEmpresa = $_SESSION['EMPRESA_REGIMEN'];
    $pdf->pContribuyentes = $_SESSION['EMPRESA_CONTRIBUYENTE'];
    $pdf->pReteIVA  = $_SESSION['EMPRESA_RTEICA'];
    $pdf->pReteICA = $_SESSION['EMPRESA_RTEIVA'];

    $pdf->pTipoEncabezado = $pTipoEncabezado;
    $pdf->pNomSede = $_SESSION['EMPRESA_DOC'];
    $pdf->pNomIPS = $_SESSION['NOM_IPS'];
    $pdf->pMargenPie = -20;
    $pdf->pLogoCliente = "../../../consultoriovirtual/" . $_SESSION['IDBD'] . "/logo/logoenc.gif";
    $pdf->pPrefijo = 1; //$row[0]["Prefijo"];
    $pdf->pNroDocumento = 1; //str_pad($row[0]["NroDocumento"], 7, "0", STR_PAD_LEFT);
    $pdf->pNroResolucion = 1; //$row[0]["NroResolucion"];
    $pdf->pFechaDoc = 1; //$row[0]["FechaDocumento"];
    $pdf->pCAS = null;
    $pdf->pTratamiento = null;
    $pdf->pUsaPie = $UsaPiePagina;

    $pdf->SetCreator(PDF_CREATOR);
    $pdf->SetAuthor('Sistemas Ofisalud © - 2011');
    $pdf->SetTitle('Ofimedical©');
    $pdf->SetSubject('Soporte Historia Clinica Salud Ocupacional');

    $pdf->SetHeaderData($pdf->pLogoCliente, PDF_HEADER_LOGO_WIDTH, $pdf->pTituloInforme, PDF_HEADER_STRING);
    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
    $pdf->SetMargins($LeftMargin, $TopMargin, $RightMargin);
    $pdf->SetHeaderMargin($HeaderMargin);
    $pdf->SetFooterMargin($FooterMargin);
    // set bacground image

    $pdf->SetAutoPageBreak(TRUE, $BottomMargin);
    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
    $pdf->setLanguageArray($l);
    $pdf->setFontSubsetting(true);
    $pdf->SetFont('dejavusans', '', 14, '', true);
    
    for($i=0;$i<$pRegistros;$i++)
    {
        if($row[$i]["nomPaciente"] != ""){
            if ($idPaciente != $row[$i]["nomPaciente"])
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
            $pdf->Ln(0.5);
        
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<table><tr><td colspan="4" align="center" style="font-size:30px; font-weight:bolder;">I - DATOS PERSONALES</td></tr>';
            $mostrarHC .= '<tr><td width="140" style="font-size:30px; font-weight:bolder;">NOMBRES Y APELLIDOS:</td><td width="300" style="font-size:30px;">' . utf8_decode($row[$i]["Nom1"]) . " " . utf8_decode($row[$i]["Nom2"]) . " " . utf8_decode($row[$i]["Ape1"]) . " " . utf8_decode($row[$i]["Ape2"]) . '</td>';
            $mostrarHC .= '<td></td></tr>';
            $mostrarHC .= '<tr><td style="font-size:30px; font-weight:bolder;">IDENTIFICACION:</td><td style="font-size:30px;">' . utf8_decode($row[$i]["TipDoc"]) . " - " . utf8_decode($row[$i]["Documento"]) . '</td><td width="80" style="font-size:30px; font-weight:bolder;"></td><td></td></tr>';
            $mostrarHC .= '<tr><td style="font-size:30px; font-weight:bolder;">FECHA DE NACIMIENTO:</td><td style="font-size:30px;">' . utf8_decode($row[$i]["FecNac"]) . '</td><td width="100" style="font-size:30px; font-weight:bolder;">SEXO:</td><td style="font-size:30px;">' . utf8_decode($row[$i]["Genero"]) . '</td></tr>';
            $mostrarHC .= '<tr><td style="font-size:30px; font-weight:bolder;">ESTADO CIVIL:</td><td style="font-size:30px;">' . utf8_decode($row[$i]["EstadoCivil"]) . '</td><td width="100" style="font-size:30px; font-weight:bolder;">EDAD:</td><td style="font-size:30px;">' . utf8_decode($row[$i]["Edad"]) . '</td></tr>';
            $mostrarHC .= '<tr><td style="font-size:30px; font-weight:bolder;">DIRECCION:</td><td style="font-size:30px;">' . utf8_decode($row[$i]["Direccion"]) . '</td><td width="100" style="font-size:30px; font-weight:bolder;">TELEFONO:</td><td style="font-size:30px;">' . utf8_decode($row[$i]["Telefono"]) . " - " . utf8_decode($row[$i]["Telefono1"]) . '</td></tr>';
            $mostrarHC .= '<tr><td style="font-size:30px; font-weight:bolder;">ESCOLARIDAD:</td><td style="font-size:30px;">' . utf8_decode($row[$i]["Escolaridad"]) . '</td><td width="100" style="font-size:30px; font-weight:bolder;">PROFESION:</td><td style="font-size:30px;">' . utf8_decode($row[$i]["Ocupacion"]) . '</td></tr>';
            $mostrarHC .= '<tr><td style="font-size:30px; font-weight:bolder;">CARGO ACTUAL:</td><td style="font-size:30px;">' . utf8_decode($row[$i]["CargoActual"]) . '</td><td width="100" style="font-size:30px; font-weight:bolder;">FECHA INGRESO:</td><td style="font-size:30px;">' . utf8_decode($row[$i]["FechaIngreso"]) . '</td></tr>';
            $mostrarHC .= '<tr><td style="font-size:30px; font-weight:bolder;">FACTORES RIESGO:</td><td colspan="3" style="font-size:30px;">' . utf8_decode($row[$i]["FactorRiesgoActual"]) . '</td></tr>';
            $mostrarHC .= '<tr><td style="font-size:30px;" colspan="4" style="font-size:30px;"><b>EPS:</b>&nbsp;' . utf8_decode($row[$i]["EPS"]) . '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>PENSION:</b>&nbsp;' . utf8_decode($row[$i]["PENSION"]) . '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>ARP:</b>&nbsp;' . utf8_decode($row[$i]["ARP"]) . '</td></tr>';
            $mostrarHC .= '</table>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $gBaseDatos = new ofiMySQLi();
            $gBaseDatos->conectar();
            $qry = "CALL sp_asistencial_saludocupacional001_historiallaboral('" . $pPaciente . "')";
            $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
            while ($rowHL[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
            $gBaseDatos->liberar();
            $gBaseDatos->cerrar();
            $pRegistrosHL = count($rowHL);
            $mostrarHC = '<table border="0" cellspacing="0"><tr><td colspan="5" align="center" style="font-size:30px; font-weight:bolder;">II - HISTORIAL LABORAL</td></tr>';
            if($pRegistrosHL > 0){
                $mostrarHC .= '<tr style="padding:5px"><td width="166" style="font-size:30px; font-weight:bolder;">EMPRESA</td>';
                $mostrarHC .= '<td style="font-size:30px; font-weight:bolder;">CARGO</td>';
                $mostrarHC .= '<td width="50" style="font-size:30px; font-weight:bolder;">TIEMPO</td>';
                $mostrarHC .= '<td width="175" style="font-size:30px; font-weight:bolder;">FACTORES RIESGO</td>';
                $mostrarHC .= '<td width="175" style="font-size:30px; font-weight:bolder;">ELEMENTOS DE PROTECCION</td></tr>';
                for($k=0;$k<$pRegistrosHL;$k++)
                {
                    $mostrarHC .= '<tr><td style="font-size:30px;">' . utf8_decode($rowHL[$k]["descEmpresa"]) . '</td><td style="font-size:30px;">' . utf8_decode($rowHL[$k]["descCargo"]) . '</td><td style="font-size:30px;" width="50">' . utf8_decode($rowHL[$k]["descTiempo"]) . '</td><td style="font-size:30px;">' . utf8_decode($rowHL[$k]["descRisego"]) . '</td><td style="font-size:30px;">' . utf8_decode($rowHL[$k]["descElementos"]) . '</td></tr>';
                }
            }
            $mostrarHC .= '</table>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<table><tr><td style="font-size:30px; font-weight:bolder;">ENFERMEDAD PROFESIONAL O ACCIDENTES LABORALES:</td></tr>';
            $mostrarHC .= '<tr><td style="font-size:30px;">' . utf8_decode($row[$i]["EnfermedadProfesional"]) . '</td></tr>';
            $mostrarHC .= '<tr><td style="font-size:30px; font-weight:bolder;">ENFERMEDAD ACTUAL:</td></tr>';
            $mostrarHC .= '<tr><td style="font-size:30px;">' . utf8_decode($row[$i]["EnfermedadActual"]) . '</td></tr>';
            $mostrarHC .= '<tr><td align="center" style="font-size:30px; font-weight:bolder;">III - ANTECEDENTES PERSONALES:</td></tr>';
            $mostrarHC .= '<tr><td style="font-size:30px;">' . utf8_decode($row[$i]["AntecedentesPersonales"]) . '</td></tr>';
            if(utf8_decode($row[$i]["Genero"]) == "F"){
                $mostrarHC .= '<tr><td style="font-size:30px;"><b>GINECO-OBSTETRICOS:</b>&nbsp;' . utf8_decode($row[$i]["APGineco"]) . '</td></tr>';
                $mostrarHC .= '<tr><td style="font-size:30px;"><b>SE REALIZO CITOLOGIA EN EL ULTIMO AÑO:</b>&nbsp;' . utf8_decode($row[$i]["APGinecoCitologiaUltimoAno"]) . '</td></tr>';
                $mostrarHC .= '<tr><td style="font-size:30px;"><b>PLANIFICA ACTUALMENTE:</b>&nbsp;' . utf8_decode($row[$i]["APPlanificaActualmente"]) . '<b>,&nbsp;&nbsp;-METODO:</b>&nbsp;' . utf8_decode($row[$i]["APPlanificaMetodo"]) . '<b>,&nbsp;&nbsp;-TIEMPO:</b>&nbsp;' . utf8_decode($row[$i]["APPlanificaTiempo"]) . '</td></tr>';
            }
            $mostrarHC .= '<tr><td style="font-size:30px;"><b>HABITOS -LICOR:</b>&nbsp;' . utf8_decode($row[$i]["APHabitoLicor"]) . '<b>&nbsp;&nbsp;&nbsp;-CIGARRILLO:</b>&nbsp;' . utf8_decode($row[$i]["APHabitoCigarrillo"]) . '<b>&nbsp;&nbsp;&nbsp;-OTROS:</b>&nbsp;' . utf8_decode($row[$i]["APHabitosOtros"]) . '</td></tr>';
            if(utf8_decode($row[$i]["APDeporte"]) == "SI"){
                 $mostrarHC .= '<tr><td style="font-size:30px;"><b>DEPORTE:</b>&nbsp;' . utf8_decode($row[$i]["APDeporteOtros"]) . '</td></tr>';
            }else{
                 $mostrarHC .= '<tr><td style="font-size:30px;"><b>DEPORTE:</b>&nbsp;' . utf8_decode($row[$i]["APDeporte"]) . '</td></tr>';
            }
            $mostrarHC .= '<tr><td align="center" style="font-size:30px; font-weight:bolder;">IV - ANTECEDENTES FAMILIARES:</td></tr>';
            $mostrarHC .= '<tr><td style="font-size:30px;">' . utf8_decode($row[$i]["AntecedentesFamiliares"]) . '</td></tr>';
            $mostrarHC .= '<tr><td align="center" style="font-size:30px; font-weight:bolder;">V - REVISION POR SISTEMAS:</td></tr></table>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            if(utf8_decode($row[$i]["RSRespiratorio"]) != "" || utf8_decode($row[$i]["RSRespiratorio"]) != null){
                $mostrarHC = '<span style="font-size:30px;"><b>RESPIRATORIO:</b>&nbsp;' . utf8_decode($row[$i]["RSRespiratorio"]) . '</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            if(utf8_decode($row[$i]["RSCirculatorio"]) != "" || utf8_decode($row[$i]["RSCirculatorio"]) != null){
                $mostrarHC = '<span style="font-size:30px;"><b>CIRCULATORIO:</b>&nbsp;' . utf8_decode($row[$i]["RSCirculatorio"]) . '</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            if(utf8_decode($row[$i]["RSDigestivo"]) != "" || utf8_decode($row[$i]["RSDigestivo"]) != null){
                $mostrarHC = '<span style="font-size:30px;"><b>DIGESTIVO:</b>&nbsp;' . utf8_decode($row[$i]["RSDigestivo"]) . '</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            if(utf8_decode($row[$i]["RSMetabolico"]) != "" || utf8_decode($row[$i]["RSMetabolico"]) != null){
                $mostrarHC = '<span style="font-size:30px;"><b>METABOLICO:</b>&nbsp;' . utf8_decode($row[$i]["RSMetabolico"]) . '</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            if(utf8_decode($row[$i]["RSHematopoyetico"]) != "" || utf8_decode($row[$i]["RSHematopoyetico"]) != null){
                $mostrarHC = '<span style="font-size:30px;"><b>HEMATOPOYETICO:</b>&nbsp;' . utf8_decode($row[$i]["RSHematopoyetico"]) . '</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            if(utf8_decode($row[$i]["RSUrogenital"]) != "" || utf8_decode($row[$i]["RSUrogenital"]) != null){
                $mostrarHC = '<span style="font-size:30px;"><b>UROGENITAL:</b>&nbsp;' . utf8_decode($row[$i]["RSUrogenital"]) . '</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            if(utf8_decode($row[$i]["RSLocomotor"]) != "" || utf8_decode($row[$i]["RSLocomotor"]) != null){
                $mostrarHC = '<span style="font-size:30px;"><b>LOCOMOTOR:</b>&nbsp;' . utf8_decode($row[$i]["RSLocomotor"]) . '</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            if(utf8_decode($row[$i]["RSNervioso"]) != "" || utf8_decode($row[$i]["RSNervioso"]) != null){
                $mostrarHC = '<span style="font-size:30px;"><b>NERVIOSO:</b>&nbsp;' . utf8_decode($row[$i]["RSNervioso"]) . '</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            if(utf8_decode($row[$i]["RSPiel"]) != "" || utf8_decode($row[$i]["RSPiel"]) != null){
                $mostrarHC = '<span style="font-size:30px;"><b>PIEL:</b>&nbsp;' . utf8_decode($row[$i]["RSPiel"]) . '</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            if(utf8_decode($row[$i]["RSOncologico"]) != "" || utf8_decode($row[$i]["RSOncologico"]) != null){
                $mostrarHC = '<span style="font-size:30px;"><b>ONCOLOGICO:</b>&nbsp;' . utf8_decode($row[$i]["RSOncologico"]) . '</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            if(utf8_decode($row[$i]["RSTraumatico"]) != "" || utf8_decode($row[$i]["RSTraumatico"]) != null){
                $mostrarHC = '<span style="font-size:30px;"><b>TRAUMATICO:</b>&nbsp;' . utf8_decode($row[$i]["RSTraumatico"]) . '</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            if(utf8_decode($row[$i]["RSOftalmologico"]) != "" || utf8_decode($row[$i]["RSOftalmologico"]) != null){
                $mostrarHC = '<span style="font-size:30px;"><b>OFTALMOLOGICO:</b>&nbsp;' . utf8_decode($row[$i]["RSOftalmologico"]) . '</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            if(utf8_decode($row[$i]["RSToxicologico"]) != "" || utf8_decode($row[$i]["RSToxicologico"]) != null){
                $mostrarHC = '<span style="font-size:30px;"><b>TOXICOLOGICO:</b>&nbsp;' . utf8_decode($row[$i]["RSToxicologico"]) . '<span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            
            $mostrarHC = '<table><tr><td align="center" style="font-size:30px; font-weight:bolder;">VI - EXAMEN FISICO:</td></tr>';
            $mostrarHC .= '<tr><td style="font-size:30px;"><b>TA:</b>&nbsp;' . utf8_decode($row[$i]["EF_TA"]) . '&nbsp;&nbsp;&nbsp;&nbsp;<b>FC:</b>&nbsp;' . utf8_decode($row[$i]["EF_FC"]) . '&nbsp;&nbsp;&nbsp;&nbsp;<b>FR:</b>&nbsp;' . utf8_decode($row[$i]["EF_FR"]) . '&nbsp;&nbsp;&nbsp;&nbsp;<b>PESO:</b>&nbsp;' . utf8_decode($row[$i]["EF_Peso"]) . '&nbsp;&nbsp;&nbsp;&nbsp;<b>TALLA:</b>&nbsp;' . utf8_decode($row[$i]["EF_Talla"]) . '&nbsp;&nbsp;&nbsp;&nbsp;<b>IMC:</b>&nbsp;' . utf8_decode($row[$i]["EF_IMC"]) . '&nbsp;&nbsp;&nbsp;&nbsp;<b>T°:</b>&nbsp;' . utf8_decode($row[$i]["EF_TE"]) . '&nbsp;&nbsp;&nbsp;&nbsp;' . '</td></tr>';
            $mostrarHC .= '<tr><td style="font-size:30px;"><b>BIOTIPO:</b>&nbsp;' . utf8_decode($row[$i]["EF_Biotipo"]) . '&nbsp;&nbsp;&nbsp;&nbsp;<b>DOMINANCIA:</b>&nbsp;' . utf8_decode($row[$i]["EF_Dominancia"]) . '</td></tr>';
            $mostrarHC .= '</table>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<span style="font-size:30px;"><b>ASPECTO GENERAL:</b>&nbsp;';
            if(utf8_decode($row[$i]["EF_AspectoGeneral"]) != "NORMAL"){
                $mostrarHC .= utf8_decode($row[$i]["EF_AspectoGeneralH"]) . '</span>';
            }else{
                $mostrarHC .= utf8_decode($row[$i]["EF_AspectoGeneral"]) . '</span>';
            }
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<span style="font-size:30px;"><b>PIEL Y FANERAS:</b>&nbsp;';
            if(utf8_decode($row[$i]["EF_PielFaneras"]) != "NORMAL"){
                $mostrarHC .= utf8_decode($row[$i]["EF_PielFanerasH"]) . '</span>';
            }else{
                $mostrarHC .= utf8_decode($row[$i]["EF_PielFaneras"]) . '</span>';
            }
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<span style="font-size:30px;"><b>OJOS:</b>&nbsp;';
            if(utf8_decode($row[$i]["EF_Ojos"]) != "NORMAL"){
                $mostrarHC .= utf8_decode($row[$i]["EF_OjosH"]) . '</span>';
            }else{
                $mostrarHC .= utf8_decode($row[$i]["EF_Ojos"]) . '</span>';
            }
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<span style="font-size:30px;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>AV: LEJANA OD:</b>&nbsp;' . utf8_decode($row[$i]["EF_AVLejanaOD"]) . '&nbsp;&nbsp;<b>OI:</b>&nbsp;' . utf8_decode($row[$i]["EF_AVLejanaOI"]) . '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>AV: CERCANA OD:</b>&nbsp;' . utf8_decode($row[$i]["EF_AVCercanaOD"]) . '&nbsp;&nbsp;<b>OI:</b>&nbsp;' . utf8_decode($row[$i]["EF_AVCercanaOI"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<span style="font-size:30px;"><b>OIDOS:</b>&nbsp;';
            if(utf8_decode($row[$i]["EF_Oidos"]) != "NORMAL"){
                $mostrarHC .= utf8_decode($row[$i]["EF_OidosH"]) . '</span>';
            }else{
                $mostrarHC .=  utf8_decode($row[$i]["EF_Oidos"]) . '</span>';
            }
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<span style="font-size:30px;"><b>NARIZ:</b>&nbsp;';
            if(utf8_decode($row[$i]["EF_Nariz"]) != "NORMAL"){
                $mostrarHC .= utf8_decode($row[$i]["EF_NarizH"]) . '</span>';
            }else{
                $mostrarHC .= utf8_decode($row[$i]["EF_Nariz"]) . '</span>';
            }
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<span style="font-size:30px;"><b>BOCA:</b>&nbsp;';
            if(utf8_decode($row[$i]["EF_Boca"]) != "NORMAL"){
                $mostrarHC .= utf8_decode($row[$i]["EF_BocaH"]) . '</span>';
            }else{
                $mostrarHC .= utf8_decode($row[$i]["EF_Boca"]) . '</span>';
            }
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<span style="font-size:30px;"><b>CUELLO:</b>&nbsp;';
            if(utf8_decode($row[$i]["EF_Cuello"]) != "NORMAL"){
                $mostrarHC .= utf8_decode($row[$i]["EF_CuelloH"]) . '</span>';
            }else{
                $mostrarHC .= utf8_decode($row[$i]["EF_Cuello"]) . '</span>';
            }
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<span style="font-size:30px;"><b>TORAX:</b>&nbsp;';
            if(utf8_decode($row[$i]["EF_Torax"]) != "NORMAL"){
                $mostrarHC .= utf8_decode($row[$i]["EF_ToraxH"]) . '</span>';
            }else{
                $mostrarHC .= utf8_decode($row[$i]["EF_Torax"]) . '</span>';
            }
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<span style="font-size:30px;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>INSPECCION:</b>&nbsp;';
            if(utf8_decode($row[$i]["EF_ToraxInspeccion"]) != "NORMAL"){
                $mostrarHC .= utf8_decode($row[$i]["EF_ToraxInspeccionH"]) . '</span>';
            }else{
                $mostrarHC .= utf8_decode($row[$i]["EF_ToraxInspeccion"]) . '</span>';
            }
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<span style="font-size:30px;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>AUSCULTACION:</b>&nbsp;';
            $mostrarHC .= utf8_decode($row[$i]["EF_ToraxAuscultacionH"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<span style="font-size:30px;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>PALPACION:</b>&nbsp;';
            if(utf8_decode($row[$i]["EF_ToraxPalpacion"]) != "NORMAL"){
                $mostrarHC .= utf8_decode($row[$i]["EF_ToraxPalpacionH"]) . '</span>';
            }else{
                $mostrarHC .= utf8_decode($row[$i]["EF_ToraxPalpacion"]) . '</span>';
            }
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            if($row[$i]["Genero"] == "F"){
                $mostrarHC = '<span style="font-size:30px;"><b>TORAX:</b>&nbsp;';
                if(utf8_decode($row[$i]["EF_Mamas"]) != "NORMAL"){
                    $mostrarHC .= utf8_decode($row[$i]["EF_MamasH"]) . '</span>';
                }else{
                    $mostrarHC .= utf8_decode($row[$i]["EF_Mamas"]) . '</span>';
                }
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            
            $mostrarHC = '<span style="font-size:30px;"><b>ABDOMEN:</b>&nbsp;';
            if(utf8_decode($row[$i]["EF_Abdomen"]) != "NORMAL"){
                $mostrarHC .= utf8_decode($row[$i]["EF_AbdomenH"]) . '</span>';
            }else{
                $mostrarHC .= utf8_decode($row[$i]["EF_Abdomen"]) . '</span>';
            }
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<span style="font-size:30px;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>INSPECCION:</b>&nbsp;';
            if(utf8_decode($row[$i]["EF_AbdomenInspeccion"]) != "NORMAL"){
                $mostrarHC .= utf8_decode($row[$i]["EF_AbdomenInspeccionH"]) . '</span>';
            }else{
                $mostrarHC .= utf8_decode($row[$i]["EF_AbdomenInspeccion"]) . '</span>';
            }
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<span style="font-size:30px;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>AUSCULTACION:</b>&nbsp;';
            if(utf8_decode($row[$i]["EF_AbdomenAuscultacion"]) != "NORMAL"){
                $mostrarHC .= utf8_decode($row[$i]["EF_AbdomenAuscultacionH"]) . '</span>';
            }else{
                $mostrarHC .= utf8_decode($row[$i]["EF_AbdomenAuscultacion"]) .'</span>';
            }
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<span style="font-size:30px;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>PALPACION:</b>&nbsp;';
            if(utf8_decode($row[$i]["EF_AbdomenPalpacion"]) != "NORMAL"){
                $mostrarHC .= utf8_decode($row[$i]["EF_AbdomenPalpacionH"]) . '</span>';
            }else{
                $mostrarHC .= utf8_decode($row[$i]["EF_AbdomenPalpacion"]) . '</span>';
            }
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<span style="font-size:30px;"><b>MIEMBROS Sup:</b>&nbsp;';
            if(utf8_decode($row[$i]["EF_MiembrosSup"]) != "NORMAL"){
                $mostrarHC .= utf8_decode($row[$i]["EF_MiembrosSupH"]) . '</span>';
            }else{
                $mostrarHC .= utf8_decode($row[$i]["EF_MiembrosSup"]) . '</span>';
            }
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<span style="font-size:30px;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>TINNEL:</b>&nbsp;' . utf8_decode($row[$i]["EF_MiembrosSupTinnel"]) . '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>PHALEN:</b>&nbsp;' . utf8_decode($row[$i]["EF_MiembrosSupPhalen"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<span style="font-size:30px;"><b>MIEMBROS Inf:</b>&nbsp;';
            if(utf8_decode($row[$i]["EF_MiembrosInf"]) != "NORMAL"){
                $mostrarHC .= utf8_decode($row[$i]["EF_MiembrosInfH"]) . '</span>';
            }else{
                $mostrarHC .= utf8_decode($row[$i]["EF_MiembrosInf"]) . '</span>';
            }
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<span style="font-size:30px;"><b>COLUMNA VERTEBRAL:</b>&nbsp;';
            if(utf8_decode($row[$i]["EF_Columna"]) != "NORMAL"){
                $mostrarHC .= utf8_decode($row[$i]["EF_ColumnaH"]) . '</span>';
            }else{
                $mostrarHC .= utf8_decode($row[$i]["EF_Columna"]) . '</span>';
            }
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<span style="font-size:30px;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>INSPECCION:</b>&nbsp;';
            if(utf8_decode($row[$i]["EF_ColumnaInspeccion"]) != "NORMAL"){
                $mostrarHC .= utf8_decode($row[$i]["EF_ColumnaInspeccionH"]) . '</span>';
            }else{
                $mostrarHC .= utf8_decode($row[$i]["EF_ColumnaInspeccion"]) . '</span>';
            }
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<span style="font-size:30px;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>PALPACION:</b>&nbsp;';
            if(utf8_decode($row[$i]["EF_ColumnaPalpacion"]) != "NORMAL"){
                $mostrarHC .= utf8_decode($row[$i]["EF_ColumnaPalpacionH"]) . '</span>';
            }else{
                $mostrarHC .= utf8_decode($row[$i]["EF_ColumnaPalpacion"]) . '</span>';
            }
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<span style="font-size:30px;"><b>GENITALES:</b>&nbsp;';
            if(utf8_decode($row[$i]["EF_Genitales"]) != "NORMAL"){
                $mostrarHC .= ',&nbsp;&nbsp;' . utf8_decode($row[$i]["EF_GenitalesH"]) . '</span>';
            }else{
                $mostrarHC .= utf8_decode($row[$i]["EF_Genitales"]) . '</span>';
            }
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<span style="font-size:30px;"><b>NEUROLOGICO:</b>&nbsp;';
            if(utf8_decode($row[$i]["EF_Neurologico"]) != "NORMAL"){
                $mostrarHC .= utf8_decode($row[$i]["EF_NeurologicoH"]) . '</span>';
            }else{
                $mostrarHC .= utf8_decode($row[$i]["EF_Neurologico"]) . '</span>';
            }
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<span style="font-size:30px;"><b>ESFERA MENTAL:</b>&nbsp;';
            if(utf8_decode($row[$i]["EF_EsfMental"]) != "NORMAL"){
                $mostrarHC .= utf8_decode($row[$i]["EF_EsfMentalH"]) . '</span>';
            }else{
                $mostrarHC .= utf8_decode($row[$i]["EF_EsfMental"]) . '</span>';
            }
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<table><tr><td align="center" style="font-size:30px; font-weight:bolder;">VII - PARACLINICOS:</td></tr>';
            $mostrarHC .= '<tr><td style="font-size:30px;">' . utf8_decode($row[$i]["Paraclinicos"]) . '</td></tr>';
            $mostrarHC .= '</table>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<table><tr><td align="center" style="font-size:30px; font-weight:bolder;">VIII - DIAGNOSTICO:</td></tr></table>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<span style="font-size:30px; color:#000;"><b>Diagnostico Principal: </b>' . utf8_decode($row[$i]["Diagppal"]) . ' - ' . utf8_decode($row[$i]["DesDiagPpal"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            if (utf8_decode($row[$i]["Diagrel1"]) != "" && utf8_decode($row[$i]["Diagrel1"]) != null){
                $mostrarHC = '<span style="font-size:30px; color:#000;"><b>Diagnostico Relacionado Nro1: </b>' . utf8_decode($row[$i]["Diagrel1"]) . ' - ' . utf8_decode($row[$i]["DesDiagRel1"]) . '</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            if (utf8_decode($row[$i]["Diagrel2"]) != "" && utf8_decode($row[$i]["Diagrel2"]) != null){
                $mostrarHC = '<span style="font-size:30px; color:#000;"><b>Diagnostico Relacionado Nro2: </b>' . utf8_decode($row[$i]["Diagrel2"]) . ' - ' . utf8_decode($row[$i]["DesDiagRel2"]) . '</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            if (utf8_decode($row[$i]["Diagrel3"]) != "" && utf8_decode($row[$i]["Diagrel3"]) != null){
                $mostrarHC = '<span style="font-size:30px; color:#000;"><b>Diagnostico Relacionado Nro3: </b>' . utf8_decode($row[$i]["Diagrel3"]) . ' - ' . utf8_decode($row[$i]["DesDiagRel3"]) . '</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            if (utf8_decode($row[$i]["ResumenDx"]) != "" && utf8_decode($row[$i]["ResumenDx"]) != null){
                $mostrarHC = '<span style="font-size:30px;"><b>OTROS DIAGNOSTICOS RELACIONADOS:</b>&nbsp;' . utf8_decode($row[$i]["ResumenDx"]) . '</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            
            $mostrarHC = '<table><tr><td align="center" style="font-size:30px; font-weight:bolder;">IX - CONCEPTO:</td></tr></table>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            if (utf8_decode($row[$i]["CONCEPAptoSinRest"]) == "1"){
                $mostrarHC = '<span style="font-size:30px;">APTO SIN RESTRICCIONES</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            if (utf8_decode($row[$i]["CONCEPAptoConRest"]) == "1"){
                $mostrarHC = '<span style="font-size:30px;">APTO CON RESTRICCIONES</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            if (utf8_decode($row[$i]["CONCEPAptoConCondi"]) == "1"){
                $mostrarHC = '<span style="font-size:30px;">APTO CON CONDICIONES</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            if (utf8_decode($row[$i]["CONCEPNoAptoTempo"]) == "1"){
                $mostrarHC = '<span style="font-size:30px;">NO APTO TEMPORALMENTE</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            if (utf8_decode($row[$i]["CONCEPNoApto"]) == "1"){
                $mostrarHC = '<span style="font-size:30px;">NO APTO</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            if (utf8_decode($row[$i]["CONCEPAptoTrabajoAlturas"]) == "1"){
                $mostrarHC = '<span style="font-size:30px;">APTO PARA TRABAJAR EN ALTURAS</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            if (utf8_decode($row[$i]["CONCEPPatologiaLaboral"]) == "1"){
                $mostrarHC = '<span style="font-size:30px;">POSIBLE PATOLOGIA ORIGEN LABORAL</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            if (utf8_decode($row[$i]["CONCEPSecuelasLaboral"]) == "1"){
                $mostrarHC = '<span style="font-size:30px;">CON SECUELAS DE ACCIDENTE LABORAL</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            if (utf8_decode($row[$i]["CONCEPExamenPeriodicoNormal"]) == "1"){
                $mostrarHC = '<span style="font-size:30px;">EXAMEN PERIODICO NORMAL</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            if (utf8_decode($row[$i]["CONCEPExamenRetiroNormal"]) == "1"){
                $mostrarHC = '<span style="font-size:30px;">EXAMEN RETIRO NORMAL</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            if (utf8_decode($row[$i]["Concepto"]) != "" && utf8_decode($row[$i]["Concepto"]) != null){
                $mostrarHC = '<span style="font-size:30px; color:#000;"><b>OBSERVACIONES: </b>' . utf8_decode($row[$i]["Concepto"]) . '</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            
            $mostrarHC = '<table><tr><td align="center" style="font-size:30px; font-weight:bolder;">X - TIPO DE RESTRICCIONES O CAUSAS DE APLAZAMIENTO:</td></tr></table>';
            $mostrarHC .= '<span style="font-size:30px;">' . utf8_decode($row[$i]["Restricciones"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<table><tr><td align="center" style="font-size:30px; font-weight:bolder;">XI - RECOMENDACIONES Y OBSERVACIONES:</td></tr></table>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            if (utf8_decode($row[$i]["RECOMENUsoAdecuadoElem"]) == "1"){
                $mostrarHC = '<span style="font-size:30px;">USO ADECUADO DE ELEMENTOS DE PROTECCION PERSONAL</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            
            if (utf8_decode($row[$i]["RECOMENControlAnualOptometria"]) == "1"){
                $mostrarHC = '<span style="font-size:30px;">CONTROL ANUAL POR OPTOMETRIA EN LA EPS</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            
            if (utf8_decode($row[$i]["RECOMENRealizaPausasActivas"]) == "1"){
                $mostrarHC = '<span style="font-size:30px;">REALIZAR PAUSAS ACTIVAS</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            
            if (utf8_decode($row[$i]["RECOMENCertificarTrabajoAlturas"]) == "1"){
                $mostrarHC = '<span style="font-size:30px;">DEBE CERTIFICARSE PARA TRABAJAR EN ALTURAS</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            
            if (utf8_decode($row[$i]["RECOMENUsarMediasVarices"]) == "1"){
                $mostrarHC = '<span style="font-size:30px;">USAR MEDIAS DE SOPORTE ELASTICO PARA VARICES</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            
            if (utf8_decode($row[$i]["RECOMENRealizarCitologia"]) == "1"){
                $mostrarHC = '<span style="font-size:30px;">REALIZAR CITOLOGIA ANUAL</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            
            if (utf8_decode($row[$i]["RECOMENRealizarDietaEjercicio"]) == "1"){
                $mostrarHC = '<span style="font-size:30px;">REALIZAR DIETA, EJERCICIO Y REDUCIR PESO</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            
            if (utf8_decode($row[$i]["RECOMENEvaluarxNutricion"]) == "1"){
                $mostrarHC = '<span style="font-size:30px;">EVALUAR POR NUTRICION EN LA EPS</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            
            if (utf8_decode($row[$i]["RECOMENDejarFumar"]) == "1"){
                $mostrarHC = '<span style="font-size:30px;">DEJAR EL HABITO DE FUMAR</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            
            if (utf8_decode($row[$i]["RECOMENDisminuirConsumoAlcohol"]) == "1"){
                $mostrarHC = '<span style="font-size:30px;">DISMINUIR CONSUMO DE ALCOHOL</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            
            if (utf8_decode($row[$i]["RECOMENIngresarProgaEpidemio"]) == "1"){
                $mostrarHC = '<span style="font-size:30px;">INGRESAR AL SISTEMA DE VIGILANCIA EPIDEMIOLOGICA</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            
            if (utf8_decode($row[$i]["RECOMENPruebasManipulaAlimentos"]) == "1"){
                $mostrarHC = '<span style="font-size:30px;">REALIZAR PRUEBAS PARA MANIPULACION DE ALIMENTOS</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            
            if (utf8_decode($row[$i]["RECOMENPruebasComplementarias"]) == "1"){
                $mostrarHC = '<span style="font-size:30px;">REALIZAR PRUEBAS COMPLEMENTARIAS</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            
            if (utf8_decode($row[$i]["RECOMENOtros"]) != "" && utf8_decode($row[$i]["RECOMENOtros"]) != null){
                $mostrarHC = '<span style="font-size:30px; color:#000;"><b>OBSERVACIONES: </b>' . utf8_decode($row[$i]["RECOMENOtros"]) . '</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            
            $idPaciente = $row[$i]["nomPaciente"];
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
        }
    }

    /*$pos = $pdf->GetY();
    while ($pos <= ($pdf->getPageHeight()-62)) {
        $pdf->Ln();
        $pos = $pdf->GetY();
    }*/
    $pdf->Ln();
    
    $mostrarHC = '<table border="1" style="padding:3px; border-top-width: 0.5px; border-right-width: 0.5px; border-bottom-width: 0.5px; border-left-width: 0.5px;"><tr><td align="center" style="font-size:24px; font-weight:bolder;">CONSENTIMIENTO INFORMADO DEL ASPIRANTE O TRABAJADOR</td></tr>';
    $mostrarHC .= '<tr><td style="text-align:justify; font-size:20px; color:#000;">Autorizo al profesional abajo mencionado a que se me realice de manera voluntaria el examen medico ocupacional y exámenes complementarios. Dejo constancia que tuve la oportunidad de manifestar mi consentimiento para la realización del Examen Medico Ocupacional y/o exámenes complementarios a partir de la información recibida por el profesional abajo mencionado. Certifico que la información suministrada es verdadera, completa y acepto el manejo de confidencialidad que se le de a la misma. Autorizo que se suministre la información necesaria a las personas o entidades contempladas en la legislación para dar cumplimiento al programa de Salud Ocupacional.</td></tr></table>';
    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
    }
    $mostrarHC = '<br><table border="0" cellspacing="0">';
    $mostrarHC .= '<tr><td style="font-size:18px; color:#000; font-weight:bolder;">';
    $mostrarHC .= '<span>' . $_SESSION['IdNombreConsultorio'] . '</span><br>';
    $mostrarHC .= '<span>' . $_SESSION['IdEspecialidadConsultorio'] . '</span><br>';
    $mostrarHC .= '<span>' . $_SESSION['IdDocumento'] . '</span><br>';
    $mostrarHC .= '<span>' . $_SESSION['IdRegistroMedico1'] . '</span><br>';
    $mostrarHC .= '<span>' . $_SESSION['IdRegistroMedico2'] . '</span><br>';
    $mostrarHC .= '<span>' . $_SESSION['IdTelefonoConsultorio'] . '</span><br>';
    if (file_exists('../../../consultoriovirtual/' . $_SESSION['IDBD']  . '/firmas/' . $row[0]["Profesional"] . '.png')) {
        $mostrarHC .= '<img src="../../../consultoriovirtual/' . $_SESSION['IDBD'] . '/firmas/' . $row[0]["Profesional"] . '.png" width="100" height="25"/><br><hr>';
    }
    $mostrarHC .= '</td>';
    $mostrarHC .= '<td width="150"></td>';
    $mostrarHC .= '<td><br>Aspirante o Trabajador<br>';
    $mostrarHC .= '<br><span style="font-size:18px; font-weight:bolder;">' . utf8_decode($row[0]["Nom1"]) . " " . utf8_decode($row[0]["Nom2"]) . " " . utf8_decode($row[0]["Ape1"]) . " " . utf8_decode($row[0]["Ape2"]) . '<br>';
    $mostrarHC .= utf8_decode($row[0]["TipDoc"]) . " - " . utf8_decode($row[0]["Documento"]) . '</span>';
    if (file_exists('../../../consultoriovirtual/' . $_SESSION['IDBD']  . '/pacientes/' . $pPaciente . '/uploads/firma.jpg')) {
        $mostrarHC .= '<br><img src="../../../consultoriovirtual/' . $_SESSION['IDBD']  . '/pacientes/' . $pPaciente . '/uploads/firma.jpg" width="100" height="25"/><br><hr>';
    }
    $mostrarHC .= '</td>';
    $mostrarHC .= '</tr>';
    $mostrarHC .= '</table>';
    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
    
    $pdf->Output('infHistoriaSaludOcupacional.pdf', 'I');

    function EncabezadoPagina(&$pdf, &$row, &$i, &$rowcount, &$contador, &$pDesde, &$pHasta){
        $idReg = $i;
        $ojo = "nada";
        if($row[$idReg]["Paciente"]=="" || $row[$idReg]["Paciente"]==null){
            $idReg = 0;
        }
        $pdf->AddPage();
        $pdf->Ln(0.5);
        $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
        $EncabezadoHTML = '<table cellspacing="0" border="0" style="font-size:24px; color:#000;">';
        $EncabezadoHTML .= '<tr>';
        $EncabezadoHTML .= '<td>';
        $EncabezadoHTML .= '<span style="font-size:44px; color:#000; font-weight:bold">' . utf8_decode($pdf->pNomEmpresa) . '</span><br>';
        if($pdf->pEspEmpresa != null || $pdf->pEspEmpresa != "")
                $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . utf8_decode($pdf->pEspEmpresa) . '</span><br>';
        if($pdf->pTDocEmpresa == "NI"){
            $tipodoc = "NIT: ";
            $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $tipodoc . $pdf->pDocEmpresa . '</span><br>';
        }
        $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">Cel: ' . $pdf->pTelEmpresa . '</span><br>';
        $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $pdf->pCiuEmpresa . '</span><br><br><br>';
        $EncabezadoHTML .= '<span style="font-size:30px; color:#000;"><b>FECHA: </b>' . utf8_decode($row[$idReg]["Fecha"]) . '</span><br>';
        $EncabezadoHTML .= '<span style="font-size:30px; color:#000;"><b>CIUDAD: </b>' . utf8_decode($row[$idReg]["Municipio"]) . '</span><br>';
        $EncabezadoHTML .= '<span style="font-size:30px; color:#000;"><b>TIPO EXAMEN: </b>' . utf8_decode($row[$idReg]["TipoExamen"]) . '</span><br>';
        $EncabezadoHTML .= '<span style="font-size:30px; color:#000;"><b>NOMBRE EMPRESA:</b>' . utf8_decode($row[$idReg]["Empresa"]) . '</span>';
        $EncabezadoHTML .= '</td>';

        //COL2
        $EncabezadoHTML .= '<td align="right">';
        if (file_exists("../../../consultoriovirtual/" . $_SESSION['IDBD'] . "/logo/logoenc.gif")) {
            $EncabezadoHTML .= '<img src="../../../consultoriovirtual/' . $_SESSION['IDBD'] . '/logo/logoenc.gif" align="right"/>';
            $EncabezadoHTML .= '<br>';
        }
        $EncabezadoHTML .= '<span align="rigth" style="font-size:44px; color:#000; font-weight:bold">HISTORIA CLINICA OCUPACIONAL</span><br>';
        $EncabezadoHTML .= '<span align="rigth" style="font-size:26px; color:#000; font-weight:bold"></span>';
        if (file_exists('../../../consultoriovirtual/' . $_SESSION['IDBD']  . '/pacientes/' . $row[$idReg]["Paciente"] . '/uploads/foto.jpg')) {
            $EncabezadoHTML .= '<br><img src="../../../consultoriovirtual/' . $_SESSION['IDBD']  . '/pacientes/' . $row[$idReg]["Paciente"] . '/uploads/foto.jpg" width="130" height="100"/>';
        }
        $EncabezadoHTML .= '</td>';
        $EncabezadoHTML .= '</tr>';
        $EncabezadoHTML .= '</table>';
        $EncabezadoHTML .= '<hr>';
        $pdf->writeHTML($EncabezadoHTML, true, false, false, false, '');
    }

    
?>
