<?php

set_time_limit(500);
require_once('../../../lib/tcpdf/config/lang/spa.php');
require_once('../../../lib/tcpdf/tcpdf.php');
require("../../../core/php/_database.php");
require("../../../core/php/php_functions.php");

    session_start();
    $pConsultorioVirtual = $_SESSION['IDBD'];
    $nomEmpresa = $_SESSION['NOM_EMPRESA'];
    $nomUsuario = $_SESSION['NOM_USUARIO'];
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:1;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:1;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pEvolucion = isset($_REQUEST['pEvolucion'])?$_REQUEST['pEvolucion']:0;

    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_partisalud_printhc('" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pEvolucion . "')";
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    while ($row[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $pRegistros = count($row);

    //Definicion de las Margenes
    $LeftMargin = PDF_MARGIN_LEFT;
    $TopMargin = 10;
    $RightMargin = PDF_MARGIN_RIGHT;
    $HeaderMargin = PDF_MARGIN_HEADER;
    $BottomMargin = 3;
    $FooterMargin = 5;
    $Alineacion = "P";
    $FormatoPagina = "CARTA";
    $UsaPiePagina = "SI";
    $pTipoEncabezado = "FVP";
    $pControlSalto = 20;
    
    $styleBarCode = array(
        'position' => 'R',
        'align' => 'R',
        'stretch' => false,
        'fitwidth' => true,
        'cellfitalign' => 'R',
        'border' => true,
        'hpadding' => 'auto',
        'vpadding' => 'auto',
        'fgcolor' => array(0,0,0),
        'bgcolor' => false, //array(255,255,255),
        'text' => true,
        'font' => 'helvetica',
        'fontsize' => 7,
        'stretchtext' => 4
    );
    //Inicializacion de la Clase
    $pdf = new TCPDF($Alineacion, PDF_UNIT, $FormatoPagina, true, 'UTF-8', false);
    //Inicializacion Variables de Control
    $pdf->pAlineacionEncabezado = $Alineacion;
    $pdf->pTituloInforme = "HISTORIA CLINICA";
    $pdf->pImprimeLogo = "NO";
    $pdf->pAnchoTxtPagina = 210;
    $pdf->pNomEmpresa = $_SESSION['NOM_EMPRESA'];
    $pdf->pTDocEmpresa = $_SESSION['EMPRESA_TDOC'];
    $pdf->pDocEmpresa = $_SESSION['EMPRESA_DOC'];
    $pdf->pDirEmpresa = $_SESSION['EMPRESA_DIR'];
    $pdf->pTelEmpresa = $_SESSION['EMPRESA_TEL'];
    $pdf->pCiuEmpresa = $_SESSION['EMPRESA_CIU'];
    $pdf->pEspEmpresa = $_SESSION['EMPRESA_ESP'];
    $pdf->pRegEmpresa = $_SESSION['EMPRESA_REGIMEN'];
    $pdf->pContribuyentes = $_SESSION['EMPRESA_CONTRIBUYENTE'];
    $pdf->pReteIVA  = $_SESSION['EMPRESA_RTEICA'];
    $pdf->pReteICA = $_SESSION['EMPRESA_RTEIVA'];

    $pdf->pTipoEncabezado = $pTipoEncabezado;
    $pdf->pNomSede = $_SESSION['EMPRESA_DOC'];
    $pdf->pNomIPS = $_SESSION['NOM_IPS'];
    $pdf->pMargenPie = -20;
    $pdf->pLogoCliente = "../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/logoenc.gif";
    $pdf->pPrefijo = 1; //$row[0]["Prefijo"];
    $pdf->pNroDocumento = 1; //str_pad($row[0]["NroDocumento"], 7, "0", STR_PAD_LEFT);
    $pdf->pNroResolucion = 1; //$row[0]["NroResolucion"];
    $pdf->pFechaDoc = 1; //$row[0]["FechaDocumento"];
    $pdf->pCAS = null;
    $pdf->pTratamiento = null;
    $pdf->pUsaPie = $UsaPiePagina;

    $pdf->SetCreator(PDF_CREATOR);
    $pdf->SetAuthor('Sistemas Ofisalud © - 2011');
    $pdf->SetTitle('Ofimedical©');
    $pdf->SetSubject('Soporte Historia Clinica Salud Ocupacional');

    $pdf->SetHeaderData($pdf->pLogoCliente, PDF_HEADER_LOGO_WIDTH, $pdf->pTituloInforme, PDF_HEADER_STRING);
    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
    $pdf->SetMargins($LeftMargin, $TopMargin, $RightMargin);
    $pdf->SetHeaderMargin($HeaderMargin);
    $pdf->SetFooterMargin($FooterMargin);
    // set bacground image

    $pdf->SetAutoPageBreak(TRUE, $BottomMargin);
    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
    $pdf->setLanguageArray($l);
    $pdf->setFontSubsetting(true);
    $pdf->SetFont('dejavusans', '', 14, '', true);

    for($i=0;$i<$pRegistros;$i++)
    {
        if($row[$i]["nomPaciente"] != ""){
            if ($idPaciente != $row[$i]["nomPaciente"])
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
            $pdf->Ln(0.5);
            
            $mostrarHC = '<table><tr><td width="80" style="font-size:30px; font-weight:bolder;">FECHA:</td><td>' . utf8_decode($row[$i]["Fecha"]);
            if(utf8_decode($row[$i]["HoraInicioMedico"]) != "" && utf8_decode($row[$i]["HoraInicioMedico"]) != null){
                $mostrarHC .= '&nbsp;&nbsp;-&nbsp;<b>HORA:</b>&nbsp;' . utf8_decode($row[$i]["HoraInicioMedico"]);
            } 
            $mostrarHC .= '</td></tr>';
            //$mostrarHC .= '<tr><td style="font-size:30px; font-weight:bolder;">EMPRESA:</td><td>' . utf8_decode($row[$i]["Empresa"]) . '</td></tr>';
            if(utf8_decode($row[$i]["TipoExamen"]) == "Ingreso"){
                $mostrarHC .= '<tr><td style="font-size:30px; font-weight:bolder;">EMPRESA:</td><td>' . utf8_decode($row[$i]["EmpresaAspira"]) . '</td></tr>';
            }else{
                $mostrarHC .= '<tr><td style="font-size:30px; font-weight:bolder;">EMPRESA:</td><td>' . utf8_decode($row[$i]["EmpresaActual"]) . '</td></tr>';
            }
            $mostrarHC .= '<tr><td style="font-size:30px; font-weight:bolder;">CIUDAD:</td><td>' . utf8_decode($row[$i]["Muni"]) . " - " . utf8_decode($row[$i]["Depto"]) . '</td></tr>';
            $mostrarHC .= '<tr><td style="font-size:30px; font-weight:bolder;">TIPO EXAMEN:</td><td>' . utf8_decode($row[$i]["TipoExamen"]) . '</td></tr></table>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<table><tr><td colspan="4" style="font-size:30px; font-weight:bolder;">DATOS PERSONALES:</td></tr>';
            $mostrarHC .= '<tr><td width="145" style="font-size:30px; font-weight:bolder;">NOMBRES Y APELLIDOS:</td><td width="300">' . utf8_decode($row[$i]["Nom1"]) . " " . utf8_decode($row[$i]["Nom2"]) . " " . utf8_decode($row[$i]["Ape1"]) . " " . utf8_decode($row[$i]["Ape2"]) . '</td>';
            $mostrarHC .= '<td></td></tr>';
            $mostrarHC .= '<tr><td style="font-size:30px; font-weight:bolder;">IDENTIFICACION:</td><td>' . utf8_decode($row[$i]["TipDoc"]) . " - " . utf8_decode($row[$i]["Documento"]) . '</td><td width="100" style="font-size:30px; font-weight:bolder;"></td><td></td></tr>';
            $mostrarHC .= '<tr><td style="font-size:30px; font-weight:bolder;">FECHA DE NACIMIENTO:</td><td>' . utf8_decode($row[$i]["FecNac"]) . '</td><td width="100" style="font-size:30px; font-weight:bolder;">SEXO:</td><td>' . utf8_decode($row[$i]["Genero"]) . '</td></tr>';
            $mostrarHC .= '<tr><td style="font-size:30px; font-weight:bolder;">ESTADO CIVIL:</td><td>' . utf8_decode($row[$i]["EstadoCivil"]) . '</td><td width="100" style="font-size:30px; font-weight:bolder;">EDAD:</td><td>' . utf8_decode($row[$i]["EdadPaciente"]) . '</td></tr>';
            $mostrarHC .= '<tr><td style="font-size:30px; font-weight:bolder;">DIRECCION:</td><td>' . utf8_decode($row[$i]["Direccion"]) . '</td><td width="100" style="font-size:30px; font-weight:bolder;">TELEFONO:</td><td>' . utf8_decode($row[$i]["Telefono"]) . " - " . utf8_decode($row[$i]["Telefono1"]) . '</td></tr>';
            $mostrarHC .= '<tr><td style="font-size:30px; font-weight:bolder;">ESCOLARIDAD:</td><td>' . utf8_decode($row[$i]["Escolaridad"]) . '</td><td width="100" style="font-size:30px; font-weight:bolder;">PROFESION:</td><td>' . utf8_decode($row[$i]["Ocupacion"]) . '</td></tr>';
            //$mostrarHC .= '<tr><td style="font-size:30px; font-weight:bolder;">CARGO ACTUAL:</td><td>' . utf8_decode($row[$i]["CargoActual"]) . '</td><td width="100" style="font-size:30px; font-weight:bolder;">FECHA INGRESO:</td><td>' . utf8_decode($row[$i]["FechaIngreso"]) . '</td></tr>';
            //$mostrarHC .= '<tr><td style="font-size:30px; font-weight:bolder;">FACTORES RIESGO:</td><td colspan="3">' . utf8_decode($row[$i]["FactorRiesgoActual"]) . '</td></tr>';
            $mostrarHC .= '<tr><td style="font-size:30px;" colspan="4"><b>EPS:</b>&nbsp;' . utf8_decode($row[$i]["EPS"]) . '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>PENSION:</b>&nbsp;' . utf8_decode($row[$i]["PENSION"]) . '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>ARP:</b>&nbsp;' . utf8_decode($row[$i]["ARP"]) . '</td></tr>';
            $mostrarHC .= '</table>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<span  style="font-size:30px; font-weight:bolder;">MOTIVO DE CONSULTA:</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span  style="text-align:justify; font-size:30px;">' . utf8_decode($row[$i]["MotivoConsulta"]) . '</span><br>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<span  style="font-size:30px; font-weight:bolder;">ENFERMEDAD ACTUAL:</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span  style="text-align:justify; font-size:30px;">' . utf8_decode($row[$i]["EnfermedadActual"]) . '</span><br>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<span  style="font-size:30px; font-weight:bolder;">ANTECEDENTES PERSONALES:</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<table>';
            
            //Fila 1
            $mostrarHC .= '<tr>';
            $mostrarHC .= '<td width="100" style="font-size:30px;">INFECCIONES:</td>';
            $mostrarHC .= '<td width="70" style="font-size:30px;">' . utf8_decode($row[$i]["APInfecciones"]) . '</td>';
            $mostrarHC .= '<td width="180" style="font-size:30px;">INMUNOLÓGICOS:</td>';
            $mostrarHC .= '<td width="70" style="font-size:30px;">' . utf8_decode($row[$i]["APInmunologicos"]) . '</td>';
            $mostrarHC .= '</tr>';
            //Fin Fila1
            
            //Fila 2
            $mostrarHC .= '<tr>';
            $mostrarHC .= '<td width="100" style="font-size:30px;">PATOLÓGICOS:</td>';
            $mostrarHC .= '<td width="70" style="font-size:30px;">' . utf8_decode($row[$i]["APPatologicos"]) . '</td>';
            $mostrarHC .= '<td width="180" style="font-size:30px;">HOSPITALARIOS:</td>';
            $mostrarHC .= '<td width="70" style="font-size:30px;">' . utf8_decode($row[$i]["APHospitalarios"]) . '</td>';
            $mostrarHC .= '</tr>';
            //Fin Fila2
            
             //Fila 3
            $mostrarHC .= '<tr>';
            $mostrarHC .= '<td width="100" style="font-size:30px;">TÓXICOS:</td>';
            $mostrarHC .= '<td width="70" style="font-size:30px;">' . utf8_decode($row[$i]["APToxicos"]) . '</td>';
            $mostrarHC .= '<td width="180" style="font-size:30px;">ENFERMEDADES PSIQUIÁTRICAS:</td>';
            $mostrarHC .= '<td width="70" style="font-size:30px;">' . utf8_decode($row[$i]["APEnfPsiquiatra"]) . '</td>';
            $mostrarHC .= '</tr>';
            //Fin Fila3
            
            //Fila 4
            $mostrarHC .= '<tr>';
            $mostrarHC .= '<td width="100" style="font-size:30px;">ALÉRGICOS:</td>';
            $mostrarHC .= '<td width="70" style="font-size:30px;">' . utf8_decode($row[$i]["APAlergicos"]) . '</td>';
            $mostrarHC .= '<td width="180" style="font-size:30px;">TRAUMÁTICOS:</td>';
            $mostrarHC .= '<td width="70" style="font-size:30px;">' . utf8_decode($row[$i]["APTraumaticos"]) . '</td>';
            $mostrarHC .= '</tr>';
            //Fin Fila4
            
            //Fila 4
            $mostrarHC .= '<tr>';
            $mostrarHC .= '<td width="100" style="font-size:30px;">QUIRÚRGICOS:</td>';
            $mostrarHC .= '<td width="70" style="font-size:30px;">' . utf8_decode($row[$i]["APQuirurgicos"]) . '</td>';
            $mostrarHC .= '<td width="180" style="font-size:30px;"></td>';
            $mostrarHC .= '<td width="70" style="font-size:30px;"></td>';
            $mostrarHC .= '</tr>';
            //Fin Fila4
            
            //Fila 5
            $mostrarHC .= '<tr>';
            $mostrarHC .= '<td width="100" style="font-size:30px;">OBSERVACIONES:</td>';
            $mostrarHC .= '<td colspaspan="3" width="585" style="text-align:justify; font-size:30px;">' . utf8_decode($row[$i]["AntecedentesPersonales"]) . '</td>';
            $mostrarHC .= '</tr>';
            //Fin Fila5
            
            
            $mostrarHC .= '</table>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            if(utf8_decode($row[$i]["Genero"]) == "F"){
                $mostrarHC = '<span  style="font-size:30px; font-weight:bolder;">ANTECEDENTES GINECOOBSTÉTRICOS:</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }

                $mostrarHC = '<table>';
                //Fila 1
                $mostrarHC .= '<tr>';
                $mostrarHC .= '<td width="100" style="font-size:30px;">MENARQUIA</td>';
                $mostrarHC .= '<td width="100" style="font-size:30px;">CICLOS</td>';
                $mostrarHC .= '<td width="100" style="font-size:30px;">F.U.M.</td>';
                $mostrarHC .= '<td width="100" style="font-size:30px;">F.U.P.</td>';
                $mostrarHC .= '<td width="15" align="center" style="font-size:30px;">G</td>';
                $mostrarHC .= '<td width="15" align="center" style="font-size:30px;">P</td>';
                $mostrarHC .= '<td width="15" align="center" style="font-size:30px;">A</td>';
                $mostrarHC .= '<td width="15" align="center" style="font-size:30px;">V</td>';
                $mostrarHC .= '<td width="15" align="center" style="font-size:30px;">C</td>';
                $mostrarHC .= '<td width="15" align="center" style="font-size:30px;">M</td>';
                $mostrarHC .= '<td width="15" align="center" style="font-size:30px;"></td>';
                $mostrarHC .= '<td width="110" style="font-size:30px;">F.ULT. CITOLOGÍA</td>';
                $mostrarHC .= '<td width="150" style="font-size:30px;">RESULTADO</td>';
                $mostrarHC .= '</tr>';
                $mostrarHC .= '<tr>';
                $mostrarHC .= '<td width="100" style="font-size:30px;">' . utf8_decode($row[$i]["APGinecoMenarquia"]) . '</td>';
                $mostrarHC .= '<td width="100" style="font-size:30px;">' . utf8_decode($row[$i]["APGinecoCiclos"]) . '</td>';
                $mostrarHC .= '<td width="100" style="font-size:30px;">' . utf8_decode($row[$i]["APGinecoFUM"]) . '</td>';
                $mostrarHC .= '<td width="100" style="font-size:30px;">' . utf8_decode($row[$i]["APGinecoFUP"]) . '</td>';
                $mostrarHC .= '<td width="15" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["APGinecoNumG"]) . '</td>';
                $mostrarHC .= '<td width="15" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["APGinecoNumP"]) . '</td>';
                $mostrarHC .= '<td width="15" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["APGinecoNumA"]) . '</td>';
                $mostrarHC .= '<td width="15" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["APGinecoNumV"]) . '</td>';
                $mostrarHC .= '<td width="15" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["APGinecoNumC"]) . '</td>';
                $mostrarHC .= '<td width="15" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["APGinecoNumM"]) . '</td>';
                $mostrarHC .= '<td width="15" align="center" style="font-size:30px;"></td>';
                $mostrarHC .= '<td width="110" style="font-size:30px;">' . utf8_decode($row[$i]["APGinecoFUC"]) . '</td>';
                $mostrarHC .= '<td width="150" style="font-size:30px;">' . utf8_decode($row[$i]["APGinecoFUCResultado"]) . '</td>';
                $mostrarHC .= '</tr>';
                $mostrarHC .= '<tr>';
                $mostrarHC .= '<td colspaspan="2" width="200" style="font-size:30px;">PLANIFICA ACTUALMENTE: ' . utf8_decode($row[$i]["APPlanificaActualmente"]) . '</td>';
                if(utf8_decode($row[$i]["APPlanificaActualmente"]) == "NO"){
                    $mostrarHC .= '<td colspaspan="7" width="305" style="font-size:30px;"></td>';
                    $mostrarHC .= '<td colspaspan="3" width="260" style="font-size:30px;"></td>';
                }else{
                    $mostrarHC .= '<td colspaspan="7" width="305" style="font-size:30px;">METODO: ' . utf8_decode($row[$i]["APPlanificaMetodo"]) . '</td>';
                    $mostrarHC .= '<td colspaspan="3" width="260" style="font-size:30px;">HACE CUANTO: ' . utf8_decode($row[$i]["APPlanificaTiempo"]) . '</td>';
                }
                $mostrarHC .= '</tr>';


                $mostrarHC .= '</table>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            $mostrarHC = '<span  style="font-size:30px; font-weight:bolder;">ANTECEDENTES TÓXICOS:</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            if(utf8_decode($row[$i]["APToxicosFuamaActualmente"])=="SI"){
                $mostrarHC = '<span style="font-size:30px;">FUMA ACTUALMENTE: ' . utf8_decode($row[$i]["APToxicosFuamaActualmente"]) . ', NÚMERO CIGARRILLOS DÍA: ' . utf8_decode($row[$i]["APToxicosNroCigarrillosActual"]) . ', TIEMPO: ' . utf8_decode($row[$i]["APToxicosFumaActualmenteTiempo"]) . '</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }else{
                $mostrarHC = '<span style="font-size:30px;">FUMA ACTUALMENTE: ' . utf8_decode($row[$i]["APToxicosFuamaActualmente"]) . '</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
                
            if(utf8_decode($row[$i]["APToxicosFuamoAnteriormente"])=="SI"){
                $mostrarHC = '<span style="font-size:30px;">FUMO ANTERIORMENTE: ' . utf8_decode($row[$i]["APToxicosFuamoAnteriormente"]) . ', NÚMERO CIGARRILLOS DÍA: ' . utf8_decode($row[$i]["APToxicosNroCigarrillosAnterior"]) . ', TIEMPO: ' . utf8_decode($row[$i]["APToxicosFumaAnteriormenteTiempo"]) . '</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }else{
                $mostrarHC = '<span style="font-size:30px;">FUMO ANTERIORMENTE: ' . utf8_decode($row[$i]["APToxicosFuamoAnteriormente"]) . '</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            
            if(utf8_decode($row[$i]["APToxicosConsumoAlcohol"])=="SI"){
                $mostrarHC = '<span style="font-size:30px;">CONSUMO DE ALCOHOL: ' . utf8_decode($row[$i]["APToxicosConsumoAlcohol"]) . ', FRECUENCIA: ' . utf8_decode($row[$i]["APToxicosConsumoAlcoholTipo"]) . ', ESTADO DE EMBRIAGUEZ: ' . utf8_decode($row[$i]["APToxicosConsumoAlcoholEmbiaguez"]) . '</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }else{
                $mostrarHC = '<span style="font-size:30px;">CONSUMO DE ALCOHOL: ' . utf8_decode($row[$i]["APToxicosFuamoAnteriormente"]) . '</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            if(utf8_decode($row[$i]["APToxicosConsumoDrogras"])=="SI"){
                $mostrarHC = '<span style="font-size:30px;">CONSUMÉ DROGAS O ALGUNA OTRA SUSTANCIA?: ' . utf8_decode($row[$i]["APToxicosConsumoDrogras"]) . ', CUAL? ' . utf8_decode($row[$i]["APToxicosConsumoDrograsCual"]) . '</span><br>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }else{
                $mostrarHC = '<span style="font-size:30px;">CONSUMÉ DROGAS O ALGUNA OTRA SUSTANCIA?: ' . utf8_decode($row[$i]["APToxicosConsumoDrogras"]) . '</span><br>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            $gBaseDatos = new ofiMySQLi();
            $gBaseDatos->conectar();
            $qry = "CALL sp_asistencial_saludocupacional001_historiallaboral('" . $pPaciente . "')";
            $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
            while ($rowHL[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
            $gBaseDatos->liberar();
            $gBaseDatos->cerrar();
            $pRegistrosHL = count($rowHL);
            $mostrarHC = '<table border="0" cellspacing="0"><tr><td colspan="5" style="font-size:30px; font-weight:bolder;">DESCRIPCIÓN DE SUS TRABAJOS INICIANDO DESDE EL PRIMERO:</td></tr>';
            if($pRegistrosHL > 0){
                $mostrarHC .= '<tr style="padding:5px"><td width="166" style="font-size:30px; font-weight:bolder;">EMPRESA</td>';
                $mostrarHC .= '<td style="font-size:30px; font-weight:bolder;">CARGO</td>';
                $mostrarHC .= '<td width="50" style="font-size:30px; font-weight:bolder;">TIEMPO</td>';
                $mostrarHC .= '<td width="175" style="font-size:30px; font-weight:bolder;">FACTOREES RIESGO</td>';
                $mostrarHC .= '<td width="175" style="font-size:30px; font-weight:bolder;">ELEMENTOS DE PROTECCION</td></tr>';
                for($k=0;$k<$pRegistrosHL;$k++)
                {
                    $mostrarHC .= '<tr><td style="font-size:30px;">' . utf8_decode($rowHL[$k]["descEmpresa"]) . '</td><td style="font-size:30px;">' . utf8_decode($rowHL[$k]["descCargo"]) . '</td><td style="font-size:30px;" width="50">' . utf8_decode($rowHL[$k]["descTiempo"]) . '</td><td style="font-size:30px;">' . utf8_decode($rowHL[$k]["descRisego"]) . '</td><td style="font-size:30px;">' . utf8_decode($rowHL[$k]["descElementos"]) . '</td></tr>';
                }
            }
            $mostrarHC .= '</table>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }else{
                $linea = $pdf->GetY();
                $pdf->SetY($linea-4);
            }
            
            $mostrarHC = '<span style="font-size:30px; font-weight:bolder;">EN EL PUESTO DE TRABAJO ACTUAL O ANTERIOR ESTÁ (O ESTUVO) EXPUESTO A:</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<table>';
            $mostrarHC .= '<tr>';
            $mostrarHC .= '<td width="120" style="font-size:30px;"></td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">EMP</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">OTRO</td>';
            $mostrarHC .= '<td width="180" style="font-size:30px;"></td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">EMP</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">OTRO</td>';
            $mostrarHC .= '<td width="150" style="font-size:30px;"></td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">EMP</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">OTRO</td>';
            $mostrarHC .= '</tr>';
            $mostrarHC .= '</table>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }else{
                $linea = $pdf->GetY();
                $pdf->SetY($linea-4);
            }
            
            $mostrarHC = '<table>';
            $mostrarHC .= '<tr>';
            $mostrarHC .= '<td width="120" align="rigth" style="font-size:30px;">Frío Intenso:</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["ExpuestoEmpresaFrioIntenso"]) . '</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["ExpuestoOtroFrioIntenso"]) . '</td>';
            $mostrarHC .= '<td width="180" align="rigth" style="font-size:30px;">Gases:</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["ExpuestoEmpresaGases"]) . '</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["ExpuestoOtroGases"]) . '</td>';
            $mostrarHC .= '<td width="150" align="rigth" style="font-size:30px;">Trabajo monótono:</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["ExpuestoEmpresaTrabajomonotono"]) . '</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["ExpuestoOtroTrabajomonotono"]) . '</td>';
            $mostrarHC .= '</tr>';
            $mostrarHC .= '</table>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }else{
                $linea = $pdf->GetY();
                $pdf->SetY($linea-4);
            }
            
            $mostrarHC = '<table>';
            $mostrarHC .= '<tr>';
            $mostrarHC .= '<td width="120" align="rigth" style="font-size:30px;">Calor Intenso:</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["ExpuestoEmpresaCalorIntenso"]) . '</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["ExpuestoOtroCalorIntenso"]) . '</td>';
            $mostrarHC .= '<td width="180" align="rigth" style="font-size:30px;">Vapores:</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["ExpuestoEmpresaVapores"]) . '</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["ExpuestoOtroVapores"]) . '</td>';
            $mostrarHC .= '<td width="150" align="rigth" style="font-size:30px;">Sobrecarga de trabajo:</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["ExpuestoEmpresaSobrecargadetrabajo"]) . '</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["ExpuestoOtroSobrecargadetrabajo"]) . '</td>';
            $mostrarHC .= '</tr>';
            $mostrarHC .= '</table>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }else{
                $linea = $pdf->GetY();
                $pdf->SetY($linea-4);
            }
            
            $mostrarHC = '<table>';
            $mostrarHC .= '<tr>';
            $mostrarHC .= '<td width="120" align="rigth" style="font-size:30px;">Ventilación inadecuada:</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["ExpuestoEmpresaVentilacioninadecuada"]) . '</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["ExpuestoOtroVentilacioninadecuada"]) . '</td>';
            $mostrarHC .= '<td width="180" align="rigth" style="font-size:30px;">Contacto de piel con químicos:</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["ExpuestoEmpresaContactodepielconquimicos"]) . '</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["ExpuestoOtroContactodepielconquimicos"]) . '</td>';
            $mostrarHC .= '<td width="150" align="rigth" style="font-size:30px;">Horas extras Sobre/tiempo:</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["ExpuestoEmpresaEstras"]) . '</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["ExpuestoOtroEstras"]) . '</td>';
            $mostrarHC .= '</tr>';
            $mostrarHC .= '</table>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }else{
                $linea = $pdf->GetY();
                $pdf->SetY($linea-4);
            }
            $mostrarHC = '<table>';
            $mostrarHC .= '<tr>';
            $mostrarHC .= '<td width="120" align="rigth" style="font-size:30px;">Ruido:</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["ExpuestoEmpresaRuido"]) . '</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["ExpuestoOtroRuido"]) . '</td>';
            $mostrarHC .= '<td width="180" align="rigth" style="font-size:30px;">Humos metálicos:</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["ExpuestoEmpresaHumos"]) . '</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["ExpuestoOtroHumos"]) . '</td>';
            $mostrarHC .= '<td width="150" align="rigth" style="font-size:30px;">Manejo de público:</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["ExpuestoEmpresaManejodepublico"]) . '</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["ExpuestoOtroManejodepublico"]) . '</td>';
            $mostrarHC .= '</tr>';
            $mostrarHC .= '</table>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }else{
                $linea = $pdf->GetY();
                $pdf->SetY($linea-4);
            }
            $mostrarHC = '<table>';
            $mostrarHC .= '<tr>';
            $mostrarHC .= '<td width="120" align="rigth" style="font-size:30px;">Vibraciones:</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["ExpuestoEmpresaVibraciones"]) . '</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["ExpuestoOtroVibraciones"]) . '</td>';
            $mostrarHC .= '<td width="180" align="rigth" style="font-size:30px;">Agentes Biológicos:</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["ExpuestoEmpresaAgentesBiologicos"]) . '</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["ExpuestoOtroAgentesBiologicos"]) . '</td>';
            $mostrarHC .= '<td width="150" align="rigth" style="font-size:30px;">Conflicto de Autoridad:</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["ExpuestoEmpresaConflictodeAutoridad"]) . '</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["ExpuestoOtroConflictodeAutoridad"]) . '</td>';
            $mostrarHC .= '</tr>';
            $mostrarHC .= '</table>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }else{
                $linea = $pdf->GetY();
                $pdf->SetY($linea-4);
            }
            $mostrarHC = '<table>';
            $mostrarHC .= '<tr>';
            $mostrarHC .= '<td width="120" align="rigth" style="font-size:30px;">Luz excesiva:</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["ExpuestoEmpresaLuzexcesiva"]) . '</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["ExpuestoOtroLuzexcesiva"]) . '</td>';
            $mostrarHC .= '<td width="180" align="rigth" style="font-size:30px;">Diseño inadecuado de muebles:</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["ExpuestoEmpresaDisenoinadecuadodemuebles"]) . '</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["ExpuestoOtroDisenoinadecuadodemuebles"]) . '</td>';
            $mostrarHC .= '<td width="150" align="rigth" style="font-size:30px;">Violencia común:</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["ExpuestoEmpresaViolenciacomun"]) . '</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["ExpuestoOtroViolenciacomun"]) . '</td>';
            $mostrarHC .= '</tr>';
            $mostrarHC .= '</table>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }else{
                $linea = $pdf->GetY();
                $pdf->SetY($linea-4);
            }
            $mostrarHC = '<table>';
            $mostrarHC .= '<tr>';
            $mostrarHC .= '<td width="120" align="rigth" style="font-size:30px;">Luz deficiente:</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["ExpuestoEmpresaLuzdeficiente"]) . '</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["ExpuestoOtroLuzdeficiente"]) . '</td>';
            $mostrarHC .= '<td width="180" align="rigth" style="font-size:30px;">Movimientos Repetitivos:</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["ExpuestoEmpresaMovimientosRepetitivos"]) . '</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["ExpuestoOtroMovimientosRepetitivos"]) . '</td>';
            $mostrarHC .= '<td width="150" align="rigth" style="font-size:30px;">Herramientas manuales:</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["ExpuestoEmpresaHerramientasmanuales"]) . '</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["ExpuestoOtroHerramientasmanuales"]) . '</td>';
            $mostrarHC .= '</tr>';
            $mostrarHC .= '</table>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }else{
                $linea = $pdf->GetY();
                $pdf->SetY($linea-4);
            }
            $mostrarHC = '<table>';
            $mostrarHC .= '<tr>';
            $mostrarHC .= '<td width="120" align="rigth" style="font-size:30px;">Radiación No Ionizante:</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["ExpuestoEmpresaRadiacionNoIonizante"]) . '</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["ExpuestoOtroRadiacionNoIonizante"]) . '</td>';
            $mostrarHC .= '<td width="180" align="rigth" style="font-size:30px;">Posturas Inadecuadas:</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["ExpuestoEmpresaPosturasInadecuadas"]) . '</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["ExpuestoOtroPosturasInadecuadas"]) . '</td>';
            $mostrarHC .= '<td width="150" align="rigth" style="font-size:30px;">Proyección de partículas:</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["ExpuestoEmpresaProyecciondeparticulas"]) . '</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["ExpuestoOtroProyecciondeparticulas"]) . '</td>';
            $mostrarHC .= '</tr>';
            $mostrarHC .= '</table>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }else{
                $linea = $pdf->GetY();
                $pdf->SetY($linea-4);
            }
            $mostrarHC = '<table>';
            $mostrarHC .= '<tr>';
            $mostrarHC .= '<td width="120" align="rigth" style="font-size:30px;">Radiación Ionizante:</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["ExpuestoEmpresaRadiacionIonizante"]) . '</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["ExpuestoOtroRadiacionIonizante"]) . '</td>';
            $mostrarHC .= '<td width="180" align="rigth" style="font-size:30px;">Levantamiento de cargas:</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["ExpuestoEmpresaLevantamientodecargas"]) . '</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["ExpuestoOtroLevantamientodecargas"]) . '</td>';
            $mostrarHC .= '<td width="150" align="rigth" style="font-size:30px;">Mecanismos en movimiento:</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["ExpuestoEmpresaMecanismosenmovimiento"]) . '</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["ExpuestoOtroMecanismosenmovimiento"]) . '</td>';
            $mostrarHC .= '</tr>';
            $mostrarHC .= '</table>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }else{
                $linea = $pdf->GetY();
                $pdf->SetY($linea-4);
            }
            $mostrarHC = '<table>';
            $mostrarHC .= '<tr>';
            $mostrarHC .= '<td width="120" align="rigth" style="font-size:30px;">Humos:</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["ExpuestoEmpresaHumos"]) . '</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["ExpuestoOtroHumos"]) . '</td>';
            $mostrarHC .= '<td width="180" align="rigth" style="font-size:30px;">Espacio Trabajo Inadecuado:</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["ExpuestoEmpresaEspacioTrabajoInadecuado"]) . '</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["ExpuestoOtroEspacioTrabajoInadecuado"]) . '</td>';
            $mostrarHC .= '<td width="150" align="rigth" style="font-size:30px;">Equipos a presión:</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["ExpuestoEmpresaEquiposapresion"]) . '</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["ExpuestoOtroEquiposapresion"]) . '</td>';
            $mostrarHC .= '</tr>';
            $mostrarHC .= '</table>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }else{
                $linea = $pdf->GetY();
                $pdf->SetY($linea-4);
            }
            $mostrarHC = '<table>';
            $mostrarHC .= '<tr>';
            $mostrarHC .= '<td width="120" align="rigth" style="font-size:30px;">Polvos:</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["ExpuestoEmpresaPolvos"]) . '</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["ExpuestoOtroPolvos"]) . '</td>';
            $mostrarHC .= '<td width="180" align="rigth" style="font-size:30px;">Estrés:</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["ExpuestoEmpresaEstras"]) . '</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["ExpuestoOtroEstras"]) . '</td>';
            $mostrarHC .= '<td width="150" align="rigth" style="font-size:30px;">Eléctricos:</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["ExpuestoEmpresaElectricos"]) . '</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["ExpuestoOtroElectricos"]) . '</td>';
            $mostrarHC .= '</tr>';
            $mostrarHC .= '</table>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }else{
                $linea = $pdf->GetY();
                $pdf->SetY($linea-4);
            }
            $mostrarHC = '<span style="font-size:30px;"><b>EMPRESA: </b>' . utf8_decode($row[$i]["ExpuestoEmpresa"]). '</span><br>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px;"><b>COMO REALIZA LAS TAREAS? : </b>' . utf8_decode($row[$i]["ComoRealizaTareas"]). '</span><br>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px;"><b>ELEMENTOS DE PROTECCIÓN PERSONAL: </b></span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<table>';
            $mostrarHC .= '<tr>';
            $mostrarHC .= '<td width="180" align="rigth" style="font-size:30px;"></td>';
            $mostrarHC .= '<td width="50" align="center" style="font-size:30px; font-weight:bolder;">Necesita</td>';
            $mostrarHC .= '<td width="50" align="center" style="font-size:30px; font-weight:bolder;">Tiene</td>';
            $mostrarHC .= '<td width="50" align="center" style="font-size:30px; font-weight:bolder;">Utilizo</td>';
            $mostrarHC .= '<td width="180" align="rigth" style="font-size:30px;"></td>';
            $mostrarHC .= '<td width="50" align="center" style="font-size:30px; font-weight:bolder;">Necesita</td>';
            $mostrarHC .= '<td width="50" align="center" style="font-size:30px; font-weight:bolder;">Tiene</td>';
            $mostrarHC .= '<td width="50" align="center" style="font-size:30px; font-weight:bolder;">Utilizo</td>';
            $mostrarHC .= '</tr>';
            $mostrarHC .= '</table>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }else{
                $linea = $pdf->GetY();
                $pdf->SetY($linea-4);
            }
            $mostrarHC = '<table>';
            $mostrarHC .= '<tr>';
            $mostrarHC .= '<td width="180" align="rigth" style="font-size:30px;">Casco</td>';
            $mostrarHC .= '<td width="50" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["EleProtCascoNecesita"]). '</td>';
            $mostrarHC .= '<td width="50" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["EleProtCascoTiene"]). '</td>';
            $mostrarHC .= '<td width="50" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["EleProtCascoUtilizo"]). '</td>';
            $mostrarHC .= '<td width="180" align="rigth" style="font-size:30px;">Guantes</td>';
            $mostrarHC .= '<td width="50" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["EleProtGuantesNecesita"]). '</td>';
            $mostrarHC .= '<td width="50" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["EleProtGuantesTiene"]). '</td>';
            $mostrarHC .= '<td width="50" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["EleProtGuantesUtilizo"]). '</td>';
            $mostrarHC .= '</tr>';
            $mostrarHC .= '</table>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }else{
                $linea = $pdf->GetY();
                $pdf->SetY($linea-4);
            }
            $mostrarHC = '<table>';
            $mostrarHC .= '<tr>';
            $mostrarHC .= '<td width="180" align="rigth" style="font-size:30px;">Cofias</td>';
            $mostrarHC .= '<td width="50" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["EleProtCofiasNecesita"]). '</td>';
            $mostrarHC .= '<td width="50" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["EleProtCofiasTiene"]). '</td>';
            $mostrarHC .= '<td width="50" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["EleProtCofiasUtilizo"]). '</td>';
            $mostrarHC .= '<td width="180" align="rigth" style="font-size:30px;">Braceras</td>';
            $mostrarHC .= '<td width="50" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["EleProtBracerasNecesita"]). '</td>';
            $mostrarHC .= '<td width="50" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["EleProtBracerasTiene"]). '</td>';
            $mostrarHC .= '<td width="50" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["EleProtBracerasUtilizo"]). '</td>';
            $mostrarHC .= '</tr>';
            $mostrarHC .= '</table>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }else{
                $linea = $pdf->GetY();
                $pdf->SetY($linea-4);
            }
            $mostrarHC = '<table>';
            $mostrarHC .= '<tr>';
            $mostrarHC .= '<td width="180" align="rigth" style="font-size:30px;">Gorro</td>';
            $mostrarHC .= '<td width="50" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["EleProtGorroNecesita"]). '</td>';
            $mostrarHC .= '<td width="50" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["EleProtGorroTiene"]). '</td>';
            $mostrarHC .= '<td width="50" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["EleProtGorroUtilizo"]). '</td>';
            $mostrarHC .= '<td width="180" align="rigth" style="font-size:30px;">Peto</td>';
            $mostrarHC .= '<td width="50" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["EleProtPetoNecesita"]). '</td>';
            $mostrarHC .= '<td width="50" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["EleProtPetoTiene"]). '</td>';
            $mostrarHC .= '<td width="50" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["EleProtPetoUtilizo"]). '</td>';
            $mostrarHC .= '</tr>';
            $mostrarHC .= '</table>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }else{
                $linea = $pdf->GetY();
                $pdf->SetY($linea-4);
            }
            $mostrarHC = '<table>';
            $mostrarHC .= '<tr>';
            $mostrarHC .= '<td width="180" align="rigth" style="font-size:30px;">Careta de acetato</td>';
            $mostrarHC .= '<td width="50" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["EleProtCaretadeacetatoNecesita"]). '</td>';
            $mostrarHC .= '<td width="50" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["EleProtCaretadeacetatoTiene"]). '</td>';
            $mostrarHC .= '<td width="50" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["EleProtCaretadeacetatoUtilizo"]). '</td>';
            $mostrarHC .= '<td width="180" align="rigth" style="font-size:30px;">Delantal</td>';
            $mostrarHC .= '<td width="50" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["EleProtDelantalNecesita"]). '</td>';
            $mostrarHC .= '<td width="50" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["EleProtDelantalTiene"]). '</td>';
            $mostrarHC .= '<td width="50" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["EleProtDelantalUtilizo"]). '</td>';
            $mostrarHC .= '</tr>';
            $mostrarHC .= '</table>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }else{
                $linea = $pdf->GetY();
                $pdf->SetY($linea-4);
            }
            $mostrarHC = '<table>';
            $mostrarHC .= '<tr>';
            $mostrarHC .= '<td width="180" align="rigth" style="font-size:30px;">Gafas de Seguridad</td>';
            $mostrarHC .= '<td width="50" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["EleProtCaretadeacetatoNecesita"]). '</td>';
            $mostrarHC .= '<td width="50" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["EleProtCaretadeacetatoTiene"]). '</td>';
            $mostrarHC .= '<td width="50" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["EleProtCaretadeacetatoUtilizo"]). '</td>';
            $mostrarHC .= '<td width="180" align="rigth" style="font-size:30px;">Calzado de Seguridad</td>';
            $mostrarHC .= '<td width="50" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["EleProtCalzadodeSeguridadNecesita"]). '</td>';
            $mostrarHC .= '<td width="50" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["EleProtCalzadodeSeguridadTiene"]). '</td>';
            $mostrarHC .= '<td width="50" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["EleProtCalzadodeSeguridadUtilizo"]). '</td>';
            $mostrarHC .= '</tr>';
            $mostrarHC .= '</table>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }else{
                $linea = $pdf->GetY();
                $pdf->SetY($linea-4);
            }
            $mostrarHC = '<table>';
            $mostrarHC .= '<tr>';
            $mostrarHC .= '<td width="180" align="rigth" style="font-size:30px;">Protectores Auriculares</td>';
            $mostrarHC .= '<td width="50" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["EleProtProtectoresAuricularesNecesita"]). '</td>';
            $mostrarHC .= '<td width="50" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["EleProtProtectoresAuricularesTiene"]). '</td>';
            $mostrarHC .= '<td width="50" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["EleProtProtectoresAuricularesUtilizo"]). '</td>';
            $mostrarHC .= '<td width="180" align="rigth" style="font-size:30px;">otros</td>';
            $mostrarHC .= '<td width="50" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["EleProtOtrosNecesita"]). '</td>';
            $mostrarHC .= '<td width="50" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["EleProtOtrosTiene"]). '</td>';
            $mostrarHC .= '<td width="50" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["EleProtOtrosUtilizo"]). '</td>';
            $mostrarHC .= '</tr>';
            $mostrarHC .= '</table>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            if(utf8_decode($row[$i]["APDeporte"])=="SI"){
                $mostrarHC = '<span style="font-size:30px;">REALIZA ALGUN DEPORTE? ' . utf8_decode($row[$i]["APDeporte"]) . ', CUAL: ' . utf8_decode($row[$i]["APDeporteOtros"]) . ', FRECUENCIA: '. utf8_decode($row[$i]["APDeporteFrecuencia"]) . '</span><br>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }else{
                $mostrarHC = '<span style="font-size:30px;">REALIZA ALGUN DEPORTE? ' . utf8_decode($row[$i]["APDeporte"]) . '</span><br>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            $mostrarHC = '<span style="font-size:30px;"><b>ACCIDENTE DE TRABAJO: </b></span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            if(utf8_decode($row[$i]["SufrioAccidenteTrabajo"])=="SI"){
                $mostrarHC = '<span style="font-size:30px;">HA TENIDO ALGÚN ACCIDENTE DE TRABAJO? ' . utf8_decode($row[$i]["SufrioAccidenteTrabajo"]) . ', DIAGNOSTICO: ' . utf8_decode($row[$i]["SufrioAccidenteTrabajoDx"]) . ', FECHA: '. utf8_decode($row[$i]["SufrioAccidenteTrabajoFec"]) . ', INCAPACIDAD: '. utf8_decode($row[$i]["SufrioAccidenteTrabajoInc"]) .'</span><br>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }else{
                $mostrarHC = '<span style="font-size:30px;">ACCIDENTE DE TRABAJO ' . utf8_decode($row[$i]["SufrioAccidenteTrabajo"]) . '</span><br>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            $mostrarHC = '<span style="font-size:30px;"><b>ENFERMEDAD PROFESIONAL: </b></span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            if(utf8_decode($row[$i]["SufrioEnfProfesional"])=="SI"){
                $mostrarHC = '<span style="font-size:30px;">HA TENIDO ALGUNA ENFERMEDAD PROFESIONAL? ' . utf8_decode($row[$i]["SufrioEnfProfesional"]) . ', DIAGNOSTICO: ' . utf8_decode($row[$i]["SufrioEnfProfesionalDx"]) . ', FECHA: '. utf8_decode($row[$i]["SufrioEnfProfesionalFec"]) . ', INCAPACIDAD: '. utf8_decode($row[$i]["SufrioEnfProfesionalInc"]) .'</span><br>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }else{
                $mostrarHC = '<span style="font-size:30px;">HA TENIDO ALGUNA ENFERMEDAD PROFESIONAL? ' . utf8_decode($row[$i]["SufrioEnfProfesional"]) . '</span><br>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            $mostrarHC = '<span style="font-size:30px;"><b>ANTECEDENTES FAMILIARES: </b></span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<table>';
            $mostrarHC .= '<tr style="font-weight:bolder;">';
            $mostrarHC .= '<td width="110" align="rigth" style="font-size:30px;"></td>';
            $mostrarHC .= '<td width="30" align="center" style="font-size:30px;">Pad</td>';
            $mostrarHC .= '<td width="30" align="center" style="font-size:30px;">Mad</td>';
            $mostrarHC .= '<td width="30" align="center" style="font-size:30px;">Hnos</td>';
            $mostrarHC .= '<td width="30" align="center" style="font-size:30px;">Tio M</td>';
            $mostrarHC .= '<td width="30" align="center" style="font-size:30px;">Tio P</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">Abu M</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">Abu P</td>';
            $mostrarHC .= '<td width="130" align="rigth" style="font-size:30px;"></td>';
            $mostrarHC .= '<td width="30" align="center" style="font-size:30px;">Pad</td>';
            $mostrarHC .= '<td width="30" align="center" style="font-size:30px;">Mad</td>';
            $mostrarHC .= '<td width="30" align="center" style="font-size:30px;">Hnos</td>';
            $mostrarHC .= '<td width="30" align="center" style="font-size:30px;">Tio M</td>';
            $mostrarHC .= '<td width="30" align="center" style="font-size:30px;">Tio P</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">Abu M</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">Abu P</td>';
            $mostrarHC .= '</tr>';
            $mostrarHC .= '</table>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }else{
                $linea = $pdf->GetY();
                $pdf->SetY($linea-4);
                
            }
            $mostrarHC = '<table>';
            $mostrarHC .= '<tr>';
            $mostrarHC .= '<td width="110" align="rigth" style="font-size:30px;">Hipertensión Arterial</td>';
            $mostrarHC .= '<td width="30" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["AFHTAPad"]). '</td>';
            $mostrarHC .= '<td width="30" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["AFHTAMad"]). '</td>';
            $mostrarHC .= '<td width="30" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["AFHTAHno"]). '</td>';
            $mostrarHC .= '<td width="30" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["AFHTATioM"]). '</td>';
            $mostrarHC .= '<td width="30" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["AFHTATioP"]). '</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["AFHTAAbuM"]). '</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["AFHTAAbuP"]). '</td>';
            $mostrarHC .= '<td width="130" align="rigth" style="font-size:30px;">Enf. Mentales</td>';
            $mostrarHC .= '<td width="30" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["AFEnfMentalPad"]). '</td>';
            $mostrarHC .= '<td width="30" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["AFDiabetesMad"]). '</td>';
            $mostrarHC .= '<td width="30" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["AFEnfMentalHno"]). '</td>';
            $mostrarHC .= '<td width="30" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["AFEnfMentalTioM"]). '</td>';
            $mostrarHC .= '<td width="30" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["AFEnfMentalTioP"]). '</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["AFEnfMentalAbuM"]). '</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["AFEnfMentalAbuP"]). '</td>';
            $mostrarHC .= '</tr>';
            $mostrarHC .= '</table>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }else{
                $linea = $pdf->GetY();
                $pdf->SetY($linea-4);
               
            }
            
            $mostrarHC = '<table>';
            $mostrarHC .= '<tr>';
            $mostrarHC .= '<td width="110" align="rigth" style="font-size:30px;">Enfermedad Coronaria</td>';
            $mostrarHC .= '<td width="30" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["AFEnfCoronariaPad"]). '</td>';
            $mostrarHC .= '<td width="30" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["AFEnfCoronariaMad"]). '</td>';
            $mostrarHC .= '<td width="30" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["AFEnfCoronariaHno"]). '</td>';
            $mostrarHC .= '<td width="30" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["AFEnfCoronariaTioM"]). '</td>';
            $mostrarHC .= '<td width="30" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["AFEnfCoronariaTioP"]). '</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["AFEnfCoronariaAbuM"]). '</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["AFEnfCoronariaAbuP"]). '</td>';
            $mostrarHC .= '<td width="130" align="rigth" style="font-size:30px;">Síndrome Convulsivo </td>';
            $mostrarHC .= '<td width="30" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["AFSindromeConvulsivoPad"]). '</td>';
            $mostrarHC .= '<td width="30" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["AFSindromeConvulsivoMad"]). '</td>';
            $mostrarHC .= '<td width="30" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["AFSindromeConvulsivoHno"]). '</td>';
            $mostrarHC .= '<td width="30" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["AFSindromeConvulsivoTioM"]). '</td>';
            $mostrarHC .= '<td width="30" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["AFSindromeConvulsivoTioP"]). '</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["AFSindromeConvulsivoAbuM"]). '</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["AFSindromeConvulsivoAbuP"]). '</td>';
            $mostrarHC .= '</tr>';
            $mostrarHC .= '</table>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            
            }else{
                $linea = $pdf->GetY();
                $pdf->SetY($linea-4);
            }
            $mostrarHC = '<table>';
            $mostrarHC .= '<tr>';
            $mostrarHC .= '<td width="110" align="rigth" style="font-size:30px;">ACV</td>';
            $mostrarHC .= '<td width="30" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["AFACVPad"]). '</td>';
            $mostrarHC .= '<td width="30" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["AFACVMad"]). '</td>';
            $mostrarHC .= '<td width="30" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["AFACVHno"]). '</td>';
            $mostrarHC .= '<td width="30" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["AFACVTioM"]). '</td>';
            $mostrarHC .= '<td width="30" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["AFACVTioP"]). '</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["AFACVAbuM"]). '</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["AFACVAbuP"]). '</td>';
            $mostrarHC .= '<td width="130" align="rigth" style="font-size:30px;">Alcoholismo–Drogadicción </td>';
            $mostrarHC .= '<td width="30" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["AFAlcoholDrogaPad"]). '</td>';
            $mostrarHC .= '<td width="30" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["AFAlcoholDrogaMad"]). '</td>';
            $mostrarHC .= '<td width="30" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["AFAlcoholDrogaHno"]). '</td>';
            $mostrarHC .= '<td width="30" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["AFAlcoholDrogaTioM"]). '</td>';
            $mostrarHC .= '<td width="30" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["AFAlcoholDrogaTioP"]). '</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["AFAlcoholDrogaAbuM"]). '</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["AFAlcoholDrogaAbuP"]). '</td>';
            $mostrarHC .= '</tr>';
            $mostrarHC .= '</table>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            
            }else{
                $linea = $pdf->GetY();
                $pdf->SetY($linea-4);
            }
            $mostrarHC = '<table>';
            $mostrarHC .= '<tr>';
            $mostrarHC .= '<td width="110" align="rigth" style="font-size:30px;">Diabetes</td>';
            $mostrarHC .= '<td width="30" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["AFDiabetesPad"]). '</td>';
            $mostrarHC .= '<td width="30" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["AFDiabetesMad"]). '</td>';
            $mostrarHC .= '<td width="30" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["AFDiabetesHno"]). '</td>';
            $mostrarHC .= '<td width="30" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["AFDiabetesTioM"]). '</td>';
            $mostrarHC .= '<td width="30" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["AFDiabetesTioP"]). '</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["AFDiabetesAbuM"]). '</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["AFDiabetesAbuP"]). '</td>';
            $mostrarHC .= '<td width="130" align="rigth" style="font-size:30px;">Cáncer </td>';
            $mostrarHC .= '<td width="30" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["AFCAPad"]). '</td>';
            $mostrarHC .= '<td width="30" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["AFCAMad"]). '</td>';
            $mostrarHC .= '<td width="30" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["AFCAHno"]). '</td>';
            $mostrarHC .= '<td width="30" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["AFCATioM"]). '</td>';
            $mostrarHC .= '<td width="30" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["AFCATioP"]). '</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["AFCAAbuM"]). '</td>';
            $mostrarHC .= '<td width="40" align="center" style="font-size:30px;">' . utf8_decode($row[$i]["AFCAAbuP"]). '</td>';
            $mostrarHC .= '</tr>';
            $mostrarHC .= '</table>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            
            }else{
                $linea = $pdf->GetY();
                $pdf->SetY($linea-4);
            }
            $mostrarHC = '<table>';
            $mostrarHC .= '<tr>';
            $mostrarHC .= '<td colspan="12" width="550" align="left" style="font-size:30px;">Observaciones:' . utf8_decode($row[$i]["AntecedentesFamiliares"]) . '</td>';
            $mostrarHC .= '</tr>';
            $mostrarHC .= '</table>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            
            }
          
            $mostrarHC = '<span style="font-size:30px;"><b>REVISIÓN POR SISTEMAS: </b></span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }

            
            if(utf8_decode($row[$i]["RSOftalmologico"])!="" || utf8_decode($row[$i]["RSOftalmologico"])!=null){
                $mostrarHC = '<table style="font-size:30px; text-align:justify;"><tr><td width="130"><b>OFTALMOLÓGICO:</b></td><td width="570">' . utf8_decode($row[$i]["RSOftalmologico"]) . '</td></tr></table>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }else{
                    $linea = $pdf->GetY();
                    $pdf->SetY($linea-4);
                }
            }
            
            if(utf8_decode($row[$i]["RSORL"])!="" || utf8_decode($row[$i]["RSORL"])!=null){
                $mostrarHC = '<table style="font-size:30px; text-align:justify;"><tr><td width="130"><b>ORL:</b></td><td width="570">' . utf8_decode($row[$i]["RSORL"]) . '</td></tr></table>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }else{
                    $linea = $pdf->GetY();
                    $pdf->SetY($linea-4);
                }
            }
            
            if(utf8_decode($row[$i]["RSRespiratorio"])!="" || utf8_decode($row[$i]["RSRespiratorio"])!=null){
                $mostrarHC = '<table style="font-size:30px; text-align:justify;"><tr><td width="130"><b>RESPIRATORIO:</b></td><td width="570">' . utf8_decode($row[$i]["RSRespiratorio"]) . '</td></tr></table>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }else{
                    $linea = $pdf->GetY();
                    $pdf->SetY($linea-4);
                }
            }
            
            if(utf8_decode($row[$i]["RSCardiovascular"])!="" || utf8_decode($row[$i]["RSCardiovascular"])!=null){
                $mostrarHC = '<table style="font-size:30px; text-align:justify;"><tr><td width="130"><b>CARDIOVASCULAR:</b></td><td width="570">' . utf8_decode($row[$i]["RSCardiovascular"]) . '</td></tr></table>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }else{
                    $linea = $pdf->GetY();
                    $pdf->SetY($linea-4);
                }
            }
            
            if(utf8_decode($row[$i]["RSDigestivo"])!="" || utf8_decode($row[$i]["RSDigestivo"])!=null){
                $mostrarHC = '<table style="font-size:30px; text-align:justify;"><tr><td width="130"><b>DIGESTIVO:</b></td><td width="570">' . utf8_decode($row[$i]["RSDigestivo"]) . '</td></tr></table>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }else{
                    $linea = $pdf->GetY();
                    $pdf->SetY($linea-4);
                }
            }
            
            if(utf8_decode($row[$i]["RSUrogenital"])!="" || utf8_decode($row[$i]["RSUrogenital"])!=null){
                $mostrarHC = '<table style="font-size:30px; text-align:justify;"><tr><td width="130"><b>GENITO-URINARIO:</b></td><td width="570">' . utf8_decode($row[$i]["RSUrogenital"]) . '</td></tr></table>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }else{
                    $linea = $pdf->GetY();
                    $pdf->SetY($linea-4);
                }
            }
            
            if(utf8_decode($row[$i]["RSLocomotor"])!="" || utf8_decode($row[$i]["RSLocomotor"])!=null){
                $mostrarHC = '<table style="font-size:30px; text-align:justify;"><tr><td width="130"><b>OSTEO-MUSCULAR:</b></td><td width="570">' . utf8_decode($row[$i]["RSLocomotor"]) . '</td></tr></table>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }else{
                    $linea = $pdf->GetY();
                    $pdf->SetY($linea-4);
                }
            }
            
            if(utf8_decode($row[$i]["RSNervioso"])!="" || utf8_decode($row[$i]["RSNervioso"])!=null){
                $mostrarHC = '<table style="font-size:30px; text-align:justify;"><tr><td width="130"><b>SISTEMA NERVIOSO:</b></td><td width="570">' . utf8_decode($row[$i]["RSNervioso"]) . '</td></tr></table>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }else{
                    $linea = $pdf->GetY();
                    $pdf->SetY($linea-4);
                }
            }
            
            if(utf8_decode($row[$i]["RSHematopoyetico"])!="" || utf8_decode($row[$i]["RSHematopoyetico"])!=null){
                $mostrarHC = '<table style="font-size:30px; text-align:justify;"><tr><td width="130"><b>PSICO-EMOCIONAL:</b></td><td width="570">' . utf8_decode($row[$i]["RSHematopoyetico"]) . '</td></tr></table>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }else{
                    $linea = $pdf->GetY();
                    $pdf->SetY($linea-4);
                }
            }
            
            if(utf8_decode($row[$i]["RSOtros"])!="" || utf8_decode($row[$i]["RSOtros"])!=null){
                $mostrarHC = '<table style="font-size:30px; text-align:justify;"><tr><td width="130"><b>OBSERVACIONES:</b></td><td width="570">' . utf8_decode($row[$i]["RSOtros"]) . '</td></tr></table>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }else{
                    $linea = $pdf->GetY();
                    $pdf->SetY($linea-4);
                }
            }
            $pdf->Ln(4);
            
            $mostrarHC = '<span style="font-size:30px;"><b>EXAMEN FISICO: </b></span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
                
            $mostrarHC = '<table><tr><td colspan="4" align="center" style="font-size:30px; font-weight:bolder;"></td></tr>';
            $mostrarHC .= '<tr><td style="font-size:30px; font-weight:bolder;">TOMA DE SIGNOS:</td><td colspan="3">' . utf8_decode($row[$i]["FactorRiesgoActual"]) . '</td></tr>';
            $mostrarHC .= '<tr><td style="font-size:30px;" colspan="4"><b>TALLA:</b>&nbsp;' . utf8_decode($row[$i]["EF_Talla"]) . '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>PESO:</b>&nbsp;' . utf8_decode($row[$i]["EF_Peso"]) . '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>IMC:</b>&nbsp;' . utf8_decode($row[$i]["EF_IMC"]) . ' - ' . utf8_decode($row[$i]["EF_IMCClasificacion"])  . '</td></tr>';
            $mostrarHC .= '<tr><td style="font-size:30px;" colspan="4"><b>LATERALIDAD:</b>&nbsp;' . utf8_decode($row[$i]["EF_Lateralidad"]) .'</td></tr>';
            $mostrarHC .= '<tr><td style="font-size:30px;" colspan="4"><b>FC:</b>&nbsp;' . utf8_decode($row[$i]["EF_FC"]) .'&nbsp;Por minuto&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>TA:</b>&nbsp;' . utf8_decode($row[$i]["EF_TAS"]) . '/' . utf8_decode($row[$i]["EF_TAD"]) . '&nbsp;MmHg&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>FR:</b>&nbsp;' . utf8_decode($row[$i]["EF_FR"])  .'&nbsp;Por minuto&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b></b>&nbsp;' .'</td></tr>'; 
            $mostrarHC .= '<tr><td style="font-size:30px;" colspan="4"><b>OBSERVACIONES:</b>&nbsp;' . utf8_decode($row[$i]["EF_Observaciones"]) .'</td></tr>';
            $mostrarHC .= '</table>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            if(utf8_decode($row[$i]["EF_Ojos"])=="ANORMAL"){
                $mostrarHC = '<table style="font-size:30px; text-align:justify;"><tr><td width="155"><b>OJOS:</b></td><td width="550">' . utf8_decode($row[$i]["EF_Ojos"]) . ', ' . utf8_decode($row[$i]["EF_OjosH"]) . '</td></tr></table>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }else{
                    $linea = $pdf->GetY();
                    $pdf->SetY($linea-4);
                }
            }else{
                $mostrarHC = '<table style="font-size:30px; text-align:justify;"><tr><td width="155"><b>OJOS:</b></td><td width="550">' . utf8_decode($row[$i]["EF_Ojos"]) . '</td></tr></table>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }else{
                    $linea = $pdf->GetY();
                    $pdf->SetY($linea-4);
                }
            }

            if(utf8_decode($row[$i]["EF_Oidos"])=="ANORMAL"){
                $mostrarHC = '<table style="font-size:30px; text-align:justify;"><tr><td width="155"><b>OIDOS:</b></td><td width="550">' . utf8_decode($row[$i]["EF_Oidos"]) . ', ' . utf8_decode($row[$i]["EF_OidosH"]) . '</td></tr></table>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }else{
                    $linea = $pdf->GetY();
                    $pdf->SetY($linea-4);
                }
            }else{
                $mostrarHC = '<table style="font-size:30px; text-align:justify;"><tr><td width="155"><b>OIDOS:</b></td><td width="550">' . utf8_decode($row[$i]["EF_Oidos"]) . '</td></tr></table>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }else{
                    $linea = $pdf->GetY();
                    $pdf->SetY($linea-4);
                }
            }
            if(utf8_decode($row[$i]["EF_Nariz"])=="ANORMAL"){
                $mostrarHC = '<table style="font-size:30px; text-align:justify;"><tr><td width="155"><b>NARIZ:</b></td><td width="550">' . utf8_decode($row[$i]["EF_Nariz"]) . ', ' . utf8_decode($row[$i]["EF_NarizH"]) . '</td></tr></table>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }else{
                    $linea = $pdf->GetY();
                    $pdf->SetY($linea-4);
                }
            }else{
                $mostrarHC = '<table style="font-size:30px; text-align:justify;"><tr><td width="155"><b>NARIZ:</b></td><td width="550">' . utf8_decode($row[$i]["EF_Nariz"]) . '</td></tr></table>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }else{
                    $linea = $pdf->GetY();
                    $pdf->SetY($linea-4);
                }
            }
            if(utf8_decode($row[$i]["EF_Boca"])=="ANORMAL"){
                $mostrarHC = '<table style="font-size:30px; text-align:justify;"><tr><td width="155"><b>BOCA:</b></td><td width="550">' . utf8_decode($row[$i]["EF_Boca"]) . ', ' . utf8_decode($row[$i]["EF_BocaH"]) . '</td></tr></table>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }else{
                    $linea = $pdf->GetY();
                    $pdf->SetY($linea-4);
                }
            }else{
                $mostrarHC = '<table style="font-size:30px; text-align:justify;"><tr><td width="155"><b>BOCA:</b></td><td width="550">' . utf8_decode($row[$i]["EF_Boca"]) . '</td></tr></table>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }else{
                    $linea = $pdf->GetY();
                    $pdf->SetY($linea-4);
                }
            }
            if(utf8_decode($row[$i]["EF_Cuello"])=="ANORMAL"){
                $mostrarHC = '<table style="font-size:30px; text-align:justify;"><tr><td width="155"><b>CUELLO:</b></td><td width="550">' . utf8_decode($row[$i]["EF_Cuello"]) . ', ' . utf8_decode($row[$i]["EF_CuelloH"]) . '</td></tr></table>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }else{
                    $linea = $pdf->GetY();
                    $pdf->SetY($linea-4);
                }
            }else{
                $mostrarHC = '<table style="font-size:30px; text-align:justify;"><tr><td width="155"><b>CUELLO:</b></td><td width="550">' . utf8_decode($row[$i]["EF_Cuello"]) . '</td></tr></table>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }else{
                    $linea = $pdf->GetY();
                    $pdf->SetY($linea-4);
                }
            }
            if(utf8_decode($row[$i]["EF_Torax"])=="ANORMAL"){
                $mostrarHC = '<table style="font-size:30px; text-align:justify;"><tr><td width="155"><b>TORAX:</b></td><td width="550">' . utf8_decode($row[$i]["EF_Torax"]) . ', ' . utf8_decode($row[$i]["EF_ToraxH"]) . '</td></tr></table>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }else{
                    $linea = $pdf->GetY();
                    $pdf->SetY($linea-4);
                }
            }else{
                $mostrarHC = '<table style="font-size:30px; text-align:justify;"><tr><td width="155"><b>TORAX:</b></td><td width="550">' . utf8_decode($row[$i]["EF_Torax"]) . '</td></tr></table>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }else{
                    $linea = $pdf->GetY();
                    $pdf->SetY($linea-4);
                }
            }
            if(utf8_decode($row[$i]["EF_Abdomen"])=="ANORMAL"){
                $mostrarHC = '<table style="font-size:30px; text-align:justify;"><tr><td width="155"><b>ABDOMEN:</b></td><td width="550">' . utf8_decode($row[$i]["EF_Abdomen"]) . ', ' . utf8_decode($row[$i]["EF_AbdomenH"]) . '</td></tr></table>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }else{
                    $linea = $pdf->GetY();
                    $pdf->SetY($linea-4);
                }
            }else{
                $mostrarHC = '<table style="font-size:30px; text-align:justify;"><tr><td width="155"><b>ABDOMEN:</b></td><td width="550">' . utf8_decode($row[$i]["EF_Abdomen"]) . '</td></tr></table>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }else{
                    $linea = $pdf->GetY();
                    $pdf->SetY($linea-4);
                }
            }
            if(utf8_decode($row[$i]["EF_Genitales"])=="ANORMAL"){
                $mostrarHC = '<table style="font-size:30px; text-align:justify;"><tr><td width="155"><b>SISTEMA UROGENITAL:</b></td><td width="550">' . utf8_decode($row[$i]["EF_Genitales"]) . ', ' . utf8_decode($row[$i]["EF_GenitalesH"]) . '</td></tr></table>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }else{
                    $linea = $pdf->GetY();
                    $pdf->SetY($linea-4);
                }
            }else{
                $mostrarHC = '<table style="font-size:30px; text-align:justify;"><tr><td width="155"><b>SISTEMA UROGENITAL:</b></td><td width="550">' . utf8_decode($row[$i]["EF_Genitales"]) . '</td></tr></table>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }else{
                    $linea = $pdf->GetY();
                    $pdf->SetY($linea-4);
                }
            }
            if(utf8_decode($row[$i]["EF_Musculo"])=="ANORMAL"){
                $mostrarHC = '<table style="font-size:30px; text-align:justify;"><tr><td width="155"><b>MÚSCULO – ESQUELÉTICO:</b></td><td width="550">' . utf8_decode($row[$i]["EF_Musculo"]) . ', ' . utf8_decode($row[$i]["EF_MusculoH"]) . '</td></tr></table>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }else{
                    $linea = $pdf->GetY();
                    $pdf->SetY($linea-4);
                }
            }else{
                $mostrarHC = '<table style="font-size:30px; text-align:justify;"><tr><td width="155"><b>MÚSCULO – ESQUELÉTICO:</b></td><td width="550">' . utf8_decode($row[$i]["EF_Musculo"]) . '</td></tr></table>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }else{
                    $linea = $pdf->GetY();
                    $pdf->SetY($linea-4);
                }
            }
            if(utf8_decode($row[$i]["EF_Vascular"])=="ANORMAL"){
                $mostrarHC = '<table style="font-size:30px; text-align:justify;"><tr><td width="155"><b>SISTEMA VASCULAR:</b></td><td width="550">' . utf8_decode($row[$i]["EF_Vascular"]) . ', ' . utf8_decode($row[$i]["EF_VascularH"]) . '</td></tr></table>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }else{
                    $linea = $pdf->GetY();
                    $pdf->SetY($linea-4);
                }
            }else{
                $mostrarHC = '<table style="font-size:30px; text-align:justify;"><tr><td width="155"><b>SISTEMA VASCULAR:</b></td><td width="550">' . utf8_decode($row[$i]["EF_Vascular"]) . '</td></tr></table>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }else{
                    $linea = $pdf->GetY();
                    $pdf->SetY($linea-4);
                }
            }
            if(utf8_decode($row[$i]["EF_Nervioso"])=="ANORMAL"){
                $mostrarHC = '<table style="font-size:30px; text-align:justify;"><tr><td width="155"><b>SISTEMA NERVIOSO:</b></td><td width="550">' . utf8_decode($row[$i]["EF_Nervioso"]) . ', ' . utf8_decode($row[$i]["EF_NerviosoH"]) . '</td></tr></table>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }else{
                    $linea = $pdf->GetY();
                    $pdf->SetY($linea-4);
                }
            }else{
                $mostrarHC = '<table style="font-size:30px; text-align:justify;"><tr><td width="155"><b>SISTEMA NERVIOSO:</b></td><td width="550">' . utf8_decode($row[$i]["EF_Nervioso"]) . '</td></tr></table>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }else{
                    $linea = $pdf->GetY();
                    $pdf->SetY($linea-4);
                }
            }
            if(utf8_decode($row[$i]["EF_PielFaneras"])=="ANORMAL"){
                $mostrarHC = '<table style="font-size:30px; text-align:justify;"><tr><td width="155"><b>PIEL:</b></td><td width="550">' . utf8_decode($row[$i]["EF_PielFaneras"]) . ', ' . utf8_decode($row[$i]["EF_PielFanerasH"]) . '</td></tr></table>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }else{
                    $linea = $pdf->GetY();
                    $pdf->SetY($linea-4);
                }
            }else{
                $mostrarHC = '<table style="font-size:30px; text-align:justify;"><tr><td width="155"><b>PIEL:</b></td><td width="550">' . utf8_decode($row[$i]["EF_PielFaneras"]) . '</td></tr></table>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }else{
                    $linea = $pdf->GetY();
                    $pdf->SetY($linea-4);
                }
            }
            if(utf8_decode($row[$i]["EF_EsfMental"])=="ANORMAL"){
                $mostrarHC = '<table style="font-size:30px; text-align:justify;"><tr><td width="155"><b>ESTADO MENTAL:</b></td><td width="550">' . utf8_decode($row[$i]["EF_EsfMental"]) . ', ' . utf8_decode($row[$i]["EF_EsfMentalH"]) . '</td></tr></table>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }else{
                    $linea = $pdf->GetY();
                    $pdf->SetY($linea-4);
                }
            }else{
                $mostrarHC = '<table style="font-size:30px; text-align:justify;"><tr><td width="155"><b>ESTADO MENTAL:</b></td><td width="550">' . utf8_decode($row[$i]["EF_EsfMental"]) . '</td></tr></table>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }else{
                    $linea = $pdf->GetY();
                    $pdf->SetY($linea-4);
                }
            }

            $pdf->Ln(4);

            $mostrarHC = '<span style="font-size:30px;"><b>EXÁMENES DE LABORATORIO: </b></span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }

            if(utf8_decode($row[$i]["LaboHemoclasificaGrupo"])!="" || utf8_decode($row[$i]["LaboHemoclasificaGrupo"])!=null){
                $mostrarHC = '<table style="font-size:30px; text-align:justify;"><tr><td width="155"><b>HEMOCLASIFICACIÓN:</b></td><td width="550"><b>Tipo: </b>' . utf8_decode($row[$i]["LaboHemoclasificaGrupo"]) . ' <b>RH: </b>' . utf8_decode($row[$i]["LaboHemoclasificaRH"]) . '</td></tr></table>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }else{
                    $linea = $pdf->GetY();
                    $pdf->SetY($linea-4);
                }
            }

            if(utf8_decode($row[$i]["LaboGlucometria"])!="" || utf8_decode($row[$i]["LaboGlucometria"])!=null){
                $mostrarHC = '<table style="font-size:30px; text-align:justify;"><tr><td width="155"><b>GLUCOMETRIA:</b></td><td width="550">' . utf8_decode($row[$i]["LaboGlucometria"]) . '</td></tr></table>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }else{
                    $linea = $pdf->GetY();
                    $pdf->SetY($linea-4);
                }
            }

            if(utf8_decode($row[$i]["LaboGlicemia"])!="" || utf8_decode($row[$i]["LaboGlicemia"])!=null){
                $mostrarHC = '<table style="font-size:30px; text-align:justify;"><tr><td width="155"><b>GLICEMIA:</b></td><td width="550">' . utf8_decode($row[$i]["LaboGlicemia"]) . '</td></tr></table>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }else{
                    $linea = $pdf->GetY();
                    $pdf->SetY($linea-4);
                }
            }

            if(utf8_decode($row[$i]["LaboSerologia"])!="" || utf8_decode($row[$i]["LaboSerologia"])!=null){
                $mostrarHC = '<table style="font-size:30px; text-align:justify;"><tr><td width="155"><b>SEROLOGIA VDRL TIPO I:</b></td><td width="550">' . utf8_decode($row[$i]["LaboSerologia"]) .', ' . utf8_decode($row[$i]["LaboSerologiaH"]) . '</td></tr></table>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }else{
                    $linea = $pdf->GetY();
                    $pdf->SetY($linea-4);
                }
            }

            /*if(utf8_decode($row[$i]["LaboPruebaEmbarazo"])!="" || utf8_decode($row[$i]["LaboPruebaEmbarazo"])!=null){
                $mostrarHC = '<table style="font-size:30px; text-align:justify;"><tr><td width="155"><b>SEROLOGIA VDRL TIPO II:</b></td><td width="550">' . utf8_decode($row[$i]["LaboPruebaEmbarazo"]) .', ' . utf8_decode($row[$i]["LaboPruebaEmbarazoH"]) . '</td></tr></table>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }else{
                    $linea = $pdf->GetY();
                    $pdf->SetY($linea-4);
                }
            }*/

            if(utf8_decode($row[$i]["LaboColesterol"])!="" || utf8_decode($row[$i]["LaboColesterol"])!=null){
                $mostrarHC = '<table style="font-size:30px; text-align:justify;"><tr><td width="155"><b>COLESTEROL:</b></td><td width="550">' . utf8_decode($row[$i]["LaboColesterol"]) . '</td></tr></table>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }else{
                    $linea = $pdf->GetY();
                    $pdf->SetY($linea-4);
                }
            }

            if(utf8_decode($row[$i]["LaboColesterolHDL"])!="" || utf8_decode($row[$i]["LaboColesterolHDL"])!=null){
                $mostrarHC = '<table style="font-size:30px; text-align:justify;"><tr><td width="155"><b>COLESTEROL HDL:</b></td><td width="550">' . utf8_decode($row[$i]["LaboColesterolHDL"]) . '</td></tr></table>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }else{
                    $linea = $pdf->GetY();
                    $pdf->SetY($linea-4);
                }
            }

            if(utf8_decode($row[$i]["LaboColesterolLDL"])!="" || utf8_decode($row[$i]["LaboColesterolLDL"])!=null){
                $mostrarHC = '<table style="font-size:30px; text-align:justify;"><tr><td width="155"><b>COLESTEROL LDL:</b></td><td width="550">' . utf8_decode($row[$i]["LaboColesterolLDL"]) . '</td></tr></table>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }else{
                    $linea = $pdf->GetY();
                    $pdf->SetY($linea-4);
                }
            }

            if(utf8_decode($row[$i]["LaboTrigliceridos"])!="" || utf8_decode($row[$i]["LaboTrigliceridos"])!=null){
                $mostrarHC = '<table style="font-size:30px; text-align:justify;"><tr><td width="155"><b>TRIGLICERIDOS:</b></td><td width="550">' . utf8_decode($row[$i]["LaboTrigliceridos"]) . '</td></tr></table>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }else{
                    $linea = $pdf->GetY();
                    $pdf->SetY($linea-4);
                }
            }

            if(utf8_decode($row[$i]["LaboOtros"])!="" || utf8_decode($row[$i]["LaboOtros"])!=null){
                $mostrarHC = '<table style="font-size:30px; text-align:justify;"><tr><td width="155"><b>OTROS:</b></td><td width="550">' . utf8_decode($row[$i]["LaboOtros"]) . '</td></tr></table>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }else{
                    $linea = $pdf->GetY();
                    $pdf->SetY($linea-4);
                }
            }

            if(utf8_decode($row[$i]["Audiometria"])!="" || utf8_decode($row[$i]["Audiometria"])!=null){
                $pdf->Ln(4);
                $mostrarHC = '<span style="font-size:30px;"><b>AUDIOMETRÍA: </b></span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
                $mostrarHC = '<span style="font-size:30px;">' . utf8_decode($row[$i]["Audiometria"]) . '</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }

            $pdf->Ln(4);
            $mostrarHC = '<span style="font-size:30px;"><b>VISIOMETRÍA: </b></span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $mostrarHC = '<span style="font-size:30px;"><b>CON CORRECCION: </b>' .  utf8_decode($row[$i]["EF_AVCorreccion"]) . '&nbsp;&nbsp;&nbsp;&nbsp;<b>AV: LEJANA OD:</b>&nbsp;' . utf8_decode($row[$i]["EF_AVLejanaOD"]) . '&nbsp;&nbsp;<b>OI:</b>&nbsp;' . utf8_decode($row[$i]["EF_AVLejanaOI"]) . '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>AV: CERCANA OD:</b>&nbsp;' . utf8_decode($row[$i]["EF_AVCercanaOD"]) . '&nbsp;&nbsp;<b>OI:</b>&nbsp;' . utf8_decode($row[$i]["EF_AVCercanaOI"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }

            $mostrarHC = '<table><tr><td style="font-size:30px; font-weight:bolder;">IMPRESIÓN  DIAGNÓSTICA:</td></tr></table>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }

            $mostrarHC = '<span style="font-size:30px; color:#000;"><b>Diagnostico Principal: </b>' . utf8_decode($row[$i]["Diagppal"]) . ' - ' . utf8_decode($row[$i]["DesDiagPpal"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            if (utf8_decode($row[$i]["Diagrel1"]) != "" && utf8_decode($row[$i]["Diagrel1"]) != null){
                $mostrarHC = '<span style="font-size:30px; color:#000;"><b>Diagnostico Relacionado Nro1: </b>' . utf8_decode($row[$i]["Diagrel1"]) . ' - ' . utf8_decode($row[$i]["DesDiagRel1"]) . '</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            if (utf8_decode($row[$i]["Diagrel2"]) != "" && utf8_decode($row[$i]["Diagrel2"]) != null){
                $mostrarHC = '<span style="font-size:30px; color:#000;"><b>Diagnostico Relacionado Nro2: </b>' . utf8_decode($row[$i]["Diagrel2"]) . ' - ' . utf8_decode($row[$i]["DesDiagRel2"]) . '</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            if (utf8_decode($row[$i]["Diagrel3"]) != "" && utf8_decode($row[$i]["Diagrel3"]) != null){
                $mostrarHC = '<span style="font-size:30px; color:#000;"><b>Diagnostico Relacionado Nro3: </b>' . utf8_decode($row[$i]["Diagrel3"]) . ' - ' . utf8_decode($row[$i]["DesDiagRel3"]) . '</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            if (utf8_decode($row[$i]["ResumenDx"]) != "" && utf8_decode($row[$i]["ResumenDx"]) != null){
                $mostrarHC = '<span style="font-size:30px;"><b>OTROS DIAGNOSTICOS RELACIONADOS:</b>&nbsp;' . utf8_decode($row[$i]["ResumenDx"]) . '</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }

            $pdf->Ln(4);
            $mostrarHC = '<table><tr><td style="font-size:30px; font-weight:bolder;">CONCEPTO:</td></tr></table>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }

            if (utf8_decode($row[$i]["CONCEPAptoSinRest"]) == "1"){
                $mostrarHC = '<span style="font-size:30px;">APTO SIN RESTRICCIONES</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            if (utf8_decode($row[$i]["CONCEPAptoConRest"]) == "1"){
                $mostrarHC = '<span style="font-size:30px;">APTO CON RESTRICCIONES</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            if (utf8_decode($row[$i]["CONCEPAptoConCondi"]) == "1"){
                $mostrarHC = '<span style="font-size:30px;">APTO CON CONDICIONES</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            if (utf8_decode($row[$i]["CONCEPNoAptoTempo"]) == "1"){
                $mostrarHC = '<span style="font-size:30px;">NO APTO TEMPORALMENTE</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            if (utf8_decode($row[$i]["CONCEPNoApto"]) == "1"){
                $mostrarHC = '<span style="font-size:30px;">NO APTO</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            if (utf8_decode($row[$i]["CONCEPAptoTrabajoAlturas"]) == "1"){
                $mostrarHC = '<span style="font-size:30px;">APTO PARA TRABAJAR EN ALTURAS</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            if (utf8_decode($row[$i]["CONCEPPatologiaLaboral"]) == "1"){
                $mostrarHC = '<span style="font-size:30px;">POSIBLE PATOLOGIA ORIGEN LABORAL</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            if (utf8_decode($row[$i]["CONCEPSecuelasLaboral"]) == "1"){
                $mostrarHC = '<span style="font-size:30px;">CON SECUELAS DE ACCIDENTE LABORAL</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            if (utf8_decode($row[$i]["CONCEPExamenPeriodicoNormal"]) == "1"){
                $mostrarHC = '<span style="font-size:30px;">EXAMEN PERIODICO NORMAL</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            if (utf8_decode($row[$i]["CONCEPExamenRetiroNormal"]) == "1"){
                $mostrarHC = '<span style="font-size:30px;">EXAMEN RETIRO NORMAL</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            if (utf8_decode($row[$i]["CONCEPPacienteSano"]) == "1"){
                $mostrarHC = '<span style="font-size:30px;">PACIENTE SANO</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            if (utf8_decode($row[$i]["CONCEPProbableEnfProfesional"]) == "1"){
                $mostrarHC = '<span style="font-size:30px;">PACIENETE CON PROBABLE ENFERMEDAD PROFESIONAL</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            if (utf8_decode($row[$i]["CONCEPSecuelasAccidenteTrabajo"]) == "1"){
                $mostrarHC = '<span style="font-size:30px;">PACIENTE CON SECUELAS DE ACCIDENTE DE TRABAJO</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            if (utf8_decode($row[$i]["Concepto"]) != "" && utf8_decode($row[$i]["Concepto"]) != null){
                $mostrarHC = '<span style="font-size:30px; color:#000;"><b>OBSERVACIONES: </b>' . utf8_decode($row[$i]["Concepto"]) . '</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }

            $pdf->Ln(4);
            $mostrarHC = '<table><tr><td style="font-size:30px; font-weight:bolder;">TIPO DE RESTRICCIONES O CAUSAS DE APLAZAMIENTO:</td></tr></table>';
            $mostrarHC .= '<span style="font-size:30px;">' . utf8_decode($row[$i]["Restricciones"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }

            $pdf->Ln(4);
            $mostrarHC = '<table><tr><td style="font-size:30px; font-weight:bolder;">RECOMENDACIONES Y OBSERVACIONES:</td></tr></table>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }

            if (utf8_decode($row[$i]["RECOMENUsoAdecuadoElem"]) == "1"){
                $mostrarHC = '<span style="font-size:30px;">USO ADECUADO DE ELEMENTOS DE PROTECCION</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }

            if (utf8_decode($row[$i]["RECOMENControlAnualOptometria"]) == "1"){
                $mostrarHC = '<span style="font-size:30px;">CONTROL ANUAL POR OPTOMETRIA EN LA EPS</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }

            if (utf8_decode($row[$i]["RECOMENRealizaPausasActivas"]) == "1"){
                $mostrarHC = '<span style="font-size:30px;">REALIZAR PAUSAS ACTIVAS</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }

            if (utf8_decode($row[$i]["RECOMENCertificarTrabajoAlturas"]) == "1"){
                $mostrarHC = '<span style="font-size:30px;">DEBE CERTIFICARSE PARA TRABAJAR EN ALTURAS</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }

            if (utf8_decode($row[$i]["RECOMENUsarMediasVarices"]) == "1"){
                $mostrarHC = '<span style="font-size:30px;">USAR MEDIAS DE SOPORTE ELASTICO PARA VARICES</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }

            if (utf8_decode($row[$i]["RECOMENRealizarCitologia"]) == "1"){
                $mostrarHC = '<span style="font-size:30px;">REALIZAR CITOLOGIA ANUAL</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }

            if (utf8_decode($row[$i]["RECOMENRealizarDietaEjercicio"]) == "1"){
                $mostrarHC = '<span style="font-size:30px;">REALIZAR DIETA, EJERCICIO Y REDUCIR PESO</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }

            if (utf8_decode($row[$i]["RECOMENEvaluarxNutricion"]) == "1"){
                $mostrarHC = '<span style="font-size:30px;">EVALUAR POR NUTRICION EN LA EPS</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }

            if (utf8_decode($row[$i]["RECOMENDejarFumar"]) == "1"){
                $mostrarHC = '<span style="font-size:30px;">DEJAR EL HABITO DE FUMAR</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }

            if (utf8_decode($row[$i]["RECOMENDisminuirConsumoAlcohol"]) == "1"){
                $mostrarHC = '<span style="font-size:30px;">DISMINUIR CONSUMO DE ALCOHOL</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }

            if (utf8_decode($row[$i]["RECOMENIngresarProgaEpidemio"]) == "1"){
                $mostrarHC = '<span style="font-size:30px;">INGRESAR AL SISTEMA DE VIGILANCIA EPIDEMIOLOGICA</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }

            if (utf8_decode($row[$i]["RECOMENPruebasManipulaAlimentos"]) == "1"){
                $mostrarHC = '<span style="font-size:30px;">REALIZAR PRUEBAS PARA MANIPULACION DE ALIMENTOS</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }

            if (utf8_decode($row[$i]["RECOMENPruebasComplementarias"]) == "1"){
                $mostrarHC = '<span style="font-size:30px;">REALIZAR PRUEBAS COMPLEMENTARIAS</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }

            if (utf8_decode($row[$i]["RECOMENOtros"]) != "" && utf8_decode($row[$i]["RECOMENOtros"]) != null){
                $mostrarHC = '<span style="font-size:30px; color:#000;"><b>OBSERVACIONES: </b>' . utf8_decode($row[$i]["RECOMENOtros"]) . '</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            // FORMATO FONO Y ADICIONAL LO DE BARRETO MAS REMISION A PROGRAMAS
        }
    }

    $pdf->Ln();

    //$mostrarHC = '<table border="1" style="padding:3px; border-top-width: 0.5px; border-right-width: 0.5px; border-bottom-width: 0.5px; border-left-width: 0.5px;"><tr><td align="center" style="font-size:24px; font-weight:bolder;">CONSENTIMIENTO INFORMADO DEL ASPIRANTE O TRABAJADOR</td></tr>';
    //$mostrarHC .= '<tr><td style="text-align:justify; font-size:20px; color:#000;">Autorizo al profesional abajo mencionado a que se me realice de manera voluntaria el examen medico ocupacional y exámenes complementarios. Dejo constancia que tuve la oportunidad de manifestar mi consentimiento para la realización del Examen Medico Ocupacional y/o exámenes complementarios a partir de la información recibida por el profesional abajo mencionado. Certifico que la información suministrada es verdadera, completa y acepto el manejo de confidencialidad que se le de a la misma. Autorizo que se suministre la información necesaria a las personas o entidades contempladas en la legislación para dar cumplimiento al programa de Salud Ocupacional.</td></tr></table>';
    $mostrarHC = '<table border="1" style="padding:3px; border-top-width: 0.5px; border-right-width: 0.5px; border-bottom-width: 0.5px; border-left-width: 0.5px;"><tr><td colspan="2" align="center" style="font-size:24px; font-weight:bolder;">CONSENTIMIENTO INFORMADO</td></tr>';
    $mostrarHC .= '<tr><td width="600" style="text-align:justify; font-size:20px; color:#000;">De acuerdo a  Resolución 2346 de 2007, modificado por la Resolución 1918 de 2009. Manifiesto he sido informado por parte del Personal  asistencial de ' . $_SESSION['NOM_EMPRESA'] . ' a cerca de los exámenes que me van a  ser  realizados  Historia Clínica Ocupacional y otros como Ej. Audiometría, electrocardiograma, oximetría, espirometría, Tamizaje visual, Exámenes de Laboratorio (ej. Serología, perfil lipídico, prueba de embarazo, glucometría,  cuadro hemático, creatinina, nitrógeno ureico, transaminasas, bilirrubinas, parcial de orina) por parte del grupo asistencial de ' . $_SESSION['NOM_EMPRESA'] . ', comprendo y estoy de acuerdo, en consecuencia  doy mi consentimiento  para la realización de estos y autorizo al personal de ' . $_SESSION['NOM_EMPRESA'] . ' a que proceda con la realización. Autorizo a que se suministre la información necesaria  a las personas o entidades contempladas en la legislación para dar cumplimiento al programa de salud ocupacional o aquellas personas según lo contemple la ley o que yo autorice por escrito para la entrega de mis reportes e historia clínica, teniendo en cuenta  la reserva de historia clínica que está contemplado en el decreto 1995 de 1999.  Además estoy de acuerdo y aseguro que toda la información que he suministrado para la realización de esta historia clínica es verdadera</td>';
    if($_SESSION['IdAplicacion'] == "OfiMedical"){
        $pImgHuella = '../../../consultoriovirtual/' . $_SESSION['IDBD']  . '/pacientes/' . $pPaciente . '/uploads/huella.gif';
    }else{
       $pImgHuella = '../../../empresas/' . $_SESSION['ID_EMPRESA']  . '/pacientes/' . $pPaciente . '/uploads/huella.gif'; 
    }
    if (file_exists($pImgHuella)) {
        $mostrarHC .= '<td width="108"><img src="' . $pImgHuella . '" width="90" height="80"></td>';
    }
    $mostrarHC .= '</tr></table>';
    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
    }
    $mostrarHC = '<br><table border="0" cellspacing="0">';
    $mostrarHC .= '<tr><td style="font-size:18px; color:#000; font-weight:bolder;">';
    if (file_exists('../../../empresas/' . $_SESSION['ID_EMPRESA']  . '/firmas/' . $row[0]["Profesional"] . '.png')) {
        $mostrarHC .= '<img src="../../../empresas/' . $_SESSION['ID_EMPRESA'] . '/firmas/' . $row[0]["Profesional"] . '.png" width="100" height="25"/><br><hr>';
    }
    $mostrarHC .= '<span>' . $row[0]['NomProfesional'] . '</span><br>';
    $mostrarHC .= '<span>' . $row[0]['nomEspecialidad'] . '</span><br>';
    $mostrarHC .= '<span>' . $row[0]['DocProfesional'] . '</span><br>';
    $mostrarHC .= '<span>' . $row[0]['RegistroProfesional'] . '</span><br>';
    $mostrarHC .= '</td>';
    $mostrarHC .= '<td width="150"></td>';
    $mostrarHC .= '<td></td>';
    $mostrarHC .= '</tr>';
    $mostrarHC .= '</table>';
    $pdf->writeHTML($mostrarHC, true, false, false, false, '');

    $pdf->Output('infHistoriaSaludOcupacional.pdf', 'I');

    function EncabezadoPagina(&$pdf, &$row, &$i, &$rowcount, &$contador, &$pDesde, &$pHasta){
        $pdf->AddPage();
        $pdf->Ln(0.5);
        $img_file = "../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/fondofac.png";
        $pdf->Image($img_file, $pdf->GetX()+60, $pdf->GetY()+95, 90, 50, '', '', '', false, 300, '', false, false, 0);
        $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
        $styleBarCode['position'] = 'R';
        $pdf->write1DBarcode($row["CAS"] . "-" . $row["ConceptoFinal"], 'EAN13', '', '', '', 5, 0.4, $styleBarCode, 'N');
        $EncabezadoHTML = '<table cellspacing="0" border="0" style="font-size:24px; color:#000;">';
        $EncabezadoHTML .= '<tr>';
        $EncabezadoHTML .= '<td>';
        $EncabezadoHTML .= '<span style="font-size:44px; color:#000; font-weight:bold">' . utf8_decode($pdf->pNomEmpresa) . '</span><br>';
        if($pdf->pEspEmpresa != null || $pdf->pEspEmpresa != "")
                $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . utf8_decode($pdf->pEspEmpresa) . '</span><br>';
        if($pdf->pTDocEmpresa == "NI"){
            $tipodoc = "NIT: ";
            $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $tipodoc . $pdf->pDocEmpresa . '</span><br>';
        }
        $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">Cel: ' . $pdf->pTelEmpresa . '</span><br>';
        $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $pdf->pCiuEmpresa . '</span>';
        $EncabezadoHTML .= '</td>';

        //COL2
        $EncabezadoHTML .= '<td align="right">';
        if (file_exists("../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/logoenc.gif")) {
            $EncabezadoHTML .= '<img src="../../../empresas/' . $_SESSION['ID_EMPRESA'] . '/logo/logoenc.gif" align="right"/>';
            $EncabezadoHTML .= '<br>';
        }
        $EncabezadoHTML .= '<span align="rigth" style="font-size:44px; color:#000; font-weight:bold">HISTORIA CLINICA OCUPACIONAL</span><br>';
        $EncabezadoHTML .= '<span align="rigth" style="font-size:26px; color:#000; font-weight:bold">Copia Controlada</span><br>';
        if (file_exists('../../../empresas/' . $_SESSION['ID_EMPRESA']  . '/pacientes/' . $row[$i]["Paciente"] . '/uploads/foto.jpg')) {
            $EncabezadoHTML .= '<br><img src="../../../empresas/' . $_SESSION['ID_EMPRESA']  . '/pacientes/' . $row[$i]["Paciente"] . '/uploads/foto.jpg" width="130" height="100"/><br>';
        }
        $EncabezadoHTML .= '</td>';
        $EncabezadoHTML .= '</tr>';
        $EncabezadoHTML .= '</table>';
        $EncabezadoHTML .= '<hr>';
        $pdf->writeHTML($EncabezadoHTML, true, false, false, false, '');
        
    }

?>
