<?php

set_time_limit(500);
require_once('../../../lib/tcpdf/config/lang/spa.php');
require_once('../../../lib/tcpdf/tcpdf.php');
require("../../../core/php/_database.php");
require("../../../core/php/php_functions.php");
//header('Content-type: application/pdf; charset: UTF-8');

    session_start();
    $pConsultorioVirtual = $_SESSION['IDBD'];
    $nomEmpresa = $_SESSION['NOM_EMPRESA'];
    $nomUsuario = $_SESSION['NOM_USUARIO'];
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:1;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:1;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pEvolucion = isset($_REQUEST['pEvolucion'])?$_REQUEST['pEvolucion']:0;

    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_partisalud_printhc('" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pEvolucion . "')";
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    while ($row[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $pRegistros = count($row);

    //Definicion de las Margenes
    $LeftMargin = PDF_MARGIN_LEFT;
    $TopMargin = 10;
    $RightMargin = PDF_MARGIN_RIGHT;
    $HeaderMargin = PDF_MARGIN_HEADER;
    $BottomMargin = 3;
    $FooterMargin = 5;
    $Alineacion = "P";
    $FormatoPagina = "CARTA";
    $UsaPiePagina = "SI";
    $pTipoEncabezado = "FVP";
    $pControlSalto = 20;
    $styleBarCode = array(
        'position' => 'R',
        'align' => 'R',
        'stretch' => false,
        'fitwidth' => true,
        'cellfitalign' => 'R',
        'border' => true,
        'hpadding' => 'auto',
        'vpadding' => 'auto',
        'fgcolor' => array(0,0,0),
        'bgcolor' => false, //array(255,255,255),
        'text' => true,
        'font' => 'helvetica',
        'fontsize' => 7,
        'stretchtext' => 4
    );
    //Inicializacion de la Clase
    $pdf = new TCPDF($Alineacion, PDF_UNIT, $FormatoPagina, true, 'UTF-8', false);
    //Inicializacion Variables de Control
    $pdf->pAlineacionEncabezado = $Alineacion;
    $pdf->pTituloInforme = "CERTIFICADO";
    $pdf->pImprimeLogo = "NO";
    $pdf->pAnchoTxtPagina = 210;
    $pdf->pNomEmpresa = $_SESSION['NOM_EMPRESA'];
    $pdf->pTDocEmpresa = $_SESSION['EMPRESA_TDOC'];
    $pdf->pDocEmpresa = $_SESSION['EMPRESA_DOC'];
    $pdf->pDirEmpresa = $_SESSION['EMPRESA_DIR'];
    $pdf->pTelEmpresa = $_SESSION['EMPRESA_TEL'];
    $pdf->pCiuEmpresa = $_SESSION['EMPRESA_CIU'];
    $pdf->pEspEmpresa = $_SESSION['EMPRESA_ESP'];
    $pdf->pRegEmpresa = $_SESSION['EMPRESA_REGIMEN'];
    $pdf->pContribuyentes = $_SESSION['EMPRESA_CONTRIBUYENTE'];
    $pdf->pReteIVA  = $_SESSION['EMPRESA_RTEICA'];
    $pdf->pReteICA = $_SESSION['EMPRESA_RTEIVA'];

    $pdf->pTipoEncabezado = $pTipoEncabezado;
    $pdf->pNomSede = $_SESSION['EMPRESA_DOC'];
    $pdf->pNomIPS = $_SESSION['NOM_IPS'];
    $pdf->pMargenPie = -20;
    $pdf->pLogoCliente = "../../../empresas/" . $_SESSION['I_EMPRESA'] . "/logo/logoenc.gif";
    $pdf->pPrefijo = 1; //$row[0]["Prefijo"];
    $pdf->pNroDocumento = 1; //str_pad($row[0]["NroDocumento"], 7, "0", STR_PAD_LEFT);
    $pdf->pNroResolucion = 1; //$row[0]["NroResolucion"];
    $pdf->pFechaDoc = 1; //$row[0]["FechaDocumento"];
    $pdf->pCAS = null;
    $pdf->pTratamiento = null;
    $pdf->pUsaPie = $UsaPiePagina;

    $pdf->SetCreator(PDF_CREATOR);
    $pdf->SetAuthor('Sistemas Ofisalud © - 2011');
    $pdf->SetTitle('Ofimedical©');
    $pdf->SetSubject('Soporte Certificado Salud Ocupacional');

    $pdf->SetHeaderData($pdf->pLogoCliente, PDF_HEADER_LOGO_WIDTH, $pdf->pTituloInforme, PDF_HEADER_STRING);
    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
    $pdf->SetMargins($LeftMargin, $TopMargin, $RightMargin);
    $pdf->SetHeaderMargin($HeaderMargin);
    $pdf->SetFooterMargin($FooterMargin);
    // set bacground image

    $pdf->SetAutoPageBreak(TRUE, $BottomMargin);
    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
    $pdf->setLanguageArray($l);
    $pdf->setFontSubsetting(true);
    $pdf->SetFont('dejavusans', '', 14, '', true);

    for($i=0;$i<$pRegistros;$i++)
    {
        if($row[$i]["nomPaciente"] != ""){
            if ($idPaciente != $row[$i]["nomPaciente"])
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
            $pdf->Ln(0.5);
            
            $mostrarHC = '<table><tr><td width="80" style="font-size:30px; font-weight:bolder;">FECHA:</td><td>' . utf8_decode($row[$i]["Fecha"]);
            if(utf8_decode($row[$i]["HoraInicioMedico"]) != "" && utf8_decode($row[$i]["HoraInicioMedico"]) != null){
                $mostrarHC .= '&nbsp;&nbsp;-&nbsp;<b>HORA:</b>&nbsp;' . utf8_decode($row[$i]["HoraInicioMedico"]);
            } 
            $mostrarHC .= '</td></tr>';
            //$mostrarHC .= '<tr><td style="font-size:30px; font-weight:bolder;">EMPRESA:</td><td>' . utf8_decode($row[$i]["Empresa"]) . '</td></tr>';
            $mostrarHC .= '<tr><td style="font-size:30px; font-weight:bolder;">CIUDAD:</td><td>' . utf8_decode($row[$i]["Muni"]) . " - " . utf8_decode($row[$i]["Depto"]) . '</td></tr></table>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<table><tr><td colspan="4" style="font-size:30px; font-weight:bolder;">DATOS PERSONALES:</td></tr>';
            $mostrarHC .= '<tr><td width="145" style="font-size:30px; font-weight:bolder;">NOMBRES Y APELLIDOS:</td><td width="300">' . utf8_decode($row[$i]["Nom1"]) . " " . utf8_decode($row[$i]["Nom2"]) . " " . utf8_decode($row[$i]["Ape1"]) . " " . utf8_decode($row[$i]["Ape2"]) . '</td>';
            $mostrarHC .= '<td></td></tr>';
            $mostrarHC .= '<tr><td style="font-size:30px; font-weight:bolder;">IDENTIFICACION:</td><td>' . utf8_decode($row[$i]["TipDoc"]) . " - " . utf8_decode($row[$i]["Documento"]) . '</td><td width="100" style="font-size:30px; font-weight:bolder;"></td><td></td></tr>';
            $mostrarHC .= '<tr><td style="font-size:30px; font-weight:bolder;">FECHA DE NACIMIENTO:</td><td>' . utf8_decode($row[$i]["FecNac"]) . '</td><td width="100" style="font-size:30px; font-weight:bolder;">SEXO:</td><td>' . utf8_decode($row[$i]["Genero"]) . '</td></tr>';
            $mostrarHC .= '<tr><td style="font-size:30px; font-weight:bolder;">ESTADO CIVIL:</td><td>' . utf8_decode($row[$i]["EstadoCivil"]) . '</td><td width="100" style="font-size:30px; font-weight:bolder;">EDAD:</td><td align = "left">' . utf8_decode($row[0]["EdadPaciente"]) . '</td></tr>';
            $mostrarHC .= '<tr><td style="font-size:30px; font-weight:bolder;">DIRECCION:</td><td>' . utf8_decode($row[$i]["Direccion"]) . '</td><td width="100" style="font-size:30px; font-weight:bolder;">TELEFONO:</td><td>' . utf8_decode($row[$i]["Telefono"]) . " - " . utf8_decode($row[$i]["Telefono1"]) . '</td></tr>';
            $mostrarHC .= '<tr><td style="font-size:30px; font-weight:bolder;">ESCOLARIDAD:</td><td>' . utf8_decode($row[$i]["Escolaridad"]) . '</td><td width="100" style="font-size:30px; font-weight:bolder;">PROFESION:</td><td>' . utf8_decode($row[$i]["Ocupacion"]) . '</td></tr>';
            //$mostrarHC .= '<tr><td style="font-size:30px; font-weight:bolder;">CARGO ACTUAL:</td><td>' . utf8_decode($row[$i]["CargoActual"]) . '</td><td width="100" style="font-size:30px; font-weight:bolder;">FECHA INGRESO:</td><td>' . utf8_decode($row[$i]["FechaIngreso"]) . '</td></tr>';
            //$mostrarHC .= '<tr><td style="font-size:30px; font-weight:bolder;">FACTORES RIESGO:</td><td colspan="3">' . utf8_decode($row[$i]["FactorRiesgoActual"]) . '</td></tr>';
            $mostrarHC .= '</table>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            if(strtoupper($row[0]["TipoExamen"])=="EGRESO"){
                $mostrarHC = '<table><tr><td width="150" style="font-size:30px; font-weight:bolder;">CARGO ACTUAL:</td><td>' . utf8_decode($row[$i]["CargoEmpresaActual"]) . '</td></tr></table>';
            }else{
                $mostrarHC = '<table><tr><td width="150" style="font-size:30px; font-weight:bolder;">CARGO AL QUE ASPIRA:</td><td>' . utf8_decode($row[$i]["CargoAspira"]) . '</td></tr></table>';
            }
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            //$pdf->Ln(4);
            if(utf8_decode($row[$i]["CONCEPAptoSinRest"]) == "1" || utf8_decode($row[$i]["CONCEPAptoConRest"]) == "1" || utf8_decode($row[$i]["CONCEPAptoConCondi"]) == "1" || utf8_decode($row[$i]["CONCEPNoAptoTempo"]) == "1" || utf8_decode($row[$i]["CONCEPNoApto"]) == "1" || utf8_decode($row[$i]["CONCEPAptoTrabajoAlturas"]) == "1" || utf8_decode($row[$i]["CONCEPPatologiaLaboral"]) == "1" || utf8_decode($row[$i]["CONCEPSecuelasLaboral"]) == "1" || utf8_decode($row[$i]["CONCEPExamenPeriodicoNormal"]) == "1" || utf8_decode($row[$i]["CONCEPExamenRetiroNormal"]) == "1" || utf8_decode($row[$i]["CONCEPPacienteSano"]) == "1" || utf8_decode($row[$i]["CONCEPProbableEnfProfesional"]) == "1" || utf8_decode($row[$i]["CONCEPSecuelasAccidenteTrabajo"]) == "1"){
                $mostrarHC = '<span style="font-size:30px; font-weight:bolder;">CONCEPTO</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }

                if (utf8_decode($row[$i]["CONCEPAptoSinRest"]) == "1"){
                    $mostrarHC = '<span style="font-size:30px;">APTO SIN RESTRICCIONES</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                    {
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
                if (utf8_decode($row[$i]["CONCEPAptoConRest"]) == "1"){
                    $mostrarHC = '<span style="font-size:30px;">APTO CON RESTRICCIONES</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                    {
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
                if (utf8_decode($row[$i]["CONCEPAptoConCondi"]) == "1"){
                    $mostrarHC = '<span style="font-size:30px;">APTO CON CONDICIONES</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                    {
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
                if (utf8_decode($row[$i]["CONCEPNoAptoTempo"]) == "1"){
                    $mostrarHC = '<span style="font-size:30px;">NO APTO TEMPORALMENTE</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                    {
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
                if (utf8_decode($row[$i]["CONCEPNoApto"]) == "1"){
                    $mostrarHC = '<span style="font-size:30px;">NO APTO</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                    {
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
                if (utf8_decode($row[$i]["CONCEPAptoTrabajoAlturas"]) == "1"){
                    $mostrarHC = '<span style="font-size:30px;">APTO PARA TRABAJAR EN ALTURAS</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                    {
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
                if (utf8_decode($row[$i]["CONCEPPatologiaLaboral"]) == "1"){
                    $mostrarHC = '<span style="font-size:30px;">POSIBLE PATOLOGIA ORIGEN LABORAL</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                    {
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
                if (utf8_decode($row[$i]["CONCEPSecuelasLaboral"]) == "1"){
                    $mostrarHC = '<span style="font-size:30px;">CON SECUELAS DE ACCIDENTE LABORAL</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                    {
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
                if (utf8_decode($row[$i]["CONCEPExamenPeriodicoNormal"]) == "1"){
                    $mostrarHC = '<span style="font-size:30px;">EXAMEN PERIODICO NORMAL</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                    {
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
                if (utf8_decode($row[$i]["CONCEPExamenRetiroNormal"]) == "1"){
                    $mostrarHC = '<span style="font-size:30px;">EXAMEN RETIRO NORMAL</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                    {
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
                if (utf8_decode($row[$i]["CONCEPPacienteSano"]) == "1"){
                    $mostrarHC = '<span style="font-size:30px;">PACIENTE SANO</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                    {
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
                if (utf8_decode($row[$i]["CONCEPProbableEnfProfesional"]) == "1"){
                    $mostrarHC = '<span style="font-size:30px;">PACIENETE CON PROBABLE ENFERMEDAD PROFESIONAL</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                    {
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
                if (utf8_decode($row[$i]["CONCEPSecuelasAccidenteTrabajo"]) == "1"){
                    $mostrarHC = '<span style="font-size:30px;">PACIENTE CON SECUELAS DE ACCIDENTE DE TRABAJO</span>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                    {
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                }
            }
            
            if($row[$i]["PasoMedicoOcupacional"] == 1 || $row[$i]["PasoMedicoOcupacional"] == '1'){
                $pdf->Ln(4);

                //$mostrarHC = '<hr><br><table><tr><td valign="middle" width="500" style="font-size:30px;"><b>MEDICO:</b><br><b>TIPO DE RESTRICCIONES O CAUSAS DE APLAZAMIENTO:</b><br><span style="text-align:justify;">' . utf8_decode($row[$i]["Restricciones"]);
                $mostrarHC = '<hr><br><table><tr><td valign="middle" width="500" style="font-size:30px;"><b>MEDICO:</b><br><b>OBSERVACIONES:</b><br><span style="text-align:justify;">' . utf8_decode($row[$i]["Restricciones"]);
                if (utf8_decode($row[$i]["Concepto"]) != "" && utf8_decode($row[$i]["Concepto"]) != null){
                    $mostrarHC .= '<br><b>OBSERVACIONES: </b>' . utf8_decode($row[$i]["Concepto"]) . '</span></td>';
                }else{
                    $mostrarHC .= '</span></td>';
                }
                $mostrarHC .= '<td width="20"></td>';
                $mostrarHC .= '<td width="200">';
                if (file_exists('../../../empresas/' . $_SESSION['ID_EMPRESA']  . '/firmas/' . $row[0]["Profesional"] . '.png')) {
                    $mostrarHC .= '<img src="../../../empresas/' . $_SESSION['ID_EMPRESA'] . '/firmas/' . $row[0]["Profesional"] . '.png" width="100" height="25"/><br>';
                }
                $mostrarHC .= '<span>' . $row[0]['NomProfesional'] . '</span><br>';
                $mostrarHC .= '<span>' . $row[0]['nomEspecialidad'] . '</span><br>';
                $mostrarHC .= '<span>' . $row[0]['DocProfesional'] . '</span><br>';
                $mostrarHC .= '<span>' . $row[0]['RegistroProfesional'] . '</span><br>';
                $mostrarHC .= '</td>';
                $mostrarHC .= '</tr>';
                $mostrarHC .= '</table><br><hr>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }

            $pdf->Ln(4);
            if($row[0]["ConceptoTomaSignos"] != "SIN DEFINIR"){
                $mostrarHC = '<table><tr><td width="500" style="font-size:30px;" valign="middle"><b>VISIOMETRIA:</b><br><span style="text-align:justify;">' . utf8_decode($row[$i]["EF_OjosH"]) . '<br>CON CORRECCION: ' .  utf8_decode($row[$i]["EF_AVCorreccion"]) . '</span></td>';
                $mostrarHC .= '<td width="20"></td>';
                $mostrarHC .= '<td width="200">';
                if (file_exists('../../../empresas/' . $_SESSION['ID_EMPRESA']  . '/firmas/' . $row[0]["ProfesionalTomaSignos"] . '.png')) {
                    $mostrarHC .= '<img src="../../../empresas/' . $_SESSION['ID_EMPRESA'] . '/firmas/' . $row[0]["ProfesionalTomaSignos"] . '.png" width="100" height="25"/><br>';
                }
                $mostrarHC .= '<span>' . $row[0]['NomProfeTomaSignos'] . '</span><br>';
                $mostrarHC .= '<span>' . $row[0]['DocProfeTomaSignos'] . '</span><br>';
                $mostrarHC .= '<span>' . $row[0]['RegProfeTomaSignos'] . '</span><br>';
                $mostrarHC .= '</td>';
                $mostrarHC .= '</tr>';
                $mostrarHC .= '</table><hr><br>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            if($row[0]["ConceptoFonoaudiologia"] != "SIN DEFINIR"){
                $mostrarHC = '<table><tr><td valign="middle" width="500" style="font-size:30px;"><b>AUDIOMETRIA:</b><br><span style="text-align:justify;">' . utf8_decode($row[$i]["Audiometria"]) .'</span></td>';
                $mostrarHC .= '<td width="20"></td>';
                $mostrarHC .= '<td width="200">';
                if (file_exists('../../../empresas/' . $_SESSION['ID_EMPRESA']  . '/firmas/' . $row[0]["ProfesionalFonoaudiologia"] . '.png')) {
                    $mostrarHC .= '<img src="../../../empresas/' . $_SESSION['ID_EMPRESA'] . '/firmas/' . $row[0]["ProfesionalFonoaudiologia"] . '.png" width="100" height="25"/><br>';
                }
                $mostrarHC .= '<span>' . $row[0]['NomProfeFono'] . '</span><br>';
                $mostrarHC .= '<span>' . $row[0]['DocProfeFono'] . '</span><br>';
                $mostrarHC .= '<span>' . $row[0]['RegProfeFono'] . '</span><br>';
                $mostrarHC .= '</td>';
                $mostrarHC .= '</tr>';
                $mostrarHC .= '</table><hr><br>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }

            /*
            $mostrarHC = '<table><tr><td valign="middle" width="500" style="font-size:30px;"><b>SEROLOGIA TIPO II:</b><br><span style="text-align:justify;">' . /*utf8_decode($row[$i]["LaboPruebaEmbarazoH"]) . '</span></td>';
            $mostrarHC .= '<td width="20"></td>';
            $mostrarHC .= '<td width="200">';
            if (file_exists('../../../empresas/' . $_SESSION['ID_EMPRESA']  . '/firmas/' . $row[0]["ProfesionalLaboratorio"] . '.png')) {
                $mostrarHC .= '<img src="../../../empresas/' . $_SESSION['ID_EMPRESA'] . '/firmas/' . $row[0]["ProfesionalLaboratorio"] . '.png" width="100" height="25"/><br>';
            }
            $mostrarHC .= '<span>' . $row[0]['NomProfeLabo'] . '</span><br>';
            $mostrarHC .= '<span>' . $row[0]['DocProfeLabo'] . '</span><br>';
            $mostrarHC .= '<span>' . $row[0]['RegProfeLabo'] . '</span><br>';
            $mostrarHC .= '</td>';
            $mostrarHC .= '</tr>';
            $mostrarHC .= '</table><hr><br>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            */

        }
    }

    $pdf->Ln();
    $mostrarHC = '<table border="1" style="padding:3px; border-top-width: 0.5px; border-right-width: 0.5px; border-bottom-width: 0.5px; border-left-width: 0.5px;"><tr><td align="center" style="font-size:24px; font-weight:bolder;">CONSENTIMIENTO INFORMADO DEL ASPIRANTE O TRABAJADOR</td></tr>';
    $mostrarHC .= '<tr><td style="text-align:justify; font-size:20px; color:#000;">Autorizo a los profesionales mencionados a que se me realice de manera voluntaria el examen medico ocupacional y exámenes complementarios. Dejo constancia que tuve la oportunidad de manifestar mi consentimiento para la realización del Examen Medico Ocupacional y/o exámenes complementarios a partir de la información recibida por los profesionales mencionados. Certifico que la información suministrada es verdadera, completa y acepto el manejo de confidencialidad que se le de a la misma. Autorizo que se suministre la información necesaria a las personas o entidades contempladas en la legislación para dar cumplimiento al programa de Salud Ocupacional.</td></tr></table>';
    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
    }
    

    $pdf->Output('infHistoriaSaludOcupacional.pdf', 'I');

    function EncabezadoPagina(&$pdf, &$row, &$i, &$rowcount, &$contador, &$pDesde, &$pHasta){
        $pdf->AddPage();
        $pdf->Ln(0.5);
        $img_file = "../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/fondofac.png";
        $pdf->Image($img_file, $pdf->GetX()+45, $pdf->GetY()+95, 90, 50, '', '', '', false, 300, '', false, false, 0);
        $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
        $styleBarCode['position'] = 'R';
        $pdf->write1DBarcode($row["CAS"] . "-" . $row["ConceptoFinal"], 'EAN13', '', '', '', 5, 0.4, $styleBarCode, 'N');
        $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
        $EncabezadoHTML = '<table cellspacing="0" border="0" style="font-size:24px; color:#000;">';
        $EncabezadoHTML .= '<tr>';
        $EncabezadoHTML .= '<td>';
        $EncabezadoHTML .= '<span style="font-size:44px; color:#000; font-weight:bold">' . utf8_decode($pdf->pNomEmpresa) . '</span><br>';
        if($pdf->pEspEmpresa != null || $pdf->pEspEmpresa != "")
                $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . utf8_decode($pdf->pEspEmpresa) . '</span><br>';
        if($pdf->pTDocEmpresa == "NI"){
            $tipodoc = "NIT: ";
            $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $tipodoc . $pdf->pDocEmpresa . '</span><br>';
        }
        $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">Cel: ' . $pdf->pTelEmpresa . '</span><br>';
        $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $pdf->pCiuEmpresa . '</span>';
        $EncabezadoHTML .= '</td>';

        //COL2
        $EncabezadoHTML .= '<td align="right">';
        if (file_exists("../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/logoenc.gif")) {
            $EncabezadoHTML .= '<img src="../../../empresas/' . $_SESSION['ID_EMPRESA'] . '/logo/logoenc.gif" align="right"/>';
            $EncabezadoHTML .= '<br>';
        }
        $EncabezadoHTML .= '<span align="rigth" style="font-size:44px; color:#000; font-weight:bold">CERTIFICADO EXAMEN MEDICO DE ' . strtoupper($row[0]["TipoExamen"]) . '</span><br>';
        $EncabezadoHTML .= '<span align="rigth" style="font-size:26px; color:#000; font-weight:bold">(Resolución 2346 de 2007)</span>';
        if (file_exists('../../../empresas/' . $_SESSION['ID_EMPRESA']  . '/pacientes/' . $row[$i]["Paciente"] . '/uploads/foto.jpg')) {
            $EncabezadoHTML .= '<br><img src="../../../empresas/' . $_SESSION['ID_EMPRESA']  . '/pacientes/' . $row[$i]["Paciente"] . '/uploads/foto.jpg" width="130" height="100"/><br>';
        }
        $EncabezadoHTML .= '</td>';
        $EncabezadoHTML .= '</tr>';
        $EncabezadoHTML .= '</table>';
        $EncabezadoHTML .= '<hr>';
        $pdf->writeHTML($EncabezadoHTML, true, false, false, false, '');
    }

?>
