<?php

set_time_limit(500);
require_once('../../../lib/tcpdf/config/lang/spa.php');
require_once('../../../lib/tcpdf/tcpdf.php');
require("../../../core/php/_database.php");
require("../../../core/php/php_functions.php");
//header('Content-type: application/pdf; charset: UTF-8');

    session_start();
    $pConsultorioVirtual = $_SESSION['IDBD'];
    $nomEmpresa = $_SESSION['NOM_EMPRESA'];
    $nomUsuario = $_SESSION['NOM_USUARIO'];
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:1;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:1;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pEvolucion = isset($_REQUEST['pEvolucion'])?$_REQUEST['pEvolucion']:0;

    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_saludocupa_printhc('" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pEvolucion . "')";
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    while ($row[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $pRegistros = count($row);

    //Definicion de las Margenes
    $LeftMargin = PDF_MARGIN_LEFT;
    $TopMargin = 5;
    $RightMargin = PDF_MARGIN_RIGHT;
    $HeaderMargin = PDF_MARGIN_HEADER;
    $BottomMargin = 3;
    $FooterMargin = 5;
    $Alineacion = "L";
    $FormatoPagina = "MEDIACARTA";
    $UsaPiePagina = "SI";
    $pTipoEncabezado = "FVP";
    $pControlSalto = 10;
    $styleBarCode = array(
        'position' => 'R',
        'align' => 'R',
        'stretch' => false,
        'fitwidth' => true,
        'cellfitalign' => 'R',
        'border' => true,
        'hpadding' => 'auto',
        'vpadding' => 'auto',
        'fgcolor' => array(0,0,0),
        'bgcolor' => false, //array(255,255,255),
        'text' => true,
        'font' => 'helvetica',
        'fontsize' => 7,
        'stretchtext' => 4
    );
    //Inicializacion de la Clase
    $pdf = new TCPDF($Alineacion, PDF_UNIT, $FormatoPagina, true, 'UTF-8', false);
    //Inicializacion Variables de Control
    $pdf->pAlineacionEncabezado = $Alineacion;
    $pdf->pTituloInforme = "TAMIZAJE VISUAL";
    $pdf->pImprimeLogo = "NO";
    $pdf->pAnchoTxtPagina = 210;
    $pdf->pNomEmpresa = $_SESSION['NOM_EMPRESA'];
    $pdf->pTDocEmpresa = $_SESSION['EMPRESA_TDOC'];
    $pdf->pDocEmpresa = $_SESSION['EMPRESA_DOC'];
    $pdf->pDirEmpresa = $_SESSION['EMPRESA_DIR'];
    $pdf->pTelEmpresa = $_SESSION['EMPRESA_TEL'];
    $pdf->pCiuEmpresa = $_SESSION['EMPRESA_CIU'];
    $pdf->pEspEmpresa = $_SESSION['EMPRESA_ESP'];
    $pdf->pRegEmpresa = $_SESSION['EMPRESA_REGIMEN'];
    $pdf->pContribuyentes = $_SESSION['EMPRESA_CONTRIBUYENTE'];
    $pdf->pReteIVA  = $_SESSION['EMPRESA_RTEICA'];
    $pdf->pReteICA = $_SESSION['EMPRESA_RTEIVA'];

    $pdf->pTipoEncabezado = $pTipoEncabezado;
    $pdf->pNomSede = $_SESSION['EMPRESA_DOC'];
    $pdf->pNomIPS = $_SESSION['NOM_IPS'];
    $pdf->pMargenPie = -20;
    $pdf->pLogoCliente = "../../../empresas/" . $_SESSION['I_EMPRESA'] . "/logo/logoenc.gif";
    $pdf->pPrefijo = 1; //$row[0]["Prefijo"];
    $pdf->pNroDocumento = 1; //str_pad($row[0]["NroDocumento"], 7, "0", STR_PAD_LEFT);
    $pdf->pNroResolucion = 1; //$row[0]["NroResolucion"];
    $pdf->pFechaDoc = 1; //$row[0]["FechaDocumento"];
    $pdf->pCAS = null;
    $pdf->pTratamiento = null;
    $pdf->pUsaPie = $UsaPiePagina;

    $pdf->SetCreator(PDF_CREATOR);
    $pdf->SetAuthor('Sistemas Ofisalud © - 2011');
    $pdf->SetTitle('Ofimedical©');
    $pdf->SetSubject('Soporte Laboratorio');

    $pdf->SetHeaderData($pdf->pLogoCliente, PDF_HEADER_LOGO_WIDTH, $pdf->pTituloInforme, PDF_HEADER_STRING);
    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
    $pdf->SetMargins($LeftMargin, $TopMargin, $RightMargin);
    $pdf->SetHeaderMargin($HeaderMargin);
    $pdf->SetFooterMargin($FooterMargin);
    // set bacground image

    $pdf->SetAutoPageBreak(TRUE, $BottomMargin);
    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
    $pdf->setLanguageArray($l);
    $pdf->setFontSubsetting(true);
    $pdf->SetFont('dejavusans', '', 14, '', true);

    for($i=0;$i<$pRegistros;$i++)
    {
        if($row[$i]["nomPaciente"] != ""){
            if ($idPaciente != $row[$i]["nomPaciente"])
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
            $pdf->Ln(0.5);
            
            $mostrarHC = '<table><tr><td width="80" style="font-size:30px; font-weight:bolder;">FECHA:</td><td>' . utf8_decode($row[$i]["Fecha"]);
            if(utf8_decode($row[$i]["HoraInicioTomaMuestras"]) != "" && utf8_decode($row[$i]["HoraInicioTomaMuestras"]) != null){
                $mostrarHC .= '&nbsp;&nbsp;-&nbsp;<b>HORA:</b>&nbsp;' . utf8_decode($row[$i]["HoraInicioTomaMuestras"]);
            } 
            $mostrarHC .= '</td></tr>';
            //$mostrarHC .= '<tr><td style="font-size:30px; font-weight:bolder;">EMPRESA:</td><td>' . utf8_decode($row[$i]["Empresa"]) . '</td></tr>';
            $mostrarHC .= '<tr><td style="font-size:30px; font-weight:bolder;">CIUDAD:</td><td>' . utf8_decode($row[$i]["Muni"]) . " - " . utf8_decode($row[$i]["Depto"]) . '</td></tr></table>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<table><tr><td colspan="4" style="font-size:30px; font-weight:bolder;">DATOS PERSONALES:</td></tr>';
            $mostrarHC .= '<tr><td width="145" style="font-size:30px; font-weight:bolder;">NOMBRES Y APELLIDOS:</td><td width="300">' . utf8_decode($row[$i]["Nom1"]) . " " . utf8_decode($row[$i]["Nom2"]) . " " . utf8_decode($row[$i]["Ape1"]) . " " . utf8_decode($row[$i]["Ape2"]) . '</td>';
            $mostrarHC .= '<td></td></tr>';
            $mostrarHC .= '<tr><td style="font-size:30px; font-weight:bolder;">IDENTIFICACION:</td><td>' . utf8_decode($row[$i]["TipDoc"]) . " - " . utf8_decode($row[$i]["Documento"]) . '</td><td width="100" style="font-size:30px; font-weight:bolder;"></td><td></td></tr>';
            $mostrarHC .= '<tr><td style="font-size:30px; font-weight:bolder;">FECHA DE NACIMIENTO:</td><td>' . utf8_decode($row[$i]["FecNac"]) . '</td><td width="100" style="font-size:30px; font-weight:bolder;">SEXO:</td><td>' . utf8_decode($row[$i]["Genero"]) . '</td></tr>';
            $mostrarHC .= '<tr><td style="font-size:30px; font-weight:bolder;">ESTADO CIVIL:</td><td>' . utf8_decode($row[$i]["EstadoCivil"]) . '</td><td width="100" style="font-size:30px; font-weight:bolder;">EDAD:</td><td align = "left">' . utf8_decode($row[0]["EdadPaciente"]) . '</td></tr>';
            $mostrarHC .= '<tr><td style="font-size:30px; font-weight:bolder;">DIRECCION:</td><td>' . utf8_decode($row[$i]["Direccion"]) . '</td><td width="100" style="font-size:30px; font-weight:bolder;">TELEFONO:</td><td>' . utf8_decode($row[$i]["Telefono"]) . " - " . utf8_decode($row[$i]["Telefono1"]) . '</td></tr>';
            $mostrarHC .= '<tr><td style="font-size:30px; font-weight:bolder;">ESCOLARIDAD:</td><td>' . utf8_decode($row[$i]["Escolaridad"]) . '</td><td width="100" style="font-size:30px; font-weight:bolder;">PROFESION:</td><td>' . utf8_decode($row[$i]["Ocupacion"]) . '</td></tr>';
            $mostrarHC .= '</table>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $pdf->Ln(4);
            if(utf8_decode($row[$i]["LaboHemoclasificaGrupo"])!="" || utf8_decode($row[$i]["LaboHemoclasificaGrupo"])!=null){
                $mostrarHC = '<table style="font-size:30px; text-align:justify;"><tr><td width="155"><b>HEMOCLASIFICACIÓN:</b></td><td width="550"><b>Tipo: </b>' . utf8_decode($row[$i]["LaboHemoclasificaGrupo"]) . ' <b>RH: </b>' . utf8_decode($row[$i]["LaboHemoclasificaRH"]) . '</td></tr></table>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }else{
                    $linea = $pdf->GetY();
                    $pdf->SetY($linea-4);
                }
            }

            if(utf8_decode($row[$i]["LaboGlucometria"])!="" || utf8_decode($row[$i]["LaboGlucometria"])!=null){
                $mostrarHC = '<table style="font-size:30px; text-align:justify;"><tr><td width="155"><b>GLUCOMETRIA:</b></td><td width="550">' . utf8_decode($row[$i]["LaboGlucometria"]) . '</td></tr></table>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }else{
                    $linea = $pdf->GetY();
                    $pdf->SetY($linea-4);
                }
            }

            if(utf8_decode($row[$i]["LaboGlicemia"])!="" || utf8_decode($row[$i]["LaboGlicemia"])!=null){
                $mostrarHC = '<table style="font-size:30px; text-align:justify;"><tr><td width="155"><b>GLICEMIA:</b></td><td width="550">' . utf8_decode($row[$i]["LaboGlicemia"]) . '</td></tr></table>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }else{
                    $linea = $pdf->GetY();
                    $pdf->SetY($linea-4);
                }
            }

            if(utf8_decode($row[$i]["LaboSerologia"])!="" || utf8_decode($row[$i]["LaboSerologia"])!=null){
                $mostrarHC = '<table style="font-size:30px; text-align:justify;"><tr><td width="155"><b>SEROLOGIA VDRL TIPO I:</b></td><td width="550">' . utf8_decode($row[$i]["LaboSerologia"]) .', ' . utf8_decode($row[$i]["LaboSerologiaH"]) . '</td></tr></table>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }else{
                    $linea = $pdf->GetY();
                    $pdf->SetY($linea-4);
                }
            }

            if(utf8_decode($row[$i]["LaboColesterol"])!="" || utf8_decode($row[$i]["LaboColesterol"])!=null){
                $mostrarHC = '<table style="font-size:30px; text-align:justify;"><tr><td width="155"><b>COLESTEROL:</b></td><td width="550">' . utf8_decode($row[$i]["LaboColesterol"]) . '</td></tr></table>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }else{
                    $linea = $pdf->GetY();
                    $pdf->SetY($linea-4);
                }
            }

            if(utf8_decode($row[$i]["LaboColesterolHDL"])!="" || utf8_decode($row[$i]["LaboColesterolHDL"])!=null){
                $mostrarHC = '<table style="font-size:30px; text-align:justify;"><tr><td width="155"><b>COLESTEROL HDL:</b></td><td width="550">' . utf8_decode($row[$i]["LaboColesterolHDL"]) . '</td></tr></table>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }else{
                    $linea = $pdf->GetY();
                    $pdf->SetY($linea-4);
                }
            }

            if(utf8_decode($row[$i]["LaboColesterolLDL"])!="" || utf8_decode($row[$i]["LaboColesterolLDL"])!=null){
                $mostrarHC = '<table style="font-size:30px; text-align:justify;"><tr><td width="155"><b>COLESTEROL LDL:</b></td><td width="550">' . utf8_decode($row[$i]["LaboColesterolLDL"]) . '</td></tr></table>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }else{
                    $linea = $pdf->GetY();
                    $pdf->SetY($linea-4);
                }
            }

            if(utf8_decode($row[$i]["LaboTrigliceridos"])!="" || utf8_decode($row[$i]["LaboTrigliceridos"])!=null){
                $mostrarHC = '<table style="font-size:30px; text-align:justify;"><tr><td width="155"><b>TRIGLICERIDOS:</b></td><td width="550">' . utf8_decode($row[$i]["LaboTrigliceridos"]) . '</td></tr></table>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }else{
                    $linea = $pdf->GetY();
                    $pdf->SetY($linea-4);
                }
            }

            if(utf8_decode($row[$i]["LaboOtros"])!="" || utf8_decode($row[$i]["LaboOtros"])!=null){
                $mostrarHC = '<table style="font-size:30px; text-align:justify;"><tr><td width="155"><b>OTROS:</b></td><td width="550">' . utf8_decode($row[$i]["LaboOtros"]) . '</td></tr></table>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }else{
                    $linea = $pdf->GetY();
                    $pdf->SetY($linea-4);
                }
            }
            
            $mostrarHC = '<table><tr>';
            $mostrarHC .= '<td width="470"></td>';
            $mostrarHC .= '<td width="200">';
            if (file_exists('../../../empresas/' . $_SESSION['ID_EMPRESA']  . '/firmas/' . $row[0]["ProfesionalLaboratorio"] . '.png')) {
                $mostrarHC .= '<img src="../../../empresas/' . $_SESSION['ID_EMPRESA'] . '/firmas/' . $row[0]["ProfesionalLaboratorio"] . '.png" width="100" height="25"/><br>';
            }
            $mostrarHC .= '<span>' . $row[0]['NomProfeLabo'] . '</span><br>';
            $mostrarHC .= '<span>' . $row[0]['DocProfeLabo'] . '</span><br>';
            $mostrarHC .= '<span>' . $row[0]['RegProfeLabo'] . '</span><br>';
            $mostrarHC .= '</td>';
            $mostrarHC .= '</tr>';
            $mostrarHC .= '</table>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
        }
    }
    
    $pdf->Output('infLaboratorio.pdf', 'I');

    function EncabezadoPagina(&$pdf, &$row, &$i, &$rowcount, &$contador, &$pDesde, &$pHasta){
        $pdf->AddPage();
        $pdf->Ln(0.5);
        $img_file = "../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/fondofac.png";
        $pdf->Image($img_file, $pdf->GetX()+45, $pdf->GetY()+42, 90, 50, '', '', '', false, 300, '', false, false, 0);
        $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
        $styleBarCode['position'] = 'R';
        $pdf->write1DBarcode($row["CAS"] . "-" . $row["ConceptoFinal"], 'EAN13', '', '', '', 5, 0.4, $styleBarCode, 'N');
        $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
        $EncabezadoHTML = '<table cellspacing="0" border="0" style="font-size:24px; color:#000;">';
        $EncabezadoHTML .= '<tr>';
        $EncabezadoHTML .= '<td>';
        $EncabezadoHTML .= '<span style="font-size:44px; color:#000; font-weight:bold">' . utf8_decode($pdf->pNomEmpresa) . '</span><br>';
        if($pdf->pEspEmpresa != null || $pdf->pEspEmpresa != "")
                $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . utf8_decode($pdf->pEspEmpresa) . '</span><br>';
        if($pdf->pTDocEmpresa == "NI"){
            $tipodoc = "NIT: ";
            $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $tipodoc . $pdf->pDocEmpresa . '</span><br>';
        }
        $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">Cel: ' . $pdf->pTelEmpresa . '</span><br>';
        $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $pdf->pCiuEmpresa . '</span>';
        $EncabezadoHTML .= '</td>';

        //COL2
        $EncabezadoHTML .= '<td align="right">';
        if (file_exists("../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/logoenc.gif")) {
            $EncabezadoHTML .= '<img src="../../../empresas/' . $_SESSION['ID_EMPRESA'] . '/logo/logoenc.gif" align="right"/>';
            $EncabezadoHTML .= '<br>';
        }
        $EncabezadoHTML .= '<span align="rigth" style="font-size:44px; color:#000; font-weight:bold">EXÁMENES DE LABORATORIO</span><br>';
        //$EncabezadoHTML .= '<span align="rigth" style="font-size:26px; color:#000; font-weight:bold">(Resolución 2346 de 2007)</span>';
        if (file_exists('../../../empresas/' . $_SESSION['ID_EMPRESA']  . '/pacientes/' . $row[$i]["Paciente"] . '/uploads/foto.jpg')) {
            $EncabezadoHTML .= '<br><img src="../../../empresas/' . $_SESSION['ID_EMPRESA']  . '/pacientes/' . $row[$i]["Paciente"] . '/uploads/foto.jpg" width="130" height="100"/><br>';
        }
        $EncabezadoHTML .= '</td>';
        $EncabezadoHTML .= '</tr>';
        $EncabezadoHTML .= '</table>';
        $EncabezadoHTML .= '<hr>';
        $pdf->writeHTML($EncabezadoHTML, true, false, false, false, '');
    }

?>
