<?php

/*
* @category    Controlador Profesionales
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

require("../../../core/php/_database.php");
require("../../../core/php/php_functions.php");

$task = '';
if ( isset($_POST['task'])){
  $task = $_POST['task'];
}
switch($task){
    case "AGENDA_MANUAL_LISTAR":
        AgendaManualListar();
        break;
    case "AGENDA_MANUAL_CANCELAR":
        AgendaManualCancelar();
        break;
    case "AGENDA_MANUAL_INASISTENCIA":
        AgendaManualInasistencia();
        break;
    case "AGENDA_ASOTRANSCAL_ASIGNARCITA":
        AgendaManualAsignarCita();
        break;
    case "AGENDA_MANUAL_EVOLUCIONAR":
        AgendaManualEvolucionar();
        break;
    case "PARTISALUD_CERRAR_PROCESO":
        CerrarProceso();
        break;
    default:
        echo "{failure:true}";
        break;
}

function CerrarProceso(){
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $pConcepto = isset($_REQUEST['pConcepto'])?$_REQUEST['pConcepto']:null;
    $qry = "CALL sp_asotranscal_closeproceso('" . $pCAS . "','" . $pUsuario . "',\"" . $pConcepto . "\")";
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function AgendaManualEvolucionar(){
    $pPrestador = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $pFecha = isset($_REQUEST['pFecha'])?$_REQUEST['pFecha']:null;
    $pEstado = isset($_REQUEST['pEstado'])?$_REQUEST['pEstado']:'x';
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_profesionales_agendamanual_evolucionar('" . $pPrestador . "','"  . $pIPS . "','" . $pProfesional . "',\"" . $pFecha . "\",\"" . $pEstado . "\")";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = PonerAcentosHTML($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}

function AgendaManualAsignarCita(){
    $CodInsercion = "PRS-" .  $_SESSION['ID_EMPRESA'] . "-SED-" . $_SESSION['ID_SEDE'] .  "-IPS-" . $_SESSION['ID_IPS'] . "-USR-" . $_SESSION['ID_USUARIO'] . "-CONS-" . mt_rand(0,100000) . "-" . date("His");
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pSO = isset($_REQUEST['pSO'])?$_REQUEST['pSO']:"NO";
    $pProfesionalCita = isset($_REQUEST['pProfesionalCita'])?$_REQUEST['pProfesionalCita']:0;
    $pFechaCita = isset($_REQUEST['pFechaCita'])?$_REQUEST['pFechaCita']:null;
    $pHoraCita = isset($_REQUEST['pHoraCita'])?$_REQUEST['pHoraCita']:null;
    $pHoraCitaInfAdd = isset($_REQUEST['pHoraCitaInfAdd'])?$_REQUEST['pHoraCitaInfAdd']:null;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pCliente = isset($_REQUEST['pCliente'])?$_REQUEST['pCliente']:0;
    $pPlan = isset($_REQUEST['pPlan'])?$_REQUEST['pPlan']:0;
    $pSubPlan = isset($_REQUEST['pSubPlan'])?$_REQUEST['pSubPlan']:0;
    $pIdProcedimiento = isset($_REQUEST['pConcepto'])?$_REQUEST['pConcepto']:0;
    $pCodProcedimiento = isset($_REQUEST['pCodProced'])?$_REQUEST['pCodProced']:"";
    $pDesProcedimiento = isset($_REQUEST['pDesProced'])?$_REQUEST['pDesProced']:"";
    $pTarifaProcedimiento = isset($_REQUEST['pTarifaProced'])?$_REQUEST['pTarifaProced']:0;
    $pSolicitudUsuario = isset($_REQUEST['pSolicitudUsuario'])?$_REQUEST['pSolicitudUsuario']:0;
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $anio = substr($pFechaCita, 0, 4);
    $mes = substr($pFechaCita, 5, 2);
    $dia = substr($pFechaCita, 8, 2);
    $fecCita = mktime(0,0,0,$mes,$dia,$anio);
    $diaSemanaCita = date("D",$fecCita);
    $horaCita = date("H",$fecCita);
    $OportunidadCita = OportunidadAsignacionCitas($fecCita);
    $pConceptos = explode("¬", isset($_REQUEST['pConceptos'])?$_REQUEST['pConceptos']:"");
    $pItemsConceptos = count($pConceptos)-1;
    
    $pNroPersonasCargoProceso = isset($_REQUEST['pNroPersonasCargoProceso'])?$_REQUEST['pNroPersonasCargoProceso']:null;
    $pCargoAspiraProceso = isset($_REQUEST['pCargoAspiraProceso'])?$_REQUEST['pCargoAspiraProceso']:null;
    $pEmpresaAspiraProceso = isset($_REQUEST['pEmpresaAspiraProceso'])?$_REQUEST['pEmpresaAspiraProceso']:null;
    $pCargoEmpresaActualProceso = isset($_REQUEST['pCargoEmpresaActualProceso'])?$_REQUEST['pCargoEmpresaActualProceso']:null;
    $pEmpresaActualProceso = isset($_REQUEST['pEmpresaActualProceso'])?$_REQUEST['pEmpresaActualProceso']:null;
    $pNomSedeEmpresaActualProceso = isset($_REQUEST['pNomSedeEmpresaActualProceso'])?$_REQUEST['pNomSedeEmpresaActualProceso']:null;
    $pAntiguedadCargoActualProceso = isset($_REQUEST['pAntiguedadCargoActualProceso'])?$_REQUEST['pAntiguedadCargoActualProceso']:null;
    $pAntiguedadOficioProceso = isset($_REQUEST['pAntiguedadOficioProceso'])?$_REQUEST['pAntiguedadOficioProceso']:null;
    $pTipoExamenProceso = isset($_REQUEST['pTipoExamenProceso'])?$_REQUEST['pTipoExamenProceso']:null;
    $pEPSProceso = isset($_REQUEST['pEPSProceso'])?$_REQUEST['pEPSProceso']:null;
    $pPENSIONProceso = isset($_REQUEST['pPENSIONProceso'])?$_REQUEST['pPENSIONProceso']:null;
    $pARPProceso = isset($_REQUEST['pARPProceso'])?$_REQUEST['pARPProceso']:null;
    $pTipoVinculacionContratoProceso = isset($_REQUEST['pTipoVinculacionContratoProceso'])?$_REQUEST['pTipoVinculacionContratoProceso']:null;
    $pTurnoProceso = isset($_REQUEST['pTurnoProceso'])?$_REQUEST['pTurnoProceso']:null;
    
    $qry = "CALL sp_asotranscal_asignarcita(\"" . $CodInsercion . "\",'" . $pEmpresa . "','" .$pIPS . "','" . $pProfesionalCita . "',\"" . $pFechaCita . "\",\"" . $pHoraCita . "\",\"" . $pHoraCitaInfAdd . "\",'" . $pPaciente . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pUsuario . "',\"" . $pSolicitudUsuario . "\",'" . $OportunidadCita . "')";
    //echo $qry;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $CampoLlave = explode("^",$gBaseDatos->jasonSP_arreglo2011($qry));
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    if($CampoLlave[0] > 0){
        for($i=0; $i<$pItemsConceptos; $i++){
            $pInfoConcepto = explode("^", $pConceptos[$i]);
            //$qry1 = "CALL sp_asotranscal_asignarcita_detalle(\"" . $CodInsercion . "\",'" . $pEmpresa . "','" .$pIPS . "','" . $pProfesionalCita . "',\"" . $pFechaCita . "\",\"" . $pHoraCita . "\",\"" . $pHoraCitaInfAdd . "\",'" . $pPaciente . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pUsuario . "',\"" . $pSolicitudUsuario . "\",'" . $OportunidadCita . "','" . $CampoLlave[0] . "','" . $pInfoConcepto[0] . "',\"" . $pInfoConcepto[1] . "\",\"" . $pInfoConcepto[2] . "\",'" . $pInfoConcepto[3] . "',\"" . $pSO . "\")";
            $qry1 = "CALL sp_asotranscal_asignarcita_detalle(\"" . $CodInsercion . "\",'" . $pEmpresa . "','" .$pIPS . "','" . $pProfesionalCita . "',\"" . $pFechaCita . "\",\"" . $pHoraCita . "\",\"" . $pHoraCitaInfAdd . "\",'" . $pPaciente . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pUsuario . "',\"" . $pSolicitudUsuario . "\",'" . $OportunidadCita . "','" . $CampoLlave[0] . "','" . $pInfoConcepto[0] . "',\"" . $pInfoConcepto[1] . "\",\"" . $pInfoConcepto[2] . "\",'" . $pInfoConcepto[3] . "',\"" . $pSO . "\",\"" . $pNroPersonasCargoProceso . "\",\"" . $pCargoAspiraProceso . "\",\"" . $pEmpresaAspiraProceso . "\",\"" . $pCargoEmpresaActualProceso . "\",\"" . $pEmpresaActualProceso . "\",\"" . $pNomSedeEmpresaActualProceso . "\",\"" . $pAntiguedadCargoActualProceso . "\",\""  . $pAntiguedadOficioProceso . "\",\"" . $pTipoExamenProceso . "\",\"" . $pEPSProceso . "\",\""  . $pPENSIONProceso . "\",\""  . $pARPProceso . "\",\""  . $pTipoVinculacionContratoProceso . "\",\"" . $pTurnoProceso . "\")";
            $qry = str_replace("null","",$qry1);
            //echo $qry;
            $gBaseDatos->conectar();
            @mysqli_query($gBaseDatos->ConexionID, $qry);
            $gBaseDatos->cerrar();
        }
        echo $CampoLlave[0];
    }else{
        echo "0";
    }
}

function AgendaManualInasistencia(){
    $pIdAgenda = isset($_REQUEST['pIdAgenda'])?$_REQUEST['pIdAgenda']:0;
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pMotivo = isset($_REQUEST['pMotivo']) ? utf8_encode(str_replace('"', '""',$_REQUEST['pMotivo'])):null;
    $pUsuario = isset($_REQUEST['pUsuario']) ? $_REQUEST['pUsuario']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_profesionales_agendamanual_inasistencia('" . $pIdAgenda . "','" . $pCAS . "',\"" . $pMotivo . "\",'" . $pUsuario . "')";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
        else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function AgendaManualCancelar(){
    $pIdAgenda = isset($_REQUEST['pIdAgenda'])?$_REQUEST['pIdAgenda']:0;
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pMotivo = isset($_REQUEST['pMotivo']) ? utf8_encode(str_replace('"', '""',$_REQUEST['pMotivo'])):null;
    $pUsuario = isset($_REQUEST['pUsuario']) ? $_REQUEST['pUsuario']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_profesionales_agendamanual_cancelar('" . $pIdAgenda . "','" . $pCAS . "',\"" . $pMotivo . "\",'" . $pUsuario . "')";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function AgendaManualListar(){
    $pPrestador = isset($_REQUEST['pPrestador'])?$_REQUEST['pPrestador']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $pFecha = isset($_REQUEST['pFecha'])?$_REQUEST['pFecha']:null;
    $pEstado = isset($_REQUEST['pEstado'])?$_REQUEST['pEstado']:'x';
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_profesionales_agendamanual_list('" . $pPrestador . "','"  . $pIPS . "','" . $pProfesional . "',\"" . $pFecha . "\",\"" . $pEstado . "\")";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = PonerAcentosHTML($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}

?>
