<?php

/*
* @category    Controlador Conceptos
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

require("../../../core/php/_database.php");
require("../../../core/php/php_functions.php");

$task = '';
if ( isset($_POST['task'])){
  $task = $_POST['task'];
}
switch($task){
    case "SEARCH_CONCEPTO_BARRAS":
        BuscarxCodigoBarras();
        break;
    case "LISTAR":
        Listar();
        break;
    case "LISTAR_MXSPYP":
        ListarMxSaludPyP();
        break;
    case "BUSCAR":
        Listar();
        break;
    case "LISTAR_ARCHIVOS_ANEXOS":
        ListarArchivosAnexos();
        break;
    case "INSERTAR":
        Insertar();
        break;
    case "INSERTAR_MXSPYP":
        InsertarMxSaludPyP();
        break;
    case "MODIFICAR":
        Modificar();
        break;
    case "MODIFICAR_MXSPYP":
        ModificarMxSaludPyP();
        break;
    case "LISTAR002":
        Listar002();
        break;
    case "INSERTAR002":
        Insertar002();
        break;
    case "MODIFICAR002":
        Modificar002();
        break;
    default:
        echo "{failure:true}";
        break;
}

function BuscarxCodigoBarras(){
    $pBarras = isset($_REQUEST['pBarras']) ? $_REQUEST['pBarras']:"NO APLICA";
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_conceptos_buscarxcodbarras(\"" . $pBarras . "\")";
    //echo $qry;
    $CampoLlave = explode("^",$gBaseDatos->jasonSP_arreglo2011($qry));
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    echo $CampoLlave[0] . '^' . $CampoLlave[1] . '^' . $CampoLlave[2] . '^' . $CampoLlave[3] . '^' . $CampoLlave[4] . '^' . $CampoLlave[5] . '^' . $CampoLlave[6];
}

function Listar002()
{
    // OR = ||
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $Descripcion = isset($_REQUEST['query']) ? $_REQUEST['query'] : null;
    $pTipoReg = isset($_REQUEST['pTipoReg']) ? $_REQUEST['pTipoReg'] :"Todos";
    $pClasificacion = isset($_REQUEST['pClasificacion']) ? $_REQUEST['pClasificacion'] :"Todos";
    $pTipoEstudio = isset($_REQUEST['pTipoEstudio']) ? $_REQUEST['pTipoEstudio'] :"Todos";
    if (is_null($Descripcion) || $Descripcion == "")
        $Descripcion = "Todos";
    $qry = 'CALL sp_conceptos_grid("' . $Descripcion . '","' . $pTipoReg . '","' . $pClasificacion . '","' . $pTipoEstudio . '")';
    $CampoLlave = explode("^",$gBaseDatos->jasonSP_arreglo2011($qry));
    $nbrows = $CampoLlave[0];
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    if($nbrows>0){
        $start = (integer) (isset($_POST['start']) ? $_POST['start'] : $_GET['start']);
        $end = (integer) (isset($_POST['limit']) ? $_POST['limit'] : $_GET['limit']);
        $qry = 'CALL sp_conceptos002_grid_limit("' . $Descripcion . '","' . $pTipoReg . '","' . $pClasificacion . '","' . $pTipoEstudio . '",\'' . $start . '\',\'' . $end . '\')';
        //echo $qry;
        $gBaseDatos = new ofiMySQLi();
        $gBaseDatos->conectar();
        $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
        while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
        {
            $nRow = $row;
            foreach($row as $key => $val)
            {
                //$nRow[$key] = utf8_decode($val);
                $nRow[$key] = PonerAcentosHTML($val);
            }
            $arr[] = $nRow;
        }
        $jsonresult = JEncode($arr);
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        echo '({success: true, requestedId:"1", "total":"'.$nbrows.'","results":'.$jsonresult.'})';
    } else {
        echo '({success: true, requestedId:"1", "total":"0", "results":""})';
    }
    
}

function Modificar002()
{
    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_conceptos002_update(" . spParametros($estructura,"SI") . ")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function Insertar002()
{
    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_conceptos002_insert(" . spParametros($estructura,"SI") . ")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function ModificarMxSaludPyP(){
    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_conceptosmxspyp_update(" . spParametros($estructura,"SI") . ")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function Modificar(){
    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_conceptos_update(" . spParametros($estructura,"SI") . ")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function InsertarMxSaludPyP(){
    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_conceptosmxspyp_insert(" . spParametros($estructura,"SI") . ")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function Insertar()
{
    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_conceptos_insert(" . spParametros($estructura,"SI") . ")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function ListarArchivosAnexos(){

    $directorio = opendir("c:\\eoficlinic\\formatoshc");
    while ($archivo = readdir($directorio)){
        if($archivo != "." && $archivo != ".." && substr($archivo,-3) == "rtf"){
            $nRow["Descripcion"] = $archivo;
            $arr[] = $nRow;
        }
    }
    $jsonresult = JEncode($arr);
    echo '({success: true, requestedId:"1", "total":"1","results":'.$jsonresult.'})';
}

function Listar(){
    // OR = ||
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $Descripcion = isset($_REQUEST['query']) ? $_REQUEST['query'] : null;
    $pTipoReg = isset($_REQUEST['pTipoReg']) ? $_REQUEST['pTipoReg'] :"Todos";
    $pClasificacion = isset($_REQUEST['pClasificacion']) ? $_REQUEST['pClasificacion'] :"Todos";
    $pTipoEstudio = isset($_REQUEST['pTipoEstudio']) ? $_REQUEST['pTipoEstudio'] :"Todos";
    if (is_null($Descripcion) || $Descripcion == "")
        $Descripcion = "Todos";
    $qry = 'CALL sp_conceptos_grid("' . $Descripcion . '","' . $pTipoReg . '","' . $pClasificacion . '","' . $pTipoEstudio . '")';
    $CampoLlave = explode("^",$gBaseDatos->jasonSP_arreglo2011($qry));
    $nbrows = $CampoLlave[0];
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    if($nbrows>0){
        $start = (integer) (isset($_POST['start']) ? $_POST['start'] : $_GET['start']);
        $end = (integer) (isset($_POST['limit']) ? $_POST['limit'] : $_GET['limit']);
        $qry = 'CALL sp_conceptos_grid_limit("' . $Descripcion . '","' . $pTipoReg . '","' . $pClasificacion . '","' . $pTipoEstudio . '",\'' . $start . '\',\'' . $end . '\')';
        //echo $qry;
        $gBaseDatos = new ofiMySQLi();
        $gBaseDatos->conectar();
        $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
        while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
        {
            $nRow = $row;
            foreach($row as $key => $val)
            {
                //$nRow[$key] = utf8_decode($val);
                $nRow[$key] = PonerAcentosHTML($val);
            }
            $arr[] = $nRow;
        }
        $jsonresult = JEncode($arr);
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        echo '({success: true, requestedId:"1", "total":"'.$nbrows.'","results":'.$jsonresult.'})';
    } else {
        echo '({success: true, requestedId:"1", "total":"0", "results":""})';
    }
}

function ListarMxSaludPyP(){
    // OR = ||
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $Descripcion = isset($_REQUEST['query']) ? $_REQUEST['query'] : null;
    $pTipoReg = isset($_REQUEST['pTipoReg']) ? $_REQUEST['pTipoReg'] :"Todos";
    $pClasificacion = isset($_REQUEST['pClasificacion']) ? $_REQUEST['pClasificacion'] :"Todos";
    $pTipoEstudio = isset($_REQUEST['pTipoEstudio']) ? $_REQUEST['pTipoEstudio'] :"Todos";
    if (is_null($Descripcion) || $Descripcion == "")
        $Descripcion = "Todos";
    $qry = 'CALL sp_conceptosmxspyp_grid("' . $Descripcion . '","' . $pTipoReg . '","' . $pClasificacion . '","' . $pTipoEstudio . '")';
    $CampoLlave = explode("^",$gBaseDatos->jasonSP_arreglo2011($qry));
    $nbrows = $CampoLlave[0];
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    if($nbrows>0){
        $start = (integer) (isset($_POST['start']) ? $_POST['start'] : $_GET['start']);
        $end = (integer) (isset($_POST['limit']) ? $_POST['limit'] : $_GET['limit']);
        $qry = 'CALL sp_conceptosmxspyp_grid_limit("' . $Descripcion . '","' . $pTipoReg . '","' . $pClasificacion . '","' . $pTipoEstudio . '",\'' . $start . '\',\'' . $end . '\')';
        //echo $qry;
        $gBaseDatos = new ofiMySQLi();
        $gBaseDatos->conectar();
        $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
        while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
        {
            $nRow = $row;
            foreach($row as $key => $val)
            {
                //$nRow[$key] = utf8_decode($val);
                $nRow[$key] = PonerAcentosHTML($val);
            }
            $arr[] = $nRow;
        }
        $jsonresult = JEncode($arr);
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        echo '({success: true, requestedId:"1", "total":"'.$nbrows.'","results":'.$jsonresult.'})';
    } else {
        echo '({success: true, requestedId:"1", "total":"0", "results":""})';
    }
}


?>
