<?php
    ini_set('memory_limit', '-1'); 
    require_once('../../../lib/tcpdf/config/lang/spa.php');
    require_once('../../../lib/tcpdf/tcpdf.php');
    require("../../../core/php/_database.php");
    require("../../../core/php/php_functions.php");
    require("../../../core/php/constantes.php");
    //header('Content-type: application/pdf; charset: UTF-8');
    
    session_start();
    //echo $_SESSION['EMPRESA_REG'];
    //Variables;
    $gBaseDatos = new ofiMySQLi();
    $pImprimeTirilla = pImprimeTirilla;
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:1;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pCliente = isset($_REQUEST['pCliente'])?$_REQUEST['pCliente']:0;
    $pFacturaDesde = isset($_REQUEST['pFacturaDesde'])?$_REQUEST['pFacturaDesde']:0;
    $pFacturaHasta = isset($_REQUEST['pFacturaHasta'])?$_REQUEST['pFacturaHasta']:0;
    $pMedicamentos = false;
    $pOtrosConceptos = false;
    //Definicion de las Margenes
    $LeftMargin = PDF_MARGIN_LEFT;
    $TopMargin = 5;
    $RightMargin = PDF_MARGIN_RIGHT;
    $HeaderMargin = PDF_MARGIN_HEADER;
    $BottomMargin = 3;
    $FooterMargin = 5;
    $Alineacion = "P";
    $FormatoPagina = "CARTA";
    $UsaPiePagina = "NO";
    $pControlSalto = 10;
    switch($pImprimeTirilla){
        case "SI":
            $Alineacion = "P";
            $FormatoPagina = "TIRILLA";
            $LeftMargin = 1;
            $TopMargin = 15; //Este Margen es para empezar nueva pagina
            $RightMargin = 1;
            $HeaderMargin = 0.5;
            $BottomMargin = 1;
            $FooterMargin = 3.5;
            $UsaPiePagina = "NO";
            $pTipoEncabezado = "MCT";
            break;
        
        default:
            $FormatoPagina = "CARTA";
            $Alineacion = "P";
            $UsaPiePagina = "NO";
            $pTipoEncabezado = "FVP";
            break;
    }
    //Inicializacion de la Clase
    $pdf = new TCPDF($Alineacion, PDF_UNIT, $FormatoPagina, true, 'UTF-8', false);
    //Inicializacion Variables de Control
    $pdf->SetCreator(PDF_CREATOR);
    $pdf->SetAuthor('Sistemas Ofisalud © - 2006');
    $pdf->SetTitle('FACTURA DE VENTA');
    $pdf->SetSubject('FACTURA POR PACIENTE');

    $pdf->SetHeaderData($pdf->pLogoCliente, PDF_HEADER_LOGO_WIDTH, $pdf->pTituloInforme, PDF_HEADER_STRING);
    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
    $pdf->SetMargins($LeftMargin, $TopMargin, $RightMargin);
    $pdf->SetHeaderMargin($HeaderMargin);
    $pdf->SetFooterMargin($FooterMargin);
    // set bacground image
    
    $pdf->SetAutoPageBreak(TRUE, $BottomMargin);
    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
    $pdf->setLanguageArray($l);
    $pdf->setFontSubsetting(true);
    $pdf->SetFont('dejavusans', '', 14, '', true);
    
    $gBaseDatos->conectar();
    $qry = "CALL sp_facturacion_print_bloquexpaciente('" . $pEmpresa . "','" . $pIPS . "','" . $pCliente . "','" . $pFacturaDesde . "','" . $pFacturaHasta . "')";
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    while ($itemsfac[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $pRegistrosItems = count($itemsfac);
    for($j=0;$j<($pRegistrosItems-1);$j++){
        $gBaseDatos->conectar();
        $qry = "CALL sp_facturacion_print_xpaciente('" . $itemsfac[$j]["idLegalizacion"] . "')";
        $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
        while ($row[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        $pRegistros = count($row);
        $pdf->pAlineacionEncabezado = $Alineacion;
        $pdf->pTituloInforme = "FACTURA DE VENTA";
        $pdf->pImprimeLogo = "NO";
        $pdf->pAnchoTxtPagina = 210;
        $pdf->pNomEmpresa = $_SESSION['NOM_EMPRESA'];
        $pdf->pTDocEmpresa = $_SESSION['EMPRESA_TDOC'];
        $pdf->pDocEmpresa = $_SESSION['EMPRESA_DOC'];
        $pdf->pDirEmpresa = $_SESSION['EMPRESA_DIR'];
        if($row[0]["IPSDireccion"] != "" && $row[0]["IPSDireccion"] != null){
            $pdf->pDirEmpresa = $row[0]["IPSDireccion"];
        }
        $pdf->pTelEmpresa = $_SESSION['EMPRESA_TEL'];
        if($row[0]["IPSTelefono"] != "" && $row[0]["IPSTelefono"] != null){
            $pdf->pTelEmpresa = $row[0]["IPSTelefono"];
        }
        $pdf->pCiuEmpresa = $_SESSION['EMPRESA_CIU'];
        if($row[0]["IPSMunicipio"] != "" && $row[0]["IPSMunicipio"] != null){
            $pdf->pCiuEmpresa = $row[0]["IPSMunicipio"] . " - " . $row[0]["IPSDepto"];
        }
        $pdf->pEspEmpresa = $_SESSION['EMPRESA_ESP'];
        $pdf->pRegEmpresa = $_SESSION['EMPRESA_REGIMEN'];
        $pdf->pContribuyentes = $_SESSION['EMPRESA_CONTRIBUYENTE'];
        $pdf->pReteIVA  = $_SESSION['EMPRESA_RTEICA'];
        $pdf->pReteICA = $_SESSION['EMPRESA_RTEIVA'];

        $pdf->pTipoEncabezado = $pTipoEncabezado;
        $pdf->pNomSede = $_SESSION['EMPRESA_DOC'];
        $pdf->pNomIPS = $_SESSION['NOM_IPS'];
        $pdf->pMargenPie = -20;
        $pdf->pLogoCliente = "../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/logoenc.gif";
        $pdf->pPrefijo = $row[0]["Prefijo"];
        $pdf->pNroDocumento = str_pad($row[0]["NroDocumento"], 7, "0", STR_PAD_LEFT);
        $pdf->pNroResolucion = $row[0]["NroResolucion"];
        $pdf->pFechaDoc = $row[0]["FechaDocumento"];
        $pdf->pFechaVenc = $row[0]["FechaVencimiento"];
        $pdf->pCAS = null;
        $pdf->pTratamiento = null;
        $pdf->pUsaPie = $UsaPiePagina;
        $pdf->pMargenPie = -20;
        switch($pImprimeTirilla){

            default:
                $pdf->AddPage();
                if ($pAnulada == 1){
                    $img_file = "../../../resources/varios/docanulado.png";
                    $pdf->Image($img_file, 110, 8, 80, 50, '', '', '', false, 300, '', false, false, 0);
                    $pdf->Image($img_file, 110, 215, 80, 50, '', '', '', false, 300, '', false, false, 0);
                }
                $pdf->Ln(2);
                $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
                $EncabezadoHTML = '<table cellspacing="0" border="0" style="font-size:24px; color:#000;">';
                $EncabezadoHTML .= '<tr><td></td><td height="5" style="font-size:14px; color:#000;" align="rigth">FACTURA POR COMPUTADOR</td></tr>';
                $EncabezadoHTML .= '<tr>';
                $EncabezadoHTML .= '<td>';
                $EncabezadoHTML .= '<span style="font-size:44px; color:#000; font-weight:bold">' . utf8_decode($pdf->pNomEmpresa) . '</span><br>';
                if($pdf->pEspEmpresa != null || $pdf->pEspEmpresa != "")
                        $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . utf8_decode($pdf->pEspEmpresa) . '</span><br>';
                if($pdf->pTDocEmpresa == "NI")
                    $tipodoc = "NIT: ";
                else
                    $tipodoc = $pdf->pTDocEmpresa . ": ";
                $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $tipodoc . $pdf->pDocEmpresa . '</span><br>';
                $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $pdf->pDirEmpresa . ' - ' . $pdf->pTelEmpresa . '</span><br>';
                $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $pdf->pCiuEmpresa . '</span><br>';
                $EncabezadoHTML .= '<span style="font-size:17px; color:#000; font-weight:bold">' . $pdf->pRegEmpresa . '</span><br>';
                $EncabezadoHTML .= '<span style="font-size:17px; color:#000; font-weight:bold">' . $pdf->pContribuyentes . '</span><br>';
                $EncabezadoHTML .= '<span style="font-size:17px; color:#000; font-weight:bold">' . $pdf->pReteIVA . '</span><br>';
                $EncabezadoHTML .= '<span style="font-size:16px; color:#000; font-weight:bold">' . $pdf->pReteICA . '</span><br>';
                $EncabezadoHTML .= '<span style="font-size:14px; color:#000; font-weight:bold">' . $_SESSION['IMPUESTO_CREE'] . '</span>';
                $EncabezadoHTML .= '</td>';

                //COL2
                $EncabezadoHTML .= '<td>';
                $EncabezadoHTML .= '<span align="rigth" style="font-size:44px; color:#000; font-weight:bold">FACTURA DE VENTA</span><br>';
                $EncabezadoHTML .= '<span align="rigth" style="font-size:40px; color:#000; font-weight:bold">Nro: ' . $pdf->pPrefijo . "-" . $pdf->pNroDocumento . '</span><br>';
                $EncabezadoHTML .= '<span align="rigth" style="font-size:24px; color:#000;">' . $pdf->pNroResolucion . '</span><br>';
                $EncabezadoHTML .= '<span align="rigth" style="font-size:40px; color:#000; font-weight:bold">Fecha Factura: ' . $pdf->pFechaDoc . '</span><br>';
                $EncabezadoHTML .= '<span align="rigth" style="font-size:30px; color:#000; font-weight:bold">Fecha Vencimiento: ' . $row[0]["FechaVencimiento"] . '</span><br>';
                $EncabezadoHTML .= '</td>';

                $EncabezadoHTML .= '</tr>';
                $EncabezadoHTML .= '</table>';
                $EncabezadoHTML .= '<hr>';
                $pdf->writeHTML($EncabezadoHTML, true, false, false, false, '');

                $pdf->SetFont(PDF_FONT_NAME_MAIN,'',10);
                // Cargar Datos del Cliente
                $pdf->writeHTMLCell(18, $rowcount, '', '', "Entidad:", 0, 0, 0, true, 'L', true);
                $InfoCliente = $row[0]["DocClie"];
                if ($row[0]["DigverClie"] != "" && $row[0]["DigverClie"] != null){
                    $InfoCliente .= "-" . $row[0]["DigverClie"];
                }
                $InfoCliente .= " " . $row[0]["NomClie"];
                $rowcount = $pdf->getNumLines(utf8_decode($InfoCliente), 78) * 3;
                $pdf->writeHTMLCell(178, $rowcount, '', '', utf8_decode($InfoCliente), 0, 0, 0, true, 'L', true);
                $pdf->Ln(4);
                $pdf->MultiCell(18,$rowcount,"Plan:",0,'L',0,0);
                $pdf->writeHTMLCell(78, $rowcount, '', '', utf8_decode($row[0]["Plan"]), 0, 0, 0, true, 'L', true);
                $pdf->MultiCell(18,$rowcount,"SubPlan:",0,'L',0,0);
                $pdf->writeHTMLCell(78, $rowcount, '', '', utf8_decode($row[0]["SubPlan"]), 0, 0, 0, true, 'L', true);
                $pdf->Ln(4);
                $pdf->MultiCell(18,$rowcount,"Dirección:",0,'L',0,0);
                $pdf->writeHTMLCell(78, $rowcount, '', '', utf8_decode($row[0]["DirClie"]), 0, 0, 0, true, 'L', true);
                $pdf->MultiCell(18,$rowcount,"Teléfono:",0,'L',0,0);
                $pdf->writeHTMLCell(78, $rowcount, '', '', utf8_decode($row[0]["TelClie"]), 0, 0, 0, true, 'L', true);
                $pdf->Ln(4);
                // Cargar Datos del Paciente
                $pdf->MultiCell(17,5,"Paciente:",0,'L',0,0);
                $rowcount = $pdf->getNumLines(utf8_decode($row[0]["TipDoc"]) . " " . utf8_decode($row[0]["Documento"]) .  " - " . utf8_decode($row[0]["PrimerNombre"]) . " " . utf8_decode($row[0]["SegundoNombre"]) . " " . utf8_decode($row[0]["PrimerApellido"]) . " " . utf8_decode($row[0]["SegundoApellido"]) . " -Genero:(" . utf8_decode($row[0]["Genero"]) . ")" . " -Edad:(" . utf8_decode($row[0]["Edad"]) . ")", 178) * 3;
                $pdf->writeHTMLCell(178, $rowcount, '', '', utf8_decode($row[0]["TipDoc"]) . " " . utf8_decode($row[0]["Documento"]) .  " - " . utf8_decode($row[0]["PrimerNombre"]) . " " . utf8_decode($row[0]["SegundoNombre"]) . " " . utf8_decode($row[0]["PrimerApellido"]) . " " . utf8_decode($row[0]["SegundoApellido"]) . " -Genero:(" . utf8_decode($row[0]["Genero"]) . ")" . " -Edad:(" . utf8_decode($row[0]["Edad"]) . ")", 0, 0, 0, true, 'L', true);
                $pdf->Ln(4);
                $rowcount = $pdf->getNumLines($row[0]["Direccion"], 70) * 3;
                $pdf->MultiCell(18,$rowcount,"Dirección:",0,'L',0,0);
                $pdf->writeHTMLCell(78, $rowcount, '', '', utf8_decode($row[0]["Direccion"]), 0, 0, 0, true, 'L', true);
                $pdf->MultiCell(18,$rowcount,"Teléfono:",0,'L',0,0);
                $pdf->writeHTMLCell(78, $rowcount, '', '', utf8_decode($row[0]["Telefono"]) . " - " . utf8_decode($row[0]["Telefono1"]), 0, 0, 0, true, 'L', true);
                $pdf->Ln($rowcount+4);


                $pdf->SetLineWidth(0.3); 
                $pdf->Line($pdf->GetX(), $pdf->GetY(), $pdf->GetX()+200, $pdf->GetY()); 
                $pdf->SetFont(PDF_FONT_NAME_MAIN,'B',11);
                //$pdf->MultiCell(200,5,"DETALLE",0,'C',0,0);
                $pdf->MultiCell(20,5,"CODIGO",0,'C',0,0);
                $pdf->MultiCell(75,5,"DESCRIPCION",0,'C',0,0);
                $pdf->MultiCell(10,5,"IVA",0,'R',0,0);
                $pdf->MultiCell(25,5,"CANTIDAD",0,'R',0,0);
                $pdf->MultiCell(32,5,"VLR UNITARIO",0,'R',0,0);
                $pdf->MultiCell(32,5,"VLR TOTAL",0,'R',0,0);
                $pdf->Ln(5);
                $pdf->SetLineWidth(0.3); 
                $pdf->Line($pdf->GetX(), $pdf->GetY(), $pdf->GetX()+200, $pdf->GetY()); 
                $pdf->Ln(1);

                $img_file = "../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/fondofac.png";
                $pdf->Image($img_file, $pdf->GetX()+60, $pdf->GetY()+35, 90, 50, '', '', '', false, 300, '', false, false, 0);

                $pdf->SetFont(PDF_FONT_NAME_MAIN,'',10);
                $pVlrTotal = 0;
                $pVlrIVA = 0;
                $pVlrCopagos = 0;
                $pVlrDescuentos = 0;
                $pVlrNeto = 0;
                for($i=0;$i<$pRegistros;$i++)
                {
                    if($row[$i]["TipoRegistro"] == "3" && !$pMedicamentos){
                        $pMedicamentos = true;
                    }
                    if($row[$i]["TipoRegistro"] == "4" && !$pOtrosConceptos){
                        $pOtrosConceptos = true;
                    }
                }
                // Cargar Detalle CONSULTAS + PROCEDIMIENTOS
                for($i=0;$i<$pRegistros;$i++)
                {
                    if($row[$i]["CantidadItem"] == null || $row[$i]["CantidadItem"] == 0){
                        $CantidadItem = 1;
                    }else{
                        $CantidadItem = $row[$i]["CantidadItem"];
                    }
                    if($row[$i]["TipoRegistro"] < 3){
                        if($row[$i]["DescProcedimiento"] != ""){
                            if($row[$i]["VlrTotalItem"] != 0){
                                $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
                                $rowcount = 0;
                                $rowcount = $pdf->getNumLines(utf8_decode($row[$i]["DescProcedimiento"]), 75) * 3;
                                $pdf->writeHTMLCell(20, $rowcount, '', '', utf8_decode($row[$i]["CUPSCodigo"]), 0, 0, 0, true, 'L', true);
                                $pdf->writeHTMLCell(75, $rowcount, '', '', utf8_decode($row[$i]["DescProcedimiento"]), 0, 0, 0, true, 'L', true);
                                $pdf->writeHTMLCell(10, $rowcount, '', '', number_format($row[$i]["VlrIVAItem"],0,".",","), 0, 0, 0, true, 'C', true);
                                $pdf->writeHTMLCell(25, $rowcount, '', '', number_format($row[$i]["CantidadItem"],0,".",","), 0, 0, 0, true, 'R', true);
                                $pdf->writeHTMLCell(32, $rowcount, '', '', number_format(($row[$i]["VlrTotalItem"]/$CantidadItem),2,".",","), 0, 0, 0, true, 'R', true);
                                $pdf->writeHTMLCell(32, $rowcount, '', '', number_format($row[$i]["VlrTotalItem"],2,".",","), 0, 0, 0, true, 'R', true);
                                $pdf->Ln($rowcount+2);
                                if($pdf->GetY() >= ($pdf->getPageHeight()-$ControlSalto))
                                {
                                    ImprimeEncabezadoFactura($pdf);
                                }
                            }
                            $pVlrTotal += $row[$i]["VlrTotalItem"];
                            $pVlrIVA += $row[$i]["VlrIVAItem"];
                            $pVlrCopagos += $row[$i]["VlrCuotaModeradoraItem"] + $row[$i]["VlrCopagosItem"];
                            $pVlrDescuentos += $row[$i]["VlrDescuentosItem"];
                            $pVlrNeto += $row[$i]["VlrNetoItem"];
                        }
                    }
                }
                //$pdf->Ln($rowcount);
                // Cargar Detalle MEDICAMENTOS
                if($pMedicamentos){
                    $pdf->SetFont(PDF_FONT_NAME_MAIN,'B',10);
                    $pdf->MultiCell(190,5,"MEDICAMENTOS",0,'C',0,0);
                    $pdf->Ln(5);
                    $pdf->SetFont(PDF_FONT_NAME_MAIN,'',10);
                    for($i=0;$i<$pRegistros;$i++)
                    {
                        if($row[$i]["CantidadItem"] == null || $row[$i]["CantidadItem"] == 0){
                            $CantidadItem = 1;
                        }else{
                            $CantidadItem = $row[$i]["CantidadItem"];
                        }
                        if($row[$i]["TipoRegistro"] == "3"){
                            if($row[$i]["DescProcedimiento"] != ""){
                                if($row[$i]["VlrTotal"] != 0){
                                    $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
                                    $rowcount = 0;
                                    $rowcount = $pdf->getNumLines(utf8_decode($row[$i]["DescProcedimiento"]), 75) * 3;
                                    $pdf->writeHTMLCell(20, $rowcount, '', '', utf8_decode($row[$i]["CUPSCodigo"]), 0, 0, 0, true, 'L', true);
                                    $pdf->writeHTMLCell(75, $rowcount, '', '', utf8_decode($row[$i]["DescProcedimiento"]), 0, 0, 0, true, 'L', true);
                                    $pdf->writeHTMLCell(10, $rowcount, '', '', number_format($row[$i]["VlrIVAItem"],0,".",","), 0, 0, 0, true, 'C', true);
                                    $pdf->writeHTMLCell(25, $rowcount, '', '', number_format($row[$i]["CantidadItem"],0,".",","), 0, 0, 0, true, 'R', true);
                                    $pdf->writeHTMLCell(32, $rowcount, '', '', number_format(($row[$i]["VlrTotalItem"]/$CantidadItem),2,".",","), 0, 0, 0, true, 'R', true);
                                    $pdf->writeHTMLCell(32, $rowcount, '', '', number_format($row[$i]["VlrTotalItem"],2,".",","), 0, 0, 0, true, 'R', true);
                                    $pdf->Ln($rowcount+2);
                                    if($pdf->GetY() >= ($pdf->getPageHeight()-$ControlSalto))
                                    {
                                        ImprimeEncabezadoFactura($pdf);
                                    }
                                }
                                $pVlrTotal += $row[$i]["VlrTotalItem"];
                                $pVlrIVA += $row[$i]["VlrIVAItem"];
                                $pVlrCopagos += $row[$i]["VlrCuotaModeradoraItem"] + $row[$i]["VlrCopagosItem"];
                                $pVlrDescuentos += $row[$i]["VlrDescuentosItem"];
                                $pVlrNeto += $row[$i]["VlrNetoItem"];
                            }
                        }
                    }
                }
                // Cargar Detalle OTROS CONCEPTOS
                if($pOtrosConceptos){
                    $pdf->SetFont(PDF_FONT_NAME_MAIN,'B',10);
                    $pdf->MultiCell(190,5,"OTROS CONCEPTOS",0,'C',0,0);
                    $pdf->Ln(5);
                    $pdf->SetFont(PDF_FONT_NAME_MAIN,'',10);
                    for($i=0;$i<$pRegistros;$i++)
                    {
                        if($row[$i]["CantidadItem"] == null || $row[$i]["CantidadItem"] == 0){
                            $CantidadItem = 1;
                        }else{
                            $CantidadItem = $row[$i]["CantidadItem"];
                        }
                        if($row[$i]["TipoRegistro"] == "4"){
                            if($row[$i]["DescProcedimiento"] != ""){
                                if($row[$i]["VlrTotal"] != 0){
                                    $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
                                    $rowcount = 0;
                                    $rowcount = $pdf->getNumLines(utf8_decode($row[$i]["DescProcedimiento"]), 75) * 3;
                                    $pdf->writeHTMLCell(20, $rowcount, '', '', utf8_decode($row[$i]["CUPSCodigo"]), 0, 0, 0, true, 'L', true);
                                    $pdf->writeHTMLCell(75, $rowcount, '', '', utf8_decode($row[$i]["DescProcedimiento"]), 0, 0, 0, true, 'L', true);
                                    $pdf->writeHTMLCell(10, $rowcount, '', '', number_format($row[$i]["VlrIVAItem"],0,".",","), 0, 0, 0, true, 'C', true);
                                    $pdf->writeHTMLCell(25, $rowcount, '', '', number_format($row[$i]["CantidadItem"],0,".",","), 0, 0, 0, true, 'R', true);
                                    $pdf->writeHTMLCell(32, $rowcount, '', '', number_format(($row[$i]["VlrTotalItem"]/$CantidadItem),2,".",","), 0, 0, 0, true, 'R', true);
                                    $pdf->writeHTMLCell(32, $rowcount, '', '', number_format($row[$i]["VlrTotalItem"],2,".",","), 0, 0, 0, true, 'R', true);
                                    $pdf->Ln($rowcount+2);
                                    if($pdf->GetY() >= ($pdf->getPageHeight()-$ControlSalto))
                                    {
                                        ImprimeEncabezadoFactura($pdf);
                                    }
                                }
                                $pVlrTotal += $row[$i]["VlrTotalItem"];
                                $pVlrIVA += $row[$i]["VlrIVAItem"];
                                $pVlrCopagos += $row[$i]["VlrCuotaModeradoraItem"] + $row[$i]["VlrCopagosItem"];
                                $pVlrDescuentos += $row[$i]["VlrDescuentosItem"];
                                $pVlrNeto += $row[$i]["VlrNetoItem"];
                            }
                        }
                    }
                }
                $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
                $pdf->Ln($rowcount+2);
                $rowcount = 0;
                if($row[0]["Concepto"] != "" && $row[0]["Concepto"] != null){
                    $rowcount = $pdf->getNumLines("NOTAS OBSERVACIONES A LA FACTURA: " . utf8_decode($row[0]["Concepto"]), 190) * 3;
                    $pdf->MultiCell(190,$rowcount,"Notas - Observaciones a la Factura: " . utf8_decode($row[0]["Concepto"]),0,'L',0,0);
                    $pdf->Ln($rowcount+2);
                }
                if($row[0]["NroAutorizacion"]!="" && $row[0]["NroAutorizacion"] != null && $row[0]["NroAutorizacion"] != 0 && $row[0]["NroAutorizacion"] != "0" && $row[0]["NroAutorizacion"] != "na" && $row[0]["NroAutorizacion"] != "NA"){ 
                    $pdf->MultiCell(190,$rowcount,"Nro Autorizacion: " . utf8_decode($row[0]["NroAutorizacion"]),0,'L',0,0);
                }
                $pdf->Ln($rowcount+5);
                //$pdf->MultiCell(190,$rowcount,"FIRMA DEL PACIENTE",0,'L',0,0);
                while ($pdf->GetY() <= ($pdf->getPageHeight()-65)) {
                    $pdf->Ln();
                }
                $pdf->Ln();
                $val = strtoupper(utf8_decode(numerotexto($pVlrNeto)));
                $EncabezadoHTML = '
                <table border="1" cellspacing="0" >
                    <tr>
                        <td width="490">&nbsp;<br>&nbsp;SON: '. $val . ' PESOS M/CTE.</td>
                        <td width="210">
                            <table border="0" cellspacing="0">
                                <tr>
                                    <td width="100">TOTAL:</td>
                                    <td width="100" align="rigth">$ ' . number_format($pVlrTotal,2,".",",") . '</td>
                                </tr>
                                <tr>
                                    <td>IVA:</td>
                                    <td width="100" align="rigth">$ ' . number_format($pVlrIVA,2,".",",") . '</td>
                                </tr>
                                <tr>
                                    <td>COPAGOS:</td>
                                    <td width="100" align="rigth">$ ' . number_format($pVlrCopagos,2,".",",") . '</td>
                                </tr>
                                <tr>
                                    <td>DESCUENTOS:</td>
                                    <td width="100" align="rigth">$ ' . number_format($pVlrDescuentos,2,".",",") . '</td>
                                </tr>
                                <tr>
                                    <td>NETO:</td>
                                    <td width="100" align="rigth">$ ' . number_format($pVlrNeto,2,".",",") . '</td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="2">
                            <table border="0" cellspacing="0">
                                <tr>
                                    <td width="525">
                                        <span style="font-size:29px; color:#000;">
                                        AUTORIZADO A RECIBIR ESTA FACTURA
                                        </span><br><br>
                                        <span style="font-size:24px; color:#000;">
                                        NOMBRES Y APELLIDOS:&nbsp;&nbsp;__________________________________________________
                                        </span><br>
                                        <span style="font-size:24px; color:#000;">
                                        Nro. IDENTIFICACION:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;__________________________________________________
                                        </span><br>
                                        <span style="font-size:24px; color:#000;">
                                        FECHA DE RECIBIDO:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;__________________________________________________
                                        </span><br><br>
                                        <span style="font-size:24px; color:#000;">
                                        FIRMA Y SELLO
                                        </span>
                                    </td>
                                    <td width="160" align="rigth">
                                        <span style="font-size:25px; color:#000;">DESCUENTO PIE FACTURA PRONTO PAGO %_____</span><br><br>
                                        <span style="font-size:25px; color:#000;">
                                        '. $_SESSION['NOM_SEDE'] . '<br>
                                        '. $_SESSION['NOM_IPS'] . '<br>
                                        Usuario: '. strtoupper($row[0]["UsuarioFactura"]) . '<br>
                                        CAS: '. $row[0]["CAS"] . '
                                        </span><br><br>
                                        <span style="font-size:16px; color:#000;">
                                        SOFTWARE OFICLINIC© 2006<br>JORGE GALEANO RUIZ NIT. 79.558.261-9 - Tel. 3005703911
                                        </span>
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                </table>
                <span style="font-size:18px; color:#000;">ESTA FACTURA DE VENTA SE ASIMILA PARA TODOS SUS EFECTOS A LA LETRA DE CAMBIO ART. 779 DEL CODIGO DE COMERCIO Y ARTICLULO 5 LEY 
    1231 DE 2008. SE CAUSARA INTERES DE MORA POR CADA DIA DE LA TASA DEL (  ) MENSUAL SIN PERJUICIO DE LA ACCION LEGAL POR INCUMPLIMIENTO DE PAGO
                </span>';
                $pdf->writeHTML($EncabezadoHTML, true, false, false, false, '');
                break;
        }
        unset($row);
    }    
    $pdf->Output('infBloqueFacturaVentaxPaciente.pdf', 'I');

    function ImprimeEncabezadoFactura(&$pdf){
        $pdf->AddPage();
        $pdf->Ln(2);
        $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
        $EncabezadoHTML = '<table cellspacing="0" border="0" style="font-size:24px; color:#000;">';
        $EncabezadoHTML .= '<tr><td></td><td height="5" style="font-size:14px; color:#000;" align="rigth">FACTURA POR COMPUTADOR</td></tr>';
        $EncabezadoHTML .= '<tr>';
        $EncabezadoHTML .= '<td>';
        $EncabezadoHTML .= '<span style="font-size:44px; color:#000; font-weight:bold">' . utf8_decode($pdf->pNomEmpresa) . '</span><br>';
        if($pdf->pEspEmpresa != null || $pdf->pEspEmpresa != "")
                $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . utf8_decode($pdf->pEspEmpresa) . '</span><br>';
        if($pdf->pTDocEmpresa == "NI")
            $tipodoc = "NIT: ";
        else
            $tipodoc = $pdf->pTDocEmpresa . ": ";
        $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $tipodoc . $pdf->pDocEmpresa . '</span><br>';
        $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $pdf->pDirEmpresa . ' - ' . $pdf->pTelEmpresa . '</span><br>';
        $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $pdf->pCiuEmpresa . '</span><br>';
        $EncabezadoHTML .= '<span style="font-size:17px; color:#000; font-weight:bold">' . $pdf->pRegEmpresa . '</span><br>';
        $EncabezadoHTML .= '<span style="font-size:17px; color:#000; font-weight:bold">' . $pdf->pContribuyentes . '</span><br>';
        $EncabezadoHTML .= '<span style="font-size:17px; color:#000; font-weight:bold">' . $pdf->pReteIVA . '</span><br>';
        $EncabezadoHTML .= '<span style="font-size:16px; color:#000; font-weight:bold">' . $pdf->pReteICA . '</span>';
        $EncabezadoHTML .= '<span style="font-size:14px; color:#000; font-weight:bold">' . $_SESSION['IMPUESTO_CREE'] . '</span>';
        $EncabezadoHTML .= '</td>';

        //COL2
        $EncabezadoHTML .= '<td>';
        $EncabezadoHTML .= '<span align="rigth" style="font-size:44px; color:#000; font-weight:bold">FACTURA DE VENTA</span><br>';
        $EncabezadoHTML .= '<span align="rigth" style="font-size:40px; color:#000; font-weight:bold">Nro: ' . $pdf->pPrefijo . "-" . $pdf->pNroDocumento . '</span><br>';
        $EncabezadoHTML .= '<span align="rigth" style="font-size:40px; color:#000; font-weight:bold">Fecha: ' . $pdf->pFechaDoc . '</span><br>';
        $EncabezadoHTML .= '<span align="rigth" style="font-size:24px; color:#000;">' . $pdf->pNroResolucion . '</span><br>';
        $EncabezadoHTML .= '<span align="rigth" style="font-size:30px; color:#000; font-weight:bold">Fecha Vencimiento: ' . $pdf->pFechaVenc . '</span><br>';
        $EncabezadoHTML .= '</td>';

        $EncabezadoHTML .= '</tr>';
        $EncabezadoHTML .= '</table>';
        $EncabezadoHTML .= '<hr>';
        $pdf->writeHTML($EncabezadoHTML, true, false, false, false, '');
        $pdf->SetFont(PDF_FONT_NAME_MAIN,'B',11);
        //$pdf->MultiCell(200,5,"DETALLE",0,'C',0,0);
        $pdf->MultiCell(20,5,"CODIGO",0,'C',0,0);
        $pdf->MultiCell(75,5,"DESCRIPCION",0,'C',0,0);
        $pdf->MultiCell(10,5,"IVA",0,'R',0,0);
        $pdf->MultiCell(25,5,"CANTIDAD",0,'R',0,0);
        $pdf->MultiCell(32,5,"VLR UNITARIO",0,'R',0,0);
        $pdf->MultiCell(32,5,"VLR TOTAL",0,'R',0,0);
        $pdf->Ln(5);
        $pdf->SetLineWidth(0.3); 
        $pdf->Line($pdf->GetX(), $pdf->GetY(), $pdf->GetX()+200, $pdf->GetY()); 
        $pdf->Ln(1);
        $img_file = "../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/fondofac.png";
        $pdf->Image($img_file, $pdf->GetX()+60, $pdf->GetY()+35, 90, 50, '', '', '', false, 300, '', false, false, 0);
    }
    
?>
