<?php
    ini_set('memory_limit', '-1'); 
    require_once('../../../lib/tcpdf/config/lang/spa.php');
    require_once('../../../lib/tcpdf/tcpdf.php');
    require("../../../core/php/_database.php");
    require("../../../core/php/php_functions.php");
    header('Content-type: application/pdf; charset: UTF-8');
    
    $pImprimeTirilla = "NO";
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:1;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pUsuario =  isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    if($pPaciente == null || $pPaciente == "")
        $pPaciente = 0;
    $pProcedimiento = isset($_REQUEST['pProcedimiento'])?$_REQUEST['pProcedimiento']:0;
    if($pProcedimiento == null || $pProcedimiento == "")
        $pProcedimiento = 0;
    $pCliente = isset($_REQUEST['pCliente'])?$_REQUEST['pCliente']:0;
    $pPlan = isset($_REQUEST['pPlan'])?$_REQUEST['pPlan']:0;
    if($pPlan == null || $pPlan == "")
        $pPlan = 0;
    $pSubplan = isset($_REQUEST['pSubplan'])?$_REQUEST['pSubplan']:0;
    if($pSubplan == null || $pSubplan == "")
        $pSubplan = 0;
    $pContrato =  isset($_REQUEST['pContrato'])?$_REQUEST['pContrato']:0;
    $pTipoEstudio = isset($_REQUEST['pTipoEstudio'])?$_REQUEST['pTipoEstudio']:0;
    if($pTipoEstudio == null || $pTipoEstudio == "")
        $pTipoEstudio = 0;
    $pCampo1 = isset($_REQUEST['pCampo1'])?$_REQUEST['pCampo1']:"NO";
    if($pCampo1 == null || $pCampo1 == "")
        $pCampo1 = "NO";
    $pCampo2 = isset($_REQUEST['pCampo2'])?$_REQUEST['pCampo2']:"NO";
    if($pCampo2 == null || $pCampo2 == "")
        $pCampo2 = "NO";
    $pCampo3 = isset($_REQUEST['pCampo3'])?$_REQUEST['pCampo2']:"NO";
    if($pCampo3 == null || $pCampo3 == "")
        $pCampo3 = "NO";
    $pDesde = isset($_REQUEST['pDesde'])?$_REQUEST['pDesde']:null;
    if($pDesde == null || $pDesde == "")
        $pDesde = null;
    $pHasta = isset($_REQUEST['pHasta'])?$_REQUEST['pHasta']:null;
    if($pHasta == null || $pHasta == "")
        $pHasta = null;
    $pNroPacientes= isset($_REQUEST['pNroPacientes'])?$_REQUEST['pNroPacientes']:0;
    $pPorFechaEstudio = isset($_REQUEST['pPorFechaEstudio'])?$_REQUEST['pPorFechaEstudio']:"NO";
    $pCapitacion = isset($_REQUEST['pCapitacion'])?$_REQUEST['pCapitacion']:"NO";
    $pVlrUPC = isset($_REQUEST['pVlrUPC'])?$_REQUEST['pVlrUPC']:0;
    $pAfiliados = isset($_REQUEST['pAfiliados'])?$_REQUEST['pAfiliados']:0;
    $pVlrTotalCapita = isset($_REQUEST['pVlrTotalCapita'])?$_REQUEST['pVlrTotalCapita']:0;
    $pCopagosCapita = isset($_REQUEST['pCopagosCapit'])?$_REQUEST['pCopagosCapit']:0;
    $pNetoCapita = isset($_REQUEST['pNetoCapita'])?$_REQUEST['pNetoCapita']:0;
    $pConceptoFactura = isset($_REQUEST['pConceptoFactura'])?$_REQUEST['pConceptoFactura']:null;
    if($pConceptoFactura == null || $pConceptoFactura == "")
        $pConceptoFactura = null;
    $pAnulada = isset($_REQUEST['pAnulada'])?$_REQUEST['pAnulada']:0;
    $pAutorizacion = "Todos";  
    
    // create new PDF document
    $pdf = new TCPDF("L", PDF_UNIT, "CARTA", true, 'UTF-8', false);
    // set document information
    $pdf->SetCreator(PDF_CREATOR);
    $pdf->SetAuthor('Sistemas Ofisalud © - 2006');
    $pdf->SetTitle('AUDITORIA');
    $pdf->SetSubject('Informe Detallado Prefactura');

    // set default header data
    session_start();
    $pdf->pAlineacionEncabezado = "L";
    $pdf->pTituloInforme = "INFORME DETALLADO PREFACTURA";
    $pdf->pImprimeLogo = "NO";
    $pdf->pAnchoTxtPagina = 270;
    $pdf->pNomEmpresa = $_SESSION['NOM_EMPRESA'];
    $pdf->pNomSede = $_SESSION['NOM_SEDE'];
    $pdf->pNomIPS = $_SESSION['NOM_IPS'];
    $pdf->pMargenPie = -20;
    //$pdf->pLogoCliente = "../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/logoenc.gif";
    if($_SESSION['IdAplicacion'] == "OfiMedical"){
        $pdf->pLogoCliente = "../../../consultoriovirtual/" . $_SESSION['IDBD'] . "/logo/logoenc.gif";
    }else{
        $pdf->pLogoCliente = "../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/logoenc.gif";
    }

    $pdf->SetHeaderData($pdf->pLogoCliente, PDF_HEADER_LOGO_WIDTH, $pdf->pTituloInforme, PDF_HEADER_STRING);
    // set header and footer fonts
    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
    // set default monospaced font
    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
    //set margins
    $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
    $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
    $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
    //set auto page breaks
    $pdf->SetAutoPageBreak(FALSE, PDF_MARGIN_BOTTOM);
    //set image scale factor
    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
    //set some language-dependent strings
    $pdf->setLanguageArray($l);
    // set default font subsetting mode
    $pdf->setFontSubsetting(true);
    $pdf->SetFont('dejavusans', '', 14, '', true);

    $idCliente = "-1";
    $idPlan = "-1";
    $idSubPlan = "-1";
    $totSubTotal = 0;
    $totIVA = 0;
    $totCopagos = 0;
    $totDescuentos = 0;
    $totNeto = 0;
    $totSubTotal_c = 0;
    $totIVA_c = 0;
    $totCopagos_c = 0;
    $totDescuentos_c = 0;
    $totNeto_c = 0;
    $totSubTotal_p = 0;
    $totIVA_p = 0;
    $totCopagos_p = 0;
    $totDescuentos_p = 0;
    $totNeto_p = 0;
    $totSubTotal_s = 0;
    $totIVA_s = 0;
    $totCopagos_s = 0;
    $totDescuentos_s = 0;
    $totNeto_s = 0;
    $contador = 0;
    $pImprimePieCliente = "No";
    $pImprimePiePlan = "No";
    $pImprimePieSubPlan = "No";
    $pUltimoRegistro = "No";
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_facturacion_prefa_detalle('" . $pEmpresa . "','" . $pIPS . "','" . $pCliente . "','" . $pPlan . "','" . $pSubplan . "','" . $pContrato . "','" . $pPaciente . "',\"" . $pAutorizacion . "\",\"" . $pPorFechaEstudio . "\",\"" . $pDesde . "\",\"" . $pHasta . "\",'" . $pProcedimiento . "','" . $pTipoEstudio . "',\"" . $pCampo1 . "\",\"" . $pCampo2 . "\",\"" . $pCampo3 . "\")";
    unset($row);
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    while ($row[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
    $pRegistros = count($row)-1;
    $gBaseDatos->liberar(); 
    $gBaseDatos->cerrar();
    for($i=0;$i<$pRegistros;$i++)
    {
        if($row[$i]["DesCliente"] != ""){
            if ($idCliente != $row[$i]["DesCliente"])
            {
                $totSubTotal_c = 0;
                $totIVA_c = 0;
                $totCopagos_c = 0;
                $totDescuentos_c = 0;
                $totNeto_c = 0;
                $idPlan = "-1";
                $idSubPlan = "-1";
                $pImprimePieCliente = "No";
                $pImprimePiePlan = "No";
                $pImprimePieSubPlan = "No";
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                
            }
            if ($idPlan != $row[$i]["DesPlan"])
            {
                $idSubPlan = "-1";
                $totSubTotal_p = 0;
                $totIVA_p = 0;
                $totCopagos_p = 0;
                $totDescuentos_p = 0;
                $totNeto_p = 0;
            }
            if ($idSubPlan != $row[$i]["DesSubPlan"])
            {
                $totSubTotal_s = 0;
                $totIVA_s = 0;
                $totCopagos_s = 0;
                $totDescuentos_s = 0;
                $totNeto_s = 0;
                $contador = 0;
            }
            $contador ++;
            $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
            $nomPaciente = $row[$i]["Documento"] . " - " . $row[$i]["Nom1"] . " " . $row[$i]["Nom2"] . " " . $row[$i]["Ape1"] . " " . $row[$i]["Ape2"];
            $rowcount = max($pdf->getNumLines(utf8_decode($nomPaciente), 45),$pdf->getNumLines(utf8_decode($row[$i]["CodProcedimiento"]) . "-" . utf8_decode($row[$i]["DescProcedimiento"]), 45))*4;
            EscribeDetalle($pdf, $row, $i, $rowcount, $contador);
            
            $idCliente = $row[$i]["DesCliente"];
            $idPlan = $row[$i]["DesPlan"];
            $idSubPlan = $row[$i]["DesSubPlan"];
            
            $totSubTotal += $row[$i]["VlrTotal"];
            $totIVA += $row[$i]["VlrIVA"];
            $totCopagos += ($row[$i]["VlrCuotaModeradora"]+$row[$i]["VlrCopagos"]);
            $totDescuentos += $row[$i]["VlrDescuentos"];
            $totNeto += $row[$i]["VlrNeto"];

            $totSubTotal_c += $row[$i]["VlrTotal"];
            $totIVA_c += $row[$i]["VlrIVA"];
            $totCopagos_c += ($row[$i]["VlrCuotaModeradora"]+$row[$i]["VlrCopagos"]);
            $totDescuentos_c += $row[$i]["VlrDescuentos"];
            $totNeto_c += $row[$i]["VlrNeto"];
            
            $totSubTotal_p += $row[$i]["VlrTotal"];
            $totIVA_p += $row[$i]["VlrIVA"];
            $totCopagos_p += ($row[$i]["VlrCuotaModeradora"]+$row[$i]["VlrCopagos"]);
            $totDescuentos_p += $row[$i]["VlrDescuentos"];
            $totNeto_p += $row[$i]["VlrNeto"];
            
            $totSubTotal_s += $row[$i]["VlrTotal"];
            $totIVA_s += $row[$i]["VlrIVA"];
            $totCopagos_s += ($row[$i]["VlrCuotaModeradora"]+$row[$i]["VlrCopagos"]);
            $totDescuentos_s += $row[$i]["VlrDescuentos"];
            $totNeto_s += $row[$i]["VlrNeto"];
            $pUltimoRegistro = "No";
            if($row[$i+1]["DesCliente"] == $idCliente){
                $pImprimePieCliente = "No";
                if ($row[$i+1]["DesPlan"] != $idPlan)
                    $pImprimePiePlan = "Si";
                else
                    $pImprimePiePlan = "No";
                if ($row[$i+1]["DesSubPlan"] != $idSubPlan)
                    $pImprimePieSubPlan = "Si";
                else
                    $pImprimePieSubPlan = "No";
            }else{
                $pImprimePieCliente = "Si";
                $pImprimePiePlan = "Si";
                $pImprimePieSubPlan = "Si";
                $pUltimoRegistro = "Si";
            }
            if (($pdf->GetY()+$rowcount) > 195)
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            if ($pImprimePieSubPlan == "Si")
            {
                if ($pdf->GetY() > 170)
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                PieGrupo($pdf, $row, $i, $totSubTotal_s, $totIVA_s, $totCopagos_s, $totDescuentos_s, $totNeto_s, "SUBPLAN", "DesSubPlan");
                $pImprimePieSubPlan = "No";
                if($pUltimoRegistro == "No"){
                    $indice = $i+1;
                    EncabezadoGrupo($pdf, $row, $indice, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
                
            if ($pImprimePiePlan == "Si")
            {
                if ($pdf->GetY() > 170)
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                PieGrupo($pdf, $row, $i, $totSubTotal_p, $totIVA_p, $totCopagos_p, $totDescuentos_p, $totNeto_p, "PLAN", "DesPlan");
                $pImprimePiePlan = "No";
                if($pUltimoRegistro == "No"){
                    $indice = $i+1;
                    EncabezadoGrupo($pdf, $row, $indice, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            
            if ($pImprimePieCliente == "Si")
            {
                if ($pdf->GetY() > 170)
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                PieGrupo($pdf, $row, $i, $totSubTotal_c, $totIV_c, $totCopagos_c, $totDescuentos_c, $totNeto_c, "CLIENTE", "DesCliente");
                $pImprimePieCliente = "No";
                if($pUltimoRegistro == "No"){
                    $indice = $i+1;
                    EncabezadoGrupo($pdf, $row, $indice, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
        }
    }
    $pdf->Output('infDetalladoPrefactura.pdf', 'I');

    function EncabezadoPagina(&$pdf, &$row, &$i, &$rowcount, &$contador, &$pDesde, &$pHasta){
        $pdf->AddPage();
        $pdf->SetFont(PDF_FONT_NAME_MAIN,'B',11);
        $pdf->MultiCell(264,10,"Periodo: " . $pDesde . " - " . $pHasta ,0,'L',0,0);
        $pdf->Ln(8.5);
        $pdf->SetFillColor(242 , 236, 236);
        $pdf->MultiCell(264,10,"CLIENTE: " . $row[$i]["DesCliente"],0,'L',0,0);
        $pdf->Ln(4.5);
        $pdf->MultiCell(264,10,"PLAN: " . $row[$i]["DesPlan"],0,'L',0,0);
        $pdf->Ln(4.5);
        $pdf->MultiCell(264,10,"SUBPLAN: " . $row[$i]["DesSubPlan"],0,'L',0,0);
        EncabezadoColumnas($pdf);
    }
    
    function EncabezadoGrupo(&$pdf, &$row, &$indice, &$rowcount, &$contador, &$pDesde, &$pHasta){
        $pdf->Ln(8.5);
        $pdf->SetFillColor(242 , 236, 236);
        $pdf->SetFont(PDF_FONT_NAME_MAIN,'B',11);
        $pdf->MultiCell(264,10,"CLIENTE: " . $row[$indice]["DesCliente"],0,'L',0,0);
        $pdf->Ln(4.5);
        $pdf->MultiCell(264,10,"PLAN: " . $row[$indice]["DesPlan"],0,'L',0,0);
        $pdf->Ln(4.5);
        $pdf->MultiCell(264,10,"SUBPLAN: " . $row[$indice]["DesSubPlan"],0,'L',0,0);
        EncabezadoColumnas($pdf);
    }
    
    function EncabezadoColumnas(&$pdf)
    {
        $pdf->Ln(4.5);
        $pdf->SetFont(PDF_FONT_NAME_MAIN,'B',9);
        $pdf->MultiCell(10,5,"Nro",1,'C',1,0);
        $pdf->MultiCell(15,5,"CAS",1,'C',1,0);
        $pdf->MultiCell(15,5,"Fecha",1,'C',1,0);
        $pdf->MultiCell(25,5,"#Autorizacion",1,'C',1,0);
        $pdf->MultiCell(45,5,"Paciente",1,'C',1,0);
        $pdf->MultiCell(45,5,"Concepto",1,'C',1,0);
        $pdf->MultiCell(10,5,"Cant",1,'C',1,0);
        $pdf->MultiCell(20,5,"SubTotal",1,'C',1,0);
        $pdf->MultiCell(17,5,"IVA",1,'C',1,0);
        $pdf->MultiCell(20,5,"Copagos",1,'C',1,0);
        $pdf->MultiCell(20,5,"Descuentos",1,'C',1,0);
        $pdf->MultiCell(23,5,"Neto",1,'C',1,0);
        $pdf->Ln();
    }
    function EscribeDetalle(&$pdf, &$row, &$i, &$rowcount, &$contador)
    {
        $fill = 0;
        $nomPaciente = $row[$i]["Documento"] . " - " . $row[$i]["Nom1"] . " " . $row[$i]["Nom2"] . " " . $row[$i]["Ape1"] . " " . $row[$i]["Ape2"];
        $pdf->writeHTMLCell(10, $rowcount, '', '', number_format($contador,0,".",","), 0, 0, $fill, true, 'L', true);
        $pdf->writeHTMLCell(15, $rowcount, '', '', $row[$i]["CAS"], 0, 0, $fill, true, 'C', true);
        $pdf->writeHTMLCell(15, $rowcount, '', '', $row[$i]["Fecha"], 0, 0, $fill, true, 'C', true);
        $pdf->writeHTMLCell(25, $rowcount, '', '', $row[$i]["NroAutorizacion"], 0, 0, $fill, true, 'C', true);
        $pdf->writeHTMLCell(45, $rowcount, '', '', utf8_decode($nomPaciente), 0, 0, $fill, true, 'L', true);
        $pdf->writeHTMLCell(45, $rowcount, '', '', utf8_decode($row[$i]["CodProcedimiento"]) . " - " . utf8_decode($row[$i]["DescProcedimiento"]), 0, 0, $fill, true, 'L', true);
        $pdf->writeHTMLCell(10, $rowcount, '', '', $row[$i]["Cantidad"], 0, 0, $fill, true, 'C', true);
        $pdf->writeHTMLCell(20, $rowcount, '', '', number_format($row[$i]["VlrTotal"],2,".",","), 0, 0, $fill, true, 'R', true);
        $pdf->writeHTMLCell(17, $rowcount, '', '', number_format($row[$i]["VlrIVA"],2,".",","), 0, 0, $fill, true, 'R', true);
        $pdf->writeHTMLCell(20, $rowcount, '', '', number_format(($row[$i]["VlrCuotaModeradora"] + $row[$i]["VlrCopagos"]),2,".",","), 0, 0, $fill, true, 'R', true);
        $pdf->writeHTMLCell(20, $rowcount, '', '', number_format($row[$i]["VlrDescuentos"],2,".",","), 0, 0, $fill, true, 'R', true);
        $pdf->writeHTMLCell(23, $rowcount, '', '', number_format($row[$i]["VlrNeto"],2,".",","), 0, 0, $fill, true, 'R', true);
        $pdf->Ln();
    }
    
    function PieGrupo(&$pdf, &$row, &$i, $totSubTotal, $totIVA, $totCopagos, $totDescuentos, $totNeto, $pTextoGrupo, $pCampoGrupo){
        $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
        $pdf->MultiCell(165,5,"TOTAL " . $pTextoGrupo . ": " . $row[$i][$pCampoGrupo],1,'R',1,0);
        $pdf->MultiCell(20,5,number_format($totSubTotal,2,".",","),1,'R',1,0);
        $pdf->MultiCell(17,5,number_format($totIVA,2,".",","),1,'R',1,0);
        $pdf->MultiCell(20,5,number_format($totCopagos,2,".",","),1,'R',1,0);
        $pdf->MultiCell(20,5,number_format($totDescuentos,2,".",","),1,'R',1,0);
        $pdf->MultiCell(23,5,number_format($totNeto,2,".",","),1,'R',1,0);
        $pdf->Ln();
    }
    
?>