<?php
    require_once('../../../lib/tcpdf/config/lang/spa.php');
    require_once('../../../lib/tcpdf/tcpdf.php');
    require("../../../core/php/_database.php");
    require("../../../core/php/php_functions.php");
    require("../../../core/php/constantes.php");
    //header('Content-type: application/pdf; charset: UTF-8');
    
    session_start();
    $pImprimeTirilla = "NO";
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:1;
    
    //Definicion de las Margenes
    $LeftMargin = PDF_MARGIN_LEFT;
    $TopMargin = 5;
    $RightMargin = PDF_MARGIN_RIGHT;
    $HeaderMargin = PDF_MARGIN_HEADER;
    $BottomMargin = 3;
    $FooterMargin = 5;
    $Alineacion = "P";
    $FormatoPagina = "CARTA";
    $UsaPiePagina = "SI";
    $pTipoEncabezado = "FVP";
      
    //Inicializacion de la Clase
    $pdf = new TCPDF($Alineacion, PDF_UNIT, $FormatoPagina, true, 'UTF-8', false);
    $pdf->pAlineacionEncabezado = $Alineacion;
    $pdf->pTituloInforme = "FACTURA DE VENTA";
    $pdf->pImprimeLogo = "NO";
    $pdf->pAnchoTxtPagina = 210;
    $pdf->pNomEmpresa = $_SESSION['NOM_EMPRESA'];
    $pdf->pTDocEmpresa = $_SESSION['EMPRESA_TDOC'];
    $pdf->pDocEmpresa = $_SESSION['EMPRESA_DOC'];
    $pdf->pDirEmpresa = $_SESSION['EMPRESA_DIR'];
    $pdf->pTelEmpresa = $_SESSION['EMPRESA_TEL'];
    $pdf->pCiuEmpresa = $_SESSION['EMPRESA_CIU'];
    $pdf->pEspEmpresa = $_SESSION['EMPRESA_ESP'];
    $pdf->pRegEmpresa = $_SESSION['EMPRESA_REGIMEN'];
    $pdf->pContribuyentes = $_SESSION['EMPRESA_CONTRIBUYENTE'];
    $pdf->pReteIVA  = $_SESSION['EMPRESA_RTEICA'];
    $pdf->pReteICA = $_SESSION['EMPRESA_RTEIVA'];
            
    $pdf->pTipoEncabezado = $pTipoEncabezado;
    $pdf->pNomSede = $_SESSION['EMPRESA_DOC'];
    $pdf->pNomIPS = $_SESSION['NOM_IPS'];
    $pdf->pMargenPie = -20;
    $pdf->pLogoCliente = "../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/logoenc.gif";
    $pdf->pPrefijo = $pPrefijo;
    $pdf->pNroDocumento = str_pad($pNroDocumento, 7, "0", STR_PAD_LEFT);
    $pdf->pNroResolucion = $pNroResolucion;
    $pdf->pFechaDoc = $pFechaDocumento;
    $pdf->pCAS = $pCAS;
    $pdf->pTratamiento = $pTratamiento;
    $pdf->pUsaPie = $UsaPiePagina;
        
    $pdf->SetCreator(PDF_CREATOR);
    $pdf->SetAuthor('Sistemas Ofisalud © - 2006');
    $pdf->SetTitle('FACTURACION');
    $pdf->SetSubject('Prefactura');

    $pdf->SetHeaderData($pdf->pLogoCliente, PDF_HEADER_LOGO_WIDTH, $pdf->pTituloInforme, PDF_HEADER_STRING);
    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
    $pdf->SetMargins($LeftMargin, $TopMargin, $RightMargin);
    $pdf->SetHeaderMargin($HeaderMargin);
    $pdf->SetFooterMargin($FooterMargin);
    
    $pdf->SetAutoPageBreak(TRUE, $BottomMargin);
    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
    $pdf->setLanguageArray($l);
    $pdf->setFontSubsetting(true);
    $pdf->SetFont('dejavusans', '', 14, '', true);
            
    $pdf->AddPage();
    if ($pAnulada == 1){
        $img_file = "../../../resources/varios/docanulado.png";
        $pdf->Image($img_file, 110, 8, 80, 50, '', '', '', false, 300, '', false, false, 0);
        $pdf->Image($img_file, 110, 215, 80, 50, '', '', '', false, 300, '', false, false, 0);
    }
    $pdf->Ln(2);
    $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
    $EncabezadoHTML = '<table cellspacing="0" border="0" style="font-size:24px; color:#000;">';
    $EncabezadoHTML .= '<tr>';
    $EncabezadoHTML .= '<td>';
    $EncabezadoHTML .= '<span style="font-size:44px; color:#000; font-weight:bold">' . utf8_decode($pdf->pNomEmpresa) . '</span><br>';
    if($pdf->pEspEmpresa != null || $pdf->pEspEmpresa != "")
            $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . utf8_decode($pdf->pEspEmpresa) . '</span><br>';
    if($pdf->pTDocEmpresa == "NI")
        $tipodoc = "NIT: ";
    else
        $tipodoc = $pdf->pTDocEmpresa . ": ";
    $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $tipodoc . $pdf->pDocEmpresa . '</span><br>';
    $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $pdf->pDirEmpresa . ' - ' . $pdf->pTelEmpresa . '</span><br>';
    $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $pdf->pCiuEmpresa . '</span><br>';
    $EncabezadoHTML .= '</td>';

    //COL2
    $EncabezadoHTML .= '<td>';
    $EncabezadoHTML .= '<span align="rigth" style="font-size:44px; color:#000; font-weight:bold">PRE-FACTURA DE VENTA</span><br>';
    $EncabezadoHTML .= '<span align="rigth" style="font-size:40px; color:#000; font-weight:bold">CAS: ' . $pCAS . '</span><br>';
    $EncabezadoHTML .= '</td>';
    $EncabezadoHTML .= '</tr>';
    $EncabezadoHTML .= '</table>';
    $EncabezadoHTML .= '<hr>';
    $pdf->writeHTML($EncabezadoHTML, true, false, false, false, '');
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_facturacion_prefacturaxcas('" . $pCAS . "')";
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    while ($row[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();

    $pRegistros = count($row);
    $pdf->SetFont(PDF_FONT_NAME_MAIN,'',10);
    $pdf->MultiCell(17,5,"Cliente:",0,'L',0,0);
    $infoCliente = "";
    if($row[0]["Tdoc"]=="NI")
        $infoCliente .= "NIT: ";
    else
        $infoCliente .= $row[0]["Tdoc"] . ": ";
    $infoCliente .= $row[0]["Documento"];
    if($row[0]["Digitover"]!="" || $row[0]["Digitover"]!=null)
        $infoCliente .= "-" . $row[0]["Digitover"];
    
    $infoCliente .= " " . utf8_decode($row[0]["DescripcionFac"]);
    $rowcount = max($pdf->getNumLines($infoCliente),$pdf->getNumLines(utf8_decode($row[0]["Direccion"]))) * 3;
    //$pdf->MultiCell(178,$rowcount,$infoCliente,0,'L',0,0);
    $pdf->writeHTMLCell(178, $rowcount, '', '', $infoCliente, 0, 0, 0, true, 'L', true);
    $pdf->Ln(4);
    // Cargar Datos del Paciente
    $pdf->MultiCell(17,5,"Paciente:",0,'L',0,0);
    $rowcount = max($pdf->getNumLines(utf8_decode($row[0]["Telefono"]) . " " . utf8_decode($row[0]["Telefono1"]),50),$pdf->getNumLines(utf8_decode($row[0]["TipDoc"]) . " " . utf8_decode($row[0]["Documento"]) .  " - " . utf8_decode($row[0]["PrimerNombre"]) . " " . utf8_decode($row[0]["SegundoNombre"]) . " " . utf8_decode($row[0]["PrimerApellido"]) . " " . utf8_decode($row[0]["SegundoApellido"]) . " -Genero:(" . utf8_decode($row[0]["Genero"]) . ")" . " -Edad:(" . utf8_decode($row[0]["Edad"]) . ")", 178)) * 4;
    $pdf->writeHTMLCell(178, $rowcount, '', '', utf8_decode($row[0]["TipDoc"]) . " " . utf8_decode($row[0]["Documento"]) .  " - " . utf8_decode($row[0]["PrimerNombre"]) . " " . utf8_decode($row[0]["SegundoNombre"]) . " " . utf8_decode($row[0]["PrimerApellido"]) . " " . utf8_decode($row[0]["SegundoApellido"]) . " -Genero:(" . utf8_decode($row[0]["Genero"]) . ")" . " -Edad:(" . utf8_decode($row[0]["Edad"]) . ")", 0, 0, 0, true, 'L', true);
    $pdf->Ln(4);
    $rowcount = max($pdf->getNumLines(utf8_decode($row[0]["Telefono"]) . " " . utf8_decode($row[0]["Telefono1"]),70),$pdf->getNumLines($row[0]["Direccion"], 70)) * 3;
    $pdf->MultiCell(18,$rowcount,"Dirección:",0,'L',0,0);
    $pdf->writeHTMLCell(78, $rowcount, '', '', utf8_decode($row[0]["Direccion"]), 0, 0, 0, true, 'L', true);
    $pdf->MultiCell(18,$rowcount,"Teléfono:",0,'L',0,0);
    $pdf->writeHTMLCell(78, $rowcount, '', '', utf8_decode($row[0]["Telefono"]) . " - " . utf8_decode($row[0]["Telefono1"]), 0, 0, 0, true, 'L', true);
    $pdf->Ln($rowcount+4);
    $pdf->SetLineWidth(0.3); 
    $pdf->Line($pdf->GetX(), $pdf->GetY(), $pdf->GetX()+200, $pdf->GetY()); 
    $pdf->SetFont(PDF_FONT_NAME_MAIN,'B',11);
    $pdf->MultiCell(20,5,"CODIGO",0,'C',0,0);
    $pdf->MultiCell(75,5,"DESCRIPCION",0,'C',0,0);
    $pdf->MultiCell(10,5,"IVA",0,'R',0,0);
    $pdf->MultiCell(25,5,"CANTIDAD",0,'R',0,0);
    $pdf->MultiCell(32,5,"VLR UNITARIO",0,'R',0,0);
    $pdf->MultiCell(32,5,"VLR TOTAL",0,'R',0,0);
    $pdf->Ln(5);
    $pdf->SetLineWidth(0.3); 
    $pdf->Line($pdf->GetX(), $pdf->GetY(), $pdf->GetX()+200, $pdf->GetY()); 
    $pdf->Ln(1);

    $img_file = "../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/fondofac.png";
    $pdf->Image($img_file, $pdf->GetX()+60, $pdf->GetY()+35, 90, 50, '', '', '', false, 300, '', false, false, 0);

    $pdf->SetFont(PDF_FONT_NAME_MAIN,'',10);
    $pVlrTotal = 0;
    $pVlrIVA = 0;
    $pVlrCopagos = 0;
    $pVlrDescuentos = 0;
    $pVlrNeto = 0;
    $fill = 0;
    for($i=0;$i<$pRegistros;$i++)
    {
        if($row[$i]["DescProcedimiento"] != ""){
            $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
            $rowcount = 0;
            $rowcount = $pdf->getNumLines(utf8_decode($row[$i]["DescProcedimiento"]), 75) * 3;
            //$pdf->MultiCell(20,$rowcount,utf8_decode($row[$i]["CUPSCodigo"]),0,'L',0,0);
            $pdf->writeHTMLCell(20, $rowcount, '', '', utf8_decode($row[$i]["CUPSCodigo"]), 0, 0, $fill, true, 'L', true);
            //$pdf->MultiCell(75,$rowcount,utf8_decode($row[$i]["DescProcedimiento"]),0,'L',0,0);
            $pdf->writeHTMLCell(75, $rowcount, '', '', utf8_decode($row[$i]["DescProcedimiento"]), 0, 0, $fill, true, 'L', true);
            //$pdf->MultiCell(10,$rowcount,number_format(0,0,".",","),0,'C',0,0);
            $pdf->writeHTMLCell(10, $rowcount, '', '', number_format(0,0,".",","), 0, 0, $fill, true, 'C', true);
            //$pdf->MultiCell(25,$rowcount,number_format($row[$i]["Cantidad"],0,".",","),0,'R',0,0);
            $pdf->writeHTMLCell(25, $rowcount, '', '', number_format($row[$i]["Cantidad"],0,".",","), 0, 0, $fill, true, 'R', true);
            //$pdf->MultiCell(32,$rowcount,"$ " . number_format(($row[$i]["VlrTotal"]/$row[$i]["Cantidad"]),2,".",","),0,'R',0,0);
            $pdf->writeHTMLCell(32, $rowcount, '', '', number_format(($row[$i]["VlrTotal"]/$row[$i]["Cantidad"]),2,".",","), 0, 0, $fill, true, 'R', true);
            //$pdf->MultiCell(32,$rowcount,"$ " . number_format($row[$i]["VlrTotal"],2,".",","),0,'R',0,0);
            $pdf->writeHTMLCell(32, $rowcount, '', '', number_format($row[$i]["VlrTotal"],2,".",","), 0, 0, $fill, true, 'R', true);
            $pdf->Ln($rowcount+2);
            $pVlrTotal += $row[$i]["VlrTotal"];
            $pVlrIVA += $row[$i]["VlrIVA"];
            $pVlrCopagos += $row[$i]["CM"] + $row[$i]["COPAGOS"];
            $pVlrDescuentos += $row[$i]["VlrDescuentos"];
            $pVlrNeto += $row[$i]["VlrNeto"];
            if($pdf->GetY() >= ($pdf->getPageHeight()-40))
            {
                ImprimeEncabezadoFactura($pdf);
            }
        }
    }
    //$pdf->writeHTMLCell(150, 10, '', '', $qry, 0, 0, $fill, true, 'R', true);
    while ($pdf->GetY() <= ($pdf->getPageHeight()-40)) {
        $pdf->Ln();
    }
    $pdf->Ln();
    $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
    $val = strtoupper(utf8_decode(numerotexto($pVlrNeto)));
    $EncabezadoHTML = '
    <table border="1" cellspacing="0" >
        <tr>
            <td width="520">&nbsp;<br>&nbsp;SON: '. $val . ' PESOS M/CTE.</td>
            <td width="180">
                <table border="0" cellspacing="0">
                    <tr>
                        <td width="70">TOTAL:</td>
                        <td width="100" align="rigth">$ ' . number_format($pVlrTotal,2,".",",") . '</td>
                    </tr>
                    <tr>
                        <td>IVA:</td>
                        <td width="100" align="rigth">$ ' . number_format($pVlrIVA,2,".",",") . '</td>
                    </tr>
                    <tr>
                        <td>COPAGOS:</td>
                        <td width="100" align="rigth">$ ' . number_format($pVlrCopagos,2,".",",") . '</td>
                    </tr>
                    <tr>
                        <td>DESCUENTOS:</td>
                        <td width="100" align="rigth">$ ' . number_format($pVlrDescuentos,2,".",",") . '</td>
                    </tr>
                    <tr>
                        <td>NETO:</td>
                        <td width="100" align="rigth">$ ' . number_format($pVlrNeto,2,".",",") . '</td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
    <span style="font-size:18px; color:#000;">ESTE NO ES UN DOCUMENTO VALIDO DE COBRO NI DE NEGOCIACION</span>';
    $pdf->writeHTML($EncabezadoHTML, true, false, false, false, '');
    $pdf->Output('Prefactura.pdf', 'I');

    function ImprimeEncabezadoFactura(&$pdf){
        $pdf->AddPage();
        $pdf->Ln(2);
        $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
        $EncabezadoHTML = '<table cellspacing="0" border="0" style="font-size:24px; color:#000;">';
        $EncabezadoHTML .= '<tr>';
        $EncabezadoHTML .= '<td>';
        $EncabezadoHTML .= '<span style="font-size:44px; color:#000; font-weight:bold">' . utf8_decode($pdf->pNomEmpresa) . '</span><br>';
        if($pdf->pEspEmpresa != null || $pdf->pEspEmpresa != "")
                $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . utf8_decode($pdf->pEspEmpresa) . '</span><br>';
        if($pdf->pTDocEmpresa == "NI")
            $tipodoc = "NIT: ";
        else
            $tipodoc = $pdf->pTDocEmpresa . ": ";
        $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $tipodoc . $pdf->pDocEmpresa . '</span><br>';
        $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $pdf->pDirEmpresa . ' - ' . $pdf->pTelEmpresa . '</span><br>';
        $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $pdf->pCiuEmpresa . '</span><br>';
        $EncabezadoHTML .= '</td>';

        //COL2
        $EncabezadoHTML .= '<td>';
        $EncabezadoHTML .= '<span align="rigth" style="font-size:44px; color:#000; font-weight:bold">PRE-FACTURA DE VENTA</span><br>';
        $EncabezadoHTML .= '<span align="rigth" style="font-size:40px; color:#000; font-weight:bold">CAS: ' . $pdf->pCAS . '</span><br>';
        $EncabezadoHTML .= '</td>';
        $EncabezadoHTML .= '</tr>';
        $EncabezadoHTML .= '</table>';
        $EncabezadoHTML .= '<hr>';
        $img_file = "../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/fondofac.png";
        $pdf->Image($img_file, $pdf->GetX()+60, $pdf->GetY()+35, 90, 50, '', '', '', false, 300, '', false, false, 0);
    }
    
?>
