<?php

/*
* @category    Controlador Profesionales
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/
ini_set('memory_limit', '-1'); 
require("../../../core/php/_database.php");
require("../../../core/php/php_functions.php");
session_start();

$task = '';
if ( isset($_POST['task'])){
  $task = $_POST['task'];
}
set_time_limit(0); 
ignore_user_abort(true);
ini_set('max_execution_time', 0);
//set_time_limit(2700);
$pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
$pCliente = isset($_REQUEST['pCliente'])?$_REQUEST['pCliente']:0;
$pPlan = isset($_REQUEST['pPlan'])?$_REQUEST['pPlan']:0;
if($pPlan == "" || $pPlan == null){
    $pPlan = 0;
}
$pSubPlan = isset($_REQUEST['pSubPlan'])?$_REQUEST['pSubPlan']:0;
if($pSubPlan == "" || $pSubPlan == null){
    $pSubPlan = 0;
}
$pContrato = isset($_REQUEST['pContrato'])?$_REQUEST['pContrato']:0;
if($pContrato == "" || $pContrato == null){
    $pContrato = 0;
}
$pParticular = isset($_REQUEST['pParticular'])?$_REQUEST['pParticular']:"N";
$pTipoEstudio = isset($_REQUEST['pTipoEstudio'])?$_REQUEST['pTipoEstudio']:0;
$pFactura = isset($_REQUEST['pFactura'])?$_REQUEST['pFactura']:0;
if($pFactura == null || $pFactura == "")
    $pFactura = 0;
$pDesde = isset($_REQUEST['pDesde'])?$_REQUEST['pDesde']:null;
if($pDesde == null || $pDesde == "")
    $pDesde = null;
$pHasta = isset($_REQUEST['pHasta'])?$_REQUEST['pHasta']:null;
if($pHasta == null || $pHasta == "")
    $pHasta = null;
$pConsecutivo = isset($_REQUEST['pConsecutivo'])?$_REQUEST['pConsecutivo']:mt_rand(1,100000);
if($pConsecutivo == null || $pConsecutivo == "" || $pConsecutivo == 0)
    $pConsecutivo = mt_rand(1,100000);
$pConsecutivo = str_pad($pConsecutivo, 6, "0", STR_PAD_LEFT);
$pXCAS = isset($_REQUEST['pXCAS'])?$_REQUEST['pXCAS']:"NO";
$qry = "";
$proceso = "consulta";
$yaCorrigioRIPS = 0;
switch($task){
    case "RIPSxFAC000a":
        $qry = "CALL sp_rips2014_000_a()";
        break;
    case "RIPSxFAC000b":
        $qry = "CALL sp_rips2014_000_b('" . $_SESSION['ID_IPS'] . "','" . $pCliente . "','" . $pContrato . "')";
        break;
    case "RIPSxFAC000c":
        $qry = "CALL sp_rips2014_000_c()";
        break;
    case "RIPSxFAC000d":
        $qry = "CALL sp_rips2014_000_d()";
        break;
    case "RIPSxFAC000e":
        $qry = "CALL sp_rips2014_000_e()";
        break;
    case "RIPSxFAC000f":
        $qry = "CALL sp_rips2014_000_f()";
        break;
    case "RIPSxFAC000g":
        $qry = "CALL sp_rips2014_000_g('" . $_SESSION['ID_IPS'] . "','" . $pCliente . "')";
        break;
    //EVENTO x FEC FAC
    case "RIPSxFAC001":
        if($pXCAS == "NO"){
            $qry = "CALL sp_rips2014_001_1('" . $_SESSION['ID_IPS'] . "',\"" . $pParticular . "\",'" . $pEmpresa . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "','" . $pFactura . "',\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pConsecutivo . "\")";
        }else{
            $qry = "CALL sp_rips2014_001_4('" . $_SESSION['ID_IPS'] . "',\"" . $pParticular . "\",'" . $pEmpresa . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "','" . $pFactura . "',\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pConsecutivo . "\")";
        }
        break;
    case "RIPSxFAC002":
        if($pXCAS == "NO"){
            $qry = "CALL sp_rips2014_002_1('" . $_SESSION['ID_IPS'] . "',\"" . $pParticular . "\",'" . $pEmpresa . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "','" . $pFactura . "',\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pConsecutivo . "\")";
        }else{
            $qry = "CALL sp_rips2014_002_4('" . $_SESSION['ID_IPS'] . "',\"" . $pParticular . "\",'" . $pEmpresa . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "','" . $pFactura . "',\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pConsecutivo . "\")";
        }
        break;
    case "RIPSxFAC003":
        if($pXCAS == "NO"){
            $qry = "CALL sp_rips2014_003_1('" . $_SESSION['ID_IPS'] . "',\"" . $pParticular . "\",'" . $pEmpresa . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "','" . $pFactura . "',\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pConsecutivo . "\")";
        }else{
            $qry = "CALL sp_rips2014_003_4('" . $_SESSION['ID_IPS'] . "',\"" . $pParticular . "\",'" . $pEmpresa . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "','" . $pFactura . "',\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pConsecutivo . "\")";
        }
        break;
    case "RIPSxFAC004":
        if($pXCAS == "NO"){
            $qry = "CALL sp_rips2014_004_1('" . $_SESSION['ID_IPS'] . "',\"" . $pParticular . "\",'" . $pEmpresa . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "','" . $pFactura . "',\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pConsecutivo . "\")";
        }else{
            $qry = "CALL sp_rips2014_004_4('" . $_SESSION['ID_IPS'] . "',\"" . $pParticular . "\",'" . $pEmpresa . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "','" . $pFactura . "',\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pConsecutivo . "\")";
        }
        break;
    case "RIPSxFAC005":
        if($pXCAS == "NO"){
            $qry = "CALL sp_rips2014_005_1('" . $_SESSION['ID_IPS'] . "',\"" . $pParticular . "\",'" . $pEmpresa . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "','" . $pFactura . "',\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pConsecutivo . "\")";
        }else{
            $qry = "CALL sp_rips2014_005_4('" . $_SESSION['ID_IPS'] . "',\"" . $pParticular . "\",'" . $pEmpresa . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "','" . $pFactura . "',\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pConsecutivo . "\")";
        }
        break;
    case "RIPSxFAC006":
        if($pXCAS == "NO"){
            $qry = "CALL sp_rips2014_006_1('" . $_SESSION['ID_IPS'] . "',\"" . $pParticular . "\",'" . $pEmpresa . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "','" . $pFactura . "',\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pConsecutivo . "\")";
        }else{
            $qry = "CALL sp_rips2014_006_4('" . $_SESSION['ID_IPS'] . "',\"" . $pParticular . "\",'" . $pEmpresa . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "','" . $pFactura . "',\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pConsecutivo . "\")";
        }
        break;
    case "RIPSxFAC007":
        if($pXCAS == "NO"){
            $qry = "CALL sp_rips2014_007_1('" . $_SESSION['ID_IPS'] . "',\"" . $pParticular . "\",'" . $pEmpresa . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "','" . $pFactura . "',\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pConsecutivo . "\")";
        }else{
            $qry = "CALL sp_rips2014_007_4('" . $_SESSION['ID_IPS'] . "',\"" . $pParticular . "\",'" . $pEmpresa . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "','" . $pFactura . "',\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pConsecutivo . "\")";
        }
        break;
    case "RIPSxFAC008":
        if($pXCAS == "NO"){
            $qry = "CALL sp_rips2014_008_1('" . $_SESSION['ID_IPS'] . "',\"" . $pParticular . "\",'" . $pEmpresa . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "','" . $pFactura . "',\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pConsecutivo . "\")";
        }else{
            $qry = "CALL sp_rips2014_008_4('" . $_SESSION['ID_IPS'] . "',\"" . $pParticular . "\",'" . $pEmpresa . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "','" . $pFactura . "',\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pConsecutivo . "\")";
        }
        break;
    //EVENTO x FEC RAD
    case "RIPSxRAD001":
        if($pXCAS == "NO"){
            $qry = "CALL sp_rips2014_001_2('" . $_SESSION['ID_IPS'] . "',\"" . $pParticular . "\",'" . $pEmpresa . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "','" . $pFactura . "',\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pConsecutivo . "\")";
        }else{
            $qry = "CALL sp_rips2014_001_5('" . $_SESSION['ID_IPS'] . "',\"" . $pParticular . "\",'" . $pEmpresa . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "','" . $pFactura . "',\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pConsecutivo . "\")";
        }
        break;
    case "RIPSxRAD002":
        if($pXCAS == "NO"){
            $qry = "CALL sp_rips2014_002_2('" . $_SESSION['ID_IPS'] . "',\"" . $pParticular . "\",'" . $pEmpresa . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "','" . $pFactura . "',\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pConsecutivo . "\")";
        }else{
            $qry = "CALL sp_rips2014_002_5('" . $_SESSION['ID_IPS'] . "',\"" . $pParticular . "\",'" . $pEmpresa . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "','" . $pFactura . "',\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pConsecutivo . "\")";
        }
        break;
    case "RIPSxRAD003":
        if($pXCAS == "NO"){
            $qry = "CALL sp_rips2014_003_2('" . $_SESSION['ID_IPS'] . "',\"" . $pParticular . "\",'" . $pEmpresa . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "','" . $pFactura . "',\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pConsecutivo . "\")";
        }else{
            $qry = "CALL sp_rips2014_003_5('" . $_SESSION['ID_IPS'] . "',\"" . $pParticular . "\",'" . $pEmpresa . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "','" . $pFactura . "',\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pConsecutivo . "\")";
        }
        break;
    case "RIPSxRAD004":
        if($pXCAS == "NO"){
            $qry = "CALL sp_rips2014_004_2('" . $_SESSION['ID_IPS'] . "',\"" . $pParticular . "\",'" . $pEmpresa . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "','" . $pFactura . "',\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pConsecutivo . "\")";
        }else{
            $qry = "CALL sp_rips2014_004_5('" . $_SESSION['ID_IPS'] . "',\"" . $pParticular . "\",'" . $pEmpresa . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "','" . $pFactura . "',\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pConsecutivo . "\")";
        }
        break;
    case "RIPSxRAD005":
        if($pXCAS == "NO"){
            $qry = "CALL sp_rips2014_005_2('" . $_SESSION['ID_IPS'] . "',\"" . $pParticular . "\",'" . $pEmpresa . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "','" . $pFactura . "',\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pConsecutivo . "\")";
        }else{
            $qry = "CALL sp_rips2014_005_5('" . $_SESSION['ID_IPS'] . "',\"" . $pParticular . "\",'" . $pEmpresa . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "','" . $pFactura . "',\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pConsecutivo . "\")";
        }
        break;
    case "RIPSxRAD006":
        if($pXCAS == "NO"){
            $qry = "CALL sp_rips2014_006_2('" . $_SESSION['ID_IPS'] . "',\"" . $pParticular . "\",'" . $pEmpresa . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "','" . $pFactura . "',\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pConsecutivo . "\")";
        }else{
            $qry = "CALL sp_rips2014_006_5('" . $_SESSION['ID_IPS'] . "',\"" . $pParticular . "\",'" . $pEmpresa . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "','" . $pFactura . "',\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pConsecutivo . "\")";
        }
        break;
    case "RIPSxRAD007":
        if($pXCAS == "NO"){
            $qry = "CALL sp_rips2014_007_2('" . $_SESSION['ID_IPS'] . "',\"" . $pParticular . "\",'" . $pEmpresa . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "','" . $pFactura . "',\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pConsecutivo . "\")";
        }else{
            $qry = "CALL sp_rips2014_007_5('" . $_SESSION['ID_IPS'] . "',\"" . $pParticular . "\",'" . $pEmpresa . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "','" . $pFactura . "',\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pConsecutivo . "\")";
        }
        break;
    case "RIPSxRAD008":
        if($pXCAS == "NO"){
            $qry = "CALL sp_rips2014_008_2('" . $_SESSION['ID_IPS'] . "',\"" . $pParticular . "\",'" . $pEmpresa . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "','" . $pFactura . "',\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pConsecutivo . "\")";
        }else{
            $qry = "CALL sp_rips2014_008_5('" . $_SESSION['ID_IPS'] . "',\"" . $pParticular . "\",'" . $pEmpresa . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "','" . $pFactura . "',\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pConsecutivo . "\")";
        }
        break;
    //////////////
    case "RIPSxFAC009":
        $qry = "CALL sp_rips2014_009('" . $_SESSION['ID_IPS'] . "',\"" . $pParticular . "\",'" . $pEmpresa . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "','" . $pFactura . "',\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pConsecutivo . "\")";
        break;
    // CAPITACION
    case "RIPSxCAP001":
        $qry = "CALL sp_rips2014_001_3('" . $_SESSION['ID_IPS'] . "',\"" . $pParticular . "\",'" . $pEmpresa . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "','" . $pFactura . "',\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pConsecutivo . "\")";
        break;
    case "RIPSxCAP002":
        $qry = "CALL sp_rips2014_002_3('" . $_SESSION['ID_IPS'] . "',\"" . $pParticular . "\",'" . $pEmpresa . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "','" . $pFactura . "',\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pConsecutivo . "\")";
        break;
    case "RIPSxCAP003":
        $qry = "CALL sp_rips2014_003_3('" . $_SESSION['ID_IPS'] . "',\"" . $pParticular . "\",'" . $pEmpresa . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "','" . $pFactura . "',\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pConsecutivo . "\")";
        break;
    case "RIPSxCAP004":
        $qry = "CALL sp_rips2014_004_3('" . $_SESSION['ID_IPS'] . "',\"" . $pParticular . "\",'" . $pEmpresa . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "','" . $pFactura . "',\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pConsecutivo . "\")";
        break;
    case "RIPSxCAP005":
        $qry = "CALL sp_rips2014_005_3('" . $_SESSION['ID_IPS'] . "',\"" . $pParticular . "\",'" . $pEmpresa . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "','" . $pFactura . "',\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pConsecutivo . "\")";
        break;
    case "RIPSxCAP006":
        $qry = "CALL sp_rips2014_006_3('" . $_SESSION['ID_IPS'] . "',\"" . $pParticular . "\",'" . $pEmpresa . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "','" . $pFactura . "',\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pConsecutivo . "\")";
        break;
    /////////////
    case "GENERAR_AC":   
        $proceso = "archivos";
        break;
    case "GENERAR_AP":   
        $proceso = "archivos";
        break;
    case "GENERAR_AM":   
        $proceso = "archivos";
        break;
    case "GENERAR_AT":   
        $proceso = "archivos";
        break;
    case "GENERAR_AH":   
        $proceso = "archivos";
        break;
    case "GENERAR_AN":   
        $proceso = "archivos";
        break;
    case "GENERAR_US":   
        $proceso = "archivos";
        break;
    case "GENERAR_AF":   
        $proceso = "archivos";
        break;
    case "GENERAR_CT":   
        $proceso = "archivos";
        break;
    default:
        $proceso = "na";
        break;
}

switch($proceso){
    case "consulta":
        $gBaseDatos = new ofiMySQLi();
        $gBaseDatos->conectar();
        if(@mysqli_query($gBaseDatos->ConexionID, $qry)){
        echo "{success: true, requestedId:'1'}";
        }else{
           echo "{success: true, requestedId:'0'}";
        }
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        break;
    case "archivos":
        
        switch($task){
            case "GENERAR_AC": 
                if($yaCorrigioRIPS == 0){
                    //Corregir RIPS
                    $gBaseDatos = new ofiMySQLi();
                    $gBaseDatos->conectar();
                    if(@mysqli_query($gBaseDatos->ConexionID, "CALL sp_rips2015_000_fixfinalidad()")){
                        $yaCorrigioRIPS = 1;
                    }else{
                       $yaCorrigioRIPS = 0;
                    }
                    $gBaseDatos->liberar();
                    $gBaseDatos->cerrar();
                }
                
                //RIPS AC
                $pNomArch = "../../../rips/AC" . $pConsecutivo . ".txt";
                if (file_exists($pNomArch)) {
                    unlink($pNomArch);
                    $tipoArch = "a";
                }else
                    $tipoArch = "w+";
                if (!$gestor = fopen($pNomArch, $tipoArch)){
                    echo "0";
                }else{
                    $gBaseDatos = new ofiMySQLi();
                    $gBaseDatos->conectar();
                    $qry = "select * from e_ac";
                    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
                    $contenido = "";
                    while ($row = @mysqli_fetch_assoc($gBaseDatos->QryID)){
                        $finfo = @mysqli_fetch_fields($gBaseDatos->QryID);
                        $contenido = "";
                        foreach ($finfo as $val){
                            //$contenido .= str_replace(",", ".", PonerAcentosHTML(utf8_decode($row[$val->name]))) . ",";
							$contenido .= str_replace(",", ".", (utf8_decode($row[$val->name]))) . ",";
                        }
                        $NewContenido = substr($contenido, 0, (strlen($contenido)-1));
                        $NewContenido .= "\r\n";
                        if (fwrite($gestor, $NewContenido) === FALSE) {
                            $gBaseDatos->liberar();
                            $gBaseDatos->cerrar();
                            echo "0";
                        }
                    }
                    $gBaseDatos->liberar();
                    $gBaseDatos->cerrar();
                    fclose($gestor); 
                    if($contenido == ""){
                        unlink($pNomArch);
                    }
                }
                break;
            case "GENERAR_AP":   
                if($yaCorrigioRIPS == 0){
                    //Corregir RIPS
                    $gBaseDatos = new ofiMySQLi();
                    $gBaseDatos->conectar();
                    if(@mysqli_query($gBaseDatos->ConexionID, "CALL sp_rips2015_000_fixfinalidad()")){
                        $yaCorrigioRIPS = 1;
                    }else{
                       $yaCorrigioRIPS = 0;
                    }
                    $gBaseDatos->liberar();
                    $gBaseDatos->cerrar();
                }
                
                //RIPS AP
                $pNomArch = "../../../rips/AP" . $pConsecutivo . ".txt";
                if (file_exists($pNomArch)) {
                    unlink($pNomArch);
                    $tipoArch = "a";
                }else
                    $tipoArch = "w+";
                if (!$gestor = fopen($pNomArch, $tipoArch)){
                    echo "0";
                }else{
                    $gBaseDatos = new ofiMySQLi();
                    $gBaseDatos->conectar();
                    $qry = "select * from e_ap";
                    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
                    $contenido = "";
                    while ($row = @mysqli_fetch_assoc($gBaseDatos->QryID)){
                        $finfo = @mysqli_fetch_fields($gBaseDatos->QryID);
                        $contenido = "";
                        foreach ($finfo as $val){
                            //$contenido .= str_replace(",", ".", PonerAcentosHTML(utf8_decode($row[$val->name]))) . ",";
							$contenido .= str_replace(",", ".", (utf8_decode($row[$val->name]))) . ",";
                        }
                        $NewContenido = substr($contenido, 0, (strlen($contenido)-1));
                        $NewContenido .= "\r\n";
                        if (fwrite($gestor, $NewContenido) === FALSE) {
                            $gBaseDatos->liberar();
                            $gBaseDatos->cerrar();
                            echo "0";
                        }
                    }
                    $gBaseDatos->liberar();
                    $gBaseDatos->cerrar();
                    fclose($gestor); 
                    if($contenido == ""){
                        unlink($pNomArch);
                    }
                }
                break;
            case "GENERAR_AM":   
                if($yaCorrigioRIPS == 0){
                    //Corregir RIPS
                    $gBaseDatos = new ofiMySQLi();
                    $gBaseDatos->conectar();
                    if(@mysqli_query($gBaseDatos->ConexionID, "CALL sp_rips2015_000_fixfinalidad()")){
                        $yaCorrigioRIPS = 1;
                    }else{
                       $yaCorrigioRIPS = 0;
                    }
                    $gBaseDatos->liberar();
                    $gBaseDatos->cerrar();
                }
                
                //RIPS AP
                $pNomArch = "../../../rips/AM" . $pConsecutivo . ".txt";
                if (file_exists($pNomArch)) {
                    unlink($pNomArch);
                    $tipoArch = "a";
                }else
                    $tipoArch = "w+";
                if (!$gestor = fopen($pNomArch, $tipoArch)){
                    echo "0";
                }else{
                    $gBaseDatos = new ofiMySQLi();
                    $gBaseDatos->conectar();
                    $qry = "select * from e_am";
                    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
                    $contenido = "";
                    while ($row = @mysqli_fetch_assoc($gBaseDatos->QryID)){
                        $finfo = @mysqli_fetch_fields($gBaseDatos->QryID);
                        $contenido = "";
                        foreach ($finfo as $val){
                            $contenido .= str_replace(",", ".", PonerAcentosHTML(utf8_decode($row[$val->name]))) . ",";
                        }
                        $NewContenido = substr($contenido, 0, (strlen($contenido)-1));
                        $NewContenido .= "\r\n";
                        if (fwrite($gestor, $NewContenido) === FALSE) {
                            $gBaseDatos->liberar();
                            $gBaseDatos->cerrar();
                            echo "0";
                        }
                    }
                    $gBaseDatos->liberar();
                    $gBaseDatos->cerrar();
                    fclose($gestor); 
                    if($contenido == ""){
                        unlink($pNomArch);
                    }
                }
                break;
            case "GENERAR_AT":   
                if($yaCorrigioRIPS == 0){
                    //Corregir RIPS
                    $gBaseDatos = new ofiMySQLi();
                    $gBaseDatos->conectar();
                    if(@mysqli_query($gBaseDatos->ConexionID, "CALL sp_rips2015_000_fixfinalidad()")){
                        $yaCorrigioRIPS = 1;
                    }else{
                       $yaCorrigioRIPS = 0;
                    }
                    $gBaseDatos->liberar();
                    $gBaseDatos->cerrar();
                }
                
                //RIPS AP
                $pNomArch = "../../../rips/AT" . $pConsecutivo . ".txt";
                if (file_exists($pNomArch)) {
                    unlink($pNomArch);
                    $tipoArch = "a";
                }else
                    $tipoArch = "w+";
                if (!$gestor = fopen($pNomArch, $tipoArch)){
                    echo "0";
                }else{
                    $gBaseDatos = new ofiMySQLi();
                    $gBaseDatos->conectar();
                    $qry = "select * from e_at";
                    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
                    $contenido = "";
                    while ($row = @mysqli_fetch_assoc($gBaseDatos->QryID)){
                        $finfo = @mysqli_fetch_fields($gBaseDatos->QryID);
                        $contenido = "";
                        foreach ($finfo as $val){
                            $contenido .= str_replace(",", ".", PonerAcentosHTML(utf8_decode($row[$val->name]))) . ",";
                        }
                        $NewContenido = substr($contenido, 0, (strlen($contenido)-1));
                        $NewContenido .= "\r\n";
                        if (fwrite($gestor, $NewContenido) === FALSE) {
                            $gBaseDatos->liberar();
                            $gBaseDatos->cerrar();
                            echo "0";
                        }
                    }
                    $gBaseDatos->liberar();
                    $gBaseDatos->cerrar();
                    fclose($gestor); 
                    if($contenido == ""){
                        unlink($pNomArch);
                    }
                }
                break;
            case "GENERAR_AH":   
                //RIPS AP
                $pNomArch = "../../../rips/AH" . $pConsecutivo . ".txt";
                if (file_exists($pNomArch)) {
                    unlink($pNomArch);
                    $tipoArch = "a";
                }else
                    $tipoArch = "w+";
                if (!$gestor = fopen($pNomArch, $tipoArch)){
                    echo "0";
                }else{
                    $gBaseDatos = new ofiMySQLi();
                    $gBaseDatos->conectar();
                    $qry = "select * from e_ah";
                    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
                    $contenido = "";
                    while ($row = @mysqli_fetch_assoc($gBaseDatos->QryID)){
                        $finfo = @mysqli_fetch_fields($gBaseDatos->QryID);
                        $contenido = "";
                        foreach ($finfo as $val){
                            $contenido .= str_replace(",", ".", PonerAcentosHTML(utf8_decode($row[$val->name]))) . ",";
                        }
                        $NewContenido = substr($contenido, 0, (strlen($contenido)-1));
                        $NewContenido .= "\r\n";
                        if (fwrite($gestor, $NewContenido) === FALSE) {
                            $gBaseDatos->liberar();
                            $gBaseDatos->cerrar();
                            echo "0";
                        }
                    }
                    $gBaseDatos->liberar();
                    $gBaseDatos->cerrar();
                    fclose($gestor); 
                    if($contenido == ""){
                        unlink($pNomArch);
                    }
                }
                break;
            case "GENERAR_AN":   
                //RIPS AP
                $pNomArch = "../../../rips/AN" . $pConsecutivo . ".txt";
                if (file_exists($pNomArch)) {
                    unlink($pNomArch);
                    $tipoArch = "a";
                }else
                    $tipoArch = "w+";
                if (!$gestor = fopen($pNomArch, $tipoArch)){
                    echo "0";
                }else{
                    $gBaseDatos = new ofiMySQLi();
                    $gBaseDatos->conectar();
                    $qry = "select * from e_an";
                    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
                    $contenido = "";
                    while ($row = @mysqli_fetch_assoc($gBaseDatos->QryID)){
                        $finfo = @mysqli_fetch_fields($gBaseDatos->QryID);
                        $contenido = "";
                        foreach ($finfo as $val){
                            $contenido .= str_replace(",", ".", PonerAcentosHTML(utf8_decode($row[$val->name]))) . ",";
                        }
                        $NewContenido = substr($contenido, 0, (strlen($contenido)-1));
                        $NewContenido .= "\r\n";
                        if (fwrite($gestor, $NewContenido) === FALSE) {
                            $gBaseDatos->liberar();
                            $gBaseDatos->cerrar();
                            echo "0";
                        }
                    }
                    $gBaseDatos->liberar();
                    $gBaseDatos->cerrar();
                    fclose($gestor); 
                    if($contenido == ""){
                        unlink($pNomArch);
                    }
                }
                break;
            case "GENERAR_US":   
                //RIPS AP
                $pNomArch = "../../../rips/US" . $pConsecutivo . ".txt";
                if (file_exists($pNomArch)) {
                    unlink($pNomArch);
                    $tipoArch = "a";
                }else
                    $tipoArch = "w+";
                if (!$gestor = fopen($pNomArch, $tipoArch)){
                    echo "0";
                }else{
                    $gBaseDatos = new ofiMySQLi();
                    $gBaseDatos->conectar();
                    $qry = "select * from e_us";
                    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
                    $contenido = "";
                    while ($row = @mysqli_fetch_assoc($gBaseDatos->QryID)){
                        $finfo = @mysqli_fetch_fields($gBaseDatos->QryID);
                        $contenido = "";
                        foreach ($finfo as $val){
                            $contenido .= str_replace(",", ".", PonerAcentosHTML(utf8_decode($row[$val->name]))) . ",";
                        }
                        $NewContenido = substr($contenido, 0, (strlen($contenido)-1));
                        $NewContenido .= "\r\n";
                        if (fwrite($gestor, $NewContenido) === FALSE) {
                            $gBaseDatos->liberar();
                            $gBaseDatos->cerrar();
                            echo "0";
                        }
                    }
                    $gBaseDatos->liberar();
                    $gBaseDatos->cerrar();
                    fclose($gestor); 
                    if($contenido == ""){
                        unlink($pNomArch);
                    }
                }
                break;
            case "GENERAR_AF":   
                //RIPS AP
                $pNomArch = "../../../rips/AF" . $pConsecutivo . ".txt";
                if (file_exists($pNomArch)) {
                    unlink($pNomArch);
                    $tipoArch = "a";
                }else
                    $tipoArch = "w+";
                if (!$gestor = fopen($pNomArch, $tipoArch)){
                    echo "0";
                }else{
                    $gBaseDatos = new ofiMySQLi();
                    $gBaseDatos->conectar();
                    $qry = "select * from e_af";
                    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
                    $contenido = "";
                    while ($row = @mysqli_fetch_assoc($gBaseDatos->QryID)){
                        $finfo = @mysqli_fetch_fields($gBaseDatos->QryID);
                        $contenido = "";
                        foreach ($finfo as $val){
                            $contenido .= str_replace(",", ".", PonerAcentosHTML(utf8_decode($row[$val->name]))) . ",";
                        }
                        $NewContenido = substr($contenido, 0, (strlen($contenido)-1));
                        $NewContenido .= "\r\n";
                        if (fwrite($gestor, $NewContenido) === FALSE) {
                            $gBaseDatos->liberar();
                            $gBaseDatos->cerrar();
                            echo "0";
                        }
                    }
                    $gBaseDatos->liberar();
                    $gBaseDatos->cerrar();
                    fclose($gestor); 
                    if($contenido == ""){
                        unlink($pNomArch);
                    }
                }
                break;
            case "GENERAR_CT":   
                //RIPS AP
                $pNomArch = "../../../rips/CT" . $pConsecutivo . ".txt";
                if (file_exists($pNomArch)) {
                    unlink($pNomArch);
                    $tipoArch = "a";
                }else
                    $tipoArch = "w+";
                if (!$gestor = fopen($pNomArch, $tipoArch)){
                    echo "0";
                }else{
                    $gBaseDatos = new ofiMySQLi();
                    $gBaseDatos->conectar();
                    $qry = "select * from e_ct";
                    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
                    $contenido = "";
                    while ($row = @mysqli_fetch_assoc($gBaseDatos->QryID)){
                        $finfo = @mysqli_fetch_fields($gBaseDatos->QryID);
                        $contenido = "";
                        foreach ($finfo as $val){
                            $contenido .= str_replace(",", ".", PonerAcentosHTML(utf8_decode($row[$val->name]))) . ",";
                        }
                        $NewContenido = substr($contenido, 0, (strlen($contenido)-1));
                        $NewContenido .= "\r\n";
                        if (fwrite($gestor, $NewContenido) === FALSE) {
                            $gBaseDatos->liberar();
                            $gBaseDatos->cerrar();
                            echo "0";
                        }
                    }
                    $gBaseDatos->liberar();
                    $gBaseDatos->cerrar();
                    fclose($gestor); 
                    if($contenido == ""){
                        unlink($pNomArch);
                    }
                }
                break;
        }
        break;
    default:
        break;
}


/*
function GenerarRIPS($Opcion){
    set_time_limit(0); 
    ignore_user_abort(true);
    ini_set('max_execution_time', 0);
    //set_time_limit(2700);
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pCliente = isset($_REQUEST['pCliente'])?$_REQUEST['pCliente']:0;
    $pPlan = isset($_REQUEST['pPlan'])?$_REQUEST['pPlan']:0;
    if($pPlan == "" || $pPlan == null){
        $pPlan = 0;
    }
    $pSubPlan = isset($_REQUEST['pSubPlan'])?$_REQUEST['pSubPlan']:0;
    if($pSubPlan == "" || $pSubPlan == null){
        $pSubPlan = 0;
    }
    $pContrato = isset($_REQUEST['pContrato'])?$_REQUEST['pContrato']:0;
    if($pContrato == "" || $pContrato == null){
        $pContrato = 0;
    }
    $pParticular = isset($_REQUEST['pParticular'])?$_REQUEST['pParticular']:"N";
    $pTipoEstudio = isset($_REQUEST['pTipoEstudio'])?$_REQUEST['pTipoEstudio']:0;
    $pFactura = isset($_REQUEST['pFactura'])?$_REQUEST['pFactura']:0;
    if($pFactura == null || $pFactura == "")
        $pFactura = 0;
    $pDesde = isset($_REQUEST['pDesde'])?$_REQUEST['pDesde']:null;
    if($pDesde == null || $pDesde == "")
        $pDesde = null;
    $pHasta = isset($_REQUEST['pHasta'])?$_REQUEST['pHasta']:null;
    if($pHasta == null || $pHasta == "")
        $pHasta = null;
    $pConsecutivo = isset($_REQUEST['pConsecutivo'])?$_REQUEST['pConsecutivo']:mt_rand(1,100000);
    if($pConsecutivo == null || $pConsecutivo == "" || $pConsecutivo == 0)
        $pConsecutivo = mt_rand(1,100000);
    $pConsecutivo = str_pad($pConsecutivo, 6, "0", STR_PAD_LEFT);
    $pXCAS = isset($_REQUEST['pXCAS'])?$_REQUEST['pXCAS']:"NO";
    
    switch($Opcion){
        case "Factura":
            if($pXCAS == "NO"){
                $qry = "CALL sp_rips2013_001_generar('" . $_SESSION['ID_IPS'] . "',\"" . $pParticular . "\",'" . $pEmpresa . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "','" . $pFactura . "',\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pConsecutivo . "\")";
            }else{
                $qry = "CALL sp_rips2013_004_generar('" . $_SESSION['ID_IPS'] . "',\"" . $pParticular . "\",'" . $pEmpresa . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "','" . $pFactura . "',\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pConsecutivo . "\")";
            }
            break;
        case "Radicado":
            if($pXCAS == "NO"){
                $qry = "CALL sp_rips2013_002_generar('" . $_SESSION['ID_IPS'] . "',\"" . $pParticular . "\",'" . $pEmpresa . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "','" . $pFactura . "',\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pConsecutivo . "\")";
            }else{
                $qry = "CALL sp_rips2013_005_generar('" . $_SESSION['ID_IPS'] . "',\"" . $pParticular . "\",'" . $pEmpresa . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "','" . $pFactura . "',\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pConsecutivo . "\")";
            }
            break;
        case "Capitado":
            $qry = "CALL sp_rips2013_003_generar('" . $_SESSION['ID_IPS'] . "',\"" . $pParticular . "\",'" . $pEmpresa . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "','" . $pFactura . "',\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pConsecutivo . "\")";
            break;
        default:
            break;
    }
    //PARTICULARES
    //$qry = "CALL sp_rips_002_generar(\"" . $pParticular . "\",'" . $pEmpresa . "','" . $_SESSION['ID_IPS'] . "','" . $pCliente . "','" . $pFactura . "',\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pConsecutivo . "\")";
    //echo $qry;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    if(@mysqli_query($gBaseDatos->ConexionID, $qry)){
        //RIPS AC
        $gBaseDatos->cerrar();
        //$pNomArch = "C:\\eoficlinic\\rips\\AC" . $pConsecutivo . ".txt";
        $pNomArch = "../../../rips/AC" . $pConsecutivo . ".txt";
        if (file_exists($pNomArch)) {
            unlink($pNomArch);
            $tipoArch = "a";
        }else
            $tipoArch = "w+";
        if (!$gestor = fopen($pNomArch, $tipoArch)){
            echo "0";
        }else{
            $gBaseDatos->conectar();
            $qry = "select * from e_ac";
            $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
            $contenido = "";
            while ($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
            {
                $finfo = @mysqli_fetch_fields($gBaseDatos->QryID);
                $contenido = "";
                foreach ($finfo as $val)
                {
                    $contenido .= str_replace(",", ".", PonerAcentosHTML(utf8_decode($row[$val->name]))) . ",";
                }
                $NewContenido = substr($contenido, 0, (strlen($contenido)-1));
                $NewContenido .= "\r\n";
                if (fwrite($gestor, $NewContenido) === FALSE) {
                    $gBaseDatos->liberar();
                    $gBaseDatos->cerrar();
                    echo "0";
                }
            }
            $gBaseDatos->liberar();
            $gBaseDatos->cerrar();
            fclose($gestor); 
            if($contenido == "")
                unlink($pNomArch);
            
        }
        
        //RIPS AP
        //$pNomArch = "C:\\eoficlinic\\rips\\AP" . $pConsecutivo . ".txt";
        $pNomArch = "../../../rips/AP" . $pConsecutivo . ".txt";
        if (file_exists($pNomArch)) {
            unlink($pNomArch);
            $tipoArch = "a";
        }else
            $tipoArch = "w+";
        if (!$gestor = fopen($pNomArch, $tipoArch)){
            echo "0";
        }else{
            $gBaseDatos->conectar();
            $qry = "select * from e_ap";
            $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
            $contenido = "";
            while ($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
            {
                $finfo = @mysqli_fetch_fields($gBaseDatos->QryID);
                $contenido = "";
                foreach ($finfo as $val)
                {
                    $contenido .= str_replace(",", ".", PonerAcentosHTML(utf8_decode($row[$val->name]))) . ",";
                }
                $NewContenido = substr($contenido, 0, (strlen($contenido)-1));
                $NewContenido .= "\r\n";
                if (fwrite($gestor, $NewContenido) === FALSE) {
                    $gBaseDatos->liberar();
                    $gBaseDatos->cerrar();
                    echo "0";
                }
            }
            $gBaseDatos->liberar();
            $gBaseDatos->cerrar();
            fclose($gestor); 
            if($contenido == "")
                unlink($pNomArch);
        }
        
        //RIPS AM
        //$pNomArch = "C:\\eoficlinic\\rips\\AM" . $pConsecutivo . ".txt";
        $pNomArch = "../../../rips/AM" . $pConsecutivo . ".txt";
        if (file_exists($pNomArch)) {
            unlink($pNomArch);
            $tipoArch = "a";
        }else
            $tipoArch = "w+";
        if (!$gestor = fopen($pNomArch, $tipoArch)){
            echo "0";
        }else{
            $gBaseDatos->conectar();
            $qry = "select * from e_am";
            $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
            $contenido = "";
            while ($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
            {
                $finfo = @mysqli_fetch_fields($gBaseDatos->QryID);
                $contenido = "";
                foreach ($finfo as $val)
                {
                    $contenido .= str_replace(",", ".", PonerAcentosHTML(utf8_decode($row[$val->name]))) . ",";
                }
                $NewContenido = substr($contenido, 0, (strlen($contenido)-1));
                $NewContenido .= "\r\n";
                if (fwrite($gestor, $NewContenido) === FALSE) {
                    $gBaseDatos->liberar();
                    $gBaseDatos->cerrar();
                    echo "0";
                }
            }
            $gBaseDatos->liberar();
            $gBaseDatos->cerrar();
            fclose($gestor); 
            if($contenido == "")
                unlink($pNomArch);
        }
        
        //RIPS AT
        $pNomArch = "../../../rips/AT" . $pConsecutivo . ".txt";
        if (file_exists($pNomArch)) {
            unlink($pNomArch);
            $tipoArch = "a";
        }else
            $tipoArch = "w+";
        if (!$gestor = fopen($pNomArch, $tipoArch)){
            echo "0";
        }else{
            $gBaseDatos->conectar();
            $qry = "select a.Factura, a.Prestador, a.Tdoc, a.Documento, a.Autoriza, a.TipoServicio, a.CodigoServicio, a.NombreServicio, a.Cantidad, a.ValorUnitario, a.ValorTotal from e_at a";
            $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
            $contenido = "";
            while ($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
            {
                $finfo = @mysqli_fetch_fields($gBaseDatos->QryID);
                $contenido = "";
                foreach ($finfo as $val)
                {
                    $contenido .= str_replace(",", ".", PonerAcentosHTML(utf8_decode($row[$val->name]))) . ",";
                }
                $NewContenido = substr($contenido, 0, (strlen($contenido)-1));
                $NewContenido .= "\r\n";
                if (fwrite($gestor, $NewContenido) === FALSE) {
                    $gBaseDatos->liberar();
                    $gBaseDatos->cerrar();
                    echo "0";
                }
            }
            $gBaseDatos->liberar();
            $gBaseDatos->cerrar();
            fclose($gestor); 
            if($contenido == "")
                unlink($pNomArch);
        }
        
        //RIPS AH
        $pNomArch = "../../../rips/AH" . $pConsecutivo . ".txt";
        if (file_exists($pNomArch)) {
            unlink($pNomArch);
            $tipoArch = "a";
        }else
            $tipoArch = "w+";
        if (!$gestor = fopen($pNomArch, $tipoArch)){
            echo "0";
        }else{
            $gBaseDatos->conectar();
            $qry = "SELECT a.Factura, a.Prestador, a.Tdoc, a.Documento, a.ViaIngreso, a.FechaIngreso, a.HoraIngreso, a.Autoriza, a.Causa, a.DiagPpalI, a.DiagPpalE, a.DiagRel1, a.DiagRel2, a.DiagRel3, a.DiagComplica, a.EstadoSalida, a.CausaMuerte, a.FechaSalida, a.HoraSalida FROM e_ah a";
            $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
            $contenido = "";
            while ($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
            {
                $finfo = @mysqli_fetch_fields($gBaseDatos->QryID);
                $contenido = "";
                foreach ($finfo as $val)
                {
                    $contenido .= str_replace(",", ".", PonerAcentosHTML(utf8_decode($row[$val->name]))) . ",";
                }
                $NewContenido = substr($contenido, 0, (strlen($contenido)-1));
                $NewContenido .= "\r\n";
                if (fwrite($gestor, $NewContenido) === FALSE) {
                    $gBaseDatos->liberar();
                    $gBaseDatos->cerrar();
                    echo "0";
                }
            }
            $gBaseDatos->liberar();
            $gBaseDatos->cerrar();
            fclose($gestor); 
            if($contenido == "")
                unlink($pNomArch);
        }
        
        //RIPS AN
        $pNomArch = "../../../rips/AN" . $pConsecutivo . ".txt";
        if (file_exists($pNomArch)) {
            unlink($pNomArch);
            $tipoArch = "a";
        }else
            $tipoArch = "w+";
        if (!$gestor = fopen($pNomArch, $tipoArch)){
            echo "0";
        }else{
            $gBaseDatos->conectar();
            $qry = "SELECT a.Factura, a.Prestador, a.Tdoc, a.Documento, a.FechaNacimiento, a.HoraNacimiento, a.EdadGesta, a.ControlPrenatal, a.Sexo, a.Peso, a.DiagPpal, a.CausaMuerte, a.FechaMuerte, a.HoraMuerte FROM e_an a";
            $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
            $contenido = "";
            while ($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
            {
                $finfo = @mysqli_fetch_fields($gBaseDatos->QryID);
                $contenido = "";
                foreach ($finfo as $val)
                {
                    $contenido .= str_replace(",", ".", PonerAcentosHTML(utf8_decode($row[$val->name]))) . ",";
                }
                $NewContenido = substr($contenido, 0, (strlen($contenido)-1));
                $NewContenido .= "\r\n";
                if (fwrite($gestor, $NewContenido) === FALSE) {
                    $gBaseDatos->liberar();
                    $gBaseDatos->cerrar();
                    echo "0";
                }
            }
            $gBaseDatos->liberar();
            $gBaseDatos->cerrar();
            fclose($gestor); 
            if($contenido == "")
                unlink($pNomArch);
        }
        
        //RIPS US
        $pNomArch = "../../../rips/US" . $pConsecutivo . ".txt";
        if (file_exists($pNomArch)) {
            unlink($pNomArch);
            $tipoArch = "a";
        }else
            $tipoArch = "w+";
        if (!$gestor = fopen($pNomArch, $tipoArch)){
            echo "0";
        }else{
            $gBaseDatos->conectar();
            $qry = "SELECT e_us.Tdoc, e_us.Documento, e_us.CodEnti, e_us.TipUSR, e_us.Apellido1, e_us.Apellido2, e_us.Nombre1, e_us.Nombre2, e_us.Edad, e_us.UniMed, e_us.Sexo, e_us.Depto, e_us.Munici, e_us.Zona FROM e_us";            $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
            $contenido = "";
            while ($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
            {
                $finfo = @mysqli_fetch_fields($gBaseDatos->QryID);
                $contenido = "";
                foreach ($finfo as $val){
                    $contenido .= str_replace(",", " ", PonerAcentosHTML(utf8_decode($row[$val->name]))) . ",";
                }
                $NewContenido = substr($contenido, 0, (strlen($contenido)-1));
                $NewContenido .= "\r\n";
                if (fwrite($gestor, $NewContenido) === FALSE) {
                    $gBaseDatos->liberar();
                    $gBaseDatos->cerrar();
                    echo "0";
                }
            }
            $gBaseDatos->liberar();
            $gBaseDatos->cerrar();
            fclose($gestor); 
            if($contenido == "")
                unlink($pNomArch);
        }
                
        //RIPS AF
        $pNomArch = "../../../rips/AF" . $pConsecutivo . ".txt";
        if (file_exists($pNomArch)) {
            unlink($pNomArch);
            $tipoArch = "a";
        }else
            $tipoArch = "w+";
        if (!$gestor = fopen($pNomArch, $tipoArch)){
            echo "0";
        }else{
            $gBaseDatos->conectar();
            $qry = "select * from e_af";
            $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
            $contenido = "";
            while ($row = @mysqli_fetch_assoc($gBaseDatos->QryID)){
                $finfo = @mysqli_fetch_fields($gBaseDatos->QryID);
                $contenido = "";
                foreach ($finfo as $val){
                    if($val->name == "Documento"){
                        $txt = str_replace(",", " ", PonerAcentosHTML(utf8_decode($row[$val->name])));
                        $txt1 = str_replace(".", "", $txt);
                        $txt = str_replace("-10", "", $txt1);
                        $txt1 = str_replace("-0", "", $txt);
                        $txt = str_replace("-1", "", $txt1);
                        $txt1 = str_replace("-2", "", $txt);
                        $txt = str_replace("-3", "", $txt1);
                        $txt1 = str_replace("-4", "", $txt);
                        $txt = str_replace("-5", "", $txt1);
                        $txt1 = str_replace("-6", "", $txt);
                        $txt = str_replace("-7", "", $txt1);
                        $txt1 = str_replace("-8", "", $txt);
                        $txt = str_replace("-9", "", $txt1);
                        $contenido .= str_replace(",", " ", $txt) . ",";
                    }else{
                        $contenido .= str_replace(",", " ", PonerAcentosHTML(utf8_decode($row[$val->name]))) . ",";
                    }
                }
                $NewContenido = substr($contenido, 0, (strlen($contenido)-1));
                $NewContenido .= "\r\n";
                if (fwrite($gestor, $NewContenido) === FALSE) {
                    $gBaseDatos->liberar();
                    $gBaseDatos->cerrar();
                    echo "0";
                }
            }
            $gBaseDatos->liberar();
            $gBaseDatos->cerrar();
            fclose($gestor); 
            if($contenido == "")
                unlink($pNomArch);
        }
        //RIPS CT
        $pNomArch = "../../../rips/CT" . $pConsecutivo . ".txt";
        if (file_exists($pNomArch)) {
            unlink($pNomArch);
            $tipoArch = "a";
        }else
            $tipoArch = "w+";
        if (!$gestor = fopen($pNomArch, $tipoArch)){
            echo "0";
        }else{
            $gBaseDatos->conectar();
            $qry = "select * from e_ct";
            $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
            $contenido = "";
            while ($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
            {
                $finfo = @mysqli_fetch_fields($gBaseDatos->QryID);
                $contenido = "";
                foreach ($finfo as $val)
                {
                    $contenido .= str_replace(",", ".", PonerAcentosHTML(utf8_decode($row[$val->name]))) . ",";
                }
                $NewContenido = substr($contenido, 0, (strlen($contenido)-1));
                $NewContenido .= "\r\n";
                if (fwrite($gestor, $NewContenido) === FALSE) {
                    $gBaseDatos->liberar();
                    $gBaseDatos->cerrar();
                    echo "0";
                }
            }
            $gBaseDatos->liberar();
            $gBaseDatos->cerrar();
            fclose($gestor); 
            if($contenido == "")
                unlink($pNomArch);
        }
        /*@copy('../../../rips/AC' . $pConsecutivo . '.txt', 'C:\\eoficlinic\\rips\\AC' . $pConsecutivo . '.txt');
        @copy('../../../rips/AP' . $pConsecutivo . '.txt', 'C:\\eoficlinic\\rips\\AP' . $pConsecutivo . '.txt');
        @copy('../../../rips/AM' . $pConsecutivo . '.txt', 'C:\\eoficlinic\\rips\\AM' . $pConsecutivo . '.txt');
        @copy('../../../rips/AT' . $pConsecutivo . '.txt', 'C:\\eoficlinic\\rips\\AT' . $pConsecutivo . '.txt');
        @copy('../../../rips/AF' . $pConsecutivo . '.txt', 'C:\\eoficlinic\\rips\\AF' . $pConsecutivo . '.txt');
        @copy('../../../rips/CT' . $pConsecutivo . '.txt', 'C:\\eoficlinic\\rips\\CT' . $pConsecutivo . '.txt');
        @copy('../../../rips/US' . $pConsecutivo . '.txt', 'C:\\eoficlinic\\rips\\US' . $pConsecutivo . '.txt');
        echo "1";
    }else{
        $gBaseDatos->cerrar();
        echo "0";
    }
    
}
*/
?>