<?php

/*
* @category    Controlador Inventarios
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

require("../../../core/php/_database.php");
require("../../../core/php/php_functions.php");

$task = '';
if ( isset($_POST['task'])){
  $task = $_POST['task'];
}
switch($task){
    case "CLOSE_INVENTARIO":
        CerrarInventario();
        break;
    case "CLOSE_INVENTARIO_SINCONTEOS":
        CerrarInventarioSinConteos();
        break;
    case "CLOSE_CONTEO":
        CerrarConteo();
        break;
    case "DEL_ITEM_CONTEO":
        EliminarItemConteo();
        break;
    case "ADD_ITEM_CONTEO":
        AdicionarItemConteo();
        break;
    case "DEL_CONTEO":
        EliminarConteoInventario();
        break;
    case "CHECK_CONTEO":
        VerificaConteosIguales();
        break;
    case "ADD_CONTEO_1":
        CrearConteoInventario("1");
        break;
    case "ADD_CONTEO_N":
        CrearConteoInventario("N");
        break;
    case "ADD_INVENTARIO":
        AdicionarInventario();
        break;
    case "GRID_DETALLE_INVENTARIO":
        GridDetalleInventario();
        break;
    case "GRID_MOVIMIENTO_CONCEPTO":
        GridMovimientoxConcepto();
        break;
    case "GRID_LOTES_CONCEPTO":
        GridLotesxConcepto();
        break;
    case "SALDO_GENERAL_LOTE":
        SaldoGeneralxLote();
        break;
    case "SALDO_LOTE":
        SaldoxLote();
        break;
    case "SALDO_CONCEPTO":
        SaldoxConcepto();
        break;
    case "ADD_LOTE":
        AdicionarLote();
        break;
    case "DEL_LOTE":
        EliminarLote();
        break;
    case "ADD_MOVIMIENTO":
        AdicionaMovimiento();
        break;
    case "LISTAR_MOVIMIENTOS_DETALLE":
        ListarDetalleMovimientos();
        break;
    case "ADD_MOVIMIENTO_DETALLE":
        AdicionaMovimientoDetalle();
        break;
    case "DEL_MOVIMIENTO_DETALLE":
        EliminarMovimientoDetalle();
        break;
    case "APLICAR_MOVIMIENTO":
        Aplicar_Movimiento();
        break;
    case "APLICAR_MOVIMIENTO_DISPENSACION":
        AplicarMovimientoDispensacion();
        break;
    default:
        echo "{failure:true}";
        break;
}

function CerrarInventario(){
    $pInventario = isset($_REQUEST['pInventario']) ? $_REQUEST['pInventario']:0;
    $pUsuario = isset($_REQUEST['pUsuario']) ? $_REQUEST['pUsuario']:0;
    $pHoraCierre = isset($_REQUEST['pHoraCierre']) ? $_REQUEST['pHoraCierre']:null;
    $pActaCierre = isset($_REQUEST['pActaCierre']) ? $_REQUEST['pActaCierre']:null;
    $pNomBaseDatos = isset($_REQUEST['pNomBaseDatos'])?$_REQUEST['pNomBaseDatos']:"NA";
    if($pNomBaseDatos == "NA"){
        $gBaseDatos = new ofiMySQLi();
    }else{
        $gBaseDatos = new ofiMySQLi($pNomBaseDatos);
    }
    $gBaseDatos->conectar();
    $qry = "CALL sp_inventarios_closeinventario('" . $pInventario .  "',\"" . $pHoraCierre . "\",\"" . $pActaCierre . "\",'" . $pUsuario . "')";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
        echo "{success: true, requestedId:'0'}";
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
}

function CerrarInventarioSinConteos(){
    $pInventario = isset($_REQUEST['pInventario']) ? $_REQUEST['pInventario']:0;
    $pUsuario = isset($_REQUEST['pUsuario']) ? $_REQUEST['pUsuario']:0;
    $pHoraCierre = isset($_REQUEST['pHoraCierre']) ? $_REQUEST['pHoraCierre']:null;
    $pActaCierre = isset($_REQUEST['pActaCierre']) ? $_REQUEST['pActaCierre']:null;
    $pNomBaseDatos = isset($_REQUEST['pNomBaseDatos'])?$_REQUEST['pNomBaseDatos']:"NA";
    if($pNomBaseDatos == "NA"){
        $gBaseDatos = new ofiMySQLi();
    }else{
        $gBaseDatos = new ofiMySQLi($pNomBaseDatos);
    }
    $gBaseDatos->conectar();
    $qry = "CALL sp_inventarios_closeinventariosinconteos('" . $pInventario .  "',\"" . $pHoraCierre . "\",\"" . $pActaCierre . "\",'" . $pUsuario . "')";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
        echo "{success: true, requestedId:'0'}";
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
}

function CerrarConteo(){
    $pInventario = isset($_REQUEST['pInventario']) ? $_REQUEST['pInventario']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_inventarios_cerrarconteo('" . $pInventario . "')";
    if(@mysqli_query($gBaseDatos->ConexionID, $qry)){
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        echo "1";
    }else{
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        echo "{success:false}";
    }
}

function EliminarItemConteo(){
    $pItemConteo = isset($_REQUEST['pItemConteo']) ? $_REQUEST['pItemConteo']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_inventarios_delitemconteo('" . $pItemConteo . "')";
    if(@mysqli_query($gBaseDatos->ConexionID, $qry)){
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        echo "1";
    }else{
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        echo "{success:false}";
    }
}

function AdicionarItemConteo(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS']) ? $_REQUEST['pIPS']:0;
    $pUsuario = isset($_REQUEST['pUsuario']) ? $_REQUEST['pUsuario']:0;
    $pInventario = isset($_REQUEST['pInventario']) ? $_REQUEST['pInventario']:0;
    $pConteo = isset($_REQUEST['pConteo']) ? $_REQUEST['pConteo']:0;
    $pConteoAnt = $pConteo - 1;
    $pConsecutivoItemConteo = isset($_REQUEST['pConsecutivoItemConteo']) ? $_REQUEST['pConsecutivoItemConteo']:0;
    $pConcepto = isset($_REQUEST['pConcepto']) ? $_REQUEST['pConcepto']:0;
    $pLote = isset($_REQUEST['pLote']) ? $_REQUEST['pLote']:null;
    if($pLote == 0 || $pLote == "0" || $pLote == null || $pLote == ""){
        $pLote = null;
    }
    $pCantidad = isset($_REQUEST['pCantidad']) ? $_REQUEST['pCantidad']:0;
    $pNomBaseDatos = isset($_REQUEST['pNomBaseDatos'])?$_REQUEST['pNomBaseDatos']:"NA";
    if($pNomBaseDatos == "NA"){
        $gBaseDatos = new ofiMySQLi();
    }else{
        $gBaseDatos = new ofiMySQLi($pNomBaseDatos);
    }
    $gBaseDatos->conectar();
    if($pConteo == 1 || $pConteo == "1"){
        if($pConsecutivoItemConteo == "0" || $pConsecutivoItemConteo == 0){
            $qry = "INSERT INTO pinventario_gestioninventario_conteos (
                    pinventario_gestioninventario_conteos.IdInventario,
                    pinventario_gestioninventario_conteos.IdConcepto,";
            if($pLote != null){
                $qry .= "pinventario_gestioninventario_conteos.IdConceptoLoteVencimiento,";
            }
            $qry .= "pinventario_gestioninventario_conteos.Conteo1,
                    pinventario_gestioninventario_conteos.ConteoFinal,
                    pinventario_gestioninventario_conteos.Iguales,
                    pinventario_gestioninventario_conteos.ConteoRealizado,
                    pinventario_gestioninventario_conteos.ConteoCerrado,
                    pinventario_gestioninventario_conteos.Usuario,
                    pinventario_gestioninventario_conteos.FechaAct) VALUES (" . $pInventario . "," . $pConcepto . ",";
            if($pLote != null){
                $qry .= $pLote . ",";
            }
            $qry .= $pCantidad . "," . $pCantidad . ",0,1,0," . $pUsuario . ",now())";
        }else{
            $qry = "UPDATE pinventario_gestioninventario_conteos SET
                    pinventario_gestioninventario_conteos.IdConcepto = " . $pConcepto . ",";
            if($pLote != null){
                $qry .= "pinventario_gestioninventario_conteos.IdConceptoLoteVencimiento = " . $pLote . ",";
            }
            $qry .= "pinventario_gestioninventario_conteos.Conteo" . $pConteo . " = " . $pCantidad . ",";
            $qry .= "pinventario_gestioninventario_conteos.ConteoFinal = " . $pCantidad . ",";
            if($pConteo != 1 && $pConteo != "1"){ 
                $qry .= "pinventario_gestioninventario_conteos.Iguales = IF(pinventario_gestioninventario_conteos.Conteo" . $pConteo . " = pinventario_gestioninventario_conteos.Conteo" . $pConteoAnt . ",1,0),";
            }else{
                $qry .= "pinventario_gestioninventario_conteos.Iguales = 0,";
            }
            $qry .= "pinventario_gestioninventario_conteos.ConteoRealizado = 1,";
            $qry .= "pinventario_gestioninventario_conteos.ConteoCerrado = 0,";
            $qry .= "pinventario_gestioninventario_conteos.Usuario = " . $pUsuario . ",";
            $qry .= "pinventario_gestioninventario_conteos.FechaAct = now()";
            $qry .= " WHERE pinventario_gestioninventario_conteos.IdRegistroConteo = " . $pConsecutivoItemConteo;
        }
    }else{
        $qry = "UPDATE pinventario_gestioninventario_conteos SET
                pinventario_gestioninventario_conteos.IdConcepto = " . $pConcepto . ",";
        if($pLote != null){
            $qry .= "pinventario_gestioninventario_conteos.IdConceptoLoteVencimiento = " . $pLote . ",";
        }
        $qry .= "pinventario_gestioninventario_conteos.Conteo" . $pConteo . " = " . $pCantidad . ",";
        $qry .= "pinventario_gestioninventario_conteos.ConteoFinal = " . $pCantidad . ",";
        if($pConteo != 1 && $pConteo != "1"){ 
            $qry .= "pinventario_gestioninventario_conteos.Iguales = IF(pinventario_gestioninventario_conteos.Conteo" . $pConteo . " = pinventario_gestioninventario_conteos.Conteo" . $pConteoAnt . ",1,0),";
        }else{
            $qry .= "pinventario_gestioninventario_conteos.Iguales = 0,";
        }
        $qry .= "pinventario_gestioninventario_conteos.ConteoRealizado = 1,";
        $qry .= "pinventario_gestioninventario_conteos.ConteoCerrado = 0,";
        $qry .= "pinventario_gestioninventario_conteos.Usuario = " . $pUsuario . ",";
        $qry .= "pinventario_gestioninventario_conteos.FechaAct = now()";
        $qry .= " WHERE pinventario_gestioninventario_conteos.IdRegistroConteo = " . $pConsecutivoItemConteo;
    }
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function EliminarConteoInventario(){
    $pInventario = isset($_REQUEST['pInventario']) ? $_REQUEST['pInventario']:0;
    $pConteo = isset($_REQUEST['pConteo']) ? $_REQUEST['pConteo']:0;
    if($pConteo == 1 || $pConteo == "1"){
        $qry = "DELETE pinventario_gestioninventario_conteos FROM pinventario_gestioninventario_conteos WHERE pinventario_gestioninventario_conteos.IdInventario = " . $pInventario;
    }else{
        $qry = "UPDATE pinventario_gestioninventario_conteos SET pinventario_gestioninventario_conteos.Conteo" . $pConteo . " = 0, pinventario_gestioninventario_conteos.Iguales = 0, pinventario_gestioninventario_conteos.ConteoRealizado = 0, pinventario_gestioninventario_conteos.ConteoCerrado = 0 WHERE pinventario_gestioninventario_conteos.IdInventario = " . $pInventario;
    }
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    if(@mysqli_query($gBaseDatos->ConexionID, $qry)){
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        $gBaseDatos = new ofiMySQLi();
        $gBaseDatos->conectar();
        $qry = "UPDATE pinventario_gestioninventario SET pinventario_gestioninventario.ConteoActual = (pinventario_gestioninventario.ConteoActual - 1) WHERE pinventario_gestioninventario.IdConsecutivoInventario =  " . $pInventario;
        if(@mysqli_query($gBaseDatos->ConexionID, $qry)){
            $gBaseDatos->liberar();
            $gBaseDatos->cerrar();
            echo "1";
        }else{
            $gBaseDatos->liberar();
            $gBaseDatos->cerrar();
            echo "{success:false}";
        }
    }else{
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        echo "{success:false}";
    }
}

function VerificaConteosIguales(){
    $gBaseDatos = new ofiMySQLi();
    $pInventario = isset($_REQUEST['pInventario']) ? $_REQUEST['pInventario']:0;
    $gBaseDatos->conectar();
    $qry = "CALL sp_inventario_verificaconteos('" . $pInventario . "')";
    //echo $qry;
    $CampoLlave = explode("^",$gBaseDatos->jasonSP_arreglo2011($qry));
    if($CampoLlave[0] == "" || $CampoLlave[0] == null){
        echo "{success:false}";
    }else{
       echo $CampoLlave[0];
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    //
}

function CrearConteoInventario($pConteo){
    $gBaseDatos = new ofiMySQLi();
    $pInventario = isset($_REQUEST['pInventario']) ? $_REQUEST['pInventario']:0;
    $gBaseDatos->conectar();
    $qry = "CALL sp_inventario_adicionarconteo('" . $pInventario . "',\"" . $pConteo . "\")";
    //echo $qry;
    $CampoLlave = explode("^",$gBaseDatos->jasonSP_arreglo2011($qry));
    if($CampoLlave[0] == "" || $CampoLlave[0] == null){
        echo "{success:false}";
    }else{
       echo $CampoLlave[0];
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
}

function AdicionarInventario(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS']) ? $_REQUEST['pIPS']:0;
    $pBodega = isset($_REQUEST['pBodega']) ? $_REQUEST['pBodega']:0;
    $pZona = isset($_REQUEST['pZona']) ? $_REQUEST['pZona']:0;
    $pTipoInventario = isset($_REQUEST['pTipoInventario']) ? $_REQUEST['pTipoInventario']:null;
    $pHoraApertura = isset($_REQUEST['pHoraApertura']) ? $_REQUEST['pHoraApertura']:null;
    $pActaApertura = isset($_REQUEST['pActaApertura']) ? $_REQUEST['pActaApertura']:null;
    $pUsuario = isset($_REQUEST['pUsuario']) ? $_REQUEST['pUsuario']:0;
    $pNomBaseDatos = isset($_REQUEST['pNomBaseDatos'])?$_REQUEST['pNomBaseDatos']:"NA";
    if($pNomBaseDatos == "NA"){
        $gBaseDatos = new ofiMySQLi();
    }else{
        $gBaseDatos = new ofiMySQLi($pNomBaseDatos);
    }
    $gBaseDatos->conectar();
    $qry = "CALL sp_inventarios_addinventario('" . $pEmpresa . "','" . $pIPS . "','" . $pBodega . "','" . $pZona . "','" . $pTipoInventario .  "',\"" . $pHoraApertura . "\",\"" . $pActaApertura . "\",'" . $pUsuario . "')";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function GridDetalleInventario(){
    $pBarras = isset($_REQUEST['pBarras']) ? $_REQUEST['pBarras']:"0";
    if($pBarras == "" || $pBarras == null){
        $pBarras = "0";
    }
    $pConteos = isset($_REQUEST['pConteos']) ? $_REQUEST['pConteos']:"N";
    $pDesConcepto = isset($_REQUEST['pDesConcepto']) ? $_REQUEST['pDesConcepto']:"Todos";
    if($pDesConcepto == "" || $pDesConcepto == null){
        $pDesConcepto = "Todos";
    }
    $pInventario = isset($_REQUEST['pInventario']) ? $_REQUEST['pInventario']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_inventario_grid_detalleinventario('" . $pInventario . "',\"" . $pBarras . "\",\"" . $pDesConcepto . "\",\"" . $pConteos . "\")";
    //echo $qry;
    $CampoLlave = explode("^",$gBaseDatos->jasonSP_arreglo2011($qry));
    $nbrows = $CampoLlave[0];
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    if($nbrows>0){
        $start = (integer) (isset($_POST['start']) ? $_POST['start'] : $_GET['start']);
        if($start == null || $start == ""){
            $start = 0;
        }
        $end = (integer) (isset($_POST['limit']) ? $_POST['limit'] : $_GET['limit']);
        if($end == null || $end == ""){
            $end = 15;
        }
        $qry = "CALL sp_inventario_grid_detalleinventario_limit('" . $pInventario . "',\"" . $pBarras . "\",\"" . $pDesConcepto . "\",\"" . $pConteos . "\",'" . $start . "','" . $end . "')";
        //echo $qry;
        $gBaseDatos = new ofiMySQLi();
        $gBaseDatos->conectar();
        $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
        while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
        {
            $nRow = $row;
            foreach($row as $key => $val)
            {
                $nRow[$key] = PonerAcentosHTML($val);
            }
            $arr[] = $nRow;
        }
        $jsonresult = JEncode($arr);
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        echo '({success: true, requestedId:"1", "total":"'.$nbrows.'","results":'.$jsonresult.'})';
    } else {
        echo '({success: true, requestedId:"1", "total":"0", "results":""})';
    }
}

function GridMovimientoxConcepto(){
    // OR = ||
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $pTipoKardex = isset($_REQUEST['pTipoKardex']) ? $_REQUEST['pTipoKardex']:"GENERAL";
    $pEmpresa = isset($_REQUEST['pEmpresa']) ? $_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS']) ? $_REQUEST['pIPS']:0;
    $pBodega = isset($_REQUEST['pBodega']) ? $_REQUEST['pBodega']:0;
    if($pBodega == null || $pBodega == ""){
        $pBodega = 0;
    }
    $pZona = isset($_REQUEST['pZona']) ? $_REQUEST['pZona']:0;
    if($pZona == null || $pZona == ""){
        $pZona = 0;
    }
    $pConcepto = isset($_REQUEST['pConcepto']) ? $_REQUEST['pConcepto']:0;
    $pLote = isset($_REQUEST['pLote']) ? $_REQUEST['pLote']:0;
    if($pTipoKardex == "GENERAL"){
        $pLote = 0;
    }
    $pUsaFec = isset($_REQUEST['pUsaFec']) ? $_REQUEST['pUsaFec']:"N";
    $pFecha = isset($_REQUEST['pFecha']) ? $_REQUEST['pFecha']:null;
    $qry = "CALL sp_inventario_movimientoxconcepto('" . $pEmpresa . "','" . $pIPS . "','" . $pBodega . "','" . $pZona . "','" . $pConcepto . "','" . $pLote . "',\"" . $pUsaFec . "\",\"" . $pFecha . "\")";
    //echo $qry;
    $CampoLlave = explode("^",$gBaseDatos->jasonSP_arreglo2011($qry));
    $nbrows = $CampoLlave[0];
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    if($nbrows>0){
        $start = (integer) (isset($_POST['start']) ? $_POST['start'] : $_GET['start']);
        if($start == null || $start == ""){
            $start = 0;
        }
        $end = (integer) (isset($_POST['limit']) ? $_POST['limit'] : $_GET['limit']);
        if($end == null || $end == ""){
            $end = 15;
        }
        $qry = "CALL sp_inventario_movimientoxconcepto_limit('" . $pEmpresa . "','" . $pIPS . "','" . $pBodega . "','" . $pZona . "','" . $pConcepto . "','" . $pLote . "',\"" . $pUsaFec . "\",\"" . $pFecha . "\",'" . $start . "','" . $end . "')";
        //echo $qry;
        $gBaseDatos = new ofiMySQLi();
        $gBaseDatos->conectar();
        $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
        while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
        {
            $nRow = $row;
            foreach($row as $key => $val)
            {
                $nRow[$key] = PonerAcentosHTML($val);
            }
            $arr[] = $nRow;
        }
        $jsonresult = JEncode($arr);
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        echo '({success: true, requestedId:"1", "total":"'.$nbrows.'","results":'.$jsonresult.'})';
    } else {
        echo '({success: true, requestedId:"1", "total":"0", "results":""})';
    }
}

function GridLotesxConcepto(){
    // OR = ||
    $pConcepto = isset($_REQUEST['pConcepto']) ? $_REQUEST['pConcepto']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_inventario_lotesxconcepto('" . $pConcepto . "')";
    //echo $qry;
    echo $gBaseDatos->jsonSP($qry,"R");
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
}

function SaldoGeneralxLote(){
    $gBaseDatos = new ofiMySQLi();
    $pLote = isset($_REQUEST['pLote']) ? $_REQUEST['pLote']:0;
    $gBaseDatos->conectar();
    $qry = "CALL sp_inventario_saldogeneralxlotexconcepto('" . $pLote . "')";
    //echo $qry;
    $CampoLlave = explode("^",$gBaseDatos->jasonSP_arreglo2011($qry));
    echo $CampoLlave[2];
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    
}

function SaldoxLote(){
    $gBaseDatos = new ofiMySQLi();
    $pEmpresa = isset($_REQUEST['pEmpresa']) ? $_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS']) ? $_REQUEST['pIPS']:0;
    $pBodega = isset($_REQUEST['pBodega']) ? $_REQUEST['pBodega']:0;
    if($pBodega == null || $pBodega == ""){
        $pBodega = 0;
    }
    $pZona = isset($_REQUEST['pZona']) ? $_REQUEST['pZona']:0;
    if($pZona == null || $pZona == ""){
        $pZona = 0;
    }
    $pLote = isset($_REQUEST['pLote']) ? $_REQUEST['pLote']:0;
    $gBaseDatos->conectar();
    $qry = "CALL sp_inventario_saldoxlotexconcepto('" . $pEmpresa . "','" . $pIPS . "','" . $pBodega . "','" . $pZona . "','" . $pLote . "')";
    echo $gBaseDatos->jasonSP_arreglo2011($qry);
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
}

function SaldoxConcepto(){
    $gBaseDatos = new ofiMySQLi();
    $pEmpresa = isset($_REQUEST['pEmpresa']) ? $_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS']) ? $_REQUEST['pIPS']:0;
    $pBodega = isset($_REQUEST['pBodega']) ? $_REQUEST['pBodega']:0;
    if($pBodega == null || $pBodega == ""){
        $pBodega = 0;
    }
    $pZona = isset($_REQUEST['pZona']) ? $_REQUEST['pZona']:0;
    if($pZona == null || $pZona == ""){
        $pZona = 0;
    }
    $pConcepto = isset($_REQUEST['pConcepto']) ? $_REQUEST['pConcepto']:0;
    $gBaseDatos->conectar();
    $qry = "CALL sp_inventario_saldoxconcepto('" . $pEmpresa . "','" . $pIPS . "','" . $pBodega . "','" . $pZona . "','" . $pConcepto . "')";
    echo $gBaseDatos->jasonSP_arreglo2011($qry);
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
}

function AdicionarLote(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS']) ? $_REQUEST['pIPS']:0;
    $pConcepto = isset($_REQUEST['pConcepto']) ? $_REQUEST['pConcepto']:0;
    $pLote = isset($_REQUEST['pLote']) ? $_REQUEST['pLote']:null;
    $pVencimiento = isset($_REQUEST['pVencimiento']) ? $_REQUEST['pVencimiento']:null;
    $pUsuario = isset($_REQUEST['pUsuario']) ? $_REQUEST['pUsuario']:0;
    $pNomBaseDatos = isset($_REQUEST['pNomBaseDatos'])?$_REQUEST['pNomBaseDatos']:"NA";
    if($pNomBaseDatos == "NA"){
        $gBaseDatos = new ofiMySQLi();
    }else{
        $gBaseDatos = new ofiMySQLi($pNomBaseDatos);
    }
    $gBaseDatos->conectar();
    $qry = "CALL sp_conceptos_addlote('" . $pConcepto . "',\"" . $pLote . "\",\"" . $pVencimiento . "\",'" . $pUsuario . "')";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function EliminarLote(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS']) ? $_REQUEST['pIPS']:0;
    $pLote = isset($_REQUEST['pLote']) ? $_REQUEST['pLote']:0;
    $pUsuario = isset($_REQUEST['pUsuario']) ? $_REQUEST['pUsuario']:0;
    $pMotivo = isset($_REQUEST['pMotivo']) ? $_REQUEST['pMotivo']:null;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_conceptos_dellote('" . $pEmpresa . "','" . $pIPS . "','" . $pLote . "','" . $pUsuario . "',\"" . $pMotivo . "\")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}


function AdicionaMovimiento(){
    $pEmpresa = isset($_REQUEST['pEmpresa']) ? $_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS']) ? $_REQUEST['pIPS']:0;
    $pTipoMovimiento = isset($_REQUEST['pTipoMovimiento']) ? $_REQUEST['pTipoMovimiento']:0;
    $pBodega = isset($_REQUEST['pBodega']) ? $_REQUEST['pBodega']:0;
    $pZona = isset($_REQUEST['pZona']) ? $_REQUEST['pZona']:0;
    $pFechaMovimiento = isset($_REQUEST['pFechaMovimiento']) ? $_REQUEST['pFechaMovimiento']:0;
    $pFechaCompra = isset($_REQUEST['pFechaCompra']) ? $_REQUEST['pFechaCompra']:null;
    $pProveedor = isset($_REQUEST['pProveedor']) ? $_REQUEST['pProveedor']:null;
    $pFacturaCompra = isset($_REQUEST['pFacturaCompra']) ? $_REQUEST['pFacturaCompra']:null;
    $pUsuario = isset($_REQUEST['pUsuario']) ? $_REQUEST['pUsuario']:null;
    $pEstado = isset($_REQUEST['pEstado']) ? $_REQUEST['pEstado']:null;
    $pBodegaDestino = isset($_REQUEST['pBodegaDestino']) ? $_REQUEST['pBodegaDestino']:null;
    $pZonaDestino = isset($_REQUEST['pZonaDestino']) ? $_REQUEST['pZonaDestino']:null;
    $pMotivoBaja = isset($_REQUEST['pMotivoBaja']) ? $_REQUEST['pMotivoBaja']:null;
    $pTipoAjuste = isset($_REQUEST['pTipoAjuste']) ? $_REQUEST['pTipoAjuste']:null;
    $pMotivoAjuste = isset($_REQUEST['pMotivoAjuste']) ? $_REQUEST['pMotivoAjuste']:null;
    $CodInsercion = "PRS-" . $pIdEmpresa . "-SED-" . $pIdSede . "-IPS-" . $pIdIPS . "-USR-" . $pUsuario . "-TMOV-" . $pTipoMovimiento . "-BOD-" . $pBodega . "-ZONA-" . $pZona . "-CONS-" . date("His");
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_inventario_movimientos_add(\"" . $CodInsercion  . "\",'" . $pEmpresa . "','" . $pIPS . "','" . $pTipoMovimiento . "','" . $pBodega . "','" . $pZona . "',\"" . $pFechaMovimiento . "\",\"" . $pFechaCompra . "\",'" . $pProveedor . "','" . $pFacturaCompra . "','" . $pUsuario . "','" . $pEstado . "','" . $pBodegaDestino . "','" . $pZonaDestino . "','" . $pMotivoBaja . "','" . $pTipoAjuste . "','" . $pMotivoAjuste . "')";
    //echo $qry;
    echo $gBaseDatos->jasonSP_arreglo($qry);
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
}

function ListarDetalleMovimientos(){
    $pMovimiento = isset($_REQUEST['pMovimiento'])?$_REQUEST['pMovimiento']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_inventario_movimientos_detalle_listar('" . $pMovimiento . "')";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = PonerAcentosHTML($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}

function AdicionaMovimientoDetalle(){
    $pItem = isset($_REQUEST['pItem']) ? $_REQUEST['pItem']:0;
    $pEntrada = isset($_REQUEST['pEntrada']) ? $_REQUEST['pEntrada']:0;
    $pSalida = isset($_REQUEST['pSalida']) ? $_REQUEST['pSalida']:0;
    $pVlrCompra = isset($_REQUEST['pVlrCompra']) ? $_REQUEST['pVlrCompra']:0;
    $pMovimiento = isset($_REQUEST['pMovimiento']) ? $_REQUEST['pMovimiento']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_inventario_movimientos_detalle_add('" . $pItem . "','" . $pEntrada . "','" . $pSalida . "','" . $pVlrCompra . "','" . $pMovimiento . "')";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}


function EliminarMovimientoDetalle(){
    $pConsecutivo = isset($_REQUEST['pConsecutivo'])?$_REQUEST['pConsecutivo']:null;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_inventario_movimientos_detalle_del('" . $pConsecutivo . "')";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function Aplicar_Movimiento(){
    $pMovimiento = isset($_REQUEST['pMovimiento'])?$_REQUEST['pMovimiento']:null;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_inventarios_movimientos_aplicar('" . $pMovimiento . "','" . $_SESSION['ID_USUARIO'] . "')";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function AplicarMovimientoDispensacion(){
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:null;
    $pBodega = isset($_REQUEST['pBodega'])?$_REQUEST['pBodega']:null;
    $pZona = isset($_REQUEST['pZona'])?$_REQUEST['pZona']:null;
    $pUsuario = isset($_SESSION['ID_USUARIO'])?$_SESSION['ID_USUARIO']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_inventarios_movimientos_dispensacion_aplicar('" . $pCAS . "','" . $pBodega . "','" . $pZona . "','" . $pUsuario . "')";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

?>
