<?php

/*
* @category    Controladora  Tipo Componente
* @package     OfiClinic Web
* @author      Héctor Iván Ramírez Cardona<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

require("../../../core/php/_database.php");
require("../../../core/php/php_functions.php");

$task = isset($_REQUEST['task'])?$_REQUEST['task']:0;
switch($task){
    case "LISTAR":
        Listar();
        break;  
     case "ELIMINAR":
        Eliminar();
        break;
         case "INSERTAR":
        Insertar();
        break;
       case "MODIFICAR":
         Modificar();
        break;
    default:
        echo "{failure:true}";
        break;
}

/**
    *  Pre:---
    *  Post: ---
    *  Return: --- 
    *  Resumen:permite registrar un tipo de comoponente a la base de dato
**/

function Insertar()
{
    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_fecprogramacion_insertar (" . spParametros($estructura,"NO") . ")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

/**
    *  Pre:---
    *  Post: ---
    *  Return: --- 
    *  Resumen:permite modificar un tipo de comoponente de la base de dato
**/

function Modificar()
{
    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_bio_tipoequipo_actualizar(" . spParametros($estructura,"NO") . ")";
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

/**
    *  Pre:---
    *  Post: ---
    *  Return: --- 
    *  Resumen:permite eliminar un tipo de comoponente de la base de dato
**/

function Eliminar()
{
    $pIdFichaTecnica = isset($_REQUEST['pIdTipoEquipo'])?$_REQUEST['pIdTipoEquipo']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_bio_tipoequipo_borrar('" . $pIdFichaTecnica . "')";
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo '1';
    else
        echo '0';
    $gBaseDatos->cerrar();
}

/**
    *  Pre:---
    *  Post: ---
    *  Return: --- 
    *  Resumen:permite listar todos los diferentes tipos de componentes de la base de dato
**/

function Listar()
{
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    
    $pKardexProgramacion=isset($_REQUEST['pKardexProgramacion']) ? $_REQUEST['pKardexProgramacion'] : null;
    $qryDetalle = isset($_REQUEST['query']) ? $_REQUEST['query'] : null;
    if (is_null($qryDetalle) || $qryDetalle == "")
        $qryDetalle = "Todos";
    $qry = "CALL sp_kardexprogramacion_listar(\"" . $pKardexProgramacion . "\",\"" . $qryDetalle . "\")";
    $CampoLlave = explode("^",$gBaseDatos->jasonSP_arreglo2011($qry));
    $nbrows = $CampoLlave[0];
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    if($nbrows>0){
        $gBaseDatos->conectar();
        $start = (integer) (isset($_POST['start']) ? $_POST['start'] : $_GET['start']);
        $end = (integer) (isset($_POST['limit']) ? $_POST['limit'] : $_GET['limit']);
        $qry = "CALL sp_kardexprogramacion_listar_limit(\"" . $pKardexProgramacion . "\",\"" . $qryDetalle . "\",'" . $start . "','" . $end . "')";
        $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
        $arr = array();
        while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
        {
            $nRow = $row;
            foreach($row as $key => $val)
            {
                $nRow[$key] = PonerAcentosHTML($val);
            }
            $arr[] = $nRow;
        }
        $jsonresult = JEncode($arr);
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        echo '({"total":"'.$nbrows.'","results":'.$jsonresult.'})';
    } else {
        echo '({"total":"0", "results":""})';
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
}

?>