<?php
    require_once('../../../lib/tcpdf/config/lang/spa.php');
    require_once('../../../lib/tcpdf/tcpdf.php');
    require("../../../core/php/_database.php");
    require("../../../core/php/php_functions.php");
    require("../../../core/php/constantes.php");
    header('Content-type: application/pdf; charset: UTF-8');
    
    session_start();
    //Variables;
    $pImprimeTirilla = pImprimeTirilla;
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pTratamiento = isset($_REQUEST['pTratamiento'])?$_REQUEST['pTratamiento']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pNomCliente = isset($_REQUEST['pNomCliente'])?$_REQUEST['pNomCliente']:null;
    $pCliente = isset($_REQUEST['pCliente'])?$_REQUEST['pCliente']:0;
    $pPlan = isset($_REQUEST['pPlan'])?$_REQUEST['pPlan']:0;
    $pSubPlan = isset($_REQUEST['pSubPlan'])?$_REQUEST['pSubPlan']:0;
    $pTipoLegalizacion = isset($_REQUEST['pTipoLegalizacion'])?$_REQUEST['pTipoLegalizacion']:null;
    $pPrefijo = isset($_REQUEST['pPrefijo'])?$_REQUEST['pPrefijo']:null;
    $pNroDocumento = isset($_REQUEST['pNroDocumento'])?$_REQUEST['pNroDocumento']:null;
    $pFechaDocumento = isset($_REQUEST['pFechaDocumento'])?$_REQUEST['pFechaDocumento']:null;
    $pNroResolucion = isset($_REQUEST['pNroResolucion'])?$_REQUEST['pNroResolucion']:null;
    $pFechaVencimiento = isset($_REQUEST['pFechaVencimiento'])?$_REQUEST['pFechaVencimiento']:null;
    $pConcepto = isset($_REQUEST['pConcepto'])?$_REQUEST['pConcepto']:null;
    $pVlrTotal = isset($_REQUEST['pVlrTotal'])?$_REQUEST['pVlrTotal']:0;
    $pVlrIVA = isset($_REQUEST['pVlrIVA'])?$_REQUEST['pVlrIVA']:0;
    $pVlrCuotaModeradora = isset($_REQUEST['pVlrCuotaModeradora'])?$_REQUEST['pVlrCuotaModeradora']:0;
    $pVlrCopagos = isset($_REQUEST['pVlrCopagos'])?$_REQUEST['pVlrCopagos']:0;
    $pVlrDescuentos = isset($_REQUEST['pVlrDescuentos'])?$_REQUEST['pVlrDescuentos']:0;
    $pVlrNeto = isset($_REQUEST['pVlrNeto'])?$_REQUEST['pVlrNeto']:0;
    $pAnulada = isset($_REQUEST['pAnulada'])?$_REQUEST['pAnulada']:null;
    $pUsuarioAnula = isset($_REQUEST['pUsuarioAnula'])?$_REQUEST['pUsuarioAnula']:0;
    $pMotivoAnula = isset($_REQUEST['pMotivoAnula'])?$_REQUEST['pMotivoAnula']:null;
    $pFechaAnula = isset($_REQUEST['pFechaAnula'])?$_REQUEST['pFechaAnula']:null;
    $pUsuarioFactura = isset($_REQUEST['pUsuarioFactura'])?$_REQUEST['pUsuarioFactura']:null;
    $pAnulada = isset($_REQUEST['pAnulada'])?$_REQUEST['pAnulada']:0;
    $pControlSalto = 30;
    
    //Definicion de las Margenes
    $LeftMargin = PDF_MARGIN_LEFT;
    $TopMargin = PDF_MARGIN_TOP;
    $RightMargin = PDF_MARGIN_RIGHT;
    $HeaderMargin = PDF_MARGIN_HEADER;
    $BottomMargin = PDF_MARGIN_BOTTOM;
    $FooterMargin = PDF_MARGIN_FOOTER;
    $Alineacion = "P";
    $FormatoPagina = "CARTA";
    $UsaPiePagina = "SI";
    
    $gBaseDatos = new ofiMySQLi(); //CARGAR DATOS DE LA IPS
    $gBaseDatos->conectar();
    $qry = "CALL sp_ips_getdatabasico('" . $_SESSION['ID_IPS']. "')";
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    while ($rowIPS[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $ipsNOM = $rowIPS[0]["Descripcion"];
    $ipsCODMUNI = $rowIPS[0]["IdMunicipio"];
    $ipsDIR = $rowIPS[0]["Direccion"];
    $ipsTEL = $rowIPS[0]["Telefono"];
        
    if($_SESSION['ImprimeRCTirilla']==0){
        //Inicializacion de la Clase
        $FormatoPagina = "MEDIACARTA";
        $Alineacion = "L";
        $UsaPiePagina = "SI";
        $pTipoEncabezado = "MC";
        $pTipoEncabezado = "FVP";
        $pdf = new TCPDF($Alineacion, PDF_UNIT, $FormatoPagina, true, 'UTF-8', false);
        //Inicializacion Variables de Control
        $pdf->pAlineacionEncabezado = $Alineacion;
        //$pdf->pTituloInforme = "RECIBO PROVISIONAL DE CAJA";
        $pdf->pTituloInforme = "RECIBO PROVISIONAL DE CAJA";
        $pdf->pImprimeLogo = "NO";
        $pdf->pAnchoTxtPagina = 210;
        $pdf->pNomEmpresa = $_SESSION['NOM_EMPRESA'];
        $pdf->pTDocEmpresa = $_SESSION['EMPRESA_TDOC'];
        $pdf->pDocEmpresa = $_SESSION['EMPRESA_DOC'];
        $pdf->pDirEmpresa = $ipsDIR;
        $pdf->pTelEmpresa = $ipsTEL;
        $pdf->pCiuEmpresa = $ipsNOM;
        $pdf->pEspEmpresa = $_SESSION['EMPRESA_ESP'];
        $pdf->pTipoEncabezado = $pTipoEncabezado;
        $pdf->pNomSede = $_SESSION['EMPRESA_DOC'];
        $pdf->pNomIPS = $_SESSION['NOM_IPS'];
        $pdf->pMargenPie = -20;
        $pdf->pLogoCliente = "../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/logoenc.gif";
        $pdf->pPrefijo = $pPrefijo;
        $pdf->pNroDocumento = $pNroDocumento;
        $pdf->pFechaDoc = $pFechaDocumento;
        $pdf->pCAS = $pCAS;
        $pdf->pTratamiento = $pTratamiento;
        $pdf->pUsaPie = $UsaPiePagina;

        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('Sistemas Ofisalud © - 2006');
        $pdf->SetTitle('MOVIMIENTO DE CAJA');
        $pdf->SetSubject('ReciboProvisionalCaja-MC');

        $pdf->SetHeaderData($pdf->pLogoCliente, PDF_HEADER_LOGO_WIDTH, $pdf->pTituloInforme, PDF_HEADER_STRING);
        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
        $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
        $pdf->SetMargins($LeftMargin, $TopMargin, $RightMargin);
        $pdf->SetHeaderMargin($HeaderMargin);
        $pdf->SetFooterMargin($FooterMargin);
        $pdf->SetAutoPageBreak(TRUE, $BottomMargin);
        $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
        $pdf->setLanguageArray($l);
        $pdf->setFontSubsetting(true);
        $pdf->SetFont('dejavusans', '', 14, '', true);
        
        EncabezadoPagina($pdf, $pPaciente, $pCliente, $pPlan, $pSubPlan);
        
        // Cargar Detalle CAS
        $gBaseDatos->conectar();
        $qry = "CALL sp_estudios_detalle_buscarxid('" . $pCAS . "')";
        $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
        while ($row = @mysqli_fetch_row($gBaseDatos->QryID))
        {
            $pdf->MultiCell(30,$rowcount,utf8_decode($row[1]),0,'L',0,0);
            $pdf->MultiCell(168,$rowcount,utf8_decode($row[2]),0,'L',0,0);
            $pdf->Ln(4);
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $pPaciente, $pCliente, $pPlan, $pSubPlan);
            }
        }
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        $pdf->Ln(5);
        if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
            EncabezadoPagina($pdf, $pPaciente, $pCliente, $pPlan, $pSubPlan);
        }
        $pdf->SetLineWidth(0.3); 
        $pdf->Line($pdf->GetX(), $pdf->GetY(), $pdf->GetX()+200, $pdf->GetY()); 
        if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
            EncabezadoPagina($pdf, $pPaciente, $pCliente, $pPlan, $pSubPlan);
        }
        $pdf->Ln(1);
        $pdf->MultiCell(198,5,"VALOR TOTAL $" .number_format($pVlrNeto,2,".",","),0,'R',0,0);
        if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
            EncabezadoPagina($pdf, $pPaciente, $pCliente, $pPlan, $pSubPlan);
        }
        $pdf->Ln(4);
        if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
            EncabezadoPagina($pdf, $pPaciente, $pCliente, $pPlan, $pSubPlan);
        }
        $val = strtoupper(utf8_decode(numerotexto($pVlrNeto)));
        $pdf->MultiCell(198,10,"SON: " . $val . " PESOS MCTE.",0,'L',0,0);
        if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
            EncabezadoPagina($pdf, $pPaciente, $pCliente, $pPlan, $pSubPlan);
        }
        $pdf->Ln(7);
        if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
            EncabezadoPagina($pdf, $pPaciente, $pCliente, $pPlan, $pSubPlan);
        }
        $pdf->SetTextColor(127);
        $pdf->SetFont(PDF_FONT_NAME_MAIN,'B',13);
        $pdf->MultiCell(198,10,"DOCUMENTO NO VALIDO COMO AUTORIZACION DE SERVICIOS",0,'L',0,0);
        
        $pdf->Output('ReciboProvisionalCajaMC.pdf', 'I');
    }else{
        $FormatoPagina = "TIRILLA";
        $Alineacion = "P";
        $UsaPiePagina = "NO";
        $pTipoEncabezado = "FVP";
        $LeftMargin = 1;
        $TopMargin = 5; //Este Margen es para empezar nueva pagina
        $RightMargin = 1;
        $HeaderMargin = 0.5;
        $BottomMargin = 1;
        $FooterMargin = 3.5;
        //Inicializacion de la Clase
        $pdf = new TCPDF($Alineacion, PDF_UNIT, $FormatoPagina, true, 'UTF-8', false);
        //Inicializacion Variables de Control
        $pdf->pAlineacionEncabezado = $Alineacion;
        $pdf->pTituloInforme = "MOVIMIENTO DE CAJA";
        $pdf->pImprimeLogo = "NO";
        $pdf->pAnchoTxtPagina = 210;
        $pdf->pNomEmpresa = $_SESSION['NOM_EMPRESA'];
        $pdf->pTDocEmpresa = $_SESSION['EMPRESA_TDOC'];
        $pdf->pDocEmpresa = $_SESSION['EMPRESA_DOC'];
        $pdf->pDirEmpresa = $_SESSION['EMPRESA_DIR'];
        $pdf->pTelEmpresa = $_SESSION['EMPRESA_TEL'];
        $pdf->pCiuEmpresa = $_SESSION['EMPRESA_CIU'];
        $pdf->pEspEmpresa = $_SESSION['EMPRESA_ESP'];
        $pdf->pRegEmpresa = $_SESSION['EMPRESA_REGIMEN'];
        $pdf->pContribuyentes = $_SESSION['EMPRESA_CONTRIBUYENTE'];
        $pdf->pReteIVA  = $_SESSION['EMPRESA_RTEICA'];
        $pdf->pReteICA = $_SESSION['EMPRESA_RTEIVA'];

        $pdf->pTipoEncabezado = $pTipoEncabezado;
        $pdf->pNomSede = $_SESSION['EMPRESA_DOC'];
        $pdf->pNomIPS = $_SESSION['NOM_IPS'];
        $pdf->pMargenPie = -20;
        $pdf->pLogoCliente = "../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/logoenc.gif";
        $pdf->pPrefijo = $pPrefijo;
        $pdf->pNroDocumento = str_pad($pNroDocumento, 7, "0", STR_PAD_LEFT);
        $pdf->pNroResolucion = $pNroResolucion;
        $pdf->pFechaDoc = $pFechaDocumento;
        $pdf->pCAS = $pCAS;
        $pdf->pTratamiento = $pTratamiento;
        $pdf->pUsaPie = $UsaPiePagina;

        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('Sistemas Ofisalud © - 2006');
        $pdf->SetTitle('MOVIMIENTO DE CAJA');
        $pdf->SetSubject('ReciboProvisionalCaja-MC');

        $pdf->SetHeaderData($pdf->pLogoCliente, PDF_HEADER_LOGO_WIDTH, $pdf->pTituloInforme, PDF_HEADER_STRING);
        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
        $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
        $pdf->SetMargins($LeftMargin, $TopMargin, $RightMargin);
        $pdf->SetHeaderMargin($HeaderMargin);
        $pdf->SetFooterMargin($FooterMargin);
        // set bacground image

        $pdf->SetAutoPageBreak(TRUE, $BottomMargin);
        $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
        $pdf->setLanguageArray($l);
        $pdf->setFontSubsetting(true);
        $pdf->SetFont('dejavusans', '', 12, '', true);

        $pdf->AddPage();
        if ($pAnulada == 1){
            $img_file = "../../../resources/varios/docanulado.png";
            $pdf->Image($img_file, 110, 8, 80, 50, '', '', '', false, 300, '', false, false, 0);
            $pdf->Image($img_file, 110, 215, 80, 50, '', '', '', false, 300, '', false, false, 0);
        }
        $pdf->Ln(2);
        //$pdf->SetFont(PDF_FONT_NAME_MAIN, 'B', 9);
        $pdf->SetFont('courier', 'B', 9);
        $EncabezadoHTML = '<table cellspacing="0" border="0" style="font-size:22px; color:#000;">';
        $EncabezadoHTML .= '<tr>';
        $EncabezadoHTML .= '<td align="center">';
        $EncabezadoHTML .= '<span style="font-size:44px; color:#000; font-weight:bold">' . ($pdf->pNomEmpresa) . '</span><br>';
        if($pdf->pEspEmpresa != null || $pdf->pEspEmpresa != "")
                $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . utf8_decode($pdf->pEspEmpresa) . '</span><br>';
        if($pdf->pTDocEmpresa == "NI")
            $tipodoc = "NIT: ";
        else
            $tipodoc = $pdf->pTDocEmpresa . ": ";
        $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $tipodoc . $pdf->pDocEmpresa . '</span><br>';
        $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $pdf->pDirEmpresa . ' - ' . $pdf->pTelEmpresa . '</span><br>';
        $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $pdf->pCiuEmpresa . '</span><br>';
        if($pdf->pRegEmpresa != ""){
            $EncabezadoHTML .= '<span style="font-size:30px; color:#000; font-weight:bold">' . $pdf->pRegEmpresa . '</span><br>';
        }
        if($pdf->pContribuyentes != ""){
            $EncabezadoHTML .= '<span style="font-size:30px; color:#000; font-weight:bold">' . $pdf->pContribuyentes . '</span><br>';
        }
        if($pdf->pReteIVA != ""){
            $EncabezadoHTML .= '<span style="font-size:30px; color:#000; font-weight:bold">' . $pdf->pReteIVA . '</span><br>';
        }
        if($pdf->pReteICA != ""){
            $EncabezadoHTML .= '<span style="font-size:30px; color:#000; font-weight:bold">' . $pdf->pReteICA . '</span><br>';
        }
        $EncabezadoHTML .= '<br>';
        $EncabezadoHTML .= '<span align="rigth" style="font-size:44px; color:#000; font-weight:bold">RECIBO DE CAJA</span><br>';
        $EncabezadoHTML .= '<span align="rigth" style="font-size:40px; color:#000; font-weight:bold">Nro: ' . $pdf->pPrefijo . "-" . $pdf->pNroDocumento . '</span><br>';
        $EncabezadoHTML .= '<span align="rigth" style="font-size:40px; color:#000; font-weight:bold">Fecha:' . $pdf->pFechaDoc . '</span><br>';
        $EncabezadoHTML .= '</td>';
        $EncabezadoHTML .= '</tr>';
        $EncabezadoHTML .= '<hr>';
        $pdf->writeHTML($EncabezadoHTML, true, false, false, false, '');
        $EncabezadoHTML = '<table cellspacing="0" border="0" style="font-size:22px; color:#000;">';
        $EncabezadoHTML .= '<tr>';
        $EncabezadoHTML .= '<td>';
        $gBaseDatos = new ofiMySQLi();
        // Cargar Datos del Paciente
        $gBaseDatos->conectar();
        $qry = "CALL sp_pacientes_buscarxid('" . $pPaciente . "')";
        $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
        while ($row = @mysqli_fetch_row($gBaseDatos->QryID))
        {
            $EncabezadoHTML .= '<span align="left" style="font-size:34px; color:#000;"><b>Paciente:</b> ' . utf8_decode($row[1]) . " " . utf8_decode($row[2]) .  " - " . utf8_decode($row[5]) . " " . utf8_decode($row[6]) . " " . utf8_decode($row[3]) . " " . utf8_decode($row[4]) . '</span><br>';
            $EncabezadoHTML .= '<span align="left" style="font-size:34px; color:#000;"><b>Dirección:</b> ' . utf8_decode($row[10]) . '</span><br>';
            $EncabezadoHTML .= '<span align="left" style="font-size:34px; color:#000;"><b>Teléfono:</b> ' . utf8_decode($row[11]) . " - " . utf8_decode($row[12]) . '</span><br>';
        }
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        $EncabezadoHTML .= '</td>';
        $EncabezadoHTML .= '</tr>';

        // Cargar Datos del Cliente
        $EncabezadoHTML .= '<tr>';
        $EncabezadoHTML .= '<td>';
        $gBaseDatos->conectar();
        $qry = "CALL sp_clientes_buscarxid('" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "')";
        $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
        while ($row = @mysqli_fetch_row($gBaseDatos->QryID))
        {
            $EncabezadoHTML .= '<span align="left" style="font-size:34px; color:#000;"><b>Entidad:</b> ' . utf8_decode($row[0]) . '</span><br>';
            $EncabezadoHTML .= '<span align="left" style="font-size:34px; color:#000;"><b>Plan:</b> ' . utf8_decode($row[1]) . '</span><br>';
            $EncabezadoHTML .= '<span align="left" style="font-size:34px; color:#000;"><b>SubPlan:</b> ' . utf8_decode($row[2]) . '</span><br>';
        }
        $EncabezadoHTML .= '</td>';
        $EncabezadoHTML .= '</tr>';
        $EncabezadoHTML .= '</table>';
        $pdf->writeHTML($EncabezadoHTML, true, false, false, false, '');
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        $pdf->Ln(-3);
        $pdf->SetLineWidth(0.3); 
        $pdf->Line($pdf->GetX(), $pdf->GetY(), $pdf->GetX()+70, $pdf->GetY()); 
        $EncabezadoHTML = '<span align="center" style="font-size:34px; color:#000; font-weight:bold"><b>DETALLE</b></span><br>';
        $pdf->writeHTML($EncabezadoHTML, true, false, false, false, '');
        $pdf->SetLineWidth(0.3); 
        $pdf->Ln(-3);
        $pdf->Line($pdf->GetX(), $pdf->GetY(), $pdf->GetX()+70, $pdf->GetY()); 
        $pdf->Ln(1);

        // Cargar Detalle CAS
        $gBaseDatos->conectar();
        $qry = "CALL sp_estudios_detalle_buscarxid('" . $pCAS . "')";
        $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
        $EncabezadoHTML = '<table cellspacing="0" border="0" style="font-size:22px; color:#000;">';
        $EncabezadoHTML .= '<tr>';
        $EncabezadoHTML .= '<td>';
        while ($row = @mysqli_fetch_row($gBaseDatos->QryID))
        {
            $EncabezadoHTML .= '<span align="left" style="font-size:34px; color:#000;">' . utf8_decode($row[1]) . " - " . utf8_decode($row[2]) . '</span><br>';
        }
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        $EncabezadoHTML .= '</td>';
        $EncabezadoHTML .= '</tr>';
        $EncabezadoHTML .= '</table>';
        $pdf->writeHTML($EncabezadoHTML, true, false, false, false, '');
        $val = strtoupper(utf8_decode(numerotexto($pVlrNeto)));
        $EncabezadoHTML = '<table border="1" cellspacing="0" >
            <tr>
                <td width="225">
                    <table border="0" cellspacing="0">
                        <tr>
                            <td width="100">TOTAL:</td>
                            <td width="110" align="rigth">$ ' . number_format($pVlrNeto,2,".",",") . '</td>
                        </tr>
                    </table>
                </td>
            </tr>
            <tr>
                <td>' . '<span align="justify" style="font-size:30px; color:#000;">SON: '. $val . ' PESOS M/CTE.</span></td>
            </tr>
        </table>
        <span align="justify" style="font-size:34px; color:#000;">DOCUMENTO NO VALIDO COMO AUTORIZACION DE SERVICIOS</span>';
        $pdf->writeHTML($EncabezadoHTML, true, false, false, false, '');
        $pdf->Output('ReciboProvisionalCajaMC.pdf', 'I');
    }
    
    function EncabezadoPagina(&$pdf, $pPaciente, $pCliente, $pPlan, $pSubPlan){
        $pdf->AddPage();
        if ($pAnulada == 1){
            $img_file = "../../../resources/varios/docanulado.png";
            $pdf->Image($img_file, 110, 8, 80, 50, '', '', '', false, 300, '', false, false, 0);
            //$pdf->Image($img_file, 110, 215, 80, 50, '', '', '', false, 300, '', false, false, 0);
        }
        $pdf->Ln(-12);
        $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
        $EncabezadoHTML = '<table cellspacing="0" border="0" style="font-size:24px; color:#000;">';
        $EncabezadoHTML .= '<tr><td></td><td height="5" style="font-size:14px; color:#000;" align="rigth"></td></tr>';
        $EncabezadoHTML .= '<tr>';
        $EncabezadoHTML .= '<td>';
        $EncabezadoHTML .= '<span style="font-size:44px; color:#000; font-weight:bold">' . ($pdf->pNomEmpresa) . '</span><br>';
        if($pdf->pEspEmpresa != null || $pdf->pEspEmpresa != "")
                $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . utf8_decode($pdf->pEspEmpresa) . '</span><br>';
        if($pdf->pTDocEmpresa == "NI")
            $tipodoc = "NIT: ";
        else
            $tipodoc = $pdf->pTDocEmpresa . ": ";
        $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $tipodoc . $pdf->pDocEmpresa . '</span><br>';
        $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $pdf->pDirEmpresa . ' - ' . $pdf->pTelEmpresa . '</span><br>';
        $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $pdf->pCiuEmpresa . '</span><br>';
        $EncabezadoHTML .= '</td>';

        //COL2
        $EncabezadoHTML .= '<td>';
        $EncabezadoHTML .= '<span align="rigth" style="font-size:44px; color:#000; font-weight:bold">RECIBO DE CAJA</span><br>';
        $EncabezadoHTML .= '<span align="rigth" style="font-size:40px; color:#000; font-weight:bold">Nro: ' . $pdf->pPrefijo . "-" . $pdf->pNroDocumento . '</span><br>';
        $EncabezadoHTML .= '<span align="rigth" style="font-size:40px; color:#000; font-weight:bold">Fecha:' . $pdf->pFechaDoc . '</span><br>';
        $EncabezadoHTML .= '</td>';

        $EncabezadoHTML .= '</tr>';
        $EncabezadoHTML .= '</table>';
        $EncabezadoHTML .= '<hr>';
        $pdf->writeHTML($EncabezadoHTML, true, false, false, false, '');
        $gBaseDatos = new ofiMySQLi();
        // Cargar Datos del Paciente
        $gBaseDatos->conectar();
        $qry = "CALL sp_pacientes_buscarxid('" . $pPaciente . "')";
        $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
        while ($row = @mysqli_fetch_row($gBaseDatos->QryID))
        {
            $pdf->SetFont(PDF_FONT_NAME_MAIN,'',10);
            $pdf->MultiCell(17,5,"Paciente:",0,'L',0,0);
            $pdf->MultiCell(178,5,utf8_decode($row[1]) . " " . utf8_decode($row[2]) .  " - " . utf8_decode($row[5]) . " " . utf8_decode($row[6]) . " " . utf8_decode($row[3]) . " " . utf8_decode($row[4]),0,'L',0,0);
            $pdf->Ln(4);
            $rowcount = $pdf->getNumLines(utf8_decode($row[10]), 80) * 3;
            $pdf->MultiCell(18,$rowcount,"Dirección:",0,'L',0,0);
            $pdf->MultiCell(78,$rowcount,utf8_decode($row[10]),0,'L',0,0);
            $pdf->MultiCell(18,$rowcount,"Teléfono:",0,'L',0,0);
            $pdf->MultiCell(78,$rowcount,utf8_decode($row[11]) . " - " . utf8_decode($row[12]),0,'L',0,0);
            $pdf->Ln(4);

        }
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();

        // Cargar Datos del Cliente
        $gBaseDatos->conectar();
        $qry = "CALL sp_clientes_buscarxid('" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "')";
        $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
        while ($row = @mysqli_fetch_row($gBaseDatos->QryID))
        {
            $pdf->MultiCell(18,$rowcount,"Entidad:",0,'L',0,0);
            $pdf->MultiCell(78,$rowcount,utf8_decode($row[0]),0,'L',0,0);
            $pdf->Ln(4);
            $pdf->MultiCell(18,$rowcount,"Plan:",0,'L',0,0);
            $pdf->MultiCell(78,$rowcount,utf8_decode($row[1]),0,'L',0,0);
            $pdf->MultiCell(18,$rowcount,"SubPlan:",0,'L',0,0);
            $pdf->MultiCell(78,$rowcount,utf8_decode($row[2]),0,'L',0,0);
            $pdf->Ln(4);
        }
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        $pdf->SetLineWidth(0.3); 
        $pdf->Line($pdf->GetX(), $pdf->GetY(), $pdf->GetX()+200, $pdf->GetY()); 
        $pdf->SetFont(PDF_FONT_NAME_MAIN,'B',11);
        $pdf->MultiCell(200,5,"DETALLE",0,'C',0,0);
        $pdf->Ln(5);
        $pdf->SetLineWidth(0.3); 
        $pdf->Line($pdf->GetX(), $pdf->GetY(), $pdf->GetX()+200, $pdf->GetY()); 
        $pdf->Ln(1);
        $pdf->SetFont(PDF_FONT_NAME_MAIN,'',10);
    }
?>