<?php
    require_once('../../../lib/tcpdf/config/lang/spa.php');
    require_once('../../../lib/tcpdf/tcpdf.php');
    require("../../../core/php/_database.php");
    require("../../../core/php/php_functions.php");
    require("../../../core/php/constantes.php");
    //header('Content-type: application/pdf; charset: UTF-8');
    
    session_start();
    //echo $_SESSION['EMPRESA_REG'];
    //Variables;
    $pImprimeTirilla = pImprimeTirilla;
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pTratamiento = isset($_REQUEST['pTratamiento'])?$_REQUEST['pTratamiento']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pNomCliente = isset($_REQUEST['pNomCliente'])?$_REQUEST['pNomCliente']:null;
    $pCliente = isset($_REQUEST['pCliente'])?$_REQUEST['pCliente']:0;
    $pPlan = isset($_REQUEST['pPlan'])?$_REQUEST['pPlan']:0;
    $pSubPlan = isset($_REQUEST['pSubPlan'])?$_REQUEST['pSubPlan']:0;
    $pTipoLegalizacion = isset($_REQUEST['pTipoLegalizacion'])?$_REQUEST['pTipoLegalizacion']:null;
    $pPrefijo = isset($_REQUEST['pPrefijo'])?$_REQUEST['pPrefijo']:null;
    $pNroDocumento = isset($_REQUEST['pNroDocumento'])?$_REQUEST['pNroDocumento']:null;
    $pFechaDocumento = isset($_REQUEST['pFechaDocumento'])?$_REQUEST['pFechaDocumento']:null;
    $pNroResolucion = isset($_REQUEST['pNroResolucion'])?$_REQUEST['pNroResolucion']:null;
    $pFechaVencimiento = isset($_REQUEST['pFechaVencimiento'])?$_REQUEST['pFechaVencimiento']:null;
    $pConcepto = isset($_REQUEST['pConcepto'])?$_REQUEST['pConcepto']:null;
    $pVlrTotal = isset($_REQUEST['pVlrTotal'])?$_REQUEST['pVlrTotal']:0;
    $pVlrIVA = isset($_REQUEST['pVlrIVA'])?$_REQUEST['pVlrIVA']:0;
    $pVlrCuotaModeradora = isset($_REQUEST['pVlrCuotaModeradora'])?$_REQUEST['pVlrCuotaModeradora']:0;
    $pVlrCopagos = isset($_REQUEST['pVlrCopagos'])?$_REQUEST['pVlrCopagos']:0;
    $pVlrDescuentos = isset($_REQUEST['pVlrDescuentos'])?$_REQUEST['pVlrDescuentos']:0;
    $pVlrNeto = isset($_REQUEST['pVlrNeto'])?$_REQUEST['pVlrNeto']:0;
    $pAnulada = isset($_REQUEST['pAnulada'])?$_REQUEST['pAnulada']:null;
    $pUsuarioAnula = isset($_REQUEST['pUsuarioAnula'])?$_REQUEST['pUsuarioAnula']:0;
    $pMotivoAnula = isset($_REQUEST['pMotivoAnula'])?$_REQUEST['pMotivoAnula']:null;
    $pFechaAnula = isset($_REQUEST['pFechaAnula'])?$_REQUEST['pFechaAnula']:null;
    $pUsuarioFactura = isset($_REQUEST['pUsuarioFactura'])?$_REQUEST['pUsuarioFactura']:null;
    $pAnulada = isset($_REQUEST['pAnulada'])?$_REQUEST['pAnulada']:0;
        
    
    //Definicion de las Margenes
    $LeftMargin = PDF_MARGIN_LEFT;
    $TopMargin = 5;
    $RightMargin = PDF_MARGIN_RIGHT;
    $HeaderMargin = PDF_MARGIN_HEADER;
    $BottomMargin = 3;
    $FooterMargin = 5;
    $Alineacion = "P";
    $FormatoPagina = "CARTA";
    $UsaPiePagina = "NO";
    switch($pImprimeTirilla){
        case "SI":
            $Alineacion = "P";
            $FormatoPagina = "TIRILLA";
            $LeftMargin = 1;
            $TopMargin = 15; //Este Margen es para empezar nueva pagina
            $RightMargin = 1;
            $HeaderMargin = 0.5;
            $BottomMargin = 1;
            $FooterMargin = 3.5;
            $UsaPiePagina = "NO";
            $pTipoEncabezado = "MCT";
            break;
        
        default:
            $FormatoPagina = "MEDIACARTA";
            $Alineacion = "L";
            $UsaPiePagina = "NO";
            $pTipoEncabezado = "FVP";
            break;
    }
      
    //Inicializacion de la Clase
    $pdf = new TCPDF($Alineacion, PDF_UNIT, $FormatoPagina, true, 'UTF-8', false);
    //Inicializacion Variables de Control
    $pdf->pAlineacionEncabezado = $Alineacion;
    $pdf->pTituloInforme = "RECIBO DE CAJA";
    $pdf->pImprimeLogo = "NO";
    $pdf->pAnchoTxtPagina = 210;
    $pdf->pNomEmpresa = $_SESSION['NOM_EMPRESA'];
    $pdf->pTDocEmpresa = $_SESSION['EMPRESA_TDOC'];
    $pdf->pDocEmpresa = $_SESSION['EMPRESA_DOC'];
    $pdf->pDirEmpresa = $_SESSION['EMPRESA_DIR'];
    $pdf->pTelEmpresa = $_SESSION['EMPRESA_TEL'];
    $pdf->pCiuEmpresa = $_SESSION['EMPRESA_CIU'];
    $pdf->pEspEmpresa = $_SESSION['EMPRESA_ESP'];
    $pdf->pRegEmpresa = $_SESSION['EMPRESA_REGIMEN'];
    $pdf->pContribuyentes = $_SESSION['EMPRESA_CONTRIBUYENTE'];
    $pdf->pReteIVA  = $_SESSION['EMPRESA_RTEICA'];
    $pdf->pReteICA = $_SESSION['EMPRESA_RTEIVA'];
            
    $pdf->pTipoEncabezado = $pTipoEncabezado;
    $pdf->pNomSede = $_SESSION['EMPRESA_DOC'];
    $pdf->pNomIPS = $_SESSION['NOM_IPS'];
    $pdf->pMargenPie = -20;
    $pdf->pLogoCliente = "../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/logoenc.gif";
    $pdf->pPrefijo = $pPrefijo;
    $pdf->pNroDocumento = str_pad($pNroDocumento, 7, "0", STR_PAD_LEFT);
    $pdf->pNroResolucion = $pNroResolucion;
    $pdf->pFechaDoc = $pFechaDocumento;
    $pdf->pCAS = $pCAS;
    $pdf->pTratamiento = $pTratamiento;
    $pdf->pUsaPie = $UsaPiePagina;
        
    $pdf->SetCreator(PDF_CREATOR);
    $pdf->SetAuthor('Sistemas Ofisalud © - 2006');
    $pdf->SetTitle('RECIBO DE CAJA');
    $pdf->SetSubject('RECOIBO CAJA');

    $pdf->SetHeaderData($pdf->pLogoCliente, PDF_HEADER_LOGO_WIDTH, $pdf->pTituloInforme, PDF_HEADER_STRING);
    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
    $pdf->SetMargins($LeftMargin, $TopMargin, $RightMargin);
    $pdf->SetHeaderMargin($HeaderMargin);
    $pdf->SetFooterMargin($FooterMargin);
    // set bacground image
    
    $pdf->SetAutoPageBreak(TRUE, $BottomMargin);
    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
    $pdf->setLanguageArray($l);
    $pdf->setFontSubsetting(true);
    $pdf->SetFont('dejavusans', '', 14, '', true);
    
    switch($pImprimeTirilla){

        default:
            $pdf->AddPage();
            if ($pAnulada == 1){
                $img_file = "../../../resources/varios/docanulado.png";
                $pdf->Image($img_file, 110, 8, 80, 50, '', '', '', false, 300, '', false, false, 0);
                //$pdf->Image($img_file, 110, 215, 80, 50, '', '', '', false, 300, '', false, false, 0);
            }
            $pdf->Ln(2);
            $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
            $EncabezadoHTML = '<table cellspacing="0" border="0" style="font-size:24px; color:#000;">';
            $EncabezadoHTML .= '<tr><td></td><td height="5" style="font-size:14px; color:#000;" align="rigth"></td></tr>';
            $EncabezadoHTML .= '<tr>';
            $EncabezadoHTML .= '<td>';
            $EncabezadoHTML .= '<span style="font-size:44px; color:#000; font-weight:bold">' . ($pdf->pNomEmpresa) . '</span><br>';
            if($pdf->pEspEmpresa != null || $pdf->pEspEmpresa != "")
                    $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . utf8_decode($pdf->pEspEmpresa) . '</span><br>';
            if($pdf->pTDocEmpresa == "NI")
                $tipodoc = "NIT: ";
            else
                $tipodoc = $pdf->pTDocEmpresa . ": ";
            $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $tipodoc . $pdf->pDocEmpresa . '</span><br>';
            $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $pdf->pDirEmpresa . ' - ' . $pdf->pTelEmpresa . '</span><br>';
            $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $pdf->pCiuEmpresa . '</span><br>';
            $EncabezadoHTML .= '</td>';
            
            //COL2
            $EncabezadoHTML .= '<td>';
            $EncabezadoHTML .= '<span align="rigth" style="font-size:44px; color:#000; font-weight:bold">RECIBO DE CAJA</span><br>';
            $EncabezadoHTML .= '<span align="rigth" style="font-size:40px; color:#000; font-weight:bold">Nro: ' . $pdf->pPrefijo . "-" . $pdf->pNroDocumento . '</span><br>';
            $EncabezadoHTML .= '<span align="rigth" style="font-size:40px; color:#000; font-weight:bold">Fecha:' . $pdf->pFechaDoc . '</span><br>';
            $EncabezadoHTML .= '</td>';
            
            $EncabezadoHTML .= '</tr>';
            $EncabezadoHTML .= '</table>';
            $EncabezadoHTML .= '<hr>';
            $pdf->writeHTML($EncabezadoHTML, true, false, false, false, '');
            $gBaseDatos = new ofiMySQLi();
            // Cargar Datos del Paciente
            $gBaseDatos->conectar();
            $qry = "CALL sp_pacientes_buscarxid('" . $pPaciente . "')";
            $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
            while ($row = @mysqli_fetch_row($gBaseDatos->QryID))
            {
                $pdf->SetFont(PDF_FONT_NAME_MAIN,'',10);
                $pdf->MultiCell(17,5,"Tercero:",0,'L',0,0);
                $pdf->writeHTMLCell(178, 5, '', '', utf8_decode($row[1]) . " " . utf8_decode($row[2]) .  " - " . utf8_decode($row[5]) . " " . utf8_decode($row[6]) . " " . utf8_decode($row[3]) . " " . utf8_decode($row[4]), 0, 0, 0, true, 'L', true);
                $pdf->Ln(4);
                $rowcount = $pdf->getNumLines(utf8_decode($row[10]), 80) * 3;
                $pdf->MultiCell(18,$rowcount,"Dirección:",0,'L',0,0);
                $pdf->MultiCell(78,$rowcount,utf8_decode($row[10]),0,'L',0,0);
                $pdf->MultiCell(18,$rowcount,"Teléfono:",0,'L',0,0);
                $pdf->MultiCell(78,$rowcount,utf8_decode($row[11]) . " - " . utf8_decode($row[12]),0,'L',0,0);
                $pdf->Ln(4);
                
            }
            $gBaseDatos->liberar();
            $gBaseDatos->cerrar();
            
            // Cargar Datos del Cliente
            $pdf->SetLineWidth(0.3); 
            $pdf->Line($pdf->GetX(), $pdf->GetY(), $pdf->GetX()+200, $pdf->GetY()); 
            $pdf->SetFont(PDF_FONT_NAME_MAIN,'B',11);
            $pdf->MultiCell(200,5,"DETALLE",0,'C',0,0);
            $pdf->Ln(5);
            $pdf->SetLineWidth(0.3); 
            $pdf->Line($pdf->GetX(), $pdf->GetY(), $pdf->GetX()+200, $pdf->GetY()); 
            $pdf->Ln(1);
            $pdf->writeHTMLCell(178, 5, '', '', utf8_decode($pConcepto), 0, 0, 0, true, 'L', true);
            //$img_file = "../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/fondofac.png";
            //$pdf->Image($img_file, $pdf->GetX()+80, $pdf->GetY()+35, 60, 20, '', '', '', false, 300, '', false, false, 0);
            $pdf->SetFont(PDF_FONT_NAME_MAIN,'',10);
            $lineas = $pdf->GetY();
            while ($pdf->GetY() <= ($pdf->getPageHeight()-65)) {
                $pdf->Ln();
            }
            $pdf->Ln();
            $val = strtoupper(utf8_decode(numerotexto($pVlrNeto)));
            $EncabezadoHTML = '
            <table border="1" cellspacing="0" >
                <tr>
                    <td width="520">&nbsp;<br>&nbsp;SON: '. $val . ' PESOS M/CTE.</td>
                    <td width="180">
                        <table border="0" cellspacing="0">
                            <tr>
                                <td width="70">TOTAL:</td>
                                <td width="100" align="rigth">$ ' . number_format($pVlrTotal,2,".",",") . '</td>
                            </tr>
                        </table>
                    </td>
                </tr>
                <tr>
                    <td colspan="2">
                        <table border="0" cellspacing="0">
                            <tr>
                                <td align="rigth">
                                    <span style="font-size:25px; color:#000;">
                                    '. $_SESSION['NOM_SEDE'] . '<br>
                                    '. $_SESSION['NOM_IPS'] . '<br>
                                    CAS: ' . $pCAS . '<br>
                                    Usuario: ' . $pUsuarioFactura . '</span><br>
                                    <span style="font-size:16px; color:#000;">
                                    SOFTWARE OFICLINIC© 2006 - Tel. 3016398114
                                    </span>
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>';
            $pdf->writeHTML($EncabezadoHTML, true, false, false, false, '');
            break;
    }
    $pdf->Output('ReciboCajaParticulares.pdf', 'I');

    function ImprimeEncabezadoFactura(&$pdf){
        $pdf->AddPage();
        $pdf->Ln(2);
        $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
        $EncabezadoHTML = '<table cellspacing="0" border="0" style="font-size:24px; color:#000;">';
        $EncabezadoHTML .= '<tr><td></td><td height="5" style="font-size:14px; color:#000;" align="rigth">FACTURA POR COMPUTADOR</td></tr>';
        $EncabezadoHTML .= '<tr>';
        $EncabezadoHTML .= '<td>';
        $EncabezadoHTML .= '<span style="font-size:44px; color:#000; font-weight:bold">' . utf8_decode($pdf->pNomEmpresa) . '</span><br>';
        if($pdf->pEspEmpresa != null || $pdf->pEspEmpresa != "")
                $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . utf8_decode($pdf->pEspEmpresa) . '</span><br>';
        if($pdf->pTDocEmpresa == "NI")
            $tipodoc = "NIT: ";
        else
            $tipodoc = $pdf->pTDocEmpresa . ": ";
        $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $tipodoc . $pdf->pDocEmpresa . '</span><br>';
        $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $pdf->pDirEmpresa . ' - ' . $pdf->pTelEmpresa . '</span><br>';
        $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $pdf->pCiuEmpresa . '</span><br>';
        $EncabezadoHTML .= '<span style="font-size:30px; color:#000; font-weight:bold">' . $pdf->pRegEmpresa . '</span><br>';
        $EncabezadoHTML .= '<span style="font-size:30px; color:#000; font-weight:bold">' . $pdf->pContribuyentes . '</span><br>';
        $EncabezadoHTML .= '<span style="font-size:30px; color:#000; font-weight:bold">' . $pdf->pReteIVA . '</span><br>';
        $EncabezadoHTML .= '<span style="font-size:30px; color:#000; font-weight:bold">' . $pdf->pReteICA . '</span>';
        $EncabezadoHTML .= '</td>';

        //COL2
        $EncabezadoHTML .= '<td>';
        $EncabezadoHTML .= '<span align="rigth" style="font-size:44px; color:#000; font-weight:bold">FACTURA DE VENTA</span><br>';
        $EncabezadoHTML .= '<span align="rigth" style="font-size:40px; color:#000; font-weight:bold">Nro: ' . $pdf->pPrefijo . "-" . $pdf->pNroDocumento . '</span><br>';
        $EncabezadoHTML .= '<span align="rigth" style="font-size:40px; color:#000; font-weight:bold">Fecha: ' . $pdf->pFechaDoc . '</span><br>';
        $EncabezadoHTML .= '<span align="rigth" style="font-size:24px; color:#000;">' . $pdf->pNroResolucion . '</span><br>';
        $EncabezadoHTML .= '<span align="rigth" style="font-size:30px; color:#000; font-weight:bold">Fecha Vencimiento: ' . $pdf->pFechaDoc . '</span><br>';
        $EncabezadoHTML .= '</td>';

        $EncabezadoHTML .= '</tr>';
        $EncabezadoHTML .= '</table>';
        $EncabezadoHTML .= '<hr>';
        $pdf->writeHTML($EncabezadoHTML, true, false, false, false, '');
        $pdf->SetFont(PDF_FONT_NAME_MAIN,'B',11);
        //$pdf->MultiCell(200,5,"DETALLE",0,'C',0,0);
        $pdf->MultiCell(20,5,"CODIGO",0,'C',0,0);
        $pdf->MultiCell(75,5,"DESCRIPCION",0,'C',0,0);
        $pdf->MultiCell(10,5,"IVA",0,'R',0,0);
        $pdf->MultiCell(25,5,"CANTIDAD",0,'R',0,0);
        $pdf->MultiCell(32,5,"VLR UNITARIO",0,'R',0,0);
        $pdf->MultiCell(32,5,"VLR TOTAL",0,'R',0,0);
        $pdf->Ln(5);
        $pdf->SetLineWidth(0.3); 
        $pdf->Line($pdf->GetX(), $pdf->GetY(), $pdf->GetX()+200, $pdf->GetY()); 
        $pdf->Ln(1);
        $img_file = "../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/fondofac.png";
        $pdf->Image($img_file, $pdf->GetX()+80, $pdf->GetY()+15, 40, 10, '', '', '', false, 300, '', false, false, 0);
    }
    
?>
