<?php
    set_time_limit(500);
    require_once('../../../lib/tcpdf/config/lang/spa.php');
    require_once('../../../lib/tcpdf/tcpdf.php');
    require("../../../core/php/_database.php");
    require("../../../core/php/php_functions.php");
    header('Content-type: application/pdf; charset: UTF-8');
    
    $estructura = explode("¬", $_REQUEST['param']);
    $pNomParametros = spNomParametrosMI($estructura,"NO");
    $NameParam = explode("¬", $pNomParametros);
    $pParametros = spParametrosMI($estructura,"NO");
    $DataParam = explode("¬", $pParametros);
    
    $items = count($NameParam);
    for ($i=0; $i<$items; $i++)
    {
        switch ($NameParam[$i]) 
        {
            case "intEmpresa":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                    $pEmpresa = 0;
                else
                    $pEmpresa = $DataParam[$i];
                break;
                
            case "intIPS":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                    $pIPS = 0;
                else
                    $pIPS = $DataParam[$i];
                break;
                
            case "intCliente":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                    $pCliente = 0;
                else
                    $pCliente = $DataParam[$i];
                break;
                
            case "intPlan":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                    $pPlan = 0;
                else
                    $pPlan = $DataParam[$i];
                break;
                
            case "intSubPlan":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                    $pSubPlan = 0;
                else
                    $pSubPlan = $DataParam[$i];
                break;
                
            case "fecDesde":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {    
                    $pDesde = date('Y-m-d');
                }else{
                    $pDesde = $DataParam[$i];
                }
                break;
                
            case "fecHasta":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pHasta = date('Y-m-d');
                }else{
                    $pHasta = $DataParam[$i];
                }
                break;
                
            case "strCampo1":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pCampo1 = 'NO';
                }else{
                    $pCampo1 = $DataParam[$i];
                }
                break;
            
            case "strCampo2":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pCampo2 = 'NO';
                }else{
                    $pCampo2 = $DataParam[$i];
                }
                break;
            
            case "strCampo3":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pCampo3 = 'NO';
                }else{
                    $pCampo3 = $DataParam[$i];
                }
                break;
            
            case "intContrato":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pContrato = 0;
                }else{
                    $pContrato = $DataParam[$i];
                }
                break;
                
            case "strPaciente":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pPaciente = 'Todos';
                }else{
                    $pPaciente = $DataParam[$i];
                }
                break;
                
            case "strAutorizacion":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pAutorizacion = 'Todos';
                }else{
                    $pAutorizacion = $DataParam[$i];
                }
                break;
            
            default:
                break;
        }
    }
    //1,1,0,0,0,"2011-08-01","2011-08-31","CAS","NO","NO"
    //pContrato int, pPaciente varchar(50), pAutorizacion varchar(50)
    $qry = "CALL sp_macroinformes_auditoria_detallado('" . $pEmpresa . "','" . $pIPS . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "',\"" . $pPaciente . "\",\"" . $pAutorizacion . "\",\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pCampo1 . "\",\"" . $pCampo2 . "\",\"" . $pCampo3 . "\")";
    //echo $qry;
    // create new PDF document
    $pdf = new TCPDF("L", PDF_UNIT, "CARTA", true, 'UTF-8', false);

    // set document information
    $pdf->SetCreator(PDF_CREATOR);
    $pdf->SetAuthor('Sistemas Ofisalud © - 2011');
    $pdf->SetTitle('AUDITORIA');
    $pdf->SetSubject('Informe Detallado Ordenes de Servicio');

    // set default header data
    session_start();
    $pdf->pAlineacionEncabezado = "L";
    $pdf->pTituloInforme = "INFORME DETALLADO ORDENES DE SERVICIO";
    $pdf->pImprimeLogo = "NO";
    $pdf->pAnchoTxtPagina = 270;
    $pdf->pNomEmpresa = $_SESSION['NOM_EMPRESA'];
    $pdf->pNomSede = $_SESSION['NOM_SEDE'];
    $pdf->pNomIPS = $_SESSION['NOM_IPS'];
    $pdf->pMargenPie = -20;
    if($_SESSION['IdAplicacion'] == "OfiMedical"){
        $pdf->pLogoCliente = "../../../consultoriovirtual/" . $_SESSION['IDBD'] . "/logo/logoenc.gif";
    }else{
        $pdf->pLogoCliente = "../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/logoenc.gif";
    }

    $pdf->SetHeaderData($pdf->pLogoCliente, PDF_HEADER_LOGO_WIDTH, $pdf->pTituloInforme, PDF_HEADER_STRING);
    // set header and footer fonts
    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
    // set default monospaced font
    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
    //set margins
    $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
    $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
    $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
    //set auto page breaks
    $pdf->SetAutoPageBreak(FALSE, PDF_MARGIN_BOTTOM);
    //set image scale factor
    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
    //set some language-dependent strings
    $pdf->setLanguageArray($l);
    // set default font subsetting mode
    $pdf->setFontSubsetting(true);
    $pdf->SetFont('dejavusans', '', 14, '', true);

    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $idCliente = "-1";
    $idPlan = "-1";
    $idSubPlan = "-1";
    $totSubTotal = 0;
    $totIVA = 0;
    $totCopagos = 0;
    $totDescuentos = 0;
    $totNeto = 0;
    $totSubTotal_c = 0;
    $totIVA_c = 0;
    $totCopagos_c = 0;
    $totDescuentos_c = 0;
    $totNeto_c = 0;
    $totSubTotal_p = 0;
    $totIVA_p = 0;
    $totCopagos_p = 0;
    $totDescuentos_p = 0;
    $totNeto_p = 0;
    $totSubTotal_s = 0;
    $totIVA_s = 0;
    $totCopagos_s = 0;
    $totDescuentos_s = 0;
    $totNeto_s = 0;
    $contador = 0;
    $pImprimePieCliente = "No";
    $pImprimePiePlan = "No";
    $pImprimePieSubPlan = "No";
    $pUltimoRegistro = "No";
    while ($row[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
    $pRegistros = count($row)-1;
    //$pdf->AddPage();
    //$pdf->Ln(4.5);
    //$pdf->MultiCell(264,10,$pRegistros,0,'L',0,0);
    //$pdf->Ln(4.5);
    for($i=0;$i<$pRegistros;$i++)
    {
        if($row[$i]["Cliente"] != ""){
            if ($idCliente != $row[$i]["Cliente"])
            {
                $totSubTotal_c = 0;
                $totIVA_c = 0;
                $totCopagos_c = 0;
                $totDescuentos_c = 0;
                $totNeto_c = 0;
                $idPlan = "-1";
                $idSubPlan = "-1";
                $pImprimePieCliente = "No";
                $pImprimePiePlan = "No";
                $pImprimePieSubPlan = "No";
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                
            }
            if ($idPlan != $row[$i]["Plan"])
            {
                $idSubPlan = "-1";
                $totSubTotal_p = 0;
                $totIVA_p = 0;
                $totCopagos_p = 0;
                $totDescuentos_p = 0;
                $totNeto_p = 0;
            }
            if ($idSubPlan != $row[$i]["SubPlan"])
            {
                $totSubTotal_s = 0;
                $totIVA_s = 0;
                $totCopagos_s = 0;
                $totDescuentos_s = 0;
                $totNeto_s = 0;
                $contador = 0;
            }
            $contador ++;
            $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
            $rowcount = max($pdf->getNumLines(utf8_decode($row[$i]["nomPaciente"]), 45),$pdf->getNumLines(utf8_decode($row[$i]["CodProcedimiento"]) . "-" . utf8_decode($row[$i]["DescProcedimiento"]), 45))*4;
            EscribeDetalle($pdf, $row, $i, $rowcount, $contador);
            
            $idCliente = $row[$i]["Cliente"];
            $idPlan = $row[$i]["Plan"];
            $idSubPlan = $row[$i]["SubPlan"];
            
            $totSubTotal += $row[$i]["VlrTotal"];
            $totIVA += $row[$i]["VlrIVA"];
            $totCopagos += ($row[$i]["VlrCuotaModeradora"]+$row[$i]["VlrCopagos"]);
            $totDescuentos += $row[$i]["VlrDescuentos"];
            $totNeto += $row[$i]["VlrNeto"];

            $totSubTotal_c += $row[$i]["VlrTotal"];
            $totIVA_c += $row[$i]["VlrIVA"];
            $totCopagos_c += ($row[$i]["VlrCuotaModeradora"]+$row[$i]["VlrCopagos"]);
            $totDescuentos_c += $row[$i]["VlrDescuentos"];
            $totNeto_c += $row[$i]["VlrNeto"];
            
            $totSubTotal_p += $row[$i]["VlrTotal"];
            $totIVA_p += $row[$i]["VlrIVA"];
            $totCopagos_p += ($row[$i]["VlrCuotaModeradora"]+$row[$i]["VlrCopagos"]);
            $totDescuentos_p += $row[$i]["VlrDescuentos"];
            $totNeto_p += $row[$i]["VlrNeto"];
            
            $totSubTotal_s += $row[$i]["VlrTotal"];
            $totIVA_s += $row[$i]["VlrIVA"];
            $totCopagos_s += ($row[$i]["VlrCuotaModeradora"]+$row[$i]["VlrCopagos"]);
            $totDescuentos_s += $row[$i]["VlrDescuentos"];
            $totNeto_s += $row[$i]["VlrNeto"];
            $pUltimoRegistro = "No";
            if($row[$i+1]["Cliente"] == $idCliente){
                $pImprimePieCliente = "No";
                if ($row[$i+1]["Plan"] != $idPlan)
                    $pImprimePiePlan = "Si";
                else
                    $pImprimePiePlan = "No";
                if ($row[$i+1]["SubPlan"] != $idSubPlan)
                    $pImprimePieSubPlan = "Si";
                else
                    $pImprimePieSubPlan = "No";
            }else{
                $pImprimePieCliente = "Si";
                $pImprimePiePlan = "Si";
                $pImprimePieSubPlan = "Si";
                $pUltimoRegistro = "Si";
            }
            if (($pdf->GetY()+$rowcount) > 195)
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            if ($pImprimePieSubPlan == "Si")
            {
                if ($pdf->GetY() > 170)
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                PieGrupo($pdf, $row, $i, $totSubTotal_s, $totIVA_s, $totCopagos_s, $totDescuentos_s, $totNeto_s, "SUBPLAN", "SubPlan");
                $pImprimePieSubPlan = "No";
                if($pUltimoRegistro == "No"){
                    $indice = $i+1;
                    EncabezadoGrupo($pdf, $row, $indice, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
                
            if ($pImprimePiePlan == "Si")
            {
                if ($pdf->GetY() > 170)
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                PieGrupo($pdf, $row, $i, $totSubTotal_p, $totIV_p, $totCopagos_p, $totDescuentos_p, $totNeto_p, "PLAN", "Plan");
                $pImprimePiePlan = "No";
                if($pUltimoRegistro == "No"){
                    $indice = $i+1;
                    EncabezadoGrupo($pdf, $row, $indice, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            
            if ($pImprimePieCliente == "Si")
            {
                if ($pdf->GetY() > 170)
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                PieGrupo($pdf, $row, $i, $totSubTotal_c, $totIV_c, $totCopagos_c, $totDescuentos_c, $totNeto_c, "CLIENTE", "Cliente");
                $pImprimePieCliente = "No";
                if($pUltimoRegistro == "No"){
                    $indice = $i+1;
                    EncabezadoGrupo($pdf, $row, $indice, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
        }
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $pdf->Output('infDetalladoOrdenesServicio.pdf', 'I');

    function EncabezadoPagina(&$pdf, &$row, &$i, &$rowcount, &$contador, &$pDesde, &$pHasta){
        $pdf->AddPage();
        $pdf->SetFont(PDF_FONT_NAME_MAIN,'B',11);
        $pdf->MultiCell(264,10,"Periodo: " . $pDesde . " - " . $pHasta ,0,'L',0,0);
        $pdf->Ln(8.5);
        $pdf->SetFillColor(242 , 236, 236);
        //$pdf->MultiCell(264,10,"CLIENTE: " . $row[$i]["Cliente"],0,'L',0,0);
        $pdf->writeHTMLCell(264, 10, '', '', "CLIENTE: " . $row[$i]["Cliente"], 0, 0, 0, true, 'L', true);
        $pdf->Ln(4.5);
        //$pdf->MultiCell(264,10,"PLAN: " . $row[$i]["Plan"],0,'L',0,0);
        $pdf->writeHTMLCell(264, 10, '', '', "PLAN: " . $row[$i]["Plan"], 0, 0, 0, true, 'L', true);
        $pdf->Ln(4.5);
        //$pdf->MultiCell(264,10,"SUBPLAN: " . $row[$i]["SubPlan"],0,'L',0,0);
        $pdf->writeHTMLCell(264, 10, '', '', "SUBPLAN: " . $row[$i]["SubPlan"], 0, 0, 0, true, 'L', true);
        EncabezadoColumnas($pdf);
    }
    
    function EncabezadoGrupo(&$pdf, &$row, &$indice, &$rowcount, &$contador, &$pDesde, &$pHasta){
        $pdf->Ln(8.5);
        $pdf->SetFillColor(242 , 236, 236);
        $pdf->SetFont(PDF_FONT_NAME_MAIN,'B',11);
        //$pdf->MultiCell(264,10,"CLIENTE: " . $row[$i]["Cliente"],0,'L',0,0);
        $pdf->writeHTMLCell(264, 10, '', '', "CLIENTE: " . $row[$indice]["Cliente"], 0, 0, 0, true, 'L', true);
        $pdf->Ln(4.5);
        //$pdf->MultiCell(264,10,"PLAN: " . $row[$i]["Plan"],0,'L',0,0);
        $pdf->writeHTMLCell(264, 10, '', '', "PLAN: " . $row[$indice]["Plan"], 0, 0, 0, true, 'L', true);
        $pdf->Ln(4.5);
        //$pdf->MultiCell(264,10,"SUBPLAN: " . $row[$i]["SubPlan"],0,'L',0,0);
        $pdf->writeHTMLCell(264, 10, '', '', "SUBPLAN: " . $row[$indice]["SubPlan"], 0, 0, 0, true, 'L', true);
        EncabezadoColumnas($pdf);
    }
    
    function EncabezadoColumnas(&$pdf)
    {
        $pdf->Ln(4.5);
        $pdf->SetFont(PDF_FONT_NAME_MAIN,'B',9);
        $pdf->MultiCell(10,5,"Nro",1,'C',1,0);
        $pdf->MultiCell(15,5,"CAS",1,'C',1,0);
        $pdf->MultiCell(15,5,"Fecha",1,'C',1,0);
        $pdf->MultiCell(25,5,"#Autorizacion",1,'C',1,0);
        $pdf->MultiCell(45,5,"Paciente",1,'C',1,0);
        $pdf->MultiCell(45,5,"Concepto",1,'C',1,0);
        $pdf->MultiCell(10,5,"Cant",1,'C',1,0);
        $pdf->MultiCell(20,5,"SubTotal",1,'C',1,0);
        $pdf->MultiCell(17,5,"IVA",1,'C',1,0);
        $pdf->MultiCell(20,5,"Copagos",1,'C',1,0);
        $pdf->MultiCell(20,5,"Descuentos",1,'C',1,0);
        $pdf->MultiCell(23,5,"Neto",1,'C',1,0);
        $pdf->Ln();
    }
    function EscribeDetalle(&$pdf, &$row, &$i, &$rowcount, &$contador)
    {
        //$pdf->MultiCell(10,$rowcount,number_format($contador,0,".",","),0,'C',0,0);
        $pdf->writeHTMLCell(10, $rowcount, '', '', number_format($contador,0,".",","), 0, 0, 0, true, 'C', true);
        //$pdf->MultiCell(15,$rowcount,$row[$i]["CAS"],0,'C',0,0);
        $pdf->writeHTMLCell(15, $rowcount, '', '', $row[$i]["CAS"], 0, 0, 0, true, 'C', true);
        //$pdf->MultiCell(15,$rowcount,$row[$i]["Fecha"],0,'C',0,0);
        $pdf->writeHTMLCell(15, $rowcount, '', '', $row[$i]["Fecha"], 0, 0, 0, true, 'C', true);
        //$pdf->MultiCell(25,$rowcount,$row[$i]["NroAutorizacion"],0,'C',0,0);
        $pdf->writeHTMLCell(25, $rowcount, '', '', $row[$i]["NroAutorizacion"], 0, 0, 0, true, 'C', true);
        //$pdf->MultiCell(45,$rowcount,$row[$i]["nomPaciente"],0,'L',0,0);
        $pdf->writeHTMLCell(45, $rowcount, '', '', $row[$i]["nomPaciente"], 0, 0, 0, true, 'L', true);
        //$pdf->MultiCell(45,$rowcount,utf8_decode($row[$i]["CodProcedimiento"]) . "-" . utf8_decode($row[$i]["DescProcedimiento"]),0,'L',0,0);
        $pdf->writeHTMLCell(45, $rowcount, '', '', utf8_decode($row[$i]["CodProcedimiento"]) . "-" . utf8_decode($row[$i]["DescProcedimiento"]), 0, 0, 0, true, 'L', true);
        //$pdf->MultiCell(10,$rowcount,$row[$i]["Cantidad"],0,'C',0,0);
        $pdf->writeHTMLCell(10, $rowcount, '', '', $row[$i]["Cantidad"], 0, 0, 0, true, 'C', true);
        //$pdf->MultiCell(20,$rowcount,number_format($row[$i]["VlrTotal"],2,".",","),0,'R',0,0);
        $pdf->writeHTMLCell(20, $rowcount, '', '', number_format($row[$i]["VlrTotal"],2,".",","), 0, 0, 0, true, 'R', true);
        //$pdf->MultiCell(17,$rowcount,number_format($row[$i]["VlrIVA"],2,".",","),0,'R',0,0);
        $pdf->writeHTMLCell(17, $rowcount, '', '', number_format($row[$i]["VlrIVA"],2,".",","), 0, 0, 0, true, 'R', true);
        //$pdf->MultiCell(20,$rowcount,number_format(($row[$i]["VlrCuotaModeradora"] + $row[$i]["VlrCopagos"]),2,".",","),0,'R',0,0);
        $pdf->writeHTMLCell(20, $rowcount, '', '', number_format(($row[$i]["VlrCuotaModeradora"] + $row[$i]["VlrCopagos"]),2,".",","), 0, 0, 0, true, 'R', true);
        //$pdf->MultiCell(20,$rowcount,number_format($row[$i]["VlrDescuentos"],2,".",","),0,'R',0,0);
        $pdf->writeHTMLCell(20, $rowcount, '', '', number_format($row[$i]["VlrDescuentos"],2,".",","), 0, 0, 0, true, 'R', true);
        //$pdf->MultiCell(23,$rowcount,number_format($row[$i]["VlrNeto"],2,".",","),0,'R',0,0);
        $pdf->writeHTMLCell(23, $rowcount, '', '', number_format($row[$i]["VlrNeto"],2,".",","), 0, 0, 0, true, 'R', true);
        $pdf->Ln();
    }
    
    function PieGrupo(&$pdf, &$row, &$i, $totSubTotal, $totIVA, $totCopagos, $totDescuentos, $totNeto, $pTextoGrupo, $pCampoGrupo){
        $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
        $pdf->MultiCell(165,5,"TOTAL " . $pTextoGrupo . ": " . $row[$i][$pCampoGrupo],1,'R',1,0);
        $pdf->MultiCell(20,5,number_format($totSubTotal,2,".",","),1,'R',1,0);
        $pdf->MultiCell(17,5,number_format($totIVA,2,".",","),1,'R',1,0);
        $pdf->MultiCell(20,5,number_format($totCopagos,2,".",","),1,'R',1,0);
        $pdf->MultiCell(20,5,number_format($totDescuentos,2,".",","),1,'R',1,0);
        $pdf->MultiCell(23,5,number_format($totNeto,2,".",","),1,'R',1,0);
        $pdf->Ln();
    }
    
?>
