<?php

set_time_limit(500);
require_once('../../../lib/tcpdf/config/lang/spa.php');
require_once('../../../lib/tcpdf/tcpdf.php');
require("../../../core/php/_database.php");
require("../../../core/php/php_functions.php");
//header('Content-type: application/pdf; charset: UTF-8');

session_start();
$nomEmpresa = $_SESSION['NOM_EMPRESA'];
$nomUsuario = $_SESSION['NOM_USUARIO'];

$estructura = explode("¬", $_REQUEST['param']);
$pNomParametros = spNomParametrosMI($estructura,"NO");
$NameParam = explode("¬", $pNomParametros);
$pParametros = spParametrosMI($estructura,"NO");
$DataParam = explode("¬", $pParametros);

$items = count($NameParam);
for ($i=0; $i<$items; $i++)
{
    switch ($NameParam[$i]) 
    {
        case "intEmpresa":
            if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                $pEmpresa = 0;
            else
                $pEmpresa = $DataParam[$i];
            break;

        case "intIPS":
            if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                $pIPS = 0;
            else
                $pIPS = $DataParam[$i];
            break;

        case "intCliente":
            if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                $pCliente = 0;
            else
                $pCliente = $DataParam[$i];
            break;

        case "intPlan":
            if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                $pPlan = 0;
            else
                $pPlan = $DataParam[$i];
            break;

        case "intSubPlan":
            if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                $pSubPlan = 0;
            else
                $pSubPlan = $DataParam[$i];
            break;

        case "fecDesde":
            if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
            {    
                $pDesde = date('Y-m-d');
            }else{
                $pDesde = $DataParam[$i];
            }
            break;

        case "fecHasta":
            if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
            {
                $pHasta = date('Y-m-d');
            }else{
                $pHasta = $DataParam[$i];
            }
            break;

        case "strCampo1":
            if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
            {
                $pCampo1 = 'NO';
            }else{
                $pCampo1 = $DataParam[$i];
            }
            break;

        case "strCampo2":
            if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
            {
                $pCampo2 = 'NO';
            }else{
                $pCampo2 = $DataParam[$i];
            }
            break;

        case "strCampo3":
            if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
            {
                $pCampo3 = 'NO';
            }else{
                $pCampo3 = $DataParam[$i];
            }
            break;

        case "intProfesional":
            if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
            {
                $pProfesional = 0;
            }else{
                $pProfesional = $DataParam[$i];
            }
            break;

        case "intContrato":
            if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
            {
                $pContrato = 0;
            }else{
                $pContrato = $DataParam[$i];
            }
            break;

        case "strPaciente":
            if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
            {
                $pPaciente = 'Todos';
            }else{
                $pPaciente = $DataParam[$i];
            }
            break;

        case "strAutorizacion":
            if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
            {
                $pAutorizacion = 'Todos';
            }else{
                $pAutorizacion = $DataParam[$i];
            }
            break;
            
        case "strPlantillaHC":
            if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
            {
                $pPlantilla = 'Todos';
            }else{
                $pPlantilla = $DataParam[$i];
            }
            break;
            
        default:
            break;
    }
}

    $qry = "CALL sp_macroinformes_soporte_hc_fisiocenter('" . $pEmpresa . "','" . $pIPS . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "',\"" . $pPaciente . "\",\"" . $pAutorizacion . "\",\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pPlantilla . "\",\"" . $pCampo1 . "\",\"" . $pCampo2 . "\",\"" . $pCampo3 . "\")";
    //echo $qry;
    //create new PDF document
    $pdf = new TCPDF("P", PDF_UNIT, "CARTA", true, 'UTF-8', false);
    //ISO-8859-1
    //UTF-8
    // set document information
    $pdf->SetCreator(PDF_CREATOR);
    $pdf->SetAuthor('Sistemas Ofisalud © - 2011');
    $pdf->SetTitle('AUDITORIA');
    $pdf->SetSubject('Informe Detallado Ordenes Sin Legalizar');

    // set default header data
    $pdf->pAlineacionEncabezado = "P";
    $pdf->pTituloInforme = "SOPORTE HISTORIA CLINICA";
    $pdf->pImprimeLogo = "NO";
    $pdf->pAnchoTxtPagina = 270;
    //'1','1','0','0','0','0',"31641373","Todos","2011-08-01","2011-08-31","Todos","NO","NO","NO"
    $pdf->pNomEmpresa = $_SESSION['NOM_EMPRESA'];
    $pdf->pNomSede = $_SESSION['NOM_SEDE'];
    $pdf->pNomIPS = $_SESSION['NOM_IPS'];
    $pdf->pMargenPie = -20;
    if($_SESSION['IdAplicacion'] == "OfiMedical"){
        $pdf->pLogoCliente = "../../../consultoriovirtual/" . $_SESSION['IDBD'] . "/logo/logoenc.gif";
    }else{
        $pdf->pLogoCliente = "../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/logoenc.gif";
    }

    $pdf->SetHeaderData($pdf->pLogoCliente, PDF_HEADER_LOGO_WIDTH, $pdf->pTituloInforme, PDF_HEADER_STRING);
    // set header and footer fonts
    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
    // set default monospaced font
    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
    //set margins
    $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
    $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
    $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
    //set auto page breaks
    $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
    //set image scale factor
    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
    //set some language-dependent strings
    $pdf->setLanguageArray($l);
    // set default font subsetting mode
    $pdf->setFontSubsetting(true);
    $pdf->SetFont('dejavusans', '', 14, '', true);

    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $pUltimoRegistro = "No";
    while ($row = @mysqli_fetch_assoc($gBaseDatos->QryID)){
        if($row["nomPaciente"] != ""){
            if ($idPaciente != $row["nomPaciente"])
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $contador ++;
            $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
            $mostrarHC = '<table border="0" style="font-size:26px; color:#000;">';
            $mostrarHC .= '<tr>';
            $mostrarHC .= '<td colspan="2" align="center" style="text-decoration:underline; font-weight:bolder">' . utf8_decode($row["Actividad"]) . '</td>';
            $mostrarHC .= '</tr>';
            $mostrarHC .= '<tr>';
            $mostrarHC .= '<td colspan="2" align="center">&nbsp;&nbsp;</td>';
            $mostrarHC .= '</tr>';
            $mostrarHC .= '<tr>';
            $mostrarHC .= '<td width="100">Paciente:</td>';
            $mostrarHC .= '<td>' . utf8_decode($row["TipDoc"]) . ' ' . utf8_decode($row["Documento"]) . ' - ' . utf8_decode($row["Nom1"]) . ' ' . utf8_decode($row["Nom2"]) . ' ' . utf8_decode($row["Ape1"]) . ' ' . utf8_decode($row["Ape2"]) . ' Genero: (' . utf8_decode($row["Genero"]) . ') FechaNac: (' .$row["FecNac"] . ')</td>';
            //$mostrarHC .= '<td>' . utf8_decode($row["TipDoc"]) . ' ' . utf8_decode($row["Documento"]) . ' - ' . utf8_decode($row["Nom1"]) . ' ' . utf8_decode($row["Nom2"]) . ' ' . utf8_encode($row["Ape1"]) . '</td>';
            $mostrarHC .= '</tr>';
            $mostrarHC .= '<tr>';
            $mostrarHC .= '<td>Cliente:</td>';
            $mostrarHC .= '<td>' . utf8_decode($row["Cliente"]) . '</td>';
            $mostrarHC .= '</tr>';
            $mostrarHC .= '<tr>';
            $mostrarHC .= '<td>Profesional Tratante:</td>';
            $mostrarHC .= '<td>' . utf8_decode($row["NomProfesional"]) . '</td>';
            $mostrarHC .= '</tr>';
            $mostrarHC .= '<tr>';
            $mostrarHC .= '<td>Fecha Atención:</td>';
            $mostrarHC .= '<td>' . utf8_decode($row["Fecha"]) . '</td>';
            $mostrarHC .= '</tr>';
            $mostrarHC .= '<tr>';
            $mostrarHC .= '<td>Hora Atención:</td>';
            $mostrarHC .= '<td>' . utf8_decode($row["HoraApertura"]) . '</td>';
            $mostrarHC .= '</tr>';
            $mostrarHC .= '<tr>';
            $mostrarHC .= '<td>CAS:</td>';
            $mostrarHC .= '<td>' . utf8_decode($row["CAS"]) . '</td>';
            $mostrarHC .= '</tr>';
            $mostrarHC .= '</table>';
            
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            
            $estructurahc = explode("¬",utf8_decode($row["Evolucion"])); 
            $reg = count($estructurahc)-1;
            $mostrarHC = "";
            $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
            for ($i=0; $i<$reg; $i++){ 
                $contenidohc = explode("^~",$estructurahc[$i]);
                //$mostrarHC .= $contenidohc[2] . "<br><br>";
                switch($contenidohc[1]){
                    case "TRUE":
                        $txtContenido = "SI";
                        break;

                    case "FALSE":
                        $txtContenido = "NO";
                        break;

                    default:
                        $txtContenido = $contenidohc[1];
                        break;
                }
                if(substr($contenidohc[2],0,3) == "bTB"){
                    $mostrarHC .= '<span style="text-decoration:underline; font-size:26px; color:#000; font-weight:bolder">' . substr($contenidohc[2],3,strlen($contenidohc[2])) . ':</span><br>';
                    $mostrarHC .= '<table cellspacing = "0" border = "0"><tr><td width="20"></td><td style="padding:10px;">';
                }else{
                    if(substr($contenidohc[2],0,3) == "eTB"){
                        $mostrarHC .= '</td></tr></table>';
                    }else{
                        if($txtContenido != "NO"){
                            $mostrarHC .= '<span style="text-decoration:underline; font-size:26px; color:#000; font-weight:bolder">' . $contenidohc[2] . ':</span><br>';
                            $mostrarHC .= '<span style="font-size:26px; color:#000;">' . $txtContenido . '</span><br><br>';
                        }
                    }
                }
            }
            $pdf->writeHTML($mostrarHC, true, false, false, false, ''); 
            
            $mostrarHC = '<br>';
            $mostrarHC .= '<table border="0" style="font-size:26px; color:#000;">';
            $mostrarHC .= '<tr>';
            $mostrarHC .= '<td width="100">Finalidad:</td>';
            $mostrarHC .= '<td width="470">' . utf8_decode($row["Finalidad"]) . '</td>';
            if (file_exists('../../../empresas/' . $_SESSION['ID_EMPRESA'] . '/firmas/' . $row["Profesional"] . '.png"')) 
                $mostrarHC .= '<td rowspan="7" valign="middle" align="left"><img src="../../../empresas/' . $_SESSION['ID_EMPRESA'] . '/firmas/' . $row["Profesional"] . '.png" width="100" height="25"/></td>';
            else
                $mostrarHC .= '<td rowspan="7" valign="middle" align="left"></td>';
            $mostrarHC .= '</tr>';
            $mostrarHC .= '<tr>';
            $mostrarHC .= '<td>Causa Externa:</td>';
            $mostrarHC .= '<td>' . utf8_decode($row["CausaExterna"]) . '</td>';
            $mostrarHC .= '</tr>';
            $mostrarHC .= '<tr>';
            $mostrarHC .= '<td>Tipo Diagnostico:</td>';
            $mostrarHC .= '<td>' . utf8_decode($row["Des_TipDiag"]) . '</td>';
            $mostrarHC .= '</tr>';
            $mostrarHC .= '<tr>';
            $mostrarHC .= '<td>Diagnostico Principal:</td>';
            $mostrarHC .= '<td>' . utf8_decode($row["Diagppal"]) . ' - ' . utf8_decode($row["DesDiagPpal"]) . '</td>';
            $mostrarHC .= '</tr>';
            $mostrarHC .= '<tr>';
            $mostrarHC .= '<td>Diagnostico Relacionado Nro1:</td>';
            $mostrarHC .= '<td>'  . utf8_decode($row["Diagrel1"]) . ' - ' . utf8_decode($row["DesDiagRel1"]) . '</td>';
            $mostrarHC .= '</tr>';
            $mostrarHC .= '<tr>';
            $mostrarHC .= '<td>Diagnostico Relacionado Nro2:</td>';
            $mostrarHC .= '<td>'  . utf8_decode($row["DiagRel2"]) . ' - ' . utf8_decode($row["DesDiagRel2"]) . '</td>';
            $mostrarHC .= '</tr>';
            $mostrarHC .= '<tr>';
            $mostrarHC .= '<td>Diagnostico Relacionado Nro3:</td>';
            $mostrarHC .= '<td>'  . utf8_decode($row["DiagRel3"]) . ' - ' . utf8_decode($row["DesDiagRel3"]) . '</td>';
            $mostrarHC .= '</tr>';
            $mostrarHC .= '</table>';
            $mostrarHC .= '<hr>';

            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            //$pdf->writeHTML($mostrarHC, true, 0, true, 0);
            
            $idPaciente = $row["nomPaciente"];
            if ($pdf->GetY() >= ($pdf->getPageHeight()-35))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
        }
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $pdf->Output('infSoporteHC.pdf', 'I');

    function EncabezadoPagina(&$pdf, &$row, &$i, &$rowcount, &$contador, &$pDesde, &$pHasta){
        $pdf->AddPage();
        //$pdf->SetFont(PDF_FONT_NAME_MAIN,'B',11);
        $pdf->Ln(6.5);
        //$pdf->MultiCell(264,10,utf8_decode($row["Actividad"]),0,'C',0,0);
        //$pdf->Ln(8.5);
    }
    
?>
