<?php

set_time_limit(500);
require("../../../../core/php/_database.php");
require("../../../../core/php/php_functions.php");
require("../../../../core/php/constantes.php");

header("Content-Type: application/vnd.ms-excel");
header("Content-Disposition: attachment; filename=rcv_ingresos.xls");
header("Pragma: no-cache");
header("Expires: 0");

session_start();
$nomEmpresa = $_SESSION['NOM_EMPRESA'];
$nomUsuario = $_SESSION['NOM_USUARIO'];

$estructura = explode("¬", $_REQUEST['param']);
$pNomParametros = spNomParametrosMI($estructura,"NO");
$NameParam = explode("¬", $pNomParametros);
$pParametros = spParametrosMI($estructura,"NO");
$DataParam = explode("¬", $pParametros);

$items = count($NameParam);
for ($i=0; $i<$items; $i++)
{
    switch ($NameParam[$i]) 
    {
        case "intEmpresa":
            if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                $pEmpresa = 0;
            else
                $pEmpresa = $DataParam[$i];
            break;

        case "intIPS":
            if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                $pIPS = 0;
            else
                $pIPS = $DataParam[$i];
            break;

        case "intCliente":
            if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                $pCliente = 0;
            else
                $pCliente = $DataParam[$i];
            break;

        case "intPlan":
            if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                $pPlan = 0;
            else
                $pPlan = $DataParam[$i];
            break;

        case "intSubPlan":
            if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                $pSubPlan = 0;
            else
                $pSubPlan = $DataParam[$i];
            break;

        case "fecDesde":
            if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
            {    
                $pDesde = date('Y-m-d');
            }else{
                $pDesde = $DataParam[$i];
            }
            break;

        case "fecHasta":
            if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
            {
                $pHasta = date('Y-m-d');
            }else{
                $pHasta = $DataParam[$i];
            }
            break;

        case "strCampo1":
            if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
            {
                $pCampo1 = 'NO';
            }else{
                $pCampo1 = $DataParam[$i];
            }
            break;

        case "strCampo2":
            if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
            {
                $pCampo2 = 'NO';
            }else{
                $pCampo2 = $DataParam[$i];
            }
            break;

        case "strCampo3":
            if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
            {
                $pCampo3 = 'NO';
            }else{
                $pCampo3 = $DataParam[$i];
            }
            break;

        case "intContrato":
            if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
            {
                $pContrato = 0;
            }else{
                $pContrato = $DataParam[$i];
            }
            break;

        case "strPaciente":
            if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
            {
                $pPaciente = 'Todos';
            }else{
                $pPaciente = $DataParam[$i];
            }
            break;

        case "strAutorizacion":
            if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
            {
                $pAutorizacion = 'Todos';
            }else{
                $pAutorizacion = $DataParam[$i];
            }
            break;

        default:
            break;
    }
}

$qry = "CALL sp_rcv_2022_ingresos('" . $pCliente . "',\"" . $pDesde . "\",\"" . $pHasta . "\")";
//echo $qry;
$gBaseDatos = new ofiMySQLi();
$gBaseDatos->conectar();
$gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
while ($rowINF[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
$finfo = @mysqli_fetch_fields($gBaseDatos->QryID);
$gBaseDatos->liberar();
$gBaseDatos->cerrar();
$pRegistros = count($rowINF);
$pCamposHC = array();
$ids = array();
for($i=0;$i<$pRegistros;$i++){
    $estructurahc = explode("¬",utf8_decode($rowINF[$i]["Evolucion"]));
    $reg = count($estructurahc)-1;
    $pContador = 0;
    for ($j=0; $j<$reg; $j++){
        $contenidohc = "";
        $contenidohc = explode("^~",$estructurahc[$j]);
        //echo "<pre>"; print_r($contenidohc[0]); print_r(" | "); print_r($contenidohc[2]);
        switch($contenidohc[0]){
            case 'strViveSolo': array_push($pCamposHC, '001@@@' . $contenidohc[2]); break;
            case 'strRCV18_Telefono': array_push($pCamposHC, '002@@@' . $contenidohc[2]); break;
            case 'strRCV18_Direccion': array_push($pCamposHC, '003@@@' . $contenidohc[2]); break;
            case 'strRCV18_ViaCaptacion': array_push($pCamposHC, '004@@@' . $contenidohc[2]); break;
            case 'strRCV18_Fuma': array_push($pCamposHC, '005@@@' . $contenidohc[2]); break;
            case 'strRCV18_DxHTA': array_push($pCamposHC, '006@@@' . $contenidohc[2]); break;
            case 'strRCV18_DxHTAAnios': array_push($pCamposHC, '007@@@' . $contenidohc[2]); break;
            case 'intRCV18_DxHTAElAnio': array_push($pCamposHC, '008@@@' . $contenidohc[2]); break;
            case 'intRCV18_DxHTAElMes': array_push($pCamposHC, '009@@@' . $contenidohc[2]); break;
            case 'strRCV18_DxDM': array_push($pCamposHC, '010@@@' . $contenidohc[2]); break;
            case 'strRCV18_DxDMAnios': array_push($pCamposHC, '011@@@' . $contenidohc[2]); break;
            case 'intRCV18_DxDMElAnio': array_push($pCamposHC, '012@@@' . $contenidohc[2]); break;
            case 'intRCV18_DxDMElMes': array_push($pCamposHC, '013@@@' . $contenidohc[2]); break;
            case 'strRCV18_TipoDM': array_push($pCamposHC, '014@@@' . $contenidohc[2]); break;
            case 'strRCV18_DxERC': array_push($pCamposHC, '015@@@' . $contenidohc[2]); break;
            case 'strRCV18_DxERCAnios': array_push($pCamposHC, '016@@@' . $contenidohc[2]); break;
            case 'intRCV18_DxERCElAnio': array_push($pCamposHC, '017@@@' . $contenidohc[2]); break;
            case 'intRCV18_DxERCElMes': array_push($pCamposHC, '018@@@' . $contenidohc[2]); break;
            case 'strRCV18_ProgramaActual': array_push($pCamposHC, '019@@@' . $contenidohc[2]); break;
            case 'strRCV18_ClasificacionRCV': array_push($pCamposHC, '020@@@' . $contenidohc[2]); break;
            case 'strRCV18_SeguimientoRCV': array_push($pCamposHC, '021@@@' . $contenidohc[2]); break;
            case 'intRCV18_Talla': array_push($pCamposHC, '022@@@' . $contenidohc[2]); break;
            case 'intRCV18_Peso': array_push($pCamposHC, '023@@@' . $contenidohc[2]); break;
            case 'intRCV18_IMC': array_push($pCamposHC, '024@@@' . $contenidohc[2]); break;
            case 'intRCV18_CircunferenciaAbd': array_push($pCamposHC, '025@@@' . $contenidohc[2]); break;
            case 'intRCV18_Sistolica': array_push($pCamposHC, '026@@@' . $contenidohc[2]); break;
            case 'intRCV18_Diastolica': array_push($pCamposHC, '027@@@' . $contenidohc[2]); break;
            case 'fecRCV18_0Parcialorina': array_push($pCamposHC, '028@@@' . $contenidohc[2]); break;
            case 'strRCV18_0ParcialorinaRes': array_push($pCamposHC, '029@@@' . $contenidohc[2]); break;
            case 'fecRCV18_0ColesterolTotal': array_push($pCamposHC, '030@@@' . $contenidohc[2]); break;
            case 'intRCV18_0ColesterolTotalRes': array_push($pCamposHC, '031@@@' . $contenidohc[2]); break;
            case 'fecRCV18_0ColesterolHDL': array_push($pCamposHC, '032@@@' . $contenidohc[2]); break;
            case 'intRCV18_0ColesterolHDLRes': array_push($pCamposHC, '033@@@' . $contenidohc[2]); break;
            case 'fecRCV18_0ColesterolLDL': array_push($pCamposHC, '034@@@' . $contenidohc[2]); break;
            case 'intRCV18_0ColesterolLDLRes': array_push($pCamposHC, '035@@@' . $contenidohc[2]); break;
            case 'fecRCV18_0Trigliceridos': array_push($pCamposHC, '036@@@' . $contenidohc[2]); break;
            case 'intRCV18_0TrigliceridosRes': array_push($pCamposHC, '037@@@' . $contenidohc[2]); break;
            case 'fecRCV18_0Glicemia': array_push($pCamposHC, '038@@@' . $contenidohc[2]); break;
            case 'intRCV18_0GlicemiaRes': array_push($pCamposHC, '039@@@' . $contenidohc[2]); break;
            case 'fecRCV18_0MicroAlbuminuria': array_push($pCamposHC, '040@@@' . $contenidohc[2]); break;
            case 'intRCV18_0MicroAlbuminuriaRes': array_push($pCamposHC, '041@@@' . $contenidohc[2]); break;
            case 'fecRCV18_0EcografiaRenal': array_push($pCamposHC, '042@@@' . $contenidohc[2]); break;
            case 'strRCV18_0EcografiaRenalRes': array_push($pCamposHC, '043@@@' . $contenidohc[2]); break;
            case 'fecRCV18_0Creatinina': array_push($pCamposHC, '044@@@' . $contenidohc[2]); break;
            case 'intRCV18_0CreatininaRes': array_push($pCamposHC, '045@@@' . $contenidohc[2]); break;
            case 'fecRCV18_0CreatininaOrina': array_push($pCamposHC, '046@@@' . $contenidohc[2]); break;
            case 'intRCV18_0CreatininaOrinaRes': array_push($pCamposHC, '047@@@' . $contenidohc[2]); break;
            case 'intRCV18_TFG0': array_push($pCamposHC, '048@@@' . $contenidohc[2]); break;
            case 'strRCV18_EstadioRenalRegistradoHC': array_push($pCamposHC, '049@@@' . $contenidohc[2]); break;
            case 'intRCV18_ALBUM_CREAT0': array_push($pCamposHC, '050@@@' . $contenidohc[2]); break;
            case 'intPuntaje': array_push($pCamposHC, '051@@@' . $contenidohc[2]); break;
            case 'strPorcentajeRiesgo': array_push($pCamposHC, '052@@@' . $contenidohc[2]); break;
            case 'fecRCV18_0EKG': array_push($pCamposHC, '053@@@' . $contenidohc[2]); break;
            case 'strRCV18_0EKGRes': array_push($pCamposHC, '054@@@' . $contenidohc[2]); break;
            case 'fecRCV18_0HemoglobinaGlicosilada': array_push($pCamposHC, '055@@@' . $contenidohc[2]); break;
            case 'intRCV18_0HemoglobinaGlicosiladaRes': array_push($pCamposHC, '056@@@' . $contenidohc[2]); break;
            case 'fecRCV18_0Proteinas': array_push($pCamposHC, '057@@@' . $contenidohc[2]); break;
            case 'intRCV18_0ProteinasRes': array_push($pCamposHC, '058@@@' . $contenidohc[2]); break;
            default:
                break;
        }
        $pContador ++;
    }
}

$pListaCampos = array_unique($pCamposHC);
$pListaCamposFinal = array_values($pListaCampos);
asort($pListaCamposFinal);
$pCamposInformes = array();
foreach ($pListaCamposFinal as $key => $val) {
    array_push($pCamposInformes, strtoupper($val));
}
$pTotCampos = count($pCamposInformes);
echo "<table border=\"0\" align=\"left\">";
echo '<tr><td colspan = "6" style="color:#03F; font-size:20px">INGRESO PACIENTES PROGRAMA RIESGO CARDIOVASCULAR</td></tr>';
echo '<tr><td colspan = "6" style="color:#900; font-size:16px">Empresa: ' . utf8_decode($nomEmpresa) . '</td></tr>';
echo '<tr><td colspan = "6" style="color:#900; font-size:14px">Usuario: ' . utf8_decode($nomUsuario) . '</td></tr>';
echo '<tr><td colspan = "6" style="color:#900; font-size:12px">Fecha/Hora: ' . date('d/m/Y h:i:s A') . '</td></tr>';
echo '<tr><td>&nbsp;</td></tr>';
echo '<tr><td colspan = "6" style="color:#000; font-size:20px">CRITERIOS DE SELECCION</td></tr>';
echo '<tr><td colspan = "6" style="color:#000; font-size:16px">Desde: ' . $pDesde . ' - Hasta: ' . $pHasta . '</td></tr>';
echo "</table>";
echo "<table border=\"1\" align=\"left\">";
echo "<tr bgcolor=\"#DFE9F7\">";
$estructurahc = explode("¬",utf8_decode($rowINF[0]["Evolucion"]));
$reg = count($estructurahc)-1;
foreach ($finfo as $val){
    if(utf8_decode($val->name != "Evolucion")){
        echo "<td><strong>" . utf8_decode($val->name) . "</strong></td>";
    }else{
        for($k=0;$k<$pTotCampos;$k++){
            $titcampo = explode("@@@",$pCamposInformes[$k]);
            switch($titcampo[0]){
                default:
                    echo utf8_decode("<td><strong>" . $titcampo[1] . "</strong></td>");
                    break;
            }
        }
    }
}

for($i=0;$i<$pRegistros;$i++){
    $pMicroalbuminuriaRes = 0;
    $pCreatininaRes = 0;
    $pRelacionMC = 0;
    $pCalculable = false;
    echo "<tr>"; 
    $xControlImp = 0;
    foreach ($finfo as $val){
        if($val->name != "Evolucion"){
            echo "<td>" . utf8_decode($rowINF[$i][$val->name]) . "</td>";
        }else{
            unset($pContenidoHC);
            $pContenidoHC = array();
            $estructurahc = explode("¬",utf8_decode($rowINF[$i]["Evolucion"]));
            $reg = count($estructurahc)-1;
            for ($j=0; $j<$reg; $j++){
                $contenidohc = explode("^~",$estructurahc[$j]);
                switch($contenidohc[1]){
                    case "TRUE":
                        $txtContenido = "SI";
                        break;

                    case "FALSE":
                        $txtContenido = "NO";
                        break;

                    case "true":
                        $txtContenido = "SI";
                        break;

                    case "false":
                        $txtContenido = "NO";
                        break;

                    default:
                        $txtContenido = $contenidohc[1];
                        break;
                }
                for($k=0;$k<$pTotCampos;$k++){
                    $titcampo = explode("@@@",$pCamposInformes[$k]);
                    if($titcampo[1] == strtoupper($contenidohc[2])){
                       $pContenidoHC[$k] = str_replace("<br />", "\n", $txtContenido);
                       //$pContenidoHC[$k] = str_replace("<br />", " ", $txtContenido);
                       $k = $pTotCampos;
                    }
                }
            }
            for ($j=0; $j<$pTotCampos; $j++){
                echo "<td>" . $pContenidoHC[$j] . "</td>";
            }
        }
    }
    echo "</tr>";
}
echo "</table>";
echo "<table border=\"0\" align=\"left\">";
echo '<tr><td>&nbsp;</td></tr>';
echo '<tr><td colspan = "5" style="color:#333; font-size:10px">' . utf8_decode(ofiCONFIDENCIALIDAD) . '</td></tr>';
echo "</table>";
