<?php
    require_once('../../../../lib/tcpdf/config/lang/spa.php');
    require_once('../../../../lib/tcpdf/tcpdf.php');
    require("../../../../core/php/_database.php");
    require("../../../../core/php/php_functions.php");
    header('Content-type: application/pdf; charset: UTF-8');
    
    $estructura = explode("¬", $_REQUEST['param']);
    $pNomParametros = spNomParametrosMI($estructura,"NO");
    $NameParam = explode("¬", $pNomParametros);
    $pParametros = spParametrosMI($estructura,"NO");
    $DataParam = explode("¬", $pParametros);
    
    $items = count($NameParam);
    for ($i=0; $i<$items; $i++)
    {
        switch ($NameParam[$i]) 
        {
            case "intEmpresa":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                    $pEmpresa = 0;
                else
                    $pEmpresa = $DataParam[$i];
                break;
                
            case "intIPS":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                    $pIPS = 0;
                else
                    $pIPS = $DataParam[$i];
                break;
                
            case "intCliente":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                    $pCliente = 0;
                else
                    $pCliente = $DataParam[$i];
                break;
                
            case "intPlan":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                    $pPlan = 0;
                else
                    $pPlan = $DataParam[$i];
                break;
                
            case "intSubPlan":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                    $pSubPlan = 0;
                else
                    $pSubPlan = $DataParam[$i];
                break;
                
            case "fecDesde":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {    
                    $pDesde = date('Y-m-d');
                }else{
                    $pDesde = $DataParam[$i];
                }
                break;
                
            case "fecHasta":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pHasta = date('Y-m-d');
                }else{
                    $pHasta = $DataParam[$i];
                }
                break;
                
            case "strCampo1":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pCampo1 = 'NO';
                }else{
                    $pCampo1 = $DataParam[$i];
                }
                break;
            
            case "strCampo2":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pCampo2 = 'NO';
                }else{
                    $pCampo2 = $DataParam[$i];
                }
                break;
            
            case "strCampo3":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pCampo3 = 'NO';
                }else{
                    $pCampo3 = $DataParam[$i];
                }
                break;
            
            case "intContrato":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pContrato = 0;
                }else{
                    $pContrato = $DataParam[$i];
                }
                break;
                
            case "strPaciente":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pPaciente = 'Todos';
                }else{
                    $pPaciente = $DataParam[$i];
                }
                break;
                
            case "strAutorizacion":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pAutorizacion = 'Todos';
                }else{
                    $pAutorizacion = $DataParam[$i];
                }
                break;
            
            default:
                break;
        }
    }
    $pImprimeTirilla = "NO";
    $LeftMargin = PDF_MARGIN_LEFT;
    $TopMargin = 5;
    $RightMargin = PDF_MARGIN_RIGHT;
    $HeaderMargin = PDF_MARGIN_HEADER;
    $BottomMargin = 3;
    $FooterMargin = 5;
    $Alineacion = "P";
    $FormatoPagina = "CARTA";
    $UsaPiePagina = "SI";
    $pTipoEncabezado = "SIN";
    $pControlSalto = 20;
    
    $qry = "CALL sp_facturacion_cuentacobro_fpc('" . $pIPS . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "',\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pCampo1 . "\",\"" . $pCampo2 . "\",\"" . $pCampo3 . "\")";
    //echo $qry;
    
    //Inicializacion de la Clase
    $pdf = new TCPDF($Alineacion, PDF_UNIT, $FormatoPagina, true, 'UTF-8', false);
    //$pdf = new TCPDF("P", PDF_UNIT, "CARTA", true, 'UTF-8', false);
    
    // set document information
    $pdf->SetCreator(PDF_CREATOR);
    $pdf->SetAuthor('Sistemas Ofisalud © - 2006');
    $pdf->SetTitle('FACTURACION');
    $pdf->SetSubject('CUENTA DE COBRO');

    // set default header data
    $qry = "CALL sp_facturacion_cuentacobro_fpc('" . $pIPS . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "',\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pCampo1 . "\",\"" . $pCampo2 . "\",\"" . $pCampo3 . "\")";
    //echo $qry;
    session_start();
    $pdf->pAlineacionEncabezado = "P";
    $pdf->pTituloInforme = "CUENTA DE COBRO";
    $pdf->pTipoEncabezado = $pTipoEncabezado;
    $pdf->pImprimeLogo = "NO";
    $pdf->pAnchoTxtPagina = 140;
    $pdf->pNomEmpresa = $_SESSION['NOM_EMPRESA'];
    $pdf->pNomSede = $_SESSION['NOM_SEDE'];
    $pdf->pNomIPS = $_SESSION['NOM_IPS'];
    $pdf->pMargenPie = -20;
    if($_SESSION['IdAplicacion'] == "OfiMedical"){
        $pdf->pLogoCliente = "../../../consultoriovirtual/" . $_SESSION['IDBD'] . "/logo/logoenc.gif";
    }else{
        $pdf->pLogoCliente = "../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/logoenc.gif";
    }
    $pdf->SetHeaderData($pdf->pLogoCliente, PDF_HEADER_LOGO_WIDTH, $pdf->pTituloInforme, PDF_HEADER_STRING);
    // set header and footer fonts
    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
    // set default monospaced font
    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
    //set margins
    $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
    $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
    $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
    //set auto page breaks
    $pdf->SetAutoPageBreak(FALSE, PDF_MARGIN_BOTTOM);
    //set image scale factor
    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
    //set some language-dependent strings
    $pdf->setLanguageArray($l);
    // set default font subsetting mode
    $pdf->setFontSubsetting(true);
    $pdf->SetFont('dejavusans', '', 14, '', true);

    $idConcepto = "-1";
    $totSubTotal_c = 0;
    $totIVA_c = 0;
    $totCopagos_c = 0;
    $totDescuentos_c = 0;
    $totNeto_c = 0;
    $contador = 0;
    $pImprimePieConcepto = "No";
    $pUltimoRegistro = "No";
    
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_facturacion_cuentacobro_fpc('" . $pIPS . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "',\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pCampo1 . "\",\"" . $pCampo2 . "\",\"" . $pCampo3 . "\")";
    unset($row);
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    while ($row[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
    $pRegistros = count($row)-1;
    $gBaseDatos->liberar(); 
    $gBaseDatos->cerrar();
    $ValorTotalCuenta = 0;
    for($i=0;$i<$pRegistros;$i++)
    {
        $ValorTotalCuenta += $row[$i]["VlrNeto"];
    }
    
    $pdf->AddPage();
    //echo $qry;
    $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 11);
    $pdf->SetFillColor(242 , 236, 236);
    $pdf->Ln(-4);
    $pdf->MultiCell(204,10,$row[0]["CiuPrestador"] . ", " . formatearFechaIdiomas( time(), $setting, 'medio'),0,'L',0,0);
    $pdf->Ln();
    $pdf->SetFont(PDF_FONT_NAME_MAIN,'B',11);
    $pdf->SetFillColor(242 , 236, 236);
    $pdf->MultiCell(204,10,$row[0]["DesCliente"],0,'C',0,0);
    $pdf->Ln(4);
    if($row[0]["TDocCliente"] == "NI"){
        $TdocCliente = "NIT";
    }else{
        $TdocCliente = $row[0]["TDocCliente"];
    }
    if($row[0]["DigverCliente"] != "" && $row[0]["DigverCliente"] != null){
        $DocCliente = $row[0]["DocCliente"] . "-" . $row[0]["DigverCliente"];
    }else{
        $DocCliente = $row[0]["DocCliente"];
    }
    $pdf->MultiCell(204,10,"(" . $TdocCliente . ": " . $DocCliente .")",0,'C',0,0);
    $pdf->Ln();
    $pdf->SetFont(PDF_FONT_NAME_MAIN,'',11);
    $pdf->MultiCell(204,10,"DEBE A:",0,'C',0,0);
    $pdf->Ln();
    $pdf->SetFont(PDF_FONT_NAME_MAIN,'B',11);
    $pdf->writeHTMLCell(204,10, '', '', '<span>' . $row[0]["NomPrestador"] . '</span>', 0, 0, 0, true, 'C', false);
    $pdf->Ln(4);
    if($row[0]["TdocPrestador"] == "NI"){
        $TdocPrestador = "NIT";
    }else{
        $TdocPrestador = $row[0]["TdocPrestador"];
    }
    $DocPrestador = $row[0]["DocPrestador"];
    $pdf->MultiCell(204,10,"(" . $TdocPrestador . ": " . $DocPrestador .")",0,'C',0,0);
    $pdf->Ln();
    $val = strtoupper(utf8_decode(numerotexto($ValorTotalCuenta)));
    
    $mostrarHC = '<table cellspacing="0">';
        $mostrarHC .= '<tr>';
            $mostrarHC .= '<td align="right" width="100">LA SUMA DE:</td>';
            $mostrarHC .= '<td width="604">';
                $mostrarHC .= " $" . number_format($ValorTotalCuenta,2,".",",");
            $mostrarHC .= '</td>';
        $mostrarHC .= '</tr>';
        $mostrarHC .= '<tr>';
            $mostrarHC .= '<td align="right" width="100">SON:</td>';
            $mostrarHC .= '<td width="604">';
                $mostrarHC .= '&nbsp;'. $val . ' PESOS M/CTE.';
            $mostrarHC .= '</td>';
        $mostrarHC .= '</tr>';
    $mostrarHC .= '</table>';
    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
    
    for($i=0;$i<$pRegistros;$i++){
        if($row[$i]["DescProcedimiento"] != ""){
            if ($idConcepto != $row[$i]["DescProcedimiento"])
            {
                $totSubTotal_c = 0;
                $totIVA_c = 0;
                $totCopagos_c = 0;
                $totDescuentos_c = 0;
                $totNeto_c = 0;
                $pImprimePieConcepto = "No";
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta,"NO");
                
            }
            $contador ++;
            $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
            $nomPaciente = $row[$i]["Documento"] . " - " . $row[$i]["Nom1"] . " " . $row[$i]["Nom2"] . " " . $row[$i]["Ape1"] . " " . $row[$i]["Ape2"];
            $nomProced = $row[$i]["CodProcedimiento"] . "-" . $row[$i]["DescProcedimiento"];
            $rowcount = max($pdf->getNumLines($nomPaciente, 35),$pdf->getNumLines($nomProced, 35))*4;
            EscribeDetalle($pdf, $row, $i, $rowcount, $contador);
            
            $idConcepto = $row[$i]["DescProcedimiento"];
            $totSubTotal += $row[$i]["VlrTotal"];
            $totIVA += $row[$i]["VlrIVA"];
            $totCopagos += ($row[$i]["VlrCuotaModeradora"]+$row[$i]["VlrCopagos"]);
            $totDescuentos += $row[$i]["VlrDescuentos"];
            $totNeto += $row[$i]["VlrNeto"];

            $totSubTotal_c += $row[$i]["VlrTotal"];
            $totIVA_c += $row[$i]["VlrIVA"];
            $totCopagos_c += ($row[$i]["VlrCuotaModeradora"]+$row[$i]["VlrCopagos"]);
            $totDescuentos_c += $row[$i]["VlrDescuentos"];
            $totNeto_c += $row[$i]["VlrNeto"];
            
            $pUltimoRegistro = "No";
            if($row[$i+1]["DescProcedimiento"] == $idConcepto){
                $pImprimePieConcepto = "No";
            }else{
                $pImprimePieConcepto = "Si";
                $pUltimoRegistro = "Si";
            }
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta,"SI");
            }
            if ($pImprimePieConcepto == "Si"){
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta,"SI");
                }
                PieGrupo($pdf, $row, $i, $totSubTotal_c, $totIV_c, $totCopagos_c, $totDescuentos_c, $totNeto_c, "CLIENTE", "DesCliente");
                $pImprimePieConcepto = "No";
                if($pUltimoRegistro == "No"){
                    $indice = $i+1;
                    EncabezadoGrupo($pdf, $row, $indice, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
        }
    }
    $pdf->Ln();
    $pdf->Ln();
    $pdf->writeHTML("__________________________________________", true, false, false, false, '');
    $pdf->writeHTML($row[0]["Quienfirma"], true, false, false, false, '');
    $pdf->writeHTML($row[0]["cargofirma"], true, false, false, false, '');
    
    $pdf->Output('infCuentaCobroxProcedimiento.pdf', 'I');
    
    
    function EncabezadoPagina(&$pdf, &$row, &$i, &$rowcount, &$contador, &$pDesde, &$pHasta, $AddPagina){
        if($AddPagina == "SI"){
            $pdf->AddPage();
        }
        EncabezadoColumnas($pdf,$row,$i);
    }
    
    function EncabezadoGrupo(&$pdf, &$row, &$indice, &$rowcount, &$contador, &$pDesde, &$pHasta){
        $pdf->Ln(8.5);
        EncabezadoColumnas($pdf, $row, $indice);
    }
    
    function EncabezadoColumnas(&$pdf, &$row, &$i)
    {
        $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
        $mostrarHC = '<span style="color:#00C; font-size: 34px;"><b>' . $row[$i]["DescProcedimiento"] . '</b></span><br>';
        $mostrarHC .= '<table border="1" style="background-color:#E4E4E4;" cellspacing="0">';
            $mostrarHC .= '<tr>';
                $mostrarHC .= '<td align="center" width="90"><b>FACTURA:</b></td>';
                $mostrarHC .= '<td align="center" width="60"><b>FECHA:</b></td>';
                $mostrarHC .= '<td align="center" width="250"><b>PACIENTE:</b></td>';
                $mostrarHC .= '<td align="center" width="100"><b>VALOR:</b></td>';
                $mostrarHC .= '<td align="center" width="100"><b>COPAGOS/CM:</b></td>';
                $mostrarHC .= '<td align="center" width="100"><b>NETO:</b></td>';
            $mostrarHC .= '</tr>';
        $mostrarHC .= '</table>';
        $pdf->writeHTML($mostrarHC, true, false, false, false, '');
    }
    function EscribeDetalle(&$pdf, &$row, &$i, &$rowcount, &$contador)
    {
        $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
        $pdf->Ln(-3);
        $mostrarHC = '<table border="1" style="padding:2px;" cellspacing="0">';
            $mostrarHC .= '<tr>';
                $mostrarHC .= '<td width="90">' . $row[$i]["Prefijo"] . '-' . $row[$i]["NroDocumento"] . '</td>';
                $mostrarHC .= '<td width="60">' . $row[$i]["Fecha"] . '</td>';
                $mostrarHC .= '<td width="250">' . $row[$i]["Documento"] . " - " . $row[$i]["Nom1"] . " " . $row[$i]["Nom2"] . " " . $row[$i]["Ape1"] . " " . $row[$i]["Ape2"] . '</td>';
                $mostrarHC .= '<td align="right" width="100">' . number_format($row[$i]["VlrTotal"],2,".",",") . '</td>';
                $mostrarHC .= '<td align="right" width="100">' . number_format(($row[$i]["VlrCuotaModeradora"] + $row[$i]["VlrCopagos"]),2,".",",") . '</td>';
                $mostrarHC .= '<td align="right" width="100">' . number_format($row[$i]["VlrNeto"],2,".",",") . '</td>';
            $mostrarHC .= '</tr>';
        $mostrarHC .= '</table>';
        $pdf->writeHTML($mostrarHC, true, false, false, false, '');
        
    }
    
    function PieGrupo(&$pdf, &$row, &$i, $totSubTotal, $totIVA, $totCopagos, $totDescuentos, $totNeto, $pTextoGrupo, $pCampoGrupo){
        $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
        $pdf->Ln(-3);
        $mostrarHC .= '<table border="1" style="background-color:#E4E4E4;" cellspacing="0">';
            $mostrarHC .= '<tr>';
                $mostrarHC .= '<td align="right" width="400"><b>TOTAL ' . $row[$i]["DescProcedimiento"] . ':</b></td>';
                $mostrarHC .= '<td align="right" width="100">' . number_format($totSubTotal,2,".",",") . '</td>';
                $mostrarHC .= '<td align="right" width="100">' . number_format($totCopagos,2,".",","). '</td>';
                $mostrarHC .= '<td align="right" width="100">' . number_format($totNeto,2,".",",") . '</td>';
            $mostrarHC .= '</tr>';
        $mostrarHC .= '</table>';
        $pdf->writeHTML($mostrarHC, true, false, false, false, '');
    }
    
?>
