<?php
    require_once('../../../../lib/tcpdf/config/lang/spa.php');
    require_once('../../../../lib/tcpdf/tcpdf.php');
    require("../../../../core/php/_database.php");
    require("../../../../core/php/php_functions.php");
    header('Content-type: application/pdf; charset: UTF-8');
    
    $estructura = explode("¬", $_REQUEST['param']);
    $pNomParametros = spNomParametrosMI($estructura,"NO");
    $NameParam = explode("¬", $pNomParametros);
    $pParametros = spParametrosMI($estructura,"NO");
    $DataParam = explode("¬", $pParametros);
    
    $items = count($NameParam);
    for ($i=0; $i<$items; $i++)
    {
        switch ($NameParam[$i]) 
        {
            case "intEmpresa":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                    $pEmpresa = 0;
                else
                    $pEmpresa = $DataParam[$i];
                break;
                
            case "intIPS":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                    $pIPS = 0;
                else
                    $pIPS = $DataParam[$i];
                break;
                
            case "intCliente":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                    $pCliente = 0;
                else
                    $pCliente = $DataParam[$i];
                break;
                
            case "intPlan":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                    $pPlan = 0;
                else
                    $pPlan = $DataParam[$i];
                break;
                
            case "intSubPlan":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                    $pSubPlan = 0;
                else
                    $pSubPlan = $DataParam[$i];
                break;
                
            case "fecDesde":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {    
                    $pDesde = date('Y-m-d');
                }else{
                    $pDesde = $DataParam[$i];
                }
                break;
                
            case "fecHasta":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pHasta = date('Y-m-d');
                }else{
                    $pHasta = $DataParam[$i];
                }
                break;
                
            case "strCampo1":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pCampo1 = 'NO';
                }else{
                    $pCampo1 = $DataParam[$i];
                }
                break;
            
            case "strCampo2":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pCampo2 = 'NO';
                }else{
                    $pCampo2 = $DataParam[$i];
                }
                break;
            
            case "strCampo3":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pCampo3 = 'NO';
                }else{
                    $pCampo3 = $DataParam[$i];
                }
                break;
            
            case "intContrato":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pContrato = 0;
                }else{
                    $pContrato = $DataParam[$i];
                }
                break;
                
            case "strPaciente":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pPaciente = 'Todos';
                }else{
                    $pPaciente = $DataParam[$i];
                }
                break;
                
            case "strAutorizacion":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pAutorizacion = 'Todos';
                }else{
                    $pAutorizacion = $DataParam[$i];
                }
                break;
            
            default:
                break;
        }
    }
    $pImprimeTirilla = "NO";
    $LeftMargin = PDF_MARGIN_LEFT;
    $TopMargin = 5;
    $RightMargin = PDF_MARGIN_RIGHT;
    $HeaderMargin = PDF_MARGIN_HEADER;
    $BottomMargin = 3;
    $FooterMargin = 5;
    $Alineacion = "L";
    $FormatoPagina = "CARTA";
    $UsaPiePagina = "SI";
    $pTipoEncabezado = "SIN";
    
    $qry = "CALL sp_facturacion_reldetallefactura('" . $pIPS . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "',\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pCampo1 . "\",\"" . $pCampo2 . "\",\"" . $pCampo3 . "\")";
    //echo $qry;
    
    //Inicializacion de la Clase
    $pdf = new TCPDF($Alineacion, PDF_UNIT, $FormatoPagina, true, 'UTF-8', false);
    //$pdf = new TCPDF("P", PDF_UNIT, "CARTA", true, 'UTF-8', false);
    
    // set document information
    $pdf->SetCreator(PDF_CREATOR);
    $pdf->SetAuthor('Sistemas Ofisalud © - 2006');
    $pdf->SetTitle('FACTURACION');
    $pdf->SetSubject('CUENTA DE COBRO');

    // set default header data
    $qry = "CALL sp_facturacion_reldetallefactura('" . $pIPS . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "',\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pCampo1 . "\",\"" . $pCampo2 . "\",\"" . $pCampo3 . "\")";
    //echo $qry;
    session_start();
    $pdf->pAlineacionEncabezado = "P";
    $pdf->pTituloInforme = "RELACION DETALLE POR FACTURA DE VENTA";
    $pdf->pTipoEncabezado = $pTipoEncabezado;
    $pdf->pImprimeLogo = "NO";
    $pdf->pAnchoTxtPagina = 140;
    $pdf->pNomEmpresa = $_SESSION['NOM_EMPRESA'];
    $pdf->pNomSede = $_SESSION['NOM_SEDE'];
    $pdf->pNomIPS = $_SESSION['NOM_IPS'];
    $pdf->pMargenPie = -20;
    if($_SESSION['IdAplicacion'] == "OfiMedical"){
        $pdf->pLogoCliente = "../../../consultoriovirtual/" . $_SESSION['IDBD'] . "/logo/logoenc.gif";
    }else{
        $pdf->pLogoCliente = "../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/logoenc.gif";
    }
    $pdf->SetHeaderData($pdf->pLogoCliente, PDF_HEADER_LOGO_WIDTH, $pdf->pTituloInforme, PDF_HEADER_STRING);
    // set header and footer fonts
    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
    // set default monospaced font
    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
    //set margins
    $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
    $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
    $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
    //set auto page breaks
    $pdf->SetAutoPageBreak(FALSE, PDF_MARGIN_BOTTOM);
    //set image scale factor
    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
    //set some language-dependent strings
    $pdf->setLanguageArray($l);
    // set default font subsetting mode
    $pdf->setFontSubsetting(true);
    $pdf->SetFont('dejavusans', '', 14, '', true);

    $idConcepto = "-1";
    $totSubTotal_c = 0;
    $totIVA_c = 0;
    $totCopagos_c = 0;
    $totDescuentos_c = 0;
    $totNeto_c = 0;
    $totSubTotal_t = 0;
    $totIVA_t = 0;
    $totCopagos_t = 0;
    $totDescuentos_t = 0;
    $totNeto_t = 0;
    $contador = 0;
    $pImprimePieConcepto = "No";
    $pUltimoRegistro = "No";
    
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_facturacion_reldetallefactura01('" . $pIPS . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "',\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pCampo1 . "\",\"" . $pCampo2 . "\",\"" . $pCampo3 . "\")";
    unset($row);
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    while ($row[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
    $pRegistros = count($row)-1;
    $gBaseDatos->liberar(); 
    $gBaseDatos->cerrar();
    $ValorTotalCuenta = 0;
    for($i=0;$i<$pRegistros;$i++){
        $ValorTotalCuenta += $row[$i]["VlrNeto"];
    }
    $pdf->AddPage();
    $pdf->Ln(-15);
    $idConcepto = "";
    for($i=0;$i<$pRegistros;$i++){
        if($row[$i]["NroDocumento"] != ""){
            if ($idConcepto != $row[$i]["DesPlan"] . "-" . $row[$i]["DesSubPlan"]){
                if($contador > 0){
                    PieGrupo($pdf, $row, $i,  $rowcount, $contador, $pDesde, $pHasta, $totSubTotal_c,$totCopagos_c,$totDescuentos_c,$totNeto_c);
                }
                $rowcount = 0;
                $contador = 0;
                $totSubTotal_c = 0;
                $totCopagos_c = 0;
                $totDescuentos_c = 0;
                $totNeto_c = 0;
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta,"NO");
            }else{
                if ($pdf->GetY() >= ($pdf->getPageHeight()-20)){
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta,"SI");
                }
            }
            $contador ++;
            $totSubTotal_c += $row[$i]["TVlrTotal"];
            $totCopagos_c += ($row[$i]["TCM"] + $row[$i]["TCOPAGOS"]);
            $totDescuentos_c += $row[$i]["TVlrDescuentos"];
            $totNeto_c += $row[$i]["TVlrNeto"];
            $totSubTotal_t += $row[$i]["TVlrTotal"];
            $totCopagos_t += ($row[$i]["TCM"] + $row[$i]["TCOPAGOS"]);
            $totDescuentos_t += $row[$i]["TVlrDescuentos"];
            $totNeto_t += $row[$i]["TVlrNeto"];
            $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
            EscribeDetalle($pdf, $row, $i, $rowcount, $contador);
            if($i == ($pRegistros-1)){
                PieGrupo($pdf, $row, $i,  $rowcount, $contador, $pDesde, $pHasta, $totSubTotal_c,$totCopagos_c,$totDescuentos_c,$totNeto_c);
                PieTotal($pdf, $row, $i,  $rowcount, $contador, $pDesde, $pHasta, $totSubTotal_t,$totCopagos_t,$totDescuentos_t,$totNeto_t);
            }
        }
        $idConcepto = $row[$i]["DesPlan"] . "-" . $row[$i]["DesSubPlan"];
    }
    $pdf->Output('infDetallexFacturaVenta.pdf', 'I');
    
    
    function EncabezadoPagina(&$pdf, &$row, &$i, &$rowcount, &$contador, &$pDesde, &$pHasta, $AddPagina){
        $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
        if($AddPagina == "SI"){
            $pdf->AddPage();
            $pdf->Ln(-15);
        }
        if ($pdf->GetY() >= ($pdf->getPageHeight()-40)){
            $pdf->AddPage();
            $pdf->Ln(-15);
        }
        
        //if($rowcount == 0){
            $mostrarHC = '<table border="1" cellspacing="0" cellpadding="2">';
            $mostrarHC .= '<tr>';
            $mostrarHC .= '<td width="125">';
            if($pNomAplicacion == "OfiMedical"){
                if (file_exists("../../../consultoriovirtual/" . $_SESSION['IDBD'] . "/logo/logoenc.gif")) {
                    $mostrarHC .= '<img src="../../../consultoriovirtual/' . $_SESSION['IDBD'] . '/logo/logoenc.gif" align="right"/>';
                }else{
                    if (file_exists("../../../../consultoriovirtual/" . $_SESSION['IDBD'] . "/logo/logoenc.gif")) {
                        $mostrarHC .= '<img src="../../../../consultoriovirtual/' . $_SESSION['IDBD'] . '/logo/logoenc.gif" align="right"/>';
                    }
                }
            }else{
                if (file_exists("../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/logoenc.gif")) {
                    $mostrarHC .= '<img src="../../../empresas/' . $_SESSION['ID_EMPRESA'] . '/logo/logoenc.gif" align="right"/>';
                }else{
                    if (file_exists("../../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/logoenc.gif")) {
                        $mostrarHC .= '<img src="../../../../empresas/' . $_SESSION['ID_EMPRESA'] . '/logo/logoenc.png" align="right"/>';
                    }
                }

            }
            $mostrarHC .= '</td>';
            $mostrarHC .= '<td width="620">';
            $mostrarHC .= '<span style="font-size:33px; font-weight:bolder;">' . $pdf->pNomEmpresa . '</span><br><br>';
            $mostrarHC .= '<span style="font-size:30px;"><b>Entidad:</b> ' . $row[$i]["DesCliente"] . '</span><br>';
            $mostrarHC .= '<span style="font-size:30px;"><b>Plan:</b> ' . $row[$i]["DesPlan"] . '</span><br>';
            $mostrarHC .= '<span style="font-size:30px;"><b>SubPlan:</b> ' . $row[$i]["DesSubPlan"] . '</span><br>';
            $mostrarHC .= '</td>';
            $mostrarHC .= '<td width="200" align="center">';
            $mostrarHC .= '<br><br><span style="font-size:33px; font-weight:bolder;">Informe Resumen de Facturación</span><br>';
            $mostrarHC .= '<br><span style="font-size:30px; font-weight:bolder;">Periodo Facturación</span><br>';
            $mostrarHC .= '<span style="font-size:30px; font-weight:bolder;">Desde: ' . $pDesde . ' - Hasta: ' . $pHasta . '</span><br>';
            $mostrarHC .= '</td>';
            $mostrarHC .= '</tr>';
            $mostrarHC .= '</table>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
        //}
        $pdf->Ln(-3);
        if ($pdf->GetY() >= ($pdf->getPageHeight()-20)){
            $pdf->AddPage();
            $pdf->Ln(-15);
        }
        $mostrarHC = '<table border="1" cellspacing="0" cellpadding="2">';
        $mostrarHC .= '<tr>';
        $mostrarHC .= '<td align="center" width="40"><b>Nro</b></td>';
        $mostrarHC .= '<td align="center" width="85"><b>Factura</b></td>';
        $mostrarHC .= '<td align="center" width="70"><b>CAS</b></td>';
        $mostrarHC .= '<td align="center" width="70"><b>Fecha Atención</b></td>';
        $mostrarHC .= '<td align="center" width="300"><b>Paciente</b></td>';
        $mostrarHC .= '<td align="center" width="105"><b>Vlr. Total</b></td>';
        $mostrarHC .= '<td align="center" width="85"><b>Vlr. CM/Copagos</b></td>';
        $mostrarHC .= '<td align="center" width="85"><b>Vlr. Descuentos</b></td>';
        $mostrarHC .= '<td align="center" width="105"><b>Vlr. Neto</b></td>';
        $mostrarHC .= '</tr>';
        $mostrarHC .= '</table>';
        $pdf->writeHTML($mostrarHC, true, false, false, false, '');
        $rowcount = 1;
    }
    
    function EscribeDetalle(&$pdf, &$row, &$i, &$rowcount, &$contador){
        if ($pdf->GetY() >= ($pdf->getPageHeight()-20)){
            EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta,"SI");
        }
        $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
        $pdf->Ln(-3);
        $AltoLinea = 0;
        $AltoLinea = max($pdf->getNumLines($row[$i]["nomPaciente"], 84),2)*5;
        $pdf->writeHTMLCell(11, $AltoLinea, '', '', $contador, 0, 0, 0, true, 'C', true);
        $pdf->writeHTMLCell(24, $AltoLinea, '', '', $row[$i]["Prefijo"] . "-" . $row[$i]["NroDocumento"], 0, 0, 0, true, 'L', true);
        $pdf->writeHTMLCell(20, $AltoLinea, '', '', $row[$i]["CAS"], 0, 0, 0, true, 'C', true);
        $pdf->writeHTMLCell(20, $AltoLinea, '', '', $row[$i]["Fecha"], 0, 0, 0, true, 'C', true);
        $pdf->writeHTMLCell(84, $AltoLinea, '', '', $row[$i]["nomPaciente"], 0, 0, 0, true, 'L', true);
        $pdf->writeHTMLCell(30, $AltoLinea, '', '', number_format($row[$i]["TVlrTotal"],2,".",","), 0, 0, 0, true, 'R', true);
        $pdf->writeHTMLCell(25, $AltoLinea, '', '', number_format(($row[$i]["TCM"] + $row[$i]["TCOPAGOS"]),2,".",","), 0, 0, 0, true, 'R', true);
        $pdf->writeHTMLCell(24, $AltoLinea, '', '', number_format($row[$i]["TVlrDescuentos"],2,".",","), 0, 0, 0, true, 'R', true);
        $pdf->writeHTMLCell(30, $AltoLinea, '', '', number_format($row[$i]["TVlrNeto"],2,".",","), 0, 0, 0, true, 'R', true);
        $pdf->Ln($AltoLinea);
        if ($pdf->GetY() >= ($pdf->getPageHeight()-20)){
            EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta,"SI");
        }
    }
    
    function PieGrupo(&$pdf, &$row, &$i, &$rowcount, &$contador, &$pDesde, &$pHasta, $totSubTotal_c,$totCopagos_c,$totDescuentos_c,$totNeto_c){
        if ($pdf->GetY() >= ($pdf->getPageHeight()-20)){
            EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta,"SI");
        }
        $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
        $pdf->Ln(-3);
        $AltoLinea = 4;
        $pdf->writeHTMLCell(159, $AltoLinea, '', '', '<b>SUBTOTAL:</b>', 1, 0, 0, true, 'R', true);
        $pdf->writeHTMLCell(30, $AltoLinea, '', '', '<b>' . number_format($totSubTotal_c,2,".",",") . '</b>', 1, 0, 0, true, 'R', true);
        $pdf->writeHTMLCell(25, $AltoLinea, '', '', '<b>' . number_format($totCopagos_c,2,".",",") . '</b>', 1, 0, 0, true, 'R', true);
        $pdf->writeHTMLCell(24, $AltoLinea, '', '', '<b>' . number_format($totDescuentos_c,2,".",",") . '</b>', 1, 0, 0, true, 'R', true);
        $pdf->writeHTMLCell(30, $AltoLinea, '', '', '<b>' . number_format($totNeto_c,2,".",",") . '</b>', 1, 0, 0, true, 'R', true);
        $pdf->Ln(8);
        if ($pdf->GetY() >= ($pdf->getPageHeight()-20)){
            EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta,"SI");
        }
    }
    
    function PieTotal(&$pdf, &$row, &$i, &$rowcount, &$contador, &$pDesde, &$pHasta, $totSubTotal_t,$totCopagos_t,$totDescuentos_t,$totNeto_t){
        if ($pdf->GetY() >= ($pdf->getPageHeight()-20)){
            EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta,"SI");
        }
        $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
        $pdf->Ln(-3);
        $AltoLinea = 4;
        $pdf->writeHTMLCell(159, $AltoLinea, '', '', '<b>TOTAL GENERAL:</b>', 1, 0, 0, true, 'R', true);
        $pdf->writeHTMLCell(30, $AltoLinea, '', '', '<b>' . number_format($totSubTotal_t,2,".",",") . '</b>', 1, 0, 0, true, 'R', true);
        $pdf->writeHTMLCell(25, $AltoLinea, '', '', '<b>' . number_format($totCopagos_t,2,".",",") . '</b>', 1, 0, 0, true, 'R', true);
        $pdf->writeHTMLCell(24, $AltoLinea, '', '', '<b>' . number_format($totDescuentos_t,2,".",",") . '</b>', 1, 0, 0, true, 'R', true);
        $pdf->writeHTMLCell(30, $AltoLinea, '', '', '<b>' . number_format($totNeto_t,2,".",",") . '</b>', 1, 0, 0, true, 'R', true);
        $pdf->Ln(8);
        if ($pdf->GetY() >= ($pdf->getPageHeight()-20)){
            EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta,"SI");
        }
    }
?>
