<?php
    //set_time_limit(500);
    require_once('../../../../lib/tcpdf/config/lang/spa.php');
    require_once('../../../../lib/tcpdf/tcpdf.php');
    require("../../../../core/php/_database.php");
    require("../../../../core/php/php_functions.php");
    header('Content-type: application/pdf; charset: UTF-8');
    
    $estructura = explode("¬", $_REQUEST['param']);
    $pNomParametros = spNomParametrosMI($estructura,"NO");
    $NameParam = explode("¬", $pNomParametros);
    $pParametros = spParametrosMI($estructura,"NO");
    $DataParam = explode("¬", $pParametros);
    
    $items = count($NameParam);
    for ($i=0; $i<$items; $i++)
    {
        switch ($NameParam[$i]) 
        {
            case "intEmpresa":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                    $pEmpresa = 0;
                else
                    $pEmpresa = $DataParam[$i];
                break;
                
            case "intIPS":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                    $pIPS = 0;
                else
                    $pIPS = $DataParam[$i];
                break;
                
            case "intCliente":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                    $pCliente = 0;
                else
                    $pCliente = $DataParam[$i];
                break;
                
            case "intPlan":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                    $pPlan = 0;
                else
                    $pPlan = $DataParam[$i];
                break;
                
            case "intSubPlan":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                    $pSubPlan = 0;
                else
                    $pSubPlan = $DataParam[$i];
                break;
                
            case "fecDesde":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {    
                    $pDesde = date('Y-m-d');
                }else{
                    $pDesde = $DataParam[$i];
                }
                break;
                
            case "fecHasta":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pHasta = date('Y-m-d');
                }else{
                    $pHasta = $DataParam[$i];
                }
                break;
                
            case "strCampo1":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pCampo1 = 'NO';
                }else{
                    $pCampo1 = $DataParam[$i];
                }
                break;
            
            case "strCampo2":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pCampo2 = 'NO';
                }else{
                    $pCampo2 = $DataParam[$i];
                }
                break;
            
            case "strCampo3":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pCampo3 = 'NO';
                }else{
                    $pCampo3 = $DataParam[$i];
                }
                break;
            
            case "intContrato":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pContrato = 0;
                }else{
                    $pContrato = $DataParam[$i];
                }
                break;
                
            case "intTipoEstudio":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pTipoEstudio = 0;
                }else{
                    $pTipoEstudio = $DataParam[$i];
                }
                break;
                
            case "strPaciente":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pPaciente = 'Todos';
                }else{
                    $pPaciente = $DataParam[$i];
                }
                break;
                
            case "strAutorizacion":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pAutorizacion = 'Todos';
                }else{
                    $pAutorizacion = $DataParam[$i];
                }
                break;
            
            default:
                break;
        }
    }
    //1,1,0,0,0,"2011-08-01","2011-08-31","CAS","NO","NO"
    //pContrato int, pPaciente varchar(50), pAutorizacion varchar(50)
    $qry = "CALL sp_macroinformes_laboratorio_remisionesxtipest('" . $pEmpresa . "','" . $pIPS . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "','" . $pTipoEstudio . "',\"" . $pPaciente . "\",\"" . $pAutorizacion . "\",\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pCampo1 . "\",\"" . $pCampo2 . "\",\"" . $pCampo3 . "\")";
    //echo $qry;
    // create new PDF document
    $pdf = new TCPDF("P", PDF_UNIT, "CARTA", true, 'UTF-8', false);

    // set document information
    $pdf->SetCreator(PDF_CREATOR);
    $pdf->SetAuthor('Sistemas Ofisalud © - 2011');
    $pdf->SetTitle('LABORATORIO');
    $pdf->SetSubject('Informe Orden Trabajo');

    // set default header data
    session_start();
    $pdf->pAlineacionEncabezado = "P";
    $pdf->pTituloInforme = "INFORME REMISIONES LABORATORIO";
    $pdf->pImprimeLogo = "NO";
    $pdf->pAnchoTxtPagina = 270;
    $pdf->pNomEmpresa = $_SESSION['NOM_EMPRESA'];
    $pdf->pNomSede = $_SESSION['NOM_SEDE'];
    $pdf->pNomIPS = $_SESSION['NOM_IPS'];
    $pdf->pMargenPie = -20;
    if($_SESSION['IdAplicacion'] == "OfiMedical"){
        $pdf->pLogoCliente = "../../../consultoriovirtual/" . $_SESSION['IDBD'] . "/logo/logoenc.gif";
    }else{
        $pdf->pLogoCliente = "../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/logoenc.gif";
    }

    $pdf->SetHeaderData($pdf->pLogoCliente, PDF_HEADER_LOGO_WIDTH, $pdf->pTituloInforme, PDF_HEADER_STRING);
    // set header and footer fonts
    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
    // set default monospaced font
    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
    //set margins
    $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
    $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
    $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
    //set auto page breaks
    $pdf->SetAutoPageBreak(FALSE, PDF_MARGIN_BOTTOM);
    //set image scale factor
    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
    //set some language-dependent strings
    $pdf->setLanguageArray($l);
    // set default font subsetting mode
    $pdf->setFontSubsetting(true);
    $pdf->SetFont('dejavusans', '', 14, '', true);

    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $idCliente = "-1";
    $idPlan = "-1";
    $idSubPlan = "-1";
    $contador = 0;
    $pImprimePieCliente = "No";
    $pImprimePiePlan = "No";
    $pImprimePieSubPlan = "No";
    $pUltimoRegistro = "No";
    while ($row[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
    $pRegistros = count($row)-1;
    $rowcount = 5;
    $i = 0;
    $idCAS = "";
    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
    for($i=0;$i<$pRegistros;$i++){
        if($row[$i]["Cliente"] != ""){
            if ($idCAS != $row[$i]["CAS"]){
                $contador = 0;
                EncabezadoCAS($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $contador ++;
            $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 9);
            $rowcount = max($pdf->getNumLines(utf8_decode($row[$i]["nomPaciente"] . " - Fecha Nac: " . $row[$i]["FecNac"] . " - Edad: " . $row[$i]["pacAnios"] . " Años " . $row[$i]["pacMeses"] . " Meses"), 85),$pdf->getNumLines(utf8_decode($row[$i]["CodProcedimiento"]) . "-" . utf8_decode($row[$i]["DescProcedimiento"]), 85))*4;
            EscribeDetalle($pdf, $row, $i, $rowcount, $contador);
            $pUltimoRegistro = "No";
            if($row[$i+1]["Cliente"] == $idCliente){
                $pImprimePieCliente = "No";
                if ($row[$i+1]["Plan"] != $idPlan)
                    $pImprimePiePlan = "Si";
                else
                    $pImprimePiePlan = "No";
                if ($row[$i+1]["SubPlan"] != $idSubPlan)
                    $pImprimePieSubPlan = "Si";
                else
                    $pImprimePieSubPlan = "No";
            }else{
                $pImprimePieCliente = "Si";
                $pImprimePiePlan = "Si";
                $pImprimePieSubPlan = "Si";
                $pUltimoRegistro = "Si";
            }
            if (($pdf->GetY()+$rowcount) > 247){
                EncabezadoPaginaCAS($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $idCAS = $row[$i]["CAS"];
        }
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $pdf->Output('infRemisionesLaboratorio.pdf', 'I');

    function EncabezadoCAS(&$pdf, &$row, &$i, &$rowcount, &$contador, &$pDesde, &$pHasta){
        $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 10);
        $pdf->Ln(4.5);
        $pdf->writeHTMLCell(201, 3, '', '', "<hr>", 0, 0, 0, true, 'L', true);
        $pdf->Ln(4.5);
        $pdf->writeHTMLCell(201, $rowcount+6, '', '', "<b>Paciente:</b> " . $row[$i]["nomPaciente"], 0, 0, 0, true, 'L', true);
        $pdf->Ln(4.5);
        $pdf->writeHTMLCell(201, $rowcount+6, '', '', "<b>Fecha Nac:</b> " . $row[$i]["FecNac"] . " <b>- Edad:</b> " . utf8_decode($row[$i]["pacAnios"]) . " Años " . utf8_decode($row[$i]["pacMeses"]) . " Meses" . utf8_decode($row[$i]["Genero"]), 0, 0, 0, true, 'L', true);
        $pdf->Ln(4.5);
        $pdf->writeHTMLCell(150, $rowcount+6, '', '', "<b><u>Examenes Solicitados:</u></b>", 0, 0, 0, true, 'L', true);
        $pdf->writeHTMLCell(51, $rowcount+6, '', '', "<b>CAS:</b>" . $row[$i]["CAS"], 0, 0, 0, true, 'R', true);
        $pdf->Ln(4.5);
    }
    
    function EncabezadoPaginaCAS(&$pdf, &$row, &$i, &$rowcount, &$contador, &$pDesde, &$pHasta){
        $pdf->pTituloInforme = "REMISIONES";
        $pdf->AddPage();
        $pdf->SetFont(PDF_FONT_NAME_MAIN,'B',11);
        $pdf->MultiCell(90,10,"Periodo: " . $pDesde . " - " . $pHasta ,0,'L',0,0);
        $pdf->MultiCell(111,10,$row[$i]["TipoEstudio"] ,0,'R',0,0);
        $pdf->SetFillColor(242 , 236, 236);
        $pdf->Ln(4.5);
        $CASActual = $row[$i]["CAS"];
        if ($CASActual == $row[$i+1]["CAS"]){
            $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 10);
            $pdf->Ln(4.5);
            $pdf->writeHTMLCell(201, 3, '', '', "<hr>", 0, 0, 0, true, 'L', true);
            $pdf->Ln(4.5);
            $pdf->writeHTMLCell(201, $rowcount+6, '', '', "<b>Paciente:</b> " . $row[$i]["nomPaciente"], 0, 0, 0, true, 'L', true);
            $pdf->Ln(4.5);
            $pdf->writeHTMLCell(201, $rowcount+6, '', '', "<b>Fecha Nac:</b> " . $row[$i]["FecNac"] . " <b>- Edad:</b> " . utf8_decode($row[$i]["pacAnios"]) . " Años " . utf8_decode($row[$i]["pacMeses"]) . " Meses" . utf8_decode($row[$i]["Genero"]), 0, 0, 0, true, 'L', true);
            $pdf->Ln(4.5);
            $pdf->writeHTMLCell(150, $rowcount+6, '', '', "<b><u>Examenes Solicitados:</u></b>", 0, 0, 0, true, 'L', true);
            $pdf->writeHTMLCell(51, $rowcount+6, '', '', "<b>CAS:</b>" . $row[$i]["CAS"], 0, 0, 0, true, 'R', true);
            $pdf->Ln(4.5);
        }
    }
    
    function EncabezadoPagina(&$pdf, &$row, &$i, &$rowcount, &$contador, &$pDesde, &$pHasta){
        $pdf->pTituloInforme = "REMISIONES";
        $pdf->AddPage();
        $pdf->SetFont(PDF_FONT_NAME_MAIN,'B',11);
        $pdf->MultiCell(90,10,"Periodo: " . $pDesde . " - " . $pHasta ,0,'L',0,0);
        $pdf->MultiCell(111,10,$row[$i]["TipoEstudio"] ,0,'R',0,0);
        $pdf->Ln(4.5);
        $pdf->SetFillColor(242 , 236, 236);
    }
    
    function EscribeDetalle(&$pdf, &$row, &$i, &$rowcount, &$contador){
        $pdf->writeHTMLCell(10, $rowcount-3, '', '', number_format($contador,0,".",","), 0, 0, 0, true, 'C', true);
        $pdf->writeHTMLCell(191, $rowcount-3, '', '', utf8_decode($row[$i]["CodProcedimiento"]) . "-" . utf8_decode($row[$i]["DescProcedimiento"]) . "-" . utf8_decode($row[$i]["Observaciones"]), 0, 0, 0, true, 'L', true);
        $pdf->Ln();
    }
?>
