<?php
    set_time_limit(500);
    require_once('../../../../../lib/tcpdf/config/lang/spa.php');
    require_once('../../../../../lib/tcpdf/tcpdf.php');
    require("../../../../../core/php/_database.php");
    require("../../../../../core/php/php_functions.php");
    header('Content-type: application/pdf; charset: UTF-8');
    
    $estructura = explode("¬", $_REQUEST['param']);
    $pNomParametros = spNomParametrosMI($estructura,"NO");
    $NameParam = explode("¬", $pNomParametros);
    $pParametros = spParametrosMI($estructura,"NO");
    $DataParam = explode("¬", $pParametros);
    
    $items = count($NameParam);
    for ($i=0; $i<$items; $i++)
    {
        switch ($NameParam[$i]) 
        {
            case "intBodegaVentaPOS":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                    $pBodega = 0;
                else
                    $pBodega = $DataParam[$i];
                break;
            
           case "intEmpresa":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                    $pEmpresa = 0;
                else
                    $pEmpresa = $DataParam[$i];
                break;
                
            case "intIPS":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                    $pIPS = 0;
                else
                    $pIPS = $DataParam[$i];
                break;
                
            case "fecDesde":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {    
                    $pDesde = date('Y-m-d');
                }else{
                    $pDesde = $DataParam[$i];
                }
                break;
                
            case "fecHasta":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pFiltroFechas = 'n';
                }else{
                    $pHasta = $DataParam[$i];
                }
                break;
                
            default:
                break;
        }
    }
    $qry = "CALL sp_macroinformes_pos_caja_recaudosdiarios('" . $pEmpresa . "','" . $pIPS . "','" . $pBodega . "',\"" . $pDesde . "\",\"" . $pHasta . "\")";
    
    // create new PDF document
    $pdf = new TCPDF("L", PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

    // set document information
    $pdf->SetCreator(PDF_CREATOR);
    $pdf->SetAuthor('Sistemas Ofisalud © - 2011');
    $pdf->SetTitle('CAJA');
    $pdf->SetSubject('Informe Recaudos Diarios');

    // set default header data
    session_start();
    $pdf->pAlineacionEncabezado = "L";
    $pdf->pTituloInforme = "INFORME RECAUDOS DIARIOS";
    $pdf->pImprimeLogo = "NO";
    $pdf->pAnchoTxtPagina = 270;
    $pdf->pNomEmpresa = $_SESSION['NOM_EMPRESA'];
    $pdf->pNomSede = $_SESSION['NOM_SEDE'];
    $pdf->pNomIPS = $_SESSION['NOM_IPS'];
    $pdf->pMargenPie = -20;
    if($_SESSION['IdAplicacion'] == "OfiMedical"){
        $pdf->pLogoCliente = "../../../consultoriovirtual/" . $_SESSION['IDBD'] . "/logo/logoenc.gif";
    }else{
        $pdf->pLogoCliente = "../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/logoenc.gif";
    }

    $pdf->SetHeaderData($pdf->pLogoCliente, PDF_HEADER_LOGO_WIDTH, $pdf->pTituloInforme, PDF_HEADER_STRING);
    // set header and footer fonts
    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
    // set default monospaced font
    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
    //set margins
    $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
    $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
    $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
    //set auto page breaks
    $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
    //set image scale factor
    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
    //set some language-dependent strings
    $pdf->setLanguageArray($l);
    // set default font subsetting mode
    $pdf->setFontSubsetting(true);
    $pdf->SetFont('dejavusans', '', 14, '', true);

    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $pdf->AddPage();
    $pdf->SetFont(PDF_FONT_NAME_MAIN,'B',11);
    $pdf->MultiCell(264,10,"Periodo: " . $pDesde . " - " . $pHasta ,0,'L',0,0);
    $pdf->Ln(4.5);
    $pdf->SetFillColor(242 , 236, 236);
    $pdf->SetFont(PDF_FONT_NAME_MAIN,'B',9);
    $pdf->MultiCell(40,5,"Documento",1,'C',1,0);
    $pdf->MultiCell(25,5,"Fecha",1,'C',1,0);
    $pdf->MultiCell(45,5,"Cliente",1,'C',1,0);
    $pdf->MultiCell(45,5,"Paciente",1,'C',1,0);
    $pdf->MultiCell(30,5,"Vlr Recaudo",1,'C',1,0);
    $pdf->MultiCell(45,5,"Usuario",1,'C',1,0);
    $pdf->MultiCell(35,5,"Observaciones",1,'C',1,0);
    $pdf->Ln();
    $vlrtot = 0;
    while ($row = @mysqli_fetch_row($gBaseDatos->QryID))
    {
        $arrfila = array();   
        $rowcount = 0;
        $fill = 0;
        $rowcount = max($pdf->getNumLines(utf8_decode($row[7]) . "<br>" . utf8_decode($row[8]), 40),$pdf->getNumLines(utf8_decode($row[7]), 45),$pdf->getNumLines(utf8_decode($row[5]), 45),$pdf->getNumLines(utf8_decode($row[6]), 45),$pdf->getNumLines(utf8_decode($row[6]), 30),$pdf->getNumLines(utf8_decode($row[12]) . " " . utf8_decode($row[13]), 35)) * 2;
        $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
        if (utf8_decode($row[11])=='1')
        {
            $pdf->SetFillColor(241 , 194, 194);
            $fill = 0;
        }else{
            $fill = 0;
        }
        if (utf8_decode($row[11])=='1' && utf8_decode($row[10]) < 0){
            $pdf->SetTextColor(255, 64, 64); 
        }else{
            $pdf->SetTextColor(0, 0, 0); 
        }
        //Documento
        //$pdf->MultiCell(40,$rowcount,utf8_decode($row[2]) . " - " . utf8_decode($row[3]),1,'L',$fill,0);
        $pdf->writeHTMLCell(40, $rowcount, '', '', utf8_decode($row[2]) . " - " . utf8_decode($row[3]) . "<br>CAS: " . utf8_decode($row[8]), 0, 0, $fill, true, 'L', true);
        //Fecha
        //$pdf->MultiCell(25,$rowcount,utf8_decode($row[4]),1,'L',$fill,0);
        $pdf->writeHTMLCell(25, $rowcount, '', '', utf8_decode($row[4]), 0, 0, $fill, true, 'L', true);
        //Cliente
        //$pdf->MultiCell(45,$rowcount,utf8_decode($row[5]),1,'L',$fill,0);
        $pdf->writeHTMLCell(45, $rowcount, '', '', utf8_decode($row[5]), 0, 0, $fill, true, 'L', true);
        //Paciente
        //$pdf->MultiCell(45,$rowcount,utf8_decode($row[6]),1,'L',$fill,0);
        $pdf->writeHTMLCell(45, $rowcount, '', '', utf8_decode($row[6]), 0, 0, $fill, true, 'L', true);
        //Valor
        //$pdf->MultiCell(30,$rowcount,number_format(utf8_decode($row[10]),2,".",","),1,'R',$fill,0);
        $pdf->writeHTMLCell(30, $rowcount, '', '', number_format(utf8_decode($row[10]),2,".",","), 0, 0, $fill, true, 'R', true);
        //Usuario
        //$pdf->MultiCell(45,$rowcount,utf8_decode($row[7]),1,'L',$fill,0);
        $pdf->writeHTMLCell(45, $rowcount, '', '', utf8_decode($row[7]), 0, 0, $fill, true, 'L', true);
        $vlrtot += $row[10];
        //Observaciones
        if (utf8_decode($row[12])==null || utf8_decode($row[12])=="")
        {
            $pdf->MultiCell(35,$rowcount,"",0,'L',$fill,0);
        }else{
            //$pdf->MultiCell(35,$rowcount,utf8_decode($row[12]) . " Usr: " . utf8_decode($row[13]) ,1,'L',$fill,0);
            $pdf->writeHTMLCell(35, $rowcount, '', '', utf8_decode($row[12]) . " Usr: " . utf8_decode($row[13]), 0, 0, $fill, true, 'L', true);
        }
        $pdf->SetTextColor(0, 0, 0); 
        $controlAgenda = $row[21];
        $pdf->Ln();
        if ($pdf->GetY() < 180)
            $pdf->Ln();
        else
        {
            $pdf->AddPage();
            $pdf->SetFont(PDF_FONT_NAME_MAIN,'B',11);
            $pdf->MultiCell(264,10,"Periodo: " . $pDesde . " - " . $pHasta ,0,'L',0,0);
            $pdf->Ln(4.5);
            $pdf->SetFillColor(242 , 236, 236);
            $pdf->SetFont(PDF_FONT_NAME_MAIN,'B',9);
            $pdf->MultiCell(40,5,"Documento",1,'C',1,0);
            $pdf->MultiCell(25,5,"Fecha",1,'C',1,0);
            $pdf->MultiCell(45,5,"Cliente",1,'C',1,0);
            $pdf->MultiCell(45,5,"Paciente",1,'C',1,0);
            $pdf->MultiCell(30,5,"Vlr Recaudo",1,'C',1,0);
            $pdf->MultiCell(45,5,"Usuario",1,'C',1,0);
            $pdf->MultiCell(35,5,"Observaciones",1,'C',1,0);
            $pdf->Ln();
        }
    }
    $pdf->SetFillColor(242 , 236, 236);
    $pdf->MultiCell(155,5,"VALOR TOTAL",1,'R',1,0);
    $pdf->MultiCell(30,5,number_format($vlrtot,2,".",","),1,'R',1,0);
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();

    $pdf->AddPage();
    $pdf->SetFont(PDF_FONT_NAME_MAIN,'B',11);
    $pdf->MultiCell(264,10,"RESUMEN POR USUARIO" ,0,'L',0,0);
    $pdf->Ln(4.5);
    $pdf->SetFont(PDF_FONT_NAME_MAIN,'B',9);
    $pdf->MultiCell(55,5,"Usuario",1,'L',1,0);
    $pdf->MultiCell(40,5,"Vlr Recaudo",1,'R',1,0);
    $pdf->Ln();
    
    $qry = "CALL sp_macroinformes_pos_caja_recaudosdiarios_01_usuario('" . $pEmpresa . "','" . $pIPS . "','" . $pBodega . "',\"" . $pDesde . "\",\"" . $pHasta . "\")";
    $gBaseDatos->conectar();
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $vlrtot = 0;
    while ($row = @mysqli_fetch_row($gBaseDatos->QryID))
    {
        $arrfila = array();   
        $rowcount = 0;
        $fill = 0;
        $rowcount = max($pdf->getNumLines(utf8_decode($row[0]), 55),1) * 3;
        $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
        $vlrtot += $row[1];
        //Usuario
        //$pdf->MultiCell(55,$rowcount,utf8_decode($row[0]),1,'L',$fill,0);
        $pdf->writeHTMLCell(55, $rowcount, '', '', utf8_decode($row[0]), 1, 0, $fill, true, 'L', true);
        //Valor
        $pdf->MultiCell(40,$rowcount,number_format(utf8_decode($row[1]),2,".",","),1,'R',$fill,0);
        if ($pdf->GetY() < 150)
            $pdf->Ln();
        else
        {
            $pdf->AddPage();
            $pdf->SetFont(PDF_FONT_NAME_MAIN,'B',11);
            $pdf->MultiCell(264,10,"RESUMEN POR USUARIO" ,0,'L',0,0);
            $pdf->Ln(4.5);
            $pdf->SetFont(PDF_FONT_NAME_MAIN,'B',9);
            $pdf->MultiCell(55,5,"Usuario",1,'L',1,0);
            $pdf->MultiCell(40,5,"Vlr Recaudo",1,'R',1,0);
            $pdf->Ln();
        }
    }
    $pdf->SetFillColor(242 , 236, 236);
    $pdf->MultiCell(55,5,"VALOR TOTAL",1,'R',1,0);
    $pdf->MultiCell(40,5,number_format($vlrtot,2,".",","),1,'R',1,0);
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    
    if ($pdf->GetY() < 180)
    {
        $pdf->Ln();
        $pdf->Ln();
        $pdf->SetFont(PDF_FONT_NAME_MAIN,'B',11);
        $pdf->MultiCell(264,10,"RESUMEN POR CLIENTE" ,0,'L',0,0);
        $pdf->Ln(4.5);
        $pdf->SetFont(PDF_FONT_NAME_MAIN,'B',9);
        $pdf->MultiCell(85,5,"Cliente",1,'L',1,0);
        $pdf->MultiCell(40,5,"Vlr Recaudo",1,'R',1,0);
        $pdf->Ln();
    }else{
        $pdf->AddPage();
        $pdf->SetFont(PDF_FONT_NAME_MAIN,'B',11);
        $pdf->MultiCell(264,10,"RESUMEN POR CLIENTE" ,0,'L',0,0);
        $pdf->Ln(4.5);
        $pdf->SetFont(PDF_FONT_NAME_MAIN,'B',9);
        $pdf->MultiCell(85,5,"Cliente",1,'L',1,0);
        $pdf->MultiCell(40,5,"Vlr Recaudo",1,'R',1,0);
        $pdf->Ln();
    }
    
    $qry = "CALL sp_macroinformes_pos_caja_recaudosdiarios_02_cliente('" . $pEmpresa . "','" . $pIPS . "','" . $pBodega . "',\"" . $pDesde . "\",\"" . $pHasta . "\")";
    $gBaseDatos->conectar();
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $vlrtot = 0;
    while ($row = @mysqli_fetch_row($gBaseDatos->QryID))
    {
        $arrfila = array();   
        $rowcount = 0;
        $fill = 0;
        $rowcount = max($pdf->getNumLines(utf8_decode($row[0]), 55),1) * 3;
        $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
        $vlrtot += $row[1];
        //Usuario
        //$pdf->MultiCell(85,$rowcount,utf8_decode($row[0]),1,'L',$fill,0);
        $pdf->writeHTMLCell(85, $rowcount, '', '', utf8_decode($row[0]), 1, 0, $fill, true, 'L', true);
        //Valor
        $pdf->MultiCell(40,$rowcount,number_format(utf8_decode($row[1]),2,".",","),1,'R',$fill,0);
        if ($pdf->GetY() < 180)
            $pdf->Ln();
        else
        {
            $pdf->AddPage();
            $pdf->SetFont(PDF_FONT_NAME_MAIN,'B',11);
            $pdf->MultiCell(264,10,"RESUMEN POR CLIENTE" ,0,'L',0,0);
            $pdf->Ln(4.5);
            $pdf->SetFont(PDF_FONT_NAME_MAIN,'B',9);
            $pdf->MultiCell(85,5,"CLIENTE",1,'L',1,0);
            $pdf->MultiCell(40,5,"Vlr Recaudo",1,'R',1,0);
            $pdf->Ln();
        }
    }
    $pdf->SetFillColor(242 , 236, 236);
    $pdf->MultiCell(85,5,"VALOR TOTAL",1,'R',1,0);
    $pdf->MultiCell(40,5,number_format($vlrtot,2,".",","),1,'R',1,0);
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    
    $pdf->Output('infRecaudosDiario.pdf', 'I');

?>
