<?php
    // 0 - Llamar Libreria
    require_once('../../../lib/tcpdf/config/lang/spa.php');
    require_once('../../../lib/tcpdf/tcpdf.php');
    require("../../../core/php/_database.php");
    require("../../../core/php/php_functions.php");
    header('Content-type: application/pdf; charset: UTF-8');
    
    //1 - Iniciar Clase
    $pdf = new TCPDF("P", PDF_UNIT, "CARTA", true, 'UTF-8', false);

    // set document information
    $pdf->SetCreator(PDF_CREATOR);
    $pdf->SetAuthor('Sistemas Ofisalud © - 2011');
    $pdf->SetTitle('AUDITORIA');
    $pdf->SetSubject('Informe Detallado Ordenes Sin Facturar');

    // set default header data
    session_start();
    $pdf->pAlineacionEncabezado = "P";
    $pdf->pTituloInforme = "PRUEBA";
    $pdf->pImprimeLogo = "NO";
    $pdf->pAnchoTxtPagina = 270;
    $pdf->pNomEmpresa = $_SESSION['NOM_EMPRESA'];
    $pdf->pNomSede = $_SESSION['NOM_SEDE'];
    $pdf->pNomIPS = $_SESSION['NOM_IPS'];
    $pdf->pMargenPie = -20;
    $pdf->pLogoCliente = "../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/logoenc.gif";

    $pdf->SetHeaderData($pdf->pLogoCliente, PDF_HEADER_LOGO_WIDTH, $pdf->pTituloInforme, PDF_HEADER_STRING);
    // set header and footer fonts
    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
    // set default monospaced font
    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
    //set margins
    $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
    $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
    $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
    //set auto page breaks
    $pdf->SetAutoPageBreak(FALSE, PDF_MARGIN_BOTTOM);
    //set image scale factor
    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
    //set some language-dependent strings
    $pdf->setLanguageArray($l);
    // set default font subsetting mode
    $pdf->setFontSubsetting(true);
    $pdf->SetFont('dejavusans', '', 14, '', true);

    $pdf->SetFillColor(242 , 236, 236);
    
    $qry = "CALL 2012_sp_prueba()";
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    while ($row[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
    $pRegistros = count($row)-1;
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $pdf->SetFont(PDF_FONT_NAME_MAIN, 'B', 9);
    EncabezadoPagina($pdf, $row, $i);
    for($i=0;$i<$pRegistros;$i++){
        if($row[$i]["Documento"] != ""){
            $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 9);
            $pdf->writeHTMLCell(30, 5, '', '', $row[$i]["Documento"] , 0, 0, 0, true, 'L', true);
            $pdf->writeHTMLCell(45, 5, '', '', $row[$i]["PrimerNombre"] , 0, 0, 0, true, 'L', true);
            $pdf->writeHTMLCell(45, 5, '', '', $row[$i]["SegundoNombre"] , 0, 0, 0, true, 'L', true);
            $pdf->writeHTMLCell(42, 5, '', '', $row[$i]["PrimerApellido"] , 0, 0, 0, true, 'L', true);
            $pdf->writeHTMLCell(40, 5, '', '', $row[$i]["SegundoApellido"] , 0, 0, 0, true, 'L', true);
            if (($pdf->GetY()+$rowcount) > 250)
            {
                EncabezadoPagina($pdf, $row, $i);
            }
            $pdf->Ln();
        }
    }
    
    $pdf->Output('infEjemplo.pdf', 'I');

    
    function EncabezadoPagina(&$pdf, &$row, &$i){
        $pdf->AddPage();
        $pdf->SetFont(PDF_FONT_NAME_MAIN, 'B', 9);
        $pdf->SetFillColor(242 , 236, 236);
        $pdf->writeHTMLCell(30, 5, '', '', "Documento" , 1, 0, 1, true, 'L', true);
        $pdf->writeHTMLCell(45, 5, '', '', "Primer Nombre" , 1, 0, 1, true, 'L', true);
        $pdf->writeHTMLCell(45, 5, '', '', "Segundo Nombre" , 1, 0, 1, true, 'L', true);
        $pdf->writeHTMLCell(42, 5, '', '', "Primer Apellido" , 1, 0, 1, true, 'L', true);
        $pdf->writeHTMLCell(40, 5, '', '', "Segundo Apellido" , 1, 0, 1, true, 'L', true);
        $pdf->Ln();
    }

?>