<?php
    set_time_limit(500);
    require_once('../../../lib/tcpdf/config/lang/spa.php');
    require_once('../../../lib/tcpdf/tcpdf.php');
    require("../../../core/php/_database.php");
    require("../../../core/php/php_functions.php");
    header('Content-type: application/pdf; charset: UTF-8');
    
    $estructura = explode("¬", $_REQUEST['param']);
    $pNomParametros = spNomParametrosMI($estructura,"NO");
    $NameParam = explode("¬", $pNomParametros);
    $pParametros = spParametrosMI($estructura,"NO");
    $DataParam = explode("¬", $pParametros);
    
    $items = count($NameParam);
    for ($i=0; $i<$items; $i++)
    {
        switch ($NameParam[$i]) 
        {
            case "intEmpresa":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                    $pEmpresa = 0;
                else
                    $pEmpresa = $DataParam[$i];
                break;
                
            case "intIPS":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                    $pIPS = 0;
                else
                    $pIPS = $DataParam[$i];
                break;
                
            case "fecDesde":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {    
                    $pDesde = date('Y-m-d');
                }else{
                    $pDesde = $DataParam[$i];
                }
                break;
                
            case "fecHasta":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pFiltroFechas = 'n';
                }else{
                    $pHasta = $DataParam[$i];
                }
                break;
                
            default:
                break;
        }
    }
    
    // create new PDF document
    $pdf = new TCPDF("P", PDF_UNIT, "CARTA", true, 'UTF-8', false);
    // set document information
    $pdf->SetCreator(PDF_CREATOR);
    $pdf->SetAuthor('Sistemas Ofisalud © - 2011');
    $pdf->SetTitle('CAJA');
    $pdf->SetSubject('Informe Recaudos Diarios - Resumen por Cliente');

    // set default header data
    session_start();
    //TEMPORAL GURDADO PARA PASISALUD
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $sql = "INSERT INTO zauditorimpresordocumentos (Informe, Usuario, NombreUsuario, NombreIPS, Fecha, Hora) VALUES (\"INFORME RESUMEN RECAUDOS POR CLIENTE\",'" . $_SESSION['ID_USUARIO'] . "',\"" . $_SESSION['NOM_USUARIO'] . "\",\"" . $_SESSION['NOM_IPS'] . "\", now(),now())";
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $sql);
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    //*********************************
    $pdf->pAlineacionEncabezado = "P";
    $pdf->pTituloInforme = "INFORME RECAUDOS DIARIOS - RESUMEN POR CLIENTE";
    $pdf->pImprimeLogo = "NO";
    $pdf->pAnchoTxtPagina = 210;
    $pdf->pNomEmpresa = $_SESSION['NOM_EMPRESA'];
    $pdf->pNomSede = $_SESSION['NOM_SEDE'];
    $pdf->pNomIPS = $_SESSION['NOM_IPS'];
    $pdf->pMargenPie = -20;
    if($_SESSION['IdAplicacion'] == "OfiMedical"){
        $pdf->pLogoCliente = "../../../consultoriovirtual/" . $_SESSION['IDBD'] . "/logo/logoenc.gif";
    }else{
        $pdf->pLogoCliente = "../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/logoenc.gif";
    }
    
    $pdf->SetHeaderData($pdf->pLogoCliente, PDF_HEADER_LOGO_WIDTH, $pdf->pTituloInforme, PDF_HEADER_STRING);
    // set header and footer fonts
    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
    // set default monospaced font
    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
    //set margins
    $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
    $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
    $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
    //set auto page breaks
    $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
    //set image scale factor
    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
    //set some language-dependent strings
    $pdf->setLanguageArray($l);
    // set default font subsetting mode
    $pdf->setFontSubsetting(true);
    $pdf->SetFont('dejavusans', '', 14, '', true);

    $pdf->AddPage();
    $pdf->SetFont(PDF_FONT_NAME_MAIN,'B',11);
    $pdf->MultiCell(200,10,"Periodo: " . $pDesde . " - " . $pHasta ,0,'L',0,0);
    $pdf->Ln(6.5);
    $pdf->SetFillColor(242 , 236, 236);
    $pdf->SetFont(PDF_FONT_NAME_MAIN,'B',9);
    $pdf->MultiCell(85,5,"Cliente",1,'L',1,0);
    $pdf->MultiCell(40,5,"Vlr Recaudo",1,'R',1,0);
    $pdf->Ln();
    $qry = "CALL sp_macroinformes_caja_recaudosdiarios_02_cliente('" . $pEmpresa . "','" . $pIPS . "',\"" . $pDesde . "\",\"" . $pHasta . "\")";
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $vlrtot = 0;
    while ($row = @mysqli_fetch_row($gBaseDatos->QryID))
    {
        $arrfila = array();   
        $rowcount = 0;
        $fill = 0;
        $rowcount = max($pdf->getNumLines(utf8_decode($row[0]), 85),1) * 3;
        $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
        $vlrtot += $row[1];
        //Usuario
        //$pdf->MultiCell(85,$rowcount,utf8_decode($row[0]),1,'L',$fill,0);
        $pdf->writeHTMLCell(85, $rowcount, '', '', utf8_decode($row[0]), 1, 0, $fill, true, 'L', true);
        //Valor
        $pdf->MultiCell(40,$rowcount,number_format(utf8_decode($row[1]),2,".",","),1,'R',$fill,0);
        if ($pdf->GetY() < 180)
            $pdf->Ln();
        else
        {
            $pdf->AddPage();
            $pdf->SetFont(PDF_FONT_NAME_MAIN,'B',11);
            $pdf->MultiCell(200,10,"Periodo: " . $pDesde . " - " . $pHasta ,0,'L',0,0);
            $pdf->Ln(6.5);
            $pdf->SetFillColor(242 , 236, 236);
            $pdf->SetFont(PDF_FONT_NAME_MAIN,'B',9);
            $pdf->MultiCell(85,5,"Cliente",1,'L',1,0);
            $pdf->MultiCell(40,5,"Vlr Recaudo",1,'R',1,0);
            $pdf->Ln();
        }
    }
    $pdf->SetFillColor(242 , 236, 236);
    $pdf->MultiCell(85,5,"VALOR TOTAL",1,'R',1,0);
    $pdf->MultiCell(40,5,number_format($vlrtot,2,".",","),1,'R',1,0);
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    
    $pdf->Output('infRecaudosDiarioResumenCliente.pdf', 'I');

?>
