<?php
function Draw001Genero($rowResultado){
    require_once("../../../../lib/jpgraph/src/jpgraph.php");
    require_once("../../../../lib/jpgraph/src/jpgraph_pie.php");
    require_once("../../../../lib/jpgraph/src/jpgraph_pie3d.php");
    $pNomArch = "chart001.png";
    if (file_exists($pNomArch)) {
        unlink($pNomArch);
    }
    //Cargar Datos del Arreglo
    $data = array($rowResultado[0]["Masculino"],$rowResultado[0]["Femenino"]);
    // Create the Pie Graph.
    $graph = new PieGraph(350,200);
    $graph->SetShadow();
    // Set A title for the plot
    //$graph->title->Set("3.1 DISTRIBUCION PORCENTUAL SEGUN GENERO");
    $graph->title->SetFont(FF_FONT0,FS_BOLD,12); 
    $graph->title->SetColor("darkblue");
    $graph->legend->Pos(0,0.90);
    // Create pie plot
    $p1 = new PiePlot3d($data);
    $p1->SetTheme("sand");
    $p1->SetCenter(0.4);
    $p1->SetAngle(30);
    $p1->value->SetFont(FF_FONT0,FS_NORMAL,8);
    $p1->SetLegends(array("MASCULINO","FEMENINO"));
    $graph->Add($p1);
    $graph->Stroke("chart001.png");
}

function Draw002Edad($aData,$aLabels){
    require_once("../../../../lib/jpgraph/src/jpgraph.php");
    require_once("../../../../lib/jpgraph/src/jpgraph_bar.php");
    $pNomArch = "chart002.png";
    if (file_exists($pNomArch)){
        unlink($pNomArch);
    }
    $datay = $aData;
    $graph = new Graph(350,220,'auto');
    $graph->SetScale("textlin");
    //$graph->yaxis->SetTickPositions(array(0,10,20,30,40,50,60,70,80), array(5,15,25,35,45,55,65,75,85));
    $graph->SetBox(false);
    //$graph->ygrid->SetColor('gray');
    $graph->ygrid->SetFill(false);
    $graph->xaxis->SetTickLabels($aLabels);
    $graph->xaxis->SetFont(FF_FONT0,FS_NORMAL,7);
    $graph->yaxis->HideLine(true);
    $graph->yaxis->HideTicks(false,false);
    // Create the bar plots
    $b1plot = new BarPlot($datay);
    $graph->Add($b1plot);
    $b1plot->value->SetFormat('%01.0f'); 
    $b1plot->value->Show();
    $b1plot->SetColor("white");
    $b1plot->SetFillGradient("#4B0082","white",GRAD_LEFT_REFLECTION);
    $b1plot->SetWidth(35);
    $graph->Stroke("chart002.png");
}

function Draw003General($aData,$aLabels,$Consec){
    require_once("../../../../lib/jpgraph/src/jpgraph.php");
    require_once("../../../../lib/jpgraph/src/jpgraph_bar.php");
    $pNomArch = "chart0" . $Consec . ".png";
    if (file_exists($pNomArch)){
        unlink($pNomArch);
    }
    $datay = $aData;
    $graph = new Graph(350,220,'auto');
    $graph->SetScale("textlin");
    //$graph->yaxis->SetTickPositions(array(0,10,20,30,40,50,60,70,80), array(5,15,25,35,45,55,65,75,85));
    $graph->SetBox(false);
    //$graph->ygrid->SetColor('gray');
    $graph->ygrid->SetFill(false);
    $graph->xaxis->SetTickLabels($aLabels);
    $graph->xaxis->SetFont(FF_FONT0,FS_NORMAL,7);
    $graph->yaxis->HideLine(true);
    $graph->yaxis->HideTicks(false,false);
    // Create the bar plots
    $b1plot = new BarPlot($datay);
    $graph->Add($b1plot);
    $b1plot->value->SetFormat('%01.0f'); 
    $b1plot->value->Show();
    $b1plot->SetColor("white");
    $b1plot->SetFillGradient("#4B0082","white",GRAD_LEFT_REFLECTION);
    $b1plot->SetWidth(35);
    $graph->Stroke($pNomArch);
}

function Draw004General($aData,$aLabels,$Consec){
    require_once("../../../../lib/jpgraph/src/jpgraph.php");
    require_once("../../../../lib/jpgraph/src/jpgraph_bar.php");
    $pNomArch = "chart0" . $Consec . ".png";
    if (file_exists($pNomArch)){
        unlink($pNomArch);
    }
    $datay = $aData;
    $graph = new Graph(350,320,'auto');
    //$graph->img->SetAngle(90); 
    $graph->SetScale("textlin");
    //$graph->yaxis->SetTickPositions(array(0,10,20,30,40,50,60,70,80), array(5,15,25,35,45,55,65,75,85));
    $graph->SetBox(false);
    //$graph->ygrid->SetColor('gray');
    $graph->ygrid->SetFill(false);
    //$graph->xaxis->SetTickLabels($aLabels);
    //$graph->xaxis->SetLabelAngle(60);
    $graph->xaxis->SetFont(FF_FONT0,FS_NORMAL,7);
    $graph->yaxis->HideLine(true);
    $graph->yaxis->HideTicks(false,false);
    // Create the bar plots
    $b1plot = new BarPlot($datay);
    $graph->Add($b1plot);
    $b1plot->value->SetFormat('%01.0f'); 
    $b1plot->value->Show();
    $b1plot->SetColor("white");
    $b1plot->SetFillGradient("#4B0082","white",GRAD_LEFT_REFLECTION);
    $b1plot->SetWidth(25);
    $graph->Stroke($pNomArch);
}

function DevolverElementos($arr, $filtro){
    $pReg = count($arr);
    $TotalElementos = 0;
    for($i=0;$i<$pReg;$i++){
        if($arr[$i] == $filtro){
           $TotalElementos ++; 
        }
    }
    return $TotalElementos;
}
?>