<?php

/*
* @category    Controlador NO POS
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/
header("Content-Type: text/plain; charset=UTF-8");
require("../../../core/php/_database.php");
require("../../../core/php/php_functions.php");
session_start();

$task = '';
if ( isset($_POST['task'])){
  $task = $_POST['task'];
}
switch($task){
    case "guardar":
        GuardarNOPOS();
        break;
    case "modificar":
        ModificarNOPOS();
        break;
    case "GUARDAR_ITEM_NOPOS":
        GuardarItemNOPOS();
        break;
    case "LISTAR_ITEM_NOPOS":
        ListarItemNOPOS();
        break;
    case "ELIMINAR_ITEM_NOPOS":
        EliminarItemNOPOS();
        break;
    case "LISTAR_NOPOS":
        ListarNOPOS();
        break;
    case "ELIMINAR_NOPOS":
        EliminarNOPOS();
        break;
    case "DUPLICAR_NOPOS":
        DuplicarNOPOS();
        break;
    default:
        echo "{failure:true}";
        break;
}

function DuplicarNOPOS(){
    $pIdEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIdIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $pIdSolicitud = isset($_REQUEST['pSolicitud'])?$_REQUEST['pSolicitud']:0;
    $CodInsercion = "PRS-" . $pIdEmpresa . "-SED-0" . "-IPS-" . $pIdIPS . "-USR-" . $pUsuario . "-PAC-" . $pPaciente . "-PROFE-" . $pProfesional . "-CONS-" . date("His");
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_nopos_copy_solicitud(\"" . $CodInsercion  . "\",'" . $pIdSolicitud . "')";
    $CampoLlave = explode("^",$gBaseDatos->jasonSP_arreglo2011($qry));
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    //echo $qry;
    if($CampoLlave[0] > 0){
        $gBaseDatos = new ofiMySQLi();
        $gBaseDatos->conectar();
        $qry = "CALL sp_nopos_copy_solicituditem('" . $pIdSolicitud  . "','" . $CampoLlave[0] . "')";
        @mysqli_query($gBaseDatos->ConexionID, $qry);
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        echo "1";
    }else{
        echo "{success:false}";
    }
}

function EliminarNOPOS(){
    $pIdServicioNOPOS = isset($_REQUEST['pIdServicioNOPOS'])?$_REQUEST['pIdServicioNOPOS']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_nopos_del_solicitud('" . $pIdServicioNOPOS . "')";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo '1';
    else
        echo '0';
    $gBaseDatos->cerrar();
}

function ListarNOPOS(){
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_nopos_solicitud_grid('" . $pPaciente . "')";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = PonerAcentosHTML($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}

function EliminarItemNOPOS(){
    $pIdServicioNOPOS = isset($_REQUEST['pIdServicioNOPOS'])?$_REQUEST['pIdServicioNOPOS']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_nopos_delitem_solicitud('" . $pIdServicioNOPOS . "')";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo '1';
    else
        echo '0';
    $gBaseDatos->cerrar();
}

function ListarItemNOPOS(){
    $pIdSolicitud = isset($_REQUEST['pIdSolicitud'])?$_REQUEST['pIdSolicitud']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_nopos_solicitud_griditem('" . $pIdSolicitud . "')";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = PonerAcentosHTML($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}


function GuardarItemNOPOS(){
    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_nopos_additem_solicitud(" . spParametros($estructura,"SI") . ")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry)){
        echo "{success: true, requestedId:'1'}";
    }else{
        echo "{success: true, requestedId:'0'}";
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
}

function GuardarNOPOS(){
    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $pIdEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIdIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $CodInsercion = "PRS-" . $pIdEmpresa . "-SED-0" . "-IPS-" . $pIdIPS . "-USR-" . $pUsuario . "-PAC-" . $pPaciente . "-PROFE-" . $pProfesional . "-CONS-" . date("His");
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_nopos_add_solicitud(\"" . $CodInsercion  . "\"," . spParametros($estructura,"SI") . ")";
    $CampoLlave = explode("^",$gBaseDatos->jasonSP_arreglo2011($qry));
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    //echo $qry;
    if($CampoLlave[0] > 0){
        echo "{success: true, requestedId:'" . $CampoLlave[0] . "'}";
    }else{
        echo "{success: true, requestedId:'0'}";
    }
}

function ModificarNOPOS(){
    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $pIdEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIdIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $pIdSolicitud = isset($_REQUEST['pIdSolicitud'])?$_REQUEST['pIdSolicitud']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_nopos_edit_solicitud('" . $pIdSolicitud  . "'," . spParametros($estructura,"SI") . ")";
    //echo $qry; 
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
}

?>