<?php

set_time_limit(500);
require_once('../../../lib/tcpdf/config/lang/spa.php');
require_once('../../../lib/tcpdf/tcpdf.php');
require("../../../core/php/_database.php");
require("../../../core/php/php_functions.php");
//header('Content-type: application/pdf; charset: UTF-8');

session_start();
$pConsultorioVirtual = $_SESSION['IDBD'];
$nomEmpresa = $_SESSION['NOM_EMPRESA'];
$nomUsuario = $_SESSION['NOM_USUARIO'];
$pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
$pSolicitud = isset($_REQUEST['pSolicitud'])?$_REQUEST['pSolicitud']:0;

$gBaseDatos = new ofiMySQLi();
$gBaseDatos->conectar();
$qry = "CALL sp_nopos_solicitud_print('" . $pSolicitud . "')";
$gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
while ($row[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
$gBaseDatos->liberar();
$gBaseDatos->cerrar();
$pRegistros = count($row);

//Definicion de las Margenes
$LeftMargin = PDF_MARGIN_LEFT;
$TopMargin = 10;
$RightMargin = PDF_MARGIN_RIGHT;
$HeaderMargin = PDF_MARGIN_HEADER;
$BottomMargin = 3;
$FooterMargin = 5;
$Alineacion = "P";
$FormatoPagina = "CARTA";
$UsaPiePagina = "SI";
$pTipoEncabezado = "FVP";
$pControlSalto = 20;
$styleBarCode = array(
    'position' => 'R',
    'align' => 'R',
    'stretch' => false,
    'fitwidth' => true,
    'cellfitalign' => 'R',
    'border' => true,
    'hpadding' => 'auto',
    'vpadding' => 'auto',
    'fgcolor' => array(0,0,0),
    'bgcolor' => false, //array(255,255,255),
    'text' => true,
    'font' => 'helvetica',
    'fontsize' => 7,
    'stretchtext' => 4
);
//Inicializacion de la Clase
$pdf = new TCPDF($Alineacion, PDF_UNIT, $FormatoPagina, true, 'UTF-8', false);
//Inicializacion Variables de Control
$pdf->pAlineacionEncabezado = $Alineacion;
$pdf->pTituloInforme = "NOPOS";
$pdf->pImprimeLogo = "NO";
$pdf->pAnchoTxtPagina = 210;
$pdf->pNomEmpresa = $_SESSION['NOM_EMPRESA'];
$pdf->pTDocEmpresa = $_SESSION['EMPRESA_TDOC'];
$pdf->pDocEmpresa = $_SESSION['EMPRESA_DOC'];
$pdf->pDirEmpresa = $_SESSION['EMPRESA_DIR'];
$pdf->pTelEmpresa = $_SESSION['EMPRESA_TEL'];
$pdf->pCiuEmpresa = $_SESSION['EMPRESA_CIU'];
$pdf->pEspEmpresa = $_SESSION['EMPRESA_ESP'];
$pdf->pRegEmpresa = $_SESSION['EMPRESA_REGIMEN'];
$pdf->pContribuyentes = $_SESSION['EMPRESA_CONTRIBUYENTE'];
$pdf->pReteIVA  = $_SESSION['EMPRESA_RTEICA'];
$pdf->pReteICA = $_SESSION['EMPRESA_RTEIVA'];

$pdf->pTipoEncabezado = $pTipoEncabezado;
$pdf->pNomSede = $_SESSION['EMPRESA_DOC'];
$pdf->pNomIPS = $_SESSION['NOM_IPS'];
$pdf->pMargenPie = -20;
$pdf->pLogoCliente = "../../../empresas/" . $_SESSION['I_EMPRESA'] . "/logo/logoenc.gif";
$pdf->pPrefijo = 1; //$row[0]["Prefijo"];
$pdf->pNroDocumento = 1; //str_pad($row[0]["NroDocumento"], 7, "0", STR_PAD_LEFT);
$pdf->pNroResolucion = 1; //$row[0]["NroResolucion"];
$pdf->pFechaDoc = 1; //$row[0]["FechaDocumento"];
$pdf->pCAS = null;
$pdf->pTratamiento = null;
$pdf->pUsaPie = $UsaPiePagina;

$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Sistemas Ofisalud © - 2011');
$pdf->SetTitle('Ofimedical©');
$pdf->SetSubject('SOLICITUD JUSTIFICACION DE SERVICIOS NO POS');

$pdf->SetHeaderData($pdf->pLogoCliente, PDF_HEADER_LOGO_WIDTH, $pdf->pTituloInforme, PDF_HEADER_STRING);
$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
$pdf->SetMargins($LeftMargin, $TopMargin, $RightMargin);
$pdf->SetHeaderMargin($HeaderMargin);
$pdf->SetFooterMargin($FooterMargin);
// set bacground image

$pdf->SetAutoPageBreak(TRUE, $BottomMargin);
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
$pdf->setLanguageArray($l);
$pdf->setFontSubsetting(true);
$pdf->SetFont('dejavusans', '', 14, '', true);
$rowcount = 5;
$contador = "";
$pDesde = "";
$pHasta = "";
$i = 0;
//$pdf->AddPage();
//$pdf->writeHTML("NANA - " . $qry, true, false, false, false, '');

if($row[$i]["PrimerNombre"] != ""){
    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
    $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
    $pdf->Ln(0.5);
    $mostrarHC = '<span style="font-size:36px; text-align:center;"><b>I. DATOS GENERALES</b></span><hr><br>';
    $mostrarHC .= '<table><tr><td width="175" style="font-size:35px;"><b>NOMBRES Y APELLIDOS: </b></td><td style="font-size:35px;" width="300">' . utf8_decode($row[$i]["PrimerNombre"]) . " " . utf8_decode($row[$i]["SegundoNombre"]) . " " . utf8_decode($row[$i]["PrimerApellido"]) . " " . utf8_decode($row[$i]["SegundoApellido"]) . '</td>';
    $mostrarHC .= '<td></td></tr>';
    $mostrarHC .= '<tr><td style="font-size:35px;"><b>IDENTIFICACION: </b></td><td style="font-size:35px;">' . utf8_decode($row[$i]["TipDoc"]) . " - " . utf8_decode($row[$i]["Documento"]) . '</td><td width="100" style="font-size:35px; "></td><td></td></tr>';
    $mostrarHC .= '<tr><td style="font-size:35px;"><b>FECHA DE NACIMIENTO: </b></td><td style="font-size:35px;">' . utf8_decode($row[$i]["FecNac"]) . '</td><td width="100" style="font-size:35px;"><b>SEXO:</b></td><td style="font-size:35px;">' . utf8_decode($row[$i]["Genero"]) . '</td></tr>';
    $mostrarHC .= '<tr><td style="font-size:35px;"><b>DIRECCION: </b></td><td style="font-size:35px;">' . utf8_decode($row[$i]["Direccion"]) . '</td><td width="100" style="font-size:35px; "><b>TELEFONO:</b></td><td style="font-size:35px;">' . utf8_decode($row[$i]["Telefono"]) . " - " . utf8_decode($row[$i]["Telefono1"]) . '</td></tr>';
    $mostrarHC .= '<tr><td></td></tr>';
    $mostrarHC .= '<tr><td style="font-size:35px;"><b>ENTIDAD: </b></td><td style="font-size:35px;" width="300">' . utf8_decode($row[$i]["DescripcionFac"]) . '</td><td></td></tr>';
    $mostrarHC .= '<tr><td style="font-size:35px;"><b>PROFESIONAL TRATANTE: </b></td><td style="font-size:35px;" width="300">' . utf8_decode($row[$i]["nomProfesional"]) . '</td><td></td></tr>';
    $mostrarHC .= '<tr><td style="font-size:35px;"><b>FECHA DE SOLICITUD: </b></td><td style="font-size:35px;" width="300">' . utf8_decode($row[$i]["FecSolicitud"]) . '</td><td></td></tr>';
    $mostrarHC .= '</table>';
    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
    }

    $mostrarHC = '<hr><span style="font-size:36px; text-align:center;"><b>II. CASO CLINICO</b></span><hr><br>';
    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
    }
    $mostrarHC = '<span style="text-align:justify; font-size:35px; color:#000;"><b>DIAGNOSTICO: </b>' . utf8_decode($row[$i]["ResumenDx"]) . ' - <b>CODIGO: </b> ' . utf8_decode($row[$i]["CodDiagnostico"]) . '</span><br>';
    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
    }
    if($row[$i]["DescripcionCasoClinico"] != "" && $row[$i]["DescripcionCasoClinico"] != null){
        $mostrarHC = '<span style="text-align:justify; font-size:35px; color:#000;"><b>RESUMEN DE LA HISTORIA CLÍNICA DEL PACIENTE: </b>' . utf8_decode($row[$i]["DescripcionCasoClinico"]) . '</span><br>';
        $pdf->writeHTML($mostrarHC, true, false, false, false, '');
        if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
            EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
        }
    }
    if($row[$i]["TratamientosRealizados"] != "" && $row[$i]["TratamientosRealizados"] != null){
        $mostrarHC = '<span style="text-align:justify; font-size:35px; color:#000;"><b>RESUMEN DE LOS TRATAMIENTOS PREVIOS RELACIONADOS CON LA HISTORIA CLINICA: </b>' . utf8_decode($row[$i]["TratamientosRealizados"]) . '</span><br>';
        $pdf->writeHTML($mostrarHC, true, false, false, false, '');
        if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
            EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
        }
    }
    if($row[$i]["AyudasDiagnosticas"] != "" && $row[$i]["AyudasDiagnosticas"] != null){
        $mostrarHC = '<span style="text-align:justify; font-size:35px; color:#000;"><b>RESULTADOS DE AYUDAS DIAGNOSTICAS: </b>' . utf8_decode($row[$i]["AyudasDiagnosticas"]) . '</span><br>';
        $pdf->writeHTML($mostrarHC, true, false, false, false, '');
        if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
            EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
        }
    }
    if($row[$i]["Otros"] != "" && $row[$i]["Otros"] != null){
        $mostrarHC = '<span style="text-align:justify; font-size:35px; color:#000;"><b>OTROS: </b>' . utf8_decode($row[$i]["Otros"]) . '</span><br>';
        $pdf->writeHTML($mostrarHC, true, false, false, false, '');
        if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
            EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
        }
    }
    //Datalle Servicios
    $mostrarHC = '<hr><span style="font-size:36px; text-align:center;"><b>III. SERVICIOS SOLICITADOS</b></span><hr>';
    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
    }
    for($i=0;$i<$pRegistros;$i++){
        if(utf8_decode($row[$i]["Descripcion"]) != ""){
            $mostrarHC = '<span style="font-size:35px; "><b>TIPO SERVICIO: </b>' . utf8_decode($row[$i]["TipoServicio"]) . ' - ' . utf8_decode($row[$i]["Descripcion"]) . '<br>';
            $mostrarHC .= '<b>USO: </b>' . utf8_decode($row[$i]["Caracter"]) . ' <b>- CANTIDAD: </b> ' . utf8_decode($row[$i]["CaracterCantidad"]) . "&nbsp;";
            if(utf8_decode($row[$i]["Caracter"])=="SUCESIVO"){
                $mostrarHC .= '<b>- DIAS TRATAMIENTO: </b>' . utf8_decode($row[$i]["CaracterDias"]);
            }
            $mostrarHC .= '<br>';
            if(utf8_decode($row[$i]["Homologo"])=="SI"){
                $mostrarHC .= '<b>HOMOLOGO: </b>' . utf8_decode($row[$i]["HomologoSustituto"]);
            }
            $mostrarHC .= '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            if($row[$i]["Justificacion"] != "" && $row[$i]["Justificacion"] != null){
                $mostrarHC = '<span style="text-align:justify; font-size:35px; color:#000;"><b>JUSTIFICACION: </b>' . utf8_decode($row[$i]["Justificacion"]) . '</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            if($row[$i]["Evidencia"] != "" && $row[$i]["Evidencia"] != null){
                $mostrarHC = '<span style="text-align:justify; font-size:35px; color:#000;"><b>EVIDENCIA: </b>' . utf8_decode($row[$i]["Evidencia"]) . '</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            if($row[$i]["Casuistica"] != "" && $row[$i]["Casuistica"] != null){
                $mostrarHC = '<span style="text-align:justify; font-size:35px; color:#000;"><b>CASUISTICA: </b>' . utf8_decode($row[$i]["Casuistica"]) . '</span>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
            $pdf->writeHTML("<hr><br>", true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
        }
    }
}
$pdf->Ln(8);
$mostrarHC = '<table border="0" cellspacing="0">';
if($_SESSION['IdAplicacion'] == "OfiMedical"){
    if (file_exists('../../../consultoriovirtual/' . $_SESSION['IDBD']  . '/firmas/' . $row[0]["Profesional"] . '.png')) {
        $mostrarHC .= '<tr>';
        $mostrarHC .= '<td width="500">&nbsp;</td>';
        $mostrarHC .= '<td width="200" valign="middle" align="left"><img src="../../../consultoriovirtual/' . $_SESSION['IDBD'] . '/firmas/' . $row[0]["Profesional"] . '.png" width="190" height="45"/></td>';
        $mostrarHC .= '</tr>';
    }
}else{
   if (file_exists('../../../empresas/' . $_SESSION['ID_EMPRESA']  . '/firmas/' . $row[0]["Profesional"] . '.png')) {
        $mostrarHC .= '<tr>';
        $mostrarHC .= '<td width="500">&nbsp;</td>';
        $mostrarHC .= '<td width="200" valign="middle" align="left"><img src="../../../empresas/' . $_SESSION['ID_EMPRESA'] . '/firmas/' . $row[0]["Profesional"] . '.png" width="190" height="45"/></td>';
        $mostrarHC .= '</tr>';
    } 
}
$mostrarHC .= '<tr>';
$mostrarHC .= '<td width="500">&nbsp;</td>';
$mostrarHC .= '<td width="200" align="left" style="font-size:27px; border-top-width: 1px; border-top-style: solid;">' . utf8_decode($row[0]["nomProfesional"]) . '</td>';
$mostrarHC .= '</tr>';
$mostrarHC .= '<tr>';
$mostrarHC .= '<td>&nbsp;</td>';
$mostrarHC .= '<td style="font-size:27px;" align="left">' . utf8_decode($row[0]["Especialidad"]) . '</td>';
$mostrarHC .= '</tr>';
$mostrarHC .= '<tr>';
$mostrarHC .= '<td>&nbsp;</td>';
$mostrarHC .= '<td style="font-size:27px;" align="left">Nro. Registro:' . utf8_decode($row[0]["RegistroProfesional"]) . '</td>';
$mostrarHC .= '</tr>';
$mostrarHC .= '</table>';
$pdf->writeHTML($mostrarHC, true, false, false, false, '');
$pdf->Output('infJustificacionSolicitudNOPOS.pdf', 'I');

function EncabezadoPagina(&$pdf, &$row, &$i, &$rowcount, &$contador, &$pDesde, &$pHasta){
    $pdf->AddPage();
    $pdf->Ln(0.5);
    $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
    $EncabezadoHTML = '<table cellspacing="0" border="0" style="font-size:24px; color:#000;">';
    $EncabezadoHTML .= '<tr>';
    $EncabezadoHTML .= '<td>';
    $EncabezadoHTML .= '<span style="font-size:44px; color:#000; font-weight:bold">' . utf8_decode($pdf->pNomEmpresa) . '</span><br>';
    if($pdf->pEspEmpresa != null || $pdf->pEspEmpresa != "")
            $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . utf8_decode($pdf->pEspEmpresa) . '</span><br>';
    if($pdf->pTDocEmpresa == "NI"){
        $tipodoc = "NIT: ";
        $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $tipodoc . $pdf->pDocEmpresa . '</span><br>';
    }
    $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">Cel: ' . $pdf->pTelEmpresa . '</span><br>';
    $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $pdf->pCiuEmpresa . '</span>';
    $EncabezadoHTML .= '</td>';

    //COL2
    $EncabezadoHTML .= '<td align="right">';
    if (file_exists("../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/logoenc.gif")) {
        $EncabezadoHTML .= '<img src="../../../empresas/' . $_SESSION['ID_EMPRESA'] . '/logo/logoenc.gif" align="right"/>';
        $EncabezadoHTML .= '<br>';
    }
    $EncabezadoHTML .= '<span align="rigth" style="font-size:39px; color:#000; font-weight:bold">SOLICITUD JUSTIFICACION DE SERVICIOS NO POS</span><br>';
    $EncabezadoHTML .= '<span align="rigth" style="font-size:39px; color:#000; font-weight:bold">FECHA: ' . utf8_decode($row[$i]["FecSolicitud"]) . '</span><br>';
    $EncabezadoHTML .= '</td>';
    $EncabezadoHTML .= '</tr>';
    $EncabezadoHTML .= '</table>';
    $EncabezadoHTML .= '<hr>';
    $pdf->writeHTML($EncabezadoHTML, true, false, false, false, '');
}

?>