<?php

/*
* @category    Controlador Odontograma
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

require("../../../core/php/_database.php");
require("../../../core/php/php_functions.php");

$task = '';
if ( isset($_POST['task'])){
  $task = $_POST['task'];
}
switch($task){
    
    case "CREAR_DETALLEODONTOGRAMA_SANO":
        CrearDetalleOdontogramaSANO();
        break;
    case "ELIMINAR_ITEM_DETALLEODONTOGRAMA":
        EliminarDetalleOdontograma();
        break;
    case "ELIMINAR_ITEM_DETALLECONTROLPLACA":
        EliminarDetalleControlPlaca();
        break;
    case "GUARDAR_ITEM_DETALLEODONTOGRAMA":
        GuardarDetalleOdontograma();
        break;
    case "GUARDAR_ITEM_DETALLECONTROLPLACA":
        GuardarDetalleControlPlaca();
        break;
    case "GUARDAR_ITEM_DETALLEODONTOGRAMA002":
        GuardarDetalleOdontograma002();
        break;
    case "LOAD_DETALLEODONTOGRAMA":
        CargarDetalleOdontograma();
        break;
    case "LOAD_DETALLECONTROLPLACA":
        CargarDetalleControlPlaca();
        break;
    case "CREAR_ODONTOGRAMA":
        CrearOdontogramaxPac();
        break;
    case "CREAR_CONTROLPLACA":
        CrearControlPlacaxPac();
        break;
    case "ELIMINAR_ODONTOGRAMA":
        EliminarOdontogramaxPac();
        break;
    case "ELIMINAR_CONTROLPLACA":
        EliminarControlPlacaxPac();
        break;
    case "OBTENER_ULTIMO_ODONTOGRAMA":
        ObtenerUltimoOdontograma();
        break;
    case "update_diente":
        UpdateDiente();
        break;
    case "load_diente":
        LoadDiente();
        break;
    default:
        echo "{failure:true}";
        break;
}

function EliminarControlPlacaxPac(){
    $pIdOdontograma = isset($_REQUEST['pIdOdontograma'])?$_REQUEST['pIdOdontograma']:null;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_odontologia_controlplaca_del('" . $pIdOdontograma . "')";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo '1';
    else
        echo '0';
    $gBaseDatos->cerrar();
}

function EliminarOdontogramaxPac(){
    $pIdOdontograma = isset($_REQUEST['pIdOdontograma'])?$_REQUEST['pIdOdontograma']:null;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_odontologia_odontograma_del('" . $pIdOdontograma . "')";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo '1';
    else
        echo '0';
    $gBaseDatos->cerrar();
}

function CrearDetalleOdontogramaSANO(){
    $pOdontograma = isset($_REQUEST['pOdontograma'])?$_REQUEST['pOdontograma']:0;
    $pDenticion = isset($_REQUEST['pDenticion'])?$_REQUEST['pDenticion']:"MALO";
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_odontologia_odontograma_detalle_insertsano('" . $pOdontograma . "',\"" . $pDenticion . "\")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo '1';
    else
        echo '0';
    $gBaseDatos->cerrar();
}

function EliminarDetalleControlPlaca(){
    $pIdItem = isset($_REQUEST['pIdItem'])?$_REQUEST['pIdItem']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_odontologia_controlplaca_detalle_delete('" . $pIdItem . "')";
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo '1';
    else
        echo '0';
    $gBaseDatos->cerrar();
}

function EliminarDetalleOdontograma(){
    $pIdItem = isset($_REQUEST['pIdItem'])?$_REQUEST['pIdItem']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_odontologia_odontograma_detalle_delete('" . $pIdItem . "')";
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo '1';
    else
        echo '0';
    $gBaseDatos->cerrar();
}

function GuardarDetalleOdontograma002(){
    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_odontologia_odontograma_detalle_insert002(" . spParametros($estructura,"SI") . ")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function GuardarDetalleOdontograma(){
    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_odontologia_odontograma_detalle_insert(" . spParametros($estructura,"SI") . ")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function GuardarDetalleControlPlaca(){
    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_odontologia_controlplaca_detalle_insert(" . spParametros($estructura,"SI") . ")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function CargarDetalleOdontograma(){
    $pOdontograma = isset($_REQUEST['pOdontograma'])?$_REQUEST['pOdontograma']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_odontologia_odontograma_cargardetalle('" . $pOdontograma . "')";
    //echo $qry;
    @mysqli_query("\"SET NAMES UTF8\"");
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = utf8_decode($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}

function CargarDetalleControlPlaca(){
    $pOdontograma = isset($_REQUEST['pOdontograma'])?$_REQUEST['pOdontograma']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_odontologia_controlplaca_cargardetalle('" . $pOdontograma . "')";
    //echo $qry;
    @mysqli_query("\"SET NAMES UTF8\"");
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = utf8_decode($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}

function CrearOdontogramaxPac(){
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pIdOdontograma = isset($_REQUEST['pIdOdontograma'])?$_REQUEST['pIdOdontograma']:0;
    $pTipoOdontograma = isset($_REQUEST['pTipoOdontograma'])?$_REQUEST['pTipoOdontograma']:"Inical";
    $pFechaAtencion = isset($_REQUEST['pFechaAtencion'])?$_REQUEST['pFechaAtencion']:null;
    $pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:null;
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pCliente = isset($_REQUEST['pCliente'])?$_REQUEST['pCliente']:null;
    $pTipoDenticion = isset($_REQUEST['pTipoDenticion'])?$_REQUEST['pTipoDenticion']:"PERMANENTE";
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_odontologia_odontograma_crear('" . $pPaciente . "','" . $pIdOdontograma . "',\"" . $pTipoOdontograma . "\",\"" . $pFechaAtencion . "\",'" . $pProfesional . "','" . $pCAS . "','" . $pCliente . "',\"" . $pTipoDenticion . "\",'" . $pUsuario . "')";
    //echo $qry;
    $CampoLlave = explode("^",$gBaseDatos->jasonSP_arreglo2011($qry));
    echo $CampoLlave[0];
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
}

function CrearControlPlacaxPac(){
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pIdOdontograma = isset($_REQUEST['pIdOdontograma'])?$_REQUEST['pIdOdontograma']:0;
    $pTipoOdontograma = isset($_REQUEST['pTipoOdontograma'])?$_REQUEST['pTipoOdontograma']:"Inical";
    $pFechaAtencion = isset($_REQUEST['pFechaAtencion'])?$_REQUEST['pFechaAtencion']:null;
    $pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:null;
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pCliente = isset($_REQUEST['pCliente'])?$_REQUEST['pCliente']:null;
    $pTipoDenticion = isset($_REQUEST['pTipoDenticion'])?$_REQUEST['pTipoDenticion']:"PERMANENTE";
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_odontologia_controlplaca_crear('" . $pPaciente . "','" . $pIdOdontograma . "',\"" . $pTipoOdontograma . "\",\"" . $pFechaAtencion . "\",'" . $pProfesional . "','" . $pCAS . "','" . $pCliente . "',\"" . $pTipoDenticion . "\",'" . $pUsuario . "')";
    //echo $qry;
    $CampoLlave = explode("^",$gBaseDatos->jasonSP_arreglo2011($qry));
    echo $CampoLlave[0];
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
}

function ObtenerUltimoOdontograma(){
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_odontologia_odontograma_ultimoregistro('" . $pPaciente . "')";
    //echo $qry;
    $CampoLlave = explode("^",$gBaseDatos->jasonSP_arreglo2011($qry));
    if($CampoLlave[0] == "{success:false}"){
        echo 0;
    }else{
        echo $CampoLlave[0];
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
}

function UpdateDiente(){
    $pDxAfectaTodoDiente = isset($_REQUEST['pDxAfectaTodoDiente'])?$_REQUEST['pDxAfectaTodoDiente']:"NO";
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pDiente = isset($_REQUEST['pDiente'])?$_REQUEST['pDiente']:0;
    $contenido = isset($_REQUEST['CAMPOS'])?$_REQUEST['CAMPOS']:null;
    $pEvolucion = utf8_encode(str_replace('"', '""',nl2br($contenido)));
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_odontograma_update_diente('" . $pCAS . "','" . $pPaciente . "','" . $pDiente . "',\"" . $pEvolucion . "\")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();

}

function LoadDiente(){
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pCAS = 1;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pDiente = isset($_REQUEST['pDiente'])?$_REQUEST['pDiente']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_odontograma_list_diente('" . $pCAS . "','" . $pPaciente . "','" . $pDiente . "')";
    echo $gBaseDatos->jasonSP_arreglo($qry);
    $gBaseDatos->cerrar();
}

function xPintarDiente(){
    /*
   
     * strDxGeneralDienteOdontograma
     * bolDX_DIENTE_NUCLEO = true
     * bolDX_DIENTE_IMPLANTE^~true^~DX_DIENTE_IMPLANTEÂ¬
     * bolDX_DIENTE_ENDOBUENA^~true^~DX_DIENTE_ENDOBUENAÂ¬
     * bolDX_DIENTE_ENDOINDICADA^~true^~DX_DIENTE_ENDOINDICADAÂ¬
     * bolDX_DIENTE_SELLANTEBOCA^~true^~DX_DIENTE_SELLANTEBOCAÂ¬
     * bolDX_DIENTE_SELLANTEINDICADO^~true^~DX_DIENTE_SELLANTEINDICADOÂ¬
     * bolDX_DIENTE_PROVICIONAL^~true^~DX_DIENTE_PROVICIONALÂ¬
     * bolDX_DIENTE_OBTURAMETALICA^~true^~DX_DIENTE_OBTURAMETALICAÂ¬
     * bolDX_DIENTE_OBTURAPORCELANA^~true^~DX_DIENTE_OBTURAPORCELANAÂ¬
     * bolDX_DIENTE_ABRASION^~true^~DX_DIENTE_ABRASIONÂ¬
     * bolDX_DIENTE_ROTACIONES^~true^~DX_DIENTE_ROTACIONESÂ¬
     * 
     * bolCaries_M^~true^~Caries MesialÂ¬
     * bolCaries_O^~true^~Caries OclusalÂ¬
     * bolCaries_D^~true^~Caries DistalÂ¬
     * bolCaries_V^~true^~Caries VestibularÂ¬
     * bolCaries_LP^~true^~Caries Lingual PalatinaÂ¬
     * 
     * bolCariesSecundaria_M^~true^~Caries Secundaria MesialÂ¬
     * bolCariesSecundaria_O^~true^~Caries Secundaria OclusalÂ¬
     * bolCariesSecundaria_D^~true^~Caries Secundaria DistalÂ¬
     * bolCariesSecundaria_V^~true^~Caries Secundaria VestibularÂ¬
     * bolCariesSecundaria_LP^~true^~Caries Secundaria Lingual PalatinaÂ¬
     * 
     * bolCariesIncipiente_M^~true^~Caries Incipiente MesialÂ¬
     * bolCariesIncipiente_O^~true^~Caries Incipiente OclusalÂ¬
     * bolCariesIncipiente_D^~true^~Caries Incipiente DistalÂ¬
     * bolCariesIncipiente_V^~true^~Caries Incipiente VestibularÂ¬
     * bolCariesIncipiente_LP^~true^~Caries Incipiente Lingual PalatinaÂ¬
     * 
     * bolCavidadVacia_M^~true^~Cavidad vac&#237;a sin caries Incipiente MesialÂ¬
     * bolCavidadVacia_O^~true^~Cavidad vac&#237;a sin caries OclusalÂ¬
     * bolCavidadVacia_D^~true^~Cavidad vac&#237;a sin caries DistalÂ¬
     * bolCavidadVacia_V^~true^~Cavidad vac&#237;a sin caries VestibularÂ¬
     * bolCavidadVacia_LP^~true^~Cavidad vac&#237;a sin caries Lingual PalatinaÂ¬
     * 
     * bolIonomeroResina_M^~true^~Ion&#243;mero o Resina MesialÂ¬
     * bolIonomeroResina_O^~true^~Ion&#243;mero o Resina OclusalÂ¬
     * bolIonomeroResina_D^~true^~Ion&#243;mero o Resina DistalÂ¬
     * bolIonomeroResina_V^~true^~Ion&#243;mero o Resina VestibularÂ¬
     * bolIonomeroResina_LP^~true^~Ion&#243;mero o Resina Lingual PalatinaÂ¬
     * 
     * bolIonomeroResinaDefecto_M^~true^~Ion&#243;mero o Resina con Defecto MesialÂ¬
     * bolIonomeroResinaDefecto_O^~true^~Ion&#243;mero o Resina con Defecto OclusalÂ¬
     * bolIonomeroResinaDefecto_D^~true^~Ion&#243;mero o Resina con Defecto DistalÂ¬
     * bolIonomeroResinaDefecto_V^~true^~Ion&#243;mero o Resina con Defecto VestibularÂ¬
     * bolIonomeroResinaDefecto_LP^~true^~Ion&#243;mero o Resina con Defecto Lingual PalatinaÂ¬
     * 
     * bolIonomeroResinaCariesSec_M^~true^~Ion&#243;mero o Resina Caries Secundaria MesialÂ¬
     * bolIonomeroResinaCariesSec_O^~true^~Ion&#243;mero o Resina Caries Secundaria OclusalÂ¬
     * bolIonomeroResinaCariesSec_D^~true^~Ion&#243;mero o Resina Caries Secundaria DistalÂ¬
     * bolIonomeroResinaCariesSec_V^~true^~Ion&#243;mero o Resina Caries Secundaria VestibularÂ¬
     * bolIonomeroResinaCariesSec_LP^~true^~Ion&#243;mero o Resina Caries Secundaria Lingual PalatinaÂ¬
     * 
     * bolAmalgama_M^~true^~Amalgama MesialÂ¬
     * bolAmalgama_O^~true^~Amalgama OclusalÂ¬
     * bolAmalgama_D^~true^~Amalgama DistalÂ¬
     * bolAmalgama_V^~true^~Amalgama VestibularÂ¬
     * bolAmalgama_LP^~true^~Amalgama Lingual PalatinaÂ¬
     * 
     * bolAmalgamaDefecto_M^~true^~Amalgama con Defecto MesialÂ¬
     * bolAmalgamaDefecto_O^~true^~Amalgama con Defecto OclusalÂ¬
     * bolAmalgamaDefecto_D^~true^~Amalgama con Defecto DistalÂ¬
     * bolAmalgamaDefecto_V^~true^~Amalgama con Defecto VestibularÂ¬
     * bolAmalgamaDefecto_LP^~true^~Amalgama con Defecto Lingual PalatinaÂ¬
     * 
     * bolAmalgamaCariesSec_M^~true^~Amalgama Caries Secundaria MesialÂ¬
     * bolAmalgamaCariesSec_O^~true^~Amalgama Caries Secundaria OclusalÂ¬
     * bolAmalgamaCariesSec_D^~true^~Amalgama Caries Secundaria DistalÂ¬
     * bolAmalgamaCariesSec_V^~true^~Amalgama Caries Secundaria VestibularÂ¬
     * bolAmalgamaCariesSec_LP^~true^~Amalgama Caries Secundaria Lingual PalatinaÂ¬
    
    
    */
}

?>