<?php

/*
* @category    Controlador Profesionales
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

require("../../../core/php/_database.php");
require("../../../core/php/php_functions.php");
session_start();

$task = '';
if ( isset($_POST['task'])){
  $task = $_POST['task'];
}
switch($task){
    case "INSERTAR":
        InsertarPaciente();
        break;
    case "MODIFICAR":
        ModificarPaciente();
        break;
    case "ACTUALIZAR":
        ModificarPacienteRadicacion();
        break;
    case "LISTAR":
        ListarPaciente();
        break;
    case "LISTARxQRY":
        ListarPacientexQry();
        break;
    case "LISTARxQRYNeuroDesa":
        ListarPacientexQryNeuroDesa();
        break;
    case "UNIFICAR":
        UnificarPaciente();
        break;
    case "CAMBIAR_CLIENTE_INFORME_NEURODESARROLLO":
        CambiarClienteInformeNeurodesarrollo();
        break;
    case "BuscarxDoc":
        BuscarPacientexDoc();
        break;
    case "SEARCH_HUELLA":
        BuscarPacientexHuella();
        break;
    case "UPDATE_HUELLA":
        UpdatePacientexHuella();
        break;
    case "SEARCH_PACIENTE_XHUELLA":
        BuscarDataPacientexHuella();
        break;
    case "CAMBIAR_RANGO_SALRIAL_LISTADO":
        CambiarRangoSalarialListadoAtencion();
        break;
    case "LISTAR_INASISTENCIAxPAC":
        ListarInasistenciasxPac();
        break;
    case "LISTAR_INASISTENCIAxPAC2023":
        ListarInasistenciasxPac2023();
        break;
    default:
        echo "{failure:true}";
        break;
}

function ListarInasistenciasxPac(){
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_pacientes_listarmultas('" . $pPaciente . "','" . $_SESSION['ID_EMPRESA'] . "','" . $_SESSION['ID_IPS'] . "')";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = PonerAcentosHTML($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}

function ListarInasistenciasxPac2023(){
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_pacientes_listarmultas2023('" . $pPaciente . "','" . $_SESSION['ID_EMPRESA'] . "','" . $_SESSION['ID_IPS'] . "')";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = PonerAcentosHTML($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}

function CambiarRangoSalarialListadoAtencion(){
    $pPaciente = isset($_REQUEST['pPaciente']) ? $_REQUEST['pPaciente']:0;
    $pTdoc = isset($_REQUEST['pTdoc']) ? $_REQUEST['pTdoc']:null;
    $pDocumento = isset($_REQUEST['pDocumento']) ? $_REQUEST['pDocumento']:null;
    $pRango = isset($_REQUEST['pRango']) ? $_REQUEST['pRango']:null;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_pacientes_rangosal_updatelistado('" . $_SESSION['ID_EMPRESA'] . "','" . $_SESSION['ID_IPS'] . "','" . $_SESSION['ID_USUARIO'] . "',\"" . $pTdoc . "\",\"" . $pDocumento . "\",\"" . $pRango . "\")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry)){
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        $gBaseDatos = new ofiMySQLi(BASE_DATOS_PARAM, SERVIDOR, USUARIO_PARAM, PASSWORD_PARAM);
        $gBaseDatos->conectar();
        $qry = "UPDATE listado SET listado.rango = \"" . $pRango . "\" WHERE listado.tdoc = \"" . $pTdoc . "\" AND listado.documento =  \"" . $pDocumento . "\"";
        //echo $qry;
        @mysqli_query($gBaseDatos->ConexionID, $qry);
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        echo "{success: true, requestedId:'1'}";
    }else{
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        echo "{success: true, requestedId:'0'}";
    }
}

function BuscarDataPacientexHuella(){
    $pHuella = isset($_REQUEST['pHuella']) ? $_REQUEST['pHuella']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_pacientes_huella_loaddata('" . $pHuella . "')";
    //echo $qry;
    $CampoLlave = explode("^",$gBaseDatos->jasonSP_arreglo2011($qry));
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    if($CampoLlave[0] != "" && $CampoLlave[0] != 0 && $CampoLlave[0] != "0"){
        $pRegistros = count($CampoLlave);
        $dataRes = "SI^";
        for($i=0;$i<$pRegistros;$i++){
            $dataRes .= $CampoLlave[$i] . '^';
        }
        echo $dataRes;
    }else{
        echo  'NO^0^0';
    }
}

function UpdatePacientexHuella(){
    $pPaciente = isset($_REQUEST['pPaciente']) ? $_REQUEST['pPaciente']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_pacientes_huella_update(\"" . $pPaciente . "\")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "1";
    else
       echo "0";
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
}

function BuscarPacientexHuella(){
    $pPaciente = isset($_REQUEST['pPaciente']) ? $_REQUEST['pPaciente']:0;
    $pHuella = isset($_REQUEST['pHuella']) ? $_REQUEST['pHuella']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_pacientes_huella_verify('" . $pPaciente . "')";
    $CampoHuella = explode("^",$gBaseDatos->jasonSP_arreglo2011($qry));
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    if($CampoHuella[0] == "OK"){
        $gBaseDatos = new ofiMySQLi();
        $gBaseDatos->conectar();
        $qry = "CALL sp_pacientes_huella_search('" . $pPaciente . "','" . $pHuella . "')";
        //echo $qry;
        $CampoLlave = explode("^",$gBaseDatos->jasonSP_arreglo2011($qry));
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        if($CampoLlave[0] != "" && $CampoLlave[0] != 0 && $CampoLlave[0] != "0"){
            echo $CampoLlave[0] . '^' . $CampoLlave[1] . '^SI';
        }else{
            echo  '1^0^NO';;
        }
    }else{
        echo  '0^0^NO';
    }
    
}

function BuscarPacientexDoc(){
    $pNomBaseDatos = isset($_REQUEST['pNomBaseDatos'])?$_REQUEST['pNomBaseDatos']:"NA";
    if($pNomBaseDatos == "NA"){
        $gBaseDatos = new ofiMySQLi();
    }else{
        $gBaseDatos = new ofiMySQLi($pNomBaseDatos);
    }
    $gBaseDatos->conectar();
    $qry = 'CALL sp_pacientes_buscarxdoc("' . $_REQUEST['pTdoc'] . '","' . $_REQUEST['pDocumento'] . '")';
    echo $gBaseDatos->jasonSP_arreglo($qry);
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
}

function CambiarClienteInformeNeurodesarrollo(){
    $pConsecutivoHC = isset($_REQUEST['pConsecutivoHC'])?$_REQUEST['pConsecutivoHC']:0;
    $pCliente = isset($_REQUEST['pCliente'])?$_REQUEST['pCliente']:0;
    $pNomBaseDatos = isset($_REQUEST['pNomBaseDatos'])?$_REQUEST['pNomBaseDatos']:"NA";
    if($pNomBaseDatos == "NA"){
        $gBaseDatos = new ofiMySQLi();
    }else{
        $gBaseDatos = new ofiMySQLi($pNomBaseDatos);
    }
    $gBaseDatos->conectar();
    $qry = "CALL sp_neurodesa_resumenhc_cambiarcliente('" . $pConsecutivoHC . "','" . $pCliente . "')";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
}

function UnificarPaciente(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $pPacienteMalo = isset($_REQUEST['pPacienteMalo'])?$_REQUEST['pPacienteMalo']:0;
    $pPacienteBueno = isset($_REQUEST['pPacienteBueno'])?$_REQUEST['pPacienteBueno']:0;
    $pMotivo = isset($_REQUEST['pMotivo'])?$_REQUEST['pMotivo']:" ";
    $pNomBaseDatos = isset($_REQUEST['pNomBaseDatos'])?$_REQUEST['pNomBaseDatos']:"NA";
    if($pNomBaseDatos == "NA"){
        $gBaseDatos = new ofiMySQLi();
    }else{
        $gBaseDatos = new ofiMySQLi($pNomBaseDatos);
    }
    $gBaseDatos->conectar();
    $qry = "CALL sp_pacientes_unificar('" . $pEmpresa . "','" . $pIPS . "','" . $pUsuario . "','" . $pPacienteMalo . "','" . $pPacienteBueno . "',\"" . $pMotivo . "\")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
}

function ListarPaciente(){

    $pSearch = isset($_REQUEST['query'])?$_REQUEST['query']:'%';
    $pIni = isset($_REQUEST['start'])?$_REQUEST['start']:0;
    $pFin = isset($_REQUEST['limit'])?$_REQUEST['limit']:15;
    if ($pSearch == "" || is_null($pSearch)){
        $pSearch = "%";
    }else{
        if ($pSearch != "%"){
            $pSearch = "%" . $pSearch . "%";
        }
    }
    $pNomBaseDatos = isset($_REQUEST['pNomBaseDatos'])?$_REQUEST['pNomBaseDatos']:"NA";
    if($pNomBaseDatos == "NA"){
        $gBaseDatos = new ofiMySQLi();
    }else{
        $gBaseDatos = new ofiMySQLi($pNomBaseDatos);
    }
    $gBaseDatos->conectar();
    $qry = 'CALL sp_grid_pacientes("' . $pSearch . '")';
    $CampoLlave = explode("^",$gBaseDatos->jasonSP_arreglo2011($qry));
    $nbrows = $CampoLlave[0];
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    if($nbrows>0){
        $gBaseDatos->conectar();
        $qry = 'CALL sp_grid_pacientes_limit("' . $pSearch . '",\'' . $pIni . '\',\'' . $pFin . '\')';
        $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
        while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
        {
            $nRow = $row;
            foreach($row as $key => $val)
            {
                $nRow[$key] = strtoupper(PonerAcentosHTML($val));
            }
            $arr[] = $nRow;
        }
        $jsonresult = JEncode($arr);
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        echo '({"total":"'.$nbrows.'","results":'.$jsonresult.'})';
    } else {
        echo '({"total":"0", "results":""})';
    }

}

function ListarPacientexQry(){

    $pSearch = isset($_REQUEST['query'])?$_REQUEST['query']:'%';
    $pDocumento = isset($_REQUEST['pDocumento'])?$_REQUEST['pDocumento']:'NA';
    if($pDocumento == null || $pDocumento == ""){
        $pDocumento = "NA";
    }
    $pApe1 = isset($_REQUEST['pApe1'])?$_REQUEST['pApe1']:'NA';
    if($pApe1 == null || $pApe1 == ""){
        $pApe1 = "NA";
    }
    $pApe2 = isset($_REQUEST['pApe2'])?$_REQUEST['pApe2']:'NA';
    if($pApe2 == null || $pApe2 == ""){
        $pApe2 = "NA";
    }
    $pNom1 = isset($_REQUEST['pNom1'])?$_REQUEST['pNom1']:'NA';
    if($pNom1 == null || $pNom1 == ""){
        $pNom1 = "NA";
    }
    $pNom2 = isset($_REQUEST['pNom2'])?$_REQUEST['pNom2']:'NA';
    if($pNom2 == null || $pNom2 == ""){
        $pNom2 = "NA";
    }
    $pIni = isset($_REQUEST['start'])?$_REQUEST['start']:0;
    $pFin = isset($_REQUEST['limit'])?$_REQUEST['limit']:15;
    
    if($pDocumento == "NA" && $pNom1 == "NA" && $pNom2 == "NA" && $pApe1 == "NA" && $pApe2 == "NA"){
        echo '({"total":"0", "results":""})';
    }else{
        $pNomBaseDatos = isset($_REQUEST['pNomBaseDatos'])?$_REQUEST['pNomBaseDatos']:"NA";
        if($pNomBaseDatos == "NA"){
            $gBaseDatos = new ofiMySQLi();
        }else{
            $gBaseDatos = new ofiMySQLi($pNomBaseDatos);
        }
        $gBaseDatos->conectar();
        $qry = 'CALL sp_grid_pacientesxQry("' . $pDocumento . '","' . $pNom1 . '","' . $pNom2 . '","' . $pApe1 . '","' . $pApe2 . '")';
        $CampoLlave = explode("^",$gBaseDatos->jasonSP_arreglo2011($qry));
        $nbrows = $CampoLlave[0];
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        if($nbrows>0){
            $gBaseDatos->conectar();
            $qry = 'CALL sp_grid_pacientesxQry_limit("' . $pDocumento . '","' . $pNom1 . '","' . $pNom2 . '","' . $pApe1 . '","' . $pApe2 . '",\'' . $pIni . '\',\'' . $pFin . '\')';
            $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
            while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
            {
                $nRow = $row;
                foreach($row as $key => $val)
                {
                    $nRow[$key] = strtoupper(PonerAcentosHTML($val));
                }
                $arr[] = $nRow;
            }
            $jsonresult = JEncode($arr);
            $gBaseDatos->liberar();
            $gBaseDatos->cerrar();
            echo '({"total":"'.$nbrows.'","results":'.$jsonresult.'})';
        } else {
            echo '({"total":"0", "results":""})';
        }
    }

}

function ListarPacientexQryNeuroDesa(){

    $pSearch = isset($_REQUEST['query'])?$_REQUEST['query']:'%';
    $pDocumento = isset($_REQUEST['pDocumento'])?$_REQUEST['pDocumento']:'NA';
    if($pDocumento == null || $pDocumento == ""){
        $pDocumento = "NA";
    }
    $pApe1 = isset($_REQUEST['pApe1'])?$_REQUEST['pApe1']:'NA';
    if($pApe1 == null || $pApe1 == ""){
        $pApe1 = "NA";
    }
    $pApe2 = isset($_REQUEST['pApe2'])?$_REQUEST['pApe2']:'NA';
    if($pApe2 == null || $pApe2 == ""){
        $pApe2 = "NA";
    }
    $pNom1 = isset($_REQUEST['pNom1'])?$_REQUEST['pNom1']:'NA';
    if($pNom1 == null || $pNom1 == ""){
        $pNom1 = "NA";
    }
    $pNom2 = isset($_REQUEST['pNom2'])?$_REQUEST['pNom2']:'NA';
    if($pNom2 == null || $pNom2 == ""){
        $pNom2 = "NA";
    }
    $pIni = isset($_REQUEST['start'])?$_REQUEST['start']:0;
    $pFin = isset($_REQUEST['limit'])?$_REQUEST['limit']:15;
    
    if($pDocumento == "NA" && $pNom1 == "NA" && $pNom2 == "NA" && $pApe1 == "NA" && $pApe2 == "NA"){
        echo '({"total":"0", "results":""})';
    }else{
        $pNomBaseDatos = isset($_REQUEST['pNomBaseDatos'])?$_REQUEST['pNomBaseDatos']:"NA";
        if($pNomBaseDatos == "NA"){
            $gBaseDatos = new ofiMySQLi();
        }else{
            $gBaseDatos = new ofiMySQLi($pNomBaseDatos);
        }
        $gBaseDatos->conectar();
        $qry = 'CALL sp_grid_pacientesxQry1("' . $pDocumento . '","' . $pNom1 . '","' . $pNom2 . '","' . $pApe1 . '","' . $pApe2 . '")';
        $CampoLlave = explode("^",$gBaseDatos->jasonSP_arreglo2011($qry));
        $nbrows = $CampoLlave[0];
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        if($nbrows>0){
            $gBaseDatos->conectar();
            $qry = 'CALL sp_grid_pacientesxQry1_limit("' . $pDocumento . '","' . $pNom1 . '","' . $pNom2 . '","' . $pApe1 . '","' . $pApe2 . '",\'' . $pIni . '\',\'' . $pFin . '\')';
            $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
            while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
            {
                $nRow = $row;
                foreach($row as $key => $val)
                {
                    $nRow[$key] = strtoupper(PonerAcentosHTML($val));
                }
                $arr[] = $nRow;
            }
            $jsonresult = JEncode($arr);
            $gBaseDatos->liberar();
            $gBaseDatos->cerrar();
            echo '({"total":"'.$nbrows.'","results":'.$jsonresult.'})';
        } else {
            echo '({"total":"0", "results":""})';
        }
    }

}

function InsertarPaciente(){
    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $CodInsercion = "PRS-" .  $_SESSION['ID_EMPRESA'] . "-SED-" . $_SESSION['ID_SEDE'] .  "-IPS-" . $_SESSION['ID_IPS'] . "-USR-" . $_SESSION['ID_USUARIO'] . "-CONS-" . mt_rand(0,100000) . "-" . date("His");
    $pUsuario = $_SESSION['ID_USUARIO'];
    $pNomBaseDatos = isset($_REQUEST['pNomBaseDatos'])?$_REQUEST['pNomBaseDatos']:"NA";
    if($pNomBaseDatos == "NA"){
        $gBaseDatos = new ofiMySQLi();
    }else{
        $gBaseDatos = new ofiMySQLi($pNomBaseDatos);
    }
    $gBaseDatos->conectar();
    $qry = "CALL sp_pacientes_insertar(\"" . $CodInsercion . "\"," . spParametros($estructura) . ",'" . $pUsuario . "')";
    //echo $qry;
    $CampoLlave = explode("^",$gBaseDatos->jasonSP_arreglo2011($qry));
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    if($CampoLlave[0]>0)
       echo "{success: true, requestedId:'1', Data:" . $CampoLlave[0] . "}";
    else
       echo "{success: true, requestedId:'0'}";
}

function ModificarPaciente(){
    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $pUsuario = $_SESSION['ID_USUARIO'];
    $pNomBaseDatos = isset($_REQUEST['pNomBaseDatos'])?$_REQUEST['pNomBaseDatos']:"NA";
    if($pNomBaseDatos == "NA"){
        $gBaseDatos = new ofiMySQLi();
    }else{
        $gBaseDatos = new ofiMySQLi($pNomBaseDatos);
    }
    $gBaseDatos->conectar();
    $qry = "CALL sp_pacientes_update(" . spParametros($estructura) . ",'" . $pUsuario . "')";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
}

function ModificarPacienteRadicacion(){
    $pIdPaciente = isset($_REQUEST['pIdPaciente'])?$_REQUEST['pIdPaciente']:0;
    $pTDoc = isset($_REQUEST['pTDoc'])?$_REQUEST['pTDoc']:"";
    $pDocID = isset($_REQUEST['pDocID'])?$_REQUEST['pDocID']:"";
    $pRegimen = isset($_REQUEST['pRegimen'])?$_REQUEST['pRegimen']:1;
    $pGenero = isset($_REQUEST['pGenero'])?$_REQUEST['pGenero']:"";
    $pApe1 = isset($_REQUEST['pApe1'])?$_REQUEST['pApe1']:"";
    $pApe2 = isset($_REQUEST['pApe2'])?$_REQUEST['pApe2']:"NA";
    $pNom1 = isset($_REQUEST['pNom1'])?$_REQUEST['pNom1']:"";
    $pNom2 = isset($_REQUEST['pNom2'])?$_REQUEST['pNom2']:"NA";
    $pFecNac = isset($_REQUEST['pFecNac'])?$_REQUEST['pFecNac']:"";
    $pDeptoMuni = isset($_REQUEST['pDeptoMuni'])?$_REQUEST['pDeptoMuni']:"";
    $pDireccion = isset($_REQUEST['pDireccion'])?$_REQUEST['pDireccion']:"";
    $pTel1 = isset($_REQUEST['pTel1'])?$_REQUEST['pTel1']:"";
    $pTel2 = isset($_REQUEST['pTel2'])?$_REQUEST['pTel2']:"NA";
    $pZona = isset($_REQUEST['pZona'])?$_REQUEST['pZona']:"";
    $pEmail = isset($_REQUEST['pEmail'])?$_REQUEST['pEmail']:"NA";
    $pTafiliado = isset($_REQUEST['pTafiliado'])?$_REQUEST['pTafiliado']:"";
    $pParentesco = isset($_REQUEST['pParentesco'])?$_REQUEST['pParentesco']:"NA";
    $pRango = isset($_REQUEST['pRango'])?$_REQUEST['pRango']:0;
    $pEstado = isset($_REQUEST['pEstado'])?$_REQUEST['pEstado']:0;
    $pIdEmpresa = isset($_REQUEST['pIdEmpresa'])?$_REQUEST['pIdEmpresa']:0;
    $pIdSede = isset($_REQUEST['pIdSede'])?$_REQUEST['pIdSede']:0;
    $pIdIPS = isset($_REQUEST['pIdIPS'])?$_REQUEST['pIdIPS']:0;
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;

    $pNomBaseDatos = isset($_REQUEST['pNomBaseDatos'])?$_REQUEST['pNomBaseDatos']:"NA";
    if($pNomBaseDatos == "NA"){
        $gBaseDatos = new ofiMySQLi();
    }else{
        $gBaseDatos = new ofiMySQLi($pNomBaseDatos);
    }
    $gBaseDatos->conectar();
    $qry = 'CALL sp_pacientes_actualizar_radicacion(\'' . $pIdPaciente  . '\',"' . $pApe1 . '","' . $pApe2 . '","' . $pNom1 . '","' . $pNom2 . '","' . $pFecNac . '","' . $pGenero . '","' . $pDireccion . '","' . $pZona . '","' . $pTel1 . '","' . $pTel2 . '","' . $pDeptoMuni . '",\'' . $pRegimen . '\',"' . $pTafiliado . '",\'' . $pRango . '\',"' . $pEmail . '","' . $pParentesco . '",\'' . $pUsuario . '\')';
    //echo $qry;
	echo $gBaseDatos->jasonSP_arreglo($qry);
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
}

?>