<?php

/*
* @category    Controlador Seguimiento Pacientes 4505
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

require("../../../core/php/_database.php");
require("../../../core/php/php_functions.php");

$task = '';
if ( isset($_POST['task'])){
  $task = $_POST['task'];
}
switch($task){
    case "LISTAR":
        Listar();
        break;
    case "LISTAR_REGUNICO":
        ListarRegUnico();
        break;
    case "MODIFICAR_SEGUIMIENTO_REGUNICO":
        ModificarSeguimientoRegUnico();
        break;
    case "MODIFICAR_SEGUIMIENTO":
        ModificarSeguimiento();
        break;
    case "GUARDAR_SEGUIMIENTO":
        GuardarSeguimiento();
        break;
    case "GUARDAR_SEGUIMIENTO_REGUNICO":
        GuardarSeguimientoRegUnico();
        break;
    case "GUARDAR_PERIODO":
        GuardarPeriodo();
        break;
    case "GUARDAR_SEGUIMIENTO_002":
        GuardarSeguimiento002();
        break;
    case "CERRAR_PERIODO":
        CerrarPeriodo();
        break;
    case "GUARDAR_BITACORA":
        GuardarBitacora();
        break;
    case "GENERAR_FILES":
        Generar4505();
        break;
    case "GENERAR_FILES_REGUNICO":
        Generar4505Regunico();
        break;
    default:
        echo "{failure:true}";
        break;
}

function Generar4505Regunico(){
    set_time_limit(0); 
    ignore_user_abort(true);
    ini_set('max_execution_time', 0);
    //set_time_limit(2700);
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pCliente = isset($_REQUEST['pCliente'])?$_REQUEST['pCliente']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_4505_generar_files01('" . $pId4505 . "')";
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    while ($row[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    //GENERAR ARCHIVO PLANO
    $gBaseDatos->cerrar();
    //$pNomArch = "C:\\eoficlinic\\rips\\AC" . $pConsecutivo . ".txt";
    //$fCorte = str_replace("-", "", $row[0]["Hasta"]);
    $pNomArch = "../../../empresas/" . $pEmpresa . "/4505/SGD280RPEDAAAMMDDNIXXXXXXXXXXXXC01.txt";
    if (file_exists($pNomArch)) {
        unlink($pNomArch);
        $tipoArch = "a";
    }else
        $tipoArch = "w+";
    if (!$gestor = fopen($pNomArch, $tipoArch)){
        echo "0";
    }else{
        $gBaseDatos = new ofiMySQLi();
        $gBaseDatos->conectar();
        $qry = "CALL sp_4505_generar_files01('" . $pId4505 . "')";
        $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
        $contenido = "";
        while ($row = @mysqli_fetch_assoc($gBaseDatos->QryID)){
            $finfo = @mysqli_fetch_fields($gBaseDatos->QryID);
            $contenido = "";
            foreach ($finfo as $val){
                $contenido .= str_replace(",", ".", PonerAcentosHTML(utf8_decode($row[$val->name]))) . "|";
            }
            $NewContenido = substr($contenido, 0, (strlen($contenido)-1));
            $NewContenido .= "\r\n";
            if (fwrite($gestor, $NewContenido) === FALSE) {
                $gBaseDatos->liberar();
                $gBaseDatos->cerrar();
                echo "0";
            }
        }
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        //fclose($gestor); 
        //if($contenido == ""){
        //    unlink($pNomArch);
        //}
        $gBaseDatos = new ofiMySQLi();
        $gBaseDatos->conectar();
        $qry = "CALL sp_4505_generar_files02('" . $pId4505 . "')";
        $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
        $contenido = "";
        while ($row = @mysqli_fetch_assoc($gBaseDatos->QryID)){
            $finfo = @mysqli_fetch_fields($gBaseDatos->QryID);
            $contenido = "";
            foreach ($finfo as $val){
                $contenido .= str_replace(",", ".", PonerAcentosHTML(utf8_decode($row[$val->name]))) . "|";
            }
            $NewContenido = substr($contenido, 0, (strlen($contenido)-1));
            $NewContenido .= "\r\n";
            if (fwrite($gestor, $NewContenido) === FALSE) {
                $gBaseDatos->liberar();
                $gBaseDatos->cerrar();
                echo "0";
            }
        }
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        fclose($gestor); 
        if($contenido == ""){
            unlink($pNomArch);
        }
    }
    echo "1";
}

function Generar4505(){
    set_time_limit(0); 
    ignore_user_abort(true);
    ini_set('max_execution_time', 0);
    //set_time_limit(2700);
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pCliente = isset($_REQUEST['pCliente'])?$_REQUEST['pCliente']:0;
    $pId4505 = isset($_REQUEST['pId4505'])?$_REQUEST['pId4505']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_4505_generar_files01('" . $pId4505 . "')";
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    while ($row[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    //GENERAR ARCHIVO PLANO
    $gBaseDatos->cerrar();
    //$pNomArch = "C:\\eoficlinic\\rips\\AC" . $pConsecutivo . ".txt";
    //$fCorte = str_replace("-", "", $row[0]["Hasta"]);
    $pNomArch = "../../../empresas/" . $pEmpresa . "/4505/SGD280RPEDAAAMMDDNIXXXXXXXXXXXXC01.txt";
    if (file_exists($pNomArch)) {
        unlink($pNomArch);
        $tipoArch = "a";
    }else
        $tipoArch = "w+";
    if (!$gestor = fopen($pNomArch, $tipoArch)){
        echo "0";
    }else{
        $gBaseDatos = new ofiMySQLi();
        $gBaseDatos->conectar();
        $qry = "CALL sp_4505_generar_files01('" . $pId4505 . "')";
        $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
        $contenido = "";
        while ($row = @mysqli_fetch_assoc($gBaseDatos->QryID)){
            $finfo = @mysqli_fetch_fields($gBaseDatos->QryID);
            $contenido = "";
            foreach ($finfo as $val){
                $contenido .= str_replace(",", ".", PonerAcentosHTML(utf8_decode($row[$val->name]))) . "|";
            }
            $NewContenido = substr($contenido, 0, (strlen($contenido)-1));
            $NewContenido .= "\r\n";
            if (fwrite($gestor, $NewContenido) === FALSE) {
                $gBaseDatos->liberar();
                $gBaseDatos->cerrar();
                echo "0";
            }
        }
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        //fclose($gestor); 
        //if($contenido == ""){
        //    unlink($pNomArch);
        //}
        $gBaseDatos = new ofiMySQLi();
        $gBaseDatos->conectar();
        $qry = "CALL sp_4505_generar_files02('" . $pId4505 . "')";
        $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
        $contenido = "";
        while ($row = @mysqli_fetch_assoc($gBaseDatos->QryID)){
            $finfo = @mysqli_fetch_fields($gBaseDatos->QryID);
            $contenido = "";
            foreach ($finfo as $val){
                $contenido .= str_replace(",", ".", PonerAcentosHTML(utf8_decode($row[$val->name]))) . "|";
            }
            $NewContenido = substr($contenido, 0, (strlen($contenido)-1));
            $NewContenido .= "\r\n";
            if (fwrite($gestor, $NewContenido) === FALSE) {
                $gBaseDatos->liberar();
                $gBaseDatos->cerrar();
                echo "0";
            }
        }
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        fclose($gestor); 
        if($contenido == ""){
            unlink($pNomArch);
        }
    }
    echo "1";
}

function GuardarBitacora(){
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pFechaContacto = isset($_REQUEST['pFechaContacto'])?$_REQUEST['pFechaContacto']:null;
    $pTipoContacto = isset($_REQUEST['pTipoContacto'])?$_REQUEST['pTipoContacto']:null;
    $pContactoEfectivo = isset($_REQUEST['pContactoEfectivo'])?$_REQUEST['pContactoEfectivo']:null;
    $pPersonaContacto = isset($_REQUEST['pPersonaContacto'])?$_REQUEST['pPersonaContacto']:null;
    $pParentesco = isset($_REQUEST['pParentesco'])?$_REQUEST['pParentesco']:null;
    $pObservacion = isset($_REQUEST['pObservacion'])?$_REQUEST['pObservacion']:null;
    $pProximoContacto = isset($_REQUEST['pProximoContacto'])?$_REQUEST['pProximoContacto']:null;
    $pPrograma = isset($_REQUEST['pPrograma'])?$_REQUEST['pPrograma']:null;
    $pMotivoProximoContacto = isset($_REQUEST['pMotivoProximoContacto'])?$_REQUEST['pMotivoProximoContacto']:null;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_pacientes_bitacora_4505('" . $pIPS . "','" . $pUsuario . "','" . $pPaciente . "',\"" . $pFechaContacto . "\",'" . $pTipoContacto . "','" . $pContactoEfectivo . "','" . $pPersonaContacto . "','" . $pParentesco . "','" . $pObservacion . "',\"" . $pProximoContacto . "\",'" . $pPrograma . "','" . $pMotivoProximoContacto . "')";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function ListarRegUnico(){
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $qry = "CALL sp_grid_pacientes_4505_listar_regunico('" . $pPaciente . "')";
    //echo $qry;
    $CampoLlave = explode("^",$gBaseDatos->jasonSP_arreglo2011($qry));
    $nbrows = $CampoLlave[0];
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    if($nbrows>0){
        $gBaseDatos->conectar();
        $start = (integer) (isset($_POST['start']) ? $_POST['start'] : $_GET['start']);
        $end = (integer) (isset($_POST['limit']) ? $_POST['limit'] : $_GET['limit']);
        $qry = "CALL sp_grid_pacientes_4505_listar_limit_regunico('" . $pPaciente . "','" . $start . "','" . $end . "')";
        //echo $qry;
        $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
        while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
        {
            $nRow = $row;
            foreach($row as $key => $val)
            {
                $nRow[$key] = PonerAcentosHTML($val);
            }
            $arr[] = $nRow;
        }
        $jsonresult = JEncode($arr);
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        echo '({success: true, requestedId:"1", "total":"'.$nbrows.'","results":'.$jsonresult.'})';
    } else {
        echo '({success: true, requestedId:"1", "total":"0", "results":""})';
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    
}
        
function Listar(){
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pCliente = isset($_REQUEST['pCliente'])?$_REQUEST['pCliente']:0;
    $pId4505 = isset($_REQUEST['pId4505'])?$_REQUEST['pId4505']:0;
    $qry = "CALL sp_grid_pacientes_4505_listar('" . $pPaciente . "','" . $pIPS . "','" . $pCliente . "','" . $pId4505 . "')";
    //echo $qry;
    $CampoLlave = explode("^",$gBaseDatos->jasonSP_arreglo2011($qry));
    $nbrows = $CampoLlave[0];
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    if($nbrows>0){
        $gBaseDatos->conectar();
        $start = (integer) (isset($_POST['start']) ? $_POST['start'] : $_GET['start']);
        $end = (integer) (isset($_POST['limit']) ? $_POST['limit'] : $_GET['limit']);
        $qry = "CALL sp_grid_pacientes_4505_listar_limit('" . $pPaciente . "','" . $pIPS . "','" . $pCliente . "','" . $pId4505 . "','" . $start . "','" . $end . "')";
        //echo $qry;
        $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
        while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
        {
            $nRow = $row;
            foreach($row as $key => $val)
            {
                $nRow[$key] = PonerAcentosHTML($val);
            }
            $arr[] = $nRow;
        }
        $jsonresult = JEncode($arr);
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        echo '({success: true, requestedId:"1", "total":"'.$nbrows.'","results":'.$jsonresult.'})';
    } else {
        echo '({success: true, requestedId:"1", "total":"0", "results":""})';
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    
}
        
function ModificarSeguimientoRegUnico(){
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pTipoDoc = isset($_REQUEST['pTipoDoc'])?$_REQUEST['pTipoDoc']:null;
    $pDocumento = isset($_REQUEST['pDocumento'])?$_REQUEST['pDocumento']:null;
    $pPrimerApellido = isset($_REQUEST['pPrimerApellido'])?$_REQUEST['pPrimerApellido']:null;
    $pSegundoApellido = isset($_REQUEST['pSegundoApellido'])?$_REQUEST['pSegundoApellido']:null;
    $pPrimerNombre = isset($_REQUEST['pPrimerNombre'])?$_REQUEST['pPrimerNombre']:null;
    $pSegundoNombre = isset($_REQUEST['pSegundoNombre'])?$_REQUEST['pSegundoNombre']:null;
    $pFechaNac = isset($_REQUEST['pFechaNac'])?$_REQUEST['pFechaNac']:null;
    $pGenero = isset($_REQUEST['pGenero'])?$_REQUEST['pGenero']:null;
    $pEtniaHC = isset($_REQUEST['pEtniaHC'])?$_REQUEST['pEtniaHC']:0;
    $pOcupacionHC = isset($_REQUEST['pOcupacionHC'])?$_REQUEST['pOcupacionHC']:0;
    $pEscolaridadHC = isset($_REQUEST['pEscolaridadHC'])?$_REQUEST['pEscolaridadHC']:0;
    $pGestacion = isset($_REQUEST['pGestacion'])?$_REQUEST['pGestacion']:0;
    $pSifilisGestacional = isset($_REQUEST['pSifilisGestacional'])?$_REQUEST['pSifilisGestacional']:0;
    $pHipertencionGestacional = isset($_REQUEST['pHipertencionGestacional'])?$_REQUEST['pHipertencionGestacional']:0;
    $pHipotiroidismoCongenito = isset($_REQUEST['pHipotiroidismoCongenito'])?$_REQUEST['pHipotiroidismoCongenito']:0;
    $pSintomaticoRespiratorio = isset($_REQUEST['pSintomaticoRespiratorio'])?$_REQUEST['pSintomaticoRespiratorio']:0;
    $pTuberculosisMultidrogoresistente = isset($_REQUEST['pTuberculosisMultidrogoresistente'])?$_REQUEST['pTuberculosisMultidrogoresistente']:0;
    $pLepra = isset($_REQUEST['pLepra'])?$_REQUEST['pLepra']:0;
    $pObesidadDesnutricion = isset($_REQUEST['pObesidadDesnutricion'])?$_REQUEST['pObesidadDesnutricion']:0;
    $pVictimaMaltrato = isset($_REQUEST['pVictimaMaltrato'])?$_REQUEST['pVictimaMaltrato']:0;
    $pViolenciaSexual = isset($_REQUEST['pViolenciaSexual'])?$_REQUEST['pViolenciaSexual']:0;
    $pInfeccionesTrasmisionSexual = isset($_REQUEST['pInfeccionesTrasmisionSexual'])?$_REQUEST['pInfeccionesTrasmisionSexual']:0;
    $pEnfermedadMental = isset($_REQUEST['pEnfermedadMental'])?$_REQUEST['pEnfermedadMental']:0;
    $pCancerCervix = isset($_REQUEST['pCancerCervix'])?$_REQUEST['pCancerCervix']:0;
    $pCancerSeno = isset($_REQUEST['pCancerSeno'])?$_REQUEST['pCancerSeno']:0;
    $pFluorosisDental = isset($_REQUEST['pFluorosisDental'])?$_REQUEST['pFluorosisDental']:0;
    $pFecPeso = isset($_REQUEST['pFecPeso'])?$_REQUEST['pFecPeso']:null;
    $pPeso = isset($_REQUEST['pPeso'])?$_REQUEST['pPeso']:0;
    $pFecTalla = isset($_REQUEST['pFecTalla'])?$_REQUEST['pFecTalla']:null;
    $pTalla = isset($_REQUEST['pTalla'])?$_REQUEST['pTalla']:0;
    $pProbableParto = isset($_REQUEST['pProbableParto'])?$_REQUEST['pProbableParto']:null;
    $pEdadGestacionalNacer = isset($_REQUEST['pEdadGestacionalNacer'])?$_REQUEST['pEdadGestacionalNacer']:0;
    $pBCG = isset($_REQUEST['pBCG'])?$_REQUEST['pBCG']:0;
    $pHepatitisB = isset($_REQUEST['pHepatitisB'])?$_REQUEST['pHepatitisB']:0;
    $pPentavalente = isset($_REQUEST['pPentavalente'])?$_REQUEST['pPentavalente']:0;
    $pPolio = isset($_REQUEST['pPolio'])?$_REQUEST['pPolio']:0;
    $pDPT = isset($_REQUEST['pDPT'])?$_REQUEST['pDPT']:0;
    $pRotavirus = isset($_REQUEST['pRotavirus'])?$_REQUEST['pRotavirus']:0;
    $pNeumococo = isset($_REQUEST['pNeumococo'])?$_REQUEST['pNeumococo']:0;
    $pInfluenza = isset($_REQUEST['pInfluenza'])?$_REQUEST['pInfluenza']:0;
    $pFiebreAmarilla = isset($_REQUEST['pFiebreAmarilla'])?$_REQUEST['pFiebreAmarilla']:0;
    $pHepatitisA = isset($_REQUEST['pHepatitisA'])?$_REQUEST['pHepatitisA']:0;
    $pTripleViral = isset($_REQUEST['pTripleViral'])?$_REQUEST['pTripleViral']:0;
    $pVPH = isset($_REQUEST['pVPH'])?$_REQUEST['pVPH']:0;
    $pTD = isset($_REQUEST['pTD'])?$_REQUEST['pTD']:0;
    $pControlPlacaBacteriana = isset($_REQUEST['pControlPlacaBacteriana'])?$_REQUEST['pControlPlacaBacteriana']:0;
    $pAtencionParto = isset($_REQUEST['pAtencionParto'])?$_REQUEST['pAtencionParto']:null;
    $pSalidaAtencionParto = isset($_REQUEST['pSalidaAtencionParto'])?$_REQUEST['pSalidaAtencionParto']:null;
    $pConcejeriaLactancia = isset($_REQUEST['pConcejeriaLactancia'])?$_REQUEST['pConcejeriaLactancia']:null;
    $pControlRecienNacido = isset($_REQUEST['pControlRecienNacido'])?$_REQUEST['pControlRecienNacido']:null;
    $pPlanificacionFamiliarPrimeraVez = isset($_REQUEST['pPlanificacionFamiliarPrimeraVez'])?$_REQUEST['pPlanificacionFamiliarPrimeraVez']:null;
    $pSuministroMetodoPlanificacion = isset($_REQUEST['pSuministroMetodoPlanificacion'])?$_REQUEST['pSuministroMetodoPlanificacion']:0;
    $pSuministroMetodo = isset($_REQUEST['pSuministroMetodo'])?$_REQUEST['pSuministroMetodo']:null;
    $pControlPrenatalPrimeraVez = isset($_REQUEST['pControlPrenatalPrimeraVez'])?$_REQUEST['pControlPrenatalPrimeraVez']:null;
    $pControlPrenatal = isset($_REQUEST['pControlPrenatal'])?$_REQUEST['pControlPrenatal']:0;
    $pUltimoControlPrenatal = isset($_REQUEST['pUltimoControlPrenatal'])?$_REQUEST['pUltimoControlPrenatal']:null;
    $pSuministroAcidoFolico = isset($_REQUEST['pSuministroAcidoFolico'])?$_REQUEST['pSuministroAcidoFolico']:0;
    $pSuministroSulfatoFerroso = isset($_REQUEST['pSuministroSulfatoFerroso'])?$_REQUEST['pSuministroSulfatoFerroso']:0;
    $pSuministroCarbonatoCalcio = isset($_REQUEST['pSuministroCarbonatoCalcio'])?$_REQUEST['pSuministroCarbonatoCalcio']:0;
    $pValoracionAgudezaVisual = isset($_REQUEST['pValoracionAgudezaVisual'])?$_REQUEST['pValoracionAgudezaVisual']:null;
    $pConsultaOfitalmologia = isset($_REQUEST['pConsultaOfitalmologia'])?$_REQUEST['pConsultaOfitalmologia']:null;
    $pFechaDxDesnutricion = isset($_REQUEST['pFechaDxDesnutricion'])?$_REQUEST['pFechaDxDesnutricion']:null;
    $pConsultaMujerVictimaMaltrato = isset($_REQUEST['pConsultaMujerVictimaMaltrato'])?$_REQUEST['pConsultaMujerVictimaMaltrato']:null;
    $pConsultaViolenciaSexual = isset($_REQUEST['pConsultaViolenciaSexual'])?$_REQUEST['pConsultaViolenciaSexual']:null;
    $pConsultaNutricion = isset($_REQUEST['pConsultaNutricion'])?$_REQUEST['pConsultaNutricion']:null;
    $pConsultaPsicologia = isset($_REQUEST['pConsultaPsicologia'])?$_REQUEST['pConsultaPsicologia']:null;
    $pConsultaCyDPrimeraVez = isset($_REQUEST['pConsultaCyDPrimeraVez'])?$_REQUEST['pConsultaCyDPrimeraVez']:null;
    $pSuministroSulfatoFerroso1ano = isset($_REQUEST['pSuministroSulfatoFerroso1ano'])?$_REQUEST['pSuministroSulfatoFerroso1ano']:0;
    $pSuministroVitaminaA = isset($_REQUEST['pSuministroVitaminaA'])?$_REQUEST['pSuministroVitaminaA']:0;
    $pConsultaJovenPrimeraVez = isset($_REQUEST['pConsultaJovenPrimeraVez'])?$_REQUEST['pConsultaJovenPrimeraVez']:null;
    $pConsultaAdultoPrimeraVez = isset($_REQUEST['pConsultaAdultoPrimeraVez'])?$_REQUEST['pConsultaAdultoPrimeraVez']:null;
    $pPreservativosEntregadosITS = isset($_REQUEST['pPreservativosEntregadosITS'])?$_REQUEST['pPreservativosEntregadosITS']:0;
    $pAsesoriaPreTestVIH = isset($_REQUEST['pAsesoriaPreTestVIH'])?$_REQUEST['pAsesoriaPreTestVIH']:null;
    $pAsesoriaPosTestVIH = isset($_REQUEST['pAsesoriaPosTestVIH'])?$_REQUEST['pAsesoriaPosTestVIH']:null;
    $pEnfMentalTratamientoUlt6Meses = isset($_REQUEST['pEnfMentalTratamientoUlt6Meses'])?$_REQUEST['pEnfMentalTratamientoUlt6Meses']:0;
    $pAntigenoHepatitisB = isset($_REQUEST['pAntigenoHepatitisB'])?$_REQUEST['pAntigenoHepatitisB']:null;
    $pResultadoAntigenoHepatitisB = isset($_REQUEST['pResultadoAntigenoHepatitisB'])?$_REQUEST['pResultadoAntigenoHepatitisB']:0;
    $pSerologia = isset($_REQUEST['pSerologia'])?$_REQUEST['pSerologia']:null;
    $pResultadoSerologia = isset($_REQUEST['pResultadoSerologia'])?$_REQUEST['pResultadoSerologia']:0;
    $pTomaElisaVIH = isset($_REQUEST['pTomaElisaVIH'])?$_REQUEST['pTomaElisaVIH']:null;
    $pResultadoElisaVIH = isset($_REQUEST['pResultadoElisaVIH'])?$_REQUEST['pResultadoElisaVIH']:0;
    $pTSHNeonatal = isset($_REQUEST['pTSHNeonatal'])?$_REQUEST['pTSHNeonatal']:null;
    $pResultadoTSHNeonatal = isset($_REQUEST['pResultadoTSHNeonatal'])?$_REQUEST['pResultadoTSHNeonatal']:0;
    $pTamizajeCancerCuelloUterino = isset($_REQUEST['pTamizajeCancerCuelloUterino'])?$_REQUEST['pTamizajeCancerCuelloUterino']:0;
    $pTomaCitologia = isset($_REQUEST['pTomaCitologia'])?$_REQUEST['pTomaCitologia']:null;
    $pResultadoCitologia = isset($_REQUEST['pResultadoCitologia'])?$_REQUEST['pResultadoCitologia']:0;
    $pCalidadMuestraCitologia = isset($_REQUEST['pCalidadMuestraCitologia'])?$_REQUEST['pCalidadMuestraCitologia']:0;
    $pCodIPSTomaCitologia = isset($_REQUEST['pCodIPSTomaCitologia'])?$_REQUEST['pCodIPSTomaCitologia']:0;
    $pTomaColposcopia = isset($_REQUEST['pTomaColposcopia'])?$_REQUEST['pTomaColposcopia']:null;
    $pCodIPSTomaColposcopia = isset($_REQUEST['pCodIPSTomaColposcopia'])?$_REQUEST['pCodIPSTomaColposcopia']:0;
    $pBiopsiaCervical = isset($_REQUEST['pBiopsiaCervical'])?$_REQUEST['pBiopsiaCervical']:null;
    $pResultadoBiopsiaCervical = isset($_REQUEST['pResultadoBiopsiaCervical'])?$_REQUEST['pResultadoBiopsiaCervical']:0;
    $pCodIPSTomaBiopsiaCervical = isset($_REQUEST['pCodIPSTomaBiopsiaCervical'])?$_REQUEST['pCodIPSTomaBiopsiaCervical']:0;
    $pMamografia = isset($_REQUEST['pMamografia'])?$_REQUEST['pMamografia']:null;
    $pResultadoMamografia = isset($_REQUEST['pResultadoMamografia'])?$_REQUEST['pResultadoMamografia']:0;
    $pCodIPSTomaMamografia = isset($_REQUEST['pCodIPSTomaMamografia'])?$_REQUEST['pCodIPSTomaMamografia']:0;
    $pTomaBiopsiaSenoBACAF = isset($_REQUEST['pTomaBiopsiaSenoBACAF'])?$_REQUEST['pTomaBiopsiaSenoBACAF']:null;
    $pFecResultadoBiopsiaSeno = isset($_REQUEST['pFecResultadoBiopsiaSeno'])?$_REQUEST['pResultadoBiopsiaSeno']:null;
    $pResultadoBiopsiaSeno = isset($_REQUEST['pResultadoBiopsiaSeno'])?$_REQUEST['pResultadoBiopsiaSeno']:0;
    $pCodIPSTomaBiopsiaSeno = isset($_REQUEST['pCodIPSTomaBiopsiaSeno'])?$_REQUEST['pCodIPSTomaBiopsiaSeno']:0;
    $pTomaHemoglobina = isset($_REQUEST['pTomaHemoglobina'])?$_REQUEST['pTomaHemoglobina']:null;
    $pResultadoHemoglobina = isset($_REQUEST['pResultadoHemoglobina'])?$_REQUEST['pResultadoHemoglobina']:0;
    $pTomaGlicemia = isset($_REQUEST['pTomaGlicemia'])?$_REQUEST['pTomaGlicemia']:null;
    $pTomaCreatinina = isset($_REQUEST['pTomaCreatinina'])?$_REQUEST['pTomaCreatinina']:null;
    $pResultadoCreatinina = isset($_REQUEST['pResultadoCreatinina'])?$_REQUEST['pResultadoCreatinina']:0;
    $pTomaHemoglobinaGlicosilada = isset($_REQUEST['pTomaHemoglobinaGlicosilada'])?$_REQUEST['pTomaHemoglobinaGlicosilada']:null;
    $pResultadoHemoglobinaGlicosilada = isset($_REQUEST['pResultadoHemoglobinaGlicosilada'])?$_REQUEST['pResultadoHemoglobinaGlicosilada']:0;
    $pTomaMicroalbuminuria = isset($_REQUEST['pTomaMicroalbuminuria'])?$_REQUEST['pTomaMicroalbuminuria']:null;
    $pTomaHDL = isset($_REQUEST['pTomaHDL'])?$_REQUEST['pTomaHDL']:null;
    $pTomaBaciloscopiaDiagnostica = isset($_REQUEST['pTomaBaciloscopiaDiagnostica'])?$_REQUEST['pTomaBaciloscopiaDiagnostica']:null;
    $pResultadoBaciloscopiaDiagnostica = isset($_REQUEST['pResultadoBaciloscopiaDiagnostica'])?$_REQUEST['pResultadoBaciloscopiaDiagnostica']:0;
    $pTratamientoHipotiroidismoCongenito = isset($_REQUEST['pTratamientoHipotiroidismoCongenito'])?$_REQUEST['pTratamientoHipotiroidismoCongenito']:0;
    $pTratamientoSifilisGestacional = isset($_REQUEST['pTratamientoSifilisGestacional'])?$_REQUEST['pTratamientoSifilisGestacional']:0;
    $pTratamientoSifilisCongenita = isset($_REQUEST['pTratamientoSifilisCongenita'])?$_REQUEST['pTratamientoSifilisCongenita']:0;
    $pTratamientoLepra = isset($_REQUEST['pTratamientoLepra'])?$_REQUEST['pTratamientoLepra']:0;
    $pTerminacionTratamientoLeishmaniasis = isset($_REQUEST['pTerminacionTratamientoLeishmaniasis'])?$_REQUEST['pTerminacionTratamientoLeishmaniasis']:null;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_pacientes_4505_update_regunico('" . $pUsuario . "','" . $pPaciente . "','" . $pTipoDoc . "','" . $pDocumento . "','" . $pPrimerApellido . "','" . $pSegundoApellido . "','" . $pPrimerNombre . "','" . $pSegundoNombre . "',\"" . $pFechaNac . "\",'" . $pGenero . "','" . $pEtniaHC . "','" . $pOcupacionHC . "','" . $pEscolaridadHC . "','" . $pGestacion . "','" . $pSifilisGestacional . "','" . $pHipertencionGestacional . "','" . $pHipotiroidismoCongenito . "','" . $pSintomaticoRespiratorio . "','" . $pTuberculosisMultidrogoresistente . "','" . $pLepra . "','" . $pObesidadDesnutricion . "','" . $pVictimaMaltrato . "','" . $pViolenciaSexual . "','" . $pInfeccionesTrasmisionSexual . "','" . $pEnfermedadMental . "','" . $pCancerCervix . "','" . $pCancerSeno . "','" . $pFluorosisDental . "',\"" . $pFecPeso . "\",'" . $pPeso . "',\"" . $pFecTalla . "\",'" . $pTalla . "',\"" . $pProbableParto . "\",'" . $pEdadGestacionalNacer . "','" . $pBCG . "','" . $pHepatitisB . "','" . $pPentavalente . "','" . $pPolio . "','" . $pDPT . "','" . $pRotavirus . "','" . $pNeumococo . "','" . $pInfluenza . "','" . $pFiebreAmarilla . "','" . $pHepatitisA . "','" . $pTripleViral . "','" . $pVPH . "','" . $pTD . "','" . $pControlPlacaBacteriana . "',\"" . $pAtencionParto . "\",\"" . $pSalidaAtencionParto . "\",\"" . $pConcejeriaLactancia . "\",\"" . $pControlRecienNacido . "\",\"" . $pPlanificacionFamiliarPrimeraVez . "\",'" . $pSuministroMetodoPlanificacion . "',\"" . $pSuministroMetodo . "\",\"" . $pControlPrenatalPrimeraVez . "\",'" . $pControlPrenatal . "',\"" . $pUltimoControlPrenatal . "\",'" . $pSuministroAcidoFolico . "','" . $pSuministroSulfatoFerroso . "','" . $pSuministroCarbonatoCalcio . "',\"" . $pValoracionAgudezaVisual . "\",\"" . $pConsultaOfitalmologia . "\",\"" . $pFechaDxDesnutricion . "\",\"" . $pConsultaMujerVictimaMaltrato . "\",\"" . $pConsultaViolenciaSexual . "\",\"" . $pConsultaNutricion . "\",\"" . $pConsultaPsicologia . "\",\"" . $pConsultaCyDPrimeraVez . "\",'" . $pSuministroSulfatoFerroso1ano . "','" . $pSuministroVitaminaA . "',\"" . $pConsultaJovenPrimeraVez . "\",\"" . $pConsultaAdultoPrimeraVez . "\",'" . $pPreservativosEntregadosITS . "',\"" . $pAsesoriaPreTestVIH . "\",\"" . $pAsesoriaPosTestVIH . "\",'" . $pEnfMentalTratamientoUlt6Meses . "',\"" . $pAntigenoHepatitisB . "\",'" . $pResultadoAntigenoHepatitisB . "',\"" . $pSerologia . "\",'" . $pResultadoSerologia . "',\"" . $pTomaElisaVIH . "\",'" . $pResultadoElisaVIH . "',\"" . $pTSHNeonatal . "\",'" . $pResultadoTSHNeonatal . "','" . $pTamizajeCancerCuelloUterino . "',\"" . $pTomaCitologia . "\",'" . $pResultadoCitologia . "','" . $pCalidadMuestraCitologia . "','" . $pCodIPSTomaCitologia . "',\"" . $pTomaColposcopia . "\",'" . $pCodIPSTomaColposcopia . "',\"" . $pBiopsiaCervical . "\",'" . $pResultadoBiopsiaCervical . "','" . $pCodIPSTomaBiopsiaCervical . "',\"" . $pMamografia . "\",'" . $pResultadoMamografia . "','" . $pCodIPSTomaMamografia . "',\"" . $pTomaBiopsiaSenoBACAF . "\",\"" . $pFecResultadoBiopsiaSeno . "\",'" . $pResultadoBiopsiaSeno . "','" . $pCodIPSTomaBiopsiaSeno . "',\"" . $pTomaHemoglobina . "\",'" . $pResultadoHemoglobina . "',\"" . $pTomaGlicemia . "\",\"" . $pTomaCreatinina . "\",'" . $pResultadoCreatinina . "',\"" . $pTomaHemoglobinaGlicosilada . "\",'" . $pResultadoHemoglobinaGlicosilada . "',\"" . $pTomaMicroalbuminuria . "\",\"" . $pTomaHDL . "\",\"" . $pTomaBaciloscopiaDiagnostica . "\",'" . $pResultadoBaciloscopiaDiagnostica . "','" . $pTratamientoHipotiroidismoCongenito . "','" . $pTratamientoSifilisGestacional . "','" . $pTratamientoSifilisCongenita . "','" . $pTratamientoLepra . "',\"" . $pTerminacionTratamientoLeishmaniasis . "\")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}
        
function ModificarSeguimiento(){
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $pId4505 = isset($_REQUEST['pId4505'])?$_REQUEST['pId4505']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pCliente = isset($_REQUEST['pCliente'])?$_REQUEST['pCliente']:0;
    $pConsecutivoRegistro = isset($_REQUEST['pConsecutivoRegistro'])?$_REQUEST['pConsecutivoRegistro']:0;
    $pTipoDoc = isset($_REQUEST['pTipoDoc'])?$_REQUEST['pTipoDoc']:null;
    $pDocumento = isset($_REQUEST['pDocumento'])?$_REQUEST['pDocumento']:null;
    $pPrimerApellido = isset($_REQUEST['pPrimerApellido'])?$_REQUEST['pPrimerApellido']:null;
    $pSegundoApellido = isset($_REQUEST['pSegundoApellido'])?$_REQUEST['pSegundoApellido']:null;
    $pPrimerNombre = isset($_REQUEST['pPrimerNombre'])?$_REQUEST['pPrimerNombre']:null;
    $pSegundoNombre = isset($_REQUEST['pSegundoNombre'])?$_REQUEST['pSegundoNombre']:null;
    $pFechaNac = isset($_REQUEST['pFechaNac'])?$_REQUEST['pFechaNac']:null;
    $pGenero = isset($_REQUEST['pGenero'])?$_REQUEST['pGenero']:null;
    $pEtniaHC = isset($_REQUEST['pEtniaHC'])?$_REQUEST['pEtniaHC']:0;
    $pOcupacionHC = isset($_REQUEST['pOcupacionHC'])?$_REQUEST['pOcupacionHC']:0;
    $pEscolaridadHC = isset($_REQUEST['pEscolaridadHC'])?$_REQUEST['pEscolaridadHC']:0;
    $pGestacion = isset($_REQUEST['pGestacion'])?$_REQUEST['pGestacion']:0;
    $pSifilisGestacional = isset($_REQUEST['pSifilisGestacional'])?$_REQUEST['pSifilisGestacional']:0;
    $pHipertencionGestacional = isset($_REQUEST['pHipertencionGestacional'])?$_REQUEST['pHipertencionGestacional']:0;
    $pHipotiroidismoCongenito = isset($_REQUEST['pHipotiroidismoCongenito'])?$_REQUEST['pHipotiroidismoCongenito']:0;
    $pSintomaticoRespiratorio = isset($_REQUEST['pSintomaticoRespiratorio'])?$_REQUEST['pSintomaticoRespiratorio']:0;
    $pTuberculosisMultidrogoresistente = isset($_REQUEST['pTuberculosisMultidrogoresistente'])?$_REQUEST['pTuberculosisMultidrogoresistente']:0;
    $pLepra = isset($_REQUEST['pLepra'])?$_REQUEST['pLepra']:0;
    $pObesidadDesnutricion = isset($_REQUEST['pObesidadDesnutricion'])?$_REQUEST['pObesidadDesnutricion']:0;
    $pVictimaMaltrato = isset($_REQUEST['pVictimaMaltrato'])?$_REQUEST['pVictimaMaltrato']:0;
    $pViolenciaSexual = isset($_REQUEST['pViolenciaSexual'])?$_REQUEST['pViolenciaSexual']:0;
    $pInfeccionesTrasmisionSexual = isset($_REQUEST['pInfeccionesTrasmisionSexual'])?$_REQUEST['pInfeccionesTrasmisionSexual']:0;
    $pEnfermedadMental = isset($_REQUEST['pEnfermedadMental'])?$_REQUEST['pEnfermedadMental']:0;
    $pCancerCervix = isset($_REQUEST['pCancerCervix'])?$_REQUEST['pCancerCervix']:0;
    $pCancerSeno = isset($_REQUEST['pCancerSeno'])?$_REQUEST['pCancerSeno']:0;
    $pFluorosisDental = isset($_REQUEST['pFluorosisDental'])?$_REQUEST['pFluorosisDental']:0;
    $pFecPeso = isset($_REQUEST['pFecPeso'])?$_REQUEST['pFecPeso']:null;
    $pPeso = isset($_REQUEST['pPeso'])?$_REQUEST['pPeso']:0;
    $pFecTalla = isset($_REQUEST['pFecTalla'])?$_REQUEST['pFecTalla']:null;
    $pTalla = isset($_REQUEST['pTalla'])?$_REQUEST['pTalla']:0;
    $pProbableParto = isset($_REQUEST['pProbableParto'])?$_REQUEST['pProbableParto']:null;
    $pEdadGestacionalNacer = isset($_REQUEST['pEdadGestacionalNacer'])?$_REQUEST['pEdadGestacionalNacer']:0;
    $pBCG = isset($_REQUEST['pBCG'])?$_REQUEST['pBCG']:0;
    $pHepatitisB = isset($_REQUEST['pHepatitisB'])?$_REQUEST['pHepatitisB']:0;
    $pPentavalente = isset($_REQUEST['pPentavalente'])?$_REQUEST['pPentavalente']:0;
    $pPolio = isset($_REQUEST['pPolio'])?$_REQUEST['pPolio']:0;
    $pDPT = isset($_REQUEST['pDPT'])?$_REQUEST['pDPT']:0;
    $pRotavirus = isset($_REQUEST['pRotavirus'])?$_REQUEST['pRotavirus']:0;
    $pNeumococo = isset($_REQUEST['pNeumococo'])?$_REQUEST['pNeumococo']:0;
    $pInfluenza = isset($_REQUEST['pInfluenza'])?$_REQUEST['pInfluenza']:0;
    $pFiebreAmarilla = isset($_REQUEST['pFiebreAmarilla'])?$_REQUEST['pFiebreAmarilla']:0;
    $pHepatitisA = isset($_REQUEST['pHepatitisA'])?$_REQUEST['pHepatitisA']:0;
    $pTripleViral = isset($_REQUEST['pTripleViral'])?$_REQUEST['pTripleViral']:0;
    $pVPH = isset($_REQUEST['pVPH'])?$_REQUEST['pVPH']:0;
    $pTD = isset($_REQUEST['pTD'])?$_REQUEST['pTD']:0;
    $pControlPlacaBacteriana = isset($_REQUEST['pControlPlacaBacteriana'])?$_REQUEST['pControlPlacaBacteriana']:0;
    $pAtencionParto = isset($_REQUEST['pAtencionParto'])?$_REQUEST['pAtencionParto']:null;
    $pSalidaAtencionParto = isset($_REQUEST['pSalidaAtencionParto'])?$_REQUEST['pSalidaAtencionParto']:null;
    $pConcejeriaLactancia = isset($_REQUEST['pConcejeriaLactancia'])?$_REQUEST['pConcejeriaLactancia']:null;
    $pControlRecienNacido = isset($_REQUEST['pControlRecienNacido'])?$_REQUEST['pControlRecienNacido']:null;
    $pPlanificacionFamiliarPrimeraVez = isset($_REQUEST['pPlanificacionFamiliarPrimeraVez'])?$_REQUEST['pPlanificacionFamiliarPrimeraVez']:null;
    $pSuministroMetodoPlanificacion = isset($_REQUEST['pSuministroMetodoPlanificacion'])?$_REQUEST['pSuministroMetodoPlanificacion']:0;
    $pSuministroMetodo = isset($_REQUEST['pSuministroMetodo'])?$_REQUEST['pSuministroMetodo']:null;
    $pControlPrenatalPrimeraVez = isset($_REQUEST['pControlPrenatalPrimeraVez'])?$_REQUEST['pControlPrenatalPrimeraVez']:null;
    $pControlPrenatal = isset($_REQUEST['pControlPrenatal'])?$_REQUEST['pControlPrenatal']:0;
    $pUltimoControlPrenatal = isset($_REQUEST['pUltimoControlPrenatal'])?$_REQUEST['pUltimoControlPrenatal']:null;
    $pSuministroAcidoFolico = isset($_REQUEST['pSuministroAcidoFolico'])?$_REQUEST['pSuministroAcidoFolico']:0;
    $pSuministroSulfatoFerroso = isset($_REQUEST['pSuministroSulfatoFerroso'])?$_REQUEST['pSuministroSulfatoFerroso']:0;
    $pSuministroCarbonatoCalcio = isset($_REQUEST['pSuministroCarbonatoCalcio'])?$_REQUEST['pSuministroCarbonatoCalcio']:0;
    $pValoracionAgudezaVisual = isset($_REQUEST['pValoracionAgudezaVisual'])?$_REQUEST['pValoracionAgudezaVisual']:null;
    $pConsultaOfitalmologia = isset($_REQUEST['pConsultaOfitalmologia'])?$_REQUEST['pConsultaOfitalmologia']:null;
    $pFechaDxDesnutricion = isset($_REQUEST['pFechaDxDesnutricion'])?$_REQUEST['pFechaDxDesnutricion']:null;
    $pConsultaMujerVictimaMaltrato = isset($_REQUEST['pConsultaMujerVictimaMaltrato'])?$_REQUEST['pConsultaMujerVictimaMaltrato']:null;
    $pConsultaViolenciaSexual = isset($_REQUEST['pConsultaViolenciaSexual'])?$_REQUEST['pConsultaViolenciaSexual']:null;
    $pConsultaNutricion = isset($_REQUEST['pConsultaNutricion'])?$_REQUEST['pConsultaNutricion']:null;
    $pConsultaPsicologia = isset($_REQUEST['pConsultaPsicologia'])?$_REQUEST['pConsultaPsicologia']:null;
    $pConsultaCyDPrimeraVez = isset($_REQUEST['pConsultaCyDPrimeraVez'])?$_REQUEST['pConsultaCyDPrimeraVez']:null;
    $pSuministroSulfatoFerroso1ano = isset($_REQUEST['pSuministroSulfatoFerroso1ano'])?$_REQUEST['pSuministroSulfatoFerroso1ano']:0;
    $pSuministroVitaminaA = isset($_REQUEST['pSuministroVitaminaA'])?$_REQUEST['pSuministroVitaminaA']:0;
    $pConsultaJovenPrimeraVez = isset($_REQUEST['pConsultaJovenPrimeraVez'])?$_REQUEST['pConsultaJovenPrimeraVez']:null;
    $pConsultaAdultoPrimeraVez = isset($_REQUEST['pConsultaAdultoPrimeraVez'])?$_REQUEST['pConsultaAdultoPrimeraVez']:null;
    $pPreservativosEntregadosITS = isset($_REQUEST['pPreservativosEntregadosITS'])?$_REQUEST['pPreservativosEntregadosITS']:0;
    $pAsesoriaPreTestVIH = isset($_REQUEST['pAsesoriaPreTestVIH'])?$_REQUEST['pAsesoriaPreTestVIH']:null;
    $pAsesoriaPosTestVIH = isset($_REQUEST['pAsesoriaPosTestVIH'])?$_REQUEST['pAsesoriaPosTestVIH']:null;
    $pEnfMentalTratamientoUlt6Meses = isset($_REQUEST['pEnfMentalTratamientoUlt6Meses'])?$_REQUEST['pEnfMentalTratamientoUlt6Meses']:0;
    $pAntigenoHepatitisB = isset($_REQUEST['pAntigenoHepatitisB'])?$_REQUEST['pAntigenoHepatitisB']:null;
    $pResultadoAntigenoHepatitisB = isset($_REQUEST['pResultadoAntigenoHepatitisB'])?$_REQUEST['pResultadoAntigenoHepatitisB']:0;
    $pSerologia = isset($_REQUEST['pSerologia'])?$_REQUEST['pSerologia']:null;
    $pResultadoSerologia = isset($_REQUEST['pResultadoSerologia'])?$_REQUEST['pResultadoSerologia']:0;
    $pTomaElisaVIH = isset($_REQUEST['pTomaElisaVIH'])?$_REQUEST['pTomaElisaVIH']:null;
    $pResultadoElisaVIH = isset($_REQUEST['pResultadoElisaVIH'])?$_REQUEST['pResultadoElisaVIH']:0;
    $pTSHNeonatal = isset($_REQUEST['pTSHNeonatal'])?$_REQUEST['pTSHNeonatal']:null;
    $pResultadoTSHNeonatal = isset($_REQUEST['pResultadoTSHNeonatal'])?$_REQUEST['pResultadoTSHNeonatal']:0;
    $pTamizajeCancerCuelloUterino = isset($_REQUEST['pTamizajeCancerCuelloUterino'])?$_REQUEST['pTamizajeCancerCuelloUterino']:0;
    $pTomaCitologia = isset($_REQUEST['pTomaCitologia'])?$_REQUEST['pTomaCitologia']:null;
    $pResultadoCitologia = isset($_REQUEST['pResultadoCitologia'])?$_REQUEST['pResultadoCitologia']:0;
    $pCalidadMuestraCitologia = isset($_REQUEST['pCalidadMuestraCitologia'])?$_REQUEST['pCalidadMuestraCitologia']:0;
    $pCodIPSTomaCitologia = isset($_REQUEST['pCodIPSTomaCitologia'])?$_REQUEST['pCodIPSTomaCitologia']:0;
    $pTomaColposcopia = isset($_REQUEST['pTomaColposcopia'])?$_REQUEST['pTomaColposcopia']:null;
    $pCodIPSTomaColposcopia = isset($_REQUEST['pCodIPSTomaColposcopia'])?$_REQUEST['pCodIPSTomaColposcopia']:0;
    $pBiopsiaCervical = isset($_REQUEST['pBiopsiaCervical'])?$_REQUEST['pBiopsiaCervical']:null;
    $pResultadoBiopsiaCervical = isset($_REQUEST['pResultadoBiopsiaCervical'])?$_REQUEST['pResultadoBiopsiaCervical']:0;
    $pCodIPSTomaBiopsiaCervical = isset($_REQUEST['pCodIPSTomaBiopsiaCervical'])?$_REQUEST['pCodIPSTomaBiopsiaCervical']:0;
    $pMamografia = isset($_REQUEST['pMamografia'])?$_REQUEST['pMamografia']:null;
    $pResultadoMamografia = isset($_REQUEST['pResultadoMamografia'])?$_REQUEST['pResultadoMamografia']:0;
    $pCodIPSTomaMamografia = isset($_REQUEST['pCodIPSTomaMamografia'])?$_REQUEST['pCodIPSTomaMamografia']:0;
    $pTomaBiopsiaSenoBACAF = isset($_REQUEST['pTomaBiopsiaSenoBACAF'])?$_REQUEST['pTomaBiopsiaSenoBACAF']:null;
    $pFecResultadoBiopsiaSeno = isset($_REQUEST['pFecResultadoBiopsiaSeno'])?$_REQUEST['pResultadoBiopsiaSeno']:null;
    $pResultadoBiopsiaSeno = isset($_REQUEST['pResultadoBiopsiaSeno'])?$_REQUEST['pResultadoBiopsiaSeno']:0;
    $pCodIPSTomaBiopsiaSeno = isset($_REQUEST['pCodIPSTomaBiopsiaSeno'])?$_REQUEST['pCodIPSTomaBiopsiaSeno']:0;
    $pTomaHemoglobina = isset($_REQUEST['pTomaHemoglobina'])?$_REQUEST['pTomaHemoglobina']:null;
    $pResultadoHemoglobina = isset($_REQUEST['pResultadoHemoglobina'])?$_REQUEST['pResultadoHemoglobina']:0;
    $pTomaGlicemia = isset($_REQUEST['pTomaGlicemia'])?$_REQUEST['pTomaGlicemia']:null;
    $pTomaCreatinina = isset($_REQUEST['pTomaCreatinina'])?$_REQUEST['pTomaCreatinina']:null;
    $pResultadoCreatinina = isset($_REQUEST['pResultadoCreatinina'])?$_REQUEST['pResultadoCreatinina']:0;
    $pTomaHemoglobinaGlicosilada = isset($_REQUEST['pTomaHemoglobinaGlicosilada'])?$_REQUEST['pTomaHemoglobinaGlicosilada']:null;
    $pResultadoHemoglobinaGlicosilada = isset($_REQUEST['pResultadoHemoglobinaGlicosilada'])?$_REQUEST['pResultadoHemoglobinaGlicosilada']:0;
    $pTomaMicroalbuminuria = isset($_REQUEST['pTomaMicroalbuminuria'])?$_REQUEST['pTomaMicroalbuminuria']:null;
    $pTomaHDL = isset($_REQUEST['pTomaHDL'])?$_REQUEST['pTomaHDL']:null;
    $pTomaBaciloscopiaDiagnostica = isset($_REQUEST['pTomaBaciloscopiaDiagnostica'])?$_REQUEST['pTomaBaciloscopiaDiagnostica']:null;
    $pResultadoBaciloscopiaDiagnostica = isset($_REQUEST['pResultadoBaciloscopiaDiagnostica'])?$_REQUEST['pResultadoBaciloscopiaDiagnostica']:0;
    $pTratamientoHipotiroidismoCongenito = isset($_REQUEST['pTratamientoHipotiroidismoCongenito'])?$_REQUEST['pTratamientoHipotiroidismoCongenito']:0;
    $pTratamientoSifilisGestacional = isset($_REQUEST['pTratamientoSifilisGestacional'])?$_REQUEST['pTratamientoSifilisGestacional']:0;
    $pTratamientoSifilisCongenita = isset($_REQUEST['pTratamientoSifilisCongenita'])?$_REQUEST['pTratamientoSifilisCongenita']:0;
    $pTratamientoLepra = isset($_REQUEST['pTratamientoLepra'])?$_REQUEST['pTratamientoLepra']:0;
    $pTerminacionTratamientoLeishmaniasis = isset($_REQUEST['pTerminacionTratamientoLeishmaniasis'])?$_REQUEST['pTerminacionTratamientoLeishmaniasis']:null;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_pacientes_4505_update('" . $pUsuario . "','" . $pId4505 . "','" . $pPaciente . "','" . $pCliente . "','" . $pConsecutivoRegistro . "','" . $pTipoDoc . "','" . $pDocumento . "','" . $pPrimerApellido . "','" . $pSegundoApellido . "','" . $pPrimerNombre . "','" . $pSegundoNombre . "',\"" . $pFechaNac . "\",'" . $pGenero . "','" . $pEtniaHC . "','" . $pOcupacionHC . "','" . $pEscolaridadHC . "','" . $pGestacion . "','" . $pSifilisGestacional . "','" . $pHipertencionGestacional . "','" . $pHipotiroidismoCongenito . "','" . $pSintomaticoRespiratorio . "','" . $pTuberculosisMultidrogoresistente . "','" . $pLepra . "','" . $pObesidadDesnutricion . "','" . $pVictimaMaltrato . "','" . $pViolenciaSexual . "','" . $pInfeccionesTrasmisionSexual . "','" . $pEnfermedadMental . "','" . $pCancerCervix . "','" . $pCancerSeno . "','" . $pFluorosisDental . "',\"" . $pFecPeso . "\",'" . $pPeso . "',\"" . $pFecTalla . "\",'" . $pTalla . "',\"" . $pProbableParto . "\",'" . $pEdadGestacionalNacer . "','" . $pBCG . "','" . $pHepatitisB . "','" . $pPentavalente . "','" . $pPolio . "','" . $pDPT . "','" . $pRotavirus . "','" . $pNeumococo . "','" . $pInfluenza . "','" . $pFiebreAmarilla . "','" . $pHepatitisA . "','" . $pTripleViral . "','" . $pVPH . "','" . $pTD . "','" . $pControlPlacaBacteriana . "',\"" . $pAtencionParto . "\",\"" . $pSalidaAtencionParto . "\",\"" . $pConcejeriaLactancia . "\",\"" . $pControlRecienNacido . "\",\"" . $pPlanificacionFamiliarPrimeraVez . "\",'" . $pSuministroMetodoPlanificacion . "',\"" . $pSuministroMetodo . "\",\"" . $pControlPrenatalPrimeraVez . "\",'" . $pControlPrenatal . "',\"" . $pUltimoControlPrenatal . "\",'" . $pSuministroAcidoFolico . "','" . $pSuministroSulfatoFerroso . "','" . $pSuministroCarbonatoCalcio . "',\"" . $pValoracionAgudezaVisual . "\",\"" . $pConsultaOfitalmologia . "\",\"" . $pFechaDxDesnutricion . "\",\"" . $pConsultaMujerVictimaMaltrato . "\",\"" . $pConsultaViolenciaSexual . "\",\"" . $pConsultaNutricion . "\",\"" . $pConsultaPsicologia . "\",\"" . $pConsultaCyDPrimeraVez . "\",'" . $pSuministroSulfatoFerroso1ano . "','" . $pSuministroVitaminaA . "',\"" . $pConsultaJovenPrimeraVez . "\",\"" . $pConsultaAdultoPrimeraVez . "\",'" . $pPreservativosEntregadosITS . "',\"" . $pAsesoriaPreTestVIH . "\",\"" . $pAsesoriaPosTestVIH . "\",'" . $pEnfMentalTratamientoUlt6Meses . "',\"" . $pAntigenoHepatitisB . "\",'" . $pResultadoAntigenoHepatitisB . "',\"" . $pSerologia . "\",'" . $pResultadoSerologia . "',\"" . $pTomaElisaVIH . "\",'" . $pResultadoElisaVIH . "',\"" . $pTSHNeonatal . "\",'" . $pResultadoTSHNeonatal . "','" . $pTamizajeCancerCuelloUterino . "',\"" . $pTomaCitologia . "\",'" . $pResultadoCitologia . "','" . $pCalidadMuestraCitologia . "','" . $pCodIPSTomaCitologia . "',\"" . $pTomaColposcopia . "\",'" . $pCodIPSTomaColposcopia . "',\"" . $pBiopsiaCervical . "\",'" . $pResultadoBiopsiaCervical . "','" . $pCodIPSTomaBiopsiaCervical . "',\"" . $pMamografia . "\",'" . $pResultadoMamografia . "','" . $pCodIPSTomaMamografia . "',\"" . $pTomaBiopsiaSenoBACAF . "\",\"" . $pFecResultadoBiopsiaSeno . "\",'" . $pResultadoBiopsiaSeno . "','" . $pCodIPSTomaBiopsiaSeno . "',\"" . $pTomaHemoglobina . "\",'" . $pResultadoHemoglobina . "',\"" . $pTomaGlicemia . "\",\"" . $pTomaCreatinina . "\",'" . $pResultadoCreatinina . "',\"" . $pTomaHemoglobinaGlicosilada . "\",'" . $pResultadoHemoglobinaGlicosilada . "',\"" . $pTomaMicroalbuminuria . "\",\"" . $pTomaHDL . "\",\"" . $pTomaBaciloscopiaDiagnostica . "\",'" . $pResultadoBaciloscopiaDiagnostica . "','" . $pTratamientoHipotiroidismoCongenito . "','" . $pTratamientoSifilisGestacional . "','" . $pTratamientoSifilisCongenita . "','" . $pTratamientoLepra . "',\"" . $pTerminacionTratamientoLeishmaniasis . "\")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}
      
function GuardarSeguimientoRegUnico(){
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pTipoDoc = isset($_REQUEST['pTipoDoc'])?$_REQUEST['pTipoDoc']:null;
    $pDocumento = isset($_REQUEST['pDocumento'])?$_REQUEST['pDocumento']:null;
    $pPrimerApellido = isset($_REQUEST['pPrimerApellido'])?$_REQUEST['pPrimerApellido']:null;
    $pSegundoApellido = isset($_REQUEST['pSegundoApellido'])?$_REQUEST['pSegundoApellido']:null;
    $pPrimerNombre = isset($_REQUEST['pPrimerNombre'])?$_REQUEST['pPrimerNombre']:null;
    $pSegundoNombre = isset($_REQUEST['pSegundoNombre'])?$_REQUEST['pSegundoNombre']:null;
    $pFechaNac = isset($_REQUEST['pFechaNac'])?$_REQUEST['pFechaNac']:null;
    $pGenero = isset($_REQUEST['pGenero'])?$_REQUEST['pGenero']:null;
    $pEtniaHC = isset($_REQUEST['pEtniaHC'])?$_REQUEST['pEtniaHC']:0;
    $pOcupacionHC = isset($_REQUEST['pOcupacionHC'])?$_REQUEST['pOcupacionHC']:0;
    $pEscolaridadHC = isset($_REQUEST['pEscolaridadHC'])?$_REQUEST['pEscolaridadHC']:0;
    $pGestacion = isset($_REQUEST['pGestacion'])?$_REQUEST['pGestacion']:0;
    $pSifilisGestacional = isset($_REQUEST['pSifilisGestacional'])?$_REQUEST['pSifilisGestacional']:0;
    $pHipertencionGestacional = isset($_REQUEST['pHipertencionGestacional'])?$_REQUEST['pHipertencionGestacional']:0;
    $pHipotiroidismoCongenito = isset($_REQUEST['pHipotiroidismoCongenito'])?$_REQUEST['pHipotiroidismoCongenito']:0;
    $pSintomaticoRespiratorio = isset($_REQUEST['pSintomaticoRespiratorio'])?$_REQUEST['pSintomaticoRespiratorio']:0;
    $pTuberculosisMultidrogoresistente = isset($_REQUEST['pTuberculosisMultidrogoresistente'])?$_REQUEST['pTuberculosisMultidrogoresistente']:0;
    $pLepra = isset($_REQUEST['pLepra'])?$_REQUEST['pLepra']:0;
    $pObesidadDesnutricion = isset($_REQUEST['pObesidadDesnutricion'])?$_REQUEST['pObesidadDesnutricion']:0;
    $pVictimaMaltrato = isset($_REQUEST['pVictimaMaltrato'])?$_REQUEST['pVictimaMaltrato']:0;
    $pViolenciaSexual = isset($_REQUEST['pViolenciaSexual'])?$_REQUEST['pViolenciaSexual']:0;
    $pInfeccionesTrasmisionSexual = isset($_REQUEST['pInfeccionesTrasmisionSexual'])?$_REQUEST['pInfeccionesTrasmisionSexual']:0;
    $pEnfermedadMental = isset($_REQUEST['pEnfermedadMental'])?$_REQUEST['pEnfermedadMental']:0;
    $pCancerCervix = isset($_REQUEST['pCancerCervix'])?$_REQUEST['pCancerCervix']:0;
    $pCancerSeno = isset($_REQUEST['pCancerSeno'])?$_REQUEST['pCancerSeno']:0;
    $pFluorosisDental = isset($_REQUEST['pFluorosisDental'])?$_REQUEST['pFluorosisDental']:0;
    $pFecPeso = isset($_REQUEST['pFecPeso'])?$_REQUEST['pFecPeso']:null;
    $pPeso = isset($_REQUEST['pPeso'])?$_REQUEST['pPeso']:0;
    $pFecTalla = isset($_REQUEST['pFecTalla'])?$_REQUEST['pFecTalla']:null;
    $pTalla = isset($_REQUEST['pTalla'])?$_REQUEST['pTalla']:0;
    $pProbableParto = isset($_REQUEST['pProbableParto'])?$_REQUEST['pProbableParto']:null;
    $pEdadGestacionalNacer = isset($_REQUEST['pEdadGestacionalNacer'])?$_REQUEST['pEdadGestacionalNacer']:0;
    $pBCG = isset($_REQUEST['pBCG'])?$_REQUEST['pBCG']:0;
    $pHepatitisB = isset($_REQUEST['pHepatitisB'])?$_REQUEST['pHepatitisB']:0;
    $pPentavalente = isset($_REQUEST['pPentavalente'])?$_REQUEST['pPentavalente']:0;
    $pPolio = isset($_REQUEST['pPolio'])?$_REQUEST['pPolio']:0;
    $pDPT = isset($_REQUEST['pDPT'])?$_REQUEST['pDPT']:0;
    $pRotavirus = isset($_REQUEST['pRotavirus'])?$_REQUEST['pRotavirus']:0;
    $pNeumococo = isset($_REQUEST['pNeumococo'])?$_REQUEST['pNeumococo']:0;
    $pInfluenza = isset($_REQUEST['pInfluenza'])?$_REQUEST['pInfluenza']:0;
    $pFiebreAmarilla = isset($_REQUEST['pFiebreAmarilla'])?$_REQUEST['pFiebreAmarilla']:0;
    $pHepatitisA = isset($_REQUEST['pHepatitisA'])?$_REQUEST['pHepatitisA']:0;
    $pTripleViral = isset($_REQUEST['pTripleViral'])?$_REQUEST['pTripleViral']:0;
    $pVPH = isset($_REQUEST['pVPH'])?$_REQUEST['pVPH']:0;
    $pTD = isset($_REQUEST['pTD'])?$_REQUEST['pTD']:0;
    $pControlPlacaBacteriana = isset($_REQUEST['pControlPlacaBacteriana'])?$_REQUEST['pControlPlacaBacteriana']:0;
    $pAtencionParto = isset($_REQUEST['pAtencionParto'])?$_REQUEST['pAtencionParto']:null;
    $pSalidaAtencionParto = isset($_REQUEST['pSalidaAtencionParto'])?$_REQUEST['pSalidaAtencionParto']:null;
    $pConcejeriaLactancia = isset($_REQUEST['pConcejeriaLactancia'])?$_REQUEST['pConcejeriaLactancia']:null;
    $pControlRecienNacido = isset($_REQUEST['pControlRecienNacido'])?$_REQUEST['pControlRecienNacido']:null;
    $pPlanificacionFamiliarPrimeraVez = isset($_REQUEST['pPlanificacionFamiliarPrimeraVez'])?$_REQUEST['pPlanificacionFamiliarPrimeraVez']:null;
    $pSuministroMetodoPlanificacion = isset($_REQUEST['pSuministroMetodoPlanificacion'])?$_REQUEST['pSuministroMetodoPlanificacion']:0;
    $pSuministroMetodo = isset($_REQUEST['pSuministroMetodo'])?$_REQUEST['pSuministroMetodo']:null;
    $pControlPrenatalPrimeraVez = isset($_REQUEST['pControlPrenatalPrimeraVez'])?$_REQUEST['pControlPrenatalPrimeraVez']:null;
    $pControlPrenatal = isset($_REQUEST['pControlPrenatal'])?$_REQUEST['pControlPrenatal']:0;
    $pUltimoControlPrenatal = isset($_REQUEST['pUltimoControlPrenatal'])?$_REQUEST['pUltimoControlPrenatal']:null;
    $pSuministroAcidoFolico = isset($_REQUEST['pSuministroAcidoFolico'])?$_REQUEST['pSuministroAcidoFolico']:0;
    $pSuministroSulfatoFerroso = isset($_REQUEST['pSuministroSulfatoFerroso'])?$_REQUEST['pSuministroSulfatoFerroso']:0;
    $pSuministroCarbonatoCalcio = isset($_REQUEST['pSuministroCarbonatoCalcio'])?$_REQUEST['pSuministroCarbonatoCalcio']:0;
    $pValoracionAgudezaVisual = isset($_REQUEST['pValoracionAgudezaVisual'])?$_REQUEST['pValoracionAgudezaVisual']:null;
    $pConsultaOfitalmologia = isset($_REQUEST['pConsultaOfitalmologia'])?$_REQUEST['pConsultaOfitalmologia']:null;
    $pFechaDxDesnutricion = isset($_REQUEST['pFechaDxDesnutricion'])?$_REQUEST['pFechaDxDesnutricion']:null;
    $pConsultaMujerVictimaMaltrato = isset($_REQUEST['pConsultaMujerVictimaMaltrato'])?$_REQUEST['pConsultaMujerVictimaMaltrato']:null;
    $pConsultaViolenciaSexual = isset($_REQUEST['pConsultaViolenciaSexual'])?$_REQUEST['pConsultaViolenciaSexual']:null;
    $pConsultaNutricion = isset($_REQUEST['pConsultaNutricion'])?$_REQUEST['pConsultaNutricion']:null;
    $pConsultaPsicologia = isset($_REQUEST['pConsultaPsicologia'])?$_REQUEST['pConsultaPsicologia']:null;
    $pConsultaCyDPrimeraVez = isset($_REQUEST['pConsultaCyDPrimeraVez'])?$_REQUEST['pConsultaCyDPrimeraVez']:null;
    $pSuministroSulfatoFerroso1ano = isset($_REQUEST['pSuministroSulfatoFerroso1ano'])?$_REQUEST['pSuministroSulfatoFerroso1ano']:0;
    $pSuministroVitaminaA = isset($_REQUEST['pSuministroVitaminaA'])?$_REQUEST['pSuministroVitaminaA']:0;
    $pConsultaJovenPrimeraVez = isset($_REQUEST['pConsultaJovenPrimeraVez'])?$_REQUEST['pConsultaJovenPrimeraVez']:null;
    $pConsultaAdultoPrimeraVez = isset($_REQUEST['pConsultaAdultoPrimeraVez'])?$_REQUEST['pConsultaAdultoPrimeraVez']:null;
    $pPreservativosEntregadosITS = isset($_REQUEST['pPreservativosEntregadosITS'])?$_REQUEST['pPreservativosEntregadosITS']:0;
    $pAsesoriaPreTestVIH = isset($_REQUEST['pAsesoriaPreTestVIH'])?$_REQUEST['pAsesoriaPreTestVIH']:null;
    $pAsesoriaPosTestVIH = isset($_REQUEST['pAsesoriaPosTestVIH'])?$_REQUEST['pAsesoriaPosTestVIH']:null;
    $pEnfMentalTratamientoUlt6Meses = isset($_REQUEST['pEnfMentalTratamientoUlt6Meses'])?$_REQUEST['pEnfMentalTratamientoUlt6Meses']:0;
    $pAntigenoHepatitisB = isset($_REQUEST['pAntigenoHepatitisB'])?$_REQUEST['pAntigenoHepatitisB']:null;
    $pResultadoAntigenoHepatitisB = isset($_REQUEST['pResultadoAntigenoHepatitisB'])?$_REQUEST['pResultadoAntigenoHepatitisB']:0;
    $pSerologia = isset($_REQUEST['pSerologia'])?$_REQUEST['pSerologia']:null;
    $pResultadoSerologia = isset($_REQUEST['pResultadoSerologia'])?$_REQUEST['pResultadoSerologia']:0;
    $pTomaElisaVIH = isset($_REQUEST['pTomaElisaVIH'])?$_REQUEST['pTomaElisaVIH']:null;
    $pResultadoElisaVIH = isset($_REQUEST['pResultadoElisaVIH'])?$_REQUEST['pResultadoElisaVIH']:0;
    $pTSHNeonatal = isset($_REQUEST['pTSHNeonatal'])?$_REQUEST['pTSHNeonatal']:null;
    $pResultadoTSHNeonatal = isset($_REQUEST['pResultadoTSHNeonatal'])?$_REQUEST['pResultadoTSHNeonatal']:0;
    $pTamizajeCancerCuelloUterino = isset($_REQUEST['pTamizajeCancerCuelloUterino'])?$_REQUEST['pTamizajeCancerCuelloUterino']:0;
    $pTomaCitologia = isset($_REQUEST['pTomaCitologia'])?$_REQUEST['pTomaCitologia']:null;
    $pResultadoCitologia = isset($_REQUEST['pResultadoCitologia'])?$_REQUEST['pResultadoCitologia']:0;
    $pCalidadMuestraCitologia = isset($_REQUEST['pCalidadMuestraCitologia'])?$_REQUEST['pCalidadMuestraCitologia']:0;
    $pCodIPSTomaCitologia = isset($_REQUEST['pCodIPSTomaCitologia'])?$_REQUEST['pCodIPSTomaCitologia']:0;
    $pTomaColposcopia = isset($_REQUEST['pTomaColposcopia'])?$_REQUEST['pTomaColposcopia']:null;
    $pCodIPSTomaColposcopia = isset($_REQUEST['pCodIPSTomaColposcopia'])?$_REQUEST['pCodIPSTomaColposcopia']:0;
    $pBiopsiaCervical = isset($_REQUEST['pBiopsiaCervical'])?$_REQUEST['pBiopsiaCervical']:null;
    $pResultadoBiopsiaCervical = isset($_REQUEST['pResultadoBiopsiaCervical'])?$_REQUEST['pResultadoBiopsiaCervical']:0;
    $pCodIPSTomaBiopsiaCervical = isset($_REQUEST['pCodIPSTomaBiopsiaCervical'])?$_REQUEST['pCodIPSTomaBiopsiaCervical']:0;
    $pMamografia = isset($_REQUEST['pMamografia'])?$_REQUEST['pMamografia']:null;
    $pResultadoMamografia = isset($_REQUEST['pResultadoMamografia'])?$_REQUEST['pResultadoMamografia']:0;
    $pCodIPSTomaMamografia = isset($_REQUEST['pCodIPSTomaMamografia'])?$_REQUEST['pCodIPSTomaMamografia']:0;
    $pTomaBiopsiaSenoBACAF = isset($_REQUEST['pTomaBiopsiaSenoBACAF'])?$_REQUEST['pTomaBiopsiaSenoBACAF']:null;
    $pFecResultadoBiopsiaSeno = isset($_REQUEST['pFecResultadoBiopsiaSeno'])?$_REQUEST['pResultadoBiopsiaSeno']:null;
    $pResultadoBiopsiaSeno = isset($_REQUEST['pResultadoBiopsiaSeno'])?$_REQUEST['pResultadoBiopsiaSeno']:0;
    $pCodIPSTomaBiopsiaSeno = isset($_REQUEST['pCodIPSTomaBiopsiaSeno'])?$_REQUEST['pCodIPSTomaBiopsiaSeno']:0;
    $pTomaHemoglobina = isset($_REQUEST['pTomaHemoglobina'])?$_REQUEST['pTomaHemoglobina']:null;
    $pResultadoHemoglobina = isset($_REQUEST['pResultadoHemoglobina'])?$_REQUEST['pResultadoHemoglobina']:0;
    $pTomaGlicemia = isset($_REQUEST['pTomaGlicemia'])?$_REQUEST['pTomaGlicemia']:null;
    $pTomaCreatinina = isset($_REQUEST['pTomaCreatinina'])?$_REQUEST['pTomaCreatinina']:null;
    $pResultadoCreatinina = isset($_REQUEST['pResultadoCreatinina'])?$_REQUEST['pResultadoCreatinina']:0;
    $pTomaHemoglobinaGlicosilada = isset($_REQUEST['pTomaHemoglobinaGlicosilada'])?$_REQUEST['pTomaHemoglobinaGlicosilada']:null;
    $pResultadoHemoglobinaGlicosilada = isset($_REQUEST['pResultadoHemoglobinaGlicosilada'])?$_REQUEST['pResultadoHemoglobinaGlicosilada']:0;
    $pTomaMicroalbuminuria = isset($_REQUEST['pTomaMicroalbuminuria'])?$_REQUEST['pTomaMicroalbuminuria']:null;
    $pTomaHDL = isset($_REQUEST['pTomaHDL'])?$_REQUEST['pTomaHDL']:null;
    $pTomaBaciloscopiaDiagnostica = isset($_REQUEST['pTomaBaciloscopiaDiagnostica'])?$_REQUEST['pTomaBaciloscopiaDiagnostica']:null;
    $pResultadoBaciloscopiaDiagnostica = isset($_REQUEST['pResultadoBaciloscopiaDiagnostica'])?$_REQUEST['pResultadoBaciloscopiaDiagnostica']:0;
    $pTratamientoHipotiroidismoCongenito = isset($_REQUEST['pTratamientoHipotiroidismoCongenito'])?$_REQUEST['pTratamientoHipotiroidismoCongenito']:0;
    $pTratamientoSifilisGestacional = isset($_REQUEST['pTratamientoSifilisGestacional'])?$_REQUEST['pTratamientoSifilisGestacional']:0;
    $pTratamientoSifilisCongenita = isset($_REQUEST['pTratamientoSifilisCongenita'])?$_REQUEST['pTratamientoSifilisCongenita']:0;
    $pTratamientoLepra = isset($_REQUEST['pTratamientoLepra'])?$_REQUEST['pTratamientoLepra']:0;
    $pTerminacionTratamientoLeishmaniasis = isset($_REQUEST['pTerminacionTratamientoLeishmaniasis'])?$_REQUEST['pTerminacionTratamientoLeishmaniasis']:null;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_pacientes_4505_add_regunico('" . $pUsuario . "','" . $pPaciente . "','" . $pTipoDoc . "','" . $pDocumento . "','" . $pPrimerApellido . "','" . $pSegundoApellido . "','" . $pPrimerNombre . "','" . $pSegundoNombre . "',\"" . $pFechaNac . "\",'" . $pGenero . "','" . $pEtniaHC . "','" . $pOcupacionHC . "','" . $pEscolaridadHC . "','" . $pGestacion . "','" . $pSifilisGestacional . "','" . $pHipertencionGestacional . "','" . $pHipotiroidismoCongenito . "','" . $pSintomaticoRespiratorio . "','" . $pTuberculosisMultidrogoresistente . "','" . $pLepra . "','" . $pObesidadDesnutricion . "','" . $pVictimaMaltrato . "','" . $pViolenciaSexual . "','" . $pInfeccionesTrasmisionSexual . "','" . $pEnfermedadMental . "','" . $pCancerCervix . "','" . $pCancerSeno . "','" . $pFluorosisDental . "',\"" . $pFecPeso . "\",'" . $pPeso . "',\"" . $pFecTalla . "\",'" . $pTalla . "',\"" . $pProbableParto . "\",'" . $pEdadGestacionalNacer . "','" . $pBCG . "','" . $pHepatitisB . "','" . $pPentavalente . "','" . $pPolio . "','" . $pDPT . "','" . $pRotavirus . "','" . $pNeumococo . "','" . $pInfluenza . "','" . $pFiebreAmarilla . "','" . $pHepatitisA . "','" . $pTripleViral . "','" . $pVPH . "','" . $pTD . "','" . $pControlPlacaBacteriana . "',\"" . $pAtencionParto . "\",\"" . $pSalidaAtencionParto . "\",\"" . $pConcejeriaLactancia . "\",\"" . $pControlRecienNacido . "\",\"" . $pPlanificacionFamiliarPrimeraVez . "\",'" . $pSuministroMetodoPlanificacion . "',\"" . $pSuministroMetodo . "\",\"" . $pControlPrenatalPrimeraVez . "\",'" . $pControlPrenatal . "',\"" . $pUltimoControlPrenatal . "\",'" . $pSuministroAcidoFolico . "','" . $pSuministroSulfatoFerroso . "','" . $pSuministroCarbonatoCalcio . "',\"" . $pValoracionAgudezaVisual . "\",\"" . $pConsultaOfitalmologia . "\",\"" . $pFechaDxDesnutricion . "\",\"" . $pConsultaMujerVictimaMaltrato . "\",\"" . $pConsultaViolenciaSexual . "\",\"" . $pConsultaNutricion . "\",\"" . $pConsultaPsicologia . "\",\"" . $pConsultaCyDPrimeraVez . "\",'" . $pSuministroSulfatoFerroso1ano . "','" . $pSuministroVitaminaA . "',\"" . $pConsultaJovenPrimeraVez . "\",\"" . $pConsultaAdultoPrimeraVez . "\",'" . $pPreservativosEntregadosITS . "',\"" . $pAsesoriaPreTestVIH . "\",\"" . $pAsesoriaPosTestVIH . "\",'" . $pEnfMentalTratamientoUlt6Meses . "',\"" . $pAntigenoHepatitisB . "\",'" . $pResultadoAntigenoHepatitisB . "',\"" . $pSerologia . "\",'" . $pResultadoSerologia . "',\"" . $pTomaElisaVIH . "\",'" . $pResultadoElisaVIH . "',\"" . $pTSHNeonatal . "\",'" . $pResultadoTSHNeonatal . "','" . $pTamizajeCancerCuelloUterino . "',\"" . $pTomaCitologia . "\",'" . $pResultadoCitologia . "','" . $pCalidadMuestraCitologia . "','" . $pCodIPSTomaCitologia . "',\"" . $pTomaColposcopia . "\",'" . $pCodIPSTomaColposcopia . "',\"" . $pBiopsiaCervical . "\",'" . $pResultadoBiopsiaCervical . "','" . $pCodIPSTomaBiopsiaCervical . "',\"" . $pMamografia . "\",'" . $pResultadoMamografia . "','" . $pCodIPSTomaMamografia . "',\"" . $pTomaBiopsiaSenoBACAF . "\",\"" . $pFecResultadoBiopsiaSeno . "\",'" . $pResultadoBiopsiaSeno . "','" . $pCodIPSTomaBiopsiaSeno . "',\"" . $pTomaHemoglobina . "\",'" . $pResultadoHemoglobina . "',\"" . $pTomaGlicemia . "\",\"" . $pTomaCreatinina . "\",'" . $pResultadoCreatinina . "',\"" . $pTomaHemoglobinaGlicosilada . "\",'" . $pResultadoHemoglobinaGlicosilada . "',\"" . $pTomaMicroalbuminuria . "\",\"" . $pTomaHDL . "\",\"" . $pTomaBaciloscopiaDiagnostica . "\",'" . $pResultadoBaciloscopiaDiagnostica . "','" . $pTratamientoHipotiroidismoCongenito . "','" . $pTratamientoSifilisGestacional . "','" . $pTratamientoSifilisCongenita . "','" . $pTratamientoLepra . "',\"" . $pTerminacionTratamientoLeishmaniasis . "\")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}
        
function GuardarSeguimiento(){
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pId4505 = isset($_REQUEST['pId4505'])?$_REQUEST['pId4505']:0;
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pCliente = isset($_REQUEST['pCliente'])?$_REQUEST['pCliente']:0;
    $pTipoDoc = isset($_REQUEST['pTipoDoc'])?$_REQUEST['pTipoDoc']:null;
    $pDocumento = isset($_REQUEST['pDocumento'])?$_REQUEST['pDocumento']:null;
    $pPrimerApellido = isset($_REQUEST['pPrimerApellido'])?$_REQUEST['pPrimerApellido']:null;
    $pSegundoApellido = isset($_REQUEST['pSegundoApellido'])?$_REQUEST['pSegundoApellido']:null;
    $pPrimerNombre = isset($_REQUEST['pPrimerNombre'])?$_REQUEST['pPrimerNombre']:null;
    $pSegundoNombre = isset($_REQUEST['pSegundoNombre'])?$_REQUEST['pSegundoNombre']:null;
    $pFechaNac = isset($_REQUEST['pFechaNac'])?$_REQUEST['pFechaNac']:null;
    $pGenero = isset($_REQUEST['pGenero'])?$_REQUEST['pGenero']:null;
    $pEtniaHC = isset($_REQUEST['pEtniaHC'])?$_REQUEST['pEtniaHC']:0;
    $pOcupacionHC = isset($_REQUEST['pOcupacionHC'])?$_REQUEST['pOcupacionHC']:0;
    $pEscolaridadHC = isset($_REQUEST['pEscolaridadHC'])?$_REQUEST['pEscolaridadHC']:0;
    $pGestacion = isset($_REQUEST['pGestacion'])?$_REQUEST['pGestacion']:0;
    $pSifilisGestacional = isset($_REQUEST['pSifilisGestacional'])?$_REQUEST['pSifilisGestacional']:0;
    $pHipertencionGestacional = isset($_REQUEST['pHipertencionGestacional'])?$_REQUEST['pHipertencionGestacional']:0;
    $pHipotiroidismoCongenito = isset($_REQUEST['pHipotiroidismoCongenito'])?$_REQUEST['pHipotiroidismoCongenito']:0;
    $pSintomaticoRespiratorio = isset($_REQUEST['pSintomaticoRespiratorio'])?$_REQUEST['pSintomaticoRespiratorio']:0;
    $pTuberculosisMultidrogoresistente = isset($_REQUEST['pTuberculosisMultidrogoresistente'])?$_REQUEST['pTuberculosisMultidrogoresistente']:0;
    $pLepra = isset($_REQUEST['pLepra'])?$_REQUEST['pLepra']:0;
    $pObesidadDesnutricion = isset($_REQUEST['pObesidadDesnutricion'])?$_REQUEST['pObesidadDesnutricion']:0;
    $pVictimaMaltrato = isset($_REQUEST['pVictimaMaltrato'])?$_REQUEST['pVictimaMaltrato']:0;
    $pViolenciaSexual = isset($_REQUEST['pViolenciaSexual'])?$_REQUEST['pViolenciaSexual']:0;
    $pInfeccionesTrasmisionSexual = isset($_REQUEST['pInfeccionesTrasmisionSexual'])?$_REQUEST['pInfeccionesTrasmisionSexual']:0;
    $pEnfermedadMental = isset($_REQUEST['pEnfermedadMental'])?$_REQUEST['pEnfermedadMental']:0;
    $pCancerCervix = isset($_REQUEST['pCancerCervix'])?$_REQUEST['pCancerCervix']:0;
    $pCancerSeno = isset($_REQUEST['pCancerSeno'])?$_REQUEST['pCancerSeno']:0;
    $pFluorosisDental = isset($_REQUEST['pFluorosisDental'])?$_REQUEST['pFluorosisDental']:0;
    $pFecPeso = isset($_REQUEST['pFecPeso'])?$_REQUEST['pFecPeso']:null;
    $pPeso = isset($_REQUEST['pPeso'])?$_REQUEST['pPeso']:0;
    $pFecTalla = isset($_REQUEST['pFecTalla'])?$_REQUEST['pFecTalla']:null;
    $pTalla = isset($_REQUEST['pTalla'])?$_REQUEST['pTalla']:0;
    $pProbableParto = isset($_REQUEST['pProbableParto'])?$_REQUEST['pProbableParto']:null;
    $pEdadGestacionalNacer = isset($_REQUEST['pEdadGestacionalNacer'])?$_REQUEST['pEdadGestacionalNacer']:0;
    $pBCG = isset($_REQUEST['pBCG'])?$_REQUEST['pBCG']:0;
    $pHepatitisB = isset($_REQUEST['pHepatitisB'])?$_REQUEST['pHepatitisB']:0;
    $pPentavalente = isset($_REQUEST['pPentavalente'])?$_REQUEST['pPentavalente']:0;
    $pPolio = isset($_REQUEST['pPolio'])?$_REQUEST['pPolio']:0;
    $pDPT = isset($_REQUEST['pDPT'])?$_REQUEST['pDPT']:0;
    $pRotavirus = isset($_REQUEST['pRotavirus'])?$_REQUEST['pRotavirus']:0;
    $pNeumococo = isset($_REQUEST['pNeumococo'])?$_REQUEST['pNeumococo']:0;
    $pInfluenza = isset($_REQUEST['pInfluenza'])?$_REQUEST['pInfluenza']:0;
    $pFiebreAmarilla = isset($_REQUEST['pFiebreAmarilla'])?$_REQUEST['pFiebreAmarilla']:0;
    $pHepatitisA = isset($_REQUEST['pHepatitisA'])?$_REQUEST['pHepatitisA']:0;
    $pTripleViral = isset($_REQUEST['pTripleViral'])?$_REQUEST['pTripleViral']:0;
    $pVPH = isset($_REQUEST['pVPH'])?$_REQUEST['pVPH']:0;
    $pTD = isset($_REQUEST['pTD'])?$_REQUEST['pTD']:0;
    $pControlPlacaBacteriana = isset($_REQUEST['pControlPlacaBacteriana'])?$_REQUEST['pControlPlacaBacteriana']:0;
    $pAtencionParto = isset($_REQUEST['pAtencionParto'])?$_REQUEST['pAtencionParto']:null;
    $pSalidaAtencionParto = isset($_REQUEST['pSalidaAtencionParto'])?$_REQUEST['pSalidaAtencionParto']:null;
    $pConcejeriaLactancia = isset($_REQUEST['pConcejeriaLactancia'])?$_REQUEST['pConcejeriaLactancia']:null;
    $pControlRecienNacido = isset($_REQUEST['pControlRecienNacido'])?$_REQUEST['pControlRecienNacido']:null;
    $pPlanificacionFamiliarPrimeraVez = isset($_REQUEST['pPlanificacionFamiliarPrimeraVez'])?$_REQUEST['pPlanificacionFamiliarPrimeraVez']:null;
    $pSuministroMetodoPlanificacion = isset($_REQUEST['pSuministroMetodoPlanificacion'])?$_REQUEST['pSuministroMetodoPlanificacion']:0;
    $pSuministroMetodo = isset($_REQUEST['pSuministroMetodo'])?$_REQUEST['pSuministroMetodo']:null;
    $pControlPrenatalPrimeraVez = isset($_REQUEST['pControlPrenatalPrimeraVez'])?$_REQUEST['pControlPrenatalPrimeraVez']:null;
    $pControlPrenatal = isset($_REQUEST['pControlPrenatal'])?$_REQUEST['pControlPrenatal']:0;
    $pUltimoControlPrenatal = isset($_REQUEST['pUltimoControlPrenatal'])?$_REQUEST['pUltimoControlPrenatal']:null;
    $pSuministroAcidoFolico = isset($_REQUEST['pSuministroAcidoFolico'])?$_REQUEST['pSuministroAcidoFolico']:0;
    $pSuministroSulfatoFerroso = isset($_REQUEST['pSuministroSulfatoFerroso'])?$_REQUEST['pSuministroSulfatoFerroso']:0;
    $pSuministroCarbonatoCalcio = isset($_REQUEST['pSuministroCarbonatoCalcio'])?$_REQUEST['pSuministroCarbonatoCalcio']:0;
    $pValoracionAgudezaVisual = isset($_REQUEST['pValoracionAgudezaVisual'])?$_REQUEST['pValoracionAgudezaVisual']:null;
    $pConsultaOfitalmologia = isset($_REQUEST['pConsultaOfitalmologia'])?$_REQUEST['pConsultaOfitalmologia']:null;
    $pFechaDxDesnutricion = isset($_REQUEST['pFechaDxDesnutricion'])?$_REQUEST['pFechaDxDesnutricion']:null;
    $pConsultaMujerVictimaMaltrato = isset($_REQUEST['pConsultaMujerVictimaMaltrato'])?$_REQUEST['pConsultaMujerVictimaMaltrato']:null;
    $pConsultaViolenciaSexual = isset($_REQUEST['pConsultaViolenciaSexual'])?$_REQUEST['pConsultaViolenciaSexual']:null;
    $pConsultaNutricion = isset($_REQUEST['pConsultaNutricion'])?$_REQUEST['pConsultaNutricion']:null;
    $pConsultaPsicologia = isset($_REQUEST['pConsultaPsicologia'])?$_REQUEST['pConsultaPsicologia']:null;
    $pConsultaCyDPrimeraVez = isset($_REQUEST['pConsultaCyDPrimeraVez'])?$_REQUEST['pConsultaCyDPrimeraVez']:null;
    $pSuministroSulfatoFerroso1ano = isset($_REQUEST['pSuministroSulfatoFerroso1ano'])?$_REQUEST['pSuministroSulfatoFerroso1ano']:0;
    $pSuministroVitaminaA = isset($_REQUEST['pSuministroVitaminaA'])?$_REQUEST['pSuministroVitaminaA']:0;
    $pConsultaJovenPrimeraVez = isset($_REQUEST['pConsultaJovenPrimeraVez'])?$_REQUEST['pConsultaJovenPrimeraVez']:null;
    $pConsultaAdultoPrimeraVez = isset($_REQUEST['pConsultaAdultoPrimeraVez'])?$_REQUEST['pConsultaAdultoPrimeraVez']:null;
    $pPreservativosEntregadosITS = isset($_REQUEST['pPreservativosEntregadosITS'])?$_REQUEST['pPreservativosEntregadosITS']:0;
    $pAsesoriaPreTestVIH = isset($_REQUEST['pAsesoriaPreTestVIH'])?$_REQUEST['pAsesoriaPreTestVIH']:null;
    $pAsesoriaPosTestVIH = isset($_REQUEST['pAsesoriaPosTestVIH'])?$_REQUEST['pAsesoriaPosTestVIH']:null;
    $pEnfMentalTratamientoUlt6Meses = isset($_REQUEST['pEnfMentalTratamientoUlt6Meses'])?$_REQUEST['pEnfMentalTratamientoUlt6Meses']:0;
    $pAntigenoHepatitisB = isset($_REQUEST['pAntigenoHepatitisB'])?$_REQUEST['pAntigenoHepatitisB']:null;
    $pResultadoAntigenoHepatitisB = isset($_REQUEST['pResultadoAntigenoHepatitisB'])?$_REQUEST['pResultadoAntigenoHepatitisB']:0;
    $pSerologia = isset($_REQUEST['pSerologia'])?$_REQUEST['pSerologia']:null;
    $pResultadoSerologia = isset($_REQUEST['pResultadoSerologia'])?$_REQUEST['pResultadoSerologia']:0;
    $pTomaElisaVIH = isset($_REQUEST['pTomaElisaVIH'])?$_REQUEST['pTomaElisaVIH']:null;
    $pResultadoElisaVIH = isset($_REQUEST['pResultadoElisaVIH'])?$_REQUEST['pResultadoElisaVIH']:0;
    $pTSHNeonatal = isset($_REQUEST['pTSHNeonatal'])?$_REQUEST['pTSHNeonatal']:null;
    $pResultadoTSHNeonatal = isset($_REQUEST['pResultadoTSHNeonatal'])?$_REQUEST['pResultadoTSHNeonatal']:0;
    $pTamizajeCancerCuelloUterino = isset($_REQUEST['pTamizajeCancerCuelloUterino'])?$_REQUEST['pTamizajeCancerCuelloUterino']:0;
    $pTomaCitologia = isset($_REQUEST['pTomaCitologia'])?$_REQUEST['pTomaCitologia']:null;
    $pResultadoCitologia = isset($_REQUEST['pResultadoCitologia'])?$_REQUEST['pResultadoCitologia']:0;
    $pCalidadMuestraCitologia = isset($_REQUEST['pCalidadMuestraCitologia'])?$_REQUEST['pCalidadMuestraCitologia']:0;
    $pCodIPSTomaCitologia = isset($_REQUEST['pCodIPSTomaCitologia'])?$_REQUEST['pCodIPSTomaCitologia']:0;
    $pTomaColposcopia = isset($_REQUEST['pTomaColposcopia'])?$_REQUEST['pTomaColposcopia']:null;
    $pCodIPSTomaColposcopia = isset($_REQUEST['pCodIPSTomaColposcopia'])?$_REQUEST['pCodIPSTomaColposcopia']:0;
    $pBiopsiaCervical = isset($_REQUEST['pBiopsiaCervical'])?$_REQUEST['pBiopsiaCervical']:null;
    $pResultadoBiopsiaCervical = isset($_REQUEST['pResultadoBiopsiaCervical'])?$_REQUEST['pResultadoBiopsiaCervical']:0;
    $pCodIPSTomaBiopsiaCervical = isset($_REQUEST['pCodIPSTomaBiopsiaCervical'])?$_REQUEST['pCodIPSTomaBiopsiaCervical']:0;
    $pMamografia = isset($_REQUEST['pMamografia'])?$_REQUEST['pMamografia']:null;
    $pResultadoMamografia = isset($_REQUEST['pResultadoMamografia'])?$_REQUEST['pResultadoMamografia']:0;
    $pCodIPSTomaMamografia = isset($_REQUEST['pCodIPSTomaMamografia'])?$_REQUEST['pCodIPSTomaMamografia']:0;
    $pTomaBiopsiaSenoBACAF = isset($_REQUEST['pTomaBiopsiaSenoBACAF'])?$_REQUEST['pTomaBiopsiaSenoBACAF']:null;
    $pFecResultadoBiopsiaSeno = isset($_REQUEST['pFecResultadoBiopsiaSeno'])?$_REQUEST['pResultadoBiopsiaSeno']:null;
    $pResultadoBiopsiaSeno = isset($_REQUEST['pResultadoBiopsiaSeno'])?$_REQUEST['pResultadoBiopsiaSeno']:0;
    $pCodIPSTomaBiopsiaSeno = isset($_REQUEST['pCodIPSTomaBiopsiaSeno'])?$_REQUEST['pCodIPSTomaBiopsiaSeno']:0;
    $pTomaHemoglobina = isset($_REQUEST['pTomaHemoglobina'])?$_REQUEST['pTomaHemoglobina']:null;
    $pResultadoHemoglobina = isset($_REQUEST['pResultadoHemoglobina'])?$_REQUEST['pResultadoHemoglobina']:0;
    $pTomaGlicemia = isset($_REQUEST['pTomaGlicemia'])?$_REQUEST['pTomaGlicemia']:null;
    $pTomaCreatinina = isset($_REQUEST['pTomaCreatinina'])?$_REQUEST['pTomaCreatinina']:null;
    $pResultadoCreatinina = isset($_REQUEST['pResultadoCreatinina'])?$_REQUEST['pResultadoCreatinina']:0;
    $pTomaHemoglobinaGlicosilada = isset($_REQUEST['pTomaHemoglobinaGlicosilada'])?$_REQUEST['pTomaHemoglobinaGlicosilada']:null;
    $pResultadoHemoglobinaGlicosilada = isset($_REQUEST['pResultadoHemoglobinaGlicosilada'])?$_REQUEST['pResultadoHemoglobinaGlicosilada']:0;
    $pTomaMicroalbuminuria = isset($_REQUEST['pTomaMicroalbuminuria'])?$_REQUEST['pTomaMicroalbuminuria']:null;
    $pTomaHDL = isset($_REQUEST['pTomaHDL'])?$_REQUEST['pTomaHDL']:null;
    $pTomaBaciloscopiaDiagnostica = isset($_REQUEST['pTomaBaciloscopiaDiagnostica'])?$_REQUEST['pTomaBaciloscopiaDiagnostica']:null;
    $pResultadoBaciloscopiaDiagnostica = isset($_REQUEST['pResultadoBaciloscopiaDiagnostica'])?$_REQUEST['pResultadoBaciloscopiaDiagnostica']:0;
    $pTratamientoHipotiroidismoCongenito = isset($_REQUEST['pTratamientoHipotiroidismoCongenito'])?$_REQUEST['pTratamientoHipotiroidismoCongenito']:0;
    $pTratamientoSifilisGestacional = isset($_REQUEST['pTratamientoSifilisGestacional'])?$_REQUEST['pTratamientoSifilisGestacional']:0;
    $pTratamientoSifilisCongenita = isset($_REQUEST['pTratamientoSifilisCongenita'])?$_REQUEST['pTratamientoSifilisCongenita']:0;
    $pTratamientoLepra = isset($_REQUEST['pTratamientoLepra'])?$_REQUEST['pTratamientoLepra']:0;
    $pTerminacionTratamientoLeishmaniasis = isset($_REQUEST['pTerminacionTratamientoLeishmaniasis'])?$_REQUEST['pTerminacionTratamientoLeishmaniasis']:null;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_pacientes_4505_add('" . $pIPS . "','" . $pId4505 . "','" . $pUsuario . "','" . $pPaciente . "','" . $pCliente . "','" . $pTipoDoc . "','" . $pDocumento . "','" . $pPrimerApellido . "','" . $pSegundoApellido . "','" . $pPrimerNombre . "','" . $pSegundoNombre . "',\"" . $pFechaNac . "\",'" . $pGenero . "','" . $pEtniaHC . "','" . $pOcupacionHC . "','" . $pEscolaridadHC . "','" . $pGestacion . "','" . $pSifilisGestacional . "','" . $pHipertencionGestacional . "','" . $pHipotiroidismoCongenito . "','" . $pSintomaticoRespiratorio . "','" . $pTuberculosisMultidrogoresistente . "','" . $pLepra . "','" . $pObesidadDesnutricion . "','" . $pVictimaMaltrato . "','" . $pViolenciaSexual . "','" . $pInfeccionesTrasmisionSexual . "','" . $pEnfermedadMental . "','" . $pCancerCervix . "','" . $pCancerSeno . "','" . $pFluorosisDental . "',\"" . $pFecPeso . "\",'" . $pPeso . "',\"" . $pFecTalla . "\",'" . $pTalla . "',\"" . $pProbableParto . "\",'" . $pEdadGestacionalNacer . "','" . $pBCG . "','" . $pHepatitisB . "','" . $pPentavalente . "','" . $pPolio . "','" . $pDPT . "','" . $pRotavirus . "','" . $pNeumococo . "','" . $pInfluenza . "','" . $pFiebreAmarilla . "','" . $pHepatitisA . "','" . $pTripleViral . "','" . $pVPH . "','" . $pTD . "','" . $pControlPlacaBacteriana . "',\"" . $pAtencionParto . "\",\"" . $pSalidaAtencionParto . "\",\"" . $pConcejeriaLactancia . "\",\"" . $pControlRecienNacido . "\",\"" . $pPlanificacionFamiliarPrimeraVez . "\",'" . $pSuministroMetodoPlanificacion . "',\"" . $pSuministroMetodo . "\",\"" . $pControlPrenatalPrimeraVez . "\",'" . $pControlPrenatal . "',\"" . $pUltimoControlPrenatal . "\",'" . $pSuministroAcidoFolico . "','" . $pSuministroSulfatoFerroso . "','" . $pSuministroCarbonatoCalcio . "',\"" . $pValoracionAgudezaVisual . "\",\"" . $pConsultaOfitalmologia . "\",\"" . $pFechaDxDesnutricion . "\",\"" . $pConsultaMujerVictimaMaltrato . "\",\"" . $pConsultaViolenciaSexual . "\",\"" . $pConsultaNutricion . "\",\"" . $pConsultaPsicologia . "\",\"" . $pConsultaCyDPrimeraVez . "\",'" . $pSuministroSulfatoFerroso1ano . "','" . $pSuministroVitaminaA . "',\"" . $pConsultaJovenPrimeraVez . "\",\"" . $pConsultaAdultoPrimeraVez . "\",'" . $pPreservativosEntregadosITS . "',\"" . $pAsesoriaPreTestVIH . "\",\"" . $pAsesoriaPosTestVIH . "\",'" . $pEnfMentalTratamientoUlt6Meses . "',\"" . $pAntigenoHepatitisB . "\",'" . $pResultadoAntigenoHepatitisB . "',\"" . $pSerologia . "\",'" . $pResultadoSerologia . "',\"" . $pTomaElisaVIH . "\",'" . $pResultadoElisaVIH . "',\"" . $pTSHNeonatal . "\",'" . $pResultadoTSHNeonatal . "','" . $pTamizajeCancerCuelloUterino . "',\"" . $pTomaCitologia . "\",'" . $pResultadoCitologia . "','" . $pCalidadMuestraCitologia . "','" . $pCodIPSTomaCitologia . "',\"" . $pTomaColposcopia . "\",'" . $pCodIPSTomaColposcopia . "',\"" . $pBiopsiaCervical . "\",'" . $pResultadoBiopsiaCervical . "','" . $pCodIPSTomaBiopsiaCervical . "',\"" . $pMamografia . "\",'" . $pResultadoMamografia . "','" . $pCodIPSTomaMamografia . "',\"" . $pTomaBiopsiaSenoBACAF . "\",\"" . $pFecResultadoBiopsiaSeno . "\",'" . $pResultadoBiopsiaSeno . "','" . $pCodIPSTomaBiopsiaSeno . "',\"" . $pTomaHemoglobina . "\",'" . $pResultadoHemoglobina . "',\"" . $pTomaGlicemia . "\",\"" . $pTomaCreatinina . "\",'" . $pResultadoCreatinina . "',\"" . $pTomaHemoglobinaGlicosilada . "\",'" . $pResultadoHemoglobinaGlicosilada . "',\"" . $pTomaMicroalbuminuria . "\",\"" . $pTomaHDL . "\",\"" . $pTomaBaciloscopiaDiagnostica . "\",'" . $pResultadoBaciloscopiaDiagnostica . "','" . $pTratamientoHipotiroidismoCongenito . "','" . $pTratamientoSifilisGestacional . "','" . $pTratamientoSifilisCongenita . "','" . $pTratamientoLepra . "',\"" . $pTerminacionTratamientoLeishmaniasis . "\")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}
     
function GuardarSeguimiento002(){
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pId4505 = isset($_REQUEST['pId4505'])?$_REQUEST['pId4505']:0;
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pCliente = isset($_REQUEST['pCliente'])?$_REQUEST['pCliente']:0;
    $pTipoDoc = isset($_REQUEST['pTipoDoc'])?$_REQUEST['pTipoDoc']:null;
    $pDocumento = isset($_REQUEST['pDocumento'])?$_REQUEST['pDocumento']:null;
    $pPrimerApellido = isset($_REQUEST['pPrimerApellido'])?$_REQUEST['pPrimerApellido']:null;
    $pSegundoApellido = isset($_REQUEST['pSegundoApellido'])?$_REQUEST['pSegundoApellido']:null;
    $pPrimerNombre = isset($_REQUEST['pPrimerNombre'])?$_REQUEST['pPrimerNombre']:null;
    $pSegundoNombre = isset($_REQUEST['pSegundoNombre'])?$_REQUEST['pSegundoNombre']:null;
    $pFechaNac = isset($_REQUEST['pFechaNac'])?$_REQUEST['pFechaNac']:null;
    $pHasta = isset($_REQUEST['pHasta'])?$_REQUEST['pHasta']:null;
    $pGenero = isset($_REQUEST['pGenero'])?$_REQUEST['pGenero']:null;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_pacientes_4505_add002('" . $pIPS . "','" . $pId4505 . "','" . $pUsuario . "','" . $pPaciente . "','" . $pCliente . "','" . $pTipoDoc . "','" . $pDocumento . "','" . $pPrimerApellido . "','" . $pSegundoApellido . "','" . $pPrimerNombre . "','" . $pSegundoNombre . "',\"" . $pFechaNac . "\",'" . $pGenero . "',\"" . $pHasta . "\")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function GuardarPeriodo(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pCliente = isset($_REQUEST['pCliente'])?$_REQUEST['pCliente']:0;
    $pPeriodoAnio = isset($_REQUEST['pPeriodoAnio'])?$_REQUEST['pPeriodoAnio']:0;
    $pPeriodoMes = isset($_REQUEST['pPeriodoMes'])?$_REQUEST['pPeriodoMes']:0;
    $pPeriodoDesde = isset($_REQUEST['pPeriodoDesde'])?$_REQUEST['pPeriodoDesde']:0;
    $pPeriodoHasta = isset($_REQUEST['pPeriodoHasta'])?$_REQUEST['pPeriodoHasta']:0;
    $CodInsercion = "PRS-" .  $_SESSION['ID_EMPRESA'] . "-SED-" . $_SESSION['ID_SEDE'] .  "-IPS-" . $_SESSION['ID_IPS'] . "-USR-" . $_SESSION['ID_USUARIO'] . "-CONS-" . mt_rand(0,100000) . "-" . date("His");
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_4505_periodo_add(\"" . $CodInsercion . "\",'" . $pEmpresa . "','" . $pIPS . "','" . $pCliente . "','" . $pPeriodoAnio . "',\"" . $pPeriodoMes . "\",\"" . $pPeriodoDesde . "\",\"" . $pPeriodoHasta . "\")";
    //echo $qry;
    $CampoLlave = explode("^",$gBaseDatos->jasonSP_arreglo2011($qry));
    $gBaseDatos->cerrar();
    $respuesta = $CampoLlave[0];
    if($respuesta > 0){
        //pId4505 bigint, pCliente int, pHasta date, pUsuario int
        $qry = "CALL sp_4505_periodo_add_000('" . $respuesta . "','" . $pIPS . "','" . $pCliente . "',\"" . $pPeriodoAnio . "-" . $pPeriodoMes . "-" . $pPeriodoHasta . "\",'" . $_SESSION['ID_USUARIO'] . "')";
        //echo $qry;
        $gBaseDatos = new ofiMySQLi();
        $gBaseDatos->conectar();
        if(@mysqli_query($gBaseDatos->ConexionID, $qry))
            echo "{success: true, requestedId:'1'}";
        else
           echo "{success: true, requestedId:'0'}";
        $gBaseDatos->cerrar();
    }else{
        echo "{success: true, requestedId:'" . $respuesta . "'}";
    }
}

function CerrarPeriodo(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pCliente = isset($_REQUEST['pCliente'])?$_REQUEST['pCliente']:0;
    $pId4505 = isset($_REQUEST['pId4505'])?$_REQUEST['pId4505']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_periodo_4505_close('" . $pEmpresa . "','" . $pIPS . "','" . $pCliente . "','" . $pId4505 . "')";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}
?>
