<?php

/*
* @category    Controlador Pacientes Kardex
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

require("../../../core/php/_database.php");
require("../../../core/php/php_functions.php");

$task = '';
if ( isset($_POST['task'])){
  $task = $_POST['task'];
}
switch($task){
    case "LISTAR":
        Listar();
        break;
    case "LISTAR_ALERTAS":
        Listar_Alertas();
        break;
    case "CREAR_REGISTRO":
        CrearRegistro();
        break;
    case "CREAR_ALERTA":
        CrearAlerta();
        break;
    case "RETIRO_PROGRAMA":
        RetiroPrograma();
        break;
    case "ELIMINAR_ALERTA":
        EliminarAlerta();
        break;
    default:
        echo "{failure:true}";
        break;
}

function Listar(){
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_pacientes_kardex_listar('" . $pIPS . "','" . $pPaciente . "')";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = PonerAcentosHTML($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}

function Listar_Alertas(){
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_pacientes_alertas_listar('" . $pIPS . "','" . $pPaciente . "')";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = PonerAcentosHTML($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}

        
function CrearRegistro(){
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pPrograma = isset($_REQUEST['pPrograma'])?$_REQUEST['pPrograma']:0;
    $pViaIngreso = isset($_REQUEST['pViaIngreso'])?$_REQUEST['pViaIngreso']:null;
    $pObservaciones = isset($_REQUEST['pObservaciones'])?$_REQUEST['pObservaciones']:null;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_pacientes_kardex_add('" . $pIPS . "','" . $pPaciente . "','" . $pPrograma . "','" . $pViaIngreso . "','" . $pObservaciones . "','" . $pUsuario . "')";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}
        
function CrearAlerta(){
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pTipoAlerta = isset($_REQUEST['pTipoAlerta'])?$_REQUEST['pTipoAlerta']:null;
    $pAlerta = isset($_REQUEST['pAlerta'])?$_REQUEST['pAlerta']:null;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_pacientes_alertas_add('" . $pPaciente . "','" . $pTipoAlerta . "','" . $pAlerta . "','" . $pUsuario . "')";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}
        
        
function RetiroPrograma(){
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $pIdKardex = isset($_REQUEST['pIdKardex'])?$_REQUEST['pIdKardex']:0;
    $pMotivoRetiro = isset($_REQUEST['pMotivoRetiro'])?$_REQUEST['pMotivoRetiro']:null;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_pacientes_kardex_retiro('" . $pIdKardex . "','" . $pMotivoRetiro . "','" . $pUsuario . "')";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function EliminarAlerta(){
    $pIdAlerta = isset($_REQUEST['pIdAlerta'])?$_REQUEST['pIdAlerta']:null;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_pacientes_alertas_del('" . $pIdAlerta . "')";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo '1';
    else
        echo '0';
    $gBaseDatos->cerrar();
}

?>
