<?php
    session_start();
    require_once('../../../lib/tcpdf/config/lang/spa.php');
    require_once('../../../lib/tcpdf/tcpdf.php');
    require("../../../core/php/_database.php");
    require("../../../core/php/php_functions.php");
    header('Content-type: application/pdf; charset: UTF-8');
    
    $pPrestador = isset($_REQUEST['pPrestador'])?$_REQUEST['pPrestador']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $pFecha = isset($_REQUEST['pFecha'])?$_REQUEST['pFecha']:null;
    $pEstado = isset($_REQUEST['pEstado'])?$_REQUEST['pEstado']:'x';
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_profesionales_agendamanual_list('" . $pPrestador . "','"  . $pIPS . "','" . $pProfesional . "',\"" . $pFecha . "\",\"" . $pEstado . "\")";
    
    // create new PDF document
    $pdf = new TCPDF("L", PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
    $pdf->SetCreator(PDF_CREATOR);
    $pdf->SetAuthor('Sistemas Ofisalud © - 2011');
    $pdf->SetTitle('Agendas por Profesional');
    $pdf->SetSubject('Agendas');

    $pdf->pAlineacionEncabezado = "L";
    $pdf->pTituloInforme = "AGENDA POR PROFESIONAL";
    $pdf->pImprimeLogo = "NO";
    $pdf->pAnchoTxtPagina = 270;
    $pdf->pNomEmpresa = $_SESSION['NOM_EMPRESA'];
    $pdf->pNomSede = $_SESSION['NOM_SEDE'];
    $pdf->pNomIPS = $_SESSION['NOM_IPS'];
    $pdf->pMargenPie = -20;
    if($_SESSION['IdAplicacion'] == "OfiClinic"){
        $pdf->pLogoCliente = "../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/logoenc.gif";
    }else{
        $pdf->pLogoCliente = "../../../consultoriovirtual/" . $_SESSION['IDBD'] . "/logo/logoenc.gif";
    }
    $pdf->SetHeaderData($pdf->pLogoCliente, PDF_HEADER_LOGO_WIDTH, $pdf->pTituloInforme, PDF_HEADER_STRING);
    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
    $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
    $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
    $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
    $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
    $pdf->setLanguageArray($l);
    $pdf->setFontSubsetting(true);
    $pdf->SetFont('dejavusans', '', 14, '', true);
    /*
    $pdf->AddPage();
    $pdf->Ln();
    $pdf->writeHTMLCell(125, 20, '', '', $qry, 0, 0, 0, true, 'L', true);
    */
    
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $i =0;
    $controlAgenda = 0;
    while ($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        if ($controlAgenda != $row["IDAGENDA"])
        {
            $pdf->AddPage();
            $pdf->SetFont(PDF_FONT_NAME_MAIN,'B',11);
            //$pdf->MultiCell(264,10,"qry: " . $qry,0,'L',0,0);
            $pdf->MultiCell(264,10,"Profesional: " . utf8_decode($row["NomProfesional"]),0,'L',0,0);
            $pdf->Ln(4);
            $pdf->MultiCell(264,10,"Fecha: " . utf8_decode($row["FecCita"]),0,'L',0,0);
            $pdf->Ln(4.5);
            $pdf->SetFillColor(242 , 236, 236);
            $pdf->SetFont(PDF_FONT_NAME_MAIN,'B',9);
            $pdf->MultiCell(25,5,utf8_decode("Hora"),1,'C',1,0);
            $pdf->MultiCell(25,5,"Info",1,'C',1,0);
            $pdf->MultiCell(60,5,"Paciente",1,'C',1,0);
            $pdf->MultiCell(30,5,"Teléfonos",1,'C',1,0);
            $pdf->MultiCell(45,5,"Actividad",1,'C',1,0);
            $pdf->MultiCell(33,5,"Cliente",1,'C',1,0);
            $pdf->MultiCell(15,5,"CAS",1,'C',1,0);
            $pdf->MultiCell(30,5,"Firma",1,'C',1,0);
            $pdf->Ln();
        }
        $arrfila = array();   
        $rowcount = 0;
        $fill = 0;
        $rowcount = max($pdf->getNumLines(utf8_decode($row["HoraCita"]), 25),$pdf->getNumLines(utf8_decode($row["HoraCitaInfAdd"]), 25),$pdf->getNumLines(utf8_decode($row["TipDoc"]) . " " . utf8_decode($row["Documento"]) . " - " . utf8_decode($row["PrimerNombre"]) . " " . utf8_decode($row["SegundoNombre"]) . " " . utf8_decode($row["PrimerApellido"]) . " " . utf8_decode($row["SegundoApellido"]), 60),$pdf->getNumLines(utf8_decode($row["DesProced"]) . " [" . utf8_decode($row["CodProced"]) . "]", 45),$pdf->getNumLines(utf8_decode($row["Cliente"]), 33),$pdf->getNumLines(utf8_decode($row["Telefono"]), 30)) * 3;
        $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
        if (utf8_decode($row[50])=='b')
        {
            $pdf->SetFillColor(241 , 194, 194);
            $fill = 0;
        }else{
            $fill = 0;
        }
        //Hora
        $pdf->writeHTMLCell(25, $rowcount, '', '', utf8_decode($row["HoraCita"]), 0, 0, $fill, true, 'L', true);
        //InfoAdd
        $pdf->writeHTMLCell(25, $rowcount, '', '', utf8_decode($row["HoraCitaInfAdd"]), 0, 0, $fill, true, 'L', true);
        //Paciente
        $pdf->writeHTMLCell(60, $rowcount, '', '', utf8_decode($row["TipDoc"]) . " " . utf8_decode($row["Documento"]) . " - " . utf8_decode($row["PrimerNombre"]) . " " . utf8_decode($row["SegundoNombre"]) . " " . utf8_decode($row["PrimerApellido"]) . " " . utf8_decode($row["SegundoApellido"]), 0, 0, $fill, true, 'L', true);
        //Tel
        //$pdf->MultiCell(30,10,utf8_decode($row[63]) . " " . utf8_decode($row[64]),0,'L',$fill,0);
        $pdf->writeHTMLCell(30, $rowcount, '', '', utf8_decode($row["Telefono"]) . " " . utf8_decode($row["Telefono1"]), 0, 0, $fill, true, 'L', true);
        //Actividad
        $pdf->writeHTMLCell(45, $rowcount, '', '',"- " . utf8_decode($row["DesProced"]) . " [" . utf8_decode($row["CodProced"]), 0, 0, $fill, true, 'L', true);
        //Cliente
        //$pdf->MultiCell(33,$rowcount,utf8_decode($row[36]),0,'L',$fill,0);
        $pdf->writeHTMLCell(33, $rowcount, '', '', utf8_decode($row["Cliente"]), 0, 0, $fill, true, 'L', true);
        //Cas
        //$pdf->MultiCell(15,$rowcount,utf8_decode($row[40]),0,'L',$fill,0);
        $pdf->writeHTMLCell(15, $rowcount, '', '', utf8_decode($row["CAS"]), 0, 0, $fill, true, 'L', true);
        //Firma
        $pdf->MultiCell(30,$rowcount,"",'B','L',0,0);
        $pdf->Ln(2);
        $controlAgenda = $row["IDAGENDA"];
        if ($pdf->GetY() < 180)
            $pdf->Ln();
        else
        {
            $pdf->AddPage();
            $pdf->SetFont(PDF_FONT_NAME_MAIN,'B',11);
            $pdf->MultiCell(264,10,"Profesional: " . utf8_decode($row["NomProfesional"]),0,'L',0,0);
            $pdf->Ln(4);
            $pdf->MultiCell(264,10,"Fecha: " . utf8_decode($row["FecCita"]),0,'L',0,0);
            $pdf->Ln(4.5);
            $pdf->SetFillColor(242 , 236, 236);
            $pdf->SetFont(PDF_FONT_NAME_MAIN,'B',9);
            $pdf->MultiCell(25,5,utf8_decode("Hora"),1,'C',1,0);
            $pdf->MultiCell(25,5,"Info",1,'C',1,0);
            $pdf->MultiCell(60,5,"Paciente",1,'C',1,0);
            $pdf->MultiCell(30,5,"Teléfonos",1,'C',1,0);
            $pdf->MultiCell(45,5,"Actividad",1,'C',1,0);
            $pdf->MultiCell(33,5,"Cliente",1,'C',1,0);
            $pdf->MultiCell(15,5,"CAS",1,'C',1,0);
            $pdf->MultiCell(30,5,"Firma",1,'C',1,0);
            $pdf->Ln();
        }
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $pdf->Output('AgendaxProfesional.pdf', 'I');

?>