<?php

/*
* @category    Controlador Profesionales
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

require("../../../core/php/_database.php");
require("../../../core/php/php_functions.php");

$task = '';
if ( isset($_POST['task'])){
  $task = $_POST['task'];
}
switch($task){
    case "LISTAR":
        Listar();
        break;
    case "INSERTAR":
        Insertar();
        break;
    case "MODIFICAR":
        Modificar();
        break;
    case "ELIMINAR":
        Eliminar();
        break;
    default:
        echo "{failure:true}";
        break;
}

function Insertar()
{
    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $pNomBaseDatos = isset($_REQUEST['pNomBaseDatos'])?$_REQUEST['pNomBaseDatos']:"NA";
    if($pNomBaseDatos == "NA"){
        $gBaseDatos = new ofiMySQLi();
    }else{
        $gBaseDatos = new ofiMySQLi($pNomBaseDatos);
    }
    $gBaseDatos->conectar();
    $qry = "CALL sp_profesol_insert(" . spParametros($estructura,"SI") . ")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function Modificar()
{
    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $pNomBaseDatos = isset($_REQUEST['pNomBaseDatos'])?$_REQUEST['pNomBaseDatos']:"NA";
    if($pNomBaseDatos == "NA"){
        $gBaseDatos = new ofiMySQLi();
    }else{
        $gBaseDatos = new ofiMySQLi($pNomBaseDatos);
    }
    $gBaseDatos->conectar();
    $qry = "CALL sp_profesol_update(" . spParametros($estructura,"SI") . ")";
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function Eliminar()
{
    $pIdProfeSol = isset($_REQUEST['pIdProfeSol'])?$_REQUEST['pIdProfeSol']:0;
    $pNomBaseDatos = isset($_REQUEST['pNomBaseDatos'])?$_REQUEST['pNomBaseDatos']:"NA";
    if($pNomBaseDatos == "NA"){
        $gBaseDatos = new ofiMySQLi();
    }else{
        $gBaseDatos = new ofiMySQLi($pNomBaseDatos);
    }
    $gBaseDatos->conectar();
    $qry = "CALL sp_profesol_delete('" . $pIdProfeSol . "')";
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo '1';
    else
        echo '0';
    $gBaseDatos->cerrar();
}

function Listar()
{
    $pNomBaseDatos = isset($_REQUEST['pNomBaseDatos'])?$_REQUEST['pNomBaseDatos']:"NA";
    if($pNomBaseDatos == "NA"){
        $gBaseDatos = new ofiMySQLi();
    }else{
        $gBaseDatos = new ofiMySQLi($pNomBaseDatos);
    }
    $gBaseDatos->conectar();
    $Search = isset($_REQUEST['query']) ? $_REQUEST['query'] : null;
    if (is_null($Search) || $Search == "")
        $Search = "Todos";
    $qry = "CALL sp_profesol_listar(\"" . $Search . "\")";
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $nbrows = $gBaseDatos->nroRegistros();
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    if($nbrows>0){
        $gBaseDatos->conectar();
        $start = (integer) (isset($_POST['start']) ? $_POST['start'] : $_GET['start']);
        $end = (integer) (isset($_POST['limit']) ? $_POST['limit'] : $_GET['limit']);
        if($end == 0){
            $end = 15;
        }
        $qry = "CALL sp_profesol_listar_limit(\"" . $Search . "\",'" . $start . "','" . $end . "')";
        //echo $qry;
        $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
        while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
        {
            $nRow = $row;
            foreach($row as $key => $val)
            {
                $nRow[$key] = PonerAcentosHTML($val);
            }
            $arr[] = $nRow;
        }
        $jsonresult = JEncode($arr);
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        echo '({"total":"'.$nbrows.'","results":'.$jsonresult.'})';
    } else {
        echo '({"total":"0", "results":""})';
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
}

?>
