<?php

/*
* @category    Controlador Programas
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

require("../../../core/php/_database.php");
require("../../../core/php/php_functions.php");

$task = '';
if ( isset($_POST['task'])){
  $task = $_POST['task'];
}
switch($task){
    case "LISTAR_PROGRAMAS":
        ListarProgramas();
        break;
    case "LISTAR_TIPOATENCION":
        ListarAtencion();
        break;
    case "LISTAR_PLANTILLAS":
        ListarPlantillas();
        break;
    case "LISTAR_SERVICIOS":
        ListarServicios();
        break;
    case "INSERTAR_PROGRAMA":
        InsertarPrograma();
        break;
    case "MODIFICAR_PROGRAMA":
        ModificarPrograma();
        break;
    case "INSERTAR_TIPOATENCION":
        InsertarTipoAtencion();
        break;
    case "MODIFICAR_TIPOATENCION":
        ModificarTipoAtencion();
        break;
    case "INSERTAR_PLANTILLA":
        InsertarPlantilla();
        break;
    case "ELIMINAR_PLANTILLAS":
        EliminarPlantilla();
        break;
    default:
        echo "{failure:true}";
        break;
}
    
function ListarProgramas(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_programas_listar('" . $pEmpresa . "')";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = PonerAcentosHTML($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}

function ListarAtencion(){
    $pPrograma = isset($_REQUEST['pPrograma'])?$_REQUEST['pPrograma']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_programas_tipoatencion_listar('" . $pPrograma . "')";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = PonerAcentosHTML($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}

function ListarPlantillas(){
    $pPrograma = isset($_REQUEST['pPrograma'])?$_REQUEST['pPrograma']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_programas_plantilla_listar('" . $pPrograma . "')";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = PonerAcentosHTML($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}

function ListarServicios(){
    $pPrograma = isset($_REQUEST['pPrograma'])?$_REQUEST['pPrograma']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_programas_servicios_listar('" . $pPrograma . "')";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = PonerAcentosHTML($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}

function InsertarPrograma(){
    $pPrograma = isset($_REQUEST['pPrograma'])?$_REQUEST['pPrograma']:null;
    $pFinalidad = isset($_REQUEST['pFinalidad'])?$_REQUEST['pFinalidad']:null;
    $pExento = isset($_REQUEST['pExento'])?$_REQUEST['pExento']:0;
    $pActivo = isset($_REQUEST['pActivo'])?$_REQUEST['pActivo']:1;
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:1;
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:1;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_programas_add('" . $pEmpresa . "','" . $pPrograma . "','" . $pFinalidad . "','" . $pExento . "','" . $pActivo . "','" . $pUsuario . "')";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();   
}

function ModificarPrograma(){
    $pIdPrograma = isset($_REQUEST['pIdPrograma'])?$_REQUEST['pIdPrograma']:null;
    $pPrograma = isset($_REQUEST['pPrograma'])?$_REQUEST['pPrograma']:null;
    $pFinalidad = isset($_REQUEST['pFinalidad'])?$_REQUEST['pFinalidad']:null;
    $pExento = isset($_REQUEST['pExento'])?$_REQUEST['pExento']:0;
    $pActivo = isset($_REQUEST['pActivo'])?$_REQUEST['pActivo']:1;
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:1;
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:1;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_programas_edit('" . $pIdPrograma . "','" . $pEmpresa . "','" . $pPrograma . "','" . $pFinalidad . "','" . $pExento . "','" . $pActivo . "','" . $pUsuario . "')";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();   
}

function InsertarTipoAtencion(){
    $pIdPrograma = isset($_REQUEST['pIdPrograma'])?$_REQUEST['pIdPrograma']:null;
    $pTipoAtencion = isset($_REQUEST['pTipoAtencion'])?$_REQUEST['pTipoAtencion']:null;
    $pTurnos = isset($_REQUEST['pTurnos'])?$_REQUEST['pTurnos']:0;
    $pActivo = isset($_REQUEST['pActivo'])?$_REQUEST['pActivo']:1;
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:1;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_programas_tipoatencion_add('" . $pIdPrograma . "','" . $pTipoAtencion . "','" . $pTurnos . "','" . $pActivo . "','" . $pUsuario . "')";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();   
}

function ModificarTipoAtencion(){
    $pIdTipoAtencion = isset($_REQUEST['pIdTipoAtencion'])?$_REQUEST['pIdTipoAtencion']:null;
    $pIdPrograma = isset($_REQUEST['pIdPrograma'])?$_REQUEST['pIdPrograma']:null;
    $pTipoAtencion = isset($_REQUEST['pTipoAtencion'])?$_REQUEST['pTipoAtencion']:null;
    $pTurnos = isset($_REQUEST['pTurnos'])?$_REQUEST['pTurnos']:0;
    $pActivo = isset($_REQUEST['pActivo'])?$_REQUEST['pActivo']:1;
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:1;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_programas_tipoatencion_edit('" . $pIdTipoAtencion . "','" . $pIdPrograma . "','" . $pTipoAtencion . "','" . $pTurnos . "','" . $pActivo . "','" . $pUsuario . "')";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();   
}

function InsertarPlantilla(){
    $pIdPrograma = isset($_REQUEST['pIdPrograma'])?$_REQUEST['pIdPrograma']:null;
    $pPlantilla = isset($_REQUEST['pPlantilla'])?$_REQUEST['pPlantilla']:null;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_programas_plantilla_add('" . $pIdPrograma . "','" . $pPlantilla . "')";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();   
}

function EliminarPlantilla(){
    $pIdPrograma = isset($_REQUEST['pIdPrograma'])?$_REQUEST['pIdPrograma']:0;
    $pPlantilla = isset($_REQUEST['pPlantilla'])?$_REQUEST['pPlantilla']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_programas_plantilla_del('" . $pIdPrograma . "','" . $pPlantilla . "')";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo '1';
    else
        echo '0';
    $gBaseDatos->cerrar();
}

?>
