<?php

/*
* @category    Controlador Solicitud de Examenes
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

require("../../../core/php/_database.php");
require("../../../core/php/php_functions.php");

$task = '';
if ( isset($_POST['task'])){
  $task = $_POST['task'];
}
switch($task){
    case "GUARDAR_SOLEXA_OFICLINIC001":
        GuardarOfiClinic001();
        break;
    case "GUARDAR_OFIMEDICAL":
        GuardarOfiMedical();
        break;
    case "GUARDAR_OFIMEDICAL_002":
        GuardarOfiMedical002();
        break;
    case "ELIMINAR_OFIMEDICAL":
        EliminarOfiMedical();
        break;
    case "ELIMINAR_OFICLINIC_001":
        EliminarOfiMedical();
        break;
    case "VER_HISTORIAL_ORDENAMIENTOS":
        VerHistorialOrdenamientos();
        break;
    case "CARGAR_EXA_SELECCIONADOS":
        CargarExaSeleccionados();
        break;
    case "CARGAR_EXA_ORDENSELECCIONADA":
        CargarOrdenSeleccionada();
        break;
    default:
        echo "{failure:true}";
        break;
}

function CargarOrdenSeleccionada(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pSede = isset($_REQUEST['pSEDE'])?$_REQUEST['pSEDE']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pCASOrigen = isset($_REQUEST['pCASOrigen'])?$_REQUEST['pCASOrigen']:0;
    $pCASDestino = isset($_REQUEST['pCASDestino'])?$_REQUEST['pCASDestino']:0;
    $pCargarReporteParaclinicos = isset($_REQUEST['pCargarReporteParaclinicos'])?$_REQUEST['pCargarReporteParaclinicos']:"N";
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_oficlinic_addexa_ordenanterior('" . $pCASOrigen . "','" . $pCASDestino . "',\"" . $pCargarReporteParaclinicos . "\")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
     
}

function CargarExaSeleccionados(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pCargarReporteParaclinicos = isset($_REQUEST['pCargarReporteParaclinicos'])?$_REQUEST['pCargarReporteParaclinicos']:"N";
    $pOrdenamientos = explode("¬", isset($_REQUEST['pOrdenamientos'])?$_REQUEST['pOrdenamientos']:"");
    $pItemsExa = count($pOrdenamientos)-1;
    for($i=0; $i<$pItemsExa; $i++){
        $pInfoConcepto = explode("^", $pOrdenamientos[$i]);
        $qry = "CALL sp_oficlinic_addexa_seleccion('" . $pInfoConcepto[0] . "','" . $pInfoConcepto[1] . "',\"" . $pCargarReporteParaclinicos . "\")";
        //echo $qry;
        $gBaseDatos = new ofiMySQLi();
        $gBaseDatos->conectar();
        @mysqli_query($gBaseDatos->ConexionID, $qry);
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
    }
    echo "1";
}

function VerHistorialOrdenamientos(){
    $pPaciente = isset($_REQUEST['pPaciente']) ? $_REQUEST['pPaciente']:0;
    $qry = "CALL sp_oficlinic_historialordenamientos('" . $pPaciente . "')";
    //echo $qry;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    @mysqli_query("\"SET NAMES UTF8\"");
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = utf8_decode($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}

function EliminarOfiMedical(){
    $pIdMx = isset($_REQUEST['pIdMx'])?$_REQUEST['pIdMx']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_ofimedical_delsolicitudes('" . $pIdMx . "')";
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo '1';
    else
        echo '0';
    $gBaseDatos->cerrar();
}

function GuardarOfiMedical(){
    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_ofimedical_addexa(" . spParametros($estructura,"SI") . ")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
     
}
function GuardarOfiMedical002(){
    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_ofimedical_addexa002(" . spParametros($estructura,"SI") . ")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
     
}

function GuardarOfiClinic001(){
    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_oficlinic_exa_add(" . spParametros($estructura,"SI") . ")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
     
}
?>
