<?php

/*
* @category    Controlador Transcribir Imagenes Dx
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/
//set_time_limit(500);
require("../../../core/php/_database.php");
require("../../../core/php/php_functions.php");
session_start();
$task = '';
if ( isset($_POST['task'])){
  $task = $_POST['task'];
}
switch($task){
    case "ABRIR_NROEXAMEN":
        AbrirNroExamen();
        break;
    case "CAMBIAR_NROEXAMEN":
        CambriarNroExamen();
        break;
    case "LISTAR_TRANSCRIBIR_ANATOMO":
        Listar_TranscribirAnatomo();
        break;
    case "LISTAR_TRANSCRIBIR_ANATOMO_PAC":
        Listar_TranscribirAnatomoPac();
        break;
    case "LISTAR_TRANSCRIBIR_ANATOMO_EXA":
        Listar_TranscribirAnatomoExa();
        break;
    case "guardar_proc":
        GuardarProc();
        break;
    case "modificar_proc":
        ModificarProc();
        break;
    case "cerrar_proc":
        CerrarProc();
        break;
    case "firmar_proc":
        FirmarProc();
        break;
    case "cargar_proc":
        CargarProc();
        break;
    case "guardar_cito":
        GuardarResulCitologia();
        break;
    case "modificar_cito":
        ModificarResulCitologia();
        break;
    case "cargar_cito":
        CargarCitologia();
        break;
    default:
        echo "{failure:true}";
        break;
}

function AbrirNroExamen(){
    $pEmpresa = isset($_SESSION['ID_EMPRESA']) ? $_SESSION['ID_EMPRESA']:0;
    $pIPS = isset($_SESSION['ID_IPS']) ? $_SESSION['ID_IPS']:0;
    $pUsuario = isset($_SESSION['ID_USUARIO']) ? $_SESSION['ID_USUARIO']:0;
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pConsecutivoDetalle = isset($_REQUEST['pConsecutivoDetalle'])?$_REQUEST['pConsecutivoDetalle']:0;
    $pPlacaAnt = isset($_REQUEST['pPlacaAnt'])?$_REQUEST['pPlacaAnt']:null;
    $pMotivo = isset($_REQUEST['pMotivo'])?$_REQUEST['pMotivo']:null;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_edit_proced_reabrir_pato('" . $pEmpresa . "','" . $pIPS . "','" . $pCAS . "','" . $pConsecutivoDetalle . "','" . $pUsuario . "',\"" . $pMotivo . "\",\"" . $pPlacaAnt . "\")";
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function CambriarNroExamen(){
    $pEmpresa = isset($_SESSION['ID_EMPRESA']) ? $_SESSION['ID_EMPRESA']:0;
    $pIPS = isset($_SESSION['ID_IPS']) ? $_SESSION['ID_IPS']:0;
    $pUsuario = isset($_SESSION['ID_USUARIO']) ? $_SESSION['ID_USUARIO']:0;
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pConsecutivoDetalle = isset($_REQUEST['pConsecutivoDetalle'])?$_REQUEST['pConsecutivoDetalle']:0;
    $pExamen = isset($_REQUEST['pExamen'])?$_REQUEST['pExamen']:0;
    $pPrefijo = isset($_REQUEST['pPrefijo'])?$_REQUEST['pPrefijo']:0;
    $pConsecutivo = isset($_REQUEST['pConsecutivo'])?$_REQUEST['pConsecutivo']:0;
    $pPlacaRef = isset($_REQUEST['pPlacaRef'])?$_REQUEST['pPlacaRef']:"0-0";
    $pPlacaAnt = isset($_REQUEST['pPlacaAnt'])?$_REQUEST['pPlacaAnt']:null;
    
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_auditoria_cambiar_nroexamenplaca('" . $pEmpresa . "','" . $pIPS . "','" . $pUsuario . "','" . $pCAS . "','" . $pConsecutivoDetalle . "','" . $pExamen . "',\"" . $pPrefijo . "\",\""  . $pConsecutivo . "\",\"" . $pPlacaRef . "\",\"" . $pPlacaAnt . "\")";
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function ModificarResulCitologia(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pProfesional = $_SESSION['ID_PROFESIONAL_HC'];
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pConsecutivoDetalle = isset($_REQUEST['pConsecutivoDetalle'])?$_REQUEST['pConsecutivoDetalle']:0;
    $pidPlantillaHC = isset($_REQUEST['pidPlantillaHC'])?$_REQUEST['pidPlantillaHC']:0;
    $pFechaAtencion = isset($_REQUEST['pFechaAtencion'])?$_REQUEST['pFechaAtencion']:null;
    $pHoraApertura = isset($_REQUEST['pHoraApertura'])?$_REQUEST['pHoraApertura']:null;
    $pActividad = isset($_REQUEST['pActividad'])?$_REQUEST['pActividad']:null;
    $pPlantilla = isset($_REQUEST['pPlantilla'])?$_REQUEST['pPlantilla']:null;
    $pRutaRptHC = isset($_REQUEST['pRutaRptHC'])?$_REQUEST['pRutaRptHC']:null;
    $pRutaRptMx = isset($_REQUEST['pRutaRptMx'])?$_REQUEST['pRutaRptMx']:null;
    $pRutaRptExa = isset($_REQUEST['pRutaRptExa'])?$_REQUEST['pRutaRptExa']:null;
    $pRutaRptRem = isset($_REQUEST['pRutaRptRem'])?$_REQUEST['pRutaRptRem']:null;
    $contenido = isset($_REQUEST['CAMPOS'])?$_REQUEST['CAMPOS']:null;
    $pDiagppal = isset($_REQUEST['pDiagppal'])?$_REQUEST['pDiagppal']:null;
    $pDiagrel1 = isset($_REQUEST['pDiagrel1'])?$_REQUEST['pDiagrel1']:null;
    $pDiagrel2 = isset($_REQUEST['pDiagrel2'])?$_REQUEST['pDiagrel2']:null;
    $pDiagrel3 = isset($_REQUEST['pDiagrel3'])?$_REQUEST['pDiagrel3']:null;
    $pTipodiag = isset($_REQUEST['pTipodiag'])?$_REQUEST['pTipodiag']:null;
    $pFinalidad = isset($_REQUEST['pFinalidad'])?$_REQUEST['pFinalidad']:null;
    $pCausa = isset($_REQUEST['pCausa'])?$_REQUEST['pCausa']:null;
    $pAmbito = isset($_REQUEST['pAmbito'])?$_REQUEST['pAmbito']:null;
    $pFinalidadProced = isset($_REQUEST['pFinalidad'])?$_REQUEST['pFinalidad']:null;
    $pPersonalAtiende = isset($_REQUEST['pPersona'])?$_REQUEST['pPersona']:null;
    $pFormaActo = isset($_REQUEST['pForma'])?$_REQUEST['pForma']:null;
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $pIdCliente = isset($_REQUEST['pIdCliente'])?$_REQUEST['pIdCliente']:0;
    $pIdPlan = isset($_REQUEST['pIdPlan'])?$_REQUEST['pIdPlan']:0;
    $pIdSubPlan = isset($_REQUEST['pIdSubPlan'])?$_REQUEST['pIdSubPlan']:0;
    $pIdContrato = isset($_REQUEST['pIdContrato'])?$_REQUEST['pIdContrato']:0;
    $pAutorizacion = isset($_REQUEST['pAutorizacion'])?$_REQUEST['pAutorizacion']:null;
    $pCITFecCitologia = isset($_REQUEST['pCITFecCitologia'])?$_REQUEST['pCITFecCitologia']:null;
    $pCITLactancia = isset($_REQUEST['pCITLactancia'])?$_REQUEST['pCITLactancia']:null;
    $pCITFecUltMestruacion = isset($_REQUEST['pCITFecUltMestruacion'])?$_REQUEST['pCITFecUltMestruacion']:null;
    $pCITGestaciones = isset($_REQUEST['pCITGestaciones'])?$_REQUEST['pCITGestaciones']:null;
    $pCITPartos = isset($_REQUEST['pCITPartos'])?$_REQUEST['pCITPartos']:null;
    $pCITAbortos = isset($_REQUEST['pCITAbortos'])?$_REQUEST['pCITAbortos']:null;
    $pCITEmbarazoActual = isset($_REQUEST['pCITEmbarazoActual'])?$_REQUEST['pCITEmbarazoActual']:null;
    $pCITMetodoPlanifica = isset($_REQUEST['pCITMetodoPlanifica'])?$_REQUEST['pCITMetodoPlanifica']:null;
    $pCITTiempoUso = isset($_REQUEST['pCITTiempoUso'])?$_REQUEST['pCITTiempoUso']:null;
    $pCITFecUltCitologia = isset($_REQUEST['pCITFecUltCitologia'])?$_REQUEST['pCITFecUltCitologia']:null;
    $pCITResultadoCitologia = isset($_REQUEST['pCITResultadoCitologia'])?$_REQUEST['pCITResultadoCitologia']:null;
    $pCITCauterizacion = isset($_REQUEST['pCITCauterizacion'])?$_REQUEST['pCITCauterizacion']:null;
    $pCITCauterizacionFec = isset($_REQUEST['pCITCauterizacionFec'])?$_REQUEST['pCITCauterizacionFec']:null;
    $pCITHisterectomia = isset($_REQUEST['pCITHisterectomia'])?$_REQUEST['pCITHisterectomia']:null;
    $pCITHisterectomiaFec = isset($_REQUEST['pCITHisterectomiaFec'])?$_REQUEST['pCITHisterectomiaFec']:null;
    $pCITVaporizacion = isset($_REQUEST['pCITVaporizacion'])?$_REQUEST['pCITVaporizacion']:null;
    $pCITVaporizacionFec = isset($_REQUEST['pCITVaporizacionFec'])?$_REQUEST['pCITVaporizacionFec']:null;
    $pCITConizacion = isset($_REQUEST['pCITConizacion'])?$_REQUEST['pCITConizacion']:null;
    $pCITConizacionFec = isset($_REQUEST['pCITConizacionFec'])?$_REQUEST['pCITConizacionFec']:null;
    $pCITCrioterapia = isset($_REQUEST['pCITCrioterapia'])?$_REQUEST['pCITCrioterapia']:null;
    $pCITCrioterapiaFec = isset($_REQUEST['pCITCrioterapiaFec'])?$_REQUEST['pCITCrioterapiaFec']:null;
    $pCITRadioterapia = isset($_REQUEST['pCITRadioterapia'])?$_REQUEST['pCITRadioterapia']:null;
    $pCITRadioterapiaFec = isset($_REQUEST['pCITRadioterapiaFec'])?$_REQUEST['pCITRadioterapiaFec']:null;
    $pCITTtoHormonal = isset($_REQUEST['pCITTtoHormonal'])?$_REQUEST['pCITTtoHormonal']:null;
    $pCITTtoHormonalFec = isset($_REQUEST['pCITTtoHormonalFec'])?$_REQUEST['pCITTtoHormonalFec']:null;
    $pCITBiopsia = isset($_REQUEST['pCITBiopsia'])?$_REQUEST['pCITBiopsia']:null;
    $pCITBiopsiaFec = isset($_REQUEST['pCITBiopsiaFec'])?$_REQUEST['pCITBiopsiaFec']:null;
    $pCITColposcopia = isset($_REQUEST['pCITColposcopia'])?$_REQUEST['pCITColposcopia']:null;
    $pCITColposcopiaFec = isset($_REQUEST['pCITColposcopiaFec'])?$_REQUEST['pCITColposcopiaFec']:null;
    $pCITAusente = isset($_REQUEST['pCITAusente'])?$_REQUEST['pCITAusente']:null;
    $pCITSano = isset($_REQUEST['pCITSano'])?$_REQUEST['pCITSano']:null;
    $pCITAtrofico = isset($_REQUEST['pCITAtrofico'])?$_REQUEST['pCITAtrofico']:null;
    $pCITCongestivo = isset($_REQUEST['pCITCongestivo'])?$_REQUEST['pCITCongestivo']:null;
    $pCITUlcerado = isset($_REQUEST['pCITUlcerado'])?$_REQUEST['pCITUlcerado']:null;
    $pCITPolipo = isset($_REQUEST['pCITPolipo'])?$_REQUEST['pCITPolipo']:null;
    $pCITMasa = isset($_REQUEST['pCITMasa'])?$_REQUEST['pCITMasa']:null;
    $pCITObservacionesToma = isset($_REQUEST['pCITObservacionesToma'])?$_REQUEST['pCITObservacionesToma']:null;
    $pBethesdaCalidadMuestra = isset($_REQUEST['pBethesdaCalidadMuestra'])?$_REQUEST['pBethesdaCalidadMuestra']:null;
    $pBethesdaDescripcion = isset($_REQUEST['pBethesdaDescripcion'])?$_REQUEST['pBethesdaDescripcion']:null;
    $pBethesdaInterpretacion = isset($_REQUEST['pBethesdaInterpretacion'])?$_REQUEST['pBethesdaInterpretacion']:null;
    $pBethesdaControl = isset($_REQUEST['pBethesdaControl'])?$_REQUEST['pBethesdaControl']:null;
    $pBethesdaMicroorganismos = isset($_REQUEST['pBethesdaMicroorganismos'])?$_REQUEST['pBethesdaMicroorganismos']:null;
    $pBethesdaObservaciones = isset($_REQUEST['pBethesdaObservaciones'])?$_REQUEST['pBethesdaObservaciones']:null;
    $pProfeRealizo = isset($_REQUEST['pProfeRealizo'])?$_REQUEST['pProfeRealizo']:null;
    $pProfeReviso = isset($_REQUEST['pProfeReviso'])?$_REQUEST['pProfeReviso']:null;
    $pNroExamen = isset($_REQUEST['pNroExamen'])?$_REQUEST['pNroExamen']:null;
    $pObservacionesGeneralesCit = isset($_REQUEST['pObservacionesGeneralesCit'])?$_REQUEST['pObservacionesGeneralesCit']:null;
    $pEstadoTranscripcion = isset($_REQUEST['pEstadoTranscripcion'])?$_REQUEST['pEstadoTranscripcion']:"CERRADO";
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_edit_proced_citologia('" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pProfeRealizo . "','1','" . $pCAS . "','" . $pConsecutivoDetalle . "','" . $pidPlantillaHC . "',\"" . $pFechaAtencion . "\",\"" . $pHoraApertura . "\",\"" . $pActividad . "\",\"" . $pPlantilla . "\",\"" . $pRutaRptHC . "\",\"" . $pRutaRptMx . "\",\"" . $pRutaRptExa . "\",\"" . $pRutaRptRem . "\",\"" . $pDiagppal . "\",\"" . $pDiagrel1 . "\",\"" . $pDiagrel2 . "\",\"" . $pAmbito . "\",\"" . $pFinalidadProced . "\",\"" . $pPersonalAtiende . "\",\"" . $pFormaActo . "\",'" . $pUsuario . "','" . $pIdCliente . "','" . $pIdPlan . "','" . $pIdSubPlan . "','" . $pIdContrato . "','" . $pTamanoFuente . "',\"" . $pCITFecCitologia . "\",\"" . $pCITLactancia . "\",\"" . $pCITFecUltMestruacion . "\",'" . $pCITGestaciones . "','" . $pCITPartos . "','" . $pCITAbortos . "',\"" . $pCITEmbarazoActual . "\",\"" . $pCITMetodoPlanifica . "\",\"" . $pCITTiempoUso . "\",\"" . $pCITFecUltCitologia . "\",\"" . $pCITResultadoCitologia . "\",\"" . $pCITCauterizacion . "\",\"" . $pCITCauterizacionFec . "\",\"" . $pCITHisterectomia . "\",\"" . $pCITHisterectomiaFec . "\",\"" . $pCITVaporizacion . "\",\"" . $pCITVaporizacionFec . "\",\"" . $pCITConizacion . "\",\"" . $pCITConizacionFec . "\",\"" . $pCITCrioterapia . "\",\"" . $pCITCrioterapiaFec . "\",\"" . $pCITRadioterapia . "\",\"" . $pCITRadioterapiaFec . "\",\"" . $pCITTtoHormonal . "\",\"" . $pCITTtoHormonalFec . "\",\"" . $pCITBiopsia . "\",\"" . $pCITBiopsiaFec . "\",\"" . $pCITColposcopia . "\",\"" . $pCITColposcopiaFec . "\",\"" . $pCITAusente . "\",\"" . $pCITSano . "\",\"" . $pCITAtrofico . "\",\"" . $pCITCongestivo . "\",\"" . $pCITUlcerado . "\",\"" . $pCITPolipo . "\",\"" . $pCITMasa . "\",\"" . $pCITObservacionesToma .  "\",\"" . $pBethesdaCalidadMuestra . "\",\"" . $pBethesdaDescripcion  . "\",\"" . $pBethesdaInterpretacion  . "\",\"" . $pBethesdaControl  . "\",\"" . $pBethesdaMicroorganismos . "\",\"" . $pBethesdaObservaciones . "\",'" . $pProfeRealizo . "','" . $pProfeReviso . "',\"" . $pNroExamen  ."\",\"" . $pEstadoTranscripcion . "\",\"" . $pObservacionesGeneralesCit . "\")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();   
 
}

function GuardarResulCitologia(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $pProfesionalRevisa = isset($_REQUEST['pProfesionalRevisa'])?$_REQUEST['pProfesionalRevisa']:0;
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pConsecutivoDetalle = isset($_REQUEST['pConsecutivoDetalle'])?$_REQUEST['pConsecutivoDetalle']:0;
    $pidPlantillaHC = isset($_REQUEST['pidPlantillaHC'])?$_REQUEST['pidPlantillaHC']:0;
    $pFechaAtencion = isset($_REQUEST['pFechaAtencion'])?$_REQUEST['pFechaAtencion']:null;
    $pHoraApertura = isset($_REQUEST['pHoraApertura'])?$_REQUEST['pHoraApertura']:null;
    $pActividad = isset($_REQUEST['pActividad'])?$_REQUEST['pActividad']:null;
    $pPlantilla = isset($_REQUEST['pPlantilla'])?$_REQUEST['pPlantilla']:null;
    $pRutaRptHC = isset($_REQUEST['pRutaRptHC'])?$_REQUEST['pRutaRptHC']:null;
    $pRutaRptMx = isset($_REQUEST['pRutaRptMx'])?$_REQUEST['pRutaRptMx']:null;
    $pRutaRptExa = isset($_REQUEST['pRutaRptExa'])?$_REQUEST['pRutaRptExa']:null;
    $pRutaRptRem = isset($_REQUEST['pRutaRptRem'])?$_REQUEST['pRutaRptRem']:null;
    $contenido = isset($_REQUEST['CAMPOS'])?$_REQUEST['CAMPOS']:null;
    $pDiagppal = isset($_REQUEST['pDiagppal'])?$_REQUEST['pDiagppal']:null;
    $pDiagrel1 = isset($_REQUEST['pDiagrel1'])?$_REQUEST['pDiagrel1']:null;
    $pDiagrel2 = isset($_REQUEST['pDiagrel2'])?$_REQUEST['pDiagrel2']:null;
    $pDiagrel3 = isset($_REQUEST['pDiagrel3'])?$_REQUEST['pDiagrel3']:null;
    $pTipodiag = isset($_REQUEST['pTipodiag'])?$_REQUEST['pTipodiag']:null;
    $pFinalidad = isset($_REQUEST['pFinalidad'])?$_REQUEST['pFinalidad']:null;
    $pCausa = isset($_REQUEST['pCausa'])?$_REQUEST['pCausa']:null;
    $pAmbito = isset($_REQUEST['pAmbito'])?$_REQUEST['pAmbito']:null;
    $pFinalidadProced = isset($_REQUEST['pFinalidad'])?$_REQUEST['pFinalidad']:null;
    $pPersonalAtiende = isset($_REQUEST['pPersona'])?$_REQUEST['pPersona']:null;
    $pFormaActo = isset($_REQUEST['pForma'])?$_REQUEST['pForma']:null;
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $pIdCliente = isset($_REQUEST['pIdCliente'])?$_REQUEST['pIdCliente']:0;
    $pIdPlan = isset($_REQUEST['pIdPlan'])?$_REQUEST['pIdPlan']:0;
    $pIdSubPlan = isset($_REQUEST['pIdSubPlan'])?$_REQUEST['pIdSubPlan']:0;
    $pIdContrato = isset($_REQUEST['pIdContrato'])?$_REQUEST['pIdContrato']:0;
    $pAutorizacion = isset($_REQUEST['pAutorizacion'])?$_REQUEST['pAutorizacion']:null;
    $pCITFecCitologia = isset($_REQUEST['pCITFecCitologia'])?$_REQUEST['pCITFecCitologia']:null;
    $pCITLactancia = isset($_REQUEST['pCITLactancia'])?$_REQUEST['pCITLactancia']:null;
    $pCITFecUltMestruacion = isset($_REQUEST['pCITFecUltMestruacion'])?$_REQUEST['pCITFecUltMestruacion']:null;
    $pCITGestaciones = isset($_REQUEST['pCITGestaciones'])?$_REQUEST['pCITGestaciones']:null;
    $pCITPartos = isset($_REQUEST['pCITPartos'])?$_REQUEST['pCITPartos']:null;
    $pCITAbortos = isset($_REQUEST['pCITAbortos'])?$_REQUEST['pCITAbortos']:null;
    $pCITEmbarazoActual = isset($_REQUEST['pCITEmbarazoActual'])?$_REQUEST['pCITEmbarazoActual']:null;
    $pCITMetodoPlanifica = isset($_REQUEST['pCITMetodoPlanifica'])?$_REQUEST['pCITMetodoPlanifica']:null;
    $pCITTiempoUso = isset($_REQUEST['pCITTiempoUso'])?$_REQUEST['pCITTiempoUso']:null;
    $pCITFecUltCitologia = isset($_REQUEST['pCITFecUltCitologia'])?$_REQUEST['pCITFecUltCitologia']:null;
    $pCITResultadoCitologia = isset($_REQUEST['pCITResultadoCitologia'])?$_REQUEST['pCITResultadoCitologia']:null;
    $pCITCauterizacion = isset($_REQUEST['pCITCauterizacion'])?$_REQUEST['pCITCauterizacion']:null;
    $pCITCauterizacionFec = isset($_REQUEST['pCITCauterizacionFec'])?$_REQUEST['pCITCauterizacionFec']:null;
    $pCITHisterectomia = isset($_REQUEST['pCITHisterectomia'])?$_REQUEST['pCITHisterectomia']:null;
    $pCITHisterectomiaFec = isset($_REQUEST['pCITHisterectomiaFec'])?$_REQUEST['pCITHisterectomiaFec']:null;
    $pCITVaporizacion = isset($_REQUEST['pCITVaporizacion'])?$_REQUEST['pCITVaporizacion']:null;
    $pCITVaporizacionFec = isset($_REQUEST['pCITVaporizacionFec'])?$_REQUEST['pCITVaporizacionFec']:null;
    $pCITConizacion = isset($_REQUEST['pCITConizacion'])?$_REQUEST['pCITConizacion']:null;
    $pCITConizacionFec = isset($_REQUEST['pCITConizacionFec'])?$_REQUEST['pCITConizacionFec']:null;
    $pCITCrioterapia = isset($_REQUEST['pCITCrioterapia'])?$_REQUEST['pCITCrioterapia']:null;
    $pCITCrioterapiaFec = isset($_REQUEST['pCITCrioterapiaFec'])?$_REQUEST['pCITCrioterapiaFec']:null;
    $pCITRadioterapia = isset($_REQUEST['pCITRadioterapia'])?$_REQUEST['pCITRadioterapia']:null;
    $pCITRadioterapiaFec = isset($_REQUEST['pCITRadioterapiaFec'])?$_REQUEST['pCITRadioterapiaFec']:null;
    $pCITTtoHormonal = isset($_REQUEST['pCITTtoHormonal'])?$_REQUEST['pCITTtoHormonal']:null;
    $pCITTtoHormonalFec = isset($_REQUEST['pCITTtoHormonalFec'])?$_REQUEST['pCITTtoHormonalFec']:null;
    $pCITBiopsia = isset($_REQUEST['pCITBiopsia'])?$_REQUEST['pCITBiopsia']:null;
    $pCITBiopsiaFec = isset($_REQUEST['pCITBiopsiaFec'])?$_REQUEST['pCITBiopsiaFec']:null;
    $pCITColposcopia = isset($_REQUEST['pCITColposcopia'])?$_REQUEST['pCITColposcopia']:null;
    $pCITColposcopiaFec = isset($_REQUEST['pCITColposcopiaFec'])?$_REQUEST['pCITColposcopiaFec']:null;
    $pCITAusente = isset($_REQUEST['pCITAusente'])?$_REQUEST['pCITAusente']:null;
    $pCITSano = isset($_REQUEST['pCITSano'])?$_REQUEST['pCITSano']:null;
    $pCITAtrofico = isset($_REQUEST['pCITAtrofico'])?$_REQUEST['pCITAtrofico']:null;
    $pCITCongestivo = isset($_REQUEST['pCITCongestivo'])?$_REQUEST['pCITCongestivo']:null;
    $pCITUlcerado = isset($_REQUEST['pCITUlcerado'])?$_REQUEST['pCITUlcerado']:null;
    $pCITPolipo = isset($_REQUEST['pCITPolipo'])?$_REQUEST['pCITPolipo']:null;
    $pCITMasa = isset($_REQUEST['pCITMasa'])?$_REQUEST['pCITMasa']:null;
    $pCITObservacionesToma = isset($_REQUEST['pCITObservacionesToma'])?$_REQUEST['pCITObservacionesToma']:null;
    $pBethesdaCalidadMuestra = isset($_REQUEST['pBethesdaCalidadMuestra'])?$_REQUEST['pBethesdaCalidadMuestra']:null;
    $pBethesdaDescripcion = isset($_REQUEST['pBethesdaDescripcion'])?$_REQUEST['pBethesdaDescripcion']:null;
    $pBethesdaInterpretacion = isset($_REQUEST['pBethesdaInterpretacion'])?$_REQUEST['pBethesdaInterpretacion']:null;
    $pBethesdaControl = isset($_REQUEST['pBethesdaControl'])?$_REQUEST['pBethesdaControl']:null;
    $pBethesdaMicroorganismos = isset($_REQUEST['pBethesdaMicroorganismos'])?$_REQUEST['pBethesdaMicroorganismos']:null;
    $pBethesdaObservaciones = isset($_REQUEST['pBethesdaObservaciones'])?$_REQUEST['pBethesdaObservaciones']:null;
    $pProfeRealizo = isset($_REQUEST['pProfeRealizo'])?$_REQUEST['pProfeRealizo']:null;
    $pProfeReviso = isset($_REQUEST['pProfeReviso'])?$_REQUEST['pProfeReviso']:null;
    $pNroExamen = isset($_REQUEST['pNroExamen'])?$_REQUEST['pNroExamen']:null;
    $pObservacionesGeneralesCit = isset($_REQUEST['pObservacionesGeneralesCit'])?$_REQUEST['pObservacionesGeneralesCit']:null;
    $pEstadoTranscripcion = isset($_REQUEST['pEstadoTranscripcion'])?$_REQUEST['pEstadoTranscripcion']:"CERRADO";
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_add_proced_citologia('" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pProfeRealizo . "','1','" . $pCAS . "','" . $pConsecutivoDetalle . "','" . $pidPlantillaHC . "',\"" . $pFechaAtencion . "\",\"" . $pHoraApertura . "\",\"" . $pActividad . "\",\"" . $pPlantilla . "\",\"" . $pRutaRptHC . "\",\"" . $pRutaRptMx . "\",\"" . $pRutaRptExa . "\",\"" . $pRutaRptRem . "\",\"" . $pDiagppal . "\",\"" . $pDiagrel1 . "\",\"" . $pDiagrel2 . "\",\"" . $pAmbito . "\",\"" . $pFinalidadProced . "\",\"" . $pPersonalAtiende. "\",\"" . $pFormaActo . "\",'" . $pUsuario . "','" . $pIdCliente . "','" . $pIdPlan . "','" . $pIdSubPlan . "','" . $pIdContrato . "','" . $pTamanoFuente . "',\"" . $pCITFecCitologia . "\",\"" . $pCITLactancia . "\",\"" . $pCITFecUltMestruacion . "\",'" . $pCITGestaciones . "','" . $pCITPartos . "','" . $pCITAbortos . "',\"" . $pCITEmbarazoActual . "\",\"" . $pCITMetodoPlanifica . "\",\"" . $pCITTiempoUso . "\",\"" . $pCITFecUltCitologia . "\",\"" . $pCITResultadoCitologia . "\",\"" . $pCITCauterizacion . "\",\"" . $pCITCauterizacionFec . "\",\"" . $pCITHisterectomia . "\",\"" . $pCITHisterectomiaFec . "\",\"" . $pCITVaporizacion . "\",\"" . $pCITVaporizacionFec . "\",\"" . $pCITConizacion . "\",\"" . $pCITConizacionFec . "\",\"" . $pCITCrioterapia . "\",\"" . $pCITCrioterapiaFec . "\",\"" . $pCITRadioterapia . "\",\"" . $pCITRadioterapiaFec . "\",\"" . $pCITTtoHormonal . "\",\"" . $pCITTtoHormonalFec . "\",\"" . $pCITBiopsia . "\",\"" . $pCITBiopsiaFec . "\",\"" . $pCITColposcopia . "\",\"" . $pCITColposcopiaFec . "\",\"" . $pCITAusente . "\",\"" . $pCITSano . "\",\"" . $pCITAtrofico . "\",\"" . $pCITCongestivo . "\",\"" . $pCITUlcerado . "\",\"" . $pCITPolipo . "\",\"" . $pCITMasa . "\",\"" . $pCITObservacionesToma .  "\",\"" . $pBethesdaCalidadMuestra . "\",\"" . $pBethesdaDescripcion  . "\",\"" . $pBethesdaInterpretacion  . "\",\"" . $pBethesdaControl  . "\",\"" . $pBethesdaMicroorganismos . "\",\"" . $pBethesdaObservaciones . "\",'" . $pProfeRealizo . "','" . $pProfeReviso . "',\"" . $pNroExamen  . "\",\"" . $pEstadoTranscripcion . "\",\"" . $pObservacionesGeneralesCit . "\")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();   
 
}

function CargarCitologia(){
    $pCAS = isset($_REQUEST['pCAS']) ? $_REQUEST['pCAS']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_proced_citologia_load('" . $pCAS . "')";
    $resY = str_replace("<BR \/><br \/>","",PonerAcentosHTML($gBaseDatos->jsonSP($qry,"D")));
    $res = str_replace("<br \/>","",$resY);
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $res1 = str_replace("[", "", $res);
    $res = str_replace("]", "", $res1);
    echo $res;
}

function CargarProc(){
    $pCAS = isset($_REQUEST['pCAS']) ? $_REQUEST['pCAS']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_proced_pato_load('" . $pCAS . "')";
    $resY = str_replace("<BR \/><br \/>","",PonerAcentosHTML($gBaseDatos->jsonSP($qry,"D")));
    $res = str_replace("<br \/>","",$resY);
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $res1 = str_replace("[", "", $res);
    $res = str_replace("]", "", $res1);
    echo $res;
}

function FirmarProc(){
    $pCerrar = isset($_REQUEST['pCerrar'])?$_REQUEST['pCerrar']:0;
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pConsecutivoDetalle = isset($_REQUEST['pConsecutivoDetalle'])?$_REQUEST['pConsecutivoDetalle']:0;
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_edit_proced_firmar_pato('" . $pCerrar . "','" . $pCAS . "','" . $pConsecutivoDetalle . "','" . $pUsuario ."')";
    //echo $qry;
    $CampoLlave = explode("^",$gBaseDatos->jasonSP_arreglo2011($qry));
    $gBaseDatos->cerrar();
    /*if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "1^";
    else
       echo "0^";
    */
    echo $CampoLlave[0];
}

function CerrarProc(){
    $pCerrar = isset($_REQUEST['pCerrar'])?$_REQUEST['pCerrar']:0;
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pConsecutivoDetalle = isset($_REQUEST['pConsecutivoDetalle'])?$_REQUEST['pConsecutivoDetalle']:0;
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_edit_proced_cerrar_pato('" . $pCerrar . "','" . $pCAS . "','" . $pConsecutivoDetalle . "','" . $pUsuario ."')";
    //echo $qry;
    $CampoLlave = explode("^",$gBaseDatos->jasonSP_arreglo2011($qry));
    $gBaseDatos->cerrar();
    /*if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "1^";
    else
       echo "0^";
    */
    echo $CampoLlave[0];
}

function GuardarProc()
{
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $pProfesionalRevisa = isset($_REQUEST['pProfesionalRevisa'])?$_REQUEST['pProfesionalRevisa']:0;
    $pCerrar = isset($_REQUEST['pCerrar'])?$_REQUEST['pCerrar']:0;
    if($pCerrar == "SI"){
        $pCerrar = 1;
    }else{
        if($pCerrar == "NO"){
            $pCerrar = 0;
        }
    }
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pConsecutivoDetalle = isset($_REQUEST['pConsecutivoDetalle'])?$_REQUEST['pConsecutivoDetalle']:0;
    $pidPlantillaHC = isset($_REQUEST['pidPlantillaHC'])?$_REQUEST['pidPlantillaHC']:0;
    $pFechaAtencion = isset($_REQUEST['pFechaAtencion'])?$_REQUEST['pFechaAtencion']:null;
    $pHoraApertura = isset($_REQUEST['pHoraApertura'])?$_REQUEST['pHoraApertura']:null;
    $pActividad = isset($_REQUEST['pActividad'])?$_REQUEST['pActividad']:null;
    $pPlantilla = isset($_REQUEST['pPlantilla'])?$_REQUEST['pPlantilla']:null;
    $pRutaRptHC = isset($_REQUEST['pRutaRptHC'])?$_REQUEST['pRutaRptHC']:null;
    $pRutaRptMx = isset($_REQUEST['pRutaRptMx'])?$_REQUEST['pRutaRptMx']:null;
    $pRutaRptExa = isset($_REQUEST['pRutaRptExa'])?$_REQUEST['pRutaRptExa']:null;
    $pRutaRptRem = isset($_REQUEST['pRutaRptRem'])?$_REQUEST['pRutaRptRem']:null;
    $contenido = isset($_REQUEST['CAMPOS'])?$_REQUEST['CAMPOS']:null;
    $pEvolucion = stripslashes(utf8_encode(str_replace('"', '""',nl2br($contenido))));
    $pDiagppal = isset($_REQUEST['pDiagppal'])?$_REQUEST['pDiagppal']:null;
    $pDiagrel1 = isset($_REQUEST['pDiagrel1'])?$_REQUEST['pDiagrel1']:null;
    $pDiagrel2 = isset($_REQUEST['pDiagrel2'])?$_REQUEST['pDiagrel2']:null;
    $pDiagrel3 = isset($_REQUEST['pDiagrel3'])?$_REQUEST['pDiagrel3']:null;
    $pAmbito = isset($_REQUEST['pAmbito'])?$_REQUEST['pAmbito']:1;
    $pFinalidad = isset($_REQUEST['pFinalidad'])?$_REQUEST['pFinalidad']:1;
    $pPersona = isset($_REQUEST['pPersona'])?$_REQUEST['pPersona']:5;
    $pForma = isset($_REQUEST['pForma'])?$_REQUEST['pForma']:1;
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $pIdCliente = isset($_REQUEST['pIdCliente'])?$_REQUEST['pIdCliente']:0;
    $pIdPlan = isset($_REQUEST['pIdPlan'])?$_REQUEST['pIdPlan']:0;
    $pIdSubPlan = isset($_REQUEST['pIdSubPlan'])?$_REQUEST['pIdSubPlan']:0;
    $pIdContrato = isset($_REQUEST['pIdContrato'])?$_REQUEST['pIdContrato']:0;
    $pTamanoFuente = isset($_REQUEST['pTamanoFuente'])?$_REQUEST['pTamanoFuente']:10;
    $pHoraAtencionPac = isset($_REQUEST['pHoraAtencionPac'])?$_REQUEST['pHoraAtencionPac']:null;
    $pHoraSalidaPac = isset($_REQUEST['pHoraSalidaPac'])?$_REQUEST['pHoraSalidaPac']:null;
    $pNroExamen = isset($_REQUEST['pNroExamen'])?$_REQUEST['pNroExamen']:null;
    $pEstadoTranscripcion = isset($_REQUEST['pEstadoTranscripcion'])?$_REQUEST['pEstadoTranscripcion']:"SIN TRANSCRIBIR";
    
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_add_proced_patologia('" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pProfesional . "','" . $pProfesionalRevisa . "','" . $pCerrar . "','" . $pCAS . "','" . $pConsecutivoDetalle . "','" . $pidPlantillaHC . "',\"" . $pFechaAtencion . "\",\"" . $pHoraApertura . "\",\"" . $pActividad . "\",\"" . $pPlantilla . "\",\"" . $pRutaRptHC . "\",\"" . $pRutaRptMx . "\",\"" . $pRutaRptExa . "\",\"" . $pRutaRptRem . "\",\"" . $pEvolucion . "\",\"" . $pDiagppal . "\",\"" . $pDiagrel1 . "\",\"" . $pDiagrel2 . "\",\"" . $pAmbito . "\",\"" . $pFinalidad . "\",\"" . $pPersona . "\",\"" . $pForma . "\",'" . $pUsuario . "','" . $pIdCliente . "','" . $pIdPlan . "','" . $pIdSubPlan . "','" . $pIdContrato . "','" . $pTamanoFuente . "',\"" . $pHoraAtencionPac . "\",\"" . $pHoraSalidaPac . "\",\"" . $pNroExamen  ."\",\"" . $pEstadoTranscripcion . "\")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();   
}

function ModificarProc()
{
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $pProfesionalRevisa = isset($_REQUEST['pProfesionalRevisa'])?$_REQUEST['pProfesionalRevisa']:0;
    $pCerrar = isset($_REQUEST['pCerrar'])?$_REQUEST['pCerrar']:0;
    if($pCerrar == "SI"){
        $pCerrar = 1;
    }else{
        if($pCerrar == "NO"){
            $pCerrar = 0;
        }
    }
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pConsecutivoDetalle = isset($_REQUEST['pConsecutivoDetalle'])?$_REQUEST['pConsecutivoDetalle']:0;
    $pFechaAtencion = isset($_REQUEST['pFechaAtencion'])?$_REQUEST['pFechaAtencion']:null;
    $pHoraApertura = isset($_REQUEST['pHoraApertura'])?$_REQUEST['pHoraApertura']:null;
    $pActividad = isset($_REQUEST['pActividad'])?$_REQUEST['pActividad']:null;
    $pPlantilla = isset($_REQUEST['pPlantilla'])?$_REQUEST['pPlantilla']:null;
    $pRutaRptHC = isset($_REQUEST['pRutaRptHC'])?$_REQUEST['pRutaRptHC']:null;
    $pRutaRptMx = isset($_REQUEST['pRutaRptMx'])?$_REQUEST['pRutaRptMx']:null;
    $pRutaRptExa = isset($_REQUEST['pRutaRptExa'])?$_REQUEST['pRutaRptExa']:null;
    $pRutaRptRem = isset($_REQUEST['pRutaRptRem'])?$_REQUEST['pRutaRptRem']:null;
    $contenido = isset($_REQUEST['CAMPOS'])?$_REQUEST['CAMPOS']:null;
    $pEvolucion = stripslashes(utf8_encode(str_replace('"', '""',nl2br($contenido))));
    $pDiagppal = isset($_REQUEST['pDiagppal'])?$_REQUEST['pDiagppal']:null;
    $pDiagrel1 = isset($_REQUEST['pDiagrel1'])?$_REQUEST['pDiagrel1']:null;
    $pDiagrel2 = isset($_REQUEST['pDiagrel2'])?$_REQUEST['pDiagrel2']:null;
    $pDiagrel3 = isset($_REQUEST['pDiagrel3'])?$_REQUEST['pDiagrel3']:null;
    $pAmbito = isset($_REQUEST['pAmbito'])?$_REQUEST['pAmbito']:1;
    $pFinalidad = isset($_REQUEST['pFinalidad'])?$_REQUEST['pFinalidad']:1;
    $pPersona = isset($_REQUEST['pPersona'])?$_REQUEST['pPersona']:5;
    $pForma = isset($_REQUEST['pForma'])?$_REQUEST['pForma']:1;
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $pIdCliente = isset($_REQUEST['pIdCliente'])?$_REQUEST['pIdCliente']:0;
    $pIdPlan = isset($_REQUEST['pIdPlan'])?$_REQUEST['pIdPlan']:0;
    $pIdSubPlan = isset($_REQUEST['pIdSubPlan'])?$_REQUEST['pIdSubPlan']:0;
    $pIdContrato = isset($_REQUEST['pIdContrato'])?$_REQUEST['pIdContrato']:0;
    $pTamanoFuente = isset($_REQUEST['pTamanoFuente'])?$_REQUEST['pTamanoFuente']:10;
    $pHoraAtencionPac = isset($_REQUEST['pHoraAtencionPac'])?$_REQUEST['pHoraAtencionPac']:null;
    $pHoraSalidaPac = isset($_REQUEST['pHoraSalidaPac'])?$_REQUEST['pHoraSalidaPac']:null;
    $pNroExamen = isset($_REQUEST['pNroExamen'])?$_REQUEST['pNroExamen']:null;
    $pEstadoTranscripcion = isset($_REQUEST['pEstadoTranscripcion'])?$_REQUEST['pEstadoTranscripcion']:"SIN TRANSCRIBIR";
    
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_edit_proced_pato('" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pProfesional . "','" . $pProfesionalRevisa . "','" . $pCerrar . "','" . $pCAS . "','" . $pConsecutivoDetalle . "','" . $pidPlantillaHC . "',\"" . $pFechaAtencion . "\",\"" . $pHoraApertura . "\",\"" . $pActividad . "\",\"" . $pPlantilla . "\",\"" . $pRutaRptHC . "\",\"" . $pRutaRptMx . "\",\"" . $pRutaRptExa . "\",\"" . $pRutaRptRem . "\",\"" . $pEvolucion . "\",\"" . $pDiagppal . "\",\"" . $pDiagrel1 . "\",\"" . $pDiagrel2 . "\",\"" . $pAmbito . "\",\"" . $pFinalidad . "\",\"" . $pPersona . "\",\"" . $pForma . "\",'" . $pUsuario . "','" . $pIdCliente . "','" . $pIdPlan . "','" . $pIdSubPlan . "','" . $pIdContrato . "','" . $pTamanoFuente . "',\"" . $pHoraAtencionPac . "\",\"" . $pHoraSalidaPac . "\",\"" . $pNroExamen  ."\",\"" . $pEstadoTranscripcion . "\")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function Listar_TranscribirAnatomo(){
    $pEmpresa = isset($_REQUEST['pPrestador'])?$_REQUEST['pPrestador']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pFecha = isset($_REQUEST['pFecha'])?$_REQUEST['pFecha']:"1900/01/01";
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pNomBaseDatos = isset($_REQUEST['pNomBaseDatos'])?$_REQUEST['pNomBaseDatos']:"NA";
    if($pNomBaseDatos == "NA"){
        $gBaseDatos = new ofiMySQLi();
    }else{
        $gBaseDatos = new ofiMySQLi($pNomBaseDatos);
    }
    $gBaseDatos->conectar();
    $qry = "CALL sp_transcribepato_listar('" . $pEmpresa . "','" . $pIPS . "',\"" . $pFecha . "\",'" . $pCAS . "')";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = PonerAcentosHTML($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}

function Listar_TranscribirAnatomoPac(){
    $pEmpresa = isset($_REQUEST['pPrestador'])?$_REQUEST['pPrestador']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pNomBaseDatos = isset($_REQUEST['pNomBaseDatos'])?$_REQUEST['pNomBaseDatos']:"NA";
    $pDocumento = isset($_REQUEST['pDocumento'])?$_REQUEST['pDocumento']:"NA";
    if($pDocumento == "" || $pDocumento == null){
        $pDocumento = "NA";
    }
    $pNom1 = isset($_REQUEST['pNom1'])?$_REQUEST['pNom1']:"NA";
    if($pNom1 == "" || $pNom1 == null){
        $pNom1 = "NA";
    }
    $pNom2 = isset($_REQUEST['pNom2'])?$_REQUEST['pNom2']:"NA";
    if($pNom2 == "" || $pNom2 == null){
        $pNom2 = "NA";
    }
    $pApe1 = isset($_REQUEST['pApe1'])?$_REQUEST['pApe1']:"NA";
    if($pApe1 == "" || $pApe1 == null){
        $pApe1 = "NA";
    }
    $pApe2 = isset($_REQUEST['pApe2'])?$_REQUEST['pApe2']:"NA";
    if($pApe2 == "" || $pApe2 == null){
        $pApe2 = "NA";
    }
    if($pNomBaseDatos == "NA"){
        $gBaseDatos = new ofiMySQLi();
    }else{
        $gBaseDatos = new ofiMySQLi($pNomBaseDatos);
    }
    $gBaseDatos->conectar();
    $qry = "CALL sp_transcribepato_listarxpac('" . $pEmpresa . "','" . $pIPS . "',\"" . $pDocumento . "\",\"" . $pNom1 . "\",\"" . $pNom2 . "\",\"" . $pApe1 . "\",\"" . $pApe2 . "\")";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = PonerAcentosHTML($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}

function Listar_TranscribirAnatomoExa(){
    $pEmpresa = isset($_REQUEST['pPrestador'])?$_REQUEST['pPrestador']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pNomBaseDatos = isset($_REQUEST['pNomBaseDatos'])?$_REQUEST['pNomBaseDatos']:"NA";
    $pExa = isset($_REQUEST['pExa'])?$_REQUEST['pExa']:"NA";
    if($pExa == "" || $pExa == null){
        $pExa = "NA";
    }
    if($pNomBaseDatos == "NA"){
        $gBaseDatos = new ofiMySQLi();
    }else{
        $gBaseDatos = new ofiMySQLi($pNomBaseDatos);
    }
    $gBaseDatos->conectar();
    $qry = "CALL sp_transcribepato_listarxexa('" . $pEmpresa . "','" . $pIPS . "',\"" . $pExa . "\")";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = PonerAcentosHTML($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}
?>
