<?php

/*
* @category    Controlador IPS
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

require("../../core/php/_database.php");
require("../../core/php/php_functions.php");
$task = '';
if ( isset($_POST['task'])){
  $task = $_POST['task'];
}
switch($task){
    case "LISTING":
        Listar();
        break;
    case "UPDATE":
        update();
        break;
    case "CREATE":
        create();
        break;
    case "DELETE":
        delete();
        break;
    case "SEARCH":
        search();
        break;
    case "PRINT":
        printer();
        break;
    default:
        echo "{failure:true}";
        break;
}

function Listar()
{
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $IPS = (isset($_POST['query']) ? $_POST['query'] : $_GET['query']);
    $Cliente = (isset($_POST['CLIENTE']) ? $_POST['CLIENTE'] : $_GET['CLIENTE']);
    $Sede = (isset($_POST['SEDE']) ? $_POST['SEDE'] : $_GET['SEDE']);
    if (is_null($IPS))
        $IPS = "Todos";
    $Gerente = "Todos";
    $Cordinador = "Todos";
    $Enfermera = "Todos";
    $Municipio = "Todos";
    $qry = "CALL sp_IPS_listar('" . $Cliente . "','" . $Sede . "',\"" . $IPS . "\",\"" . $Gerente . "\",\"" . $Cordinador . "\",\"" . $Enfermera . "\",\"" . $Municipio . "\")";
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $nbrows = $gBaseDatos->nroRegistros();
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    if($nbrows>0){
        $gBaseDatos->conectar();
        $start = (integer) (isset($_POST['start']) ? $_POST['start'] : $_GET['start']);
        $end = (integer) (isset($_POST['limit']) ? $_POST['limit'] : $_GET['limit']);
        $qry = "CALL sp_IPS_listar_limit('" . $Cliente . "','" . $Sede . "',\"" . $IPS . "\",\"" . $Gerente . "\",\"" . $Cordinador . "\",\"" . $Enfermera . "\",\"" . $Municipio . "\",'" . $start . "','" . $end . "')";
        $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
        while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
        {
            $nRow = $row;
            foreach($row as $key => $val)
            {
                $nRow[$key] = utf8_encode($val);
            }
            $arr[] = $nRow;
        }
        $jsonresult = JEncode($arr);
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        echo '({"total":"'.$nbrows.'","results":'.$jsonresult.'})';
    } else {
        echo '({"total":"0", "results":""})';
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
}

function update()
{
    $IDRecord = $_POST['IDRecord'];
    $IPS = strtoupper(addslashes($_POST['IPS']));
    $Gerente = strtoupper(addslashes($_POST['Gerente']));
    $Cordinador = strtoupper(addslashes($_POST['Cordinador']));
    $Enfermera = strtoupper(addslashes($_POST['Enfermera']));
    $Direccion = strtoupper(addslashes($_POST['Direccion']));
    $Telefono = strtoupper(addslashes($_POST['Telefono']));
    $GerenteEmail = (isset($_POST['GerenteEmail']) ? addslashes($_POST['GerenteEmail']) : addslashes($_GET['GerenteEmail']));
    if (is_null($GerenteEmail) || $GerenteEmail == "")
        $GerenteEmail = "null";
    $CordinadorEmail = (isset($_POST['CordinadorEmail']) ? addslashes($_POST['CordinadorEmail']) : addslashes($_GET['CordinadorEmail']));
    if (is_null($CordinadorEmail) || $CordinadorEmail == "")
        $CordinadorEmail = "null";
    $EnfermeraEmail = (isset($_POST['EnfermeraEmail']) ? addslashes($_POST['EnfermeraEmail']) : addslashes($_GET['EnfermeraEmail']));
    if (is_null($EnfermeraEmail) || $EnfermeraEmail == "")
        $EnfermeraEmail = "null";
    $IdMunicipio = $_POST['IdMunicipio'];
    $IdUsuario = $_POST['USUARIO'];
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = 'CALL sp_IPS_update("' . $IPS . '","' . $Gerente . '","' . $Cordinador . '","' . $Enfermera . '","' . $Direccion . '","' . $Telefono . '","' . $IdMunicipio . '",\'' . $IDRecord . '\',\'' . $IdUsuario . '\',"' . $GerenteEmail . '","' . $CordinadorEmail . '","' . $EnfermeraEmail . '")';
    if (@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo '1';
    else
        echo '0';
    $gBaseDatos->cerrar();
}

function create(){

    $IPS = strtoupper(addslashes($_POST['IPS']));
    $Gerente = strtoupper(addslashes($_POST['Gerente']));
    $Cordinador = strtoupper(addslashes($_POST['Cordinador']));
    $Enfermera = strtoupper(addslashes($_POST['Enfermera']));
    $Direccion = strtoupper(addslashes($_POST['Direccion']));
    $Telefono = strtoupper(addslashes($_POST['Telefono']));
    $IdMunicipio = $_POST['IdMunicipio'];
    $GerenteEmail = (isset($_POST['GerenteEmail']) ? addslashes($_POST['GerenteEmail']) : addslashes($_GET['GerenteEmail']));
    if (is_null($GerenteEmail) || $GerenteEmail == "")
        $GerenteEmail = "null";
    $CordinadorEmail = (isset($_POST['CordinadorEmail']) ? addslashes($_POST['CordinadorEmail']) : addslashes($_GET['CordinadorEmail']));
    if (is_null($CordinadorEmail) || $CordinadorEmail == "")
        $CordinadorEmail = "null";
    $EnfermeraEmail = (isset($_POST['EnfermeraEmail']) ? addslashes($_POST['EnfermeraEmail']) : addslashes($_GET['EnfermeraEmail']));
    if (is_null($EnfermeraEmail) || $EnfermeraEmail == "")
        $EnfermeraEmail = "null";
    $IdCliente = $_POST['CLIENTE'];
    $IdSede = $_POST['SEDE'];
    $IdUsuario = $_POST['USUARIO'];
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = 'CALL sp_IPS_insert(\'' . $IdCliente . '\',\'' . $IdSede . '\',"' . $IPS . '","' . $Gerente . '","' . $Cordinador . '","' . $Enfermera . '","' . $Direccion . '","' . $Telefono . '","' . $IdMunicipio . '",\'' . $IdUsuario . '\',"' . $GerenteEmail . '","' . $CordinadorEmail . '","' . $EnfermeraEmail . '")';
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo '1';
    else
        echo '0';
    $gBaseDatos->cerrar();
}

function delete(){
   
    $ids = $_POST['ids'];
    if (version_compare(PHP_VERSION,"5.2","<"))  {
        require_once("./JSON.php");
        $json = new Services_JSON();
        $idpres = $json->decode(stripslashes($ids));
    } else {
        $idpres = json_decode(stripslashes($ids));
    }
    if(sizeof($idpres)<1)
        echo '0';
    else
    {
        $gBaseDatos = new ofiMySQLi();
        $gBaseDatos->conectar();
        for($i = 0; $i < sizeof($idpres); $i++){
            $qry = "CALL sp_IPS_delete('" . $idpres[$i] . "')";
            @mysqli_query($gBaseDatos->ConexionID, $qry);
        }
        $gBaseDatos->cerrar();
        echo '1';
    }
}


function search()
{
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $IPS = (isset($_POST['IPS']) ? $_POST['IPS'] : $_GET['IPS']);
    if (is_null($IPS) || $IPS == "")
        $IPS = "Todos";
    $Gerente = (isset($_POST['Gerente']) ? $_POST['Gerente'] : $_GET['Gerente']);
    if (is_null($Gerente) || $Gerente == "")
        $Gerente = "Todos";
    $Cordinador = (isset($_POST['Cordinador']) ? $_POST['Cordinador'] : $_GET['Cordinador']);
    if (is_null($Cordinador) || $Cordinador == "")
        $Cordinador = "Todos";
    $Enfermera = (isset($_POST['Enfermera']) ? $_POST['Enfermera'] : $_GET['Enfermera']);
    if (is_null($Enfermera) || $Enfermera == "")
        $Enfermera = "Todos";
    $Municipio = (isset($_POST['Municipio']) ? $_POST['Municipio'] : $_GET['Municipio']);
    if (is_null($Municipio) || $Municipio == "")
        $Municipio = "Todos";
    $Cliente = (isset($_POST['CLIENTE']) ? $_POST['CLIENTE'] : $_GET['CLIENTE']);
    $Sede = (isset($_POST['SEDE']) ? $_POST['SEDE'] : $_GET['SEDE']);
    $qry = "CALL sp_IPS_listar('" . $Cliente . "','" . $Sede . "',\"" . $IPS . "\",\"" . $Gerente . "\",\"" . $Cordinador . "\",\"" . $Enfermera . "\",\"" . $Municipio . "\")";
    //echo '<script type="text/javascript"> alert(' . $qry . ')</script>';
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $nbrows = $gBaseDatos->nroRegistros();
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    if($nbrows>0){
        $gBaseDatos->conectar();
        $start = (integer) (isset($_POST['start']) ? $_POST['start'] : $_GET['start']);
        $end = (integer) (isset($_POST['limit']) ? $_POST['limit'] : $_GET['limit']);
        $qry = "CALL sp_IPS_listar_limit('" . $Cliente . "','" . $Sede . "',\"" . $IPS . "\",\"" . $Gerente . "\",\"" . $Cordinador . "\",\"" . $Enfermera . "\",\"" . $Municipio . "\",'" . $start . "','" . $end . "')";
        $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
        while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
        {
            $nRow = $row;
            foreach($row as $key => $val)
            {
                $nRow[$key] = utf8_encode($val);
            }
            $arr[] = $nRow;
        }
        $jsonresult = JEncode($arr);
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        echo '({"total":"'.$nbrows.'","results":'.$jsonresult.'})';
    } else {
        echo '({"total":"0", "results":""})';
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
}

function printer()
{
   // Ok since we limited our queries to 15 entries, we need to do a query again and get everything.
   if($_POST['currentlisting']=='LISTING'){  // we are doing a basic listing or using the quicksearch
        $query = "SELECT * FROM presidents pr, parties pa WHERE pr.IDparty = pa.IDparty";
        // Here we check if we have a query parameter :
        if (isset($_POST['query']) && ($_POST['query'] != "")){
      		$query .= " AND (pr.firstname LIKE '%".$_POST['query']."%' OR pr.lastname LIKE '%".$_POST['query']."%')";
        }
        $query .= " ORDER BY tookoffice";
        $result = mysql_query($query);
        $nbrows = mysql_num_rows($result);
   } else if($_POST['currentlisting']=='SEARCH'){
         $query = "SELECT * FROM presidents pr, parties pa WHERE pr.IDparty = pa.IDparty";
         $firstname = $_POST['firstname'];
         $lastname = $_POST['lastname'];
         $enteringoffice = $_POST['enteringoffice'];
         $leavingoffice = $_POST['leavingoffice'];
         $party  = $_POST['party'];

         if($firstname != ''){
            $query .= " AND firstname LIKE '%".$firstname."%'";
         };
         if($lastname != ''){
            $query .= " AND lastname LIKE '%".$lastname."%'";
         };
         if($party != ''){
            $query .= " AND pr.IDparty = '".$party."'";
         };
         if ($enteringoffice) {
            $query .= " AND tookoffice >= '".$enteringoffice."'";
         };
         if ($leavingoffice) {
            $query .= " AND leftoffice <= '".$leavingoffice."'";
         };
         $result = mysql_query($query);
         $nbrows = mysql_num_rows($result);
   }

   // We now have our array, let's build our HTML file :
   $file = fopen("presidentslist.html",'w');
	fwrite($file, "<!DOCTYPE html PUBLIC '-//W3C//DTD XHTML 1.0 Transitional//EN' 'http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd'><html xmlns='http://www.w3.org/1999/xhtml'><head><meta http-equiv='Content-Type' content='text/html; charset=iso-8859-1' /><title>Printing the Grid</title><link rel='stylesheet' type='text/css' href='printstyle.css'/></head>");
	fwrite($file, "<body><table summary='Presidents List'><caption>The Presidents of the United States</caption><thead><tr><th scope='col'>First Name</th><th scope='col'>Last Name</th><th scope='col'>Party</th><th scope='col'>Entering Office</th><th scope='col'>Leaving Office</th><th scope='col'>Income</th></tr></thead><tfoot><tr><th scope='row'>Total</th><td colspan='4'>");
	fwrite($file, $nbrows);
	fwrite($file, " presidents</td></tr></tfoot><tbody>");
	for($i = 0; $i< $nbrows; $i++){
		$data = mysql_fetch_array($result);
		fwrite($file,'<tr');
		if($i%1==0){
			fwrite($file," class='odd'");
		}
		fwrite($file, "><th scope='row' id='r97'>");
		fwrite($file, $data['firstname']);
		fwrite($file,"</th><td>");
		fwrite($file, $data['lastname']);
		fwrite($file, "</td><td>");
		fwrite($file, $data['name']);
		fwrite($file, "</td><td>");
		fwrite($file, codeDate($data['tookoffice']));
		fwrite($file, "</td><td>");
		fwrite($file, codeDate($data['leftoffice']));
		fwrite($file, "</td><td> $");
		fwrite($file, $data['income']);
		fwrite($file, "</td></tr>");
	}
	fwrite($file, "</tbody></table></body></html>");	
	fclose($file);
	echo '1';
        @mysql_freeresult($result);
        @mysql_close();// we are done.

}

?> 