<?php
/*
* @category    Grid Repositorio Actividades de Trazabilidad
* @package     Nube Apps - Planificador de Creditos
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@nubeapps.com.co>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     Planificar de Creditos Ver 1.0
* @license     COMERCIAL
* @link        http://www.nubeapps.com.co
* @country     Colombia
* @telephone   3168345866
*/
include "classRecaudos.php";
class ControlRecaudosRepository {
    protected $db;
    public function __construct(PDO $db) {
        $this->db = $db;
    }
    private function read($row) {
        $result = new ControlRecaudos();
        $result->idItem = $row["idItem"];
        $result->idUsuario = $row["idUsuario"];
        $result->usuario = $row["usuario"];
        $result->fecha = $row["fecha"];
        $result->vlrRecaudoSistema = $row["vlrRecaudoSistema"];
        $result->vlrRecaudado = $row["vlrRecaudado"];
        $result->vlrDiferencia = $row["vlrDiferencia"];
        $result->nota = $row["nota"];
        $result->vlrErrorTirillas = $row["vlrErrorTirillas"];
        $result->vlrInsumosLab = $row["vlrInsumosLab"];
        $result->vlrInsumosOdontologia = $row["vlrInsumosOdontologia"];
        $result->vlrHistoriasClinicas = $row["vlrHistoriasClinicas"];
        $result->vlrOtros = $row["vlrOtros"];
        $result->vlrRecaudadoAnt = $row["vlrRecaudadoAnt"];
        $result->vlrErrorTirillasAnt = $row["vlrErrorTirillasAnt"];
        $result->vlrDiferenciaAnt = $row["vlrDiferenciaAnt"];
        $result->notaAnt = $row["notaAnt"];
        $result->observaciones = $row["observaciones"];
        $result->estado = $row["estado"];
        return $result;
    }
    public function getAll($pFecha) {
        $sql = 'CALL sp_caja_preparar_recaudo("'. $pFecha . '")';
        $q = $this->db->prepare($sql);
        $q->execute();
        $rows = $q->fetchAll();
        $result = array();
        foreach($rows as $row) {
            array_push($result, $this->read($row));
        }
        return $result;
    }
    public function updateItem($data) {
        //echo var_dump($data);
        $sql = 'UPDATE tmp_recaudos_diarios 
        SET tmp_recaudos_diarios.vlrRecaudado = :p1, 
        tmp_recaudos_diarios.vlrDiferencia = :p2, 
        tmp_recaudos_diarios.vlrErrorTirillas = :p3,  
	      tmp_recaudos_diarios.vlrInsumosLab = :p4, 
	      tmp_recaudos_diarios.vlrInsumosOdontologia = :p5,  
	      tmp_recaudos_diarios.vlrHistoriasClinicas = :p6, 
	      tmp_recaudos_diarios.vlrOtros = :p7, 
	      tmp_recaudos_diarios.vlrRecaudadoAnt = :p8, 
	      tmp_recaudos_diarios.vlrErrorTirillasAnt = :p9, 
        tmp_recaudos_diarios.vlrDiferenciaAnt = :p10, 
        tmp_recaudos_diarios.notaAnt = :p11, 
        tmp_recaudos_diarios.observaciones = :p12,
        tmp_recaudos_diarios.nota = :p13 
        WHERE
	tmp_recaudos_diarios.idItem = :p14';
        $q = $this->db->prepare($sql);
        $q->bindParam(":p1", $data["vlrRecaudado"]);
        $q->bindParam(":p2", $data["vlrDiferencia"]);
        $q->bindParam(":p3", $data["vlrErrorTirillas"]);
        $q->bindParam(":p4", $data["vlrInsumosLab"]);
        $q->bindParam(":p5", $data["vlrInsumosOdontologia"]);
        $q->bindParam(":p6", $data["vlrHistoriasClinicas"]);
        $q->bindParam(":p7", $data["vlrOtros"]);
        $q->bindParam(":p8", $data["vlrRecaudadoAnt"]);
        $q->bindParam(":p9", $data["vlrErrorTirillasAnt"]);
        $q->bindParam(":p10", $data["vlrDiferenciaAnt"]);
        $q->bindParam(":p11", $data["notaAnt"]);
        $q->bindParam(":p12", $data["observaciones"]);
        $q->bindParam(":p13", $data["nota"]);
        $q->bindParam(":p14", $data["idItem"]);
        $q->execute();
    }
    public function updateRecaudoDiario() {
        $sql = "CALL sp_caja_actualizar_recaudo()";
        $q = $this->db->prepare($sql);
        $q->execute();
    }
    public function remove($IdRegistro) {
        $sql = "DELETE FROM pacientes_terapias_sesiones WHERE idregistro = :id";
        $q = $this->db->prepare($sql);
        $q->bindParam(":id", $IdRegistro, PDO::PARAM_INT);
        $q->execute();
    }
}