<?php
@session_start();
require("../../../../core/php/_database.php");
require("../../../../core/php/php_functions.php");
class Resumen {
    public $vlrRecaudoSistema;
    public $vlrRecaudado;
    public $vlrDiferencia;
    public $vlrErrorTirillas;
    public $vlrInsumosLab;
    public $vlrInsumosOdontologia;
    public $vlrHistoriasClinicas;
    public $vlrOtros;
    public $vlrRecaudadoAnt;
    public $vlrErrorTirillasAnt;
    public $vlrDiferenciaAnt;
}

class ResumenRepository {
    protected $db;
    public function __construct(PDO $db) {
        $this->db = $db;
    }
    private function read($row) {
        $result = new Resumen();
        $result->vlrRecaudoSistema = $row["vlrRecaudoSistema"];
        $result->vlrRecaudado = $row["vlrRecaudado"];
        $result->vlrDiferencia = $row["vlrDiferencia"];
        $result->vlrErrorTirillas = $row["vlrErrorTirillas"];
        $result->vlrInsumosLab = $row["vlrInsumosLab"];
        $result->vlrInsumosOdontologia = $row["vlrInsumosOdontologia"];
        $result->vlrHistoriasClinicas = $row["vlrHistoriasClinicas"];
        $result->vlrOtros = $row["vlrOtros"];
        $result->vlrRecaudadoAnt = $row["vlrRecaudadoAnt"];
        $result->vlrErrorTirillasAnt = $row["vlrErrorTirillasAnt"];
        $result->vlrDiferenciaAnt = $row["vlrDiferenciaAnt"];
        return $result;
    }
    public function getAll() {
        $pFecha = isset($_REQUEST['pFecha'])?$_REQUEST['pFecha']:null;
        $sql = 'CALL sp_caja_resumen_diario("' . $pFecha . '")';
        //echo $sql;
        $q = $this->db->prepare($sql);
        $q->execute();
        $rows = $q->fetchAll();
        $result = array();
        foreach($rows as $row) {
            array_push($result, $this->read($row));
        }
        return $result;
    }
}

$config = include("config_dbgrid.php");
$db = new PDO($config["db"], $config["username"], $config["password"]);
$res = new ResumenRepository($db);
$result = $res->getAll();
header("Content-Type: application/json");
echo json_encode($result);